/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:55:09 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Canvas;
import java.awt.GraphicsConfiguration;
import javax.swing.JFrame;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.EntryGroupMenu;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class EntryGroupMenu_ESTest extends EntryGroupMenu_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "");
      Entry entry0 = simpleEntryGroup0.createEntry("");
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent("", entry0, 1);
      entryGroupMenu0.entryChanged(entryChangeEvent0);
      assertFalse(entryGroupMenu0.isFocusCycleRoot());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0);
      // Undeclared exception!
      try { 
        entryGroupMenu0.entryGroupChanged((EntryGroupChangeEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.EntryGroupMenu", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EntryGroupMenu entryGroupMenu0 = null;
      try {
        entryGroupMenu0 = new EntryGroupMenu((JFrame) null, (EntryGroup) null, "");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.EntryGroupMenu", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EntryGroupMenu entryGroupMenu0 = null;
      try {
        entryGroupMenu0 = new EntryGroupMenu((JFrame) null, (EntryGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.EntryGroupMenu", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key("|v]CuLOfC");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "|v]CuLOfC", "|v]CuLOfC", true, false, false);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "|v]CuLOfC");
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, filteredEntryGroup0, "|v]CuLOfC");
      Entry entry0 = filteredEntryGroup0.createEntry("|v]CuLOfC");
      assertEquals(0, entry0.getFeatureCount());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "");
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Canvas canvas0 = new Canvas((GraphicsConfiguration) null);
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent(canvas0, entry0, 3);
      entryGroupMenu0.entryChanged(entryChangeEvent0);
      assertEquals(3, entryChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key("|v]CuLOfC");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "|v]CuLOfC", "|v]CuLOfC", true, false, false);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "|v]CuLOfC");
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, filteredEntryGroup0, "|v]CuLOfC");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, (Entry) null, 5);
      entryGroupMenu0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(6, EntryGroupChangeEvent.DONE_GONE);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "");
      Entry entry0 = simpleEntryGroup0.createEntry("");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, entry0, 4);
      entryGroupMenu0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(2, EntryGroupChangeEvent.ENTRY_ADDED);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "V'BU~oG+zvYelZ\"Ohb");
      Entry entry0 = simpleEntryGroup0.createEntry("");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, entry0, 1);
      entryGroupMenu0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(6, EntryGroupChangeEvent.DONE_GONE);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("An<+z)j#AV&982xd");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "An<+z)j#AV&982xd");
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, filteredEntryGroup0, "~ 5Tz/86_Lu");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, (Entry) null, 2);
      entryGroupMenu0.entryGroupChanged(entryGroupChangeEvent0);
      assertEquals(6, EntryGroupChangeEvent.DONE_GONE);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "|z$o\"^(o?&JqQc");
      Entry entry0 = simpleEntryGroup0.createEntry("|z$o\"^(o?&JqQc");
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent(entry0, (Feature) null, 5);
      entryGroupMenu0.entryChanged(entryChangeEvent0);
      assertTrue(entryGroupMenu0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "");
      Entry entry0 = simpleEntryGroup0.createEntry("");
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, entry0, 3);
      entryGroupMenu0.entryGroupChanged(entryGroupChangeEvent0);
      assertTrue(entryGroupMenu0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0);
      EntryGroupChangeEvent entryGroupChangeEvent0 = new EntryGroupChangeEvent(simpleEntryGroup0, (Entry) null, (-3380));
      entryGroupMenu0.entryGroupChanged(entryGroupChangeEvent0);
      assertFalse(entryGroupMenu0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      EntryGroupMenu entryGroupMenu0 = new EntryGroupMenu((JFrame) null, simpleEntryGroup0, "");
      Entry entry0 = simpleEntryGroup0.createEntry("");
      simpleEntryGroup0.remove(entry0);
  }
}
