/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:55:08 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.SystemColor;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.components.FeaturePlot;
import uk.ac.sanger.artemis.components.Plot;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchStreamFeature;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.plot.CoilFeatureAlgorithm;
import uk.ac.sanger.artemis.plot.HydrophilicityAlgorithm;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Plot_ESTest extends Plot_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.menu;
      Plot.makeColours(systemColor0, 0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        Plot.makeColours((Color) null, 2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.Plot", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Color color0 = Color.RED;
      // Undeclared exception!
      try { 
        Plot.makeColours(color0, (-177));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.Plot", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Color color0 = new Color(0, 255, 0);
      Plot.makeColours(color0, 255);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Color color0 = Color.blue;
      Color[] colorArray0 = Plot.makeColours(color0, 1175);
      assertNotNull(colorArray0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      CoilFeatureAlgorithm coilFeatureAlgorithm0 = new CoilFeatureAlgorithm((Feature) null);
      FeaturePlot featurePlot0 = null;
      try {
        featurePlot0 = new FeaturePlot(coilFeatureAlgorithm0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeaturePlot", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Key key0 = new Key("");
      QualifierVector qualifierVector0 = new QualifierVector();
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, (Location) null, qualifierVector0);
      Feature feature0 = new Feature(mSPcrunchStreamFeature0);
      HydrophilicityAlgorithm hydrophilicityAlgorithm0 = new HydrophilicityAlgorithm(feature0);
      FeaturePlot featurePlot0 = new FeaturePlot(hydrophilicityAlgorithm0);
      featurePlot0.calculateFeatures(true);
  }
}
