/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:22:21 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.net.URL;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.alignment.LookSeqPanel;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class LookSeqPanel_ESTest extends LookSeqPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      String string0 = lookSeqPanel0.getQueryStr();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("cannot set qualifiers", "cannot set qualifiers");
      String string0 = lookSeqPanel0.getQueryStr();
      assertEquals("cannot set qualifiers", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      // Undeclared exception!
      try { 
        lookSeqPanel0.showOptions();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LookSeqPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      // Undeclared exception!
      try { 
        lookSeqPanel0.setDisplay((-366), 0, (DisplayAdjustmentEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LookSeqPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("qd&pM[})Hlt1ZiHR.p", "qd&pM[})Hlt1ZiHR.p");
      // Undeclared exception!
      try { 
        lookSeqPanel0.paintComponent((Graphics) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JComponent", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MockFile mockFile0 = new MockFile("0zI=#1l`7c");
      URL uRL0 = mockFile0.toURL();
      LookSeqPanel lookSeqPanel0 = null;
      try {
        lookSeqPanel0 = new LookSeqPanel(uRL0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      lookSeqPanel0.setImage((String) null, (String) null);
      assertTrue(lookSeqPanel0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("", "");
      // Undeclared exception!
      try { 
        lookSeqPanel0.showOptions();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      DisplayAdjustmentEvent displayAdjustmentEvent0 = new DisplayAdjustmentEvent(lookSeqPanel0, (-1539), 1614, 500000, 0.0F, (-1539), true, 0);
      lookSeqPanel0.setUrl((String) null, "");
      lookSeqPanel0.setDisplay(2, 6, displayAdjustmentEvent0);
      assertEquals("", lookSeqPanel0.getQueryStr());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("g", "g");
      DisplayAdjustmentEvent displayAdjustmentEvent0 = new DisplayAdjustmentEvent("g", 1768, 0, 1091, (-2772.839F), 3895, true, 3895);
      lookSeqPanel0.setDisplay(1768, 1768, displayAdjustmentEvent0);
      assertEquals("g", lookSeqPanel0.getQueryStr());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("'n!", "");
      lookSeqPanel0.setDisplay(3659, 10, (DisplayAdjustmentEvent) null);
      assertEquals("", lookSeqPanel0.getQueryStr());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel(uRL0);
      assertTrue(lookSeqPanel0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("'n!", "");
      lookSeqPanel0.setFeatureDisplay((FeatureDisplay) null);
      assertEquals("", lookSeqPanel0.getQueryStr());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      DisplayAdjustmentEvent displayAdjustmentEvent0 = new DisplayAdjustmentEvent(lookSeqPanel0, (-1539), 1614, 500000, 0.0F, (-1539), true, 0);
      lookSeqPanel0.displayAdjustmentValueChanged(displayAdjustmentEvent0);
      assertEquals(5, DisplayAdjustmentEvent.CONTIG_REORDER);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("", "");
      String string0 = lookSeqPanel0.getQueryStr();
      assertEquals("", string0);
  }
}
