/*
 * vhfCompatibility.h
 *
 * Copyright (C) 2000-2010 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2000-04-01
 * modified: 2010-02-13 (NSAppKitVersionNumber##_# for Apple)
 *
 * This file is part of the vhf Shared Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by the vhf interservice GmbH. Among other things,
 * the License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this library; see the file LICENSE. If not, write to vhf.
 *
 * If you want to link this library to your proprietary software,
 * or for other uses which are not covered by the definitions
 * laid down in the vhf Public License, vhf also offers a proprietary
 * license scheme. See the vhf internet pages or ask for details.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_COMPATIBILITY
#define VHF_H_COMPATIBILITY

#include <AppKit/AppKit.h>
#include "types.h"

/* GNUstep
 */
#if defined( GNUSTEP_BASE_VERSION )

#    define VHFIsDrawingToScreen()	[[NSGraphicsContext currentContext] isDrawingToScreen]
#    define VHFSelectorIsEqual(a, b)	sel_eq(a, b)
#    define VHFAntialiasing()		[[NSGraphicsContext currentContext] shouldAntialias]
#    define VHFSetAntialiasing(f)	[[NSGraphicsContext currentContext] setShouldAntialias:f]
#    define PSWait()			[[NSGraphicsContext currentContext] flushGraphics]

/* MAC OS X
 */
#elif defined ( __APPLE__ )

#    define VHFIsDrawingToScreen()	[[NSGraphicsContext currentContext] isDrawingToScreen]
#    define VHFSelectorIsEqual(a, b)	a == b
#    define VHFAntialiasing()		[[NSGraphicsContext currentContext] shouldAntialias]
#    define VHFSetAntialiasing(f)	[[NSGraphicsContext currentContext] setShouldAntialias:f]
#    define PSWait()			[[NSGraphicsContext currentContext] flushGraphics]
#    define PSgsave()			[NSGraphicsContext saveGraphicsState]
#    define PSgrestore()		[NSGraphicsContext restoreGraphicsState]
static __inline__ void PScomposite(float x, float y, float w, float h, int gstateNum, float dx, float dy, int op)	{ }

#   ifndef NSAppKitVersionNumber10_4
#       define NSAppKitVersionNumber10_4 824
#   endif
#   ifndef NSAppKitVersionNumber10_5
#       define NSAppKitVersionNumber10_5 949
#   endif
#   ifndef NSAppKitVersionNumber10_6
#       define NSAppKitVersionNumber10_6 1038
#   endif

/* OpenStep
 */
#else

#    include <NSBezierPath.h>
//#    include <AppKit/psops.h>
#    define VHFIsDrawingToScreen()	[[NSDPSContext currentContext] isDrawingToScreen]
#    define VHFSelectorIsEqual(a, b)	a == b
#    define VHFAntialiasing()		NO
#    define VHFSetAntialiasing(f)	
#    define NSGraphicsContext		NSDPSContext
#    define NSBackspaceCharacter	NSBackspaceKey
#    define NSDeleteCharacter		NSDeleteKey

#endif

#endif // VHF_H_COMPATIBILITY
