DACSACL(1)                   DACS Commands Manual                   DACSACL(1)



[1mNAME[0m
       dacsacl - list, check, or re-index access control rules

[1mSYNOPSIS[0m
       [1mdacsacl [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-build [22m| [1m-nobuild[22m] [[1m-vfs [4m[22mvfs_uri[24m] [...]
               [[4mop-spec[24m] [[4macl-name[24m...]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsacl [22mutility performs administrative functions related to access
       control, such as:

       +o   validating the syntax of ACL files (parsing the XML and [1mDACS[0m
           expressions);

       +o   checking that the revocation list (VFS type revocations) exists and
           performing a syntax check on it;

       +o   creating an index (a directory data structure, as an XML file) of
           access control files; and

       +o   listing and deleting access tokens in the authorization cache
           (refer to [34m[1mdacs_acs(8)[0m[1m[22m[2]).


       Please refer to [34m[1mdacs.acls(5)[0m[1m[22m[3] for details about how access control
       rule files are named.

           [1mImportant[0m
           Version 1.4.21 introduced important changes to the way [1mDACS[0m
           processes access control files, introducing incompatibilities with
           earlier releases. Please pay special attention to the [1m-convert [22mand
           [1m-build [22mflags.

           Most importantly, after adding, deleting, or editing an access
           control file the ACL index must be regenerated. This can be done
           simply by running [1mdacsacl [22mwith no arguments.

           [1mNotes[0m
           +o   So that it can be run as part of the installation procedure,
               [1mdacsacl [22mdoes not require dacs.conf to exist. If it does exist,
               however, it must be readable and syntactically correct.

           +o   The program emits a warning message if it finds different ACL
               files that contain identical url_pattern (or url_expr)
               attributes. It does not detect pairs of these attributes that
               are equivalent, however; in general, it is not possible to do
               so because the actual specifications used to match against a
               service request are not known until run time. Two or more
               service elements should never apply to the same service request
               (other than through wildcard matching) and the result of
               authorization testing with such rules is indeterminate.

           +o   The [34m[1mdacs_admin(8)[0m[1m[22m[4] web service provides some of the same
               functionality as [1mdacsacl[22m.


[1mOPTIONS[0m
       In addition to the standard [34m[4mdacsoptions[0m[4m[24m[1], [1mdacsacl [22mrecognizes these
       options:


       [1m-build[0m
           Index rebuilding is done by default with most modes of operation,
           but it can be explicitly requested with this flag. If the flag is
           given, it is not an error if an index file does not exist (as when
           initially creating an index).

       [1m-nobuild[0m
           Suppress index rebuilding.

       [1m-vfs [4m[22mvfs_uri[0m
           This flag, which may be repeated, causes [4mvfs_uri[24m to be defined as
           if by a [34m[1mVFS[0m[1m[22m[5] directive, overriding any existing definition. This
           can be used to specify an alternate location for the item types
           acls or dacs_acls, for instance. As a special case, if acls
           (dacs_acls) is defined using this flag but not dacs_acls (acls),
           then only the former's index will be rebuilt.

           This option can be useful in conjunction with the [34m[1m-un[0m[1m[22m[1] flag so
           that indexes can be generated before a jurisdiction has been
           configured.

       The optional [4mop-spec[24m describes one of the following operations:

       [1m-convert[0m
           This flag is used to convert from the older rule processing scheme
           (pre-1.4.21) to the current scheme. It should only be needed by
           installations that are using custom rules (i.e., those other than
           the standard rules for [1mDACS [22mweb pages and web services). Note that
           in some cases (described below) conversion is not fully automated,
           so the administrator may need to do some additional work.

       [1m--[0m
           This flag is a no-op that is used to prevent any following argument
           from being interpreted as a flag or operation.

       [1m-f [4m[22mfile[24m [...]
           Each [4mfile[24m argument is the pathname of an ACL file or a directory
           containing ACL files. Since ACL files can be organized using a
           directory structure, directories are checked recursively.

       [1m-l[0m
           List the full URI of each access control rule in the virtual
           filestore for item types acls and dacs_acls. No error checking is
           performed.

       [1m-s[0m
           List the name (sans prefixes) of each access control rule in the
           virtual filestore for item types acls and dacs_acls. No error
           checking is performed.

       [1m-tc[0m
           Clean up the authorization cache by deleting expired or otherwise
           invalid entries. Note: since there may not be any concurrency
           control in effect, this should probably not be done while [1mDACS[0m
           could be writing to the file.

       [1m-td [22m# ...
           Delete one or more authorization cache entries by giving their
           integer listing number (starting at 1, as produced by the [1m-tl[0m
           flag). Note: since there may not be any concurrency control in
           effect, this should probably not be done while [1mDACS [22mcould be
           writing to the file.

       [1m-tl[0m
           List the entries in the authorization cache.

       [1m-tt[0m
           Truncate the authorization cache, effectively deleting everything
           in the cache. This is not currently implemented; in the meantime,
           simply delete the file or database, or copy /dev/null to it.

       If one or more [4macl-name[24m arguments appear they are interpreted as ACL
       files accessed through [1mDACS's [22mvirtual filestore using item types acls
       and dacs_acls (both are checked). The applicable [1mDACS [22mconfiguration for
       the item type determines how an [4macl-name[24m will be accessed. Note that
       [4macl-name[24m must be the actual filename.

       If no [4mop-spec[24m or [4macl-name[24m is specified, [1mdacsacl [22mwill examine all
       currently indexed ACL files configured for the appropriate [1mDACS[0m
       jurisdiction.

[1mEXAMPLES[0m
       The following command checks all of the access control rules belonging
       to the jurisdiction associated with dss.example.com:

           % dacsacl -u dss.example.com -v
           Checking: /usr/local/dacs/federations/dss/acls/acl.2
           Checking: /usr/local/dacs/federations/dss/acls/acl.3
           Checking: /usr/local/dacs/federations/dss/acls/acl.4
           Checking: /usr/local/dacs/acls/acl-auth.0
           (Note: duplicate keys for "acl-auth.0" and "acl-conf.0")
           Checking: /usr/local/dacs/acls/acl-conf.0
           (Note: duplicate keys for "acl-conf.0" and "acl-dacs.0")
           Checking: /usr/local/dacs/acls/acl-dacs.0
           (Note: duplicate keys for "acl-dacs.0" and "acl-passwd.0")
           Checking: /usr/local/dacs/acls/acl-passwd.0
           (Note: duplicate keys for "acl-passwd.0" and "acl-stddocs.0")
           Checking: /usr/local/dacs/acls/acl-stddocs.0
           Updated rule: [acls]dacs-fs:/usr/local/dacs/conf/acls/acl-abc.0
           Updated rule: [acls]dacs-fs:/usr/local/dacs/conf/acls/acl-accounts.0
           ...
           Built index for "acls": 44 rules
           Updated rule: [dacs_acls]dacs-fs:/usr/local/dacs/acls/acl-admin.0
           Updated rule: [dacs_acls]dacs-fs:/usr/local/dacs/acls/acl-auth-agent.0
           ...
           Built index for "dacs_acls": 14 rules
           58 ACL files were checked (OK)


           [1mNote[0m
           While it is not an error for access control rules to have the same
           numeric suffix, because the suffix partly determines the order in
           which roles are processed, using equal suffix values accidentally
           may have unintended results.

       The following command checks only one access control rule belonging to
       the jurisdiction associated with dss.example.com:

           % dacsacl -u dss.example.com -v acl.2
           Checking: /usr/local/dacs/federations/dss/acls/acl.2
           1 ACL file was checked (OK)

       In general, to validate and index a set of rules placed in the
       directory /tmp/rules:

           % dacsacl -un -q -build -vfs "[dacs_acls]file:///tmp/rules"


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacsvfs(1)[0m[1m[22m[6], [34m[1mdacs.acls(5)[0m[1m[22m[3], [34m[1mdacs_acs(8)[0m[1m[22m[7], [34m[1mdacs_admin(8)[0m[1m[22m[4],
       [34m[1mdacs_vfs(8)[0m[1m[22m[8]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[9])

[1mCOPYING[0m
       Copyright (C) 2003-2016 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[10] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#authorization_caching

        3. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        4. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        5. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        6. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

        7. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        8. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                        DACSACL(1)
