%{
#ifdef WIN32
#pragma warning (disable: 4786) // disable warning for STL maps
#pragma warning (disable: 4996) // disable warning for deprecated POSIX name
#pragma warning (disable: 4018) // disable warning for comparing signed and unsigned
#endif /* WIN32 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//#ifdef WIN32
//#include <windows.h>
//#include <winbase.h>
//#include "dpuserType.h"
//#endif

#include <string>
#include <vector>

#include "tools.h"
#define YYSTYPE char*
#include "y.tab.h"
#include "dpuser_utils.h"
#include "dpstringlist.h"

int dpuser2cparse();
void dpuser2cerror(const char *s);

yy_buffer_state *yy_scan_string(const char *str);

int infunction = 0;
std::string line, name;
int nargs;
funcorproc_ID funcorproc;
char *global_s;      // in parser/dpuser.l exists also a char named s
char dpstringbuf[256];
extern char *dpuser2clval;

%}

%x DECLARATION
%x ARGUMENTS
%x COMMENT
%x STRINGCON
%x FITSCON

dig [0-9]
num1 {dig}+\.?([eEdD][-+]?{dig}+)?
num2 {dig}*\.{dig}+([eEdD][-+]?{dig}+)?
number {num1}|{num2}

bla ([0-9]+\.?([eEdD][-+]?[0-9]+)?)|([0-9]*\.[0-9]+([eEdD][-+]?[0-9]+)?)

%array

%%

"function "" "*[a-zA-Z][a-zA-Z0-9_]*	{
	idlcode = false;
	//funcorproc = 1;
	funcorproc = funcID;
	name = std::string(yytext+9);
	nargs = 0;
	tools_variables.push_back(extractVariable(yytext+9));
	line = std::string("dpuserType ") + (yytext+9) + "(";
	tools_variables.push_back("nparams");
	BEGIN DECLARATION;
}

"procedure "" "*[a-zA-Z][a-zA-Z0-9_]*	{
	idlcode = false;
	//funcorproc = 2;
	funcorproc = procID;
	name = yytext+10;
	nargs = 0;
	line = std::string("void ") + (yytext+10) + "(";
	tools_variables.push_back("nparams");
	BEGIN DECLARATION;
}

<DECLARATION>" "*","" "*
<DECLARATION>[&]?[a-zA-Z][a-zA-Z0-9_]* {
	nargs++;
	line += std::string("dpuserType ") + yytext;
   if (yytext[0] == '&')
	  arguments.push_back(yytext+1);
   else
	  arguments.push_back(yytext);
	BEGIN ARGUMENTS;
}
<DECLARATION>"{"" "*\n {
	line += ")";
   createInfo(funcorproc, nargs, name, line);
   line += " {";
	addLineToOutput(line);
	bracketcounter = 1;
	line = "";
	BEGIN 0;
}

<ARGUMENTS>" "*","" "*
<ARGUMENTS>" "
<ARGUMENTS>[&]?[a-zA-Z][a-zA-Z0-9_]* {
	nargs++;
	line += std::string(", dpuserType ") + yytext;
   if (yytext[0] == '&')
	  arguments.push_back(yytext+1);
   else
	  arguments.push_back(yytext);
}
<ARGUMENTS>"{"" "*\n {
   line += ")";	
   createInfo(funcorproc, nargs, name, line);
	line += " {";
	addLineToOutput(line);
	bracketcounter = 1;
	line = "";
	BEGIN 0;
}

[0-9]+      {
                dpuser2clval = strdup(yytext);
                return INTEGER;
            }

([0-9]+\.?([eEdD][-+]?[0-9]+)?)|([0-9]*\.[0-9]+([eEdD][-+]?[0-9]+)?)    {
								for (int _c_ = 0; _c_ < strlen(yytext); _c_++) {
									if (yytext[_c_] == 'd') yytext[_c_] = 'e';
									else if (yytext[_c_] == 'D') yytext[_c_] = 'E';
								}
								dpuser2clval = strdup(yytext);
								return REAL;
						}

([0-9]+"i")|(([0-9]+\.?([eEdD][-+]?[0-9]+)?)|([0-9]*\.[0-9]+([eEdD][-+]?[0-9]+)?)"i") {
								yytext[strlen(yytext)-1] = 0;
								dpuser2clval= strdup(yytext);
								return COMPLEX;
						}

","" "*"/"[a-zA-Z][a-zA-Z0-9]* {
	int i;
	i = 1;
	while (yytext[i] != '/') i++;
	i++;
	dpuser2clval = strdup(yytext + i);
	return OPTION;
}

"{" {
	bracketcounter++;
	return *yytext;
}

"}" {
	bracketcounter--;
	if (bracketcounter >= 1)
		return *yytext;
	else {
		flushOutput(name);
	}
}

[-()<>=+*/;:,\[\].^!?#%] {
	if (bracketcounter >= 1)
		return *yytext;
}

">="|" ge "|" GE "       return GE;
"<="|" le "|" LE "       return LE;
"=="|" eq "|" EQ "       return EQ;
"!="|" ne "|" NE "       return NE;
"&&"|" and "|" AND "     return AND;
"||"|" or "|" OR "       return OR;

" do "|" DO "|" Do "	;
"then begin"|"begin"|"BEGIN"|"Begin"	return '{';
"endfor"|"ENDFOR"|"Endfor"|"end"|"END"|"endelse"|"endif"	return '}';
"then" ;

"+="            return PlusE;
"-="            return MinusE;
"*="            return MulE;
"/="            return DivE;
"++"            return PlusP;
"--"            return MinusM;

"exit"          return EXIT;
"quit"          return EXIT;
"bye"           return EXIT;

[a-zA-Z][a-zA-Z0-9]*" "+[a-zA-Z0-9]       { 
								int i, fail;
								fail = 0;
								i = 2;
								while (yytext[yyleng-i] == ' ') { yytext[yyleng - i] = 0; i++; }
								if (yytext[yyleng-i] == ',') { yytext[yyleng - i] = 0; i++; }
								while (yytext[yyleng-i] == ' ') { yytext[yyleng - i] = 0; i++; }
								unput(yytext[yyleng-1]);
									if (strcmp(yytext, "if") == 0) {
										return IF;
									}
									if (strcmp(yytext, "else") == 0) {
										return ELSE;
									}
									if (strcmp(yytext, "for") == 0) {
										return FOR;
									}
									dpuser2clval = strdup(yytext);
									if (strcmp(yytext, "return") == 0) {
										return RETVAL;
									}
									return PGPLOT;
            }

[a-zA-Z][a-zA-Z0-9_.]*       { 
//								int i;
								if (strcmp(yytext, "if") == 0) {
									return IF;
								}
								if (strcmp(yytext, "else") == 0) {
									return ELSE;
								}
								if (strcmp(yytext, "for") == 0) {
									return FOR;
								}
								dpuser2clval = strdup(yytext);
								if (strcmp(yytext, "return") == 0) {
									return RETVAL;
								}
								if (isVariable(yytext)) return VARIABLE;
								return PGPLOT;
							}

[a-zA-Z0-9][a-zA-Z0-9_]*" "*"("       { 
								int i;

								yytext[yyleng-1]=0;
								i = yyleng - 2;
								while (yytext[i] == ' ') yytext[i--] = 0;

									if (strcmp(yytext, "for") == 0) {
										unput('(');
										return FOR;
									}
									if (strcmp(yytext, "if") == 0) {
										unput('(');
										return IF;
									}
									if (strcmp(yytext, "else") == 0) {
										unput('(');
										return ELSE;
									}
									if (strcmp(yytext, "while") == 0) {
										unput('(');
										return WHILE;
									}
									if (strcmp(yytext, "where") == 0) {
										unput('(');
										return WHERE;
									}
									
									unput('(');
									dpuser2clval = strdup(yytext);
									return FUNCTION;
							}

[a-zA-Z_][a-zA-Z0-9_]*" "*"="/[^=]		{
								int i;
								yytext[strlen(yytext)-1] = '\0';
								i = yyleng - 2;
								while (yytext[i] == ' ') yytext[i--] = 0;
                dpuser2clval = strdup(yytext);
								unput('=');
                return VARIABLE;
            }

\"             { BEGIN STRINGCON; global_s = dpstringbuf; }
<STRINGCON>\\\\   { *global_s++ = '\\'; }
<STRINGCON>\\t    { *global_s++ = '\t'; }
<STRINGCON>\\n    { *global_s++ = '\n'; }
<STRINGCON>\\\"   { *global_s++ = '"'; }
<STRINGCON>\"     { *global_s++ = '\0';
                 BEGIN 0;
								 dpuser2clval = strdup(dpstringbuf);
								 return STRING;
					  		}
<STRINGCON>\n     { global_s[-1] = '\0';
                 BEGIN 0;
								 unput(';');
								 unput('\n');
								 dp_output("Warning: Unterminated string constant\n");
								 dpuser2clval = strdup(dpstringbuf);
								 return STRING;
					  		}
<STRINGCON>.       { *global_s++ = *yytext; }

\'             { BEGIN FITSCON; global_s = dpstringbuf; }
<FITSCON>\\\'   { *global_s++ = '\''; }
<FITSCON>\'     { *global_s++ = '\0';
                 BEGIN 0;
								 dpuser2clval = strdup(dpstringbuf);
								 return FITSFILE;
					  		}
<FITSCON>\n     { global_s[-1] = '\0';
                 BEGIN 0;
								 unput(';');
								 unput('\n');
								 dpuser2clval = strdup(dpstringbuf);
								 dp_output("Warning: Unterminated FITS file name\n");
								 return FITSFILE;
					  		}
<FITSCON>.       { *global_s++ = *yytext; }

[ \t\n+]        ;       /* ignore whitespace */

%%

int yywrap(void) {
	return 1;
}

void dpuser2cerror(const char *s) {
	dp_output("%s\n", s);
	throw dpuserTypeException(const_cast<char*>(s));
}

int main_dpuser2c(char *fname) {
	int retVal = -1;
	// open script-file for reading
	FILE *fd = fopen(fname, "rb");
	if (fd != NULL) {
		size_t length;
		char *input;
		dpString iinput;
		dpStringList lines;
		int n;
		std::string line;
		char *cline;

		// get length of input file
		fseek(fd, 0L, SEEK_END);
		length = ftell(fd);
//		length++;
		fseek(fd, 0L, SEEK_SET);

		input = (char *)calloc(length+1, sizeof(char));
		if (input != NULL) {
			// read script into input-variable
			fread(input, sizeof(char), length, fd);
			
			for (n = 0; n < length; n++) if (input[n] == '\r') input[n] = '\n';
			for (n = 0; n < length; n++) if (input[n] == '\t') input[n] = ' ';
			for (n = 0; n < length-2; n++) {
				if (input[n] == '\\' && input[n+1] == '\n') {
					input[n] = ' ';
					input[n+1] = ' ';
					if (input[n+2] == '\n') input[n+2] = ' ';
				}
				if (input[n] == 'e' && input[n+1] == 'q') {
					input[n] = '=';
					input[n+1] = '=';
				}
			}
			input[length] = 0;
			eatCcomment(input);
			eatCCcomment(input);
			iinput = input;
			lines = dpStringList::split('\n', iinput);
			iinput = "";
			for (n = 0; n < lines.size(); n++) {
			   cline = tweakInput((char *)(lines[n] + "   ").c_str());
            line = std::string(cline) + "\n";
						free(cline);
            iinput += line;
         }
		  free(input);
			input = strdup(iinput.c_str());

			// send input-string to dpuser2c-parser
			yy_scan_string(input);
			dpuser2cparse();

			free(input);

			// everything was fine
			retVal = 0;
		}
		fclose(fd);
	} else {
		dp_output(">>> Could not open script-file for reading\n");
	}
   
	return retVal;
}
