/*
 * Decompiled with CFR 0.152.
 */
package dumphd.core;

import dumphd.aacs.AACSDecrypter;
import dumphd.aacs.AACSException;
import dumphd.core.ACAException;
import dumphd.core.DiscSet;
import dumphd.core.KeyDataFile;
import dumphd.util.ByteArray;
import dumphd.util.ByteSource;
import dumphd.util.CopyResult;
import dumphd.util.FileSource;
import dumphd.util.MessagePrinter;
import dumphd.util.PrintStreamPrinter;
import dumphd.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class ACAPacker {
    public static final String idString = "HDDVDACA";
    public static final long maxVersion = 0x100001L;
    private static final HashMap<String, Byte> mimeTypes = new HashMap();
    private MessagePrinter out = null;
    private AACSDecrypter aacsDec = null;
    private byte[] header = new byte[32];
    private byte[][] toc = new byte[65536][];
    private boolean contentCheck = false;

    static {
        mimeTypes.put(".XPL", new Byte(1));
        mimeTypes.put(".XMF", new Byte(2));
        mimeTypes.put(".XMU", new Byte(3));
        mimeTypes.put(".XTS", new Byte(4));
        mimeTypes.put(".XAS", new Byte(5));
        mimeTypes.put(".XSS", new Byte(6));
        mimeTypes.put(".JS", new Byte(7));
        mimeTypes.put(".EVO", new Byte(8));
        mimeTypes.put(".MAP", new Byte(9));
        mimeTypes.put(".JPG", new Byte(10));
        mimeTypes.put(".PNG", new Byte(11));
        mimeTypes.put(".MNG", new Byte(12));
        mimeTypes.put(".CVI", new Byte(13));
        mimeTypes.put(".CDW", new Byte(14));
        mimeTypes.put(".WAV", new Byte(15));
        mimeTypes.put(".OTF", new Byte(16));
        mimeTypes.put(".TTC", new Byte(16));
        mimeTypes.put(".TTF", new Byte(16));
        mimeTypes.put(null, new Byte(-1));
    }

    public ACAPacker(MessagePrinter mp) {
        this.out = mp;
        int i = 0;
        while (i < 65536) {
            this.toc[i] = null;
            ++i;
        }
    }

    public ACAPacker(MessagePrinter mp, AACSDecrypter aacsDec) {
        this.out = mp;
        this.aacsDec = aacsDec;
        int i = 0;
        while (i < 65536) {
            this.toc[i] = null;
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void list(ByteSource input) throws ACAException, IOException {
        String fileId = null;
        int tocEntries = 0;
        long fileSize = 0L;
        byte[] tocEntry = null;
        long offset = 0L;
        long size = 0L;
        long crc32 = 0L;
        int mimeType = 0;
        String fileName = null;
        long tocSize = 0L;
        long dataSize = 0L;
        boolean versionWarning = false;
        boolean sizeWarning = false;
        this.out.print("Reading header... ");
        if (input.read(this.header, 0, this.header.length) != this.header.length) throw new ACAException("File too small to be an ACA file");
        fileId = new String(this.header, 0, idString.length(), "US-ASCII");
        if (!fileId.equals(idString)) throw new ACAException("Invalid file id");
        if (ByteArray.getVarLong(this.header, 8, 4) > 0x100001L) {
            versionWarning = true;
        }
        tocEntries = ByteArray.getUShort(this.header, 12);
        fileSize = ByteArray.getVarLong(this.header, 14, 4);
        if (fileSize != input.size()) {
            sizeWarning = true;
        }
        this.out.println("OK");
        if (versionWarning) {
            this.out.println("WARNING! Unsupported ACA version");
        }
        if (sizeWarning) {
            this.out.println("WARNING! ACA filesize does not match physical filesize");
        }
        this.out.println(String.format("Version         : 0x%1$08X", ByteArray.getVarLong(this.header, 8, 4)));
        this.out.println("Number of files : " + ByteArray.getUShort(this.header, 12));
        this.out.println("Filesize        : " + ByteArray.getVarLong(this.header, 14, 4));
        this.out.println("Reading TOC... ");
        this.out.println(String.format("%1$10s %2$10s %3$10s %4$2s %5$s", "Offset", "Size", "CRC32", "Mime", "Name"));
        int i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            if (tocEntry == null) {
                tocEntry = new byte[301];
                this.toc[i] = tocEntry;
            }
            Arrays.fill(tocEntry, 0, tocEntry.length, (byte)0);
            input.read(tocEntry, 0, 14);
            input.read(tocEntry, 14, (tocEntry[13] & 0xFF) + 32);
            offset = ByteArray.getVarLong(tocEntry, 0, 4);
            size = ByteArray.getVarLong(tocEntry, 4, 4);
            crc32 = ByteArray.getVarLong(tocEntry, 8, 4);
            mimeType = ByteArray.getUByte(tocEntry, 12);
            fileName = new String(tocEntry, 14, tocEntry[13] & 0xFF, "US-ASCII");
            tocSize += (long)(46 + (tocEntry[13] & 0xFF));
            dataSize += size;
            this.out.println(String.format("0x%1$08X 0x%2$08X 0x%3$08X 0x%4$02X %5$s", offset, size, crc32, mimeType, fileName));
            ++i;
        }
        long contentSize = (long)this.header.length + tocSize + dataSize;
        this.out.println("Finished TOC reading");
        this.out.println();
        this.out.println("Header size        : " + this.header.length);
        this.out.println("TOC size           : " + tocSize);
        this.out.println("Data size          : " + dataSize);
        this.out.println("-------------------------------");
        this.out.println("Total content size : " + contentSize);
        this.out.println("Filesize           : " + fileSize);
        this.out.println("-------------------------------");
        this.out.println("Slack              : " + (fileSize - contentSize));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long dePack(ByteSource input, File outDir) throws ACAException, IOException {
        String fileId = null;
        int tocEntries = 0;
        long fileSize = 0L;
        byte[] tocEntry = null;
        long offset = 0L;
        long size = 0L;
        long crc32 = 0L;
        String fileName = null;
        long oldOffset = 0L;
        long dataCrc32 = 0L;
        long outSize = 0L;
        CopyResult cr = null;
        this.out.print("Reading header... ");
        if (input.read(this.header, 0, this.header.length) != this.header.length) throw new ACAException("File too small to be an ACA file");
        fileId = new String(this.header, 0, idString.length(), "US-ASCII");
        if (!fileId.equals(idString)) throw new ACAException("Invalid file id");
        if (ByteArray.getVarLong(this.header, 8, 4) > 0x100001L) throw new ACAException("Unsupported ACA file version");
        tocEntries = ByteArray.getUShort(this.header, 12);
        fileSize = ByteArray.getVarLong(this.header, 14, 4);
        if (fileSize > input.size()) throw new ACAException("Physical filesize smaller than ACA filesize");
        this.out.println("OK");
        this.out.print("Reading TOC... ");
        int i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            if (tocEntry == null) {
                tocEntry = new byte[301];
                this.toc[i] = tocEntry;
            }
            input.read(tocEntry, 0, 14);
            input.read(tocEntry, 14, (tocEntry[13] & 0xFF) + 32);
            ++i;
        }
        this.out.println("OK");
        oldOffset = input.getPosition();
        this.out.println("Depacking files...");
        i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            offset = ByteArray.getVarLong(tocEntry, 0, 4);
            size = ByteArray.getVarLong(tocEntry, 4, 4);
            crc32 = ByteArray.getVarLong(tocEntry, 8, 4);
            fileName = new String(tocEntry, 14, (int)tocEntry[13], "US-ASCII");
            if (offset < oldOffset) throw new ACAException("Offset of current file is inside previous file");
            oldOffset = offset + size;
            if (oldOffset > fileSize) throw new ACAException("Current file exceeds total file size");
            this.out.print(fileName);
            FileSource output = new FileSource(new File(outDir, fileName), 2);
            input.setPosition(offset);
            input.addWindow(size);
            try {
                if (this.aacsDec != null && (ByteArray.getUByte(tocEntry, 12) == (mimeTypes.get(null) & 0xFF) || this.contentCheck)) {
                    this.out.print(", searching AACS... ");
                    cr = this.aacsDec.decryptArf(input, output);
                    if (cr.size != size) {
                        this.out.println("REMOVED");
                        crc32 = cr.crc32;
                    } else {
                        this.out.println("NONE");
                    }
                } else {
                    if (this.contentCheck) {
                        this.out.print(", searching AACS... ");
                        if (AACSDecrypter.isArfEncrypted(input)) {
                            this.out.println("FOUND");
                        } else {
                            this.out.println("NONE");
                        }
                    } else {
                        this.out.println();
                    }
                    cr = Utils.copyBs(input, output, size);
                }
            }
            catch (AACSException e) {
                this.out.println("ERROR");
                this.out.println(e.getMessage());
                cr.size = 0L;
                cr.crc32 = crc32;
            }
            input.removeWindow();
            outSize += cr.size;
            dataCrc32 = cr.crc32;
            output.close();
            ++i;
        }
        this.out.println("Depacking finished");
        return outSize;
    }

    public long pack(Collection<File> inFiles, File outFile) throws ACAException, IOException {
        int tocEntries = 0;
        int tocSize = 0;
        long fileSize = this.header.length;
        byte[] tocEntry = null;
        long offset = 0L;
        long size = 0L;
        long crc32 = 0L;
        byte mimeType = 0;
        String fileName = null;
        byte[] fileNameBytes = null;
        CopyResult cr = null;
        this.out.println("Building TOC... ");
        Iterator<File> it = inFiles.iterator();
        while (it.hasNext()) {
            File inFile = it.next();
            if (inFile.isFile()) {
                Byte mimeTypeObject;
                tocEntry = this.toc[tocEntries];
                if (tocEntry == null) {
                    tocEntry = new byte[301];
                    this.toc[tocEntries] = tocEntry;
                }
                fileName = inFile.getName();
                fileNameBytes = fileName.getBytes("US-ASCII");
                mimeType = mimeTypes.get(null);
                int extOffset = fileName.lastIndexOf(46);
                if (extOffset >= 0 && (mimeTypeObject = mimeTypes.get(fileName.substring(extOffset).toUpperCase())) != null) {
                    mimeType = mimeTypeObject;
                }
                ByteArray.setByte(tocEntry, 12, mimeType);
                ByteArray.setByte(tocEntry, 13, (byte)fileNameBytes.length);
                System.arraycopy(fileNameBytes, 0, tocEntry, 14, fileNameBytes.length);
                Arrays.fill(tocEntry, 14 + fileNameBytes.length, tocEntry.length, (byte)0);
                ++tocEntries;
                tocSize += 46 + fileNameBytes.length;
                continue;
            }
            this.out.println(String.valueOf(inFile.getPath()) + ": File not found, skipping");
            it.remove();
        }
        FileSource output = new FileSource(outFile, 2);
        output.setPosition(fileSize += (long)tocSize);
        this.out.println("Packing files... ");
        int i = 0;
        for (File inFile : inFiles) {
            tocEntry = this.toc[i];
            this.out.print(inFile.getName());
            FileSource input = new FileSource(inFile, 0);
            size = input.size();
            offset = output.getPosition();
            output.addWindow(size);
            if (this.aacsDec != null) {
                this.out.print(", searching AACS... ");
                try {
                    cr = this.aacsDec.decryptArf(input, output);
                    if (cr.size != size) {
                        this.out.println("REMOVED");
                    }
                    this.out.println("NONE");
                }
                catch (AACSException e) {
                    this.out.println("ERROR");
                    this.out.println(e.getMessage());
                    input.close();
                    output.close();
                    throw new ACAException("Could not add file to archive", e);
                }
            } else {
                if (this.contentCheck) {
                    this.out.print(", looking for AACS protection... ");
                    if (AACSDecrypter.isArfEncrypted(input)) {
                        tocEntry[12] = mimeTypes.get(null);
                        this.out.println("FOUND");
                    } else {
                        this.out.println("NONE");
                    }
                } else {
                    this.out.println();
                }
                cr = Utils.copyBs(input, output, size);
            }
            output.removeWindow();
            size = cr.size;
            crc32 = cr.crc32;
            input.close();
            ByteArray.setInt(tocEntry, 0, (int)offset);
            ByteArray.setInt(tocEntry, 4, (int)size);
            ByteArray.setInt(tocEntry, 8, (int)crc32);
            fileSize += size;
            ++i;
        }
        fileNameBytes = idString.getBytes("US-ASCII");
        System.arraycopy(fileNameBytes, 0, this.header, 0, fileNameBytes.length);
        ByteArray.setInt(this.header, 8, 0x100001);
        ByteArray.setShort(this.header, 12, (short)tocEntries);
        ByteArray.setInt(this.header, 14, (int)fileSize);
        Arrays.fill(this.header, 18, this.header.length, (byte)0);
        this.out.print("Writing header... ");
        output.setPosition(0L);
        output.write(this.header, 0, this.header.length);
        this.out.println("OK");
        this.out.print("Writing TOC... ");
        i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            output.write(tocEntry, 0, 46 + tocEntry[13]);
            ++i;
        }
        output.close();
        this.out.println("OK");
        this.out.println("Packing finished");
        return fileSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long rePack(ByteSource input, ByteSource output) throws ACAException, IOException {
        String fileId = null;
        int tocEntries = 0;
        long fileSize = 0L;
        byte[] tocEntry = null;
        long offset = 0L;
        long size = 0L;
        long crc32 = 0L;
        byte mimeType = 0;
        String fileName = null;
        long oldOffset = 0L;
        long dataCrc32 = 0L;
        long outSize = 0L;
        CopyResult cr = null;
        this.out.print("Reading header... ");
        if (input.read(this.header, 0, this.header.length) != this.header.length) throw new ACAException("File too small to be an ACA file");
        fileId = new String(this.header, 0, idString.length(), "US-ASCII");
        if (!fileId.equals(idString)) throw new ACAException("Invalid file id");
        if (ByteArray.getVarLong(this.header, 8, 4) > 0x100001L) throw new ACAException("Unsupported ACA file version");
        tocEntries = ByteArray.getUShort(this.header, 12);
        fileSize = ByteArray.getVarLong(this.header, 14, 4);
        if (fileSize > input.size()) throw new ACAException("Physical filesize smaller than ACA filesize");
        this.out.println("OK");
        this.out.print("Reading TOC... ");
        int i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            if (tocEntry == null) {
                tocEntry = new byte[301];
                this.toc[i] = tocEntry;
            }
            input.read(tocEntry, 0, 14);
            input.read(tocEntry, 14, (tocEntry[13] & 0xFF) + 32);
            ++i;
        }
        this.out.println("OK");
        oldOffset = input.getPosition();
        output.setPosition(oldOffset);
        outSize = oldOffset;
        this.out.println("Repacking files...");
        i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            offset = ByteArray.getVarLong(tocEntry, 0, 4);
            size = ByteArray.getVarLong(tocEntry, 4, 4);
            crc32 = ByteArray.getVarLong(tocEntry, 8, 4);
            fileName = new String(tocEntry, 14, (int)tocEntry[13], "US-ASCII");
            if (offset < oldOffset) throw new ACAException("Offset of current file is inside previous file");
            oldOffset = offset + size;
            if (oldOffset > fileSize) throw new ACAException("Current file exceeds total file size");
            this.out.print(fileName);
            input.setPosition(offset);
            input.addWindow(size);
            output.addWindow(size);
            if (this.aacsDec != null && (ByteArray.getUByte(tocEntry, 12) == (mimeTypes.get(null) & 0xFF) || this.contentCheck)) {
                Byte mimeTypeObject;
                this.out.print(", searching AACS... ");
                try {
                    cr = this.aacsDec.decryptArf(input, output);
                    if (cr.size != size) {
                        this.out.println("REMOVED");
                    } else {
                        this.out.println("NONE");
                    }
                }
                catch (AACSException e) {
                    this.out.println("ERROR");
                    this.out.println(e.getMessage());
                    throw new ACAException("Could not add file to archive", e);
                }
                size = cr.size;
                crc32 = cr.crc32;
                mimeType = mimeTypes.get(null);
                int extOffset = fileName.lastIndexOf(46);
                if (extOffset >= 0 && (mimeTypeObject = mimeTypes.get(fileName.substring(extOffset).toUpperCase())) != null) {
                    mimeType = mimeTypeObject;
                }
                ByteArray.setInt(tocEntry, 0, (int)outSize);
                ByteArray.setInt(tocEntry, 4, (int)size);
                ByteArray.setInt(tocEntry, 8, (int)crc32);
                ByteArray.setByte(tocEntry, 12, mimeType);
            } else {
                if (this.contentCheck) {
                    this.out.print(", searching AACS... ");
                    if (AACSDecrypter.isArfEncrypted(input)) {
                        this.out.println("FOUND");
                    } else {
                        this.out.println("NONE");
                    }
                } else {
                    this.out.println();
                }
                cr = Utils.copyBs(input, output, size);
            }
            output.removeWindow();
            input.removeWindow();
            outSize += cr.size;
            dataCrc32 = cr.crc32;
            ++i;
        }
        i = 0;
        ByteArray.setInt(this.header, 14, (int)outSize);
        this.out.print("Writing header... ");
        output.setPosition(0L);
        output.write(this.header, 0, this.header.length);
        this.out.println("OK");
        this.out.print("Writing TOC... ");
        i = 0;
        while (i < tocEntries) {
            tocEntry = this.toc[i];
            output.write(tocEntry, 0, 46 + tocEntry[13]);
            ++i;
        }
        this.out.println("OK");
        this.out.println("Repacking finished");
        return outSize;
    }

    public void clearTocTable() {
        int i = 0;
        while (i < this.toc.length) {
            this.toc[i] = null;
            ++i;
        }
    }

    public boolean isContentChecking() {
        return this.contentCheck;
    }

    public void setContentChecking(boolean contentCheck) {
        this.contentCheck = contentCheck;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        System.out.println("ACAPacker 0.8 by KenD00");
        System.out.println();
        mode = -1;
        crypto = 2;
        currentArg = 0;
        if (args.length > 1 && (cli = args[currentArg]).startsWith("-")) {
            i = 1;
            while (i < cli.length()) {
                switch (cli.charAt(i)) {
                    case 'D': 
                    case 'd': {
                        mode = 0;
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        mode = 1;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        mode = 2;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        mode = 3;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (i + 1 >= cli.length()) break;
                        switch (cli.charAt(i + 1)) {
                            case '0': {
                                crypto = 0;
                                break;
                            }
                            case '1': {
                                crypto = 1;
                                break;
                            }
                            case '2': {
                                crypto = 2;
                            }
                        }
                        ++i;
                    }
                }
                ++i;
            }
            ++currentArg;
        }
        switch (mode) {
            case 0: {
                if (currentArg + 2 == args.length) {
                    in = new File(args[currentArg]).getAbsoluteFile();
                    out = new File(args[currentArg + 1]).getAbsoluteFile();
                    if (in.isFile()) {
                        if (!out.exists()) {
                            out.mkdirs();
                        }
                        if (out.isDirectory()) {
                            packer = ACAPacker.initACAPacker(crypto, in);
                            if (packer != null) {
                                try {
                                    inSrc = new FileSource(in, 0);
                                    try {
                                        written = packer.dePack(inSrc, out);
                                        inSrc.close();
                                        System.out.println("Written: " + written);
                                    }
                                    catch (ACAException e) {
                                        System.out.println("Error: " + e.getMessage());
                                        inSrc.close();
                                        System.exit(2);
                                    }
                                    System.exit(0);
                                }
                                catch (IOException e) {
                                    System.out.println("Error: " + e.getMessage());
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            System.out.println("Error: output is not a directory");
                        }
                    } else {
                        System.out.println("Error: input file not found");
                    }
                } else {
                    System.out.println("Error: invalid number of arguments");
                }
                System.exit(1);
                break;
            }
            case 1: {
                if (currentArg + 2 != args.length) ** GOTO lbl114
                in = new File(args[currentArg]).getAbsoluteFile();
                inDirectory = in.getParentFile();
                out = new File(args[currentArg + 1]).getAbsoluteFile();
                if (!in.isFile()) ** GOTO lbl112
                if (out.isDirectory()) ** GOTO lbl110
                try {
                    inList = new LinkedList<File>();
                    inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), "US-ASCII"));
                    while ((inFileName = inReader.readLine()) != null) {
                        inFile = new File(inFileName);
                        if (!inFile.isAbsolute()) {
                            inList.add(new File(inDirectory, inFileName));
                            continue;
                        }
                        inList.add(inFile);
                    }
                    inReader.close();
                    packer = ACAPacker.initACAPacker(crypto, in);
                    if (packer != null) {
                        try {
                            written = packer.pack(inList, out);
                            System.out.println("Written: " + written);
                        }
                        catch (ACAException e) {
                            System.out.println("Error: " + e.getMessage());
                            System.exit(2);
                        }
                        System.exit(0);
                    }
                    ** GOTO lbl115
                }
                catch (IOException e) {
                    System.out.println("Error: " + e.getMessage());
                    e.printStackTrace();
                }
                ** GOTO lbl115
lbl110:
                // 1 sources

                System.out.println("Error: output is a directory");
                ** GOTO lbl115
lbl112:
                // 1 sources

                System.out.println("Error: input file not found");
                ** GOTO lbl115
lbl114:
                // 1 sources

                System.out.println("Error: invalid number of arguments");
lbl115:
                // 6 sources

                System.exit(1);
                break;
            }
            case 2: {
                if (currentArg + 2 != args.length) ** GOTO lbl150
                in = new File(args[currentArg]).getAbsoluteFile();
                out = new File(args[currentArg + 1]).getAbsoluteFile();
                if (!in.isFile()) ** GOTO lbl148
                if (out.isDirectory()) ** GOTO lbl146
                try {
                    packer = ACAPacker.initACAPacker(crypto, in);
                    if (packer != null) {
                        inSource = new FileSource(in, 0);
                        outSource = new FileSource(out, 2);
                        try {
                            written = packer.rePack(inSource, outSource);
                            outSource.close();
                            inSource.close();
                            System.out.println("Written: " + written);
                        }
                        catch (ACAException e) {
                            System.out.println("Error: " + e.getMessage());
                            outSource.close();
                            inSource.close();
                            System.exit(2);
                        }
                        System.exit(0);
                    }
                    ** GOTO lbl151
                }
                catch (IOException e) {
                    System.out.println("Error: " + e.getMessage());
                    e.printStackTrace();
                }
                ** GOTO lbl151
lbl146:
                // 1 sources

                System.out.println("Error: output is a directory");
                ** GOTO lbl151
lbl148:
                // 1 sources

                System.out.println("Error: input file not found");
                ** GOTO lbl151
lbl150:
                // 1 sources

                System.out.println("Error: invalid number of arguments");
lbl151:
                // 6 sources

                System.exit(1);
                break;
            }
            case 3: {
                if (currentArg + 1 == args.length) {
                    in = new File(args[currentArg]).getAbsoluteFile();
                    if (in.isFile()) {
                        packer = new ACAPacker(new PrintStreamPrinter(System.out));
                        try {
                            inSrc = new FileSource(in, 0);
                            try {
                                packer.list(inSrc);
                                inSrc.close();
                                System.exit(0);
                            }
                            catch (ACAException e) {
                                System.out.println("Error: " + e.getMessage());
                                inSrc.close();
                                System.exit(2);
                            }
                        }
                        catch (IOException e) {
                            System.out.println("Error: " + e.getMessage());
                            e.printStackTrace();
                        }
                        System.exit(0);
                    } else {
                        System.out.println("Error: input file not found");
                    }
                } else {
                    System.out.println("Error: invalid number of arguments");
                }
                System.exit(1);
            }
        }
        System.out.println("Usage: ACAPacker -parameters input [output]");
        System.out.println();
        System.out.println("Parameters:");
        System.out.println(" -d    Depack mode");
        System.out.println("       input  : input ACA file");
        System.out.println("       output : output directory");
        System.out.println("       Depacks the contents of the input file into the output directory");
        System.out.println("       Existing files in the output directory get overwritten");
        System.out.println();
        System.out.println(" -p    Pack mode");
        System.out.println("       input  : input file list file");
        System.out.println("                A text file with a filename in every line");
        System.out.println("                If the filename denotes no / a relative path the path is");
        System.out.println("                resolved against the path of the input file list file");
        System.out.println("       output : output ACA file");
        System.out.println("       Packs the files from the input list into the output ACA file");
        System.out.println("       The output ACA file gets overwritten if it already exists");
        System.out.println();
        System.out.println(" -r    Repack mode");
        System.out.println("       input  : input ACA file");
        System.out.println("       output : output ACA file");
        System.out.println("       Repacks the input ACA file into the output ACA file,");
        System.out.println("       only useful with -c2");
        System.out.println("       The output ACA file gets overwritten if it already exists");
        System.out.println();
        System.out.println(" -l    List mode");
        System.out.println("       input  : input ACA file");
        System.out.println("       Lists the header information and prints out the TOC of the");
        System.out.println("       input ACA file");
        System.out.println();
        System.out.println(" -c[x] Cryptography parameters, used in all modes except list mode");
        System.out.println("       x = 0 : Do not detect AACS");
        System.out.println("       x = 1 : Detect AACS but do not process it");
        System.out.println("       x = 2 : Detect and remove AACS (default)");
        System.out.println("               This mode requires the AACS directory to be present");
        System.out.println("               in the parent directory of the directory of the input file");
    }

    private static ACAPacker initACAPacker(int crypto, File srcFile) {
        ACAPacker returnValue = null;
        if (crypto > 1) {
            KeyDataFile kdf = null;
            AACSDecrypter aacsDec = null;
            try {
                kdf = new KeyDataFile(new File("KEYDB.cfg"));
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                srcFile = null;
            }
            if (srcFile != null) {
                if ((srcFile = srcFile.getParentFile()) != null) {
                    if ((srcFile = srcFile.getParentFile()) != null) {
                        if (srcFile.isDirectory()) {
                            DiscSet ws = new DiscSet(3, srcFile);
                            if ((srcFile = new File(srcFile, "AACS")).isDirectory()) {
                                ws.aacsDir = srcFile;
                                try {
                                    aacsDec = new AACSDecrypter(new PrintStreamPrinter(System.out), kdf);
                                    aacsDec.identifyDisc(ws);
                                    aacsDec.initDisc(ws);
                                    aacsDec.init(ws);
                                }
                                catch (AACSException e) {
                                    System.out.println(e.getMessage());
                                    srcFile = null;
                                }
                                try {
                                    kdf.close();
                                }
                                catch (IOException e) {
                                    System.out.println("Warning: " + e.getMessage());
                                }
                            } else {
                                System.out.println("AACS directory not found");
                                srcFile = null;
                            }
                        } else {
                            System.out.println("Root is not a directory");
                            srcFile = null;
                        }
                    } else {
                        System.out.println("Could not traverse into root directory");
                    }
                } else {
                    System.out.println("Source has no parent directory");
                }
            }
            if (srcFile == null) {
                System.out.println("Error: AACS not initialized");
                return null;
            }
            returnValue = new ACAPacker(new PrintStreamPrinter(System.out), aacsDec);
        } else {
            returnValue = new ACAPacker(new PrintStreamPrinter(System.out));
        }
        if (crypto > 0) {
            returnValue.setContentChecking(true);
        }
        return returnValue;
    }
}

