.PHONY: all objdir clean realclean

# CONTENT

MODULE := Test3D
CONFIG := debug
ifndef COMPILER
COMPILER := default
endif

_CF_DIR = $(CF_DIR)

ifndef DEBUG
OPTIMIZE := -g
else
OPTIMIZE := -g
NOSTRIP := y
endif
TARGET_TYPE = executable

ifeq "$(TARGET_TYPE)" "executable"
CONSOLE = -mwindows
endif

# FLAGS

CFLAGS =
CECFLAGS =
ECFLAGS =
OFLAGS =
LIBS =

# INCLUDES

include $(_CF_DIR)crossplatform.mk
include $(_CF_DIR)$(PLATFORM)-$(COMPILER).cf

# VARIABLES

OBJ = obj/$(CONFIG).$(PLATFORM)/

ifdef DEBUG
CFLAGS += -D_DEBUG
endif

RES = 

TARGET = obj/$(CONFIG).$(PLATFORM)/Test3D$(E)

OBJECTS = \
	$(OBJ)Test3D.o \
	$(OBJ)$(MODULE).main$(O)

_ECSOURCES = \
	Test3D.ec

ECSOURCES = $(call shwspace,$(_ECSOURCES))

COBJECTS = $(call shwspace,$(addprefix $(OBJ),$(patsubst %.ec,%$(C),$(notdir $(_ECSOURCES)))))

SYMBOLS = $(call shwspace,$(addprefix $(OBJ),$(patsubst %.ec,%$(S),$(notdir $(_ECSOURCES)))))

IMPORTS = $(call shwspace,$(addprefix $(OBJ),$(patsubst %.ec,%$(I),$(notdir $(_ECSOURCES)))))

SOURCES = $(ECSOURCES)

RESOURCES =

LIBS += $(SHAREDLIB) $(EXECUTABLE) $(LINKOPT)

ifneq "$(TARGET_TYPE)" "staticlib"
LIBS += \
	$(call _L,ecere)
endif

CFLAGS += $(OPTIMIZE) $(FORCE_32_BIT) $(FPIC) -Wall

CECFLAGS += -cpp $(call escspace,$(CPP)) -t $(PLATFORM)

ECFLAGS +=

ifneq "$(TARGET_TYPE)" "staticlib"
OFLAGS += $(FORCE_32_BIT)
endif

# TARGETS

all: objdir $(TARGET)

objdir:
	$(if $(wildcard $(OBJ)),,$(call mkdirq,$(OBJ)))

$(OBJ)$(MODULE).main.ec: $(SYMBOLS) $(COBJECTS)
	$(ECS) $(ECSLIBOPT) $(SYMBOLS) $(IMPORTS) -symbols obj/$(CONFIG).$(PLATFORM) -o $(OBJ)$(MODULE).main.ec

$(OBJ)$(MODULE).main.c: $(OBJ)$(MODULE).main.ec
	$(ECP) $(CECFLAGS) $(ECFLAGS) $(CFLAGS) -c $(OBJ)$(MODULE).main.ec -o $(OBJ)$(MODULE).main.sym -symbols $(OBJ)
	$(ECC) $(CECFLAGS) $(ECFLAGS) $(CFLAGS) $(FVISIBILITY) -c $(OBJ)$(MODULE).main.ec -o $(OBJ)$(MODULE).main.c -symbols $(OBJ)

$(SYMBOLS): | objdir
$(OBJECTS): | objdir
$(TARGET): $(SOURCES) $(RESOURCES) $(SYMBOLS) $(OBJECTS) | objdir
ifneq "$(TARGET_TYPE)" "staticlib"
	$(CC) $(OFLAGS) $(OBJECTS) $(LIBS) -o $(TARGET) $(INSTALLNAME)
else
	$(AR) rcs $(TARGET) $(OBJECTS) $(LIBS)
endif

# SYMBOL RULES

$(OBJ)Test3D.sym: Test3D.ec
	$(ECP) $(CECFLAGS) $(ECFLAGS) $(CFLAGS) -c Test3D.ec -o $(OBJ)Test3D.sym

# C OBJECT RULES

$(OBJ)Test3D.c: Test3D.ec $(OBJ)Test3D.sym | $(SYMBOLS)
	$(ECC) $(CECFLAGS) $(ECFLAGS) $(CFLAGS) $(FVISIBILITY) -c Test3D.ec -o $(OBJ)Test3D.c -symbols $(OBJ)

# OBJECT RULES

$(OBJ)Test3D.o: $(OBJ)Test3D.c
	$(CC) $(CFLAGS) $(FVISIBILITY) -c $(OBJ)Test3D.c -o $(OBJ)Test3D.o

$(OBJ)$(MODULE).main$(O): $(OBJ)$(MODULE).main.c
	$(CC) $(CFLAGS) $(FVISIBILITY) -c $(OBJ)$(MODULE).main.c -o $(OBJ)$(MODULE).main$(O)

clean: objdir
	$(call rmq,$(OBJ)$(MODULE).main.c $(OBJ)$(MODULE).main.ec $(OBJ)$(MODULE).main$(I) $(OBJ)$(MODULE).main$(S) $(TARGET))
	$(call rmq,$(OBJECTS))
	$(call rmq,$(COBJECTS))
	$(call rmq,$(BOWLS))
	$(call rmq,$(IMPORTS))
	$(call rmq,$(SYMBOLS))

realclean: clean
	$(call rmrq,$(OBJ))

