/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GribResourceReader {
    private static GribResourceReader gribResourceReader;

    public static void setGribResourceReader(GribResourceReader reader) {
        gribResourceReader = reader;
    }

    public abstract InputStream openInputStream(String var1) throws IOException;

    public static InputStream getInputStream(String resourceName) {
        return GribResourceReader.getInputStream(resourceName, null);
    }

    public static InputStream getInputStream(String resourceName, Class originClass) {
        if (gribResourceReader != null) {
            try {
                InputStream inputStream = gribResourceReader.openInputStream(resourceName);
                if (inputStream != null) {
                    return inputStream;
                }
            }
            catch (IOException ioe) {
                System.err.println("Failed to open:" + resourceName + "\n" + ioe);
            }
        }
        InputStream s = null;
        while (originClass != null && (s = originClass.getResourceAsStream(resourceName)) == null) {
            originClass = originClass.getSuperclass();
        }
        ClassLoader cl = GribResourceReader.class.getClassLoader();
        s = cl.getResourceAsStream(resourceName);
        if (s != null) {
            return s;
        }
        File f = new File(resourceName);
        if (f.exists()) {
            try {
                s = new FileInputStream(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (s != null) {
            return s;
        }
        try {
            Matcher m = Pattern.compile(" ").matcher(resourceName);
            String encodedUrl = m.replaceAll("%20");
            URL dataUrl = new URL(encodedUrl);
            URLConnection connection = dataUrl.openConnection();
            s = connection.getInputStream();
        }
        catch (Exception exc) {
            // empty catch block
        }
        return s;
    }

    public static String getFileRoot(String f) {
        int idx = f.lastIndexOf("/");
        if (idx < 0) {
            idx = f.lastIndexOf(File.separator);
        }
        if (idx < 0) {
            return f;
        }
        return f.substring(0, idx);
    }
}

