// mag_compass.hxx - an altimeter tied to the static port.
// Written by David Megginson, started 2002.
//
// This file is in the Public Domain and comes with no warranty.


#ifndef __INSTRUMENTS_MAG_COMPASS_HXX
#define __INSTRUMENTS_MAG_COMPASS_HXX 1

#ifndef __cplusplus
# error This library requires C++
#endif

#include <simgear/props/props.hxx>
#include <simgear/structure/subsystem_mgr.hxx>
#include <simgear/math/interpolater.hxx>


/**
 * Model a magnetic compass.
 *
 * Input properties:
 *
 * /instrumentation/"name"/serviceable
 * /instrumentation/"name"/pitch-offset-deg
 * /instrumentation/"name"/max-pitch-deg
 * /instrumentation/"name"/max-roll-deg
 * /orientation/roll-deg
 * /orientation/pitch-deg
 * /orientation/heading-magnetic-deg
 * /orientation/side-slip-deg
 * /environment/magnetic-dip-deg
 * /accelerations/pilot/north-accel-fps_sec
 * /accelerations/pilot/east-accel-fps_sec
 * /accelerations/pilot/down-accel-fps_sec
 *
 * Output properties:
 *
 * /instrumentation/"name"/indicated-heading-deg
 */
class MagCompass : public SGSubsystem
{
public:
    MagCompass ( SGPropertyNode *node);
    MagCompass ();
    virtual ~MagCompass ();

    // Subsystem API.
    void init() override;
    void reinit() override;
    void update(double dt) override;

    // Subsystem identification.
    static const char* staticSubsystemClassId() { return "magnetic-compass"; }

private:
    double _rate_degps;

    std::string _name;
    int _num;
    SGSharedPtr<SGInterpTable> _deviation_table;
    SGPropertyNode_ptr _deviation_node;

    SGPropertyNode_ptr _serviceable_node;
    SGPropertyNode_ptr _pitch_offset_node;
    SGPropertyNode_ptr _roll_node;
    SGPropertyNode_ptr _pitch_node;
    SGPropertyNode_ptr _heading_node;
    SGPropertyNode_ptr _beta_node;
    SGPropertyNode_ptr _dip_node;
    SGPropertyNode_ptr _x_accel_node;
    SGPropertyNode_ptr _y_accel_node;
    SGPropertyNode_ptr _z_accel_node;
    SGPropertyNode_ptr _out_node;
};

#endif // __INSTRUMENTS_MAG_COMPASS_HXX
