{
    Copyright (c) 1998-2000 by Florian Klaempfl and Peter Vreman

    Contains the basic declarations for the i8086 architecture

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************
}
{ This include file contains the basic declarations for the i8086 architecture.
}

{*****************************************************************************
                                Operand Sizes
*****************************************************************************}

    type
      topsize = (S_NO,
        S_B,S_W,S_L,S_Q,S_BW,S_BL,S_WL,
        S_IS,S_IL,S_IQ,
        S_FS,S_FL,S_FX,S_FV,S_FXX,
        S_MD,
        S_NEAR,S_FAR,S_SHORT,
        S_T,
        S_XMM,
        S_YMM,
        S_ZMM
      );

      TOpSizes = set of topsize;

{*****************************************************************************
                                Registers
*****************************************************************************}
  const
      {# Standard opcode string table (for each tasmop enumeration). The
         opcode strings should conform to the names as defined by the
         processor manufacturer.
      }
      std_op2str:op2strtable={$i i8086int.inc}

{*****************************************************************************
                               GDB Information
*****************************************************************************}

      {# Register indexes for stabs information, when some
         parameters or variables are stored in registers.

         Taken from i386.c (dbx_register_map) and i386.h
          (FIXED_REGISTERS) from GCC 3.x source code

      }
      reg_stab_table : array[tregisterindex] of shortint = (
        {$i r8086stab.inc}
      );


{*****************************************************************************
                          Default generic sizes
*****************************************************************************}

      {# Defines the default address size for a processor, }
      OS_ADDR = OS_16;
      {# the natural int size for a processor,
         has to match osuinttype/ossinttype as initialized in psystem }
      OS_INT = OS_16;
      OS_SINT = OS_S16;
      {# the maximum float size for a processor,           }
      OS_FLOAT = OS_F80;
      {# the size of a vector register for a processor     }
      OS_VECTOR = OS_M128;

{*****************************************************************************
                          Generic Register names
*****************************************************************************}

      {# Stack pointer register }
      NR_STACK_POINTER_REG = NR_SP;
      RS_STACK_POINTER_REG = RS_SP;
      {# Frame pointer register }
      RS_FRAME_POINTER_REG = RS_BP;
      NR_FRAME_POINTER_REG = NR_BP;
      { Return address for DWARF }
      NR_RETURN_ADDRESS_REG = NR_EIP;
      { Results are returned in this register (16-bit values) }
      NR_FUNCTION_RETURN_REG = NR_AX;
      RS_FUNCTION_RETURN_REG = RS_AX;
      { Low part of 32bit return value }
      NR_FUNCTION_RETURN32_LOW_REG = NR_AX;
      RS_FUNCTION_RETURN32_LOW_REG = RS_AX;
      { High part of 32bit return value }
      NR_FUNCTION_RETURN32_HIGH_REG = NR_DX;
      RS_FUNCTION_RETURN32_HIGH_REG = RS_DX;
      { Bits 0..15 of 64bit return value }
      NR_FUNCTION_RETURN64_LOW_REG = NR_DX;
      RS_FUNCTION_RETURN64_LOW_REG = RS_DX;
      { Bits 16..31 of 64bit return value }
      NR_FUNCTION_RETURN64_HIGH_REG = NR_CX;
      RS_FUNCTION_RETURN64_HIGH_REG = RS_CX;
      { Bits 32..47 of 64bit return value }
      NR_FUNCTION_RETURN64_HIGHER_REG = NR_BX;
      RS_FUNCTION_RETURN64_HIGHER_REG = RS_BX;
      { Bits 48..63 of 64bit return value }
      NR_FUNCTION_RETURN64_HIGHEST_REG = NR_AX;
      RS_FUNCTION_RETURN64_HIGHEST_REG = RS_AX;
      { The value returned from a function is available in this register }
      NR_FUNCTION_RESULT_REG = NR_FUNCTION_RETURN_REG;
      RS_FUNCTION_RESULT_REG = RS_FUNCTION_RETURN_REG;
      { The lowh part of 32bit value returned from a function }
      NR_FUNCTION_RESULT32_LOW_REG = NR_FUNCTION_RETURN32_LOW_REG;
      RS_FUNCTION_RESULT32_LOW_REG = RS_FUNCTION_RETURN32_LOW_REG;
      { The high part of 32bit value returned from a function }
      NR_FUNCTION_RESULT32_HIGH_REG = NR_FUNCTION_RETURN32_HIGH_REG;
      RS_FUNCTION_RESULT32_HIGH_REG = RS_FUNCTION_RETURN32_HIGH_REG;
      { Bits 0..15 of 64bit return value returned from a function }
      NR_FUNCTION_RESULT64_LOW_REG = NR_FUNCTION_RETURN64_LOW_REG;
      RS_FUNCTION_RESULT64_LOW_REG = RS_FUNCTION_RETURN64_LOW_REG;
      { Bits 16..31 of 64bit return value returned from a function }
      NR_FUNCTION_RESULT64_HIGH_REG = NR_FUNCTION_RETURN64_HIGH_REG;
      RS_FUNCTION_RESULT64_HIGH_REG = RS_FUNCTION_RETURN64_HIGH_REG;
      { Bits 32..47 of 64bit return value returned from a function }
      NR_FUNCTION_RESULT64_HIGHER_REG = NR_FUNCTION_RETURN64_HIGHER_REG;
      RS_FUNCTION_RESULT64_HIGHER_REG = RS_FUNCTION_RETURN64_HIGHER_REG;
      { Bits 48..63 of 64bit return value returned from a function }
      NR_FUNCTION_RESULT64_HIGHEST_REG = NR_FUNCTION_RETURN64_HIGHEST_REG;
      RS_FUNCTION_RESULT64_HIGHEST_REG = RS_FUNCTION_RETURN64_HIGHEST_REG;

      { WARNING: don't change to R_ST0!! See comments above implementation of }
      { a_loadfpu* methods in rgcpu (JM)                                      }
      NR_fpu_result_reg = NR_ST;
      NR_mm_result_reg = NR_MM0;

      { Offset where the parent framepointer is pushed }
      PARENT_FRAMEPOINTER_OFFSET = 8;

{*****************************************************************************
                       GCC /ABI linking information
*****************************************************************************}

    const
      {# Required parameter alignment when calling a routine declared as
         stdcall and cdecl. The alignment value should be the one defined
         by GCC or the target ABI.

         The value of this constant is equal to the constant
         PARM_BOUNDARY / BITS_PER_UNIT in the GCC source.
      }
      std_param_align = 2;
