/*
 * $Id: gfrm_simple.c 4695 2010-05-27 11:54:51Z n-soda $
 */

#include <stdio.h>
#include <stdlib.h>
#include <libgen.h>
#include <unistd.h>

#include <gfarm/gfarm.h>

char *program_name = "gfrm";

static void
usage(void)
{
	fprintf(stderr, "Usage: %s [-f] [-h hostname] file...\n", program_name);
	exit(EXIT_FAILURE);
}

int
main(int argc, char **argv)
{
	gfarm_error_t e;
	int i, n, c, status = 0;
	int opt_force = 0;
	char *host = NULL;
	gfarm_stringlist paths;
	gfs_glob_t types;

	if (argc > 0)
		program_name = basename(argv[0]);
	e = gfarm_initialize(&argc, &argv);
	if (e != GFARM_ERR_NO_ERROR) {
		fprintf(stderr, "%s: %s\n", program_name,
		    gfarm_error_string(e));
		exit(EXIT_FAILURE);
	}

	while ((c = getopt(argc, argv, "fh:?")) != -1) {
		switch (c) {
		case 'f':
			opt_force = 1;
			break;
		case 'h':
			host = optarg;
			break;
		case '?':
		default:
			usage();
		}
	}
	argc -= optind;
	argv += optind;
	if (argc <= 0)
		usage();

	e = gfarm_stringlist_init(&paths);
	if (e != GFARM_ERR_NO_ERROR) {
		fprintf(stderr, "%s: %s\n", program_name,
		    gfarm_error_string(e));
		exit(EXIT_FAILURE);
	}
	e = gfs_glob_init(&types);
	if (e != GFARM_ERR_NO_ERROR) {
		fprintf(stderr, "%s: %s\n", program_name,
		    gfarm_error_string(e));
		exit(EXIT_FAILURE);
	}
	for (i = 0; i < argc; i++)
		gfs_glob(argv[i], &paths, &types);
	gfs_glob_free(&types);

	n = gfarm_stringlist_length(&paths);
	for (i = 0; i < n; i++) {
		char *p = gfarm_stringlist_elem(&paths, i);

		if (host == NULL)
			e = gfs_unlink(p);
		else
			e = gfs_replica_remove_by_file(p, host);
		if (e != GFARM_ERR_NO_ERROR &&
		    (!opt_force || e != GFARM_ERR_NO_SUCH_FILE_OR_DIRECTORY)) {
			fprintf(stderr, "%s: %s: %s\n",
			    program_name, p, gfarm_error_string(e));
			status = 1;
		}
	}
	gfarm_stringlist_free_deeply(&paths);
	e = gfarm_terminate();
	if (e != GFARM_ERR_NO_ERROR) {
		fprintf(stderr, "%s: %s\n", program_name,
		    gfarm_error_string(e));
		status = 1;
	}
	return (status);
}
