/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimptextlayer_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_TEXT_LAYER_PDB_H__
#define __GIMP_TEXT_LAYER_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gint32                gimp_text_layer_new                (gint32                 image_ID,
                                                          const gchar           *text,
                                                          const gchar           *fontname,
                                                          gdouble                size,
                                                          GimpUnit               unit);
gchar*                gimp_text_layer_get_text           (gint32                 layer_ID);
gboolean              gimp_text_layer_set_text           (gint32                 layer_ID,
                                                          const gchar           *text);
gchar*                gimp_text_layer_get_markup         (gint32                 layer_ID);
gchar*                gimp_text_layer_get_font           (gint32                 layer_ID);
gboolean              gimp_text_layer_set_font           (gint32                 layer_ID,
                                                          const gchar           *font);
gdouble               gimp_text_layer_get_font_size      (gint32                 layer_ID,
                                                          GimpUnit              *unit);
gboolean              gimp_text_layer_set_font_size      (gint32                 layer_ID,
                                                          gdouble                font_size,
                                                          GimpUnit               unit);
gboolean              gimp_text_layer_get_antialias      (gint32                 layer_ID);
gboolean              gimp_text_layer_set_antialias      (gint32                 layer_ID,
                                                          gboolean               antialias);
GimpTextHintStyle     gimp_text_layer_get_hint_style     (gint32                 layer_ID);
gboolean              gimp_text_layer_set_hint_style     (gint32                 layer_ID,
                                                          GimpTextHintStyle      style);
gboolean              gimp_text_layer_get_kerning        (gint32                 layer_ID);
gboolean              gimp_text_layer_set_kerning        (gint32                 layer_ID,
                                                          gboolean               kerning);
gchar*                gimp_text_layer_get_language       (gint32                 layer_ID);
gboolean              gimp_text_layer_set_language       (gint32                 layer_ID,
                                                          const gchar           *language);
GimpTextDirection     gimp_text_layer_get_base_direction (gint32                 layer_ID);
gboolean              gimp_text_layer_set_base_direction (gint32                 layer_ID,
                                                          GimpTextDirection      direction);
GimpTextJustification gimp_text_layer_get_justification  (gint32                 layer_ID);
gboolean              gimp_text_layer_set_justification  (gint32                 layer_ID,
                                                          GimpTextJustification  justify);
gboolean              gimp_text_layer_get_color          (gint32                 layer_ID,
                                                          GimpRGB               *color);
gboolean              gimp_text_layer_set_color          (gint32                 layer_ID,
                                                          const GimpRGB         *color);
gdouble               gimp_text_layer_get_indent         (gint32                 layer_ID);
gboolean              gimp_text_layer_set_indent         (gint32                 layer_ID,
                                                          gdouble                indent);
gdouble               gimp_text_layer_get_line_spacing   (gint32                 layer_ID);
gboolean              gimp_text_layer_set_line_spacing   (gint32                 layer_ID,
                                                          gdouble                line_spacing);
gdouble               gimp_text_layer_get_letter_spacing (gint32                 layer_ID);
gboolean              gimp_text_layer_set_letter_spacing (gint32                 layer_ID,
                                                          gdouble                letter_spacing);
gboolean              gimp_text_layer_resize             (gint32                 layer_ID,
                                                          gdouble                width,
                                                          gdouble                height);
GIMP_DEPRECATED_FOR(gimp_text_layer_get_hint_style)
gboolean              gimp_text_layer_get_hinting        (gint32                 layer_ID,
                                                          gboolean              *autohint);
GIMP_DEPRECATED_FOR(gimp_text_layer_set_hint_style)
gboolean              gimp_text_layer_set_hinting        (gint32                 layer_ID,
                                                          gboolean               hinting,
                                                          gboolean               autohint);


G_END_DECLS

#endif /* __GIMP_TEXT_LAYER_PDB_H__ */
