// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns all stack related events for a specified stack in reverse chronological
// order. For more information about a stack's event history, see [CloudFormation stack creation events]in the
// CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
//
// [CloudFormation stack creation events]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html
func (c *Client) DescribeStackEvents(ctx context.Context, params *DescribeStackEventsInput, optFns ...func(*Options)) (*DescribeStackEventsOutput, error) {
	if params == nil {
		params = &DescribeStackEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeStackEvents", params, optFns, c.addOperationDescribeStackEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeStackEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input for DescribeStackEvents action.
type DescribeStackEventsInput struct {

	// A string that identifies the next page of events that you want to retrieve.
	NextToken *string

	// The name or the unique stack ID that's associated with the stack, which aren't
	// always interchangeable:
	//
	//   - Running stacks: You can specify either the stack's name or its unique stack
	//   ID.
	//
	//   - Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string

	noSmithyDocumentSerde
}

// The output for a DescribeStackEvents action.
type DescribeStackEventsOutput struct {

	// If the output exceeds 1 MB in size, a string that identifies the next page of
	// events. If no additional page exists, this value is null.
	NextToken *string

	// A list of StackEvents structures.
	StackEvents []types.StackEvent

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeStackEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeStackEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeStackEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeStackEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeStackEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeStackEventsPaginatorOptions is the paginator options for
// DescribeStackEvents
type DescribeStackEventsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeStackEventsPaginator is a paginator for DescribeStackEvents
type DescribeStackEventsPaginator struct {
	options   DescribeStackEventsPaginatorOptions
	client    DescribeStackEventsAPIClient
	params    *DescribeStackEventsInput
	nextToken *string
	firstPage bool
}

// NewDescribeStackEventsPaginator returns a new DescribeStackEventsPaginator
func NewDescribeStackEventsPaginator(client DescribeStackEventsAPIClient, params *DescribeStackEventsInput, optFns ...func(*DescribeStackEventsPaginatorOptions)) *DescribeStackEventsPaginator {
	if params == nil {
		params = &DescribeStackEventsInput{}
	}

	options := DescribeStackEventsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeStackEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeStackEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeStackEvents page.
func (p *DescribeStackEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeStackEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeStackEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeStackEventsAPIClient is a client that implements the
// DescribeStackEvents operation.
type DescribeStackEventsAPIClient interface {
	DescribeStackEvents(context.Context, *DescribeStackEventsInput, ...func(*Options)) (*DescribeStackEventsOutput, error)
}

var _ DescribeStackEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeStackEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeStackEvents",
	}
}
