// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package b2bi

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCapability = "CreateCapability"

// CreateCapabilityRequest generates a "aws/request.Request" representing the
// client's request for the CreateCapability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCapability for more information on using the CreateCapability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCapabilityRequest method.
//	req, resp := client.CreateCapabilityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateCapability
func (c *B2bi) CreateCapabilityRequest(input *CreateCapabilityInput) (req *request.Request, output *CreateCapabilityOutput) {
	op := &request.Operation{
		Name:       opCreateCapability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCapabilityInput{}
	}

	output = &CreateCapabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCapability API operation for AWS B2B Data Interchange.
//
// Instantiates a capability based on the specified parameters. Capabilities
// contain the information necessary to process incoming EDI (electronic data
// interchange) documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation CreateCapability for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateCapability
func (c *B2bi) CreateCapability(input *CreateCapabilityInput) (*CreateCapabilityOutput, error) {
	req, out := c.CreateCapabilityRequest(input)
	return out, req.Send()
}

// CreateCapabilityWithContext is the same as CreateCapability with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCapability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) CreateCapabilityWithContext(ctx aws.Context, input *CreateCapabilityInput, opts ...request.Option) (*CreateCapabilityOutput, error) {
	req, out := c.CreateCapabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePartnership = "CreatePartnership"

// CreatePartnershipRequest generates a "aws/request.Request" representing the
// client's request for the CreatePartnership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePartnership for more information on using the CreatePartnership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePartnershipRequest method.
//	req, resp := client.CreatePartnershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreatePartnership
func (c *B2bi) CreatePartnershipRequest(input *CreatePartnershipInput) (req *request.Request, output *CreatePartnershipOutput) {
	op := &request.Operation{
		Name:       opCreatePartnership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePartnershipInput{}
	}

	output = &CreatePartnershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePartnership API operation for AWS B2B Data Interchange.
//
// Creates a partnership between a customer and a trading partner, based on
// the supplied parameters. Partnerships link trading partners with your profile
// and a specific transformer, so that the EDI (electronic data interchange)
// documents that they upload to Amazon S3 can be processed according to their
// specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation CreatePartnership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreatePartnership
func (c *B2bi) CreatePartnership(input *CreatePartnershipInput) (*CreatePartnershipOutput, error) {
	req, out := c.CreatePartnershipRequest(input)
	return out, req.Send()
}

// CreatePartnershipWithContext is the same as CreatePartnership with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePartnership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) CreatePartnershipWithContext(ctx aws.Context, input *CreatePartnershipInput, opts ...request.Option) (*CreatePartnershipOutput, error) {
	req, out := c.CreatePartnershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProfileRequest method.
//	req, resp := client.CreateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateProfile
func (c *B2bi) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for AWS B2B Data Interchange.
//
// Creates a customer profile. You can have up to five customer profiles, each
// representing a distinct private network. Profiles contain basic information
// about you and your business.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateProfile
func (c *B2bi) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransformer = "CreateTransformer"

// CreateTransformerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransformer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransformer for more information on using the CreateTransformer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransformerRequest method.
//	req, resp := client.CreateTransformerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateTransformer
func (c *B2bi) CreateTransformerRequest(input *CreateTransformerInput) (req *request.Request, output *CreateTransformerOutput) {
	op := &request.Operation{
		Name:       opCreateTransformer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransformerInput{}
	}

	output = &CreateTransformerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransformer API operation for AWS B2B Data Interchange.
//
// Creates a transformer. Transformers describe how to process the incoming
// EDI (electronic data interchange) documents, and extract the necessary information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation CreateTransformer for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateTransformer
func (c *B2bi) CreateTransformer(input *CreateTransformerInput) (*CreateTransformerOutput, error) {
	req, out := c.CreateTransformerRequest(input)
	return out, req.Send()
}

// CreateTransformerWithContext is the same as CreateTransformer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransformer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) CreateTransformerWithContext(ctx aws.Context, input *CreateTransformerInput, opts ...request.Option) (*CreateTransformerOutput, error) {
	req, out := c.CreateTransformerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCapability = "DeleteCapability"

// DeleteCapabilityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCapability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCapability for more information on using the DeleteCapability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCapabilityRequest method.
//	req, resp := client.DeleteCapabilityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteCapability
func (c *B2bi) DeleteCapabilityRequest(input *DeleteCapabilityInput) (req *request.Request, output *DeleteCapabilityOutput) {
	op := &request.Operation{
		Name:       opDeleteCapability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCapabilityInput{}
	}

	output = &DeleteCapabilityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCapability API operation for AWS B2B Data Interchange.
//
// Deletes the specified capability. Capabilities contain the information necessary
// to process incoming EDI (electronic data interchange) documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation DeleteCapability for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteCapability
func (c *B2bi) DeleteCapability(input *DeleteCapabilityInput) (*DeleteCapabilityOutput, error) {
	req, out := c.DeleteCapabilityRequest(input)
	return out, req.Send()
}

// DeleteCapabilityWithContext is the same as DeleteCapability with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCapability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) DeleteCapabilityWithContext(ctx aws.Context, input *DeleteCapabilityInput, opts ...request.Option) (*DeleteCapabilityOutput, error) {
	req, out := c.DeleteCapabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePartnership = "DeletePartnership"

// DeletePartnershipRequest generates a "aws/request.Request" representing the
// client's request for the DeletePartnership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePartnership for more information on using the DeletePartnership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePartnershipRequest method.
//	req, resp := client.DeletePartnershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeletePartnership
func (c *B2bi) DeletePartnershipRequest(input *DeletePartnershipInput) (req *request.Request, output *DeletePartnershipOutput) {
	op := &request.Operation{
		Name:       opDeletePartnership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartnershipInput{}
	}

	output = &DeletePartnershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePartnership API operation for AWS B2B Data Interchange.
//
// Deletes the specified partnership. Partnerships link trading partners with
// your profile and a specific transformer, so that the EDI (electronic data
// interchange) documents that they upload to Amazon S3 can be processed according
// to their specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation DeletePartnership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeletePartnership
func (c *B2bi) DeletePartnership(input *DeletePartnershipInput) (*DeletePartnershipOutput, error) {
	req, out := c.DeletePartnershipRequest(input)
	return out, req.Send()
}

// DeletePartnershipWithContext is the same as DeletePartnership with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePartnership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) DeletePartnershipWithContext(ctx aws.Context, input *DeletePartnershipInput, opts ...request.Option) (*DeletePartnershipOutput, error) {
	req, out := c.DeletePartnershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileRequest method.
//	req, resp := client.DeleteProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteProfile
func (c *B2bi) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProfile API operation for AWS B2B Data Interchange.
//
// Deletes the specified profile. Profiles contain basic information about you
// and your business.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteProfile
func (c *B2bi) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransformer = "DeleteTransformer"

// DeleteTransformerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransformer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransformer for more information on using the DeleteTransformer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransformerRequest method.
//	req, resp := client.DeleteTransformerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer
func (c *B2bi) DeleteTransformerRequest(input *DeleteTransformerInput) (req *request.Request, output *DeleteTransformerOutput) {
	op := &request.Operation{
		Name:       opDeleteTransformer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransformerInput{}
	}

	output = &DeleteTransformerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTransformer API operation for AWS B2B Data Interchange.
//
// Deletes the specified transformer. Transformers describe how to process the
// incoming EDI (electronic data interchange) documents, and extract the necessary
// information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation DeleteTransformer for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer
func (c *B2bi) DeleteTransformer(input *DeleteTransformerInput) (*DeleteTransformerOutput, error) {
	req, out := c.DeleteTransformerRequest(input)
	return out, req.Send()
}

// DeleteTransformerWithContext is the same as DeleteTransformer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransformer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) DeleteTransformerWithContext(ctx aws.Context, input *DeleteTransformerInput, opts ...request.Option) (*DeleteTransformerOutput, error) {
	req, out := c.DeleteTransformerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCapability = "GetCapability"

// GetCapabilityRequest generates a "aws/request.Request" representing the
// client's request for the GetCapability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCapability for more information on using the GetCapability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCapabilityRequest method.
//	req, resp := client.GetCapabilityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetCapability
func (c *B2bi) GetCapabilityRequest(input *GetCapabilityInput) (req *request.Request, output *GetCapabilityOutput) {
	op := &request.Operation{
		Name:       opGetCapability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCapabilityInput{}
	}

	output = &GetCapabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCapability API operation for AWS B2B Data Interchange.
//
// Retrieves the details for the specified capability. Capabilities contain
// the information necessary to process incoming EDI (electronic data interchange)
// documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation GetCapability for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetCapability
func (c *B2bi) GetCapability(input *GetCapabilityInput) (*GetCapabilityOutput, error) {
	req, out := c.GetCapabilityRequest(input)
	return out, req.Send()
}

// GetCapabilityWithContext is the same as GetCapability with the addition of
// the ability to pass a context and additional request options.
//
// See GetCapability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) GetCapabilityWithContext(ctx aws.Context, input *GetCapabilityInput, opts ...request.Option) (*GetCapabilityOutput, error) {
	req, out := c.GetCapabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPartnership = "GetPartnership"

// GetPartnershipRequest generates a "aws/request.Request" representing the
// client's request for the GetPartnership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartnership for more information on using the GetPartnership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPartnershipRequest method.
//	req, resp := client.GetPartnershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetPartnership
func (c *B2bi) GetPartnershipRequest(input *GetPartnershipInput) (req *request.Request, output *GetPartnershipOutput) {
	op := &request.Operation{
		Name:       opGetPartnership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPartnershipInput{}
	}

	output = &GetPartnershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartnership API operation for AWS B2B Data Interchange.
//
// Retrieves the details for a partnership, based on the partner and profile
// IDs specified. Partnerships link trading partners with your profile and a
// specific transformer, so that the EDI (electronic data interchange) documents
// that they upload to Amazon S3 can be processed according to their specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation GetPartnership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetPartnership
func (c *B2bi) GetPartnership(input *GetPartnershipInput) (*GetPartnershipOutput, error) {
	req, out := c.GetPartnershipRequest(input)
	return out, req.Send()
}

// GetPartnershipWithContext is the same as GetPartnership with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartnership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) GetPartnershipWithContext(ctx aws.Context, input *GetPartnershipInput, opts ...request.Option) (*GetPartnershipOutput, error) {
	req, out := c.GetPartnershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileRequest method.
//	req, resp := client.GetProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetProfile
func (c *B2bi) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for AWS B2B Data Interchange.
//
// Retrieves the details for the profile specified by the profile ID. Profiles
// contain basic information about you and your business.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation GetProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetProfile
func (c *B2bi) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTransformer = "GetTransformer"

// GetTransformerRequest generates a "aws/request.Request" representing the
// client's request for the GetTransformer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTransformer for more information on using the GetTransformer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTransformerRequest method.
//	req, resp := client.GetTransformerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformer
func (c *B2bi) GetTransformerRequest(input *GetTransformerInput) (req *request.Request, output *GetTransformerOutput) {
	op := &request.Operation{
		Name:       opGetTransformer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTransformerInput{}
	}

	output = &GetTransformerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTransformer API operation for AWS B2B Data Interchange.
//
// Retrieves the details for the transformer specified by the transformer ID.
// Transformers describe how to process the incoming EDI (electronic data interchange)
// documents, and extract the necessary information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation GetTransformer for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformer
func (c *B2bi) GetTransformer(input *GetTransformerInput) (*GetTransformerOutput, error) {
	req, out := c.GetTransformerRequest(input)
	return out, req.Send()
}

// GetTransformerWithContext is the same as GetTransformer with the addition of
// the ability to pass a context and additional request options.
//
// See GetTransformer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) GetTransformerWithContext(ctx aws.Context, input *GetTransformerInput, opts ...request.Option) (*GetTransformerOutput, error) {
	req, out := c.GetTransformerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTransformerJob = "GetTransformerJob"

// GetTransformerJobRequest generates a "aws/request.Request" representing the
// client's request for the GetTransformerJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTransformerJob for more information on using the GetTransformerJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTransformerJobRequest method.
//	req, resp := client.GetTransformerJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob
func (c *B2bi) GetTransformerJobRequest(input *GetTransformerJobInput) (req *request.Request, output *GetTransformerJobOutput) {
	op := &request.Operation{
		Name:       opGetTransformerJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTransformerJobInput{}
	}

	output = &GetTransformerJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTransformerJob API operation for AWS B2B Data Interchange.
//
// Returns the details of the transformer run, based on the Transformer job
// ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation GetTransformerJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob
func (c *B2bi) GetTransformerJob(input *GetTransformerJobInput) (*GetTransformerJobOutput, error) {
	req, out := c.GetTransformerJobRequest(input)
	return out, req.Send()
}

// GetTransformerJobWithContext is the same as GetTransformerJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetTransformerJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) GetTransformerJobWithContext(ctx aws.Context, input *GetTransformerJobInput, opts ...request.Option) (*GetTransformerJobOutput, error) {
	req, out := c.GetTransformerJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCapabilities = "ListCapabilities"

// ListCapabilitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListCapabilities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCapabilities for more information on using the ListCapabilities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCapabilitiesRequest method.
//	req, resp := client.ListCapabilitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities
func (c *B2bi) ListCapabilitiesRequest(input *ListCapabilitiesInput) (req *request.Request, output *ListCapabilitiesOutput) {
	op := &request.Operation{
		Name:       opListCapabilities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCapabilitiesInput{}
	}

	output = &ListCapabilitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCapabilities API operation for AWS B2B Data Interchange.
//
// Lists the capabilities associated with your Amazon Web Services account for
// your current or specified region. Capabilities contain the information necessary
// to process incoming EDI (electronic data interchange) documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation ListCapabilities for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities
func (c *B2bi) ListCapabilities(input *ListCapabilitiesInput) (*ListCapabilitiesOutput, error) {
	req, out := c.ListCapabilitiesRequest(input)
	return out, req.Send()
}

// ListCapabilitiesWithContext is the same as ListCapabilities with the addition of
// the ability to pass a context and additional request options.
//
// See ListCapabilities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListCapabilitiesWithContext(ctx aws.Context, input *ListCapabilitiesInput, opts ...request.Option) (*ListCapabilitiesOutput, error) {
	req, out := c.ListCapabilitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCapabilitiesPages iterates over the pages of a ListCapabilities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCapabilities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCapabilities operation.
//	pageNum := 0
//	err := client.ListCapabilitiesPages(params,
//	    func(page *b2bi.ListCapabilitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *B2bi) ListCapabilitiesPages(input *ListCapabilitiesInput, fn func(*ListCapabilitiesOutput, bool) bool) error {
	return c.ListCapabilitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCapabilitiesPagesWithContext same as ListCapabilitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListCapabilitiesPagesWithContext(ctx aws.Context, input *ListCapabilitiesInput, fn func(*ListCapabilitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCapabilitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCapabilitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCapabilitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPartnerships = "ListPartnerships"

// ListPartnershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListPartnerships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPartnerships for more information on using the ListPartnerships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPartnershipsRequest method.
//	req, resp := client.ListPartnershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships
func (c *B2bi) ListPartnershipsRequest(input *ListPartnershipsInput) (req *request.Request, output *ListPartnershipsOutput) {
	op := &request.Operation{
		Name:       opListPartnerships,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPartnershipsInput{}
	}

	output = &ListPartnershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPartnerships API operation for AWS B2B Data Interchange.
//
// Lists the partnerships associated with your Amazon Web Services account for
// your current or specified region. Partnerships link trading partners with
// your profile and a specific transformer, so that the EDI (electronic data
// interchange) documents that they upload to Amazon S3 can be processed according
// to their specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation ListPartnerships for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships
func (c *B2bi) ListPartnerships(input *ListPartnershipsInput) (*ListPartnershipsOutput, error) {
	req, out := c.ListPartnershipsRequest(input)
	return out, req.Send()
}

// ListPartnershipsWithContext is the same as ListPartnerships with the addition of
// the ability to pass a context and additional request options.
//
// See ListPartnerships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListPartnershipsWithContext(ctx aws.Context, input *ListPartnershipsInput, opts ...request.Option) (*ListPartnershipsOutput, error) {
	req, out := c.ListPartnershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPartnershipsPages iterates over the pages of a ListPartnerships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPartnerships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPartnerships operation.
//	pageNum := 0
//	err := client.ListPartnershipsPages(params,
//	    func(page *b2bi.ListPartnershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *B2bi) ListPartnershipsPages(input *ListPartnershipsInput, fn func(*ListPartnershipsOutput, bool) bool) error {
	return c.ListPartnershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPartnershipsPagesWithContext same as ListPartnershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListPartnershipsPagesWithContext(ctx aws.Context, input *ListPartnershipsInput, fn func(*ListPartnershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPartnershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPartnershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPartnershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfiles = "ListProfiles"

// ListProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfiles for more information on using the ListProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfilesRequest method.
//	req, resp := client.ListProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles
func (c *B2bi) ListProfilesRequest(input *ListProfilesInput) (req *request.Request, output *ListProfilesOutput) {
	op := &request.Operation{
		Name:       opListProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfilesInput{}
	}

	output = &ListProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfiles API operation for AWS B2B Data Interchange.
//
// Lists the profiles associated with your Amazon Web Services account for your
// current or specified region. Profiles contain basic information about you
// and your business.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation ListProfiles for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles
func (c *B2bi) ListProfiles(input *ListProfilesInput) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	return out, req.Send()
}

// ListProfilesWithContext is the same as ListProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListProfilesWithContext(ctx aws.Context, input *ListProfilesInput, opts ...request.Option) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfilesPages iterates over the pages of a ListProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfiles operation.
//	pageNum := 0
//	err := client.ListProfilesPages(params,
//	    func(page *b2bi.ListProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *B2bi) ListProfilesPages(input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool) error {
	return c.ListProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfilesPagesWithContext same as ListProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListProfilesPagesWithContext(ctx aws.Context, input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTagsForResource
func (c *B2bi) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS B2B Data Interchange.
//
// Lists all of the tags associated with the Amazon Resource Name (ARN) that
// you specify. The resource can be a capability, partnership, profile, or transformer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTagsForResource
func (c *B2bi) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTransformers = "ListTransformers"

// ListTransformersRequest generates a "aws/request.Request" representing the
// client's request for the ListTransformers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTransformers for more information on using the ListTransformers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTransformersRequest method.
//	req, resp := client.ListTransformersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers
func (c *B2bi) ListTransformersRequest(input *ListTransformersInput) (req *request.Request, output *ListTransformersOutput) {
	op := &request.Operation{
		Name:       opListTransformers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTransformersInput{}
	}

	output = &ListTransformersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTransformers API operation for AWS B2B Data Interchange.
//
// Lists the available transformers. Transformers describe how to process the
// incoming EDI (electronic data interchange) documents, and extract the necessary
// information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation ListTransformers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers
func (c *B2bi) ListTransformers(input *ListTransformersInput) (*ListTransformersOutput, error) {
	req, out := c.ListTransformersRequest(input)
	return out, req.Send()
}

// ListTransformersWithContext is the same as ListTransformers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTransformers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListTransformersWithContext(ctx aws.Context, input *ListTransformersInput, opts ...request.Option) (*ListTransformersOutput, error) {
	req, out := c.ListTransformersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTransformersPages iterates over the pages of a ListTransformers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTransformers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTransformers operation.
//	pageNum := 0
//	err := client.ListTransformersPages(params,
//	    func(page *b2bi.ListTransformersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *B2bi) ListTransformersPages(input *ListTransformersInput, fn func(*ListTransformersOutput, bool) bool) error {
	return c.ListTransformersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTransformersPagesWithContext same as ListTransformersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) ListTransformersPagesWithContext(ctx aws.Context, input *ListTransformersInput, fn func(*ListTransformersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTransformersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTransformersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTransformersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartTransformerJob = "StartTransformerJob"

// StartTransformerJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTransformerJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTransformerJob for more information on using the StartTransformerJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTransformerJobRequest method.
//	req, resp := client.StartTransformerJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/StartTransformerJob
func (c *B2bi) StartTransformerJobRequest(input *StartTransformerJobInput) (req *request.Request, output *StartTransformerJobOutput) {
	op := &request.Operation{
		Name:       opStartTransformerJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTransformerJobInput{}
	}

	output = &StartTransformerJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTransformerJob API operation for AWS B2B Data Interchange.
//
// Runs a job, using a transformer, to parse input EDI (electronic data interchange)
// file into the output structures used by Amazon Web Services B2BI Data Interchange.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation StartTransformerJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/StartTransformerJob
func (c *B2bi) StartTransformerJob(input *StartTransformerJobInput) (*StartTransformerJobOutput, error) {
	req, out := c.StartTransformerJobRequest(input)
	return out, req.Send()
}

// StartTransformerJobWithContext is the same as StartTransformerJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTransformerJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) StartTransformerJobWithContext(ctx aws.Context, input *StartTransformerJobInput, opts ...request.Option) (*StartTransformerJobOutput, error) {
	req, out := c.StartTransformerJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TagResource
func (c *B2bi) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS B2B Data Interchange.
//
// Attaches a key-value pair to a resource, as identified by its Amazon Resource
// Name (ARN). Resources are capability, partnership, profile, transformers
// and other entities.
//
// There is no response returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TagResource
func (c *B2bi) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestMapping = "TestMapping"

// TestMappingRequest generates a "aws/request.Request" representing the
// client's request for the TestMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestMapping for more information on using the TestMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestMappingRequest method.
//	req, resp := client.TestMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestMapping
func (c *B2bi) TestMappingRequest(input *TestMappingInput) (req *request.Request, output *TestMappingOutput) {
	op := &request.Operation{
		Name:       opTestMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestMappingInput{}
	}

	output = &TestMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestMapping API operation for AWS B2B Data Interchange.
//
// Maps the input file according to the provided template file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation TestMapping for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestMapping
func (c *B2bi) TestMapping(input *TestMappingInput) (*TestMappingOutput, error) {
	req, out := c.TestMappingRequest(input)
	return out, req.Send()
}

// TestMappingWithContext is the same as TestMapping with the addition of
// the ability to pass a context and additional request options.
//
// See TestMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) TestMappingWithContext(ctx aws.Context, input *TestMappingInput, opts ...request.Option) (*TestMappingOutput, error) {
	req, out := c.TestMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestParsing = "TestParsing"

// TestParsingRequest generates a "aws/request.Request" representing the
// client's request for the TestParsing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestParsing for more information on using the TestParsing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestParsingRequest method.
//	req, resp := client.TestParsingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestParsing
func (c *B2bi) TestParsingRequest(input *TestParsingInput) (req *request.Request, output *TestParsingOutput) {
	op := &request.Operation{
		Name:       opTestParsing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestParsingInput{}
	}

	output = &TestParsingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestParsing API operation for AWS B2B Data Interchange.
//
// Parses the input EDI (electronic data interchange) file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation TestParsing for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestParsing
func (c *B2bi) TestParsing(input *TestParsingInput) (*TestParsingOutput, error) {
	req, out := c.TestParsingRequest(input)
	return out, req.Send()
}

// TestParsingWithContext is the same as TestParsing with the addition of
// the ability to pass a context and additional request options.
//
// See TestParsing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) TestParsingWithContext(ctx aws.Context, input *TestParsingInput, opts ...request.Option) (*TestParsingOutput, error) {
	req, out := c.TestParsingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UntagResource
func (c *B2bi) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS B2B Data Interchange.
//
// Detaches a key-value pair from the specified resource, as identified by its
// Amazon Resource Name (ARN). Resources are capability, partnership, profile,
// transformers and other entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UntagResource
func (c *B2bi) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCapability = "UpdateCapability"

// UpdateCapabilityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCapability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCapability for more information on using the UpdateCapability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCapabilityRequest method.
//	req, resp := client.UpdateCapabilityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateCapability
func (c *B2bi) UpdateCapabilityRequest(input *UpdateCapabilityInput) (req *request.Request, output *UpdateCapabilityOutput) {
	op := &request.Operation{
		Name:       opUpdateCapability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCapabilityInput{}
	}

	output = &UpdateCapabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCapability API operation for AWS B2B Data Interchange.
//
// Updates some of the parameters for a capability, based on the specified parameters.
// Capabilities contain the information necessary to process incoming EDI (electronic
// data interchange) documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation UpdateCapability for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateCapability
func (c *B2bi) UpdateCapability(input *UpdateCapabilityInput) (*UpdateCapabilityOutput, error) {
	req, out := c.UpdateCapabilityRequest(input)
	return out, req.Send()
}

// UpdateCapabilityWithContext is the same as UpdateCapability with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCapability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) UpdateCapabilityWithContext(ctx aws.Context, input *UpdateCapabilityInput, opts ...request.Option) (*UpdateCapabilityOutput, error) {
	req, out := c.UpdateCapabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePartnership = "UpdatePartnership"

// UpdatePartnershipRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePartnership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePartnership for more information on using the UpdatePartnership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePartnershipRequest method.
//	req, resp := client.UpdatePartnershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdatePartnership
func (c *B2bi) UpdatePartnershipRequest(input *UpdatePartnershipInput) (req *request.Request, output *UpdatePartnershipOutput) {
	op := &request.Operation{
		Name:       opUpdatePartnership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePartnershipInput{}
	}

	output = &UpdatePartnershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePartnership API operation for AWS B2B Data Interchange.
//
// Updates some of the parameters for a partnership between a customer and trading
// partner. Partnerships link trading partners with your profile and a specific
// transformer, so that the EDI (electronic data interchange) documents that
// they upload to Amazon S3 can be processed according to their specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation UpdatePartnership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdatePartnership
func (c *B2bi) UpdatePartnership(input *UpdatePartnershipInput) (*UpdatePartnershipOutput, error) {
	req, out := c.UpdatePartnershipRequest(input)
	return out, req.Send()
}

// UpdatePartnershipWithContext is the same as UpdatePartnership with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePartnership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) UpdatePartnershipWithContext(ctx aws.Context, input *UpdatePartnershipInput, opts ...request.Option) (*UpdatePartnershipOutput, error) {
	req, out := c.UpdatePartnershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProfileRequest method.
//	req, resp := client.UpdateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateProfile
func (c *B2bi) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfile API operation for AWS B2B Data Interchange.
//
// Updates the specified parameters for a profile. Profiles contain basic information
// about you and your business.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateProfile
func (c *B2bi) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTransformer = "UpdateTransformer"

// UpdateTransformerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTransformer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTransformer for more information on using the UpdateTransformer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTransformerRequest method.
//	req, resp := client.UpdateTransformerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateTransformer
func (c *B2bi) UpdateTransformerRequest(input *UpdateTransformerInput) (req *request.Request, output *UpdateTransformerOutput) {
	op := &request.Operation{
		Name:       opUpdateTransformer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTransformerInput{}
	}

	output = &UpdateTransformerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTransformer API operation for AWS B2B Data Interchange.
//
// Updates the specified parameters for a transformer. Transformers describe
// how to process the incoming EDI (electronic data interchange) documents,
// and extract the necessary information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS B2B Data Interchange's
// API operation UpdateTransformer for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict exception is thrown when you attempt to delete a resource (such
//     as a profile or a capability) that is being used by other resources.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     Occurs when a B2BI object cannot be validated against a request from another
//     object.
//
//   - ThrottlingException
//     The request was denied due to throttling: the data speed and rendering may
//     be limited depending on various parameters and conditions.
//
//   - ResourceNotFoundException
//     Occurs when the requested resource does not exist, or cannot be found. In
//     some cases, the resource exists in a region other than the region specified
//     in the API call.
//
//   - ServiceQuotaExceededException
//     Occurs when the calling command attempts to exceed one of the service quotas,
//     for example trying to create a capability when you already have the maximum
//     number of capabilities allowed.
//
//   - InternalServerException
//     This exception is thrown when an error occurs in the Amazon Web Services
//     B2B Data Interchange service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateTransformer
func (c *B2bi) UpdateTransformer(input *UpdateTransformerInput) (*UpdateTransformerOutput, error) {
	req, out := c.UpdateTransformerRequest(input)
	return out, req.Send()
}

// UpdateTransformerWithContext is the same as UpdateTransformer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTransformer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *B2bi) UpdateTransformerWithContext(ctx aws.Context, input *UpdateTransformerInput, opts ...request.Option) (*UpdateTransformerOutput, error) {
	req, out := c.UpdateTransformerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A capability object. Currently, only EDI (electronic data interchange) capabilities
// are supported. Capabilities contain the information necessary to process
// incoming EDI (electronic data interchange) documents.
type CapabilityConfiguration struct {
	_ struct{} `type:"structure"`

	// An EDI (electronic data interchange) configuration object.
	Edi *EdiConfiguration `locationName:"edi" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapabilityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapabilityConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapabilityConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapabilityConfiguration"}
	if s.Edi != nil {
		if err := s.Edi.Validate(); err != nil {
			invalidParams.AddNested("Edi", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEdi sets the Edi field's value.
func (s *CapabilityConfiguration) SetEdi(v *EdiConfiguration) *CapabilityConfiguration {
	s.Edi = v
	return s
}

// Returns the capability summary details. Capabilities contain the information
// necessary to process incoming EDI (electronic data interchange) documents.
type CapabilitySummary struct {
	_ struct{} `type:"structure"`

	// Returns a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`

	// Returns a timestamp for creation date and time of the capability.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns a timestamp that identifies the most recent date and time that the
	// capability was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The display name of the capability.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CapabilityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapabilitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapabilitySummary) GoString() string {
	return s.String()
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *CapabilitySummary) SetCapabilityId(v string) *CapabilitySummary {
	s.CapabilityId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CapabilitySummary) SetCreatedAt(v time.Time) *CapabilitySummary {
	s.CreatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CapabilitySummary) SetModifiedAt(v time.Time) *CapabilitySummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CapabilitySummary) SetName(v string) *CapabilitySummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CapabilitySummary) SetType(v string) *CapabilitySummary {
	s.Type = &v
	return s
}

// A conflict exception is thrown when you attempt to delete a resource (such
// as a profile or a capability) that is being used by other resources.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCapabilityInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies a structure that contains the details for a capability.
	//
	// Configuration is a required field
	Configuration *CapabilityConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// Specifies one or more locations in Amazon S3, each specifying an EDI document
	// that can be used with this capability. Each item contains the name of the
	// bucket and the key, to identify the document's location.
	InstructionsDocuments []*S3Location `locationName:"instructionsDocuments" type:"list"`

	// Specifies the name of the capability, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the key-value pairs assigned to ARNs that you can use to group
	// and search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	Tags []*Tag `locationName:"tags" type:"list"`

	// Specifies the type of the capability. Currently, only edi is supported.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CapabilityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCapabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCapabilityInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.InstructionsDocuments != nil {
		for i, v := range s.InstructionsDocuments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstructionsDocuments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCapabilityInput) SetClientToken(v string) *CreateCapabilityInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateCapabilityInput) SetConfiguration(v *CapabilityConfiguration) *CreateCapabilityInput {
	s.Configuration = v
	return s
}

// SetInstructionsDocuments sets the InstructionsDocuments field's value.
func (s *CreateCapabilityInput) SetInstructionsDocuments(v []*S3Location) *CreateCapabilityInput {
	s.InstructionsDocuments = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCapabilityInput) SetName(v string) *CreateCapabilityInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCapabilityInput) SetTags(v []*Tag) *CreateCapabilityInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCapabilityInput) SetType(v string) *CreateCapabilityInput {
	s.Type = &v
	return s
}

type CreateCapabilityOutput struct {
	_ struct{} `type:"structure"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// CapabilityArn is a required field
	CapabilityArn *string `locationName:"capabilityArn" min:"1" type:"string" required:"true"`

	// Returns a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`

	// Returns a structure that contains the details for a capability.
	//
	// Configuration is a required field
	Configuration *CapabilityConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// Returns a timestamp for creation date and time of the capability.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns one or more locations in Amazon S3, each specifying an EDI document
	// that can be used with this capability. Each item contains the name of the
	// bucket and the key, to identify the document's location.
	InstructionsDocuments []*S3Location `locationName:"instructionsDocuments" type:"list"`

	// Returns the name of the capability used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CapabilityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCapabilityOutput) GoString() string {
	return s.String()
}

// SetCapabilityArn sets the CapabilityArn field's value.
func (s *CreateCapabilityOutput) SetCapabilityArn(v string) *CreateCapabilityOutput {
	s.CapabilityArn = &v
	return s
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *CreateCapabilityOutput) SetCapabilityId(v string) *CreateCapabilityOutput {
	s.CapabilityId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateCapabilityOutput) SetConfiguration(v *CapabilityConfiguration) *CreateCapabilityOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateCapabilityOutput) SetCreatedAt(v time.Time) *CreateCapabilityOutput {
	s.CreatedAt = &v
	return s
}

// SetInstructionsDocuments sets the InstructionsDocuments field's value.
func (s *CreateCapabilityOutput) SetInstructionsDocuments(v []*S3Location) *CreateCapabilityOutput {
	s.InstructionsDocuments = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCapabilityOutput) SetName(v string) *CreateCapabilityOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCapabilityOutput) SetType(v string) *CreateCapabilityOutput {
	s.Type = &v
	return s
}

type CreatePartnershipInput struct {
	_ struct{} `type:"structure"`

	// Specifies a list of the capabilities associated with this partnership.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// Reserved for future use.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies the email address associated with this trading partner.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePartnershipInput's
	// String and GoString methods.
	//
	// Email is a required field
	Email *string `locationName:"email" min:"5" type:"string" required:"true" sensitive:"true"`

	// Specifies a descriptive name for the partnership.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the phone number associated with the partnership.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePartnershipInput's
	// String and GoString methods.
	Phone *string `locationName:"phone" min:"7" type:"string" sensitive:"true"`

	// Specifies the unique, system-generated identifier for the profile connected
	// to this partnership.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`

	// Specifies the key-value pairs assigned to ARNs that you can use to group
	// and search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartnershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePartnershipInput"}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 5))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Phone != nil && len(*s.Phone) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Phone", 7))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreatePartnershipInput) SetCapabilities(v []*string) *CreatePartnershipInput {
	s.Capabilities = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePartnershipInput) SetClientToken(v string) *CreatePartnershipInput {
	s.ClientToken = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreatePartnershipInput) SetEmail(v string) *CreatePartnershipInput {
	s.Email = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePartnershipInput) SetName(v string) *CreatePartnershipInput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *CreatePartnershipInput) SetPhone(v string) *CreatePartnershipInput {
	s.Phone = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *CreatePartnershipInput) SetProfileId(v string) *CreatePartnershipInput {
	s.ProfileId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePartnershipInput) SetTags(v []*Tag) *CreatePartnershipInput {
	s.Tags = v
	return s
}

type CreatePartnershipOutput struct {
	_ struct{} `type:"structure"`

	// Returns one or more capabilities associated with this partnership.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// Returns a timestamp for creation date and time of the partnership.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the email address associated with this trading partner.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePartnershipOutput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Returns a descriptive name for the partnership.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// PartnershipArn is a required field
	PartnershipArn *string `locationName:"partnershipArn" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`

	// Returns the phone number associated with the partnership.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePartnershipOutput's
	// String and GoString methods.
	Phone *string `locationName:"phone" min:"7" type:"string" sensitive:"true"`

	// Returns the unique, system-generated identifier for the profile connected
	// to this partnership.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for a trading partner.
	TradingPartnerId *string `locationName:"tradingPartnerId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnershipOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreatePartnershipOutput) SetCapabilities(v []*string) *CreatePartnershipOutput {
	s.Capabilities = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreatePartnershipOutput) SetCreatedAt(v time.Time) *CreatePartnershipOutput {
	s.CreatedAt = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreatePartnershipOutput) SetEmail(v string) *CreatePartnershipOutput {
	s.Email = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePartnershipOutput) SetName(v string) *CreatePartnershipOutput {
	s.Name = &v
	return s
}

// SetPartnershipArn sets the PartnershipArn field's value.
func (s *CreatePartnershipOutput) SetPartnershipArn(v string) *CreatePartnershipOutput {
	s.PartnershipArn = &v
	return s
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *CreatePartnershipOutput) SetPartnershipId(v string) *CreatePartnershipOutput {
	s.PartnershipId = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *CreatePartnershipOutput) SetPhone(v string) *CreatePartnershipOutput {
	s.Phone = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *CreatePartnershipOutput) SetProfileId(v string) *CreatePartnershipOutput {
	s.ProfileId = &v
	return s
}

// SetTradingPartnerId sets the TradingPartnerId field's value.
func (s *CreatePartnershipOutput) SetTradingPartnerId(v string) *CreatePartnershipOutput {
	s.TradingPartnerId = &v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name for the business associated with this profile.
	//
	// BusinessName is a required field
	BusinessName *string `locationName:"businessName" min:"1" type:"string" required:"true"`

	// Reserved for future use.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies the email address associated with this customer profile.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProfileInput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Specifies whether or not logging is enabled for this profile.
	//
	// Logging is a required field
	Logging *string `locationName:"logging" type:"string" required:"true" enum:"Logging"`

	// Specifies the name of the profile.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the phone number associated with the profile.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProfileInput's
	// String and GoString methods.
	//
	// Phone is a required field
	Phone *string `locationName:"phone" min:"7" type:"string" required:"true" sensitive:"true"`

	// Specifies the key-value pairs assigned to ARNs that you can use to group
	// and search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.BusinessName == nil {
		invalidParams.Add(request.NewErrParamRequired("BusinessName"))
	}
	if s.BusinessName != nil && len(*s.BusinessName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessName", 1))
	}
	if s.Email != nil && len(*s.Email) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 5))
	}
	if s.Logging == nil {
		invalidParams.Add(request.NewErrParamRequired("Logging"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Phone == nil {
		invalidParams.Add(request.NewErrParamRequired("Phone"))
	}
	if s.Phone != nil && len(*s.Phone) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Phone", 7))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBusinessName sets the BusinessName field's value.
func (s *CreateProfileInput) SetBusinessName(v string) *CreateProfileInput {
	s.BusinessName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProfileInput) SetClientToken(v string) *CreateProfileInput {
	s.ClientToken = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateProfileInput) SetEmail(v string) *CreateProfileInput {
	s.Email = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *CreateProfileInput) SetLogging(v string) *CreateProfileInput {
	s.Logging = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProfileInput) SetName(v string) *CreateProfileInput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *CreateProfileInput) SetPhone(v string) *CreateProfileInput {
	s.Phone = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProfileInput) SetTags(v []*Tag) *CreateProfileInput {
	s.Tags = v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// Returns the name for the business associated with this profile.
	//
	// BusinessName is a required field
	BusinessName *string `locationName:"businessName" min:"1" type:"string" required:"true"`

	// Returns a timestamp representing the time the profile was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the email address associated with this customer profile.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProfileOutput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Returns the name of the logging group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// Returns whether or not logging is turned on for this profile.
	Logging *string `locationName:"logging" type:"string" enum:"Logging"`

	// Returns the name of the profile, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the phone number associated with the profile.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProfileOutput's
	// String and GoString methods.
	//
	// Phone is a required field
	Phone *string `locationName:"phone" min:"7" type:"string" required:"true" sensitive:"true"`

	// Returns an Amazon Resource Name (ARN) for the profile.
	//
	// ProfileArn is a required field
	ProfileArn *string `locationName:"profileArn" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetBusinessName sets the BusinessName field's value.
func (s *CreateProfileOutput) SetBusinessName(v string) *CreateProfileOutput {
	s.BusinessName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateProfileOutput) SetCreatedAt(v time.Time) *CreateProfileOutput {
	s.CreatedAt = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateProfileOutput) SetEmail(v string) *CreateProfileOutput {
	s.Email = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CreateProfileOutput) SetLogGroupName(v string) *CreateProfileOutput {
	s.LogGroupName = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *CreateProfileOutput) SetLogging(v string) *CreateProfileOutput {
	s.Logging = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProfileOutput) SetName(v string) *CreateProfileOutput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *CreateProfileOutput) SetPhone(v string) *CreateProfileOutput {
	s.Phone = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateProfileOutput) SetProfileArn(v string) *CreateProfileOutput {
	s.ProfileArn = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *CreateProfileOutput) SetProfileId(v string) *CreateProfileOutput {
	s.ProfileId = &v
	return s
}

type CreateTransformerInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	//
	// EdiType is a required field
	EdiType *EdiType `locationName:"ediType" type:"structure" required:"true"`

	// Specifies that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Specifies the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	//
	// MappingTemplate is a required field
	MappingTemplate *string `locationName:"mappingTemplate" type:"string" required:"true"`

	// Specifies the name of the transformer, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies a sample EDI document that is used by a transformer as a guide
	// for processing the EDI data.
	SampleDocument *string `locationName:"sampleDocument" type:"string"`

	// Specifies the key-value pairs assigned to ARNs that you can use to group
	// and search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTransformerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTransformerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransformerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTransformerInput"}
	if s.EdiType == nil {
		invalidParams.Add(request.NewErrParamRequired("EdiType"))
	}
	if s.FileFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("FileFormat"))
	}
	if s.MappingTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("MappingTemplate"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTransformerInput) SetClientToken(v string) *CreateTransformerInput {
	s.ClientToken = &v
	return s
}

// SetEdiType sets the EdiType field's value.
func (s *CreateTransformerInput) SetEdiType(v *EdiType) *CreateTransformerInput {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateTransformerInput) SetFileFormat(v string) *CreateTransformerInput {
	s.FileFormat = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *CreateTransformerInput) SetMappingTemplate(v string) *CreateTransformerInput {
	s.MappingTemplate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTransformerInput) SetName(v string) *CreateTransformerInput {
	s.Name = &v
	return s
}

// SetSampleDocument sets the SampleDocument field's value.
func (s *CreateTransformerInput) SetSampleDocument(v string) *CreateTransformerInput {
	s.SampleDocument = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTransformerInput) SetTags(v []*Tag) *CreateTransformerInput {
	s.Tags = v
	return s
}

type CreateTransformerOutput struct {
	_ struct{} `type:"structure"`

	// Returns a timestamp for creation date and time of the transformer.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	//
	// EdiType is a required field
	EdiType *EdiType `locationName:"ediType" type:"structure" required:"true"`

	// Returns that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Returns the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	//
	// MappingTemplate is a required field
	MappingTemplate *string `locationName:"mappingTemplate" type:"string" required:"true"`

	// Returns the name of the transformer, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns a sample EDI document that is used by a transformer as a guide for
	// processing the EDI data.
	SampleDocument *string `locationName:"sampleDocument" type:"string"`

	// Returns the state of the newly created transformer. The transformer can be
	// either active or inactive. For the transformer to be used in a capability,
	// its status must active.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TransformerStatus"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// TransformerArn is a required field
	TransformerArn *string `locationName:"transformerArn" min:"1" type:"string" required:"true"`

	// Returns the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTransformerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTransformerOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateTransformerOutput) SetCreatedAt(v time.Time) *CreateTransformerOutput {
	s.CreatedAt = &v
	return s
}

// SetEdiType sets the EdiType field's value.
func (s *CreateTransformerOutput) SetEdiType(v *EdiType) *CreateTransformerOutput {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateTransformerOutput) SetFileFormat(v string) *CreateTransformerOutput {
	s.FileFormat = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *CreateTransformerOutput) SetMappingTemplate(v string) *CreateTransformerOutput {
	s.MappingTemplate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTransformerOutput) SetName(v string) *CreateTransformerOutput {
	s.Name = &v
	return s
}

// SetSampleDocument sets the SampleDocument field's value.
func (s *CreateTransformerOutput) SetSampleDocument(v string) *CreateTransformerOutput {
	s.SampleDocument = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTransformerOutput) SetStatus(v string) *CreateTransformerOutput {
	s.Status = &v
	return s
}

// SetTransformerArn sets the TransformerArn field's value.
func (s *CreateTransformerOutput) SetTransformerArn(v string) *CreateTransformerOutput {
	s.TransformerArn = &v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *CreateTransformerOutput) SetTransformerId(v string) *CreateTransformerOutput {
	s.TransformerId = &v
	return s
}

type DeleteCapabilityInput struct {
	_ struct{} `type:"structure"`

	// Specifies a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCapabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCapabilityInput"}
	if s.CapabilityId == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityId"))
	}
	if s.CapabilityId != nil && len(*s.CapabilityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *DeleteCapabilityInput) SetCapabilityId(v string) *DeleteCapabilityInput {
	s.CapabilityId = &v
	return s
}

type DeleteCapabilityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCapabilityOutput) GoString() string {
	return s.String()
}

type DeletePartnershipInput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePartnershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePartnershipInput"}
	if s.PartnershipId == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnershipId"))
	}
	if s.PartnershipId != nil && len(*s.PartnershipId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartnershipId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *DeletePartnershipInput) SetPartnershipId(v string) *DeletePartnershipInput {
	s.PartnershipId = &v
	return s
}

type DeletePartnershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnershipOutput) GoString() string {
	return s.String()
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileInput) SetProfileId(v string) *DeleteProfileInput {
	s.ProfileId = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

type DeleteTransformerInput struct {
	_ struct{} `type:"structure"`

	// Specifies the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTransformerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTransformerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTransformerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTransformerInput"}
	if s.TransformerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerId"))
	}
	if s.TransformerId != nil && len(*s.TransformerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransformerId sets the TransformerId field's value.
func (s *DeleteTransformerInput) SetTransformerId(v string) *DeleteTransformerInput {
	s.TransformerId = &v
	return s
}

type DeleteTransformerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTransformerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTransformerOutput) GoString() string {
	return s.String()
}

// Specifies the details for the EDI (electronic data interchange) transformation.
type EdiConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains the Amazon S3 bucket and prefix for the location of the input file,
	// which is contained in an S3Location object.
	//
	// InputLocation is a required field
	InputLocation *S3Location `locationName:"inputLocation" type:"structure" required:"true"`

	// Contains the Amazon S3 bucket and prefix for the location of the output file,
	// which is contained in an S3Location object.
	//
	// OutputLocation is a required field
	OutputLocation *S3Location `locationName:"outputLocation" type:"structure" required:"true"`

	// Returns the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// Type is a required field
	Type *EdiType `locationName:"type" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdiConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdiConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EdiConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EdiConfiguration"}
	if s.InputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("InputLocation"))
	}
	if s.OutputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputLocation"))
	}
	if s.TransformerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerId"))
	}
	if s.TransformerId != nil && len(*s.TransformerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.InputLocation != nil {
		if err := s.InputLocation.Validate(); err != nil {
			invalidParams.AddNested("InputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputLocation sets the InputLocation field's value.
func (s *EdiConfiguration) SetInputLocation(v *S3Location) *EdiConfiguration {
	s.InputLocation = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *EdiConfiguration) SetOutputLocation(v *S3Location) *EdiConfiguration {
	s.OutputLocation = v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *EdiConfiguration) SetTransformerId(v string) *EdiConfiguration {
	s.TransformerId = &v
	return s
}

// SetType sets the Type field's value.
func (s *EdiConfiguration) SetType(v *EdiType) *EdiConfiguration {
	s.Type = v
	return s
}

// Specifies the details for the EDI standard that is being used for the transformer.
// Currently, only X12 is supported. X12 is a set of standards and corresponding
// messages that define specific business documents.
type EdiType struct {
	_ struct{} `type:"structure"`

	// Returns the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	X12Details *X12Details `locationName:"x12Details" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdiType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdiType) GoString() string {
	return s.String()
}

// SetX12Details sets the X12Details field's value.
func (s *EdiType) SetX12Details(v *X12Details) *EdiType {
	s.X12Details = v
	return s
}

type GetCapabilityInput struct {
	_ struct{} `type:"structure"`

	// Specifies a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCapabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCapabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCapabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCapabilityInput"}
	if s.CapabilityId == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityId"))
	}
	if s.CapabilityId != nil && len(*s.CapabilityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *GetCapabilityInput) SetCapabilityId(v string) *GetCapabilityInput {
	s.CapabilityId = &v
	return s
}

type GetCapabilityOutput struct {
	_ struct{} `type:"structure"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// CapabilityArn is a required field
	CapabilityArn *string `locationName:"capabilityArn" min:"1" type:"string" required:"true"`

	// Returns a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`

	// Returns a structure that contains the details for a capability.
	//
	// Configuration is a required field
	Configuration *CapabilityConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// Returns a timestamp for creation date and time of the capability.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns one or more locations in Amazon S3, each specifying an EDI document
	// that can be used with this capability. Each item contains the name of the
	// bucket and the key, to identify the document's location.
	InstructionsDocuments []*S3Location `locationName:"instructionsDocuments" type:"list"`

	// Returns a timestamp for last time the capability was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the name of the capability, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CapabilityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCapabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCapabilityOutput) GoString() string {
	return s.String()
}

// SetCapabilityArn sets the CapabilityArn field's value.
func (s *GetCapabilityOutput) SetCapabilityArn(v string) *GetCapabilityOutput {
	s.CapabilityArn = &v
	return s
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *GetCapabilityOutput) SetCapabilityId(v string) *GetCapabilityOutput {
	s.CapabilityId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetCapabilityOutput) SetConfiguration(v *CapabilityConfiguration) *GetCapabilityOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetCapabilityOutput) SetCreatedAt(v time.Time) *GetCapabilityOutput {
	s.CreatedAt = &v
	return s
}

// SetInstructionsDocuments sets the InstructionsDocuments field's value.
func (s *GetCapabilityOutput) SetInstructionsDocuments(v []*S3Location) *GetCapabilityOutput {
	s.InstructionsDocuments = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetCapabilityOutput) SetModifiedAt(v time.Time) *GetCapabilityOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCapabilityOutput) SetName(v string) *GetCapabilityOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetCapabilityOutput) SetType(v string) *GetCapabilityOutput {
	s.Type = &v
	return s
}

type GetPartnershipInput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPartnershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPartnershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPartnershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPartnershipInput"}
	if s.PartnershipId == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnershipId"))
	}
	if s.PartnershipId != nil && len(*s.PartnershipId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartnershipId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *GetPartnershipInput) SetPartnershipId(v string) *GetPartnershipInput {
	s.PartnershipId = &v
	return s
}

type GetPartnershipOutput struct {
	_ struct{} `type:"structure"`

	// Returns one or more capabilities associated with this partnership.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// Returns a timestamp for creation date and time of the partnership.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the email address associated with this trading partner.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPartnershipOutput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the display name of the partnership
	Name *string `locationName:"name" min:"1" type:"string"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// PartnershipArn is a required field
	PartnershipArn *string `locationName:"partnershipArn" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`

	// Returns the phone number associated with the partnership.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPartnershipOutput's
	// String and GoString methods.
	Phone *string `locationName:"phone" min:"7" type:"string" sensitive:"true"`

	// Returns the unique, system-generated identifier for the profile connected
	// to this partnership.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`

	// Returns the unique identifier for the partner for this partnership.
	TradingPartnerId *string `locationName:"tradingPartnerId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPartnershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPartnershipOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *GetPartnershipOutput) SetCapabilities(v []*string) *GetPartnershipOutput {
	s.Capabilities = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetPartnershipOutput) SetCreatedAt(v time.Time) *GetPartnershipOutput {
	s.CreatedAt = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *GetPartnershipOutput) SetEmail(v string) *GetPartnershipOutput {
	s.Email = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetPartnershipOutput) SetModifiedAt(v time.Time) *GetPartnershipOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetPartnershipOutput) SetName(v string) *GetPartnershipOutput {
	s.Name = &v
	return s
}

// SetPartnershipArn sets the PartnershipArn field's value.
func (s *GetPartnershipOutput) SetPartnershipArn(v string) *GetPartnershipOutput {
	s.PartnershipArn = &v
	return s
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *GetPartnershipOutput) SetPartnershipId(v string) *GetPartnershipOutput {
	s.PartnershipId = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *GetPartnershipOutput) SetPhone(v string) *GetPartnershipOutput {
	s.Phone = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *GetPartnershipOutput) SetProfileId(v string) *GetPartnershipOutput {
	s.ProfileId = &v
	return s
}

// SetTradingPartnerId sets the TradingPartnerId field's value.
func (s *GetPartnershipOutput) SetTradingPartnerId(v string) *GetPartnershipOutput {
	s.TradingPartnerId = &v
	return s
}

type GetProfileInput struct {
	_ struct{} `type:"structure"`

	// Specifies the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *GetProfileInput) SetProfileId(v string) *GetProfileInput {
	s.ProfileId = &v
	return s
}

type GetProfileOutput struct {
	_ struct{} `type:"structure"`

	// Returns the name for the business associated with this profile.
	//
	// BusinessName is a required field
	BusinessName *string `locationName:"businessName" min:"1" type:"string" required:"true"`

	// Returns a timestamp for creation date and time of the transformer.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the email address associated with this customer profile.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetProfileOutput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Returns the name of the logging group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// Returns whether or not logging is enabled for this profile.
	Logging *string `locationName:"logging" type:"string" enum:"Logging"`

	// Returns a timestamp for last time the profile was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the name of the profile, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the phone number associated with the profile.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetProfileOutput's
	// String and GoString methods.
	//
	// Phone is a required field
	Phone *string `locationName:"phone" min:"7" type:"string" required:"true" sensitive:"true"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// ProfileArn is a required field
	ProfileArn *string `locationName:"profileArn" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetBusinessName sets the BusinessName field's value.
func (s *GetProfileOutput) SetBusinessName(v string) *GetProfileOutput {
	s.BusinessName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetProfileOutput) SetCreatedAt(v time.Time) *GetProfileOutput {
	s.CreatedAt = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *GetProfileOutput) SetEmail(v string) *GetProfileOutput {
	s.Email = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *GetProfileOutput) SetLogGroupName(v string) *GetProfileOutput {
	s.LogGroupName = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *GetProfileOutput) SetLogging(v string) *GetProfileOutput {
	s.Logging = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetProfileOutput) SetModifiedAt(v time.Time) *GetProfileOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetProfileOutput) SetName(v string) *GetProfileOutput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *GetProfileOutput) SetPhone(v string) *GetProfileOutput {
	s.Phone = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *GetProfileOutput) SetProfileArn(v string) *GetProfileOutput {
	s.ProfileArn = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *GetProfileOutput) SetProfileId(v string) *GetProfileOutput {
	s.ProfileId = &v
	return s
}

type GetTransformerInput struct {
	_ struct{} `type:"structure"`

	// Specifies the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTransformerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTransformerInput"}
	if s.TransformerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerId"))
	}
	if s.TransformerId != nil && len(*s.TransformerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransformerId sets the TransformerId field's value.
func (s *GetTransformerInput) SetTransformerId(v string) *GetTransformerInput {
	s.TransformerId = &v
	return s
}

type GetTransformerJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`

	// Specifies the unique, system-generated identifier for a transformer run.
	//
	// TransformerJobId is a required field
	TransformerJobId *string `locationName:"transformerJobId" min:"25" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTransformerJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTransformerJobInput"}
	if s.TransformerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerId"))
	}
	if s.TransformerId != nil && len(*s.TransformerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerId", 1))
	}
	if s.TransformerJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerJobId"))
	}
	if s.TransformerJobId != nil && len(*s.TransformerJobId) < 25 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerJobId", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransformerId sets the TransformerId field's value.
func (s *GetTransformerJobInput) SetTransformerId(v string) *GetTransformerJobInput {
	s.TransformerId = &v
	return s
}

// SetTransformerJobId sets the TransformerJobId field's value.
func (s *GetTransformerJobInput) SetTransformerJobId(v string) *GetTransformerJobInput {
	s.TransformerJobId = &v
	return s
}

type GetTransformerJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns an optional error message, which gets populated when the job is not
	// run successfully.
	Message *string `locationName:"message" type:"string"`

	// Returns the location for the output files. If the caller specified a directory
	// for the output, then this contains the full path to the output file, including
	// the file name generated by the service.
	OutputFiles []*S3Location `locationName:"outputFiles" type:"list"`

	// Returns the current state of the transformer job, either running, succeeded,
	// or failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TransformerJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerJobOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *GetTransformerJobOutput) SetMessage(v string) *GetTransformerJobOutput {
	s.Message = &v
	return s
}

// SetOutputFiles sets the OutputFiles field's value.
func (s *GetTransformerJobOutput) SetOutputFiles(v []*S3Location) *GetTransformerJobOutput {
	s.OutputFiles = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTransformerJobOutput) SetStatus(v string) *GetTransformerJobOutput {
	s.Status = &v
	return s
}

type GetTransformerOutput struct {
	_ struct{} `type:"structure"`

	// Returns a timestamp for creation date and time of the transformer.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	//
	// EdiType is a required field
	EdiType *EdiType `locationName:"ediType" type:"structure" required:"true"`

	// Returns that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Returns the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	//
	// MappingTemplate is a required field
	MappingTemplate *string `locationName:"mappingTemplate" type:"string" required:"true"`

	// Returns a timestamp for last time the transformer was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the name of the transformer, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns a sample EDI document that is used by a transformer as a guide for
	// processing the EDI data.
	SampleDocument *string `locationName:"sampleDocument" type:"string"`

	// Returns the state of the newly created transformer. The transformer can be
	// either active or inactive. For the transformer to be used in a capability,
	// its status must active.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TransformerStatus"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// TransformerArn is a required field
	TransformerArn *string `locationName:"transformerArn" min:"1" type:"string" required:"true"`

	// Returns the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransformerOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetTransformerOutput) SetCreatedAt(v time.Time) *GetTransformerOutput {
	s.CreatedAt = &v
	return s
}

// SetEdiType sets the EdiType field's value.
func (s *GetTransformerOutput) SetEdiType(v *EdiType) *GetTransformerOutput {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *GetTransformerOutput) SetFileFormat(v string) *GetTransformerOutput {
	s.FileFormat = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *GetTransformerOutput) SetMappingTemplate(v string) *GetTransformerOutput {
	s.MappingTemplate = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetTransformerOutput) SetModifiedAt(v time.Time) *GetTransformerOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetTransformerOutput) SetName(v string) *GetTransformerOutput {
	s.Name = &v
	return s
}

// SetSampleDocument sets the SampleDocument field's value.
func (s *GetTransformerOutput) SetSampleDocument(v string) *GetTransformerOutput {
	s.SampleDocument = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTransformerOutput) SetStatus(v string) *GetTransformerOutput {
	s.Status = &v
	return s
}

// SetTransformerArn sets the TransformerArn field's value.
func (s *GetTransformerOutput) SetTransformerArn(v string) *GetTransformerOutput {
	s.TransformerArn = &v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *GetTransformerOutput) SetTransformerId(v string) *GetTransformerOutput {
	s.TransformerId = &v
	return s
}

// This exception is thrown when an error occurs in the Amazon Web Services
// B2B Data Interchange service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"10" type:"string"`

	// The server attempts to retry a failed command.
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCapabilitiesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of capabilities to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCapabilitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCapabilitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCapabilitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCapabilitiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCapabilitiesInput) SetMaxResults(v int64) *ListCapabilitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCapabilitiesInput) SetNextToken(v string) *ListCapabilitiesInput {
	s.NextToken = &v
	return s
}

type ListCapabilitiesOutput struct {
	_ struct{} `type:"structure"`

	// Returns one or more capabilities associated with this partnership.
	//
	// Capabilities is a required field
	Capabilities []*CapabilitySummary `locationName:"capabilities" type:"list" required:"true"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCapabilitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCapabilitiesOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *ListCapabilitiesOutput) SetCapabilities(v []*CapabilitySummary) *ListCapabilitiesOutput {
	s.Capabilities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCapabilitiesOutput) SetNextToken(v string) *ListCapabilitiesOutput {
	s.NextToken = &v
	return s
}

type ListPartnershipsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of capabilities to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies the unique, system-generated identifier for the profile connected
	// to this partnership.
	ProfileId *string `locationName:"profileId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartnershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartnershipsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPartnershipsInput) SetMaxResults(v int64) *ListPartnershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnershipsInput) SetNextToken(v string) *ListPartnershipsInput {
	s.NextToken = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ListPartnershipsInput) SetProfileId(v string) *ListPartnershipsInput {
	s.ProfileId = &v
	return s
}

type ListPartnershipsOutput struct {
	_ struct{} `type:"structure"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Specifies a list of your partnerships.
	//
	// Partnerships is a required field
	Partnerships []*PartnershipSummary `locationName:"partnerships" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnershipsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnershipsOutput) SetNextToken(v string) *ListPartnershipsOutput {
	s.NextToken = &v
	return s
}

// SetPartnerships sets the Partnerships field's value.
func (s *ListPartnershipsOutput) SetPartnerships(v []*PartnershipSummary) *ListPartnershipsOutput {
	s.Partnerships = v
	return s
}

type ListProfilesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of profiles to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfilesInput) SetMaxResults(v int64) *ListProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesInput) SetNextToken(v string) *ListProfilesInput {
	s.NextToken = &v
	return s
}

type ListProfilesOutput struct {
	_ struct{} `type:"structure"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Returns an array of ProfileSummary objects.
	//
	// Profiles is a required field
	Profiles []*ProfileSummary `locationName:"profiles" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesOutput) SetNextToken(v string) *ListProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *ListProfilesOutput) SetProfiles(v []*ProfileSummary) *ListProfilesOutput {
	s.Profiles = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Requests the tags associated with a particular Amazon Resource Name (ARN).
	// An ARN is an identifier for a specific Amazon Web Services resource, such
	// as a capability, partnership, profile, or transformer.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Returns the key-value pairs assigned to ARNs that you can use to group and
	// search for resources by type. You can attach this metadata to resources (capabilities,
	// partnerships, and so on) for any purpose.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTransformersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of items to return for the API response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransformersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransformersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTransformersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTransformersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTransformersInput) SetMaxResults(v int64) *ListTransformersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransformersInput) SetNextToken(v string) *ListTransformersInput {
	s.NextToken = &v
	return s
}

type ListTransformersOutput struct {
	_ struct{} `type:"structure"`

	// When additional results are obtained from the command, a NextToken parameter
	// is returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Returns an array of one or more transformer objects.
	//
	// For each transformer, a TransformerSummary object is returned. The TransformerSummary
	// contains all the details for a specific transformer.
	//
	// Transformers is a required field
	Transformers []*TransformerSummary `locationName:"transformers" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransformersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransformersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransformersOutput) SetNextToken(v string) *ListTransformersOutput {
	s.NextToken = &v
	return s
}

// SetTransformers sets the Transformers field's value.
func (s *ListTransformersOutput) SetTransformers(v []*TransformerSummary) *ListTransformersOutput {
	s.Transformers = v
	return s
}

// A structure that contains the details for a partnership. Partnerships link
// trading partners with your profile and a specific transformer, so that the
// EDI (electronic data interchange) documents that they upload to Amazon S3
// can be processed according to their specifications.
type PartnershipSummary struct {
	_ struct{} `type:"structure"`

	// Returns one or more capabilities associated with this partnership.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// Returns a timestamp for creation date and time of the partnership.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the name of the partnership.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Returns the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for the profile connected
	// to this partnership.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for a trading partner.
	TradingPartnerId *string `locationName:"tradingPartnerId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartnershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartnershipSummary) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *PartnershipSummary) SetCapabilities(v []*string) *PartnershipSummary {
	s.Capabilities = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PartnershipSummary) SetCreatedAt(v time.Time) *PartnershipSummary {
	s.CreatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *PartnershipSummary) SetModifiedAt(v time.Time) *PartnershipSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *PartnershipSummary) SetName(v string) *PartnershipSummary {
	s.Name = &v
	return s
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *PartnershipSummary) SetPartnershipId(v string) *PartnershipSummary {
	s.PartnershipId = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *PartnershipSummary) SetProfileId(v string) *PartnershipSummary {
	s.ProfileId = &v
	return s
}

// SetTradingPartnerId sets the TradingPartnerId field's value.
func (s *PartnershipSummary) SetTradingPartnerId(v string) *PartnershipSummary {
	s.TradingPartnerId = &v
	return s
}

// Contains the details for a profile. Profiles contain basic information about
// you and your business.
type ProfileSummary struct {
	_ struct{} `type:"structure"`

	// Returns the name for the business associated with this profile.
	//
	// BusinessName is a required field
	BusinessName *string `locationName:"businessName" min:"1" type:"string" required:"true"`

	// Returns the timestamp for creation date and time of the profile.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the name of the logging group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// Specifies whether or not logging is enabled for this profile.
	Logging *string `locationName:"logging" type:"string" enum:"Logging"`

	// Returns the timestamp that identifies the most recent date and time that
	// the profile was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the display name for profile.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileSummary) GoString() string {
	return s.String()
}

// SetBusinessName sets the BusinessName field's value.
func (s *ProfileSummary) SetBusinessName(v string) *ProfileSummary {
	s.BusinessName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ProfileSummary) SetCreatedAt(v time.Time) *ProfileSummary {
	s.CreatedAt = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *ProfileSummary) SetLogGroupName(v string) *ProfileSummary {
	s.LogGroupName = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *ProfileSummary) SetLogging(v string) *ProfileSummary {
	s.Logging = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *ProfileSummary) SetModifiedAt(v time.Time) *ProfileSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProfileSummary) SetName(v string) *ProfileSummary {
	s.Name = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ProfileSummary) SetProfileId(v string) *ProfileSummary {
	s.ProfileId = &v
	return s
}

// Occurs when the requested resource does not exist, or cannot be found. In
// some cases, the resource exists in a region other than the region specified
// in the API call.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the details for the Amazon S3 file location that is being used
// with Amazon Web Services B2BI Data Interchange. File locations in Amazon
// S3 are identified using a combination of the bucket and key.
type S3Location struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the Amazon S3 bucket.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`

	// Specifies the Amazon S3 key for the file location.
	Key *string `locationName:"key" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Location) SetBucketName(v string) *S3Location {
	s.BucketName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// Occurs when the calling command attempts to exceed one of the service quotas,
// for example trying to create a capability when you already have the maximum
// number of capabilities allowed.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"10" type:"string"`

	// The quota that was exceeded, which caused the exception.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The ID for the resource that exceeded the quota, which caused the exception.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type (profile, partnership, transformer, or capability) that
	// exceeded the quota, which caused the exception.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The code responsible for exceeding the quota, which caused the exception.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartTransformerJobInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies the location of the input file for the transformation. The location
	// consists of an Amazon S3 bucket and prefix.
	//
	// InputFile is a required field
	InputFile *S3Location `locationName:"inputFile" type:"structure" required:"true"`

	// Specifies the location of the output file for the transformation. The location
	// consists of an Amazon S3 bucket and prefix.
	//
	// OutputLocation is a required field
	OutputLocation *S3Location `locationName:"outputLocation" type:"structure" required:"true"`

	// Specifies the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransformerJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransformerJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTransformerJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTransformerJobInput"}
	if s.InputFile == nil {
		invalidParams.Add(request.NewErrParamRequired("InputFile"))
	}
	if s.OutputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputLocation"))
	}
	if s.TransformerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerId"))
	}
	if s.TransformerId != nil && len(*s.TransformerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerId", 1))
	}
	if s.InputFile != nil {
		if err := s.InputFile.Validate(); err != nil {
			invalidParams.AddNested("InputFile", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartTransformerJobInput) SetClientToken(v string) *StartTransformerJobInput {
	s.ClientToken = &v
	return s
}

// SetInputFile sets the InputFile field's value.
func (s *StartTransformerJobInput) SetInputFile(v *S3Location) *StartTransformerJobInput {
	s.InputFile = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *StartTransformerJobInput) SetOutputLocation(v *S3Location) *StartTransformerJobInput {
	s.OutputLocation = v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *StartTransformerJobInput) SetTransformerId(v string) *StartTransformerJobInput {
	s.TransformerId = &v
	return s
}

type StartTransformerJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns the unique, system-generated identifier for a transformer run.
	//
	// TransformerJobId is a required field
	TransformerJobId *string `locationName:"transformerJobId" min:"25" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransformerJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransformerJobOutput) GoString() string {
	return s.String()
}

// SetTransformerJobId sets the TransformerJobId field's value.
func (s *StartTransformerJobOutput) SetTransformerJobId(v string) *StartTransformerJobOutput {
	s.TransformerJobId = &v
	return s
}

// Creates a key-value pair for a specific resource. Tags are metadata that
// you can use to search for and group a resource for various purposes. You
// can apply tags to capabilities, partnerships, profiles and transformers.
// A tag key can take more than one value. For example, to group capabilities
// for accounting purposes, you might create a tag called Group and assign the
// values Research and Accounting to that group.
type Tag struct {
	_ struct{} `type:"structure"`

	// Specifies the name assigned to the tag that you create.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Contains one or more values that you assigned to the key name that you create.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// Specifies the key-value pairs assigned to ARNs that you can use to group
	// and search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TestMappingInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Specify the EDI (electronic data interchange) file that is used as input
	// for the transform.
	//
	// InputFileContent is a required field
	InputFileContent *string `locationName:"inputFileContent" type:"string" required:"true"`

	// Specifies the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	//
	// MappingTemplate is a required field
	MappingTemplate *string `locationName:"mappingTemplate" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestMappingInput"}
	if s.FileFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("FileFormat"))
	}
	if s.InputFileContent == nil {
		invalidParams.Add(request.NewErrParamRequired("InputFileContent"))
	}
	if s.MappingTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("MappingTemplate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileFormat sets the FileFormat field's value.
func (s *TestMappingInput) SetFileFormat(v string) *TestMappingInput {
	s.FileFormat = &v
	return s
}

// SetInputFileContent sets the InputFileContent field's value.
func (s *TestMappingInput) SetInputFileContent(v string) *TestMappingInput {
	s.InputFileContent = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *TestMappingInput) SetMappingTemplate(v string) *TestMappingInput {
	s.MappingTemplate = &v
	return s
}

type TestMappingOutput struct {
	_ struct{} `type:"structure"`

	// Returns a string for the mapping that can be used to identify the mapping.
	// Similar to a fingerprint
	//
	// MappedFileContent is a required field
	MappedFileContent *string `locationName:"mappedFileContent" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestMappingOutput) GoString() string {
	return s.String()
}

// SetMappedFileContent sets the MappedFileContent field's value.
func (s *TestMappingOutput) SetMappedFileContent(v string) *TestMappingOutput {
	s.MappedFileContent = &v
	return s
}

type TestParsingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	//
	// EdiType is a required field
	EdiType *EdiType `locationName:"ediType" type:"structure" required:"true"`

	// Specifies that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Specifies an S3Location object, which contains the Amazon S3 bucket and prefix
	// for the location of the input file.
	//
	// InputFile is a required field
	InputFile *S3Location `locationName:"inputFile" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestParsingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestParsingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestParsingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestParsingInput"}
	if s.EdiType == nil {
		invalidParams.Add(request.NewErrParamRequired("EdiType"))
	}
	if s.FileFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("FileFormat"))
	}
	if s.InputFile == nil {
		invalidParams.Add(request.NewErrParamRequired("InputFile"))
	}
	if s.InputFile != nil {
		if err := s.InputFile.Validate(); err != nil {
			invalidParams.AddNested("InputFile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEdiType sets the EdiType field's value.
func (s *TestParsingInput) SetEdiType(v *EdiType) *TestParsingInput {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *TestParsingInput) SetFileFormat(v string) *TestParsingInput {
	s.FileFormat = &v
	return s
}

// SetInputFile sets the InputFile field's value.
func (s *TestParsingInput) SetInputFile(v *S3Location) *TestParsingInput {
	s.InputFile = v
	return s
}

type TestParsingOutput struct {
	_ struct{} `type:"structure"`

	// Returns the contents of the input file being tested, parsed according to
	// the specified EDI (electronic data interchange) type.
	//
	// ParsedFileContent is a required field
	ParsedFileContent *string `locationName:"parsedFileContent" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestParsingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestParsingOutput) GoString() string {
	return s.String()
}

// SetParsedFileContent sets the ParsedFileContent field's value.
func (s *TestParsingOutput) SetParsedFileContent(v string) *TestParsingOutput {
	s.ParsedFileContent = &v
	return s
}

// The request was denied due to throttling: the data speed and rendering may
// be limited depending on various parameters and conditions.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"10" type:"string"`

	// The server attempts to retry a command that was throttled.
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the details for a transformer object. Transformers describe how
// to process the incoming EDI (electronic data interchange) documents, and
// extract the necessary information.
type TransformerSummary struct {
	_ struct{} `type:"structure"`

	// Returns a timestamp indicating when the transformer was created. For example,
	// 2023-07-20T19:58:44.624Z.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	//
	// EdiType is a required field
	EdiType *EdiType `locationName:"ediType" type:"structure" required:"true"`

	// Returns that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Returns the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	//
	// MappingTemplate is a required field
	MappingTemplate *string `locationName:"mappingTemplate" type:"string" required:"true"`

	// Returns a timestamp representing the date and time for the most recent change
	// for the transformer object.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the descriptive name for the transformer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns a sample EDI document that is used by a transformer as a guide for
	// processing the EDI data.
	SampleDocument *string `locationName:"sampleDocument" type:"string"`

	// Returns the state of the newly created transformer. The transformer can be
	// either active or inactive. For the transformer to be used in a capability,
	// its status must active.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TransformerStatus"`

	// Returns the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformerSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TransformerSummary) SetCreatedAt(v time.Time) *TransformerSummary {
	s.CreatedAt = &v
	return s
}

// SetEdiType sets the EdiType field's value.
func (s *TransformerSummary) SetEdiType(v *EdiType) *TransformerSummary {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *TransformerSummary) SetFileFormat(v string) *TransformerSummary {
	s.FileFormat = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *TransformerSummary) SetMappingTemplate(v string) *TransformerSummary {
	s.MappingTemplate = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *TransformerSummary) SetModifiedAt(v time.Time) *TransformerSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *TransformerSummary) SetName(v string) *TransformerSummary {
	s.Name = &v
	return s
}

// SetSampleDocument sets the SampleDocument field's value.
func (s *TransformerSummary) SetSampleDocument(v string) *TransformerSummary {
	s.SampleDocument = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TransformerSummary) SetStatus(v string) *TransformerSummary {
	s.Status = &v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *TransformerSummary) SetTransformerId(v string) *TransformerSummary {
	s.TransformerId = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// Specifies the key-value pairs assigned to ARNs that you can use to group
	// and search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCapabilityInput struct {
	_ struct{} `type:"structure"`

	// Specifies a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`

	// Specifies a structure that contains the details for a capability.
	Configuration *CapabilityConfiguration `locationName:"configuration" type:"structure"`

	// Specifies one or more locations in Amazon S3, each specifying an EDI document
	// that can be used with this capability. Each item contains the name of the
	// bucket and the key, to identify the document's location.
	InstructionsDocuments []*S3Location `locationName:"instructionsDocuments" type:"list"`

	// Specifies a new name for the capability, to replace the existing name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCapabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCapabilityInput"}
	if s.CapabilityId == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityId"))
	}
	if s.CapabilityId != nil && len(*s.CapabilityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.InstructionsDocuments != nil {
		for i, v := range s.InstructionsDocuments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstructionsDocuments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *UpdateCapabilityInput) SetCapabilityId(v string) *UpdateCapabilityInput {
	s.CapabilityId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateCapabilityInput) SetConfiguration(v *CapabilityConfiguration) *UpdateCapabilityInput {
	s.Configuration = v
	return s
}

// SetInstructionsDocuments sets the InstructionsDocuments field's value.
func (s *UpdateCapabilityInput) SetInstructionsDocuments(v []*S3Location) *UpdateCapabilityInput {
	s.InstructionsDocuments = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCapabilityInput) SetName(v string) *UpdateCapabilityInput {
	s.Name = &v
	return s
}

type UpdateCapabilityOutput struct {
	_ struct{} `type:"structure"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// CapabilityArn is a required field
	CapabilityArn *string `locationName:"capabilityArn" min:"1" type:"string" required:"true"`

	// Returns a system-assigned unique identifier for the capability.
	//
	// CapabilityId is a required field
	CapabilityId *string `locationName:"capabilityId" min:"1" type:"string" required:"true"`

	// Returns a structure that contains the details for a capability.
	//
	// Configuration is a required field
	Configuration *CapabilityConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// Returns a timestamp for creation date and time of the capability.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns one or more locations in Amazon S3, each specifying an EDI document
	// that can be used with this capability. Each item contains the name of the
	// bucket and the key, to identify the document's location.
	InstructionsDocuments []*S3Location `locationName:"instructionsDocuments" type:"list"`

	// Returns a timestamp for last time the capability was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the name of the capability, used to identify it.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the type of the capability. Currently, only edi is supported.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CapabilityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCapabilityOutput) GoString() string {
	return s.String()
}

// SetCapabilityArn sets the CapabilityArn field's value.
func (s *UpdateCapabilityOutput) SetCapabilityArn(v string) *UpdateCapabilityOutput {
	s.CapabilityArn = &v
	return s
}

// SetCapabilityId sets the CapabilityId field's value.
func (s *UpdateCapabilityOutput) SetCapabilityId(v string) *UpdateCapabilityOutput {
	s.CapabilityId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateCapabilityOutput) SetConfiguration(v *CapabilityConfiguration) *UpdateCapabilityOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateCapabilityOutput) SetCreatedAt(v time.Time) *UpdateCapabilityOutput {
	s.CreatedAt = &v
	return s
}

// SetInstructionsDocuments sets the InstructionsDocuments field's value.
func (s *UpdateCapabilityOutput) SetInstructionsDocuments(v []*S3Location) *UpdateCapabilityOutput {
	s.InstructionsDocuments = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateCapabilityOutput) SetModifiedAt(v time.Time) *UpdateCapabilityOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCapabilityOutput) SetName(v string) *UpdateCapabilityOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateCapabilityOutput) SetType(v string) *UpdateCapabilityOutput {
	s.Type = &v
	return s
}

type UpdatePartnershipInput struct {
	_ struct{} `type:"structure"`

	// List of the capabilities associated with this partnership.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// The name of the partnership, used to identify it.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePartnershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePartnershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePartnershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePartnershipInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PartnershipId == nil {
		invalidParams.Add(request.NewErrParamRequired("PartnershipId"))
	}
	if s.PartnershipId != nil && len(*s.PartnershipId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartnershipId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdatePartnershipInput) SetCapabilities(v []*string) *UpdatePartnershipInput {
	s.Capabilities = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePartnershipInput) SetName(v string) *UpdatePartnershipInput {
	s.Name = &v
	return s
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *UpdatePartnershipInput) SetPartnershipId(v string) *UpdatePartnershipInput {
	s.PartnershipId = &v
	return s
}

type UpdatePartnershipOutput struct {
	_ struct{} `type:"structure"`

	// Returns one or more capabilities associated with this partnership.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the email address associated with this trading partner.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePartnershipOutput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Returns a timestamp that identifies the most recent date and time that the
	// partnership was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the partnership, used to identify it.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// PartnershipArn is a required field
	PartnershipArn *string `locationName:"partnershipArn" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for a partnership.
	//
	// PartnershipId is a required field
	PartnershipId *string `locationName:"partnershipId" min:"1" type:"string" required:"true"`

	// Returns the phone number associated with the partnership.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePartnershipOutput's
	// String and GoString methods.
	Phone *string `locationName:"phone" min:"7" type:"string" sensitive:"true"`

	// Returns the unique, system-generated identifier for the profile connected
	// to this partnership.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for a trading partner.
	TradingPartnerId *string `locationName:"tradingPartnerId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePartnershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePartnershipOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdatePartnershipOutput) SetCapabilities(v []*string) *UpdatePartnershipOutput {
	s.Capabilities = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdatePartnershipOutput) SetCreatedAt(v time.Time) *UpdatePartnershipOutput {
	s.CreatedAt = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UpdatePartnershipOutput) SetEmail(v string) *UpdatePartnershipOutput {
	s.Email = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdatePartnershipOutput) SetModifiedAt(v time.Time) *UpdatePartnershipOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePartnershipOutput) SetName(v string) *UpdatePartnershipOutput {
	s.Name = &v
	return s
}

// SetPartnershipArn sets the PartnershipArn field's value.
func (s *UpdatePartnershipOutput) SetPartnershipArn(v string) *UpdatePartnershipOutput {
	s.PartnershipArn = &v
	return s
}

// SetPartnershipId sets the PartnershipId field's value.
func (s *UpdatePartnershipOutput) SetPartnershipId(v string) *UpdatePartnershipOutput {
	s.PartnershipId = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *UpdatePartnershipOutput) SetPhone(v string) *UpdatePartnershipOutput {
	s.Phone = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdatePartnershipOutput) SetProfileId(v string) *UpdatePartnershipOutput {
	s.ProfileId = &v
	return s
}

// SetTradingPartnerId sets the TradingPartnerId field's value.
func (s *UpdatePartnershipOutput) SetTradingPartnerId(v string) *UpdatePartnershipOutput {
	s.TradingPartnerId = &v
	return s
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name for the business associated with this profile.
	BusinessName *string `locationName:"businessName" min:"1" type:"string"`

	// Specifies the email address associated with this customer profile.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateProfileInput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// The name of the profile, used to identify it.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies the phone number associated with the profile.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateProfileInput's
	// String and GoString methods.
	Phone *string `locationName:"phone" min:"7" type:"string" sensitive:"true"`

	// Specifies the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.BusinessName != nil && len(*s.BusinessName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessName", 1))
	}
	if s.Email != nil && len(*s.Email) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Phone != nil && len(*s.Phone) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Phone", 7))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBusinessName sets the BusinessName field's value.
func (s *UpdateProfileInput) SetBusinessName(v string) *UpdateProfileInput {
	s.BusinessName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UpdateProfileInput) SetEmail(v string) *UpdateProfileInput {
	s.Email = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProfileInput) SetName(v string) *UpdateProfileInput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *UpdateProfileInput) SetPhone(v string) *UpdateProfileInput {
	s.Phone = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileInput) SetProfileId(v string) *UpdateProfileInput {
	s.ProfileId = &v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`

	// Returns the name for the business associated with this profile.
	//
	// BusinessName is a required field
	BusinessName *string `locationName:"businessName" min:"1" type:"string" required:"true"`

	// Returns a timestamp for creation date and time of the profile.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the email address associated with this customer profile.
	//
	// Email is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateProfileOutput's
	// String and GoString methods.
	Email *string `locationName:"email" min:"5" type:"string" sensitive:"true"`

	// Returns the name of the logging group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// Specifies whether or not logging is enabled for this profile.
	Logging *string `locationName:"logging" type:"string" enum:"Logging"`

	// Returns a timestamp for last time the profile was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Returns the name of the profile.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns the phone number associated with the profile.
	//
	// Phone is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateProfileOutput's
	// String and GoString methods.
	//
	// Phone is a required field
	Phone *string `locationName:"phone" min:"7" type:"string" required:"true" sensitive:"true"`

	// Returns an Amazon Resource Name (ARN) for the profile.
	//
	// ProfileArn is a required field
	ProfileArn *string `locationName:"profileArn" min:"1" type:"string" required:"true"`

	// Returns the unique, system-generated identifier for the profile.
	//
	// ProfileId is a required field
	ProfileId *string `locationName:"profileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

// SetBusinessName sets the BusinessName field's value.
func (s *UpdateProfileOutput) SetBusinessName(v string) *UpdateProfileOutput {
	s.BusinessName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateProfileOutput) SetCreatedAt(v time.Time) *UpdateProfileOutput {
	s.CreatedAt = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UpdateProfileOutput) SetEmail(v string) *UpdateProfileOutput {
	s.Email = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *UpdateProfileOutput) SetLogGroupName(v string) *UpdateProfileOutput {
	s.LogGroupName = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *UpdateProfileOutput) SetLogging(v string) *UpdateProfileOutput {
	s.Logging = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateProfileOutput) SetModifiedAt(v time.Time) *UpdateProfileOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProfileOutput) SetName(v string) *UpdateProfileOutput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *UpdateProfileOutput) SetPhone(v string) *UpdateProfileOutput {
	s.Phone = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateProfileOutput) SetProfileArn(v string) *UpdateProfileOutput {
	s.ProfileArn = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileOutput) SetProfileId(v string) *UpdateProfileOutput {
	s.ProfileId = &v
	return s
}

type UpdateTransformerInput struct {
	_ struct{} `type:"structure"`

	// Specifies the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	EdiType *EdiType `locationName:"ediType" type:"structure"`

	// Specifies that the currently supported file formats for EDI transformations
	// are JSON and XML.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"FileFormat"`

	// Specifies the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	MappingTemplate *string `locationName:"mappingTemplate" type:"string"`

	// Specify a new name for the transformer, if you want to update it.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies a sample EDI document that is used by a transformer as a guide
	// for processing the EDI data.
	SampleDocument *string `locationName:"sampleDocument" type:"string"`

	// Specifies the transformer's status. You can update the state of the transformer,
	// from active to inactive, or inactive to active.
	Status *string `locationName:"status" type:"string" enum:"TransformerStatus"`

	// Specifies the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTransformerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTransformerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTransformerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTransformerInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TransformerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformerId"))
	}
	if s.TransformerId != nil && len(*s.TransformerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransformerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEdiType sets the EdiType field's value.
func (s *UpdateTransformerInput) SetEdiType(v *EdiType) *UpdateTransformerInput {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *UpdateTransformerInput) SetFileFormat(v string) *UpdateTransformerInput {
	s.FileFormat = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *UpdateTransformerInput) SetMappingTemplate(v string) *UpdateTransformerInput {
	s.MappingTemplate = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTransformerInput) SetName(v string) *UpdateTransformerInput {
	s.Name = &v
	return s
}

// SetSampleDocument sets the SampleDocument field's value.
func (s *UpdateTransformerInput) SetSampleDocument(v string) *UpdateTransformerInput {
	s.SampleDocument = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTransformerInput) SetStatus(v string) *UpdateTransformerInput {
	s.Status = &v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *UpdateTransformerInput) SetTransformerId(v string) *UpdateTransformerInput {
	s.TransformerId = &v
	return s
}

type UpdateTransformerOutput struct {
	_ struct{} `type:"structure"`

	// Returns a timestamp for creation date and time of the transformer.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the details for the EDI standard that is being used for the transformer.
	// Currently, only X12 is supported. X12 is a set of standards and corresponding
	// messages that define specific business documents.
	//
	// EdiType is a required field
	EdiType *EdiType `locationName:"ediType" type:"structure" required:"true"`

	// Returns that the currently supported file formats for EDI transformations
	// are JSON and XML.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"FileFormat"`

	// Returns the name of the mapping template for the transformer. This template
	// is used to convert the input document into the correct set of objects.
	//
	// MappingTemplate is a required field
	MappingTemplate *string `locationName:"mappingTemplate" type:"string" required:"true"`

	// Returns a timestamp for last time the transformer was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Returns the name of the transformer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Returns a sample EDI document that is used by a transformer as a guide for
	// processing the EDI data.
	SampleDocument *string `locationName:"sampleDocument" type:"string"`

	// Returns the state of the newly created transformer. The transformer can be
	// either active or inactive. For the transformer to be used in a capability,
	// its status must active.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TransformerStatus"`

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// TransformerArn is a required field
	TransformerArn *string `locationName:"transformerArn" min:"1" type:"string" required:"true"`

	// Returns the system-assigned unique identifier for the transformer.
	//
	// TransformerId is a required field
	TransformerId *string `locationName:"transformerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTransformerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTransformerOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateTransformerOutput) SetCreatedAt(v time.Time) *UpdateTransformerOutput {
	s.CreatedAt = &v
	return s
}

// SetEdiType sets the EdiType field's value.
func (s *UpdateTransformerOutput) SetEdiType(v *EdiType) *UpdateTransformerOutput {
	s.EdiType = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *UpdateTransformerOutput) SetFileFormat(v string) *UpdateTransformerOutput {
	s.FileFormat = &v
	return s
}

// SetMappingTemplate sets the MappingTemplate field's value.
func (s *UpdateTransformerOutput) SetMappingTemplate(v string) *UpdateTransformerOutput {
	s.MappingTemplate = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateTransformerOutput) SetModifiedAt(v time.Time) *UpdateTransformerOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTransformerOutput) SetName(v string) *UpdateTransformerOutput {
	s.Name = &v
	return s
}

// SetSampleDocument sets the SampleDocument field's value.
func (s *UpdateTransformerOutput) SetSampleDocument(v string) *UpdateTransformerOutput {
	s.SampleDocument = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTransformerOutput) SetStatus(v string) *UpdateTransformerOutput {
	s.Status = &v
	return s
}

// SetTransformerArn sets the TransformerArn field's value.
func (s *UpdateTransformerOutput) SetTransformerArn(v string) *UpdateTransformerOutput {
	s.TransformerArn = &v
	return s
}

// SetTransformerId sets the TransformerId field's value.
func (s *UpdateTransformerOutput) SetTransformerId(v string) *UpdateTransformerOutput {
	s.TransformerId = &v
	return s
}

// Occurs when a B2BI object cannot be validated against a request from another
// object.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that contains the X12 transaction set and version. The X12 structure
// is used when the system transforms an EDI (electronic data interchange) file.
type X12Details struct {
	_ struct{} `type:"structure"`

	// Returns an enumerated type where each value identifies an X12 transaction
	// set. Transaction sets are maintained by the X12 Accredited Standards Committee.
	TransactionSet *string `locationName:"transactionSet" type:"string" enum:"X12TransactionSet"`

	// Returns the version to use for the specified X12 transaction set. Supported
	// versions are 4010, 4030, and 5010.
	Version *string `locationName:"version" type:"string" enum:"X12Version"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s X12Details) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s X12Details) GoString() string {
	return s.String()
}

// SetTransactionSet sets the TransactionSet field's value.
func (s *X12Details) SetTransactionSet(v string) *X12Details {
	s.TransactionSet = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *X12Details) SetVersion(v string) *X12Details {
	s.Version = &v
	return s
}

const (
	// CapabilityTypeEdi is a CapabilityType enum value
	CapabilityTypeEdi = "edi"
)

// CapabilityType_Values returns all elements of the CapabilityType enum
func CapabilityType_Values() []string {
	return []string{
		CapabilityTypeEdi,
	}
}

const (
	// FileFormatXml is a FileFormat enum value
	FileFormatXml = "XML"

	// FileFormatJson is a FileFormat enum value
	FileFormatJson = "JSON"
)

// FileFormat_Values returns all elements of the FileFormat enum
func FileFormat_Values() []string {
	return []string{
		FileFormatXml,
		FileFormatJson,
	}
}

const (
	// LoggingEnabled is a Logging enum value
	LoggingEnabled = "ENABLED"

	// LoggingDisabled is a Logging enum value
	LoggingDisabled = "DISABLED"
)

// Logging_Values returns all elements of the Logging enum
func Logging_Values() []string {
	return []string{
		LoggingEnabled,
		LoggingDisabled,
	}
}

const (
	// TransformerJobStatusRunning is a TransformerJobStatus enum value
	TransformerJobStatusRunning = "running"

	// TransformerJobStatusSucceeded is a TransformerJobStatus enum value
	TransformerJobStatusSucceeded = "succeeded"

	// TransformerJobStatusFailed is a TransformerJobStatus enum value
	TransformerJobStatusFailed = "failed"
)

// TransformerJobStatus_Values returns all elements of the TransformerJobStatus enum
func TransformerJobStatus_Values() []string {
	return []string{
		TransformerJobStatusRunning,
		TransformerJobStatusSucceeded,
		TransformerJobStatusFailed,
	}
}

const (
	// TransformerStatusActive is a TransformerStatus enum value
	TransformerStatusActive = "active"

	// TransformerStatusInactive is a TransformerStatus enum value
	TransformerStatusInactive = "inactive"
)

// TransformerStatus_Values returns all elements of the TransformerStatus enum
func TransformerStatus_Values() []string {
	return []string{
		TransformerStatusActive,
		TransformerStatusInactive,
	}
}

const (
	// X12TransactionSetX12110 is a X12TransactionSet enum value
	X12TransactionSetX12110 = "X12_110"

	// X12TransactionSetX12180 is a X12TransactionSet enum value
	X12TransactionSetX12180 = "X12_180"

	// X12TransactionSetX12204 is a X12TransactionSet enum value
	X12TransactionSetX12204 = "X12_204"

	// X12TransactionSetX12210 is a X12TransactionSet enum value
	X12TransactionSetX12210 = "X12_210"

	// X12TransactionSetX12214 is a X12TransactionSet enum value
	X12TransactionSetX12214 = "X12_214"

	// X12TransactionSetX12215 is a X12TransactionSet enum value
	X12TransactionSetX12215 = "X12_215"

	// X12TransactionSetX12310 is a X12TransactionSet enum value
	X12TransactionSetX12310 = "X12_310"

	// X12TransactionSetX12315 is a X12TransactionSet enum value
	X12TransactionSetX12315 = "X12_315"

	// X12TransactionSetX12322 is a X12TransactionSet enum value
	X12TransactionSetX12322 = "X12_322"

	// X12TransactionSetX12404 is a X12TransactionSet enum value
	X12TransactionSetX12404 = "X12_404"

	// X12TransactionSetX12410 is a X12TransactionSet enum value
	X12TransactionSetX12410 = "X12_410"

	// X12TransactionSetX12820 is a X12TransactionSet enum value
	X12TransactionSetX12820 = "X12_820"

	// X12TransactionSetX12824 is a X12TransactionSet enum value
	X12TransactionSetX12824 = "X12_824"

	// X12TransactionSetX12830 is a X12TransactionSet enum value
	X12TransactionSetX12830 = "X12_830"

	// X12TransactionSetX12846 is a X12TransactionSet enum value
	X12TransactionSetX12846 = "X12_846"

	// X12TransactionSetX12850 is a X12TransactionSet enum value
	X12TransactionSetX12850 = "X12_850"

	// X12TransactionSetX12852 is a X12TransactionSet enum value
	X12TransactionSetX12852 = "X12_852"

	// X12TransactionSetX12855 is a X12TransactionSet enum value
	X12TransactionSetX12855 = "X12_855"

	// X12TransactionSetX12856 is a X12TransactionSet enum value
	X12TransactionSetX12856 = "X12_856"

	// X12TransactionSetX12860 is a X12TransactionSet enum value
	X12TransactionSetX12860 = "X12_860"

	// X12TransactionSetX12861 is a X12TransactionSet enum value
	X12TransactionSetX12861 = "X12_861"

	// X12TransactionSetX12864 is a X12TransactionSet enum value
	X12TransactionSetX12864 = "X12_864"

	// X12TransactionSetX12940 is a X12TransactionSet enum value
	X12TransactionSetX12940 = "X12_940"

	// X12TransactionSetX12990 is a X12TransactionSet enum value
	X12TransactionSetX12990 = "X12_990"

	// X12TransactionSetX12997 is a X12TransactionSet enum value
	X12TransactionSetX12997 = "X12_997"
)

// X12TransactionSet_Values returns all elements of the X12TransactionSet enum
func X12TransactionSet_Values() []string {
	return []string{
		X12TransactionSetX12110,
		X12TransactionSetX12180,
		X12TransactionSetX12204,
		X12TransactionSetX12210,
		X12TransactionSetX12214,
		X12TransactionSetX12215,
		X12TransactionSetX12310,
		X12TransactionSetX12315,
		X12TransactionSetX12322,
		X12TransactionSetX12404,
		X12TransactionSetX12410,
		X12TransactionSetX12820,
		X12TransactionSetX12824,
		X12TransactionSetX12830,
		X12TransactionSetX12846,
		X12TransactionSetX12850,
		X12TransactionSetX12852,
		X12TransactionSetX12855,
		X12TransactionSetX12856,
		X12TransactionSetX12860,
		X12TransactionSetX12861,
		X12TransactionSetX12864,
		X12TransactionSetX12940,
		X12TransactionSetX12990,
		X12TransactionSetX12997,
	}
}

const (
	// X12VersionVersion4010 is a X12Version enum value
	X12VersionVersion4010 = "VERSION_4010"

	// X12VersionVersion4030 is a X12Version enum value
	X12VersionVersion4030 = "VERSION_4030"

	// X12VersionVersion5010 is a X12Version enum value
	X12VersionVersion5010 = "VERSION_5010"
)

// X12Version_Values returns all elements of the X12Version enum
func X12Version_Values() []string {
	return []string{
		X12VersionVersion4010,
		X12VersionVersion4030,
		X12VersionVersion5010,
	}
}
