// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's effective_tld_names.dat, hg revision 9767cf9a0150 (2013-10-15)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 369

// Text is the combined text of all labels.
const text = "bielawashingtondcasertaishinomakikugawatchandclockasaokaminokawa" +
	"nishiaizubangexeterbiellaakesvuemieleccertificationaturalscience" +
	"snaturelles3-us-west-1bieszczadygeyachiyodabievat-band-campobass" +
	"obetsuldalvdalaskanittedalaheadjudygarlandrobakrehamnaturbruksgy" +
	"mnaturhistorisches3-us-west-2bifukagawassamukawatarikuzentakatai" +
	"rabihorologyonagoyabikedabilbaogakievenassisibenikihokumakogeneb" +
	"akkeshibechambagricultureklambulancechirebungoonomichinomiyakemb" +
	"uchikujoetsuruokafjordyndns-at-workinggroupowiatambovaroyonaguni" +
	"versityumenatuurwetenschappenaumburglassassinational-library-sco" +
	"tlandes3-website-ap-northeast-1billustrationaustdalosangeles3-we" +
	"bsite-ap-southeast-1biohtawaramotoineppulminamidaitomanmobileirv" +
	"ikashibatakarazukaminoyamatsuriiyamanobeeldengeluidyndns-blogdns" +
	"3-website-ap-southeast-2birdartdecoaloteneindianapolis-a-blogger" +
	"birkenesoddtangenoamishirasatodayoriikashiharabirthplacexhibitio" +
	"navalouvrexpressexyukuhashimoichinosekigaharabjarkoyurihonjolszt" +
	"ynsettlers3-website-eu-west-1bjerkreimperiabjugnavigationavuotna" +
	"kanotoddenawrastelecomoldebmdyndns-freemasonryusuharabolzanordla" +
	"ndyndns-homeftpaccess3-website-sa-east-1bomloabaths3-website-us-" +
	"east-1bonnayoromutashinaindianmarketplacebostonakijinsekikogenov" +
	"arabotanicalgardenvironmentalconservationikkoebenhavnikolaevenes" +
	"sebyglandyndns-ipalermomanposts-and-telecommunications3-website-" +
	"us-gov-west-1botanicgardeninomiyakonojournalismolenskashiwarabot" +
	"anycasinordre-landyndns-mailowiczest-a-la-maisondre-landyndns-of" +
	"fice-on-the-webhopocznorilskashiwazakiyosumitakaginozawaonsenira" +
	"sakinfoggiabozentsujiiebrandywinevalleyusuissembokumamotoyamatsu" +
	"motofukebrasiljan-mayenishiawakurabremangerbresciabrindisiellaka" +
	"samatsudonnagatorokunohealthruhereggiocalabriabristolgamvikasuka" +
	"beiarndyndns-picsiroroskolegnicagliaridagawatch-and-clockasumiga" +
	"urawa-mazowszexchangebritish-libraryazannakadomari-elasticbeanst" +
	"alkasuyanagawabritishcolumbialowiezachpomorskienishiazainsurance" +
	"broadcastleasingles3-website-us-west-1broke-itarantokyotangoslop" +
	"padovanylvenicebrokerbronnoysundyndns-remoteginankokubunjintelli" +
	"gencebrumunddaluccarbonia-iglesias-carboniaiglesiascarboniabrune" +
	"lblagdenesnaaseralingenkainanaejrietipschlesischest-mon-blogueur" +
	"brussels3-website-us-west-2bruxellesjamalborkangerbryanskleppalm" +
	"springsakerbrynewjerseyuulsandoyuzawabuzz-2bvballooninggfarmerse" +
	"inebinosegawaustraliastronomyokohamamatsudaejeonbukareliaostalba" +
	"nsnasabaerobaticarrierbwegrowestfalenishigotembaixadabzgoracityd" +
	"aluroycivilaviationishinomiyashironostrowwlkpanamacivilisationis" +
	"hinoomotegotsukisofukushimarburgloppenzamamidsundyndns-workshopp" +
	"dalustercivilizationishinoshimacivilwarmiasakuchinotsuchiurakawa" +
	"clintonoshoesalangenishiokoppegardyroyclothingminakamichigangwon" +
	"ishitosashimizunaminamiawajikis-a-conservativefsnillfjordcloudco" +
	"ntrolledogawarabikomaezakirunorfolkebibleborkdalutskazimierz-dol" +
	"nycloudfrontariodejaneiromskoguchikuzenishiwakis-a-cpaderborniss" +
	"edaluxembourgqcatanzarowfarmsteadyndns-serverbaniacntarumizusawa" +
	"coloradoplateaukraanghkemerovoldavvenjargalsadoesntexisteingeeka" +
	"zoologycolumbusantiquesalatatarstanisshingouvicenzaogashimadachi" +
	"cagobodoes-itateshinanomachildrensgardeniyodogawacompute-1comput" +
	"erhistoryofscience-fictionlsaltdaluzernrwritesthisblogspotateyam" +
	"aconferenceconstructionconsuladoomdnsaliascolipicenord-aurdalto-" +
	"adigeelvinckazunoconsultanthropologyconsultingvollvivcateringebu" +
	"nkyonanaoshimabariaketrzynishiharacontemporaryartgalleryggets-it" +
	"atsunocontractorskenconventureshinodesashibetsuikimobetsurutahar" +
	"acooperaunitelevisioncopenhagentsalvadordalillehammerfest-le-pat" +
	"rondheiminamiiserniacorporationcorvettexasiacosenzagannefrankfur" +
	"tattoocostumedicaltanissettaitogitsulikes-piecountysfjordcqhabor" +
	"ovnotogawacranbrookuwanamizuhobby-sitextilebtimnetzgorzeleccolon" +
	"ialwilliamsburgretajimakanegasakisosakitagatakaharussiacremonash" +
	"orokanaiecrewroclawwwcrimeacrotonewyorkshirepbodynathomebuiltaxi" +
	"s-a-bruinsfanculturalcentertainmentgorycuneocxn--3bst00minamiizu" +
	"kamisunagawacymruovatmparachutingrimstadfhvalerfieldfigueresalzb" +
	"urgrossetouchijiwadepotaruis-a-cubicle-slaveroyrviknakanojoshkar" +
	"-olangevagsoyfilateliafilminamimakis-a-democratjeldsundfineartsa" +
	"megawafinlandfinnoyfirenzefirminamiminowafitjarchitecturennebude" +
	"jjuedischesapeakebayfjalerdalflekkefjordflesbergenflightinground" +
	"handlingroznyflogisticsamnangerfloraflorencefloridaflorovigoogle" +
	"apisa-geekgrparaglidingruenoharafndfolldalfor-better-thanawafor-" +
	"ourfor-somedio-campidano-mediocampidanomediofor-thedmarkhabarovs" +
	"khakassiaforceforgotdnsanfranciscollectionforli-cesena-forlicese" +
	"naforlikescandyndns-at-homednsangoforsandasuolodingenfortmissoul" +
	"an-udell-ogliastrakhanamigawafortworthachijorpelandforuminamiogu" +
	"nionfosnesanjournalistavernfotherokusslattuminamisanrikubetsurge" +
	"onshalloffameldalfredrikstadaokagakirafreiburgulenfreightjomeloy" +
	"alistavropolkowicefribourgunmarnardalfrognfrolandfrom-akuneuesan" +
	"nanfrom-alfrom-arqldfrom-azgradfrom-cambridgetmyiparisor-fronfro" +
	"m-coldwarszawafrom-ctownfrom-dcharterfrom-dellogliastraderfrom-f" +
	"lakstadtoyakokamiokamikitayamatotakadafrom-gausdalfrom-hichisoft" +
	"waremarkerfrom-iafrom-idfrom-ilfrom-incheonfrom-ksannohemnesanta" +
	"barbarafrom-kyotobetsuwanouchikushinonsennanburyatiafrom-lahppia" +
	"cenzakopanefrom-mannoshirooshikamaishimodatefrom-mdfrom-medizinh" +
	"istorischesantacruzhgorodfrom-microlightoyokawafrom-mnfrom-mochi" +
	"zukirkenesantafedjelenia-gorafrom-msanukis-a-designerfrom-mtoyon" +
	"akagyokutomaritimekeepinguovdageaidnurembergushikamifuranotaires" +
	"aotomelhusdecorativeartsapporofrom-nchattanooganordreisa-hockeyn" +
	"utazulvikaszubytomakomaibarafrom-ndfrom-nefrom-nhachinoheguris-a" +
	"-doctorfrom-njessheiminamitanefrom-nminamiuonumatsusakahogis-a-f" +
	"inancialadvisor-aurdalfrom-nvdonskharkivguernseyfrom-nyfrom-ohda" +
	"from-oketogooglecodespotoyonezawafrom-orlandfrom-pacificheltenha" +
	"m-radio-openair-surveillancefrom-prdfrom-rissagaeroclubindallasp" +
	"eziamallamadridvrdnsdojobojis-a-geekharkovenneslaskerfrom-schoen" +
	"brunnfrom-sdfrom-tnfrom-txn--3ds443gwangjurfrom-utsiracusagamiha" +
	"rafrom-vadsogndalfrom-vtoyonofrom-wafrom-wielunnerfrom-wveronams" +
	"osnowiechelyabinskodjeffersongfest-a-la-masionishiizunazukinuyam" +
	"anouchikuhokuryugasakitaurayasudafrom-wyfrosinonefrostargardfroy" +
	"aitaiwanaip6boneat-urlewismillerhcloudcontrolappalace-burg12000f" +
	"starostwodzislawfujiiderafujikawaguchikonefujiminohkurafujinomiy" +
	"adafujiokayamansionsaratoverranfujisatoshonaircraftoyookanrafuji" +
	"sawafujishiroishidakabiratoridelmenhorstalowa-wolawafujiyoshidaf" +
	"ukayabeardudinkakegawalesundfukuchiyamadafukudominicherkasydneyu" +
	"zhno-sakhalinskatowicefukuis-a-greenfukumitsukefukuokazakirovogr" +
	"adoyfukuroishigakiryufuefukihabikinokawair-traffic-controlleyfuk" +
	"usakisarazunjargafukuyamagatajimidorittogurafunabashiriuchinadaf" +
	"unagatajiris-a-gurunsakatakatsukis-a-hard-workerfunahashikamiama" +
	"kusatsumasendaisenfundaciofuoiskujitawarafuosskoczowfurniturevie" +
	"wsarpsborgxn--3e0b707efurubiraquariuminamiyamashirokawanabellevu" +
	"edavvesiidazaifudaigodollsarufutsunomiyawakasaikaitakoelnfurudon" +
	"ostiafurukawaharafusognefussaikishiwadafutabayamaguchinomigawafu" +
	"tboldlygoingnowhere-for-moregontrailroadfuttsunanjohanamakinohar" +
	"afylkesbiblfyresdalhakubanhakuis-a-hunterhakusandnessjoenhaldenh" +
	"alsaintlouis-a-anarchistoirehammarfeastafricamerakershuscountrye" +
	"stateofdelawarezzoologicalhamurakamigoris-a-knightoyotaris-a-lan" +
	"dscaperugiahangglidingzhytomyrhannanmokuizumodellinghannoverhall" +
	"ancashirehanyuzenhapmirkutskhmelnitskiyamassa-carrara-massacarra" +
	"ramassabuyshousesasayamahappoumuenchenhareidsbergbauernunzenhars" +
	"tadharvestcelebrationhasamarahasaminami-alpsienakamuratakamoriok" +
	"amakurazakitahiroshimarugame-hostre-totenkawahasudahasvikhmelnyt" +
	"skyiversaillesaseboknowsitallhatogayakagehatoyamazakitakamiizumi" +
	"sanoksnesaskatchewanhatsukaichiharahattfjelldalhawaiijimarumorim" +
	"achidahayashimamotobusheyhazuminobusenetoyotomiyazakis-a-lawyerh" +
	"emsedalheroyhigashichichibuskerudinewmexicodynaliascoli-picenono" +
	"ichikawamisatobishimaizurubtsovskjaknoluoktainaikawababia-gorakk" +
	"estadultoyotsukaidohigashihiroshimanehigashiizumozakitamidtre-ga" +
	"uldalhigashikagawahigashikagurasoedahigashikawakitaaikitamotosum" +
	"idatlantichernigovernmentargis-a-bulls-fanishikatakasugais-a-can" +
	"didatehigashikurumeeresassaris-a-liberalhigashimatsushimarylandh" +
	"igashimatsuyamakitaakitadaitoigawahigashimurayamalatvuopmifunehi" +
	"gashinarusells-for-lessatxn--45brj9chernihivanovosibirskydivingl" +
	"iwicehigashinehigashiomihachimanchesterhigashiosakasayamamotorcy" +
	"cleikangerhigashishirakawamatakanezawahigashisumiyoshikawaminami" +
	"aikitanakagusukumodenakaniikawatanagurahigashitsunohigashiurausu" +
	"kitashiobarahigashiyamatokoriyamanakakogawahigashiyodogawahigash" +
	"iyoshinogaris-a-libertarianhiraizumisatohmarylhurstathelleirfjor" +
	"dhirakatashinagawahiranairlinemurorankoshigayachimatagajobsaudah" +
	"irarahiratsukagawahirayakumodernhistorichousesauheradhitachiomiy" +
	"aginowaniigatakahamantovaksdalhitachiotagoparmahitoyoshimihamada" +
	"hitradinghjartdalhjelmelandholdingsmolajollanbibaidarholeckobier" +
	"zycehomelinuxn--4gbrimininghomeunixn--54b7fta0cchernivtsiemenswe" +
	"denishikatsuragis-a-catererhongorgehonjyoichiropractichernovtsyk" +
	"kylveneziahornindalhortendofinternetoyourahoteledatabaseballange" +
	"nhoyangerhoylandetroitozawahuissier-justicehumanitiesavannahgahu" +
	"rdalhurumajis-a-linux-useranishiaritabashiibahccavuotnagaravenna" +
	"gareyamalopolskanlandhyugawaraissmarterthanyouthachiojiyaizuwaka" +
	"matsubushikusakadogawaiwatarailwayiwateiwatsukiyonojfklabuzenjgo" +
	"rajpnkoryolbia-tempio-olbiatempioolbialystokkekosaigawakosakaero" +
	"dromedecinemagadanconagawakayamagazinedre-eikerimo-i-ranaamesjev" +
	"uemielnoboribetsuitachikawakeisenbahnkoseis-a-nursells-for-usgar" +
	"denkoshimizumakis-a-painteractivegarsheiheijis-a-llamasfjordenko" +
	"shunantokamachippubetsubetsugarustkanzakiyosatohokkaidoshibuyaha" +
	"baghdadkostromahabmerkosugekotohiradomurakotourakouhokutamakis-a" +
	"-patsfankounosumypetscientisteigenkouyamateramodumincommunitysva" +
	"rdokouzushimatsumaebashikaois-a-personaltrainerkozagawakozakis-a" +
	"-photographerokuappspotenzaporizhzhelsinkitakatakanabedzin-addra" +
	"mmenuernbergkrageroticapebretonamibungotakadakrakowkrasnoyarskol" +
	"obrzegersundkristiansandefjordkristiansundkrodsheradkrokstadelva" +
	"ntaakryminnesotaketakashimatsushigekumatorinokumejimatsunokumena" +
	"nyokaichibaikaliszkola-speziakunisakis-a-playerkunitachiaraisaij" +
	"osoyrokunitomigusukukis-a-republicanadakunneppuwajimakunstsammlu" +
	"ngkunstunddesignkurekurgankurobelgorodoystre-slidrettravellinoku" +
	"rogimimatakasagorlicekuroisojaworznokuromatsunairportland-4-sale" +
	"rnogataikicks-assedichiryuoharuhrkurotakikawasakis-a-rockstarach" +
	"owicekurskomaganekushirogawakustanairtraffichitachinakagawawhali" +
	"nglobalatinabeauxartsandcraftsakurais-a-celticsfanishikawazukana" +
	"nporostrodakusunndalkutchandakutnokuzbassnoasaitamatsukuris-a-so" +
	"cialistationkuzumakis-a-soxfankvafjordkvalsundkvamsterdamberkele" +
	"ykvanangenkvinesdalkvinnheradkviteseidskogkvitsoykwkyowariasahik" +
	"awakyuragithubalsfjordlugolekaluganskarlsoyokotehimejibigawautho" +
	"rdalandiscoveryokosukaratsuginamikatagamilanobihirosakikamijimau" +
	"rskog-holandirectoryokamikawanehonbetsurugildeskalmykiaosteroyke" +
	"nglandgcahcesuolocalhistorybnikahokutoeigersundielddanuorringeri" +
	"ke164misugitokashikis-a-techietis-a-musicianmitakeharamitourismi" +
	"sakis-a-studentozsdemitoyoakemiuramiyazumiyotamanomjondalenmombe" +
	"tsurgutrdmoneyagawamonmouthachirogatakahashimamakitagawamonticel" +
	"londonetskomakizunokunimilitarymontrealestatecouncilmonza-brianz" +
	"amonza-e-della-brianzamonzabrianzamonzaebrianzamonzaedellabrianz" +
	"amordoviamoriyamatsuzakis-a-therapistoiamoriyoshiokamitondabayas" +
	"hiogamagoriziamoroyamatta-varjjatreemoscowmoseushistorymosjoenmo" +
	"skenescrapper-sitemosreggio-calabriamosscrappingmosvikomatsushim" +
	"asudamuenstermugis-an-accountantranaklodzkodairamuikamitsuemukoc" +
	"hikuseihigashiagatsumagoizumizakitakyushuaiamulhousells-itrentin" +
	"omunakatanemuncieszynmuosattemurmanskomforbalsanagochihayaakasak" +
	"awagoebizenakamagayahikobearalvahkikuchikumagayagawalbrzychampio" +
	"nshipalanakasatsunaibestadivttasvuotnakaiwamizawaustrheimatunduh" +
	"rennesoygardeniwaizumiotsukumiyamazonaws3-ap-northeast-1murotorc" +
	"raftrentomskomitamamuramusashimurayamamusashinoharamuseetrevisol" +
	"aquilapyatigorskommunalforbundmuseumverenigingmutsuzawamyphotosh" +
	"imamytis-a-bookkeepermisasaguris-a-teacherkassypassenger-associa" +
	"tionpaviapescarapharmacienseminepharmacyberlevagangaviikarugaula" +
	"rdalphiladelphiaareadmyblogsitephilatelyphoenixn--6frz82gphotogr" +
	"aphyogoris-an-actressaves-the-whalessandria-trani-barletta-andri" +
	"atranibarlettaandriapilotseoullensakerpinkzlgpippupiszmisawapitt" +
	"sburghofcfarsundyndns-webetsukubahcavuotnagaokakyotambadajozorau" +
	"mallorcadaquesakuragawapkommuneplanetariumisconfusedplantationpl" +
	"antservebbserveftparochesterplazaplchitosetogakushimotoganewport" +
	"lligatewayplorenskogplumbingpodhaleksvikomonopodlasiedlcepodzone" +
	"poltavaresearchaeologicalpomorzeszowpordenoneporsangerporsanguid" +
	"eporsgrunnanpoznanpreservationpresidioprincipesaro-urbino-pesaro" +
	"urbinopesaromantelekommunikationprivneprochowiceproductionprofer" +
	"mobaraprojectriesteamurskiptveterinaireggio-emiliapruszkowprzewo" +
	"rskogptzpartis-an-actorpvtroandinosaurepwpzwqsldshimonosekikawas" +
	"himosuwalkis-an-entertainershimotsukeshimotsumashingujolstershin" +
	"ichinanshinjoyoitakaokamchatkameokameyamashinashikiwildlifederat" +
	"ionshinjukumanoshinkamigotoyohashimotokorozawashinshinotsusakis-" +
	"byklebesbydgoszczecincinnationalfirearmsayokkaichirurgiens-denti" +
	"steshikagamiishikarikaturindalshinshiroshintokushimashintomikasa" +
	"harashinyoshitomiokaneyamazoeshiojirishirifujiedashioyanaizushir" +
	"ahamatonbetsusonoshirakoenigshiranukaniepceshiraois-certifieduca" +
	"torahimeshimageandsoundandvisionshiraokanmakiyokawarashiratakaha" +
	"gis-foundationshishikuis-goneshisokndalshisuifuettertdasnetzshit" +
	"aramashizukuishimofusaitokonamegatakatoris-into-animeguroshizuok" +
	"annamihoboleslawiechocolatelemarkatsushikabelaugustowadagestange" +
	"ologyshowasigdalsimbirskomvuxn--55qx5dsimple-urlsirdalslgslupsko" +
	"vestfoldsnzsolundsomasvuotnakayamasomnakhodkamogawasoosopotromsa" +
	"kakinokis-into-carschokoladensor-odalsor-varangersorfoldsorreisa" +
	"hayakawakamiichikaiseiyokoshibahikariwanumatakayamasortlandsorum" +
	"ishimatsuurasouthcarolinazawasouthwesterniiminamiashigarasowaspa" +
	"ce-to-rentromsolognespbaltimore-og-romsdalindaskimitsubatamiasta" +
	"rnbergjemnes3-ap-southeast-2spjelkavikonantanangerspydebergsquar" +
	"endalenvikingatlantakazakis-into-cartoonschoolkuszjetranbysrvest" +
	"neserviceservegame-servercellillesandiegoshikiminokamoenairguard" +
	"steinkjerusalembetsukuis-into-gamesaverdestjohnstjordalshalsenst" +
	"ockholmestrandstor-elvdalstordalstorenburgstorfjordstpetersburgs" +
	"tuff-4-salevangerstuttgartrusteesuzukanoyaltaijis-leetrani-andri" +
	"a-barletta-trani-andriasvalbardurhamburgsveiosvelvikongsbergsviz" +
	"zeraswidnicareersettsurreyswiebodzinderoyswinoujscienceandhistor" +
	"ysxn--6qq986b3xlvestre-totenris-lostfoldvestvagoyvevelstadvibo-v" +
	"alentiavibovalentiavideovinnicargojomediaphonefosshnvinnytsiavir" +
	"giniavirtualvirtuelviterboltularssonvladikavkazanvladimirumasaki" +
	"tchenvladivostokaizukarasjohkamiminershacknetrogstadvlogvolgogra" +
	"dvolkenkunderseaporturystykanumazuryvologdanskoninohembygdsforbu" +
	"ndvolyngdalvoronezhitomirvossevangenvrnvyatkarasjokonskowolansci" +
	"encecentersciencehistoryxn--9dbhblg6diamondshakotankomorotsukami" +
	"satohnoshooxn--andy-iraxn--aroport-byaotsuzakanonjis-not-certifi" +
	"edunetnedalxn--asky-iraxn--aurskog-hland-jnbarcelonagasakikonaio" +
	"irasecngjerdrumemorialinzaishobarakpetroleumessinatsukigatakasak" +
	"iheyakutiautomotivelandivtasvuodnaharimaniwakuratebinagisodegaur" +
	"austevollimanowarudasmatartcenterprisesakijogaszczytnord-odaltoa" +
	"digeiseiroudaegubalestrandabergamoarekepnorddalezajsk-uralsk12xn" +
	"--avery-yuasakegawaxn--b-5gaxn--bdddj-mrabdxn--bearalvhki-y4axn-" +
	"-berlevg-jxaxn--bhcavuotna-s4axn--bhccavuotna-k7axn--bidr-5nachi" +
	"katsuuraxn--bievt-0qaxn--bjarky-fyaroslavlaanderenxn--bjddar-pta" +
	"kinouexn--blt-elaborxn--bmlo-grajewolominamataketomisatokuyamaxn" +
	"--bod-2namsskoganeis-savedxn--brnny-wuaccident-investigationjuku" +
	"doyamaceratabusebastopologyeongbukooris-a-nascarfanxn--brnnysund" +
	"-m8accident-preventionlinebraskaunbieidsvollxn--brum-voagatuvarg" +
	"gatrysilkongsvingerxn--btsfjord-9zaxn--cg4bkis-slickhvestbyxn--c" +
	"iqpnxn--clchc0ea0b2g2a9gcdxn--comunicaes-v6a2oxn--correios-e-tel" +
	"ecomunicaes-ghc29axn--czrw28barreaudnedalnasushiobaravocataniaus" +
	"tinnarvikariyameiwamashikokuchuobanazawasnesoddenmarkhangelskjer" +
	"voyagemologicaliforniaomoriguchiharamliernewhampshirecreationarv" +
	"iikanagawaeroportalabamagasakishimabarahkkeravjudaicaarborteache" +
	"s-yogasawaragusartsaritsynarutokigawagrinethnologyekaterinburgdy" +
	"niagroks-theaternopilawakuyabukibichuozudmurtiamusementakkofuelv" +
	"erumbone12xn--davvenjrga-y4axn--dnna-grandrapidsharis-an-anarchi" +
	"storicalsocietysnesavonakatsugawaxn--drbak-wuaxn--dyry-iraxn--ev" +
	"eni-0qa01gaxn--finny-yuaxn--fiq228c5hshellaskoyabenord-fronxn--f" +
	"iq64barrel-of-knowledgeometre-experts-comptables3-fips-us-gov-we" +
	"st-1xn--fiqs8sherbrookegawaxn--fiqz9shimojis-an-artistavangerxn-" +
	"-fjord-lraxn--fl-ziaxn--flor-jraxn--fpcrj9c3dxn--frde-granexn--f" +
	"rna-woarais-uberleetraniandriabarlettatraniandriaxn--frya-hraxn-" +
	"-fzc2c9e2chofunatoristanore-og-uvdalucernexn--gecrj9chonangonohe" +
	"jis-a-chefastlyxn--ggaviika-8ya47hadanotteroyxn--gildeskl-g0axn-" +
	"-givuotna-8yasakaiminatonsbergxn--gjvik-wuaxn--gls-elachoseikaku" +
	"damatsuedtirollagrarboretuminamiechizenishimeraxn--gmq050is-very" +
	"-badaddjamisongdalenxn--gmqw5axn--h-2familyngenxn--h1aeghadselfi" +
	"parliamentoyosatomobeneventochiokinoshimalvikhersoniikappulawyxn" +
	"--h2brj9choshibukawaxn--hbmer-xqaxn--hcesuolo-7ya35barrell-of-kn" +
	"owledgeorgiavoues3-ap-southeast-1xn--hery-iraxn--hgebostad-g3axn" +
	"--hmmrfeasta-s4achoyodontexistmein-the-bandaiwafunewspaperxn--hn" +
	"efoss-q1axn--hobl-iraxn--holtlen-hxaxn--hpmir-xqaxn--hyanger-q1a" +
	"xn--hylandet-54axn--indery-fyasugis-very-evillagematsubarakawach" +
	"inaganoharaokinawashirosatobamagnitkagaminogiessengerdalstahauge" +
	"sundxn--io0a7is-very-gooddaxn--j1amhaebaruminanoxn--j6w193gxn--j" +
	"lster-byasuokarasuyamashikiyosemitexn--jrpeland-54axn--karmy-yua" +
	"xn--kfjord-iuaxn--klbu-woaxn--koluokta-7ya57hagaxn--kprw13dxn--k" +
	"pry57dxn--krager-gyatominamibosokamishihoronobeokamikoaniihamata" +
	"makawajimashikexn--kranghke-b0axn--krdsherad-m8axn--krehamn-dxax" +
	"n--krjohka-hwab49jevnakerxn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-" +
	"fyatsukaratexn--kvnangen-k0axn--l-1fareastcoastaldefencexn--lahe" +
	"adju-7yatsushiroxn--langevg-jxaxn--lcvr32dxn--ldingen-q1axn--lea" +
	"gaviika-52baselburgjerstadotsurugashimanxjeonnamerikawauembroide" +
	"ryokozemergencyclopedicartoonarteducationalchikugokasejnynysafet" +
	"ychyllestadnepropetrovskarmoyomitanobiraxn--lesund-huaxn--lgbbat" +
	"1ad8jewelryxn--lgrd-poachtraeumtgeradefenseljejuifauskedsmokorse" +
	"ttlementarnobrzegyptianpachigasakidsakyotanabellunordkappglogowi" +
	"ndmillukowloclawekatsuyamasoyxn--lhppi-xqaxn--linds-pratottoris-" +
	"very-nicexn--lns-qlarvikopervikmschweizhevskokonoexn--loabt-0qax" +
	"n--lrdal-sraxn--lrenskog-54axn--lt-liachungbukautokeinostrolekan" +
	"azawaxn--lten-granvindafjordxn--lury-iraxn--mely-iraxn--merker-k" +
	"uaxn--mgb2ddeshimokawaxn--mgb9awbferraraxn--mgba3a4f16axn--mgba3" +
	"a4franapleshimokitayamaxn--mgbaam7a8hagebostadxn--mgbayh7gpaduax" +
	"n--mgbbh1a71exn--mgbc0a9azcgxn--mgberp4a5d4a87gxn--mgberp4a5d4ar" +
	"xn--mgbqly7c0a67fbchungnamdalseidfjordyndns-wikinkobayashijonawa" +
	"texn--mgbqly7cvafranziskanerimarinexn--mgbtf8flandershimonitayan" +
	"agis-an-engineerxn--mjndalen-64axn--mk0axis-very-sweetranoyxn--m" +
	"latvuopmi-s4axn--mli-tlavagiskexn--mlselv-iuaxn--moreke-juaxn--m" +
	"osjen-eyawaraxn--mot-tlavangenxn--mre-og-romsdal-qqbashkiriaxn--" +
	"msy-ula0haibarakitahatakahatakaishimogosenxn--mtta-vrjjat-k7afet" +
	"sundxn--muost-0qaxn--mxtq1missileitungsenxn--ngbc5azdxn--nmesjev" +
	"uemie-tcbajddarchaeologyxn--nnx388axn--nodessakuhokksundxn--nry-" +
	"yla5gxn--nttery-byaesellsyourhomeipasadenakatombetsurnadalxn--nv" +
	"uotna-hwaxn--o3cw4hakatanohatakamatsukawaxn--od0algxn--od0aq3bat" +
	"ochigifuchukotkakamigaharaxn--ogbpf8flatangerxn--oppegrd-ixaxn--" +
	"ostery-fyawatahamaxn--osyro-wuaxn--p1ais-with-thebandovre-eikerx" +
	"n--pgbs0dhakodatexn--porsgu-sta26fgroks-thisayamanashichikashuku" +
	"jukuriyamaritimodalenxn--q9jyb4chuvashiaxn--rady-iraxn--rdal-poa" +
	"xn--rde-ulaxn--rdy-0nabarisleofmandalxn--rennesy-v1axn--rhkkervj" +
	"u-01afhskchristiansburgrongaxn--rholt-mragoworse-thandsondrioxn-" +
	"-rhqv96gxn--risa-5narashinoxn--risr-iraxn--rland-uuaxn--rlingen-" +
	"mxaxn--rmskog-byaxn--rros-gratangenxn--rskog-uuaxn--rst-0naritak" +
	"urashikisshikiwakunigamiharuslivinghistoryxn--rsta-francaisehara" +
	"xn--ryken-vuaxn--ryrvik-byaxn--s-1farmequipmentverdalxn--s9brj9c" +
	"iminamifuranostrowiecastresistancexn--sandnessjen-ogbatsfjordnip" +
	"ropetrovskarpaczeladz-1xn--sandy-yuaxn--seral-lraxn--sgne-grazxn" +
	"--skierv-utazaskvollxn--skjervy-v1axn--skjk-soaxn--sknit-yqaxn--" +
	"sknland-fxaxn--slat-5naroyxn--slt-elabourxn--smla-hraxn--smna-gr" +
	"axn--snase-nraxn--sndre-land-0cbgxn--snes-poaxn--snsa-roaxn--sr-" +
	"aurdal-l8axn--sr-fron-q1axn--sr-odal-q1axn--sr-varanger-ggbeppub" +
	"olognagasukesennumamurogawallonieruchomoscienceandindustrynation" +
	"alheritagepilepsyzranzanativeamericanantiques3-sa-east-1xn--srfo" +
	"ld-byaxn--srreisa-q1axn--srum-graxn--stfold-9xaxn--stjrdal-s1axn" +
	"--stjrdalshalsen-sqberlincolnaturalhistorymuseumcenterxn--stre-t" +
	"oten-zcbernrtamayukiitatebayashichinohekinannestadpaleoceanograp" +
	"hics3-us-gov-west-1xn--tjme-hraxn--tn0agrigentomologyeonggiehtav" +
	"uoatnagahamaroyerotikadenagaivuotnagakutechnologyeongnamegawakka" +
	"naibetsubamericanartanddesignieznodawaraholtalendoftheinternetcm" +
	"wxn--tnsberg-q1axn--trany-yuaxn--trgstad-r1axn--trna-woaxn--trom" +
	"s-zuaxn--tysvr-vraxn--uc0atvedestrandxn--uc0ay4axn--unjrga-rtaki" +
	"zawaxn--unup4yxn--vads-jraxn--vard-jraxn--vegrshei-c0axn--vestvg" +
	"y-ixa6oxn--vg-yiabeskidyn-o-saurlandebuildingjesdalipetskaruizaw" +
	"axn--vgan-qoaxn--vgsy-qoa0jewishartransportrapaniizaxn--vhquvest" +
	"re-slidreamhostersevastopolelxn--vler-qoaxn--vre-eiker-k8axn--vr" +
	"ggt-xqadxn--vry-yla5gxn--wcvs22dxn--wgbh1circuscultureggioemilia" +
	"xn--wgbl6axn--xkc2al3hye2axn--xkc2dl3a5ee0hakonexn--yer-znarusaw" +
	"axn--yfro4i67oxn--ygarden-p1axn--ygbi2ammxn--80asehdbambleangavi" +
	"ikagoshimalselvendrellindesnes3-eu-west-1xn--ystre-slidre-ujbeta" +
	"inaboxfordeatnuorockartuzyonabarullensvangjovikarumaintenancevje" +
	"-og-hornnessetagayaseljordrangedalivornoceanographiquebecasadela" +
	"monedaxn--zf0ao64axn--zf0avxn--80aswgxxxn--90a3academykolaivano-" +
	"frankivskiervaapsteiermarkonyvelomzaporizhzhiaxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x01a028c2, // n0x0000 c0x0006 (n0x0171-n0x0177)  + I ac
	0x01e02742, // n0x0001 c0x0007 (n0x0177-n0x0178)  + I ad
	0x02213e42, // n0x0002 c0x0008 (n0x0178-n0x017f)  + I ae
	0x026251c4, // n0x0003 c0x0009 (n0x017f-n0x01d8)  + I aero
	0x02a07402, // n0x0004 c0x000a (n0x01d8-n0x01dd)  + I af
	0x02e04882, // n0x0005 c0x000b (n0x01dd-n0x01e2)  + I ag
	0x03200582, // n0x0006 c0x000c (n0x01e2-n0x01e6)  + I ai
	0x03601dc2, // n0x0007 c0x000d (n0x01e6-n0x01ec)  + I al
	0x00200dc2, // n0x0008 c0x0000 (---------------)  + I am
	0x03a00a82, // n0x0009 c0x000e (n0x01ec-n0x01f0)  + I an
	0x03e00d02, // n0x000a c0x000f (n0x01f0-n0x01f6)  + I ao
	0x00269742, // n0x000b c0x0000 (---------------)  + I aq
	0x04203902, // n0x000c c0x0010 (n0x01f6-n0x01fe)  + I ar
	0x04b39284, // n0x000d c0x0012 (n0x01ff-n0x0205)  o I arpa
	0x04e00182, // n0x000e c0x0013 (n0x0205-n0x0206)  + I as
	0x00237a04, // n0x000f c0x0000 (---------------)  + I asia
	0x05200982, // n0x0010 c0x0014 (n0x0206-n0x020d)  + I at
	0x05a08742, // n0x0011 c0x0016 (n0x020e-n0x0221)  o I au
	0x06a00102, // n0x0012 c0x001a (n0x0231-n0x0232)  + I aw
	0x0023bf42, // n0x0013 c0x0000 (---------------)  + I ax
	0x06e0b342, // n0x0014 c0x001b (n0x0232-n0x023e)  + I az
	0x07201242, // n0x0015 c0x001c (n0x023e-n0x0248)  + I ba
	0x07639782, // n0x0016 c0x001d (n0x0248-n0x0250)  + I bb
	0x016ee802, // n0x0017 c0x0005 (---------------)* o I bd
	0x07a03042, // n0x0018 c0x001e (n0x0250-n0x0252)  + I be
	0x07f21802, // n0x0019 c0x001f (n0x0252-n0x0253)  + I bf
	0x0833c7c2, // n0x001a c0x0020 (n0x0253-n0x0277)  + I bg
	0x08617382, // n0x001b c0x0021 (n0x0277-n0x027c)  + I bh
	0x08a00002, // n0x001c c0x0022 (n0x027c-n0x0281)  + I bi
	0x002054c4, // n0x001d c0x0000 (---------------)  + I bike
	0x08eb5183, // n0x001e c0x0023 (n0x0281-n0x0288)  + I biz
	0x0920eb42, // n0x001f c0x0024 (n0x0288-n0x028c)  + I bj
	0x09610682, // n0x0020 c0x0025 (n0x028c-n0x0291)  + I bm
	0x016a96c2, // n0x0021 c0x0005 (---------------)* o I bn
	0x09a07c82, // n0x0022 c0x0026 (n0x0291-n0x029a)  + I bo
	0x09e03e42, // n0x0023 c0x0027 (n0x029a-n0x02df)  + I br
	0x0a6092c2, // n0x0024 c0x0029 (n0x02e0-n0x02e5)  + I bs
	0x0aa39ac2, // n0x0025 c0x002a (n0x02e5-n0x02ea)  + I bt
	0x00223944, // n0x0026 c0x0000 (---------------)  + I buzz
	0x0ae25582, // n0x0027 c0x002b (n0x02ea-n0x02ec)  + I bw
	0x0b214082, // n0x0028 c0x002c (n0x02ec-n0x02f0)  + I by
	0x0b625d42, // n0x0029 c0x002d (n0x02f0-n0x02f5)  + I bz
	0x0ba00402, // n0x002a c0x002e (n0x02f5-n0x0306)  + I ca
	0x0026eac6, // n0x002b c0x0000 (---------------)  + I camera
	0x002e0286, // n0x002c c0x0000 (---------------)  + I career
	0x002e0287, // n0x002d c0x0000 (---------------)  + I careers
	0x00201b43, // n0x002e c0x0000 (---------------)  + I cat
	0x0be01942, // n0x002f c0x002f (n0x0306-n0x030a)  + I cc
	0x0c2f6602, // n0x0030 c0x0030 (n0x030a-n0x030b)  + I cd
	0x0c6bf202, // n0x0031 c0x0031 (n0x030b-n0x030c)  + I cf
	0x002154c2, // n0x0032 c0x0000 (---------------)  + I cg
	0x0ca00a02, // n0x0033 c0x0032 (n0x030c-n0x030d)  + I ch
	0x0ce01e82, // n0x0034 c0x0033 (n0x030d-n0x031c)  + I ci
	0x0d200c02, // n0x0035 c0x0034 (n0x031c-n0x031d)* o I ck
	0x0d600b42, // n0x0036 c0x0035 (n0x031d-n0x0321)  + I cl
	0x00229988, // n0x0037 c0x0000 (---------------)  + I clothing
	0x0db45f82, // n0x0038 c0x0036 (n0x0321-n0x0322)  + I cm
	0x0de2dc82, // n0x0039 c0x0037 (n0x0322-n0x034e)  + I cn
	0x0e208f82, // n0x003a c0x0038 (n0x034e-n0x035b)  + I co
	0x0e6104c3, // n0x003b c0x0039 (n0x035b-n0x0414)  + I com
	0x002322cc, // n0x003c c0x0000 (---------------)  + I construction
	0x0023518b, // n0x003d c0x0000 (---------------)  + I contractors
	0x00236044, // n0x003e c0x0000 (---------------)  + I coop
	0x0f639282, // n0x003f c0x003d (n0x0435-n0x043c)  + I cr
	0x0fa06482, // n0x0040 c0x003e (n0x043c-n0x0442)  + I cu
	0x0ff17902, // n0x0041 c0x003f (n0x0442-n0x0443)  + I cv
	0x1032d3c2, // n0x0042 c0x0040 (n0x0443-n0x0447)  + I cw
	0x1063cb02, // n0x0043 c0x0041 (n0x0447-n0x0449)  + I cx
	0x0163d302, // n0x0044 c0x0005 (---------------)* o I cy
	0x10a026c2, // n0x0045 c0x0042 (n0x0449-n0x044a)  + I cz
	0x10e09102, // n0x0046 c0x0043 (n0x044a-n0x0452)  + I de
	0x002e7908, // n0x0047 c0x0000 (---------------)  + I diamonds
	0x002a82c9, // n0x0048 c0x0000 (---------------)  + I directory
	0x00203782, // n0x0049 c0x0000 (---------------)  + I dj
	0x11295182, // n0x004a c0x0044 (n0x0452-n0x0453)  + I dk
	0x11644cc2, // n0x004b c0x0045 (n0x0453-n0x0458)  + I dm
	0x11a1a1c2, // n0x004c c0x0046 (n0x0458-n0x0462)  + I do
	0x11e60242, // n0x004d c0x0047 (n0x0462-n0x046a)  + I dz
	0x12201902, // n0x004e c0x0048 (n0x046a-n0x0476)  + I ec
	0x002ceec3, // n0x004f c0x0000 (---------------)  + I edu
	0x1260b9c2, // n0x0050 c0x0049 (n0x0476-n0x0480)  + I ee
	0x12a1a842, // n0x0051 c0x004a (n0x0480-n0x0489)  + I eg
	0x002ec70b, // n0x0052 c0x0000 (---------------)  + I enterprises
	0x00337989, // n0x0053 c0x0000 (---------------)  + I equipment
	0x016004c2, // n0x0054 c0x0005 (---------------)* o I er
	0x12e016c2, // n0x0055 c0x004b (n0x0489-n0x048e)  + I es
	0x0026efc6, // n0x0056 c0x0000 (---------------)  + I estate
	0x016013c2, // n0x0057 c0x0005 (---------------)* o I et
	0x0020f502, // n0x0058 c0x0000 (---------------)  + I eu
	0x13601ac2, // n0x0059 c0x004d (n0x048f-n0x0492)  + I fi
	0x01607442, // n0x005a c0x0005 (---------------)* o I fj
	0x0168fd02, // n0x005b c0x0005 (---------------)* o I fk
	0x00332782, // n0x005c c0x0000 (---------------)  + I fm
	0x00218142, // n0x005d c0x0000 (---------------)  + I fo
	0x13a108c2, // n0x005e c0x004e (n0x0492-n0x04aa)  + I fr
	0x0026bf86, // n0x005f c0x0000 (---------------)  + I futbol
	0x002008c2, // n0x0060 c0x0000 (---------------)  + I ga
	0x00234c47, // n0x0061 c0x0000 (---------------)  + I gallery
	0x0020bf02, // n0x0062 c0x0000 (---------------)  + I gd
	0x13e01302, // n0x0063 c0x004f (n0x04aa-n0x04b1)  + I ge
	0x00223dc2, // n0x0064 c0x0000 (---------------)  + I gf
	0x14207942, // n0x0065 c0x0050 (n0x04b1-n0x04b6)  + I gg
	0x1462e502, // n0x0066 c0x0051 (n0x04b6-n0x04bb)  + I gh
	0x14a17c02, // n0x0067 c0x0052 (n0x04bb-n0x04c1)  + I gi
	0x002088c2, // n0x0068 c0x0000 (---------------)  + I gl
	0x00229b42, // n0x0069 c0x0000 (---------------)  + I gm
	0x14e0fb82, // n0x006a c0x0053 (n0x04c1-n0x04c7)  o I gn
	0x002150c3, // n0x006b c0x0000 (---------------)  + I gov
	0x152bce02, // n0x006c c0x0054 (n0x04c7-n0x04cd)  + I gp
	0x0022d302, // n0x006d c0x0000 (---------------)  + I gq
	0x156063c2, // n0x006e c0x0055 (n0x04cd-n0x04d3)  + I gr
	0x00342f08, // n0x006f c0x0000 (---------------)  + I graphics
	0x00223142, // n0x0070 c0x0000 (---------------)  + I gs
	0x15a002c2, // n0x0071 c0x0056 (n0x04d3-n0x04da)  + I gt
	0x01607f02, // n0x0072 c0x0005 (---------------)* o I gu
	0x002c3f05, // n0x0073 c0x0000 (---------------)  + I guide
	0x002673c4, // n0x0074 c0x0000 (---------------)  + I guru
	0x00229f02, // n0x0075 c0x0000 (---------------)  + I gw
	0x15e03f82, // n0x0076 c0x0057 (n0x04da-n0x04dd)  + I gy
	0x1622e542, // n0x0077 c0x0058 (n0x04dd-n0x04f3)  + I hk
	0x00271702, // n0x0078 c0x0000 (---------------)  + I hm
	0x16664042, // n0x0079 c0x0059 (n0x04f3-n0x04f9)  + I hn
	0x002886c8, // n0x007a c0x0000 (---------------)  + I holdings
	0x16a1a6c2, // n0x007b c0x005a (n0x04f9-n0x04fd)  + I hr
	0x16e0a5c2, // n0x007c c0x005b (n0x04fd-n0x050e)  + I ht
	0x1723d6c2, // n0x007d c0x005c (n0x050e-n0x052e)  + I hu
	0x1760ab82, // n0x007e c0x005d (n0x052e-n0x0538)  + I id
	0x17a00042, // n0x007f c0x005e (n0x0538-n0x053a)  + I ie
	0x17e05682, // n0x0080 c0x005f (n0x053a-n0x053b)* o I il
	0x1860e682, // n0x0081 c0x0061 (n0x053c-n0x0542)  + I im
	0x18e00242, // n0x0082 c0x0063 (n0x0544-n0x0551)  + I in
	0x192180c4, // n0x0083 c0x0064 (n0x0551-n0x055b)  + I info
	0x1961fe43, // n0x0084 c0x0065 (n0x055b-n0x055c)  + I int
	0x19a01c02, // n0x0085 c0x0066 (n0x055c-n0x055e)  + I io
	0x19e2f482, // n0x0086 c0x0067 (n0x055e-n0x0564)  + I iq
	0x1a204fc2, // n0x0087 c0x0068 (n0x0564-n0x056d)  + I ir
	0x1a6005c2, // n0x0088 c0x0069 (n0x056d-n0x0573)  + I is
	0x1aa034c2, // n0x0089 c0x006a (n0x0573-n0x0689)  + I it
	0x1ae0f782, // n0x008a c0x006b (n0x0689-n0x068e)  + I je
	0x01743602, // n0x008b c0x0005 (---------------)* o I jm
	0x1b207182, // n0x008c c0x006c (n0x068e-n0x0696)  + I jo
	0x00285dc4, // n0x008d c0x0000 (---------------)  + I jobs
	0x1b690082, // n0x008e c0x006d (n0x0696-n0x06d6)  + I jp
	0x01601682, // n0x008f c0x0005 (---------------)* o I ke
	0x29243242, // n0x0090 c0x00a4 (n0x0d6c-n0x0d72)  + I kg
	0x01644dc2, // n0x0091 c0x0005 (---------------)* o I kh
	0x296007c2, // n0x0092 c0x00a5 (n0x0d72-n0x0d79)  + I ki
	0x00235c03, // n0x0093 c0x0000 (---------------)  + I kim
	0x002e3f87, // n0x0094 c0x0000 (---------------)  + I kitchen
	0x002c9c44, // n0x0095 c0x0000 (---------------)  + I kiwi
	0x29b1e782, // n0x0096 c0x00a6 (n0x0d79-n0x0d8a)  + I km
	0x29e3ec82, // n0x0097 c0x00a7 (n0x0d8a-n0x0d8e)  + I kn
	0x2a226ac2, // n0x0098 c0x00a8 (n0x0d8e-n0x0d94)  o I kp
	0x2a603b82, // n0x0099 c0x00a9 (n0x0d94-n0x0db2)  + I kr
	0x016a5c42, // n0x009a c0x0005 (---------------)* o I kw
	0x2aa1ed02, // n0x009b c0x00aa (n0x0db2-n0x0db7)  + I ky
	0x2aebea42, // n0x009c c0x00ab (n0x0db7-n0x0dbd)  + I kz
	0x2b2000c2, // n0x009d c0x00ac (n0x0dbd-n0x0dc6)  + I la
	0x00203984, // n0x009e c0x0000 (---------------)  + I land
	0x2b6056c2, // n0x009f c0x00ad (n0x0dc6-n0x0dcb)  o I lb
	0x2ba13702, // n0x00a0 c0x00ae (n0x0dcb-n0x0dd1)  + I lc
	0x00208d42, // n0x00a1 c0x0000 (---------------)  + I li
	0x00241cc8, // n0x00a2 c0x0000 (---------------)  + I lighting
	0x2be1d042, // n0x00a3 c0x00af (n0x0dd1-n0x0ddf)  + I lk
	0x2c26c8c2, // n0x00a4 c0x00b0 (n0x0ddf-n0x0de4)  o I lr
	0x2c601e02, // n0x00a5 c0x00b1 (n0x0de4-n0x0de6)  + I ls
	0x2ca06502, // n0x00a6 c0x00b2 (n0x0de6-n0x0de7)  + I lt
	0x00209882, // n0x00a7 c0x0000 (---------------)  + I lu
	0x2ce03242, // n0x00a8 c0x00b3 (n0x0de7-n0x0df0)  + I lv
	0x2d25d282, // n0x00a9 c0x00b4 (n0x0df0-n0x0df9)  + I ly
	0x2d600742, // n0x00aa c0x00b5 (n0x0df9-n0x0dff)  + I ma
	0x2dac95c2, // n0x00ab c0x00b6 (n0x0dff-n0x0e01)  + I mc
	0x002106c2, // n0x00ac c0x0000 (---------------)  + I md
	0x2de08202, // n0x00ad c0x00b7 (n0x0e01-n0x0e09)  + I me
	0x00299044, // n0x00ae c0x0000 (---------------)  + I menu
	0x2e321182, // n0x00af c0x00b8 (n0x0e09-n0x0e11)  + I mg
	0x00310882, // n0x00b0 c0x0000 (---------------)  + I mh
	0x0025f683, // n0x00b1 c0x0000 (---------------)  + I mil
	0x2e726902, // n0x00b2 c0x00b9 (n0x0e11-n0x0e18)  + I mk
	0x2ea11a82, // n0x00b3 c0x00ba (n0x0e18-n0x0e1f)  + I ml
	0x01614a82, // n0x00b4 c0x0005 (---------------)* o I mm
	0x2ee03cc2, // n0x00b5 c0x00bb (n0x0e1f-n0x0e23)  + I mn
	0x2f20a782, // n0x00b6 c0x00bc (n0x0e23-n0x0e28)  + I mo
	0x0020adc4, // n0x00b7 c0x0000 (---------------)  + I mobi
	0x0023ae86, // n0x00b8 c0x0000 (---------------)  + I monash
	0x00202e42, // n0x00b9 c0x0000 (---------------)  + I mp
	0x00307d02, // n0x00ba c0x0000 (---------------)  + I mq
	0x2f63d382, // n0x00bb c0x00bd (n0x0e28-n0x0e2a)  + I mr
	0x00222fc2, // n0x00bc c0x0000 (---------------)  + I ms
	0x01652e82, // n0x00bd c0x0005 (---------------)* o I mt
	0x2fa04a82, // n0x00be c0x00be (n0x0e2a-n0x0e31)  + I mu
	0x2feb9786, // n0x00bf c0x00bf (n0x0e31-n0x1055)  + I museum
	0x3021adc2, // n0x00c0 c0x00c0 (n0x1055-n0x1063)  + I mv
	0x30745fc2, // n0x00c1 c0x00c1 (n0x1063-n0x106e)  + I mw
	0x30b2a542, // n0x00c2 c0x00c2 (n0x106e-n0x1074)  + I mx
	0x30e246c2, // n0x00c3 c0x00c3 (n0x1074-n0x107b)  + I my
	0x31353842, // n0x00c4 c0x00c4 (n0x107b-n0x107c)* o I mz
	0x31601c82, // n0x00c5 c0x00c5 (n0x107c-n0x108d)  + I na
	0x31ad16c4, // n0x00c6 c0x00c6 (n0x108d-n0x108f)  + I name
	0x32601f42, // n0x00c7 c0x00c9 (n0x1091-n0x1092)  + I nc
	0x00205f42, // n0x00c8 c0x0000 (---------------)  + I ne
	0x32a39bc3, // n0x00c9 c0x00ca (n0x1092-n0x10bd)  + I net
	0x33a18102, // n0x00ca c0x00ce (n0x10c4-n0x10ce)  + I nf
	0x33e00282, // n0x00cb c0x00cf (n0x10ce-n0x10d7)  + I ng
	0x01601002, // n0x00cc c0x0005 (---------------)* o I ni
	0x34231642, // n0x00cd c0x00d0 (n0x10d7-n0x10da)  + I nl
	0x346006c2, // n0x00ce c0x00d1 (n0x10da-n0x13b0)  + I no
	0x01614642, // n0x00cf c0x0005 (---------------)* o I np
	0x3ca10ac2, // n0x00d0 c0x00f2 (n0x13d8-n0x13df)  + I nr
	0x3ce52942, // n0x00d1 c0x00f3 (n0x13df-n0x13e2)  + I nu
	0x3d227942, // n0x00d2 c0x00f4 (n0x13e2-n0x13e3)* o I nz
	0x3da00702, // n0x00d3 c0x00f6 (n0x13e4-n0x13f7)  + I om
	0x00231603, // n0x00d4 c0x0000 (---------------)  + I onl
	0x3de453c3, // n0x00d5 c0x00f7 (n0x13f7-n0x142c)  + I org
	0x0027a286, // n0x00d6 c0x0000 (---------------)  + I otsuka
	0x3e611382, // n0x00d7 c0x00f9 (n0x142e-n0x1439)  + I pa
	0x3ea08682, // n0x00d8 c0x00fa (n0x1439-n0x1440)  + I pe
	0x3ef2e842, // n0x00d9 c0x00fb (n0x1440-n0x1443)  + I pf
	0x0171ce02, // n0x00da c0x0005 (---------------)* o I pg
	0x3f298042, // n0x00db c0x00fc (n0x1443-n0x144b)  + I ph
	0x002bce4b, // n0x00dc c0x0000 (---------------)  + I photography
	0x002be984, // n0x00dd c0x0000 (---------------)  + I pink
	0x3f6c05c2, // n0x00de c0x00fd (n0x144b-n0x1459)  + I pk
	0x3fa0dcc2, // n0x00df c0x00fe (n0x1459-n0x1504)  + I pl
	0x002c2508, // n0x00e0 c0x0000 (---------------)  + I plumbing
	0x002714c2, // n0x00e1 c0x0000 (---------------)  + I pm
	0x402900c2, // n0x00e2 c0x0100 (n0x150d-n0x1512)  + I pn
	0x00214684, // n0x00e3 c0x0000 (---------------)  + I post
	0x4060e2c2, // n0x00e4 c0x0101 (n0x1512-n0x151f)  + I pr
	0x40ac5983, // n0x00e5 c0x0102 (n0x151f-n0x1526)  + I pro
	0x40e21942, // n0x00e6 c0x0103 (n0x1526-n0x152d)  + I ps
	0x412c6682, // n0x00e7 c0x0104 (n0x152d-n0x1536)  + I pt
	0x416c79c2, // n0x00e8 c0x0105 (n0x1536-n0x153c)  + I pw
	0x41ab9182, // n0x00e9 c0x0106 (n0x153c-n0x1543)  + I py
	0x41ef04c2, // n0x00ea c0x0107 (n0x1543-n0x154b)  + I qa
	0x42202142, // n0x00eb c0x0108 (n0x154b-n0x154f)  + I re
	0x00268ec7, // n0x00ec c0x0000 (---------------)  + I reviews
	0x42603a82, // n0x00ed c0x0109 (n0x154f-n0x155b)  + I ro
	0x42a08082, // n0x00ee c0x010a (n0x155b-n0x1561)  + I rs
	0x42e03e82, // n0x00ef c0x010b (n0x1561-n0x15e6)  + I ru
	0x002a0744, // n0x00f0 c0x0000 (---------------)  + I ruhr
	0x432083c2, // n0x00f1 c0x010c (n0x15e6-n0x15ef)  + I rw
	0x43600cc2, // n0x00f2 c0x010d (n0x15ef-n0x15f7)  + I sa
	0x43a31c42, // n0x00f3 c0x010e (n0x15f7-n0x15fc)  + I sb
	0x43e01e42, // n0x00f4 c0x010f (n0x15fc-n0x1601)  + I sc
	0x4424db82, // n0x00f5 c0x0110 (n0x1601-n0x1609)  + I sd
	0x44600482, // n0x00f6 c0x0111 (n0x1609-n0x1632)  + I se
	0x0020e3c4, // n0x00f7 c0x0000 (---------------)  + I sexy
	0x44a03f42, // n0x00f8 c0x0112 (n0x1632-n0x1639)  + I sg
	0x44e001c2, // n0x00f9 c0x0113 (n0x1639-n0x163e)  + I sh
	0x00229205, // n0x00fa c0x0000 (---------------)  + I shoes
	0x00205a42, // n0x00fb c0x0000 (---------------)  + I si
	0x0021e307, // n0x00fc c0x0000 (---------------)  + I singles
	0x452033c2, // n0x00fd c0x0114 (n0x163e-n0x163f)  + I sk
	0x4561ef02, // n0x00fe c0x0115 (n0x163f-n0x1644)  + I sl
	0x00215b42, // n0x00ff c0x0000 (---------------)  + I sm
	0x45a02002, // n0x0100 c0x0116 (n0x1644-n0x164b)  + I sn
	0x45e02fc2, // n0x0101 c0x0117 (n0x164b-n0x164e)  + I so
	0x002b1502, // n0x0102 c0x0000 (---------------)  + I sr
	0x46202482, // n0x0103 c0x0118 (n0x164e-n0x165a)  + I st
	0x00203102, // n0x0104 c0x0000 (---------------)  + I su
	0x46601702, // n0x0105 c0x0119 (n0x165a-n0x165f)  + I sv
	0x46ae1042, // n0x0106 c0x011a (n0x165f-n0x1660)  + I sx
	0x46e63e42, // n0x0107 c0x011b (n0x1660-n0x1666)  + I sy
	0x47202642, // n0x0108 c0x011c (n0x1666-n0x1669)  + I sz
	0x00238006, // n0x0109 c0x0000 (---------------)  + I tattoo
	0x002009c2, // n0x010a c0x0000 (---------------)  + I tc
	0x47609bc2, // n0x010b c0x011d (n0x1669-n0x166a)  + I td
	0x003449ca, // n0x010c c0x0000 (---------------)  + I technology
	0x002103c3, // n0x010d c0x0000 (---------------)  + I tel
	0x002257c2, // n0x010e c0x0000 (---------------)  + I tf
	0x00234c02, // n0x010f c0x0000 (---------------)  + I tg
	0x47a095c2, // n0x0110 c0x011e (n0x166a-n0x1671)  + I th
	0x002218c4, // n0x0111 c0x0000 (---------------)  + I tips
	0x47e3fb82, // n0x0112 c0x011f (n0x1671-n0x1680)  + I tj
	0x00294842, // n0x0113 c0x0000 (---------------)  + I tk
	0x48209002, // n0x0114 c0x0120 (n0x1680-n0x1681)  + I tl
	0x4863d502, // n0x0115 c0x0121 (n0x1681-n0x1689)  + I tm
	0x48a0ff42, // n0x0116 c0x0122 (n0x1689-n0x169d)  + I tn
	0x48e00302, // n0x0117 c0x0123 (n0x169d-n0x16a3)  + I to
	0x0020d705, // n0x0118 c0x0000 (---------------)  + I today
	0x49209942, // n0x0119 c0x0124 (n0x16a3-n0x16a5)* o I tr
	0x0029ed06, // n0x011a c0x0000 (---------------)  + I travel
	0x49a03502, // n0x011b c0x0126 (n0x16a6-n0x16b7)  + I tt
	0x49e7ecc2, // n0x011c c0x0127 (n0x16b7-n0x16bb)  + I tv
	0x4a247802, // n0x011d c0x0128 (n0x16bb-n0x16c9)  + I tw
	0x4a639c42, // n0x011e c0x0129 (n0x16c9-n0x16d5)  o I tz
	0x4aa697c2, // n0x011f c0x012a (n0x16d5-n0x1723)  + I ua
	0x4ae00882, // n0x0120 c0x012b (n0x1723-n0x172b)  + I ug
	0x4b203ec2, // n0x0121 c0x012c (n0x172b-n0x1736)* o I uk
	0x0021a4c3, // n0x0122 c0x0000 (---------------)  + I uno
	0x4ba02342, // n0x0123 c0x012e (n0x1737-n0x1776)  + I us
	0x59e1d142, // n0x0124 c0x0167 (n0x181d-n0x1823)  + I uy
	0x5a204d42, // n0x0125 c0x0168 (n0x1823-n0x1827)  + I uz
	0x00202b82, // n0x0126 c0x0000 (---------------)  + I va
	0x5a633d02, // n0x0127 c0x0169 (n0x1827-n0x182d)  + I vc
	0x5aa05902, // n0x0128 c0x016a (n0x182d-n0x1837)  + I ve
	0x002355c8, // n0x0129 c0x0000 (---------------)  + I ventures
	0x002579c2, // n0x012a c0x0000 (---------------)  + I vg
	0x5ae0afc2, // n0x012b c0x016b (n0x1837-n0x183c)  + I vi
	0x5b213cc2, // n0x012c c0x016c (n0x183c-n0x1848)  + I vn
	0x002f9006, // n0x012d c0x0000 (---------------)  + I voyage
	0x00201742, // n0x012e c0x0000 (---------------)  + I vu
	0x00289f83, // n0x012f c0x0000 (---------------)  + I wed
	0x0022d5c2, // n0x0130 c0x0000 (---------------)  + I wf
	0x5b61c282, // n0x0131 c0x016d (n0x1848-n0x184f)  + I ws
	0x0023cb4b, // n0x0132 c0x0000 (---------------)  + I xn--3bst00m
	0x0025b64b, // n0x0133 c0x0000 (---------------)  + I xn--3ds443g
	0x0026928c, // n0x0134 c0x0000 (---------------)  + I xn--3e0b707e
	0x0027f64b, // n0x0135 c0x0000 (---------------)  + I xn--45brj9c
	0x0028930a, // n0x0136 c0x0000 (---------------)  + I xn--4gbrim
	0x0028988e, // n0x0137 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x002bcb8b, // n0x0138 c0x0000 (---------------)  + I xn--6frz82g
	0x002e108e, // n0x0139 c0x0000 (---------------)  + I xn--6qq986b3xl
	0x0034ea4c, // n0x013a c0x0000 (---------------)  + I xn--80asehdb
	0x003526ca, // n0x013b c0x0000 (---------------)  + I xn--80aswg
	0x003529ca, // n0x013c c0x0000 (---------------)  + I xn--90a3ac
	0x002f58ca, // n0x013d c0x0000 (---------------)  + I xn--cg4bki
	0x002f6116, // n0x013e c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x002ff60e, // n0x013f c0x0000 (---------------)  + I xn--fiq228c5hs
	0x002ffeca, // n0x0140 c0x0000 (---------------)  + I xn--fiq64b
	0x0030110a, // n0x0141 c0x0000 (---------------)  + I xn--fiqs8s
	0x003016ca, // n0x0142 c0x0000 (---------------)  + I xn--fiqz9s
	0x0030280d, // n0x0143 c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x00303f4d, // n0x0144 c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x00304a8b, // n0x0145 c0x0000 (---------------)  + I xn--gecrj9c
	0x00309f8b, // n0x0146 c0x0000 (---------------)  + I xn--h2brj9c
	0x003106c9, // n0x0147 c0x0000 (---------------)  + I xn--j1amh
	0x00310c0b, // n0x0148 c0x0000 (---------------)  + I xn--j6w193g
	0x00312c0b, // n0x0149 c0x0000 (---------------)  + I xn--kprw13d
	0x00312ecb, // n0x014a c0x0000 (---------------)  + I xn--kpry57d
	0x0031ad8f, // n0x014b c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x0032108c, // n0x014c c0x0000 (---------------)  + I xn--mgb2ddes
	0x0032158c, // n0x014d c0x0000 (---------------)  + I xn--mgb9awbf
	0x00321a0f, // n0x014e c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x00321dce, // n0x014f c0x0000 (---------------)  + I xn--mgba3a4fra
	0x003225ce, // n0x0150 c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x00322b8e, // n0x0151 c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x00322fce, // n0x0152 c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0032334f, // n0x0153 c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x00323713, // n0x0154 c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x00323bd1, // n0x0155 c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x00324013, // n0x0156 c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x00325090, // n0x0157 c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x003258cc, // n0x0158 c0x0000 (---------------)  + I xn--mgbtf8fl
	0x0032aa4c, // n0x0159 c0x0000 (---------------)  + I xn--ngbc5azd
	0x0032b60b, // n0x015a c0x0000 (---------------)  + I xn--nnx388a
	0x0032b8c8, // n0x015b c0x0000 (---------------)  + I xn--node
	0x0032d24a, // n0x015c c0x0000 (---------------)  + I xn--o3cw4h
	0x0032e68c, // n0x015d c0x0000 (---------------)  + I xn--ogbpf8fl
	0x0032f7c8, // n0x015e c0x0000 (---------------)  + I xn--p1ai
	0x0032ffcb, // n0x015f c0x0000 (---------------)  + I xn--pgbs0dh
	0x0033154b, // n0x0160 c0x0000 (---------------)  + I xn--q9jyb4c
	0x00333f4b, // n0x0161 c0x0000 (---------------)  + I xn--rhqv96g
	0x00337d4b, // n0x0162 c0x0000 (---------------)  + I xn--s9brj9c
	0x0034810a, // n0x0163 c0x0000 (---------------)  + I xn--unup4y
	0x0034ad09, // n0x0164 c0x0000 (---------------)  + I xn--vhquv
	0x0034c80a, // n0x0165 c0x0000 (---------------)  + I xn--wgbh1c
	0x0034d00a, // n0x0166 c0x0000 (---------------)  + I xn--wgbl6a
	0x0034d290, // n0x0167 c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x0034d691, // n0x0168 c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x0034e04d, // n0x0169 c0x0000 (---------------)  + I xn--yfro4i67o
	0x0034e74d, // n0x016a c0x0000 (---------------)  + I xn--ygbi2ammx
	0x00352943, // n0x016b c0x0000 (---------------)  + I xxx
	0x01619502, // n0x016c c0x0005 (---------------)* o I ye
	0x00255382, // n0x016d c0x0000 (---------------)  + I yt
	0x01602702, // n0x016e c0x0005 (---------------)* o I za
	0x016bed42, // n0x016f c0x0005 (---------------)* o I zm
	0x016c7a82, // n0x0170 c0x0005 (---------------)* o I zw
	0x002104c3, // n0x0171 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0172 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0173 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0174 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0175 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0176 c0x0000 (---------------)  + I org
	0x002006c3, // n0x0177 c0x0000 (---------------)  + I nom
	0x002028c2, // n0x0178 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x0179 c0x0000 (---------------)  + I co
	0x002150c3, // n0x017a c0x0000 (---------------)  + I gov
	0x0025f683, // n0x017b c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x017c c0x0000 (---------------)  + I net
	0x002453c3, // n0x017d c0x0000 (---------------)  + I org
	0x00204343, // n0x017e c0x0000 (---------------)  + I sch
	0x002f2996, // n0x017f c0x0000 (---------------)  + I accident-investigation
	0x002f40d3, // n0x0180 c0x0000 (---------------)  + I accident-prevention
	0x002251c9, // n0x0181 c0x0000 (---------------)  + I aerobatic
	0x00259bc8, // n0x0182 c0x0000 (---------------)  + I aeroclub
	0x00290f09, // n0x0183 c0x0000 (---------------)  + I aerodrome
	0x002366c6, // n0x0184 c0x0000 (---------------)  + I agents
	0x00259310, // n0x0185 c0x0000 (---------------)  + I air-surveillance
	0x002659d3, // n0x0186 c0x0000 (---------------)  + I air-traffic-control
	0x00261ac8, // n0x0187 c0x0000 (---------------)  + I aircraft
	0x002855c7, // n0x0188 c0x0000 (---------------)  + I airline
	0x0029fb87, // n0x0189 c0x0000 (---------------)  + I airport
	0x002a188a, // n0x018a c0x0000 (---------------)  + I airtraffic
	0x002066c9, // n0x018b c0x0000 (---------------)  + I ambulance
	0x002fcb89, // n0x018c c0x0000 (---------------)  + I amusement
	0x002bae4b, // n0x018d c0x0000 (---------------)  + I association
	0x002a6ec6, // n0x018e c0x0000 (---------------)  + I author
	0x00223b4a, // n0x018f c0x0000 (---------------)  + I ballooning
	0x0021f3c6, // n0x0190 c0x0000 (---------------)  + I broker
	0x002facc3, // n0x0191 c0x0000 (---------------)  + I caa
	0x002e2745, // n0x0192 c0x0000 (---------------)  + I cargo
	0x00233d48, // n0x0193 c0x0000 (---------------)  + I catering
	0x0020198d, // n0x0194 c0x0000 (---------------)  + I certification
	0x002b5e4c, // n0x0195 c0x0000 (---------------)  + I championship
	0x0024c787, // n0x0196 c0x0000 (---------------)  + I charter
	0x0022618d, // n0x0197 c0x0000 (---------------)  + I civilaviation
	0x00259cc4, // n0x0198 c0x0000 (---------------)  + I club
	0x0023204a, // n0x0199 c0x0000 (---------------)  + I conference
	0x0023344a, // n0x019a c0x0000 (---------------)  + I consultant
	0x0023390a, // n0x019b c0x0000 (---------------)  + I consulting
	0x0022af87, // n0x019c c0x0000 (---------------)  + I control
	0x002adb47, // n0x019d c0x0000 (---------------)  + I council
	0x0023b244, // n0x019e c0x0000 (---------------)  + I crew
	0x00252b46, // n0x019f c0x0000 (---------------)  + I design
	0x002a9144, // n0x01a0 c0x0000 (---------------)  + I dgca
	0x002ceec8, // n0x01a1 c0x0000 (---------------)  + I educator
	0x00319189, // n0x01a2 c0x0000 (---------------)  + I emergency
	0x00326206, // n0x01a3 c0x0000 (---------------)  + I engine
	0x00326208, // n0x01a4 c0x0000 (---------------)  + I engineer
	0x0023c58d, // n0x01a5 c0x0000 (---------------)  + I entertainment
	0x00337989, // n0x01a6 c0x0000 (---------------)  + I equipment
	0x0021c348, // n0x01a7 c0x0000 (---------------)  + I exchange
	0x0020e247, // n0x01a8 c0x0000 (---------------)  + I express
	0x002c9e4a, // n0x01a9 c0x0000 (---------------)  + I federation
	0x00241c86, // n0x01aa c0x0000 (---------------)  + I flight
	0x00249c87, // n0x01ab c0x0000 (---------------)  + I freight
	0x002fcec4, // n0x01ac c0x0000 (---------------)  + I fuel
	0x00243407, // n0x01ad c0x0000 (---------------)  + I gliding
	0x0027c3ca, // n0x01ae c0x0000 (---------------)  + I government
	0x00241e8e, // n0x01af c0x0000 (---------------)  + I groundhandling
	0x00207985, // n0x01b0 c0x0000 (---------------)  + I group
	0x002702cb, // n0x01b1 c0x0000 (---------------)  + I hanggliding
	0x0023bd09, // n0x01b2 c0x0000 (---------------)  + I homebuilt
	0x0021ddc9, // n0x01b3 c0x0000 (---------------)  + I insurance
	0x00215947, // n0x01b4 c0x0000 (---------------)  + I journal
	0x0024830a, // n0x01b5 c0x0000 (---------------)  + I journalist
	0x0021e247, // n0x01b6 c0x0000 (---------------)  + I leasing
	0x00242389, // n0x01b7 c0x0000 (---------------)  + I logistics
	0x00291788, // n0x01b8 c0x0000 (---------------)  + I magazine
	0x00350c8b, // n0x01b9 c0x0000 (---------------)  + I maintenance
	0x0021278b, // n0x01ba c0x0000 (---------------)  + I marketplace
	0x002e2905, // n0x01bb c0x0000 (---------------)  + I media
	0x0025178a, // n0x01bc c0x0000 (---------------)  + I microlight
	0x00270ac9, // n0x01bd c0x0000 (---------------)  + I modelling
	0x0020fbca, // n0x01be c0x0000 (---------------)  + I navigation
	0x0023d58b, // n0x01bf c0x0000 (---------------)  + I parachuting
	0x0024330b, // n0x01c0 c0x0000 (---------------)  + I paragliding
	0x002babd5, // n0x01c1 c0x0000 (---------------)  + I passenger-association
	0x002be505, // n0x01c2 c0x0000 (---------------)  + I pilot
	0x0020e2c5, // n0x01c3 c0x0000 (---------------)  + I press
	0x002c5c0a, // n0x01c4 c0x0000 (---------------)  + I production
	0x002f9cca, // n0x01c5 c0x0000 (---------------)  + I recreation
	0x0023ba87, // n0x01c6 c0x0000 (---------------)  + I repbody
	0x0020e303, // n0x01c7 c0x0000 (---------------)  + I res
	0x002c31c8, // n0x01c8 c0x0000 (---------------)  + I research
	0x002b7e8a, // n0x01c9 c0x0000 (---------------)  + I rotorcraft
	0x00319ec6, // n0x01ca c0x0000 (---------------)  + I safety
	0x00296509, // n0x01cb c0x0000 (---------------)  + I scientist
	0x002db088, // n0x01cc c0x0000 (---------------)  + I services
	0x002d3144, // n0x01cd c0x0000 (---------------)  + I show
	0x0027fd89, // n0x01ce c0x0000 (---------------)  + I skydiving
	0x0024df08, // n0x01cf c0x0000 (---------------)  + I software
	0x002ab207, // n0x01d0 c0x0000 (---------------)  + I student
	0x0023bf04, // n0x01d1 c0x0000 (---------------)  + I taxi
	0x0024cd06, // n0x01d2 c0x0000 (---------------)  + I trader
	0x00288087, // n0x01d3 c0x0000 (---------------)  + I trading
	0x00297a07, // n0x01d4 c0x0000 (---------------)  + I trainer
	0x00247fc5, // n0x01d5 c0x0000 (---------------)  + I union
	0x002077cc, // n0x01d6 c0x0000 (---------------)  + I workinggroup
	0x00227dc5, // n0x01d7 c0x0000 (---------------)  + I works
	0x002104c3, // n0x01d8 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x01d9 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x01da c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x01db c0x0000 (---------------)  + I net
	0x002453c3, // n0x01dc c0x0000 (---------------)  + I org
	0x00208f82, // n0x01dd c0x0000 (---------------)  + I co
	0x002104c3, // n0x01de c0x0000 (---------------)  + I com
	0x00239bc3, // n0x01df c0x0000 (---------------)  + I net
	0x002006c3, // n0x01e0 c0x0000 (---------------)  + I nom
	0x002453c3, // n0x01e1 c0x0000 (---------------)  + I org
	0x002104c3, // n0x01e2 c0x0000 (---------------)  + I com
	0x00239bc3, // n0x01e3 c0x0000 (---------------)  + I net
	0x00216f83, // n0x01e4 c0x0000 (---------------)  + I off
	0x002453c3, // n0x01e5 c0x0000 (---------------)  + I org
	0x002104c3, // n0x01e6 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x01e7 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x01e8 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x01e9 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x01ea c0x0000 (---------------)  + I net
	0x002453c3, // n0x01eb c0x0000 (---------------)  + I org
	0x002104c3, // n0x01ec c0x0000 (---------------)  + I com
	0x002ceec3, // n0x01ed c0x0000 (---------------)  + I edu
	0x00239bc3, // n0x01ee c0x0000 (---------------)  + I net
	0x002453c3, // n0x01ef c0x0000 (---------------)  + I org
	0x00208f82, // n0x01f0 c0x0000 (---------------)  + I co
	0x00203582, // n0x01f1 c0x0000 (---------------)  + I ed
	0x00233b42, // n0x01f2 c0x0000 (---------------)  + I gv
	0x002034c2, // n0x01f3 c0x0000 (---------------)  + I it
	0x00205242, // n0x01f4 c0x0000 (---------------)  + I og
	0x0023bb02, // n0x01f5 c0x0000 (---------------)  + I pb
	0x046104c3, // n0x01f6 c0x0011 (n0x01fe-n0x01ff)  + I com
	0x002ceec3, // n0x01f7 c0x0000 (---------------)  + I edu
	0x00230083, // n0x01f8 c0x0000 (---------------)  + I gob
	0x0021fe43, // n0x01f9 c0x0000 (---------------)  + I int
	0x0025f683, // n0x01fa c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x01fb c0x0000 (---------------)  + I net
	0x002453c3, // n0x01fc c0x0000 (---------------)  + I org
	0x00201d03, // n0x01fd c0x0000 (---------------)  + I tur
	0x00031c88, // n0x01fe c0x0000 (---------------)  +   blogspot
	0x002aa044, // n0x01ff c0x0000 (---------------)  + I e164
	0x00298e07, // n0x0200 c0x0000 (---------------)  + I in-addr
	0x0025f243, // n0x0201 c0x0000 (---------------)  + I ip6
	0x00267204, // n0x0202 c0x0000 (---------------)  + I iris
	0x0020b703, // n0x0203 c0x0000 (---------------)  + I uri
	0x002159c3, // n0x0204 c0x0000 (---------------)  + I urn
	0x002150c3, // n0x0205 c0x0000 (---------------)  + I gov
	0x002028c2, // n0x0206 c0x0000 (---------------)  + I ac
	0x000b5183, // n0x0207 c0x0000 (---------------)  +   biz
	0x05608f82, // n0x0208 c0x0015 (n0x020d-n0x020e)  + I co
	0x00233b42, // n0x0209 c0x0000 (---------------)  + I gv
	0x000180c4, // n0x020a c0x0000 (---------------)  +   info
	0x00204282, // n0x020b c0x0000 (---------------)  + I or
	0x000c5804, // n0x020c c0x0000 (---------------)  +   priv
	0x00031c88, // n0x020d c0x0000 (---------------)  +   blogspot
	0x002352c3, // n0x020e c0x0000 (---------------)  + I act
	0x00299d43, // n0x020f c0x0000 (---------------)  + I asn
	0x05e104c3, // n0x0210 c0x0017 (n0x0221-n0x0222)  + I com
	0x00232044, // n0x0211 c0x0000 (---------------)  + I conf
	0x0021b3c5, // n0x0212 c0x0000 (---------------)  + I csiro
	0x062ceec3, // n0x0213 c0x0018 (n0x0222-n0x022a)  + I edu
	0x066150c3, // n0x0214 c0x0019 (n0x022a-n0x0231)  + I gov
	0x0020ab82, // n0x0215 c0x0000 (---------------)  + I id
	0x002180c4, // n0x0216 c0x0000 (---------------)  + I info
	0x00239bc3, // n0x0217 c0x0000 (---------------)  + I net
	0x00289f03, // n0x0218 c0x0000 (---------------)  + I nsw
	0x00204e02, // n0x0219 c0x0000 (---------------)  + I nt
	0x002453c3, // n0x021a c0x0000 (---------------)  + I org
	0x00217cc2, // n0x021b c0x0000 (---------------)  + I oz
	0x0024b443, // n0x021c c0x0000 (---------------)  + I qld
	0x00200cc2, // n0x021d c0x0000 (---------------)  + I sa
	0x00212443, // n0x021e c0x0000 (---------------)  + I tas
	0x0022fb03, // n0x021f c0x0000 (---------------)  + I vic
	0x00200142, // n0x0220 c0x0000 (---------------)  + I wa
	0x00031c88, // n0x0221 c0x0000 (---------------)  +   blogspot
	0x002352c3, // n0x0222 c0x0000 (---------------)  + I act
	0x00289f03, // n0x0223 c0x0000 (---------------)  + I nsw
	0x00204e02, // n0x0224 c0x0000 (---------------)  + I nt
	0x0024b443, // n0x0225 c0x0000 (---------------)  + I qld
	0x00200cc2, // n0x0226 c0x0000 (---------------)  + I sa
	0x00212443, // n0x0227 c0x0000 (---------------)  + I tas
	0x0022fb03, // n0x0228 c0x0000 (---------------)  + I vic
	0x00200142, // n0x0229 c0x0000 (---------------)  + I wa
	0x002352c3, // n0x022a c0x0000 (---------------)  + I act
	0x00204e02, // n0x022b c0x0000 (---------------)  + I nt
	0x0024b443, // n0x022c c0x0000 (---------------)  + I qld
	0x00200cc2, // n0x022d c0x0000 (---------------)  + I sa
	0x00212443, // n0x022e c0x0000 (---------------)  + I tas
	0x0022fb03, // n0x022f c0x0000 (---------------)  + I vic
	0x00200142, // n0x0230 c0x0000 (---------------)  + I wa
	0x002104c3, // n0x0231 c0x0000 (---------------)  + I com
	0x002b5183, // n0x0232 c0x0000 (---------------)  + I biz
	0x002104c3, // n0x0233 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0234 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0235 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x0236 c0x0000 (---------------)  + I info
	0x0021fe43, // n0x0237 c0x0000 (---------------)  + I int
	0x0025f683, // n0x0238 c0x0000 (---------------)  + I mil
	0x002d16c4, // n0x0239 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x023a c0x0000 (---------------)  + I net
	0x002453c3, // n0x023b c0x0000 (---------------)  + I org
	0x00208642, // n0x023c c0x0000 (---------------)  + I pp
	0x002c5983, // n0x023d c0x0000 (---------------)  + I pro
	0x00208f82, // n0x023e c0x0000 (---------------)  + I co
	0x002104c3, // n0x023f c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0240 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0241 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0242 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0243 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0244 c0x0000 (---------------)  + I org
	0x00208082, // n0x0245 c0x0000 (---------------)  + I rs
	0x002f4804, // n0x0246 c0x0000 (---------------)  + I unbi
	0x00267484, // n0x0247 c0x0000 (---------------)  + I unsa
	0x002b5183, // n0x0248 c0x0000 (---------------)  + I biz
	0x002104c3, // n0x0249 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x024a c0x0000 (---------------)  + I edu
	0x002150c3, // n0x024b c0x0000 (---------------)  + I gov
	0x002180c4, // n0x024c c0x0000 (---------------)  + I info
	0x00239bc3, // n0x024d c0x0000 (---------------)  + I net
	0x002453c3, // n0x024e c0x0000 (---------------)  + I org
	0x002dd805, // n0x024f c0x0000 (---------------)  + I store
	0x002028c2, // n0x0250 c0x0000 (---------------)  + I ac
	0x00031c88, // n0x0251 c0x0000 (---------------)  +   blogspot
	0x002150c3, // n0x0252 c0x0000 (---------------)  + I gov
	0x0023cd41, // n0x0253 c0x0000 (---------------)  + I 0
	0x00202541, // n0x0254 c0x0000 (---------------)  + I 1
	0x00204701, // n0x0255 c0x0000 (---------------)  + I 2
	0x002022c1, // n0x0256 c0x0000 (---------------)  + I 3
	0x0025b801, // n0x0257 c0x0000 (---------------)  + I 4
	0x0027f781, // n0x0258 c0x0000 (---------------)  + I 5
	0x0025f2c1, // n0x0259 c0x0000 (---------------)  + I 6
	0x00269481, // n0x025a c0x0000 (---------------)  + I 7
	0x002bcd81, // n0x025b c0x0000 (---------------)  + I 8
	0x0027f881, // n0x025c c0x0000 (---------------)  + I 9
	0x00200101, // n0x025d c0x0000 (---------------)  + I a
	0x00200001, // n0x025e c0x0000 (---------------)  + I b
	0x00200401, // n0x025f c0x0000 (---------------)  + I c
	0x002003c1, // n0x0260 c0x0000 (---------------)  + I d
	0x00200081, // n0x0261 c0x0000 (---------------)  + I e
	0x00201ac1, // n0x0262 c0x0000 (---------------)  + I f
	0x002002c1, // n0x0263 c0x0000 (---------------)  + I g
	0x00200201, // n0x0264 c0x0000 (---------------)  + I h
	0x00200041, // n0x0265 c0x0000 (---------------)  + I i
	0x002037c1, // n0x0266 c0x0000 (---------------)  + I j
	0x002007c1, // n0x0267 c0x0000 (---------------)  + I k
	0x002000c1, // n0x0268 c0x0000 (---------------)  + I l
	0x00200741, // n0x0269 c0x0000 (---------------)  + I m
	0x00200281, // n0x026a c0x0000 (---------------)  + I n
	0x00200341, // n0x026b c0x0000 (---------------)  + I o
	0x00202e81, // n0x026c c0x0000 (---------------)  + I p
	0x0022d341, // n0x026d c0x0000 (---------------)  + I q
	0x00200501, // n0x026e c0x0000 (---------------)  + I r
	0x002001c1, // n0x026f c0x0000 (---------------)  + I s
	0x00200301, // n0x0270 c0x0000 (---------------)  + I t
	0x00200881, // n0x0271 c0x0000 (---------------)  + I u
	0x00201741, // n0x0272 c0x0000 (---------------)  + I v
	0x00200141, // n0x0273 c0x0000 (---------------)  + I w
	0x00201381, // n0x0274 c0x0000 (---------------)  + I x
	0x002027c1, // n0x0275 c0x0000 (---------------)  + I y
	0x002011c1, // n0x0276 c0x0000 (---------------)  + I z
	0x002104c3, // n0x0277 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0278 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0279 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x027a c0x0000 (---------------)  + I net
	0x002453c3, // n0x027b c0x0000 (---------------)  + I org
	0x00208f82, // n0x027c c0x0000 (---------------)  + I co
	0x002104c3, // n0x027d c0x0000 (---------------)  + I com
	0x002ceec3, // n0x027e c0x0000 (---------------)  + I edu
	0x00204282, // n0x027f c0x0000 (---------------)  + I or
	0x002453c3, // n0x0280 c0x0000 (---------------)  + I org
	0x00007546, // n0x0281 c0x0000 (---------------)  +   dyndns
	0x00043a8a, // n0x0282 c0x0000 (---------------)  +   for-better
	0x0006c508, // n0x0283 c0x0000 (---------------)  +   for-more
	0x000440c8, // n0x0284 c0x0000 (---------------)  +   for-some
	0x00044b07, // n0x0285 c0x0000 (---------------)  +   for-the
	0x00108ec6, // n0x0286 c0x0000 (---------------)  +   selfip
	0x00017306, // n0x0287 c0x0000 (---------------)  +   webhop
	0x00202f44, // n0x0288 c0x0000 (---------------)  + I asso
	0x002f7707, // n0x0289 c0x0000 (---------------)  + I barreau
	0x00031c88, // n0x028a c0x0000 (---------------)  +   blogspot
	0x0022fa44, // n0x028b c0x0000 (---------------)  + I gouv
	0x002104c3, // n0x028c c0x0000 (---------------)  + I com
	0x002ceec3, // n0x028d c0x0000 (---------------)  + I edu
	0x002150c3, // n0x028e c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x028f c0x0000 (---------------)  + I net
	0x002453c3, // n0x0290 c0x0000 (---------------)  + I org
	0x002104c3, // n0x0291 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0292 c0x0000 (---------------)  + I edu
	0x00230083, // n0x0293 c0x0000 (---------------)  + I gob
	0x002150c3, // n0x0294 c0x0000 (---------------)  + I gov
	0x0021fe43, // n0x0295 c0x0000 (---------------)  + I int
	0x0025f683, // n0x0296 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0297 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0298 c0x0000 (---------------)  + I org
	0x0027ecc2, // n0x0299 c0x0000 (---------------)  + I tv
	0x002bc4c3, // n0x029a c0x0000 (---------------)  + I adm
	0x00257203, // n0x029b c0x0000 (---------------)  + I adv
	0x00206383, // n0x029c c0x0000 (---------------)  + I agr
	0x00200dc2, // n0x029d c0x0000 (---------------)  + I am
	0x0024b3c3, // n0x029e c0x0000 (---------------)  + I arq
	0x0020c703, // n0x029f c0x0000 (---------------)  + I art
	0x0020d6c3, // n0x02a0 c0x0000 (---------------)  + I ato
	0x00200001, // n0x02a1 c0x0000 (---------------)  + I b
	0x0020a503, // n0x02a2 c0x0000 (---------------)  + I bio
	0x0020be44, // n0x02a3 c0x0000 (---------------)  + I blog
	0x00210683, // n0x02a4 c0x0000 (---------------)  + I bmd
	0x00337fc3, // n0x02a5 c0x0000 (---------------)  + I cim
	0x002ea143, // n0x02a6 c0x0000 (---------------)  + I cng
	0x0022dc83, // n0x02a7 c0x0000 (---------------)  + I cnt
	0x0a2104c3, // n0x02a8 c0x0028 (n0x02df-n0x02e0)  + I com
	0x00236044, // n0x02a9 c0x0000 (---------------)  + I coop
	0x002ea103, // n0x02aa c0x0000 (---------------)  + I ecn
	0x0020c803, // n0x02ab c0x0000 (---------------)  + I eco
	0x002ceec3, // n0x02ac c0x0000 (---------------)  + I edu
	0x00234983, // n0x02ad c0x0000 (---------------)  + I emp
	0x0020bac3, // n0x02ae c0x0000 (---------------)  + I eng
	0x002584c3, // n0x02af c0x0000 (---------------)  + I esp
	0x00345f03, // n0x02b0 c0x0000 (---------------)  + I etc
	0x00221883, // n0x02b1 c0x0000 (---------------)  + I eti
	0x00223e03, // n0x02b2 c0x0000 (---------------)  + I far
	0x00242344, // n0x02b3 c0x0000 (---------------)  + I flog
	0x00332782, // n0x02b4 c0x0000 (---------------)  + I fm
	0x00243803, // n0x02b5 c0x0000 (---------------)  + I fnd
	0x002486c3, // n0x02b6 c0x0000 (---------------)  + I fot
	0x0025ffc3, // n0x02b7 c0x0000 (---------------)  + I fst
	0x0025fe43, // n0x02b8 c0x0000 (---------------)  + I g12
	0x00223d83, // n0x02b9 c0x0000 (---------------)  + I ggf
	0x002150c3, // n0x02ba c0x0000 (---------------)  + I gov
	0x002d3443, // n0x02bb c0x0000 (---------------)  + I imb
	0x0020ca83, // n0x02bc c0x0000 (---------------)  + I ind
	0x002180c3, // n0x02bd c0x0000 (---------------)  + I inf
	0x00207483, // n0x02be c0x0000 (---------------)  + I jor
	0x0028c903, // n0x02bf c0x0000 (---------------)  + I jus
	0x0021b643, // n0x02c0 c0x0000 (---------------)  + I leg
	0x0034b683, // n0x02c1 c0x0000 (---------------)  + I lel
	0x0020b603, // n0x02c2 c0x0000 (---------------)  + I mat
	0x002382c3, // n0x02c3 c0x0000 (---------------)  + I med
	0x0025f683, // n0x02c4 c0x0000 (---------------)  + I mil
	0x002aa903, // n0x02c5 c0x0000 (---------------)  + I mus
	0x00239bc3, // n0x02c6 c0x0000 (---------------)  + I net
	0x002006c3, // n0x02c7 c0x0000 (---------------)  + I nom
	0x00210083, // n0x02c8 c0x0000 (---------------)  + I not
	0x0022b003, // n0x02c9 c0x0000 (---------------)  + I ntr
	0x00230143, // n0x02ca c0x0000 (---------------)  + I odo
	0x002453c3, // n0x02cb c0x0000 (---------------)  + I org
	0x0031cdc3, // n0x02cc c0x0000 (---------------)  + I ppg
	0x002c5983, // n0x02cd c0x0000 (---------------)  + I pro
	0x00221943, // n0x02ce c0x0000 (---------------)  + I psc
	0x00273a83, // n0x02cf c0x0000 (---------------)  + I psi
	0x002c7b03, // n0x02d0 c0x0000 (---------------)  + I qsl
	0x00259085, // n0x02d1 c0x0000 (---------------)  + I radio
	0x002a8343, // n0x02d2 c0x0000 (---------------)  + I rec
	0x002d3d83, // n0x02d3 c0x0000 (---------------)  + I slg
	0x002dae83, // n0x02d4 c0x0000 (---------------)  + I srv
	0x0023bf04, // n0x02d5 c0x0000 (---------------)  + I taxi
	0x0026f0c3, // n0x02d6 c0x0000 (---------------)  + I teo
	0x0023d503, // n0x02d7 c0x0000 (---------------)  + I tmp
	0x002ac183, // n0x02d8 c0x0000 (---------------)  + I trd
	0x00201d03, // n0x02d9 c0x0000 (---------------)  + I tur
	0x0027ecc2, // n0x02da c0x0000 (---------------)  + I tv
	0x00237883, // n0x02db c0x0000 (---------------)  + I vet
	0x002e4d04, // n0x02dc c0x0000 (---------------)  + I vlog
	0x00324b04, // n0x02dd c0x0000 (---------------)  + I wiki
	0x002bea83, // n0x02de c0x0000 (---------------)  + I zlg
	0x00031c88, // n0x02df c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x02e0 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x02e1 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x02e2 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x02e3 c0x0000 (---------------)  + I net
	0x002453c3, // n0x02e4 c0x0000 (---------------)  + I org
	0x002104c3, // n0x02e5 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x02e6 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x02e7 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x02e8 c0x0000 (---------------)  + I net
	0x002453c3, // n0x02e9 c0x0000 (---------------)  + I org
	0x00208f82, // n0x02ea c0x0000 (---------------)  + I co
	0x002453c3, // n0x02eb c0x0000 (---------------)  + I org
	0x002104c3, // n0x02ec c0x0000 (---------------)  + I com
	0x002150c3, // n0x02ed c0x0000 (---------------)  + I gov
	0x0025f683, // n0x02ee c0x0000 (---------------)  + I mil
	0x00216f82, // n0x02ef c0x0000 (---------------)  + I of
	0x002104c3, // n0x02f0 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x02f1 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x02f2 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x02f3 c0x0000 (---------------)  + I net
	0x002453c3, // n0x02f4 c0x0000 (---------------)  + I org
	0x00202a82, // n0x02f5 c0x0000 (---------------)  + I ab
	0x003234c2, // n0x02f6 c0x0000 (---------------)  + I bc
	0x00031c88, // n0x02f7 c0x0000 (---------------)  +   blogspot
	0x00008f82, // n0x02f8 c0x0000 (---------------)  +   co
	0x002a9182, // n0x02f9 c0x0000 (---------------)  + I gc
	0x00206302, // n0x02fa c0x0000 (---------------)  + I mb
	0x00224bc2, // n0x02fb c0x0000 (---------------)  + I nb
	0x00218102, // n0x02fc c0x0000 (---------------)  + I nf
	0x00231642, // n0x02fd c0x0000 (---------------)  + I nl
	0x00207642, // n0x02fe c0x0000 (---------------)  + I ns
	0x00204e02, // n0x02ff c0x0000 (---------------)  + I nt
	0x00252942, // n0x0300 c0x0000 (---------------)  + I nu
	0x00200342, // n0x0301 c0x0000 (---------------)  + I on
	0x00208682, // n0x0302 c0x0000 (---------------)  + I pe
	0x0022d342, // n0x0303 c0x0000 (---------------)  + I qc
	0x002033c2, // n0x0304 c0x0000 (---------------)  + I sk
	0x0028af82, // n0x0305 c0x0000 (---------------)  + I yk
	0x00011309, // n0x0306 c0x0000 (---------------)  +   ftpaccess
	0x000db38b, // n0x0307 c0x0000 (---------------)  +   game-server
	0x000b9dc8, // n0x0308 c0x0000 (---------------)  +   myphotos
	0x000b19c9, // n0x0309 c0x0000 (---------------)  +   scrapping
	0x002150c3, // n0x030a c0x0000 (---------------)  + I gov
	0x00031c88, // n0x030b c0x0000 (---------------)  +   blogspot
	0x00031c88, // n0x030c c0x0000 (---------------)  +   blogspot
	0x002028c2, // n0x030d c0x0000 (---------------)  + I ac
	0x00202f44, // n0x030e c0x0000 (---------------)  + I asso
	0x00208f82, // n0x030f c0x0000 (---------------)  + I co
	0x002104c3, // n0x0310 c0x0000 (---------------)  + I com
	0x00203582, // n0x0311 c0x0000 (---------------)  + I ed
	0x002ceec3, // n0x0312 c0x0000 (---------------)  + I edu
	0x002053c2, // n0x0313 c0x0000 (---------------)  + I go
	0x0022fa44, // n0x0314 c0x0000 (---------------)  + I gouv
	0x0021fe43, // n0x0315 c0x0000 (---------------)  + I int
	0x002106c2, // n0x0316 c0x0000 (---------------)  + I md
	0x00239bc3, // n0x0317 c0x0000 (---------------)  + I net
	0x00204282, // n0x0318 c0x0000 (---------------)  + I or
	0x002453c3, // n0x0319 c0x0000 (---------------)  + I org
	0x0020e2c6, // n0x031a c0x0000 (---------------)  + I presse
	0x002e85cf, // n0x031b c0x0000 (---------------)  + I xn--aroport-bya
	0x0063b483, // n0x031c c0x0001 (---------------)  ! I www
	0x00208f82, // n0x031d c0x0000 (---------------)  + I co
	0x00230083, // n0x031e c0x0000 (---------------)  + I gob
	0x002150c3, // n0x031f c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0320 c0x0000 (---------------)  + I mil
	0x002150c3, // n0x0321 c0x0000 (---------------)  + I gov
	0x002028c2, // n0x0322 c0x0000 (---------------)  + I ac
	0x00203682, // n0x0323 c0x0000 (---------------)  + I ah
	0x0020eb42, // n0x0324 c0x0000 (---------------)  + I bj
	0x002104c3, // n0x0325 c0x0000 (---------------)  + I com
	0x00238e42, // n0x0326 c0x0000 (---------------)  + I cq
	0x002ceec3, // n0x0327 c0x0000 (---------------)  + I edu
	0x00207442, // n0x0328 c0x0000 (---------------)  + I fj
	0x0020bf02, // n0x0329 c0x0000 (---------------)  + I gd
	0x002150c3, // n0x032a c0x0000 (---------------)  + I gov
	0x00223142, // n0x032b c0x0000 (---------------)  + I gs
	0x00269242, // n0x032c c0x0000 (---------------)  + I gx
	0x00270542, // n0x032d c0x0000 (---------------)  + I gz
	0x00200a42, // n0x032e c0x0000 (---------------)  + I ha
	0x002e77c2, // n0x032f c0x0000 (---------------)  + I hb
	0x002036c2, // n0x0330 c0x0000 (---------------)  + I he
	0x00200202, // n0x0331 c0x0000 (---------------)  + I hi
	0x0022e542, // n0x0332 c0x0000 (---------------)  + I hk
	0x00221a02, // n0x0333 c0x0000 (---------------)  + I hl
	0x00264042, // n0x0334 c0x0000 (---------------)  + I hn
	0x00310fc2, // n0x0335 c0x0000 (---------------)  + I jl
	0x002e0bc2, // n0x0336 c0x0000 (---------------)  + I js
	0x002ef242, // n0x0337 c0x0000 (---------------)  + I jx
	0x0022bfc2, // n0x0338 c0x0000 (---------------)  + I ln
	0x0025f683, // n0x0339 c0x0000 (---------------)  + I mil
	0x0020a782, // n0x033a c0x0000 (---------------)  + I mo
	0x00239bc3, // n0x033b c0x0000 (---------------)  + I net
	0x0020ad82, // n0x033c c0x0000 (---------------)  + I nm
	0x002f0c42, // n0x033d c0x0000 (---------------)  + I nx
	0x002453c3, // n0x033e c0x0000 (---------------)  + I org
	0x00238e82, // n0x033f c0x0000 (---------------)  + I qh
	0x00201e42, // n0x0340 c0x0000 (---------------)  + I sc
	0x0024db82, // n0x0341 c0x0000 (---------------)  + I sd
	0x002001c2, // n0x0342 c0x0000 (---------------)  + I sh
	0x00202002, // n0x0343 c0x0000 (---------------)  + I sn
	0x002e1042, // n0x0344 c0x0000 (---------------)  + I sx
	0x0023fb82, // n0x0345 c0x0000 (---------------)  + I tj
	0x00247802, // n0x0346 c0x0000 (---------------)  + I tw
	0x00318a02, // n0x0347 c0x0000 (---------------)  + I xj
	0x002d370a, // n0x0348 c0x0000 (---------------)  + I xn--55qx5d
	0x0031010a, // n0x0349 c0x0000 (---------------)  + I xn--io0a7i
	0x0032da4a, // n0x034a c0x0000 (---------------)  + I xn--od0alg
	0x00353b82, // n0x034b c0x0000 (---------------)  + I xz
	0x00207582, // n0x034c c0x0000 (---------------)  + I yn
	0x002dac42, // n0x034d c0x0000 (---------------)  + I zj
	0x0023fec4, // n0x034e c0x0000 (---------------)  + I arts
	0x002104c3, // n0x034f c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0350 c0x0000 (---------------)  + I edu
	0x00240684, // n0x0351 c0x0000 (---------------)  + I firm
	0x002150c3, // n0x0352 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x0353 c0x0000 (---------------)  + I info
	0x0021fe43, // n0x0354 c0x0000 (---------------)  + I int
	0x0025f683, // n0x0355 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0356 c0x0000 (---------------)  + I net
	0x002006c3, // n0x0357 c0x0000 (---------------)  + I nom
	0x002453c3, // n0x0358 c0x0000 (---------------)  + I org
	0x002a8343, // n0x0359 c0x0000 (---------------)  + I rec
	0x00209243, // n0x035a c0x0000 (---------------)  + I web
	0x0eab77c9, // n0x035b c0x003a (n0x0414-n0x042b)  o I amazonaws
	0x00098407, // n0x035c c0x0000 (---------------)  +   appspot
	0x00003902, // n0x035d c0x0000 (---------------)  +   ar
	0x0014ff0a, // n0x035e c0x0000 (---------------)  +   betainabox
	0x0000be47, // n0x035f c0x0000 (---------------)  +   blogdns
	0x00031c88, // n0x0360 c0x0000 (---------------)  +   blogspot
	0x00003e42, // n0x0361 c0x0000 (---------------)  +   br
	0x00006887, // n0x0362 c0x0000 (---------------)  +   cechire
	0x0005f84f, // n0x0363 c0x0000 (---------------)  +   cloudcontrolapp
	0x0002ae4f, // n0x0364 c0x0000 (---------------)  +   cloudcontrolled
	0x0002dc82, // n0x0365 c0x0000 (---------------)  +   cn
	0x00058408, // n0x0366 c0x0000 (---------------)  +   codespot
	0x00009102, // n0x0367 c0x0000 (---------------)  +   de
	0x00032888, // n0x0368 c0x0000 (---------------)  +   dnsalias
	0x0005a447, // n0x0369 c0x0000 (---------------)  +   dnsdojo
	0x0002eb4b, // n0x036a c0x0000 (---------------)  +   doesntexist
	0x0010c549, // n0x036b c0x0000 (---------------)  +   dontexist
	0x00032787, // n0x036c c0x0000 (---------------)  +   doomdns
	0x0014b18c, // n0x036d c0x0000 (---------------)  +   dreamhosters
	0x0014958a, // n0x036e c0x0000 (---------------)  +   dyn-o-saur
	0x00078ac8, // n0x036f c0x0000 (---------------)  +   dynalias
	0x0004634e, // n0x0370 c0x0000 (---------------)  +   dyndns-at-home
	0x0000754e, // n0x0371 c0x0000 (---------------)  +   dyndns-at-work
	0x0000bc8b, // n0x0372 c0x0000 (---------------)  +   dyndns-blog
	0x0001070b, // n0x0373 c0x0000 (---------------)  +   dyndns-free
	0x0001104b, // n0x0374 c0x0000 (---------------)  +   dyndns-home
	0x00014209, // n0x0375 c0x0000 (---------------)  +   dyndns-ip
	0x0001644b, // n0x0376 c0x0000 (---------------)  +   dyndns-mail
	0x00016dcd, // n0x0377 c0x0000 (---------------)  +   dyndns-office
	0x0001b18b, // n0x0378 c0x0000 (---------------)  +   dyndns-pics
	0x0001f7cd, // n0x0379 c0x0000 (---------------)  +   dyndns-remote
	0x0002d80d, // n0x037a c0x0000 (---------------)  +   dyndns-server
	0x000bf3ca, // n0x037b c0x0000 (---------------)  +   dyndns-web
	0x0012494b, // n0x037c c0x0000 (---------------)  +   dyndns-wiki
	0x00027c0b, // n0x037d c0x0000 (---------------)  +   dyndns-work
	0x0001ccd0, // n0x037e c0x0000 (---------------)  +   elasticbeanstalk
	0x0001684f, // n0x037f c0x0000 (---------------)  +   est-a-la-maison
	0x0005d7cf, // n0x0380 c0x0000 (---------------)  +   est-a-la-masion
	0x00036d8d, // n0x0381 c0x0000 (---------------)  +   est-le-patron
	0x00021c10, // n0x0382 c0x0000 (---------------)  +   est-mon-blogueur
	0x0000f502, // n0x0383 c0x0000 (---------------)  +   eu
	0x0004ac47, // n0x0384 c0x0000 (---------------)  +   from-ak
	0x0004b0c7, // n0x0385 c0x0000 (---------------)  +   from-al
	0x0004b287, // n0x0386 c0x0000 (---------------)  +   from-ar
	0x0004b7c7, // n0x0387 c0x0000 (---------------)  +   from-ca
	0x0004c387, // n0x0388 c0x0000 (---------------)  +   from-ct
	0x0004c607, // n0x0389 c0x0000 (---------------)  +   from-dc
	0x0004c947, // n0x038a c0x0000 (---------------)  +   from-de
	0x0004ce87, // n0x038b c0x0000 (---------------)  +   from-fl
	0x0004d987, // n0x038c c0x0000 (---------------)  +   from-ga
	0x0004dc87, // n0x038d c0x0000 (---------------)  +   from-hi
	0x0004e287, // n0x038e c0x0000 (---------------)  +   from-ia
	0x0004e447, // n0x038f c0x0000 (---------------)  +   from-id
	0x0004e607, // n0x0390 c0x0000 (---------------)  +   from-il
	0x0004e7c7, // n0x0391 c0x0000 (---------------)  +   from-in
	0x0004eac7, // n0x0392 c0x0000 (---------------)  +   from-ks
	0x0004f1c7, // n0x0393 c0x0000 (---------------)  +   from-ky
	0x000502c7, // n0x0394 c0x0000 (---------------)  +   from-ma
	0x00050b07, // n0x0395 c0x0000 (---------------)  +   from-md
	0x00051647, // n0x0396 c0x0000 (---------------)  +   from-mi
	0x00051bc7, // n0x0397 c0x0000 (---------------)  +   from-mn
	0x00051d87, // n0x0398 c0x0000 (---------------)  +   from-mo
	0x00052747, // n0x0399 c0x0000 (---------------)  +   from-ms
	0x00052d47, // n0x039a c0x0000 (---------------)  +   from-mt
	0x00054787, // n0x039b c0x0000 (---------------)  +   from-nc
	0x00055707, // n0x039c c0x0000 (---------------)  +   from-nd
	0x000558c7, // n0x039d c0x0000 (---------------)  +   from-ne
	0x00055a87, // n0x039e c0x0000 (---------------)  +   from-nh
	0x000561c7, // n0x039f c0x0000 (---------------)  +   from-nj
	0x00056787, // n0x03a0 c0x0000 (---------------)  +   from-nm
	0x00057587, // n0x03a1 c0x0000 (---------------)  +   from-nv
	0x00057dc7, // n0x03a2 c0x0000 (---------------)  +   from-oh
	0x00058007, // n0x03a3 c0x0000 (---------------)  +   from-ok
	0x00058847, // n0x03a4 c0x0000 (---------------)  +   from-or
	0x00058b07, // n0x03a5 c0x0000 (---------------)  +   from-pa
	0x00059707, // n0x03a6 c0x0000 (---------------)  +   from-pr
	0x00059907, // n0x03a7 c0x0000 (---------------)  +   from-ri
	0x0005ad47, // n0x03a8 c0x0000 (---------------)  +   from-sc
	0x0005b147, // n0x03a9 c0x0000 (---------------)  +   from-sd
	0x0005b307, // n0x03aa c0x0000 (---------------)  +   from-tn
	0x0005b4c7, // n0x03ab c0x0000 (---------------)  +   from-tx
	0x0005bac7, // n0x03ac c0x0000 (---------------)  +   from-ut
	0x0005c087, // n0x03ad c0x0000 (---------------)  +   from-va
	0x0005c447, // n0x03ae c0x0000 (---------------)  +   from-vt
	0x0005c747, // n0x03af c0x0000 (---------------)  +   from-wa
	0x0005c907, // n0x03b0 c0x0000 (---------------)  +   from-wi
	0x0005cc87, // n0x03b1 c0x0000 (---------------)  +   from-wv
	0x0005e847, // n0x03b2 c0x0000 (---------------)  +   from-wy
	0x00072c02, // n0x03b3 c0x0000 (---------------)  +   gb
	0x0004bac7, // n0x03b4 c0x0000 (---------------)  +   getmyip
	0x00042e8a, // n0x03b5 c0x0000 (---------------)  +   googleapis
	0x0005828a, // n0x03b6 c0x0000 (---------------)  +   googlecode
	0x00045446, // n0x03b7 c0x0000 (---------------)  +   gotdns
	0x000063c2, // n0x03b8 c0x0000 (---------------)  +   gr
	0x00098289, // n0x03b9 c0x0000 (---------------)  +   herokuapp
	0x00048789, // n0x03ba c0x0000 (---------------)  +   herokussl
	0x0003970a, // n0x03bb c0x0000 (---------------)  +   hobby-site
	0x00089109, // n0x03bc c0x0000 (---------------)  +   homelinux
	0x000896c8, // n0x03bd c0x0000 (---------------)  +   homeunix
	0x0003d6c2, // n0x03be c0x0000 (---------------)  +   hu
	0x0005a089, // n0x03bf c0x0000 (---------------)  +   iamallama
	0x0006e28e, // n0x03c0 c0x0000 (---------------)  +   is-a-anarchist
	0x0000cd0c, // n0x03c1 c0x0000 (---------------)  +   is-a-blogger
	0x000ba18f, // n0x03c2 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0007c70e, // n0x03c3 c0x0000 (---------------)  +   is-a-bulls-fan
	0x0008a3cc, // n0x03c4 c0x0000 (---------------)  +   is-a-caterer
	0x00105049, // n0x03c5 c0x0000 (---------------)  +   is-a-chef
	0x0002a751, // n0x03c6 c0x0000 (---------------)  +   is-a-conservative
	0x0002cb88, // n0x03c7 c0x0000 (---------------)  +   is-a-cpa
	0x0003e692, // n0x03c8 c0x0000 (---------------)  +   is-a-cubicle-slave
	0x0003f88d, // n0x03c9 c0x0000 (---------------)  +   is-a-democrat
	0x00052a0d, // n0x03ca c0x0000 (---------------)  +   is-a-designer
	0x00055f0b, // n0x03cb c0x0000 (---------------)  +   is-a-doctor
	0x00056e95, // n0x03cc c0x0000 (---------------)  +   is-a-financialadvisor
	0x0005a6c9, // n0x03cd c0x0000 (---------------)  +   is-a-geek
	0x0006468a, // n0x03ce c0x0000 (---------------)  +   is-a-green
	0x00067289, // n0x03cf c0x0000 (---------------)  +   is-a-guru
	0x00067810, // n0x03d0 c0x0000 (---------------)  +   is-a-hard-worker
	0x0006d78b, // n0x03d1 c0x0000 (---------------)  +   is-a-hunter
	0x0006fe0f, // n0x03d2 c0x0000 (---------------)  +   is-a-landscaper
	0x00077d0b, // n0x03d3 c0x0000 (---------------)  +   is-a-lawyer
	0x0007d70c, // n0x03d4 c0x0000 (---------------)  +   is-a-liberal
	0x000842d0, // n0x03d5 c0x0000 (---------------)  +   is-a-libertarian
	0x00093b0a, // n0x03d6 c0x0000 (---------------)  +   is-a-llama
	0x000aa7cd, // n0x03d7 c0x0000 (---------------)  +   is-a-musician
	0x000f394e, // n0x03d8 c0x0000 (---------------)  +   is-a-nascarfan
	0x00092a4a, // n0x03d9 c0x0000 (---------------)  +   is-a-nurse
	0x000933cc, // n0x03da c0x0000 (---------------)  +   is-a-painter
	0x000976d4, // n0x03db c0x0000 (---------------)  +   is-a-personaltrainer
	0x00097f11, // n0x03dc c0x0000 (---------------)  +   is-a-photographer
	0x0009c90b, // n0x03dd c0x0000 (---------------)  +   is-a-player
	0x0009d54f, // n0x03de c0x0000 (---------------)  +   is-a-republican
	0x000a0c0d, // n0x03df c0x0000 (---------------)  +   is-a-rockstar
	0x000a3e4e, // n0x03e0 c0x0000 (---------------)  +   is-a-socialist
	0x000ab0cc, // n0x03e1 c0x0000 (---------------)  +   is-a-student
	0x000ba78c, // n0x03e2 c0x0000 (---------------)  +   is-a-teacher
	0x000aa4cb, // n0x03e3 c0x0000 (---------------)  +   is-a-techie
	0x000af5ce, // n0x03e4 c0x0000 (---------------)  +   is-a-therapist
	0x000b2410, // n0x03e5 c0x0000 (---------------)  +   is-an-accountant
	0x000c730b, // n0x03e6 c0x0000 (---------------)  +   is-an-actor
	0x000bd20d, // n0x03e7 c0x0000 (---------------)  +   is-an-actress
	0x000fdccf, // n0x03e8 c0x0000 (---------------)  +   is-an-anarchist
	0x00101a8c, // n0x03e9 c0x0000 (---------------)  +   is-an-artist
	0x0012608e, // n0x03ea c0x0000 (---------------)  +   is-an-engineer
	0x000c8291, // n0x03eb c0x0000 (---------------)  +   is-an-entertainer
	0x000cec4c, // n0x03ec c0x0000 (---------------)  +   is-certified
	0x000d0587, // n0x03ed c0x0000 (---------------)  +   is-gone
	0x000d1a0d, // n0x03ee c0x0000 (---------------)  +   is-into-anime
	0x000d51cc, // n0x03ef c0x0000 (---------------)  +   is-into-cars
	0x000da650, // n0x03f0 c0x0000 (---------------)  +   is-into-cartoons
	0x000dc58d, // n0x03f1 c0x0000 (---------------)  +   is-into-games
	0x000debc7, // n0x03f2 c0x0000 (---------------)  +   is-leet
	0x000e8c90, // n0x03f3 c0x0000 (---------------)  +   is-not-certified
	0x000f5b08, // n0x03f4 c0x0000 (---------------)  +   is-slick
	0x0010324b, // n0x03f5 c0x0000 (---------------)  +   is-uberleet
	0x0012f98f, // n0x03f6 c0x0000 (---------------)  +   is-with-theband
	0x00043088, // n0x03f7 c0x0000 (---------------)  +   isa-geek
	0x00054d4d, // n0x03f8 c0x0000 (---------------)  +   isa-hockeynut
	0x0008e790, // n0x03f9 c0x0000 (---------------)  +   issmarterthanyou
	0x00090083, // n0x03fa c0x0000 (---------------)  +   jpn
	0x00003b82, // n0x03fb c0x0000 (---------------)  +   kr
	0x00038909, // n0x03fc c0x0000 (---------------)  +   likes-pie
	0x0004614a, // n0x03fd c0x0000 (---------------)  +   likescandy
	0x0005f388, // n0x03fe c0x0000 (---------------)  +   neat-url
	0x000006c2, // n0x03ff c0x0000 (---------------)  +   no
	0x000360ca, // n0x0400 c0x0000 (---------------)  +   operaunite
	0x0002d342, // n0x0401 c0x0000 (---------------)  +   qc
	0x0005f7c7, // n0x0402 c0x0000 (---------------)  +   rhcloud
	0x00003a82, // n0x0403 c0x0000 (---------------)  +   ro
	0x00003e82, // n0x0404 c0x0000 (---------------)  +   ru
	0x00000cc2, // n0x0405 c0x0000 (---------------)  +   sa
	0x000bd510, // n0x0406 c0x0000 (---------------)  +   saves-the-whales
	0x00000482, // n0x0407 c0x0000 (---------------)  +   se
	0x00108ec6, // n0x0408 c0x0000 (---------------)  +   selfip
	0x0007f24e, // n0x0409 c0x0000 (---------------)  +   sells-for-less
	0x00092c4b, // n0x040a c0x0000 (---------------)  +   sells-for-u
	0x000c10c8, // n0x040b c0x0000 (---------------)  +   servebbs
	0x000d398a, // n0x040c c0x0000 (---------------)  +   simple-url
	0x000d7f4d, // n0x040d c0x0000 (---------------)  +   space-to-rent
	0x000fae8c, // n0x040e c0x0000 (---------------)  +   teaches-yoga
	0x00003ec2, // n0x040f c0x0000 (---------------)  +   uk
	0x00002342, // n0x0410 c0x0000 (---------------)  +   us
	0x0001d142, // n0x0411 c0x0000 (---------------)  +   uy
	0x00031a0e, // n0x0412 c0x0000 (---------------)  +   writesthisblog
	0x00002702, // n0x0413 c0x0000 (---------------)  +   za
	0x0ec30c47, // n0x0414 c0x003b (n0x042b-n0x0433)  +   compute
	0x0f030c49, // n0x0415 c0x003c (n0x0433-n0x0435)  +   compute-1
	0x00020fc3, // n0x0416 c0x0000 (---------------)  +   elb
	0x00002282, // n0x0417 c0x0000 (---------------)  +   s3
	0x000b79d1, // n0x0418 c0x0000 (---------------)  +   s3-ap-northeast-1
	0x0010b411, // n0x0419 c0x0000 (---------------)  +   s3-ap-southeast-1
	0x000d92d1, // n0x041a c0x0000 (---------------)  +   s3-ap-southeast-2
	0x0014f74c, // n0x041b c0x0000 (---------------)  +   s3-eu-west-1
	0x00100bd5, // n0x041c c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x0013fb0c, // n0x041d c0x0000 (---------------)  +   s3-sa-east-1
	0x001430d0, // n0x041e c0x0000 (---------------)  +   s3-us-gov-west-1
	0x0000228c, // n0x041f c0x0000 (---------------)  +   s3-us-west-1
	0x0000444c, // n0x0420 c0x0000 (---------------)  +   s3-us-west-2
	0x00009199, // n0x0421 c0x0000 (---------------)  +   s3-website-ap-northeast-1
	0x00009ed9, // n0x0422 c0x0000 (---------------)  +   s3-website-ap-southeast-1
	0x0000bfd9, // n0x0423 c0x0000 (---------------)  +   s3-website-ap-southeast-2
	0x0000f254, // n0x0424 c0x0000 (---------------)  +   s3-website-eu-west-1
	0x00011514, // n0x0425 c0x0000 (---------------)  +   s3-website-sa-east-1
	0x00011c94, // n0x0426 c0x0000 (---------------)  +   s3-website-us-east-1
	0x00014d58, // n0x0427 c0x0000 (---------------)  +   s3-website-us-gov-west-1
	0x0001e494, // n0x0428 c0x0000 (---------------)  +   s3-website-us-west-1
	0x000221d4, // n0x0429 c0x0000 (---------------)  +   s3-website-us-west-2
	0x00011f49, // n0x042a c0x0000 (---------------)  +   us-east-1
	0x0000944e, // n0x042b c0x0000 (---------------)  +   ap-northeast-1
	0x0000a18e, // n0x042c c0x0000 (---------------)  +   ap-southeast-1
	0x0000c28e, // n0x042d c0x0000 (---------------)  +   ap-southeast-2
	0x0000f509, // n0x042e c0x0000 (---------------)  +   eu-west-1
	0x000117c9, // n0x042f c0x0000 (---------------)  +   sa-east-1
	0x0001500d, // n0x0430 c0x0000 (---------------)  +   us-gov-west-1
	0x00002349, // n0x0431 c0x0000 (---------------)  +   us-west-1
	0x00004509, // n0x0432 c0x0000 (---------------)  +   us-west-2
	0x00139503, // n0x0433 c0x0000 (---------------)  +   z-1
	0x00023a03, // n0x0434 c0x0000 (---------------)  +   z-2
	0x002028c2, // n0x0435 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x0436 c0x0000 (---------------)  + I co
	0x00203582, // n0x0437 c0x0000 (---------------)  + I ed
	0x00201ac2, // n0x0438 c0x0000 (---------------)  + I fi
	0x002053c2, // n0x0439 c0x0000 (---------------)  + I go
	0x00204282, // n0x043a c0x0000 (---------------)  + I or
	0x00200cc2, // n0x043b c0x0000 (---------------)  + I sa
	0x002104c3, // n0x043c c0x0000 (---------------)  + I com
	0x002ceec3, // n0x043d c0x0000 (---------------)  + I edu
	0x002150c3, // n0x043e c0x0000 (---------------)  + I gov
	0x002180c3, // n0x043f c0x0000 (---------------)  + I inf
	0x00239bc3, // n0x0440 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0441 c0x0000 (---------------)  + I org
	0x00031c88, // n0x0442 c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x0443 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0444 c0x0000 (---------------)  + I edu
	0x00239bc3, // n0x0445 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0446 c0x0000 (---------------)  + I org
	0x00011bc3, // n0x0447 c0x0000 (---------------)  +   ath
	0x002150c3, // n0x0448 c0x0000 (---------------)  + I gov
	0x00031c88, // n0x0449 c0x0000 (---------------)  +   blogspot
	0x00031c88, // n0x044a c0x0000 (---------------)  +   blogspot
	0x000104c3, // n0x044b c0x0000 (---------------)  +   com
	0x000d0b4f, // n0x044c c0x0000 (---------------)  +   fuettertdasnetz
	0x0002ed4a, // n0x044d c0x0000 (---------------)  +   isteingeek
	0x0010c6c7, // n0x044e c0x0000 (---------------)  +   istmein
	0x00039a4a, // n0x044f c0x0000 (---------------)  +   lebtimnetz
	0x0012a7ca, // n0x0450 c0x0000 (---------------)  +   leitungsen
	0x0011b64d, // n0x0451 c0x0000 (---------------)  +   traeumtgerade
	0x00031c88, // n0x0452 c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x0453 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0454 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0455 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0456 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0457 c0x0000 (---------------)  + I org
	0x0020c703, // n0x0458 c0x0000 (---------------)  + I art
	0x002104c3, // n0x0459 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x045a c0x0000 (---------------)  + I edu
	0x00230083, // n0x045b c0x0000 (---------------)  + I gob
	0x002150c3, // n0x045c c0x0000 (---------------)  + I gov
	0x0025f683, // n0x045d c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x045e c0x0000 (---------------)  + I net
	0x002453c3, // n0x045f c0x0000 (---------------)  + I org
	0x002c7b43, // n0x0460 c0x0000 (---------------)  + I sld
	0x00209243, // n0x0461 c0x0000 (---------------)  + I web
	0x0020c703, // n0x0462 c0x0000 (---------------)  + I art
	0x00202f44, // n0x0463 c0x0000 (---------------)  + I asso
	0x002104c3, // n0x0464 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0465 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0466 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0467 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0468 c0x0000 (---------------)  + I org
	0x0020cc43, // n0x0469 c0x0000 (---------------)  + I pol
	0x002104c3, // n0x046a c0x0000 (---------------)  + I com
	0x002ceec3, // n0x046b c0x0000 (---------------)  + I edu
	0x0023fdc3, // n0x046c c0x0000 (---------------)  + I fin
	0x00230083, // n0x046d c0x0000 (---------------)  + I gob
	0x002150c3, // n0x046e c0x0000 (---------------)  + I gov
	0x002180c4, // n0x046f c0x0000 (---------------)  + I info
	0x002edec3, // n0x0470 c0x0000 (---------------)  + I k12
	0x002382c3, // n0x0471 c0x0000 (---------------)  + I med
	0x0025f683, // n0x0472 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0473 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0474 c0x0000 (---------------)  + I org
	0x002c5983, // n0x0475 c0x0000 (---------------)  + I pro
	0x0025f203, // n0x0476 c0x0000 (---------------)  + I aip
	0x002104c3, // n0x0477 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0478 c0x0000 (---------------)  + I edu
	0x0023dbc3, // n0x0479 c0x0000 (---------------)  + I fie
	0x002150c3, // n0x047a c0x0000 (---------------)  + I gov
	0x00208d43, // n0x047b c0x0000 (---------------)  + I lib
	0x002382c3, // n0x047c c0x0000 (---------------)  + I med
	0x002453c3, // n0x047d c0x0000 (---------------)  + I org
	0x00223043, // n0x047e c0x0000 (---------------)  + I pri
	0x0020d884, // n0x047f c0x0000 (---------------)  + I riik
	0x002104c3, // n0x0480 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0481 c0x0000 (---------------)  + I edu
	0x00289783, // n0x0482 c0x0000 (---------------)  + I eun
	0x002150c3, // n0x0483 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0484 c0x0000 (---------------)  + I mil
	0x002d16c4, // n0x0485 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x0486 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0487 c0x0000 (---------------)  + I org
	0x00201e43, // n0x0488 c0x0000 (---------------)  + I sci
	0x132104c3, // n0x0489 c0x004c (n0x048e-n0x048f)  + I com
	0x002ceec3, // n0x048a c0x0000 (---------------)  + I edu
	0x00230083, // n0x048b c0x0000 (---------------)  + I gob
	0x002006c3, // n0x048c c0x0000 (---------------)  + I nom
	0x002453c3, // n0x048d c0x0000 (---------------)  + I org
	0x00031c88, // n0x048e c0x0000 (---------------)  +   blogspot
	0x002a7085, // n0x048f c0x0000 (---------------)  + I aland
	0x00031c88, // n0x0490 c0x0000 (---------------)  +   blogspot
	0x00005c03, // n0x0491 c0x0000 (---------------)  +   iki
	0x002fa248, // n0x0492 c0x0000 (---------------)  + I aeroport
	0x002a0387, // n0x0493 c0x0000 (---------------)  + I assedic
	0x00202f44, // n0x0494 c0x0000 (---------------)  + I asso
	0x002f7d06, // n0x0495 c0x0000 (---------------)  + I avocat
	0x0030b2c6, // n0x0496 c0x0000 (---------------)  + I avoues
	0x00031c88, // n0x0497 c0x0000 (---------------)  +   blogspot
	0x002f29c3, // n0x0498 c0x0000 (---------------)  + I cci
	0x00206249, // n0x0499 c0x0000 (---------------)  + I chambagri
	0x002cbbd5, // n0x049a c0x0000 (---------------)  + I chirurgiens-dentistes
	0x002104c3, // n0x049b c0x0000 (---------------)  + I com
	0x00300792, // n0x049c c0x0000 (---------------)  + I experts-comptables
	0x0030054f, // n0x049d c0x0000 (---------------)  + I geometre-expert
	0x0022fa44, // n0x049e c0x0000 (---------------)  + I gouv
	0x0023a385, // n0x049f c0x0000 (---------------)  + I greta
	0x0028c6d0, // n0x04a0 c0x0000 (---------------)  + I huissier-justice
	0x002910c7, // n0x04a1 c0x0000 (---------------)  + I medecin
	0x002006c3, // n0x04a2 c0x0000 (---------------)  + I nom
	0x00253e08, // n0x04a3 c0x0000 (---------------)  + I notaires
	0x002bb40a, // n0x04a4 c0x0000 (---------------)  + I pharmacien
	0x0029fc44, // n0x04a5 c0x0000 (---------------)  + I port
	0x00259843, // n0x04a6 c0x0000 (---------------)  + I prd
	0x0020e2c6, // n0x04a7 c0x0000 (---------------)  + I presse
	0x0023d502, // n0x04a8 c0x0000 (---------------)  + I tm
	0x002c670b, // n0x04a9 c0x0000 (---------------)  + I veterinaire
	0x002104c3, // n0x04aa c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04ab c0x0000 (---------------)  + I edu
	0x002150c3, // n0x04ac c0x0000 (---------------)  + I gov
	0x0025f683, // n0x04ad c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x04ae c0x0000 (---------------)  + I net
	0x002453c3, // n0x04af c0x0000 (---------------)  + I org
	0x002c75c3, // n0x04b0 c0x0000 (---------------)  + I pvt
	0x00208f82, // n0x04b1 c0x0000 (---------------)  + I co
	0x002150c3, // n0x04b2 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x04b3 c0x0000 (---------------)  + I net
	0x002453c3, // n0x04b4 c0x0000 (---------------)  + I org
	0x00204343, // n0x04b5 c0x0000 (---------------)  + I sch
	0x002104c3, // n0x04b6 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04b7 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x04b8 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x04b9 c0x0000 (---------------)  + I mil
	0x002453c3, // n0x04ba c0x0000 (---------------)  + I org
	0x002104c3, // n0x04bb c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04bc c0x0000 (---------------)  + I edu
	0x002150c3, // n0x04bd c0x0000 (---------------)  + I gov
	0x00231743, // n0x04be c0x0000 (---------------)  + I ltd
	0x00250983, // n0x04bf c0x0000 (---------------)  + I mod
	0x002453c3, // n0x04c0 c0x0000 (---------------)  + I org
	0x002028c2, // n0x04c1 c0x0000 (---------------)  + I ac
	0x002104c3, // n0x04c2 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04c3 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x04c4 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x04c5 c0x0000 (---------------)  + I net
	0x002453c3, // n0x04c6 c0x0000 (---------------)  + I org
	0x00202f44, // n0x04c7 c0x0000 (---------------)  + I asso
	0x002104c3, // n0x04c8 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04c9 c0x0000 (---------------)  + I edu
	0x0020adc4, // n0x04ca c0x0000 (---------------)  + I mobi
	0x00239bc3, // n0x04cb c0x0000 (---------------)  + I net
	0x002453c3, // n0x04cc c0x0000 (---------------)  + I org
	0x00031c88, // n0x04cd c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x04ce c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04cf c0x0000 (---------------)  + I edu
	0x002150c3, // n0x04d0 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x04d1 c0x0000 (---------------)  + I net
	0x002453c3, // n0x04d2 c0x0000 (---------------)  + I org
	0x002104c3, // n0x04d3 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04d4 c0x0000 (---------------)  + I edu
	0x00230083, // n0x04d5 c0x0000 (---------------)  + I gob
	0x0020ca83, // n0x04d6 c0x0000 (---------------)  + I ind
	0x0025f683, // n0x04d7 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x04d8 c0x0000 (---------------)  + I net
	0x002453c3, // n0x04d9 c0x0000 (---------------)  + I org
	0x00208f82, // n0x04da c0x0000 (---------------)  + I co
	0x002104c3, // n0x04db c0x0000 (---------------)  + I com
	0x00239bc3, // n0x04dc c0x0000 (---------------)  + I net
	0x00031c88, // n0x04dd c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x04de c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04df c0x0000 (---------------)  + I edu
	0x002150c3, // n0x04e0 c0x0000 (---------------)  + I gov
	0x0025a343, // n0x04e1 c0x0000 (---------------)  + I idv
	0x00239bc3, // n0x04e2 c0x0000 (---------------)  + I net
	0x002453c3, // n0x04e3 c0x0000 (---------------)  + I org
	0x002d370a, // n0x04e4 c0x0000 (---------------)  + I xn--55qx5d
	0x002f5ec9, // n0x04e5 c0x0000 (---------------)  + I xn--ciqpn
	0x00307bcb, // n0x04e6 c0x0000 (---------------)  + I xn--gmq050i
	0x0030850a, // n0x04e7 c0x0000 (---------------)  + I xn--gmqw5a
	0x0031010a, // n0x04e8 c0x0000 (---------------)  + I xn--io0a7i
	0x003177cb, // n0x04e9 c0x0000 (---------------)  + I xn--lcvr32d
	0x0032680a, // n0x04ea c0x0000 (---------------)  + I xn--mk0axi
	0x0032a44a, // n0x04eb c0x0000 (---------------)  + I xn--mxtq1m
	0x0032da4a, // n0x04ec c0x0000 (---------------)  + I xn--od0alg
	0x0032dccb, // n0x04ed c0x0000 (---------------)  + I xn--od0aq3b
	0x003437c9, // n0x04ee c0x0000 (---------------)  + I xn--tn0ag
	0x0034748a, // n0x04ef c0x0000 (---------------)  + I xn--uc0atv
	0x0034794b, // n0x04f0 c0x0000 (---------------)  + I xn--uc0ay4a
	0x0034c54b, // n0x04f1 c0x0000 (---------------)  + I xn--wcvs22d
	0x0035248a, // n0x04f2 c0x0000 (---------------)  + I xn--zf0avx
	0x002104c3, // n0x04f3 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x04f4 c0x0000 (---------------)  + I edu
	0x00230083, // n0x04f5 c0x0000 (---------------)  + I gob
	0x0025f683, // n0x04f6 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x04f7 c0x0000 (---------------)  + I net
	0x002453c3, // n0x04f8 c0x0000 (---------------)  + I org
	0x002104c3, // n0x04f9 c0x0000 (---------------)  + I com
	0x0024ac44, // n0x04fa c0x0000 (---------------)  + I from
	0x00201182, // n0x04fb c0x0000 (---------------)  + I iz
	0x002d16c4, // n0x04fc c0x0000 (---------------)  + I name
	0x0027a0c5, // n0x04fd c0x0000 (---------------)  + I adult
	0x0020c703, // n0x04fe c0x0000 (---------------)  + I art
	0x00202f44, // n0x04ff c0x0000 (---------------)  + I asso
	0x002104c3, // n0x0500 c0x0000 (---------------)  + I com
	0x00236044, // n0x0501 c0x0000 (---------------)  + I coop
	0x002ceec3, // n0x0502 c0x0000 (---------------)  + I edu
	0x00240684, // n0x0503 c0x0000 (---------------)  + I firm
	0x0022fa44, // n0x0504 c0x0000 (---------------)  + I gouv
	0x002180c4, // n0x0505 c0x0000 (---------------)  + I info
	0x002382c3, // n0x0506 c0x0000 (---------------)  + I med
	0x00239bc3, // n0x0507 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0508 c0x0000 (---------------)  + I org
	0x00297805, // n0x0509 c0x0000 (---------------)  + I perso
	0x0020cc43, // n0x050a c0x0000 (---------------)  + I pol
	0x002c5983, // n0x050b c0x0000 (---------------)  + I pro
	0x00202143, // n0x050c c0x0000 (---------------)  + I rel
	0x00227ec4, // n0x050d c0x0000 (---------------)  + I shop
	0x0025fec4, // n0x050e c0x0000 (---------------)  + I 2000
	0x003073c5, // n0x050f c0x0000 (---------------)  + I agrar
	0x00031c88, // n0x0510 c0x0000 (---------------)  +   blogspot
	0x002e3604, // n0x0511 c0x0000 (---------------)  + I bolt
	0x002160c6, // n0x0512 c0x0000 (---------------)  + I casino
	0x00225ec4, // n0x0513 c0x0000 (---------------)  + I city
	0x00208f82, // n0x0514 c0x0000 (---------------)  + I co
	0x00299407, // n0x0515 c0x0000 (---------------)  + I erotica
	0x003443c7, // n0x0516 c0x0000 (---------------)  + I erotika
	0x0023f584, // n0x0517 c0x0000 (---------------)  + I film
	0x00247cc5, // n0x0518 c0x0000 (---------------)  + I forum
	0x002dc785, // n0x0519 c0x0000 (---------------)  + I games
	0x0028ba85, // n0x051a c0x0000 (---------------)  + I hotel
	0x002180c4, // n0x051b c0x0000 (---------------)  + I info
	0x002da288, // n0x051c c0x0000 (---------------)  + I ingatlan
	0x002eca86, // n0x051d c0x0000 (---------------)  + I jogasz
	0x00353648, // n0x051e c0x0000 (---------------)  + I konyvelo
	0x00219f05, // n0x051f c0x0000 (---------------)  + I lakas
	0x002e2905, // n0x0520 c0x0000 (---------------)  + I media
	0x0030cc44, // n0x0521 c0x0000 (---------------)  + I news
	0x002453c3, // n0x0522 c0x0000 (---------------)  + I org
	0x002c5804, // n0x0523 c0x0000 (---------------)  + I priv
	0x002065c6, // n0x0524 c0x0000 (---------------)  + I reklam
	0x0020e3c3, // n0x0525 c0x0000 (---------------)  + I sex
	0x00227ec4, // n0x0526 c0x0000 (---------------)  + I shop
	0x0034a985, // n0x0527 c0x0000 (---------------)  + I sport
	0x00238884, // n0x0528 c0x0000 (---------------)  + I suli
	0x0021c2c4, // n0x0529 c0x0000 (---------------)  + I szex
	0x0023d502, // n0x052a c0x0000 (---------------)  + I tm
	0x002ab386, // n0x052b c0x0000 (---------------)  + I tozsde
	0x0033a246, // n0x052c c0x0000 (---------------)  + I utazas
	0x002e24c5, // n0x052d c0x0000 (---------------)  + I video
	0x002028c2, // n0x052e c0x0000 (---------------)  + I ac
	0x002b5183, // n0x052f c0x0000 (---------------)  + I biz
	0x00208f82, // n0x0530 c0x0000 (---------------)  + I co
	0x002053c2, // n0x0531 c0x0000 (---------------)  + I go
	0x0025f683, // n0x0532 c0x0000 (---------------)  + I mil
	0x002246c2, // n0x0533 c0x0000 (---------------)  + I my
	0x00239bc3, // n0x0534 c0x0000 (---------------)  + I net
	0x00204282, // n0x0535 c0x0000 (---------------)  + I or
	0x00204343, // n0x0536 c0x0000 (---------------)  + I sch
	0x00209243, // n0x0537 c0x0000 (---------------)  + I web
	0x00031c88, // n0x0538 c0x0000 (---------------)  +   blogspot
	0x002150c3, // n0x0539 c0x0000 (---------------)  + I gov
	0x18208f82, // n0x053a c0x0060 (n0x053b-n0x053c)  o I co
	0x00031c88, // n0x053b c0x0000 (---------------)  +   blogspot
	0x002028c2, // n0x053c c0x0000 (---------------)  + I ac
	0x18a08f82, // n0x053d c0x0062 (n0x0542-n0x0544)  + I co
	0x002150c3, // n0x053e c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x053f c0x0000 (---------------)  + I net
	0x002131c3, // n0x0540 c0x0000 (---------------)  + I nic
	0x002453c3, // n0x0541 c0x0000 (---------------)  + I org
	0x00231743, // n0x0542 c0x0000 (---------------)  + I ltd
	0x002c1843, // n0x0543 c0x0000 (---------------)  + I plc
	0x002028c2, // n0x0544 c0x0000 (---------------)  + I ac
	0x00031c88, // n0x0545 c0x0000 (---------------)  +   blogspot
	0x00208f82, // n0x0546 c0x0000 (---------------)  + I co
	0x002ceec3, // n0x0547 c0x0000 (---------------)  + I edu
	0x00240684, // n0x0548 c0x0000 (---------------)  + I firm
	0x00205ec3, // n0x0549 c0x0000 (---------------)  + I gen
	0x002150c3, // n0x054a c0x0000 (---------------)  + I gov
	0x0020ca83, // n0x054b c0x0000 (---------------)  + I ind
	0x0025f683, // n0x054c c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x054d c0x0000 (---------------)  + I net
	0x002131c3, // n0x054e c0x0000 (---------------)  + I nic
	0x002453c3, // n0x054f c0x0000 (---------------)  + I org
	0x0020e303, // n0x0550 c0x0000 (---------------)  + I res
	0x00100113, // n0x0551 c0x0000 (---------------)  +   barrel-of-knowledge
	0x0010acd4, // n0x0552 c0x0000 (---------------)  +   barrell-of-knowledge
	0x00007546, // n0x0553 c0x0000 (---------------)  +   dyndns
	0x00043f07, // n0x0554 c0x0000 (---------------)  +   for-our
	0x000fc0c9, // n0x0555 c0x0000 (---------------)  +   groks-the
	0x0013088a, // n0x0556 c0x0000 (---------------)  +   groks-this
	0x0006c3cd, // n0x0557 c0x0000 (---------------)  +   here-for-more
	0x000754ca, // n0x0558 c0x0000 (---------------)  +   knowsitall
	0x00108ec6, // n0x0559 c0x0000 (---------------)  +   selfip
	0x00017306, // n0x055a c0x0000 (---------------)  +   webhop
	0x0020f502, // n0x055b c0x0000 (---------------)  + I eu
	0x002104c3, // n0x055c c0x0000 (---------------)  + I com
	0x000a6206, // n0x055d c0x0000 (---------------)  +   github
	0x002104c3, // n0x055e c0x0000 (---------------)  + I com
	0x002ceec3, // n0x055f c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0560 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0561 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0562 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0563 c0x0000 (---------------)  + I org
	0x002028c2, // n0x0564 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x0565 c0x0000 (---------------)  + I co
	0x002150c3, // n0x0566 c0x0000 (---------------)  + I gov
	0x0020ab82, // n0x0567 c0x0000 (---------------)  + I id
	0x00239bc3, // n0x0568 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0569 c0x0000 (---------------)  + I org
	0x00204343, // n0x056a c0x0000 (---------------)  + I sch
	0x00321a0f, // n0x056b c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x00321dce, // n0x056c c0x0000 (---------------)  + I xn--mgba3a4fra
	0x002104c3, // n0x056d c0x0000 (---------------)  + I com
	0x002ceec3, // n0x056e c0x0000 (---------------)  + I edu
	0x002150c3, // n0x056f c0x0000 (---------------)  + I gov
	0x0021fe43, // n0x0570 c0x0000 (---------------)  + I int
	0x00239bc3, // n0x0571 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0572 c0x0000 (---------------)  + I org
	0x00204882, // n0x0573 c0x0000 (---------------)  + I ag
	0x00343989, // n0x0574 c0x0000 (---------------)  + I agrigento
	0x00201dc2, // n0x0575 c0x0000 (---------------)  + I al
	0x002bd80b, // n0x0576 c0x0000 (---------------)  + I alessandria
	0x00232eca, // n0x0577 c0x0000 (---------------)  + I alto-adige
	0x002ecec9, // n0x0578 c0x0000 (---------------)  + I altoadige
	0x00200a82, // n0x0579 c0x0000 (---------------)  + I an
	0x00291406, // n0x057a c0x0000 (---------------)  + I ancona
	0x002deed5, // n0x057b c0x0000 (---------------)  + I andria-barletta-trani
	0x002bd955, // n0x057c c0x0000 (---------------)  + I andria-trani-barletta
	0x00303613, // n0x057d c0x0000 (---------------)  + I andriabarlettatrani
	0x002bded3, // n0x057e c0x0000 (---------------)  + I andriatranibarletta
	0x00200d02, // n0x057f c0x0000 (---------------)  + I ao
	0x00224e05, // n0x0580 c0x0000 (---------------)  + I aosta
	0x002a8d85, // n0x0581 c0x0000 (---------------)  + I aoste
	0x00208602, // n0x0582 c0x0000 (---------------)  + I ap
	0x00269742, // n0x0583 c0x0000 (---------------)  + I aq
	0x002b9006, // n0x0584 c0x0000 (---------------)  + I aquila
	0x00203902, // n0x0585 c0x0000 (---------------)  + I ar
	0x0026f306, // n0x0586 c0x0000 (---------------)  + I arezzo
	0x00278c4d, // n0x0587 c0x0000 (---------------)  + I ascoli-piceno
	0x00232a0c, // n0x0588 c0x0000 (---------------)  + I ascolipiceno
	0x0021cd44, // n0x0589 c0x0000 (---------------)  + I asti
	0x00200982, // n0x058a c0x0000 (---------------)  + I at
	0x0020e042, // n0x058b c0x0000 (---------------)  + I av
	0x0029ed88, // n0x058c c0x0000 (---------------)  + I avellino
	0x00201242, // n0x058d c0x0000 (---------------)  + I ba
	0x002b4a86, // n0x058e c0x0000 (---------------)  + I balsan
	0x00234384, // n0x058f c0x0000 (---------------)  + I bari
	0x002df095, // n0x0590 c0x0000 (---------------)  + I barletta-trani-andria
	0x00303793, // n0x0591 c0x0000 (---------------)  + I barlettatraniandria
	0x0031cb07, // n0x0592 c0x0000 (---------------)  + I belluno
	0x003094c9, // n0x0593 c0x0000 (---------------)  + I benevento
	0x002ed6c7, // n0x0594 c0x0000 (---------------)  + I bergamo
	0x0033c7c2, // n0x0595 c0x0000 (---------------)  + I bg
	0x00200002, // n0x0596 c0x0000 (---------------)  + I bi
	0x002014c6, // n0x0597 c0x0000 (---------------)  + I biella
	0x0020be42, // n0x0598 c0x0000 (---------------)  + I bl
	0x00031c88, // n0x0599 c0x0000 (---------------)  +   blogspot
	0x002a96c2, // n0x059a c0x0000 (---------------)  + I bn
	0x00207c82, // n0x059b c0x0000 (---------------)  + I bo
	0x0033dfc7, // n0x059c c0x0000 (---------------)  + I bologna
	0x00210d47, // n0x059d c0x0000 (---------------)  + I bolzano
	0x002182c5, // n0x059e c0x0000 (---------------)  + I bozen
	0x00203e42, // n0x059f c0x0000 (---------------)  + I br
	0x00219ac7, // n0x05a0 c0x0000 (---------------)  + I brescia
	0x00219c88, // n0x05a1 c0x0000 (---------------)  + I brindisi
	0x002092c2, // n0x05a2 c0x0000 (---------------)  + I bs
	0x00239ac2, // n0x05a3 c0x0000 (---------------)  + I bt
	0x00225d42, // n0x05a4 c0x0000 (---------------)  + I bz
	0x00200402, // n0x05a5 c0x0000 (---------------)  + I ca
	0x0021b788, // n0x05a6 c0x0000 (---------------)  + I cagliari
	0x002383cd, // n0x05a7 c0x0000 (---------------)  + I caltanissetta
	0x002443cf, // n0x05a8 c0x0000 (---------------)  + I campidano-medio
	0x0024478e, // n0x05a9 c0x0000 (---------------)  + I campidanomedio
	0x00202dca, // n0x05aa c0x0000 (---------------)  + I campobasso
	0x00220451, // n0x05ab c0x0000 (---------------)  + I carbonia-iglesias
	0x002208d0, // n0x05ac c0x0000 (---------------)  + I carboniaiglesias
	0x00271b8d, // n0x05ad c0x0000 (---------------)  + I carrara-massa
	0x00271ecc, // n0x05ae c0x0000 (---------------)  + I carraramassa
	0x00200407, // n0x05af c0x0000 (---------------)  + I caserta
	0x002f7dc7, // n0x05b0 c0x0000 (---------------)  + I catania
	0x0022d389, // n0x05b1 c0x0000 (---------------)  + I catanzaro
	0x0021ce42, // n0x05b2 c0x0000 (---------------)  + I cb
	0x00201982, // n0x05b3 c0x0000 (---------------)  + I ce
	0x00245c0c, // n0x05b4 c0x0000 (---------------)  + I cesena-forli
	0x00245f0b, // n0x05b5 c0x0000 (---------------)  + I cesenaforli
	0x00200a02, // n0x05b6 c0x0000 (---------------)  + I ch
	0x002aa686, // n0x05b7 c0x0000 (---------------)  + I chieti
	0x00201e82, // n0x05b8 c0x0000 (---------------)  + I ci
	0x00200b42, // n0x05b9 c0x0000 (---------------)  + I cl
	0x0022dc82, // n0x05ba c0x0000 (---------------)  + I cn
	0x00208f82, // n0x05bb c0x0000 (---------------)  + I co
	0x002104c4, // n0x05bc c0x0000 (---------------)  + I como
	0x00237b07, // n0x05bd c0x0000 (---------------)  + I cosenza
	0x00239282, // n0x05be c0x0000 (---------------)  + I cr
	0x0023adc7, // n0x05bf c0x0000 (---------------)  + I cremona
	0x0023b6c7, // n0x05c0 c0x0000 (---------------)  + I crotone
	0x0021b3c2, // n0x05c1 c0x0000 (---------------)  + I cs
	0x00231542, // n0x05c2 c0x0000 (---------------)  + I ct
	0x0023c9c5, // n0x05c3 c0x0000 (---------------)  + I cuneo
	0x002026c2, // n0x05c4 c0x0000 (---------------)  + I cz
	0x0024710e, // n0x05c5 c0x0000 (---------------)  + I dell-ogliastra
	0x0024ca8d, // n0x05c6 c0x0000 (---------------)  + I dellogliastra
	0x002ceec3, // n0x05c7 c0x0000 (---------------)  + I edu
	0x00201f02, // n0x05c8 c0x0000 (---------------)  + I en
	0x0024f9c4, // n0x05c9 c0x0000 (---------------)  + I enna
	0x002bf1c2, // n0x05ca c0x0000 (---------------)  + I fc
	0x00232102, // n0x05cb c0x0000 (---------------)  + I fe
	0x002c5f45, // n0x05cc c0x0000 (---------------)  + I fermo
	0x00321847, // n0x05cd c0x0000 (---------------)  + I ferrara
	0x00330842, // n0x05ce c0x0000 (---------------)  + I fg
	0x00201ac2, // n0x05cf c0x0000 (---------------)  + I fi
	0x002404c7, // n0x05d0 c0x0000 (---------------)  + I firenze
	0x00242908, // n0x05d1 c0x0000 (---------------)  + I florence
	0x00332782, // n0x05d2 c0x0000 (---------------)  + I fm
	0x00218146, // n0x05d3 c0x0000 (---------------)  + I foggia
	0x00245a8c, // n0x05d4 c0x0000 (---------------)  + I forli-cesena
	0x00245dcb, // n0x05d5 c0x0000 (---------------)  + I forlicesena
	0x002108c2, // n0x05d6 c0x0000 (---------------)  + I fr
	0x0025ea09, // n0x05d7 c0x0000 (---------------)  + I frosinone
	0x00201302, // n0x05d8 c0x0000 (---------------)  + I ge
	0x0020d385, // n0x05d9 c0x0000 (---------------)  + I genoa
	0x00212ec6, // n0x05da c0x0000 (---------------)  + I genova
	0x002053c2, // n0x05db c0x0000 (---------------)  + I go
	0x002b01c7, // n0x05dc c0x0000 (---------------)  + I gorizia
	0x002150c3, // n0x05dd c0x0000 (---------------)  + I gov
	0x002063c2, // n0x05de c0x0000 (---------------)  + I gr
	0x0023e088, // n0x05df c0x0000 (---------------)  + I grosseto
	0x00220691, // n0x05e0 c0x0000 (---------------)  + I iglesias-carbonia
	0x00220ad0, // n0x05e1 c0x0000 (---------------)  + I iglesiascarbonia
	0x0020e682, // n0x05e2 c0x0000 (---------------)  + I im
	0x0020f907, // n0x05e3 c0x0000 (---------------)  + I imperia
	0x002005c2, // n0x05e4 c0x0000 (---------------)  + I is
	0x00237347, // n0x05e5 c0x0000 (---------------)  + I isernia
	0x00203b82, // n0x05e6 c0x0000 (---------------)  + I kr
	0x0029c509, // n0x05e7 c0x0000 (---------------)  + I la-spezia
	0x002b8fc7, // n0x05e8 c0x0000 (---------------)  + I laquila
	0x00259f08, // n0x05e9 c0x0000 (---------------)  + I laspezia
	0x002a2186, // n0x05ea c0x0000 (---------------)  + I latina
	0x00213702, // n0x05eb c0x0000 (---------------)  + I lc
	0x002018c2, // n0x05ec c0x0000 (---------------)  + I le
	0x002018c5, // n0x05ed c0x0000 (---------------)  + I lecce
	0x00239e05, // n0x05ee c0x0000 (---------------)  + I lecco
	0x00208d42, // n0x05ef c0x0000 (---------------)  + I li
	0x00351847, // n0x05f0 c0x0000 (---------------)  + I livorno
	0x00200b82, // n0x05f1 c0x0000 (---------------)  + I lo
	0x00246b44, // n0x05f2 c0x0000 (---------------)  + I lodi
	0x00206502, // n0x05f3 c0x0000 (---------------)  + I lt
	0x00209882, // n0x05f4 c0x0000 (---------------)  + I lu
	0x00220385, // n0x05f5 c0x0000 (---------------)  + I lucca
	0x002f3108, // n0x05f6 c0x0000 (---------------)  + I macerata
	0x00287487, // n0x05f7 c0x0000 (---------------)  + I mantova
	0x00271a0d, // n0x05f8 c0x0000 (---------------)  + I massa-carrara
	0x00271d8c, // n0x05f9 c0x0000 (---------------)  + I massacarrara
	0x002969c6, // n0x05fa c0x0000 (---------------)  + I matera
	0x00206302, // n0x05fb c0x0000 (---------------)  + I mb
	0x002c95c2, // n0x05fc c0x0000 (---------------)  + I mc
	0x00208202, // n0x05fd c0x0000 (---------------)  + I me
	0x0024424f, // n0x05fe c0x0000 (---------------)  + I medio-campidano
	0x0024464e, // n0x05ff c0x0000 (---------------)  + I mediocampidano
	0x002eaac7, // n0x0600 c0x0000 (---------------)  + I messina
	0x00200e02, // n0x0601 c0x0000 (---------------)  + I mi
	0x002a79c5, // n0x0602 c0x0000 (---------------)  + I milan
	0x002a79c6, // n0x0603 c0x0000 (---------------)  + I milano
	0x00203cc2, // n0x0604 c0x0000 (---------------)  + I mn
	0x0020a782, // n0x0605 c0x0000 (---------------)  + I mo
	0x00282406, // n0x0606 c0x0000 (---------------)  + I modena
	0x002add05, // n0x0607 c0x0000 (---------------)  + I monza
	0x002add0d, // n0x0608 c0x0000 (---------------)  + I monza-brianza
	0x002ae055, // n0x0609 c0x0000 (---------------)  + I monza-e-della-brianza
	0x002ae58c, // n0x060a c0x0000 (---------------)  + I monzabrianza
	0x002ae88d, // n0x060b c0x0000 (---------------)  + I monzaebrianza
	0x002aebd2, // n0x060c c0x0000 (---------------)  + I monzaedellabrianza
	0x00222fc2, // n0x060d c0x0000 (---------------)  + I ms
	0x00252e82, // n0x060e c0x0000 (---------------)  + I mt
	0x00201c82, // n0x060f c0x0000 (---------------)  + I na
	0x00322146, // n0x0610 c0x0000 (---------------)  + I naples
	0x0020cbc6, // n0x0611 c0x0000 (---------------)  + I napoli
	0x002006c2, // n0x0612 c0x0000 (---------------)  + I no
	0x00212f46, // n0x0613 c0x0000 (---------------)  + I novara
	0x00252942, // n0x0614 c0x0000 (---------------)  + I nu
	0x00350345, // n0x0615 c0x0000 (---------------)  + I nuoro
	0x00205242, // n0x0616 c0x0000 (---------------)  + I og
	0x00247249, // n0x0617 c0x0000 (---------------)  + I ogliastra
	0x0029024c, // n0x0618 c0x0000 (---------------)  + I olbia-tempio
	0x0029058b, // n0x0619 c0x0000 (---------------)  + I olbiatempio
	0x00204282, // n0x061a c0x0000 (---------------)  + I or
	0x00304448, // n0x061b c0x0000 (---------------)  + I oristano
	0x00208fc2, // n0x061c c0x0000 (---------------)  + I ot
	0x00211382, // n0x061d c0x0000 (---------------)  + I pa
	0x0021f006, // n0x061e c0x0000 (---------------)  + I padova
	0x00322e85, // n0x061f c0x0000 (---------------)  + I padua
	0x00214407, // n0x0620 c0x0000 (---------------)  + I palermo
	0x00287a85, // n0x0621 c0x0000 (---------------)  + I parma
	0x002bb105, // n0x0622 c0x0000 (---------------)  + I pavia
	0x002cea02, // n0x0623 c0x0000 (---------------)  + I pc
	0x00227fc2, // n0x0624 c0x0000 (---------------)  + I pd
	0x00208682, // n0x0625 c0x0000 (---------------)  + I pe
	0x00270107, // n0x0626 c0x0000 (---------------)  + I perugia
	0x002c4b0d, // n0x0627 c0x0000 (---------------)  + I pesaro-urbino
	0x002c4e8c, // n0x0628 c0x0000 (---------------)  + I pesarourbino
	0x002bb247, // n0x0629 c0x0000 (---------------)  + I pescara
	0x0031ce02, // n0x062a c0x0000 (---------------)  + I pg
	0x0021b342, // n0x062b c0x0000 (---------------)  + I pi
	0x0024ff48, // n0x062c c0x0000 (---------------)  + I piacenza
	0x00243044, // n0x062d c0x0000 (---------------)  + I pisa
	0x002af847, // n0x062e c0x0000 (---------------)  + I pistoia
	0x002900c2, // n0x062f c0x0000 (---------------)  + I pn
	0x00202e82, // n0x0630 c0x0000 (---------------)  + I po
	0x002c3909, // n0x0631 c0x0000 (---------------)  + I pordenone
	0x00298507, // n0x0632 c0x0000 (---------------)  + I potenza
	0x0020e2c2, // n0x0633 c0x0000 (---------------)  + I pr
	0x0031dd05, // n0x0634 c0x0000 (---------------)  + I prato
	0x002c6682, // n0x0635 c0x0000 (---------------)  + I pt
	0x0020a982, // n0x0636 c0x0000 (---------------)  + I pu
	0x002c75c2, // n0x0637 c0x0000 (---------------)  + I pv
	0x002c7a42, // n0x0638 c0x0000 (---------------)  + I pz
	0x00201d82, // n0x0639 c0x0000 (---------------)  + I ra
	0x002fb286, // n0x063a c0x0000 (---------------)  + I ragusa
	0x0028de47, // n0x063b c0x0000 (---------------)  + I ravenna
	0x002281c2, // n0x063c c0x0000 (---------------)  + I rc
	0x00202142, // n0x063d c0x0000 (---------------)  + I re
	0x002b154f, // n0x063e c0x0000 (---------------)  + I reggio-calabria
	0x002c694d, // n0x063f c0x0000 (---------------)  + I reggio-emilia
	0x0021a80e, // n0x0640 c0x0000 (---------------)  + I reggiocalabria
	0x0034cd0c, // n0x0641 c0x0000 (---------------)  + I reggioemilia
	0x00208882, // n0x0642 c0x0000 (---------------)  + I rg
	0x002042c2, // n0x0643 c0x0000 (---------------)  + I ri
	0x00221805, // n0x0644 c0x0000 (---------------)  + I rieti
	0x002894c6, // n0x0645 c0x0000 (---------------)  + I rimini
	0x00214502, // n0x0646 c0x0000 (---------------)  + I rm
	0x00215a02, // n0x0647 c0x0000 (---------------)  + I rn
	0x00203a82, // n0x0648 c0x0000 (---------------)  + I ro
	0x002952c4, // n0x0649 c0x0000 (---------------)  + I roma
	0x00291044, // n0x064a c0x0000 (---------------)  + I rome
	0x00242d86, // n0x064b c0x0000 (---------------)  + I rovigo
	0x00200cc2, // n0x064c c0x0000 (---------------)  + I sa
	0x0029ff07, // n0x064d c0x0000 (---------------)  + I salerno
	0x0027d587, // n0x064e c0x0000 (---------------)  + I sassari
	0x002fe486, // n0x064f c0x0000 (---------------)  + I savona
	0x00205a42, // n0x0650 c0x0000 (---------------)  + I si
	0x00273ac5, // n0x0651 c0x0000 (---------------)  + I siena
	0x0025bc88, // n0x0652 c0x0000 (---------------)  + I siracusa
	0x00202fc2, // n0x0653 c0x0000 (---------------)  + I so
	0x00333d87, // n0x0654 c0x0000 (---------------)  + I sondrio
	0x00223002, // n0x0655 c0x0000 (---------------)  + I sp
	0x002b1502, // n0x0656 c0x0000 (---------------)  + I sr
	0x00202f82, // n0x0657 c0x0000 (---------------)  + I ss
	0x00307149, // n0x0658 c0x0000 (---------------)  + I suedtirol
	0x00201702, // n0x0659 c0x0000 (---------------)  + I sv
	0x00200542, // n0x065a c0x0000 (---------------)  + I ta
	0x0021eb47, // n0x065b c0x0000 (---------------)  + I taranto
	0x00201402, // n0x065c c0x0000 (---------------)  + I te
	0x002903cc, // n0x065d c0x0000 (---------------)  + I tempio-olbia
	0x002906cb, // n0x065e c0x0000 (---------------)  + I tempioolbia
	0x00296a46, // n0x065f c0x0000 (---------------)  + I teramo
	0x002d7945, // n0x0660 c0x0000 (---------------)  + I terni
	0x0020ff42, // n0x0661 c0x0000 (---------------)  + I tn
	0x00200302, // n0x0662 c0x0000 (---------------)  + I to
	0x0029b9c6, // n0x0663 c0x0000 (---------------)  + I torino
	0x00211342, // n0x0664 c0x0000 (---------------)  + I tp
	0x00209942, // n0x0665 c0x0000 (---------------)  + I tr
	0x002ded55, // n0x0666 c0x0000 (---------------)  + I trani-andria-barletta
	0x002bdb15, // n0x0667 c0x0000 (---------------)  + I trani-barletta-andria
	0x003034d3, // n0x0668 c0x0000 (---------------)  + I traniandriabarletta
	0x002be053, // n0x0669 c0x0000 (---------------)  + I tranibarlettaandria
	0x0034aa87, // n0x066a c0x0000 (---------------)  + I trapani
	0x002b3e48, // n0x066b c0x0000 (---------------)  + I trentino
	0x002b80c6, // n0x066c c0x0000 (---------------)  + I trento
	0x002b8e07, // n0x066d c0x0000 (---------------)  + I treviso
	0x002c6307, // n0x066e c0x0000 (---------------)  + I trieste
	0x002030c2, // n0x066f c0x0000 (---------------)  + I ts
	0x002cc585, // n0x0670 c0x0000 (---------------)  + I turin
	0x0027ecc2, // n0x0671 c0x0000 (---------------)  + I tv
	0x00203802, // n0x0672 c0x0000 (---------------)  + I ud
	0x002787c5, // n0x0673 c0x0000 (---------------)  + I udine
	0x002c4ccd, // n0x0674 c0x0000 (---------------)  + I urbino-pesaro
	0x002c500c, // n0x0675 c0x0000 (---------------)  + I urbinopesaro
	0x00202b82, // n0x0676 c0x0000 (---------------)  + I va
	0x002c3146, // n0x0677 c0x0000 (---------------)  + I varese
	0x00223b02, // n0x0678 c0x0000 (---------------)  + I vb
	0x00233d02, // n0x0679 c0x0000 (---------------)  + I vc
	0x00205902, // n0x067a c0x0000 (---------------)  + I ve
	0x0028b0c7, // n0x067b c0x0000 (---------------)  + I venezia
	0x0021f246, // n0x067c c0x0000 (---------------)  + I venice
	0x0022da88, // n0x067d c0x0000 (---------------)  + I verbania
	0x002db588, // n0x067e c0x0000 (---------------)  + I vercelli
	0x0025ce06, // n0x067f c0x0000 (---------------)  + I verona
	0x0020afc2, // n0x0680 c0x0000 (---------------)  + I vi
	0x002e1e8d, // n0x0681 c0x0000 (---------------)  + I vibo-valentia
	0x002e21cc, // n0x0682 c0x0000 (---------------)  + I vibovalentia
	0x0022fb07, // n0x0683 c0x0000 (---------------)  + I vicenza
	0x002e34c7, // n0x0684 c0x0000 (---------------)  + I viterbo
	0x0020e1c2, // n0x0685 c0x0000 (---------------)  + I vr
	0x00244f82, // n0x0686 c0x0000 (---------------)  + I vs
	0x0025c582, // n0x0687 c0x0000 (---------------)  + I vt
	0x0022e842, // n0x0688 c0x0000 (---------------)  + I vv
	0x00208f82, // n0x0689 c0x0000 (---------------)  + I co
	0x002150c3, // n0x068a c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x068b c0x0000 (---------------)  + I net
	0x002453c3, // n0x068c c0x0000 (---------------)  + I org
	0x00204343, // n0x068d c0x0000 (---------------)  + I sch
	0x002104c3, // n0x068e c0x0000 (---------------)  + I com
	0x002ceec3, // n0x068f c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0690 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0691 c0x0000 (---------------)  + I mil
	0x002d16c4, // n0x0692 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x0693 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0694 c0x0000 (---------------)  + I org
	0x00204343, // n0x0695 c0x0000 (---------------)  + I sch
	0x002028c2, // n0x0696 c0x0000 (---------------)  + I ac
	0x00202742, // n0x0697 c0x0000 (---------------)  + I ad
	0x1ba76685, // n0x0698 c0x006e (n0x06d6-n0x070b)  + I aichi
	0x1be3a905, // n0x0699 c0x006f (n0x070b-n0x0727)  + I akita
	0x1c2f9546, // n0x069a c0x0070 (n0x0727-n0x073d)  + I aomori
	0x00031c88, // n0x069b c0x0000 (---------------)  +   blogspot
	0x1c69c185, // n0x069c c0x0071 (n0x073d-n0x0777)  + I chiba
	0x00208f82, // n0x069d c0x0000 (---------------)  + I co
	0x00203582, // n0x069e c0x0000 (---------------)  + I ed
	0x1caa6bc5, // n0x069f c0x0072 (n0x0777-n0x078d)  + I ehime
	0x1ce64585, // n0x06a0 c0x0073 (n0x078d-n0x079c)  + I fukui
	0x1d264bc7, // n0x06a1 c0x0074 (n0x079c-n0x07db)  + I fukuoka
	0x1d627489, // n0x06a2 c0x0075 (n0x07db-n0x080e)  + I fukushima
	0x1db2e104, // n0x06a3 c0x0076 (n0x080e-n0x0834)  + I gifu
	0x002053c2, // n0x06a4 c0x0000 (---------------)  + I go
	0x002063c2, // n0x06a5 c0x0000 (---------------)  + I gr
	0x1de4a645, // n0x06a6 c0x0077 (n0x0834-n0x0858)  + I gunma
	0x1e274349, // n0x06a7 c0x0078 (n0x0858-n0x0871)  + I hiroshima
	0x1e694bc8, // n0x06a8 c0x0079 (n0x0871-n0x08ff)  + I hokkaido
	0x1eabd085, // n0x06a9 c0x007a (n0x08ff-n0x092d)  + I hyogo
	0x1ef29287, // n0x06aa c0x007b (n0x092d-n0x0960)  + I ibaraki
	0x1f2a2c88, // n0x06ab c0x007c (n0x0960-n0x0973)  + I ishikawa
	0x1f68f885, // n0x06ac c0x007d (n0x0973-n0x0996)  + I iwate
	0x1fa04846, // n0x06ad c0x007e (n0x0996-n0x09a5)  + I kagawa
	0x1ff4f049, // n0x06ae c0x007f (n0x09a5-n0x09b9)  + I kagoshima
	0x202fa088, // n0x06af c0x0080 (n0x09b9-n0x09d7)  + I kanagawa
	0x206a0a48, // n0x06b0 c0x0081 (n0x09d7-n0x09d8)* o I kawasaki
	0x20ab37ca, // n0x06b1 c0x0082 (n0x09d8-n0x09d9)* o I kitakyushu
	0x20eb5584, // n0x06b2 c0x0083 (n0x09d9-n0x09da)* o I kobe
	0x212b2f45, // n0x06b3 c0x0084 (n0x09da-n0x09f9)  + I kochi
	0x21618c48, // n0x06b4 c0x0085 (n0x09f9-n0x0a13)  + I kumamoto
	0x21a4f305, // n0x06b5 c0x0086 (n0x0a13-n0x0a32)  + I kyoto
	0x002132c2, // n0x06b6 c0x0000 (---------------)  + I lg
	0x21e01803, // n0x06b7 c0x0087 (n0x0a32-n0x0a50)  + I mie
	0x22286f46, // n0x06b8 c0x0088 (n0x0a50-n0x0a71)  + I miyagi
	0x22677b48, // n0x06b9 c0x0089 (n0x0a71-n0x0a8c)  + I miyazaki
	0x22b0f046, // n0x06ba c0x008a (n0x0a8c-n0x0ad7)  + I nagano
	0x22ee9c88, // n0x06bb c0x008b (n0x0ad7-n0x0aed)  + I nagasaki
	0x23205346, // n0x06bc c0x008c (n0x0aed-n0x0aee)* o I nagoya
	0x23734484, // n0x06bd c0x008d (n0x0aee-n0x0b14)  + I nara
	0x00205f42, // n0x06be c0x0000 (---------------)  + I ne
	0x23a871c7, // n0x06bf c0x008e (n0x0b14-n0x0b36)  + I niigata
	0x23ec9384, // n0x06c0 c0x008f (n0x0b36-n0x0b49)  + I oita
	0x242611c7, // n0x06c1 c0x0090 (n0x0b49-n0x0b63)  + I okayama
	0x2470f2c7, // n0x06c2 c0x0091 (n0x0b63-n0x0b8d)  + I okinawa
	0x00204282, // n0x06c3 c0x0000 (---------------)  + I or
	0x24a80b85, // n0x06c4 c0x0092 (n0x0b8d-n0x0bbf)  + I osaka
	0x24e59b04, // n0x06c5 c0x0093 (n0x0bbf-n0x0bd9)  + I saga
	0x252a3b07, // n0x06c6 c0x0094 (n0x0bd9-n0x0c1e)  + I saitama
	0x256545c7, // n0x06c7 c0x0095 (n0x0c1e-n0x0c1f)* o I sapporo
	0x25a68246, // n0x06c8 c0x0096 (n0x0c1f-n0x0c20)* o I sendai
	0x25e652c5, // n0x06c9 c0x0097 (n0x0c20-n0x0c37)  + I shiga
	0x2627a787, // n0x06ca c0x0098 (n0x0c37-n0x0c4e)  + I shimane
	0x266d1e48, // n0x06cb c0x0099 (n0x0c4e-n0x0c72)  + I shizuoka
	0x26b2dfc7, // n0x06cc c0x009a (n0x0c72-n0x0c91)  + I tochigi
	0x26eccac9, // n0x06cd c0x009b (n0x0c91-n0x0ca2)  + I tokushima
	0x2721ec85, // n0x06ce c0x009c (n0x0ca2-n0x0cdb)  + I tokyo
	0x2771ddc7, // n0x06cf c0x009d (n0x0cdb-n0x0ce8)  + I tottori
	0x27a18dc6, // n0x06d0 c0x009e (n0x0ce8-n0x0d00)  + I toyama
	0x27e91608, // n0x06d1 c0x009f (n0x0d00-n0x0d1d)  + I wakayama
	0x28266548, // n0x06d2 c0x00a0 (n0x0d1d-n0x0d3f)  + I yamagata
	0x2866bb49, // n0x06d3 c0x00a1 (n0x0d3f-n0x0d4f)  + I yamaguchi
	0x28b30b49, // n0x06d4 c0x00a2 (n0x0d4f-n0x0d6b)  + I yamanashi
	0x28e24708, // n0x06d5 c0x00a3 (n0x0d6b-n0x0d6c)* o I yokohama
	0x0029ce85, // n0x06d6 c0x0000 (---------------)  + I aisai
	0x0020b5c3, // n0x06d7 c0x0000 (---------------)  + I ama
	0x00248284, // n0x06d8 c0x0000 (---------------)  + I anjo
	0x0033e1c5, // n0x06d9 c0x0000 (---------------)  + I asuke
	0x002a0506, // n0x06da c0x0000 (---------------)  + I chiryu
	0x002a1ac5, // n0x06db c0x0000 (---------------)  + I chita
	0x0026b444, // n0x06dc c0x0000 (---------------)  + I fuso
	0x002b00c8, // n0x06dd c0x0000 (---------------)  + I gamagori
	0x002a3605, // n0x06de c0x0000 (---------------)  + I handa
	0x00277644, // n0x06df c0x0000 (---------------)  + I hazu
	0x00342947, // n0x06e0 c0x0000 (---------------)  + I hekinan
	0x00282cca, // n0x06e1 c0x0000 (---------------)  + I higashiura
	0x00206c8a, // n0x06e2 c0x0000 (---------------)  + I ichinomiya
	0x002d7587, // n0x06e3 c0x0000 (---------------)  + I inazawa
	0x0025de87, // n0x06e4 c0x0000 (---------------)  + I inuyama
	0x003361c7, // n0x06e5 c0x0000 (---------------)  + I isshiki
	0x002eba47, // n0x06e6 c0x0000 (---------------)  + I iwakura
	0x002ce8c5, // n0x06e7 c0x0000 (---------------)  + I kanie
	0x002f8206, // n0x06e8 c0x0000 (---------------)  + I kariya
	0x0027cc87, // n0x06e9 c0x0000 (---------------)  + I kasugai
	0x00249884, // n0x06ea c0x0000 (---------------)  + I kira
	0x00217906, // n0x06eb c0x0000 (---------------)  + I kiyosu
	0x002ad246, // n0x06ec c0x0000 (---------------)  + I komaki
	0x002d9945, // n0x06ed c0x0000 (---------------)  + I konan
	0x002e7b84, // n0x06ee c0x0000 (---------------)  + I kota
	0x00287e06, // n0x06ef c0x0000 (---------------)  + I mihama
	0x00281bc7, // n0x06f0 c0x0000 (---------------)  + I miyoshi
	0x00344848, // n0x06f1 c0x0000 (---------------)  + I nagakute
	0x002294c6, // n0x06f2 c0x0000 (---------------)  + I nishio
	0x0022f887, // n0x06f3 c0x0000 (---------------)  + I nisshin
	0x00277483, // n0x06f4 c0x0000 (---------------)  + I obu
	0x0022c706, // n0x06f5 c0x0000 (---------------)  + I oguchi
	0x002a0685, // n0x06f6 c0x0000 (---------------)  + I oharu
	0x00264cc7, // n0x06f7 c0x0000 (---------------)  + I okazaki
	0x002a5d4a, // n0x06f8 c0x0000 (---------------)  + I owariasahi
	0x0023e184, // n0x06f9 c0x0000 (---------------)  + I seto
	0x0028a108, // n0x06fa c0x0000 (---------------)  + I shikatsu
	0x002cc789, // n0x06fb c0x0000 (---------------)  + I shinshiro
	0x002d0f07, // n0x06fc c0x0000 (---------------)  + I shitara
	0x00235ec6, // n0x06fd c0x0000 (---------------)  + I tahara
	0x00287308, // n0x06fe c0x0000 (---------------)  + I takahama
	0x00279309, // n0x06ff c0x0000 (---------------)  + I tobishima
	0x002a9904, // n0x0700 c0x0000 (---------------)  + I toei
	0x00258204, // n0x0701 c0x0000 (---------------)  + I togo
	0x002e4345, // n0x0702 c0x0000 (---------------)  + I tokai
	0x002d15c8, // n0x0703 c0x0000 (---------------)  + I tokoname
	0x002ab587, // n0x0704 c0x0000 (---------------)  + I toyoake
	0x002ca649, // n0x0705 c0x0000 (---------------)  + I toyohashi
	0x002519c8, // n0x0706 c0x0000 (---------------)  + I toyokawa
	0x002585c6, // n0x0707 c0x0000 (---------------)  + I toyone
	0x0026fc46, // n0x0708 c0x0000 (---------------)  + I toyota
	0x0027dc48, // n0x0709 c0x0000 (---------------)  + I tsushima
	0x00313486, // n0x070a c0x0000 (---------------)  + I yatomi
	0x0023a905, // n0x070b c0x0000 (---------------)  + I akita
	0x00268306, // n0x070c c0x0000 (---------------)  + I daisen
	0x002617c8, // n0x070d c0x0000 (---------------)  + I fujisato
	0x002e2806, // n0x070e c0x0000 (---------------)  + I gojome
	0x002ac68b, // n0x070f c0x0000 (---------------)  + I hachirogata
	0x00272606, // n0x0710 c0x0000 (---------------)  + I happou
	0x0027ef8d, // n0x0711 c0x0000 (---------------)  + I higashinaruse
	0x0020edc5, // n0x0712 c0x0000 (---------------)  + I honjo
	0x0028a8c6, // n0x0713 c0x0000 (---------------)  + I honjyo
	0x00260705, // n0x0714 c0x0000 (---------------)  + I ikawa
	0x00313c09, // n0x0715 c0x0000 (---------------)  + I kamikoani
	0x0024d347, // n0x0716 c0x0000 (---------------)  + I kamioka
	0x002a7848, // n0x0717 c0x0000 (---------------)  + I katagami
	0x002332c6, // n0x0718 c0x0000 (---------------)  + I kazuno
	0x0027e3c9, // n0x0719 c0x0000 (---------------)  + I kitaakita
	0x00290dc6, // n0x071a c0x0000 (---------------)  + I kosaka
	0x002a5cc5, // n0x071b c0x0000 (---------------)  + I kyowa
	0x00279206, // n0x071c c0x0000 (---------------)  + I misato
	0x00256606, // n0x071d c0x0000 (---------------)  + I mitane
	0x002afa09, // n0x071e c0x0000 (---------------)  + I moriyoshi
	0x002a9706, // n0x071f c0x0000 (---------------)  + I nikaho
	0x002504c7, // n0x0720 c0x0000 (---------------)  + I noshiro
	0x002509c5, // n0x0721 c0x0000 (---------------)  + I odate
	0x00205783, // n0x0722 c0x0000 (---------------)  + I oga
	0x002a0085, // n0x0723 c0x0000 (---------------)  + I ogata
	0x00218b07, // n0x0724 c0x0000 (---------------)  + I semboku
	0x002a6a86, // n0x0725 c0x0000 (---------------)  + I yokote
	0x0020ecc9, // n0x0726 c0x0000 (---------------)  + I yurihonjo
	0x002f9546, // n0x0727 c0x0000 (---------------)  + I aomori
	0x00304e86, // n0x0728 c0x0000 (---------------)  + I gonohe
	0x00255c09, // n0x0729 c0x0000 (---------------)  + I hachinohe
	0x00267d09, // n0x072a c0x0000 (---------------)  + I hashikami
	0x00285487, // n0x072b c0x0000 (---------------)  + I hiranai
	0x002a7bc8, // n0x072c c0x0000 (---------------)  + I hirosaki
	0x00325e89, // n0x072d c0x0000 (---------------)  + I itayanagi
	0x00265188, // n0x072e c0x0000 (---------------)  + I kuroishi
	0x002bed86, // n0x072f c0x0000 (---------------)  + I misawa
	0x002b9b85, // n0x0730 c0x0000 (---------------)  + I mutsu
	0x0021ca0a, // n0x0731 c0x0000 (---------------)  + I nakadomari
	0x00304f06, // n0x0732 c0x0000 (---------------)  + I noheji
	0x002e9fc6, // n0x0733 c0x0000 (---------------)  + I oirase
	0x00287105, // n0x0734 c0x0000 (---------------)  + I owani
	0x0021a408, // n0x0735 c0x0000 (---------------)  + I rokunohe
	0x0024ec47, // n0x0736 c0x0000 (---------------)  + I sannohe
	0x0034274a, // n0x0737 c0x0000 (---------------)  + I shichinohe
	0x0022f946, // n0x0738 c0x0000 (---------------)  + I shingo
	0x002fcd85, // n0x0739 c0x0000 (---------------)  + I takko
	0x002d2c86, // n0x073a c0x0000 (---------------)  + I towada
	0x00294647, // n0x073b c0x0000 (---------------)  + I tsugaru
	0x00235d87, // n0x073c c0x0000 (---------------)  + I tsuruta
	0x0022b385, // n0x073d c0x0000 (---------------)  + I abiko
	0x002a5e85, // n0x073e c0x0000 (---------------)  + I asahi
	0x00304d06, // n0x073f c0x0000 (---------------)  + I chonan
	0x00306d86, // n0x0740 c0x0000 (---------------)  + I chosei
	0x0030a206, // n0x0741 c0x0000 (---------------)  + I choshi
	0x002f8704, // n0x0742 c0x0000 (---------------)  + I chuo
	0x00266b09, // n0x0743 c0x0000 (---------------)  + I funabashi
	0x0026ca06, // n0x0744 c0x0000 (---------------)  + I futtsu
	0x002474ca, // n0x0745 c0x0000 (---------------)  + I hanamigawa
	0x002766c8, // n0x0746 c0x0000 (---------------)  + I ichihara
	0x00279008, // n0x0747 c0x0000 (---------------)  + I ichikawa
	0x00206c8a, // n0x0748 c0x0000 (---------------)  + I ichinomiya
	0x002ea585, // n0x0749 c0x0000 (---------------)  + I inzai
	0x00281b05, // n0x074a c0x0000 (---------------)  + I isumi
	0x002b5308, // n0x074b c0x0000 (---------------)  + I kamagaya
	0x002d4ac8, // n0x074c c0x0000 (---------------)  + I kamogawa
	0x00215d07, // n0x074d c0x0000 (---------------)  + I kashiwa
	0x002d18c6, // n0x074e c0x0000 (---------------)  + I katori
	0x002f0008, // n0x074f c0x0000 (---------------)  + I katsuura
	0x002d8bc7, // n0x0750 c0x0000 (---------------)  + I kimitsu
	0x002660c8, // n0x0751 c0x0000 (---------------)  + I kisarazu
	0x00297dc6, // n0x0752 c0x0000 (---------------)  + I kozaki
	0x00330f88, // n0x0753 c0x0000 (---------------)  + I kujukuri
	0x00234046, // n0x0754 c0x0000 (---------------)  + I kyonan
	0x0021a087, // n0x0755 c0x0000 (---------------)  + I matsudo
	0x002667c6, // n0x0756 c0x0000 (---------------)  + I midori
	0x00287e06, // n0x0757 c0x0000 (---------------)  + I mihama
	0x0031358a, // n0x0758 c0x0000 (---------------)  + I minamiboso
	0x002c6006, // n0x0759 c0x0000 (---------------)  + I mobara
	0x002b9b89, // n0x075a c0x0000 (---------------)  + I mutsuzawa
	0x0028dd46, // n0x075b c0x0000 (---------------)  + I nagara
	0x0028df8a, // n0x075c c0x0000 (---------------)  + I nagareyama
	0x00334489, // n0x075d c0x0000 (---------------)  + I narashino
	0x00335e46, // n0x075e c0x0000 (---------------)  + I narita
	0x00345804, // n0x075f c0x0000 (---------------)  + I noda
	0x0020d44d, // n0x0760 c0x0000 (---------------)  + I oamishirasato
	0x0026bdc7, // n0x0761 c0x0000 (---------------)  + I omigawa
	0x002f2e86, // n0x0762 c0x0000 (---------------)  + I onjuku
	0x002a0905, // n0x0763 c0x0000 (---------------)  + I otaki
	0x00290e45, // n0x0764 c0x0000 (---------------)  + I sakae
	0x002a2746, // n0x0765 c0x0000 (---------------)  + I sakura
	0x002d1349, // n0x0766 c0x0000 (---------------)  + I shimofusa
	0x002ce447, // n0x0767 c0x0000 (---------------)  + I shirako
	0x00262206, // n0x0768 c0x0000 (---------------)  + I shiroi
	0x002d09c6, // n0x0769 c0x0000 (---------------)  + I shisui
	0x002ebe09, // n0x076a c0x0000 (---------------)  + I sodegaura
	0x0023a844, // n0x076b c0x0000 (---------------)  + I sosa
	0x0026ac84, // n0x076c c0x0000 (---------------)  + I tako
	0x00231e48, // n0x076d c0x0000 (---------------)  + I tateyama
	0x002c1d46, // n0x076e c0x0000 (---------------)  + I togane
	0x002e8088, // n0x076f c0x0000 (---------------)  + I tohnosho
	0x002f1c08, // n0x0770 c0x0000 (---------------)  + I tomisato
	0x0025e607, // n0x0771 c0x0000 (---------------)  + I urayasu
	0x00285b09, // n0x0772 c0x0000 (---------------)  + I yachimata
	0x00202887, // n0x0773 c0x0000 (---------------)  + I yachiyo
	0x0029c04a, // n0x0774 c0x0000 (---------------)  + I yokaichiba
	0x002d658f, // n0x0775 c0x0000 (---------------)  + I yokoshibahikari
	0x0027a24a, // n0x0776 c0x0000 (---------------)  + I yotsukaido
	0x00221605, // n0x0777 c0x0000 (---------------)  + I ainan
	0x00261a05, // n0x0778 c0x0000 (---------------)  + I honai
	0x0027cb45, // n0x0779 c0x0000 (---------------)  + I ikata
	0x002342c7, // n0x077a c0x0000 (---------------)  + I imabari
	0x00202983, // n0x077b c0x0000 (---------------)  + I iyo
	0x002a7dc8, // n0x077c c0x0000 (---------------)  + I kamijima
	0x00205c46, // n0x077d c0x0000 (---------------)  + I kihoku
	0x00205d49, // n0x077e c0x0000 (---------------)  + I kumakogen
	0x002e3e86, // n0x077f c0x0000 (---------------)  + I masaki
	0x0029bcc7, // n0x0780 c0x0000 (---------------)  + I matsuno
	0x0027e189, // n0x0781 c0x0000 (---------------)  + I matsuyama
	0x002a7748, // n0x0782 c0x0000 (---------------)  + I namikata
	0x00313dc7, // n0x0783 c0x0000 (---------------)  + I niihama
	0x002fc943, // n0x0784 c0x0000 (---------------)  + I ozu
	0x0029cf05, // n0x0785 c0x0000 (---------------)  + I saijo
	0x002d64c5, // n0x0786 c0x0000 (---------------)  + I seiyo
	0x002f854b, // n0x0787 c0x0000 (---------------)  + I shikokuchuo
	0x0024f3c4, // n0x0788 c0x0000 (---------------)  + I tobe
	0x002da904, // n0x0789 c0x0000 (---------------)  + I toon
	0x00260886, // n0x078a c0x0000 (---------------)  + I uchiko
	0x0029db87, // n0x078b c0x0000 (---------------)  + I uwajima
	0x0032f20a, // n0x078c c0x0000 (---------------)  + I yawatahama
	0x00307807, // n0x078d c0x0000 (---------------)  + I echizen
	0x00293987, // n0x078e c0x0000 (---------------)  + I eiheiji
	0x00264585, // n0x078f c0x0000 (---------------)  + I fukui
	0x00205505, // n0x0790 c0x0000 (---------------)  + I ikeda
	0x0031d449, // n0x0791 c0x0000 (---------------)  + I katsuyama
	0x00287e06, // n0x0792 c0x0000 (---------------)  + I mihama
	0x0030768d, // n0x0793 c0x0000 (---------------)  + I minamiechizen
	0x0030f685, // n0x0794 c0x0000 (---------------)  + I obama
	0x0027a483, // n0x0795 c0x0000 (---------------)  + I ohi
	0x00206b83, // n0x0796 c0x0000 (---------------)  + I ono
	0x00225105, // n0x0797 c0x0000 (---------------)  + I sabae
	0x00306345, // n0x0798 c0x0000 (---------------)  + I sakai
	0x00287308, // n0x0799 c0x0000 (---------------)  + I takahama
	0x003186c7, // n0x079a c0x0000 (---------------)  + I tsuruga
	0x0026aa06, // n0x079b c0x0000 (---------------)  + I wakasa
	0x002833c6, // n0x079c c0x0000 (---------------)  + I ashiya
	0x0028fe05, // n0x079d c0x0000 (---------------)  + I buzen
	0x00319ac7, // n0x079e c0x0000 (---------------)  + I chikugo
	0x0025e107, // n0x079f c0x0000 (---------------)  + I chikuho
	0x00207047, // n0x07a0 c0x0000 (---------------)  + I chikujo
	0x0024f6ca, // n0x07a1 c0x0000 (---------------)  + I chikushino
	0x0022c7c8, // n0x07a2 c0x0000 (---------------)  + I chikuzen
	0x002f8704, // n0x07a3 c0x0000 (---------------)  + I chuo
	0x0026a247, // n0x07a4 c0x0000 (---------------)  + I dazaifu
	0x00263707, // n0x07a5 c0x0000 (---------------)  + I fukuchi
	0x0032d486, // n0x07a6 c0x0000 (---------------)  + I hakata
	0x00278307, // n0x07a7 c0x0000 (---------------)  + I higashi
	0x00269bc8, // n0x07a8 c0x0000 (---------------)  + I hirokawa
	0x00330a48, // n0x07a9 c0x0000 (---------------)  + I hisayama
	0x0023cf06, // n0x07aa c0x0000 (---------------)  + I iizuka
	0x002eabc8, // n0x07ab c0x0000 (---------------)  + I inatsuki
	0x00256d44, // n0x07ac c0x0000 (---------------)  + I kaho
	0x0027cc86, // n0x07ad c0x0000 (---------------)  + I kasuga
	0x0021d086, // n0x07ae c0x0000 (---------------)  + I kasuya
	0x002cfbc6, // n0x07af c0x0000 (---------------)  + I kawara
	0x002926c6, // n0x07b0 c0x0000 (---------------)  + I keisen
	0x00283944, // n0x07b1 c0x0000 (---------------)  + I koga
	0x002ebb06, // n0x07b2 c0x0000 (---------------)  + I kurate
	0x0029ef86, // n0x07b3 c0x0000 (---------------)  + I kurogi
	0x0027d346, // n0x07b4 c0x0000 (---------------)  + I kurume
	0x0020aa46, // n0x07b5 c0x0000 (---------------)  + I minami
	0x00215746, // n0x07b6 c0x0000 (---------------)  + I miyako
	0x00269a06, // n0x07b7 c0x0000 (---------------)  + I miyama
	0x0026a908, // n0x07b8 c0x0000 (---------------)  + I miyawaka
	0x00293208, // n0x07b9 c0x0000 (---------------)  + I mizumaki
	0x002b4048, // n0x07ba c0x0000 (---------------)  + I munakata
	0x002a1cc8, // n0x07bb c0x0000 (---------------)  + I nakagawa
	0x002b5286, // n0x07bc c0x0000 (---------------)  + I nakama
	0x00201005, // n0x07bd c0x0000 (---------------)  + I nishi
	0x002a0046, // n0x07be c0x0000 (---------------)  + I nogata
	0x002bd105, // n0x07bf c0x0000 (---------------)  + I ogori
	0x00249747, // n0x07c0 c0x0000 (---------------)  + I okagaki
	0x00200ec5, // n0x07c1 c0x0000 (---------------)  + I okawa
	0x002d5143, // n0x07c2 c0x0000 (---------------)  + I oki
	0x00212385, // n0x07c3 c0x0000 (---------------)  + I omuta
	0x00333604, // n0x07c4 c0x0000 (---------------)  + I onga
	0x00215885, // n0x07c5 c0x0000 (---------------)  + I onojo
	0x0020a7c3, // n0x07c6 c0x0000 (---------------)  + I oto
	0x00290c07, // n0x07c7 c0x0000 (---------------)  + I saigawa
	0x002ba5c8, // n0x07c8 c0x0000 (---------------)  + I sasaguri
	0x002c8bc6, // n0x07c9 c0x0000 (---------------)  + I shingu
	0x002cd10d, // n0x07ca c0x0000 (---------------)  + I shinyoshitomi
	0x002619c6, // n0x07cb c0x0000 (---------------)  + I shonai
	0x0027b7c5, // n0x07cc c0x0000 (---------------)  + I soeda
	0x002b2e03, // n0x07cd c0x0000 (---------------)  + I sue
	0x0029ccc9, // n0x07ce c0x0000 (---------------)  + I tachiarai
	0x002acc86, // n0x07cf c0x0000 (---------------)  + I tagawa
	0x00204e46, // n0x07d0 c0x0000 (---------------)  + I takata
	0x00294b44, // n0x07d1 c0x0000 (---------------)  + I toho
	0x0027a1c7, // n0x07d2 c0x0000 (---------------)  + I toyotsu
	0x00235b06, // n0x07d3 c0x0000 (---------------)  + I tsuiki
	0x00265645, // n0x07d4 c0x0000 (---------------)  + I ukiha
	0x00217a43, // n0x07d5 c0x0000 (---------------)  + I umi
	0x002189c4, // n0x07d6 c0x0000 (---------------)  + I usui
	0x002638c6, // n0x07d7 c0x0000 (---------------)  + I yamada
	0x002f8304, // n0x07d8 c0x0000 (---------------)  + I yame
	0x0021d188, // n0x07d9 c0x0000 (---------------)  + I yanagawa
	0x0020e489, // n0x07da c0x0000 (---------------)  + I yukuhashi
	0x00201149, // n0x07db c0x0000 (---------------)  + I aizubange
	0x0028478a, // n0x07dc c0x0000 (---------------)  + I aizumisato
	0x0028ee0d, // n0x07dd c0x0000 (---------------)  + I aizuwakamatsu
	0x002b4f07, // n0x07de c0x0000 (---------------)  + I asakawa
	0x0030c9c6, // n0x07df c0x0000 (---------------)  + I bandai
	0x00250a04, // n0x07e0 c0x0000 (---------------)  + I date
	0x00227489, // n0x07e1 c0x0000 (---------------)  + I fukushima
	0x0026ae48, // n0x07e2 c0x0000 (---------------)  + I furudono
	0x0026b9c6, // n0x07e3 c0x0000 (---------------)  + I futaba
	0x00243d86, // n0x07e4 c0x0000 (---------------)  + I hanawa
	0x00278307, // n0x07e5 c0x0000 (---------------)  + I higashi
	0x002cfd86, // n0x07e6 c0x0000 (---------------)  + I hirata
	0x00226786, // n0x07e7 c0x0000 (---------------)  + I hirono
	0x003424c6, // n0x07e8 c0x0000 (---------------)  + I iitate
	0x0030f34a, // n0x07e9 c0x0000 (---------------)  + I inawashiro
	0x002a2c88, // n0x07ea c0x0000 (---------------)  + I ishikawa
	0x0022ca85, // n0x07eb c0x0000 (---------------)  + I iwaki
	0x002b3609, // n0x07ec c0x0000 (---------------)  + I izumizaki
	0x002cc18a, // n0x07ed c0x0000 (---------------)  + I kagamiishi
	0x002cd488, // n0x07ee c0x0000 (---------------)  + I kaneyama
	0x00281588, // n0x07ef c0x0000 (---------------)  + I kawamata
	0x00298a08, // n0x07f0 c0x0000 (---------------)  + I kitakata
	0x0028300c, // n0x07f1 c0x0000 (---------------)  + I kitashiobara
	0x002f3845, // n0x07f2 c0x0000 (---------------)  + I koori
	0x00283648, // n0x07f3 c0x0000 (---------------)  + I koriyama
	0x002ad4c6, // n0x07f4 c0x0000 (---------------)  + I kunimi
	0x00336586, // n0x07f5 c0x0000 (---------------)  + I miharu
	0x002d6fc7, // n0x07f6 c0x0000 (---------------)  + I mishima
	0x00307705, // n0x07f7 c0x0000 (---------------)  + I namie
	0x00304dc5, // n0x07f8 c0x0000 (---------------)  + I nango
	0x00201009, // n0x07f9 c0x0000 (---------------)  + I nishiaizu
	0x00225907, // n0x07fa c0x0000 (---------------)  + I nishigo
	0x00205d05, // n0x07fb c0x0000 (---------------)  + I okuma
	0x00227107, // n0x07fc c0x0000 (---------------)  + I omotego
	0x00206b83, // n0x07fd c0x0000 (---------------)  + I ono
	0x002abac5, // n0x07fe c0x0000 (---------------)  + I otama
	0x0023ff88, // n0x07ff c0x0000 (---------------)  + I samegawa
	0x00329807, // n0x0800 c0x0000 (---------------)  + I shimogo
	0x00281449, // n0x0801 c0x0000 (---------------)  + I shirakawa
	0x002d3145, // n0x0802 c0x0000 (---------------)  + I showa
	0x002d4444, // n0x0803 c0x0000 (---------------)  + I soma
	0x00286288, // n0x0804 c0x0000 (---------------)  + I sukagawa
	0x00200547, // n0x0805 c0x0000 (---------------)  + I taishin
	0x00313f88, // n0x0806 c0x0000 (---------------)  + I tamakawa
	0x002827c8, // n0x0807 c0x0000 (---------------)  + I tanagura
	0x0020c985, // n0x0808 c0x0000 (---------------)  + I tenei
	0x002fc686, // n0x0809 c0x0000 (---------------)  + I yabuki
	0x0024d686, // n0x080a c0x0000 (---------------)  + I yamato
	0x0020b589, // n0x080b c0x0000 (---------------)  + I yamatsuri
	0x002cdd47, // n0x080c c0x0000 (---------------)  + I yanaizu
	0x0028e586, // n0x080d c0x0000 (---------------)  + I yugawa
	0x0031c547, // n0x080e c0x0000 (---------------)  + I anpachi
	0x00205943, // n0x080f c0x0000 (---------------)  + I ena
	0x0032e104, // n0x0810 c0x0000 (---------------)  + I gifu
	0x0021fb05, // n0x0811 c0x0000 (---------------)  + I ginan
	0x0026a4c4, // n0x0812 c0x0000 (---------------)  + I godo
	0x002c8cc4, // n0x0813 c0x0000 (---------------)  + I gujo
	0x002ac9c7, // n0x0814 c0x0000 (---------------)  + I hashima
	0x0024ddc7, // n0x0815 c0x0000 (---------------)  + I hichiso
	0x002623c4, // n0x0816 c0x0000 (---------------)  + I hida
	0x00281290, // n0x0817 c0x0000 (---------------)  + I higashishirakawa
	0x002a6d47, // n0x0818 c0x0000 (---------------)  + I ibigawa
	0x00205505, // n0x0819 c0x0000 (---------------)  + I ikeda
	0x0032e38c, // n0x081a c0x0000 (---------------)  + I kakamigahara
	0x00203404, // n0x081b c0x0000 (---------------)  + I kani
	0x002ccf08, // n0x081c c0x0000 (---------------)  + I kasahara
	0x00219f89, // n0x081d c0x0000 (---------------)  + I kasamatsu
	0x00318cc6, // n0x081e c0x0000 (---------------)  + I kawaue
	0x0023a948, // n0x081f c0x0000 (---------------)  + I kitagata
	0x00200e04, // n0x0820 c0x0000 (---------------)  + I mino
	0x002dbb88, // n0x0821 c0x0000 (---------------)  + I minokamo
	0x002aab06, // n0x0822 c0x0000 (---------------)  + I mitake
	0x0022a2c8, // n0x0823 c0x0000 (---------------)  + I mizunami
	0x0027be46, // n0x0824 c0x0000 (---------------)  + I motosu
	0x002fe58b, // n0x0825 c0x0000 (---------------)  + I nakatsugawa
	0x00205785, // n0x0826 c0x0000 (---------------)  + I ogaki
	0x00256cc8, // n0x0827 c0x0000 (---------------)  + I sakahogi
	0x0020e8c4, // n0x0828 c0x0000 (---------------)  + I seki
	0x0020e8ca, // n0x0829 c0x0000 (---------------)  + I sekigahara
	0x00281449, // n0x082a c0x0000 (---------------)  + I shirakawa
	0x002666c6, // n0x082b c0x0000 (---------------)  + I tajimi
	0x002d6ac8, // n0x082c c0x0000 (---------------)  + I takayama
	0x0023e585, // n0x082d c0x0000 (---------------)  + I tarui
	0x002fb744, // n0x082e c0x0000 (---------------)  + I toki
	0x002cce06, // n0x082f c0x0000 (---------------)  + I tomika
	0x0024f588, // n0x0830 c0x0000 (---------------)  + I wanouchi
	0x00266548, // n0x0831 c0x0000 (---------------)  + I yamagata
	0x002e8906, // n0x0832 c0x0000 (---------------)  + I yaotsu
	0x002122c4, // n0x0833 c0x0000 (---------------)  + I yoro
	0x0021c986, // n0x0834 c0x0000 (---------------)  + I annaka
	0x00202907, // n0x0835 c0x0000 (---------------)  + I chiyoda
	0x002610c7, // n0x0836 c0x0000 (---------------)  + I fujioka
	0x002b31cf, // n0x0837 c0x0000 (---------------)  + I higashiagatsuma
	0x002ec8c7, // n0x0838 c0x0000 (---------------)  + I isesaki
	0x00335f07, // n0x0839 c0x0000 (---------------)  + I itakura
	0x002d1fc5, // n0x083a c0x0000 (---------------)  + I kanna
	0x00261dc5, // n0x083b c0x0000 (---------------)  + I kanra
	0x00285149, // n0x083c c0x0000 (---------------)  + I katashina
	0x00279c06, // n0x083d c0x0000 (---------------)  + I kawaba
	0x00265405, // n0x083e c0x0000 (---------------)  + I kiryu
	0x00268007, // n0x083f c0x0000 (---------------)  + I kusatsu
	0x00297408, // n0x0840 c0x0000 (---------------)  + I maebashi
	0x002f8385, // n0x0841 c0x0000 (---------------)  + I meiwa
	0x002667c6, // n0x0842 c0x0000 (---------------)  + I midori
	0x00229b88, // n0x0843 c0x0000 (---------------)  + I minakami
	0x0030f04a, // n0x0844 c0x0000 (---------------)  + I naganohara
	0x0023ecc8, // n0x0845 c0x0000 (---------------)  + I nakanojo
	0x00270847, // n0x0846 c0x0000 (---------------)  + I nanmoku
	0x002d69c6, // n0x0847 c0x0000 (---------------)  + I numata
	0x002b35c6, // n0x0848 c0x0000 (---------------)  + I oizumi
	0x00225e03, // n0x0849 c0x0000 (---------------)  + I ora
	0x00213103, // n0x084a c0x0000 (---------------)  + I ota
	0x0030a2c9, // n0x084b c0x0000 (---------------)  + I shibukawa
	0x00325d09, // n0x084c c0x0000 (---------------)  + I shimonita
	0x002cc9c6, // n0x084d c0x0000 (---------------)  + I shinto
	0x002d3145, // n0x084e c0x0000 (---------------)  + I showa
	0x002eae48, // n0x084f c0x0000 (---------------)  + I takasaki
	0x002d6ac8, // n0x0850 c0x0000 (---------------)  + I takayama
	0x002b83c8, // n0x0851 c0x0000 (---------------)  + I tamamura
	0x0034254b, // n0x0852 c0x0000 (---------------)  + I tatebayashi
	0x002cd347, // n0x0853 c0x0000 (---------------)  + I tomioka
	0x0028fa89, // n0x0854 c0x0000 (---------------)  + I tsukiyono
	0x002b3448, // n0x0855 c0x0000 (---------------)  + I tsumagoi
	0x00243604, // n0x0856 c0x0000 (---------------)  + I ueno
	0x002afb08, // n0x0857 c0x0000 (---------------)  + I yoshioka
	0x00273789, // n0x0858 c0x0000 (---------------)  + I asaminami
	0x0030ca85, // n0x0859 c0x0000 (---------------)  + I daiwa
	0x0023a407, // n0x085a c0x0000 (---------------)  + I etajima
	0x0032e185, // n0x085b c0x0000 (---------------)  + I fuchu
	0x00266448, // n0x085c c0x0000 (---------------)  + I fukuyama
	0x0027650b, // n0x085d c0x0000 (---------------)  + I hatsukaichi
	0x0027a4d0, // n0x085e c0x0000 (---------------)  + I higashihiroshima
	0x0028a6c5, // n0x085f c0x0000 (---------------)  + I hongo
	0x00212c8c, // n0x0860 c0x0000 (---------------)  + I jinsekikogen
	0x0026abc5, // n0x0861 c0x0000 (---------------)  + I kaita
	0x00264603, // n0x0862 c0x0000 (---------------)  + I kui
	0x002ca246, // n0x0863 c0x0000 (---------------)  + I kumano
	0x0029e404, // n0x0864 c0x0000 (---------------)  + I kure
	0x0025bf06, // n0x0865 c0x0000 (---------------)  + I mihara
	0x00281bc7, // n0x0866 c0x0000 (---------------)  + I miyoshi
	0x0020ff84, // n0x0867 c0x0000 (---------------)  + I naka
	0x00206b88, // n0x0868 c0x0000 (---------------)  + I onomichi
	0x002a7c8d, // n0x0869 c0x0000 (---------------)  + I osakikamijima
	0x0029b345, // n0x086a c0x0000 (---------------)  + I otake
	0x00256cc4, // n0x086b c0x0000 (---------------)  + I saka
	0x00221344, // n0x086c c0x0000 (---------------)  + I sera
	0x0028d5c9, // n0x086d c0x0000 (---------------)  + I seranishi
	0x002c8f08, // n0x086e c0x0000 (---------------)  + I shinichi
	0x002ea6c7, // n0x086f c0x0000 (---------------)  + I shobara
	0x002aab88, // n0x0870 c0x0000 (---------------)  + I takehara
	0x00266bc8, // n0x0871 c0x0000 (---------------)  + I abashiri
	0x00262505, // n0x0872 c0x0000 (---------------)  + I abira
	0x00345047, // n0x0873 c0x0000 (---------------)  + I aibetsu
	0x00262487, // n0x0874 c0x0000 (---------------)  + I akabira
	0x00206007, // n0x0875 c0x0000 (---------------)  + I akkeshi
	0x002a5e89, // n0x0876 c0x0000 (---------------)  + I asahikawa
	0x00235989, // n0x0877 c0x0000 (---------------)  + I ashibetsu
	0x0023af46, // n0x0878 c0x0000 (---------------)  + I ashoro
	0x002720c6, // n0x0879 c0x0000 (---------------)  + I assabu
	0x002680c6, // n0x087a c0x0000 (---------------)  + I atsuma
	0x00288b45, // n0x087b c0x0000 (---------------)  + I bibai
	0x002f4884, // n0x087c c0x0000 (---------------)  + I biei
	0x00204746, // n0x087d c0x0000 (---------------)  + I bifuka
	0x00205086, // n0x087e c0x0000 (---------------)  + I bihoro
	0x00262548, // n0x087f c0x0000 (---------------)  + I biratori
	0x0029430b, // n0x0880 c0x0000 (---------------)  + I chippubetsu
	0x002c18c7, // n0x0881 c0x0000 (---------------)  + I chitose
	0x00250a04, // n0x0882 c0x0000 (---------------)  + I date
	0x002bf5c6, // n0x0883 c0x0000 (---------------)  + I ebetsu
	0x002dc347, // n0x0884 c0x0000 (---------------)  + I embetsu
	0x002b7305, // n0x0885 c0x0000 (---------------)  + I eniwa
	0x00291b45, // n0x0886 c0x0000 (---------------)  + I erimo
	0x00248204, // n0x0887 c0x0000 (---------------)  + I esan
	0x00235906, // n0x0888 c0x0000 (---------------)  + I esashi
	0x002047c8, // n0x0889 c0x0000 (---------------)  + I fukagawa
	0x00227489, // n0x088a c0x0000 (---------------)  + I fukushima
	0x00253d06, // n0x088b c0x0000 (---------------)  + I furano
	0x00269588, // n0x088c c0x0000 (---------------)  + I furubira
	0x00238ec6, // n0x088d c0x0000 (---------------)  + I haboro
	0x00330248, // n0x088e c0x0000 (---------------)  + I hakodate
	0x002ce04c, // n0x088f c0x0000 (---------------)  + I hamatonbetsu
	0x002623c6, // n0x0890 c0x0000 (---------------)  + I hidaka
	0x0027b48d, // n0x0891 c0x0000 (---------------)  + I higashikagura
	0x0027b90b, // n0x0892 c0x0000 (---------------)  + I higashikawa
	0x00250585, // n0x0893 c0x0000 (---------------)  + I hiroo
	0x0025e247, // n0x0894 c0x0000 (---------------)  + I hokuryu
	0x002a9806, // n0x0895 c0x0000 (---------------)  + I hokuto
	0x002a87c8, // n0x0896 c0x0000 (---------------)  + I honbetsu
	0x0023afc9, // n0x0897 c0x0000 (---------------)  + I horokanai
	0x003139c8, // n0x0898 c0x0000 (---------------)  + I horonobe
	0x00205505, // n0x0899 c0x0000 (---------------)  + I ikeda
	0x0023a507, // n0x089a c0x0000 (---------------)  + I imakane
	0x002cc308, // n0x089b c0x0000 (---------------)  + I ishikari
	0x002b6a09, // n0x089c c0x0000 (---------------)  + I iwamizawa
	0x0025f106, // n0x089d c0x0000 (---------------)  + I iwanai
	0x00253c0a, // n0x089e c0x0000 (---------------)  + I kamifurano
	0x002a8548, // n0x089f c0x0000 (---------------)  + I kamikawa
	0x0031380b, // n0x08a0 c0x0000 (---------------)  + I kamishihoro
	0x0023d00c, // n0x08a1 c0x0000 (---------------)  + I kamisunagawa
	0x002dbc88, // n0x08a2 c0x0000 (---------------)  + I kamoenai
	0x00263046, // n0x08a3 c0x0000 (---------------)  + I kayabe
	0x00206f08, // n0x08a4 c0x0000 (---------------)  + I kembuchi
	0x002e9e07, // n0x08a5 c0x0000 (---------------)  + I kikonai
	0x00235c09, // n0x08a6 c0x0000 (---------------)  + I kimobetsu
	0x0027424d, // n0x08a7 c0x0000 (---------------)  + I kitahiroshima
	0x0027acc6, // n0x08a8 c0x0000 (---------------)  + I kitami
	0x002949c8, // n0x08a9 c0x0000 (---------------)  + I kiyosato
	0x002930c9, // n0x08aa c0x0000 (---------------)  + I koshimizu
	0x0029d9c8, // n0x08ab c0x0000 (---------------)  + I kunneppu
	0x00331088, // n0x08ac c0x0000 (---------------)  + I kuriyama
	0x0029f90c, // n0x08ad c0x0000 (---------------)  + I kuromatsunai
	0x002a1447, // n0x08ae c0x0000 (---------------)  + I kushiro
	0x002a3507, // n0x08af c0x0000 (---------------)  + I kutchan
	0x002a5cc5, // n0x08b0 c0x0000 (---------------)  + I kyowa
	0x00314207, // n0x08b1 c0x0000 (---------------)  + I mashike
	0x002972c8, // n0x08b2 c0x0000 (---------------)  + I matsumae
	0x002cce86, // n0x08b3 c0x0000 (---------------)  + I mikasa
	0x0033804c, // n0x08b4 c0x0000 (---------------)  + I minamifurano
	0x002abec8, // n0x08b5 c0x0000 (---------------)  + I mombetsu
	0x002b0a88, // n0x08b6 c0x0000 (---------------)  + I moseushi
	0x00204a86, // n0x08b7 c0x0000 (---------------)  + I mukawa
	0x00285787, // n0x08b8 c0x0000 (---------------)  + I muroran
	0x0023b144, // n0x08b9 c0x0000 (---------------)  + I naie
	0x002a1cc8, // n0x08ba c0x0000 (---------------)  + I nakagawa
	0x002b620c, // n0x08bb c0x0000 (---------------)  + I nakasatsunai
	0x0032ca0c, // n0x08bc c0x0000 (---------------)  + I nakatombetsu
	0x00221685, // n0x08bd c0x0000 (---------------)  + I nanae
	0x002a2f87, // n0x08be c0x0000 (---------------)  + I nanporo
	0x00212246, // n0x08bf c0x0000 (---------------)  + I nayoro
	0x00285706, // n0x08c0 c0x0000 (---------------)  + I nemuro
	0x00309c88, // n0x08c1 c0x0000 (---------------)  + I niikappu
	0x00205bc4, // n0x08c2 c0x0000 (---------------)  + I niki
	0x002294cb, // n0x08c3 c0x0000 (---------------)  + I nishiokoppe
	0x0029218b, // n0x08c4 c0x0000 (---------------)  + I noboribetsu
	0x002d69c6, // n0x08c5 c0x0000 (---------------)  + I numata
	0x002a7b07, // n0x08c6 c0x0000 (---------------)  + I obihiro
	0x0031a8c5, // n0x08c7 c0x0000 (---------------)  + I obira
	0x00258145, // n0x08c8 c0x0000 (---------------)  + I oketo
	0x00229606, // n0x08c9 c0x0000 (---------------)  + I okoppe
	0x0023e545, // n0x08ca c0x0000 (---------------)  + I otaru
	0x0024f385, // n0x08cb c0x0000 (---------------)  + I otobe
	0x00219047, // n0x08cc c0x0000 (---------------)  + I otofuke
	0x0020a7c9, // n0x08cd c0x0000 (---------------)  + I otoineppu
	0x00272704, // n0x08ce c0x0000 (---------------)  + I oumu
	0x002bfe85, // n0x08cf c0x0000 (---------------)  + I ozora
	0x002beb45, // n0x08d0 c0x0000 (---------------)  + I pippu
	0x00285888, // n0x08d1 c0x0000 (---------------)  + I rankoshi
	0x002069c5, // n0x08d2 c0x0000 (---------------)  + I rebun
	0x00248d09, // n0x08d3 c0x0000 (---------------)  + I rikubetsu
	0x002cd8c7, // n0x08d4 c0x0000 (---------------)  + I rishiri
	0x002cd8cb, // n0x08d5 c0x0000 (---------------)  + I rishirifuji
	0x002c5206, // n0x08d6 c0x0000 (---------------)  + I saroma
	0x0026a649, // n0x08d7 c0x0000 (---------------)  + I sarufutsu
	0x002e7ac8, // n0x08d8 c0x0000 (---------------)  + I shakotan
	0x002fdbc5, // n0x08d9 c0x0000 (---------------)  + I shari
	0x00206108, // n0x08da c0x0000 (---------------)  + I shibecha
	0x002359c8, // n0x08db c0x0000 (---------------)  + I shibetsu
	0x002d2947, // n0x08dc c0x0000 (---------------)  + I shikabe
	0x00297547, // n0x08dd c0x0000 (---------------)  + I shikaoi
	0x002aca49, // n0x08de c0x0000 (---------------)  + I shimamaki
	0x0022a207, // n0x08df c0x0000 (---------------)  + I shimizu
	0x00321349, // n0x08e0 c0x0000 (---------------)  + I shimokawa
	0x002cab8c, // n0x08e1 c0x0000 (---------------)  + I shinshinotsu
	0x002cc9c8, // n0x08e2 c0x0000 (---------------)  + I shintoku
	0x002ce709, // n0x08e3 c0x0000 (---------------)  + I shiranuka
	0x002ceac7, // n0x08e4 c0x0000 (---------------)  + I shiraoi
	0x00266c89, // n0x08e5 c0x0000 (---------------)  + I shiriuchi
	0x00202fc7, // n0x08e6 c0x0000 (---------------)  + I sobetsu
	0x0023d108, // n0x08e7 c0x0000 (---------------)  + I sunagawa
	0x002a0145, // n0x08e8 c0x0000 (---------------)  + I taiki
	0x0027cc06, // n0x08e9 c0x0000 (---------------)  + I takasu
	0x002a0948, // n0x08ea c0x0000 (---------------)  + I takikawa
	0x002f0f88, // n0x08eb c0x0000 (---------------)  + I takinoue
	0x002cc049, // n0x08ec c0x0000 (---------------)  + I teshikaga
	0x0024f3c7, // n0x08ed c0x0000 (---------------)  + I tobetsu
	0x00284985, // n0x08ee c0x0000 (---------------)  + I tohma
	0x002553c9, // n0x08ef c0x0000 (---------------)  + I tomakomai
	0x00253206, // n0x08f0 c0x0000 (---------------)  + I tomari
	0x00218dc4, // n0x08f1 c0x0000 (---------------)  + I toya
	0x0024d1c6, // n0x08f2 c0x0000 (---------------)  + I toyako
	0x002779c8, // n0x08f3 c0x0000 (---------------)  + I toyotomi
	0x0028b8c7, // n0x08f4 c0x0000 (---------------)  + I toyoura
	0x00294508, // n0x08f5 c0x0000 (---------------)  + I tsubetsu
	0x002eac89, // n0x08f6 c0x0000 (---------------)  + I tsukigata
	0x00228e47, // n0x08f7 c0x0000 (---------------)  + I urakawa
	0x00282e86, // n0x08f8 c0x0000 (---------------)  + I urausu
	0x0025e304, // n0x08f9 c0x0000 (---------------)  + I uryu
	0x00212409, // n0x08fa c0x0000 (---------------)  + I utashinai
	0x00344ec8, // n0x08fb c0x0000 (---------------)  + I wakkanai
	0x00204947, // n0x08fc c0x0000 (---------------)  + I wassamu
	0x00286586, // n0x08fd c0x0000 (---------------)  + I yakumo
	0x0028a9c6, // n0x08fe c0x0000 (---------------)  + I yoichi
	0x002e9f44, // n0x08ff c0x0000 (---------------)  + I aioi
	0x0029b4c6, // n0x0900 c0x0000 (---------------)  + I akashi
	0x00205e03, // n0x0901 c0x0000 (---------------)  + I ako
	0x002fa549, // n0x0902 c0x0000 (---------------)  + I amagasaki
	0x00205746, // n0x0903 c0x0000 (---------------)  + I aogaki
	0x0029f2c5, // n0x0904 c0x0000 (---------------)  + I asago
	0x002833c6, // n0x0905 c0x0000 (---------------)  + I ashiya
	0x0022a5c5, // n0x0906 c0x0000 (---------------)  + I awaji
	0x00265f48, // n0x0907 c0x0000 (---------------)  + I fukusaki
	0x002db9c7, // n0x0908 c0x0000 (---------------)  + I goshiki
	0x002eb886, // n0x0909 c0x0000 (---------------)  + I harima
	0x002a6c06, // n0x090a c0x0000 (---------------)  + I himeji
	0x00279008, // n0x090b c0x0000 (---------------)  + I ichikawa
	0x002852c7, // n0x090c c0x0000 (---------------)  + I inagawa
	0x0027ad05, // n0x090d c0x0000 (---------------)  + I itami
	0x002838c8, // n0x090e c0x0000 (---------------)  + I kakogawa
	0x0026f808, // n0x090f c0x0000 (---------------)  + I kamigori
	0x002a8548, // n0x0910 c0x0000 (---------------)  + I kamikawa
	0x0026aa85, // n0x0911 c0x0000 (---------------)  + I kasai
	0x0027cc86, // n0x0912 c0x0000 (---------------)  + I kasuga
	0x00200f09, // n0x0913 c0x0000 (---------------)  + I kawanishi
	0x0024d504, // n0x0914 c0x0000 (---------------)  + I miki
	0x0022a44b, // n0x0915 c0x0000 (---------------)  + I minamiawaji
	0x0022648b, // n0x0916 c0x0000 (---------------)  + I nishinomiya
	0x0022c989, // n0x0917 c0x0000 (---------------)  + I nishiwaki
	0x00206b83, // n0x0918 c0x0000 (---------------)  + I ono
	0x00246945, // n0x0919 c0x0000 (---------------)  + I sanda
	0x0024af46, // n0x091a c0x0000 (---------------)  + I sannan
	0x00272408, // n0x091b c0x0000 (---------------)  + I sasayama
	0x002cb9c4, // n0x091c c0x0000 (---------------)  + I sayo
	0x002c8bc6, // n0x091d c0x0000 (---------------)  + I shingu
	0x0024f809, // n0x091e c0x0000 (---------------)  + I shinonsen
	0x002d0745, // n0x091f c0x0000 (---------------)  + I shiso
	0x00218f86, // n0x0920 c0x0000 (---------------)  + I sumoto
	0x00200546, // n0x0921 c0x0000 (---------------)  + I taishi
	0x00204e44, // n0x0922 c0x0000 (---------------)  + I taka
	0x0020b20a, // n0x0923 c0x0000 (---------------)  + I takarazuka
	0x0029f208, // n0x0924 c0x0000 (---------------)  + I takasago
	0x002f0f86, // n0x0925 c0x0000 (---------------)  + I takino
	0x002bfc85, // n0x0926 c0x0000 (---------------)  + I tamba
	0x00234fc7, // n0x0927 c0x0000 (---------------)  + I tatsuno
	0x00261c87, // n0x0928 c0x0000 (---------------)  + I toyooka
	0x002fc684, // n0x0929 c0x0000 (---------------)  + I yabu
	0x002266c7, // n0x092a c0x0000 (---------------)  + I yashiro
	0x00251a44, // n0x092b c0x0000 (---------------)  + I yoka
	0x00251a46, // n0x092c c0x0000 (---------------)  + I yokawa
	0x00200dc3, // n0x092d c0x0000 (---------------)  + I ami
	0x002a5e85, // n0x092e c0x0000 (---------------)  + I asahi
	0x0032fc45, // n0x092f c0x0000 (---------------)  + I bando
	0x002b2fc8, // n0x0930 c0x0000 (---------------)  + I chikusei
	0x0026a405, // n0x0931 c0x0000 (---------------)  + I daigo
	0x00262109, // n0x0932 c0x0000 (---------------)  + I fujishiro
	0x00286d47, // n0x0933 c0x0000 (---------------)  + I hitachi
	0x002a1b0b, // n0x0934 c0x0000 (---------------)  + I hitachinaka
	0x00286d4c, // n0x0935 c0x0000 (---------------)  + I hitachiomiya
	0x0028778a, // n0x0936 c0x0000 (---------------)  + I hitachiota
	0x00329287, // n0x0937 c0x0000 (---------------)  + I ibaraki
	0x00208ac3, // n0x0938 c0x0000 (---------------)  + I ina
	0x002c9ac8, // n0x0939 c0x0000 (---------------)  + I inashiki
	0x0026ac45, // n0x093a c0x0000 (---------------)  + I itako
	0x002f8405, // n0x093b c0x0000 (---------------)  + I iwama
	0x0029cfc4, // n0x093c c0x0000 (---------------)  + I joso
	0x0023d006, // n0x093d c0x0000 (---------------)  + I kamisu
	0x00219f86, // n0x093e c0x0000 (---------------)  + I kasama
	0x0029b507, // n0x093f c0x0000 (---------------)  + I kashima
	0x0021be0b, // n0x0940 c0x0000 (---------------)  + I kasumigaura
	0x00283944, // n0x0941 c0x0000 (---------------)  + I koga
	0x002d2104, // n0x0942 c0x0000 (---------------)  + I miho
	0x002aad84, // n0x0943 c0x0000 (---------------)  + I mito
	0x002af246, // n0x0944 c0x0000 (---------------)  + I moriya
	0x0020ff84, // n0x0945 c0x0000 (---------------)  + I naka
	0x002d16c8, // n0x0946 c0x0000 (---------------)  + I namegata
	0x00303145, // n0x0947 c0x0000 (---------------)  + I oarai
	0x0022b205, // n0x0948 c0x0000 (---------------)  + I ogawa
	0x002b8307, // n0x0949 c0x0000 (---------------)  + I omitama
	0x0025e349, // n0x094a c0x0000 (---------------)  + I ryugasaki
	0x00306345, // n0x094b c0x0000 (---------------)  + I sakai
	0x002c034a, // n0x094c c0x0000 (---------------)  + I sakuragawa
	0x002508c9, // n0x094d c0x0000 (---------------)  + I shimodate
	0x002c894a, // n0x094e c0x0000 (---------------)  + I shimotsuma
	0x0030f489, // n0x094f c0x0000 (---------------)  + I shirosato
	0x002d7e44, // n0x0950 c0x0000 (---------------)  + I sowa
	0x002d0a85, // n0x0951 c0x0000 (---------------)  + I suifu
	0x002cfe88, // n0x0952 c0x0000 (---------------)  + I takahagi
	0x002a3bcb, // n0x0953 c0x0000 (---------------)  + I tamatsukuri
	0x002e4345, // n0x0954 c0x0000 (---------------)  + I tokai
	0x003093c6, // n0x0955 c0x0000 (---------------)  + I tomobe
	0x0023b784, // n0x0956 c0x0000 (---------------)  + I tone
	0x00262646, // n0x0957 c0x0000 (---------------)  + I toride
	0x00228cc9, // n0x0958 c0x0000 (---------------)  + I tsuchiura
	0x002bf687, // n0x0959 c0x0000 (---------------)  + I tsukuba
	0x002f9708, // n0x095a c0x0000 (---------------)  + I uchihara
	0x0028f186, // n0x095b c0x0000 (---------------)  + I ushiku
	0x00202887, // n0x095c c0x0000 (---------------)  + I yachiyo
	0x00266548, // n0x095d c0x0000 (---------------)  + I yamagata
	0x003281c6, // n0x095e c0x0000 (---------------)  + I yawara
	0x00342404, // n0x095f c0x0000 (---------------)  + I yuki
	0x00239547, // n0x0960 c0x0000 (---------------)  + I anamizu
	0x0026d685, // n0x0961 c0x0000 (---------------)  + I hakui
	0x0026da47, // n0x0962 c0x0000 (---------------)  + I hakusan
	0x00204844, // n0x0963 c0x0000 (---------------)  + I kaga
	0x002a9786, // n0x0964 c0x0000 (---------------)  + I kahoku
	0x0031ff48, // n0x0965 c0x0000 (---------------)  + I kanazawa
	0x0027bac8, // n0x0966 c0x0000 (---------------)  + I kawakita
	0x002b1d47, // n0x0967 c0x0000 (---------------)  + I komatsu
	0x0020ff88, // n0x0968 c0x0000 (---------------)  + I nakanoto
	0x00234105, // n0x0969 c0x0000 (---------------)  + I nanao
	0x00206bc4, // n0x096a c0x0000 (---------------)  + I nomi
	0x00278f08, // n0x096b c0x0000 (---------------)  + I nonoichi
	0x00210084, // n0x096c c0x0000 (---------------)  + I noto
	0x002506c5, // n0x096d c0x0000 (---------------)  + I shika
	0x002de804, // n0x096e c0x0000 (---------------)  + I suzu
	0x002d8cc7, // n0x096f c0x0000 (---------------)  + I tsubata
	0x002a8907, // n0x0970 c0x0000 (---------------)  + I tsurugi
	0x00266dc8, // n0x0971 c0x0000 (---------------)  + I uchinada
	0x0029dbc6, // n0x0972 c0x0000 (---------------)  + I wajima
	0x0026a385, // n0x0973 c0x0000 (---------------)  + I fudai
	0x00261f08, // n0x0974 c0x0000 (---------------)  + I fujisawa
	0x0026ccc8, // n0x0975 c0x0000 (---------------)  + I hanamaki
	0x002846c9, // n0x0976 c0x0000 (---------------)  + I hiraizumi
	0x00226786, // n0x0977 c0x0000 (---------------)  + I hirono
	0x003427c8, // n0x0978 c0x0000 (---------------)  + I ichinohe
	0x0020e74a, // n0x0979 c0x0000 (---------------)  + I ichinoseki
	0x002b7388, // n0x097a c0x0000 (---------------)  + I iwaizumi
	0x0028f885, // n0x097b c0x0000 (---------------)  + I iwate
	0x0025a586, // n0x097c c0x0000 (---------------)  + I joboji
	0x00250788, // n0x097d c0x0000 (---------------)  + I kamaishi
	0x0023a5ca, // n0x097e c0x0000 (---------------)  + I kanegasaki
	0x00350b87, // n0x097f c0x0000 (---------------)  + I karumai
	0x00265905, // n0x0980 c0x0000 (---------------)  + I kawai
	0x00275cc8, // n0x0981 c0x0000 (---------------)  + I kitakami
	0x002687c4, // n0x0982 c0x0000 (---------------)  + I kuji
	0x0021a486, // n0x0983 c0x0000 (---------------)  + I kunohe
	0x002a4308, // n0x0984 c0x0000 (---------------)  + I kuzumaki
	0x00215746, // n0x0985 c0x0000 (---------------)  + I miyako
	0x0022de08, // n0x0986 c0x0000 (---------------)  + I mizusawa
	0x00273e87, // n0x0987 c0x0000 (---------------)  + I morioka
	0x002e5bc6, // n0x0988 c0x0000 (---------------)  + I ninohe
	0x00345804, // n0x0989 c0x0000 (---------------)  + I noda
	0x003042c7, // n0x098a c0x0000 (---------------)  + I ofunato
	0x00293fc4, // n0x098b c0x0000 (---------------)  + I oshu
	0x00228c87, // n0x098c c0x0000 (---------------)  + I otsuchi
	0x00204c8d, // n0x098d c0x0000 (---------------)  + I rikuzentakata
	0x00215d85, // n0x098e c0x0000 (---------------)  + I shiwa
	0x002d114b, // n0x098f c0x0000 (---------------)  + I shizukuishi
	0x00217a06, // n0x0990 c0x0000 (---------------)  + I sumita
	0x00347f08, // n0x0991 c0x0000 (---------------)  + I takizawa
	0x0032d588, // n0x0992 c0x0000 (---------------)  + I tanohata
	0x00229104, // n0x0993 c0x0000 (---------------)  + I tono
	0x00294f06, // n0x0994 c0x0000 (---------------)  + I yahaba
	0x002638c6, // n0x0995 c0x0000 (---------------)  + I yamada
	0x002b5b47, // n0x0996 c0x0000 (---------------)  + I ayagawa
	0x0027b14d, // n0x0997 c0x0000 (---------------)  + I higashikagawa
	0x002e8b07, // n0x0998 c0x0000 (---------------)  + I kanonji
	0x002956c8, // n0x0999 c0x0000 (---------------)  + I kotohira
	0x00250405, // n0x099a c0x0000 (---------------)  + I manno
	0x00274508, // n0x099b c0x0000 (---------------)  + I marugame
	0x002ab506, // n0x099c c0x0000 (---------------)  + I mitoyo
	0x00234188, // n0x099d c0x0000 (---------------)  + I naoshima
	0x002528c6, // n0x099e c0x0000 (---------------)  + I sanuki
	0x003185c7, // n0x099f c0x0000 (---------------)  + I tadotsu
	0x0032d709, // n0x09a0 c0x0000 (---------------)  + I takamatsu
	0x00229107, // n0x09a1 c0x0000 (---------------)  + I tonosho
	0x0026bc88, // n0x09a2 c0x0000 (---------------)  + I uchinomi
	0x00255005, // n0x09a3 c0x0000 (---------------)  + I utazu
	0x00218348, // n0x09a4 c0x0000 (---------------)  + I zentsuji
	0x0024ad85, // n0x09a5 c0x0000 (---------------)  + I akune
	0x002279c5, // n0x09a6 c0x0000 (---------------)  + I amami
	0x00309745, // n0x09a7 c0x0000 (---------------)  + I hioki
	0x00226dc3, // n0x09a8 c0x0000 (---------------)  + I isa
	0x00268384, // n0x09a9 c0x0000 (---------------)  + I isen
	0x00275ec5, // n0x09aa c0x0000 (---------------)  + I izumi
	0x0034f049, // n0x09ab c0x0000 (---------------)  + I kagoshima
	0x002de906, // n0x09ac c0x0000 (---------------)  + I kanoya
	0x00269cc8, // n0x09ad c0x0000 (---------------)  + I kawanabe
	0x00324b85, // n0x09ae c0x0000 (---------------)  + I kinko
	0x00296887, // n0x09af c0x0000 (---------------)  + I kouyama
	0x0027404a, // n0x09b0 c0x0000 (---------------)  + I makurazaki
	0x00218ec9, // n0x09b1 c0x0000 (---------------)  + I matsumoto
	0x0025650a, // n0x09b2 c0x0000 (---------------)  + I minamitane
	0x002b40c8, // n0x09b3 c0x0000 (---------------)  + I nakatane
	0x00226f4c, // n0x09b4 c0x0000 (---------------)  + I nishinoomote
	0x0026808d, // n0x09b5 c0x0000 (---------------)  + I satsumasendai
	0x002d4cc3, // n0x09b6 c0x0000 (---------------)  + I soo
	0x0022dd08, // n0x09b7 c0x0000 (---------------)  + I tarumizu
	0x00218985, // n0x09b8 c0x0000 (---------------)  + I yusui
	0x00279b86, // n0x09b9 c0x0000 (---------------)  + I aikawa
	0x002a75c6, // n0x09ba c0x0000 (---------------)  + I atsugi
	0x00351405, // n0x09bb c0x0000 (---------------)  + I ayase
	0x0031c649, // n0x09bc c0x0000 (---------------)  + I chigasaki
	0x002ebc45, // n0x09bd c0x0000 (---------------)  + I ebina
	0x00261f08, // n0x09be c0x0000 (---------------)  + I fujisawa
	0x00305846, // n0x09bf c0x0000 (---------------)  + I hadano
	0x0034da86, // n0x09c0 c0x0000 (---------------)  + I hakone
	0x00286149, // n0x09c1 c0x0000 (---------------)  + I hiratsuka
	0x00336e47, // n0x09c2 c0x0000 (---------------)  + I isehara
	0x002d6406, // n0x09c3 c0x0000 (---------------)  + I kaisei
	0x00273fc8, // n0x09c4 c0x0000 (---------------)  + I kamakura
	0x002cfac8, // n0x09c5 c0x0000 (---------------)  + I kiyokawa
	0x00224907, // n0x09c6 c0x0000 (---------------)  + I matsuda
	0x002d7ace, // n0x09c7 c0x0000 (---------------)  + I minamiashigara
	0x002ab745, // n0x09c8 c0x0000 (---------------)  + I miura
	0x002b6905, // n0x09c9 c0x0000 (---------------)  + I nakai
	0x00215648, // n0x09ca c0x0000 (---------------)  + I ninomiya
	0x00345847, // n0x09cb c0x0000 (---------------)  + I odawara
	0x0020a842, // n0x09cc c0x0000 (---------------)  + I oi
	0x0029f604, // n0x09cd c0x0000 (---------------)  + I oiso
	0x0025be0a, // n0x09ce c0x0000 (---------------)  + I sagamihara
	0x00204a08, // n0x09cf c0x0000 (---------------)  + I samukawa
	0x002dc446, // n0x09d0 c0x0000 (---------------)  + I tsukui
	0x0027e2c8, // n0x09d1 c0x0000 (---------------)  + I yamakita
	0x0024d686, // n0x09d2 c0x0000 (---------------)  + I yamato
	0x002a7388, // n0x09d3 c0x0000 (---------------)  + I yokosuka
	0x0028e588, // n0x09d4 c0x0000 (---------------)  + I yugawara
	0x00227984, // n0x09d5 c0x0000 (---------------)  + I zama
	0x00297185, // n0x09d6 c0x0000 (---------------)  + I zushi
	0x00625ec4, // n0x09d7 c0x0001 (---------------)  ! I city
	0x00625ec4, // n0x09d8 c0x0001 (---------------)  ! I city
	0x00625ec4, // n0x09d9 c0x0001 (---------------)  ! I city
	0x00200783, // n0x09da c0x0000 (---------------)  + I aki
	0x002ed086, // n0x09db c0x0000 (---------------)  + I geisei
	0x002623c6, // n0x09dc c0x0000 (---------------)  + I hidaka
	0x002829cc, // n0x09dd c0x0000 (---------------)  + I higashitsuno
	0x00200683, // n0x09de c0x0000 (---------------)  + I ino
	0x002cc186, // n0x09df c0x0000 (---------------)  + I kagami
	0x00200d84, // n0x09e0 c0x0000 (---------------)  + I kami
	0x002acc08, // n0x09e1 c0x0000 (---------------)  + I kitagawa
	0x002b2f45, // n0x09e2 c0x0000 (---------------)  + I kochi
	0x0025bf06, // n0x09e3 c0x0000 (---------------)  + I mihara
	0x00218d48, // n0x09e4 c0x0000 (---------------)  + I motoyama
	0x002b7e06, // n0x09e5 c0x0000 (---------------)  + I muroto
	0x002eb806, // n0x09e6 c0x0000 (---------------)  + I nahari
	0x00273b88, // n0x09e7 c0x0000 (---------------)  + I nakamura
	0x0021fb87, // n0x09e8 c0x0000 (---------------)  + I nankoku
	0x00229fc9, // n0x09e9 c0x0000 (---------------)  + I nishitosa
	0x002309ca, // n0x09ea c0x0000 (---------------)  + I niyodogawa
	0x00251f04, // n0x09eb c0x0000 (---------------)  + I ochi
	0x00200ec5, // n0x09ec c0x0000 (---------------)  + I okawa
	0x00258585, // n0x09ed c0x0000 (---------------)  + I otoyo
	0x00227286, // n0x09ee c0x0000 (---------------)  + I otsuki
	0x002b4f46, // n0x09ef c0x0000 (---------------)  + I sakawa
	0x00282306, // n0x09f0 c0x0000 (---------------)  + I sukumo
	0x002cae06, // n0x09f1 c0x0000 (---------------)  + I susaki
	0x0022a104, // n0x09f2 c0x0000 (---------------)  + I tosa
	0x0022a10b, // n0x09f3 c0x0000 (---------------)  + I tosashimizu
	0x002519c4, // n0x09f4 c0x0000 (---------------)  + I toyo
	0x00235045, // n0x09f5 c0x0000 (---------------)  + I tsuno
	0x0028d1c5, // n0x09f6 c0x0000 (---------------)  + I umaji
	0x0025e6c6, // n0x09f7 c0x0000 (---------------)  + I yasuda
	0x00210b48, // n0x09f8 c0x0000 (---------------)  + I yusuhara
	0x00267f47, // n0x09f9 c0x0000 (---------------)  + I amakusa
	0x0030f204, // n0x09fa c0x0000 (---------------)  + I arao
	0x00210a03, // n0x09fb c0x0000 (---------------)  + I aso
	0x0030c405, // n0x09fc c0x0000 (---------------)  + I choyo
	0x002530c7, // n0x09fd c0x0000 (---------------)  + I gyokuto
	0x00287bc9, // n0x09fe c0x0000 (---------------)  + I hitoyoshi
	0x00267e4b, // n0x09ff c0x0000 (---------------)  + I kamiamakusa
	0x0029b507, // n0x0a00 c0x0000 (---------------)  + I kashima
	0x002b5847, // n0x0a01 c0x0000 (---------------)  + I kikuchi
	0x00290b84, // n0x0a02 c0x0000 (---------------)  + I kosa
	0x00218c48, // n0x0a03 c0x0000 (---------------)  + I kumamoto
	0x00311507, // n0x0a04 c0x0000 (---------------)  + I mashiki
	0x0027ee06, // n0x0a05 c0x0000 (---------------)  + I mifune
	0x002f1988, // n0x0a06 c0x0000 (---------------)  + I minamata
	0x00247dcb, // n0x0a07 c0x0000 (---------------)  + I minamioguni
	0x0033e106, // n0x0a08 c0x0000 (---------------)  + I nagasu
	0x00234649, // n0x0a09 c0x0000 (---------------)  + I nishihara
	0x00247f45, // n0x0a0a c0x0000 (---------------)  + I oguni
	0x002fc943, // n0x0a0b c0x0000 (---------------)  + I ozu
	0x00218f86, // n0x0a0c c0x0000 (---------------)  + I sumoto
	0x00273d88, // n0x0a0d c0x0000 (---------------)  + I takamori
	0x00227343, // n0x0a0e c0x0000 (---------------)  + I uki
	0x002531c3, // n0x0a0f c0x0000 (---------------)  + I uto
	0x00266546, // n0x0a10 c0x0000 (---------------)  + I yamaga
	0x0024d686, // n0x0a11 c0x0000 (---------------)  + I yamato
	0x0031718a, // n0x0a12 c0x0000 (---------------)  + I yatsushiro
	0x00263085, // n0x0a13 c0x0000 (---------------)  + I ayabe
	0x0026370b, // n0x0a14 c0x0000 (---------------)  + I fukuchiyama
	0x0028330b, // n0x0a15 c0x0000 (---------------)  + I higashiyama
	0x00260503, // n0x0a16 c0x0000 (---------------)  + I ide
	0x0020a883, // n0x0a17 c0x0000 (---------------)  + I ine
	0x002c92c4, // n0x0a18 c0x0000 (---------------)  + I joyo
	0x002c9707, // n0x0a19 c0x0000 (---------------)  + I kameoka
	0x00273e04, // n0x0a1a c0x0000 (---------------)  + I kamo
	0x0023a944, // n0x0a1b c0x0000 (---------------)  + I kita
	0x002ad344, // n0x0a1c c0x0000 (---------------)  + I kizu
	0x002b7688, // n0x0a1d c0x0000 (---------------)  + I kumiyama
	0x002bfbc8, // n0x0a1e c0x0000 (---------------)  + I kyotamba
	0x0031c949, // n0x0a1f c0x0000 (---------------)  + I kyotanabe
	0x0021ed08, // n0x0a20 c0x0000 (---------------)  + I kyotango
	0x002794c7, // n0x0a21 c0x0000 (---------------)  + I maizuru
	0x0020aa46, // n0x0a22 c0x0000 (---------------)  + I minami
	0x0026990f, // n0x0a23 c0x0000 (---------------)  + I minamiyamashiro
	0x002ab886, // n0x0a24 c0x0000 (---------------)  + I miyazu
	0x002b2ec4, // n0x0a25 c0x0000 (---------------)  + I muko
	0x002bfa0a, // n0x0a26 c0x0000 (---------------)  + I nagaokakyo
	0x00252fc7, // n0x0a27 c0x0000 (---------------)  + I nakagyo
	0x002d99c6, // n0x0a28 c0x0000 (---------------)  + I nantan
	0x00275b09, // n0x0a29 c0x0000 (---------------)  + I oyamazaki
	0x0031c8c5, // n0x0a2a c0x0000 (---------------)  + I sakyo
	0x00306e45, // n0x0a2b c0x0000 (---------------)  + I seika
	0x0031ca06, // n0x0a2c c0x0000 (---------------)  + I tanabe
	0x00218483, // n0x0a2d c0x0000 (---------------)  + I uji
	0x00268809, // n0x0a2e c0x0000 (---------------)  + I ujitawara
	0x002a2e06, // n0x0a2f c0x0000 (---------------)  + I wazuka
	0x002c9949, // n0x0a30 c0x0000 (---------------)  + I yamashina
	0x0032f206, // n0x0a31 c0x0000 (---------------)  + I yawata
	0x002a5e85, // n0x0a32 c0x0000 (---------------)  + I asahi
	0x002a2245, // n0x0a33 c0x0000 (---------------)  + I inabe
	0x00237343, // n0x0a34 c0x0000 (---------------)  + I ise
	0x002c9848, // n0x0a35 c0x0000 (---------------)  + I kameyama
	0x002b4fc7, // n0x0a36 c0x0000 (---------------)  + I kawagoe
	0x00205c44, // n0x0a37 c0x0000 (---------------)  + I kiho
	0x0023a7c8, // n0x0a38 c0x0000 (---------------)  + I kisosaki
	0x00336304, // n0x0a39 c0x0000 (---------------)  + I kiwa
	0x002c29c6, // n0x0a3a c0x0000 (---------------)  + I komono
	0x002ca246, // n0x0a3b c0x0000 (---------------)  + I kumano
	0x00239486, // n0x0a3c c0x0000 (---------------)  + I kuwana
	0x00256b89, // n0x0a3d c0x0000 (---------------)  + I matsusaka
	0x002f8385, // n0x0a3e c0x0000 (---------------)  + I meiwa
	0x00287e06, // n0x0a3f c0x0000 (---------------)  + I mihama
	0x002371c9, // n0x0a40 c0x0000 (---------------)  + I minamiise
	0x002aa146, // n0x0a41 c0x0000 (---------------)  + I misugi
	0x00269a06, // n0x0a42 c0x0000 (---------------)  + I miyama
	0x00332506, // n0x0a43 c0x0000 (---------------)  + I nabari
	0x00227585, // n0x0a44 c0x0000 (---------------)  + I shima
	0x002de806, // n0x0a45 c0x0000 (---------------)  + I suzuka
	0x003185c4, // n0x0a46 c0x0000 (---------------)  + I tado
	0x002a0145, // n0x0a47 c0x0000 (---------------)  + I taiki
	0x002a0944, // n0x0a48 c0x0000 (---------------)  + I taki
	0x00295dc6, // n0x0a49 c0x0000 (---------------)  + I tamaki
	0x0030f644, // n0x0a4a c0x0000 (---------------)  + I toba
	0x002030c3, // n0x0a4b c0x0000 (---------------)  + I tsu
	0x0026af05, // n0x0a4c c0x0000 (---------------)  + I udono
	0x002356c8, // n0x0a4d c0x0000 (---------------)  + I ureshino
	0x0028f5c7, // n0x0a4e c0x0000 (---------------)  + I watarai
	0x002cba49, // n0x0a4f c0x0000 (---------------)  + I yokkaichi
	0x0026b148, // n0x0a50 c0x0000 (---------------)  + I furukawa
	0x0027da11, // n0x0a51 c0x0000 (---------------)  + I higashimatsushima
	0x002005ca, // n0x0a52 c0x0000 (---------------)  + I ishinomaki
	0x002d6907, // n0x0a53 c0x0000 (---------------)  + I iwanuma
	0x00306f06, // n0x0a54 c0x0000 (---------------)  + I kakuda
	0x00200d84, // n0x0a55 c0x0000 (---------------)  + I kami
	0x002a0a48, // n0x0a56 c0x0000 (---------------)  + I kawasaki
	0x0033e289, // n0x0a57 c0x0000 (---------------)  + I kesennuma
	0x00276dc8, // n0x0a58 c0x0000 (---------------)  + I marumori
	0x0027dbca, // n0x0a59 c0x0000 (---------------)  + I matsushima
	0x00248acd, // n0x0a5a c0x0000 (---------------)  + I minamisanriku
	0x00279206, // n0x0a5b c0x0000 (---------------)  + I misato
	0x00273c86, // n0x0a5c c0x0000 (---------------)  + I murata
	0x00304386, // n0x0a5d c0x0000 (---------------)  + I natori
	0x0022b207, // n0x0a5e c0x0000 (---------------)  + I ogawara
	0x00295785, // n0x0a5f c0x0000 (---------------)  + I ohira
	0x002914c7, // n0x0a60 c0x0000 (---------------)  + I onagawa
	0x0023a885, // n0x0a61 c0x0000 (---------------)  + I osaki
	0x002cda04, // n0x0a62 c0x0000 (---------------)  + I rifu
	0x002bb686, // n0x0a63 c0x0000 (---------------)  + I semine
	0x0020b0c7, // n0x0a64 c0x0000 (---------------)  + I shibata
	0x00330ccd, // n0x0a65 c0x0000 (---------------)  + I shichikashuku
	0x002506c7, // n0x0a66 c0x0000 (---------------)  + I shikama
	0x002affc8, // n0x0a67 c0x0000 (---------------)  + I shiogama
	0x00262209, // n0x0a68 c0x0000 (---------------)  + I shiroishi
	0x00285cc6, // n0x0a69 c0x0000 (---------------)  + I tagajo
	0x0025f085, // n0x0a6a c0x0000 (---------------)  + I taiwa
	0x00254084, // n0x0a6b c0x0000 (---------------)  + I tome
	0x00277ac6, // n0x0a6c c0x0000 (---------------)  + I tomiya
	0x002fc586, // n0x0a6d c0x0000 (---------------)  + I wakuya
	0x00204b86, // n0x0a6e c0x0000 (---------------)  + I watari
	0x00280d48, // n0x0a6f c0x0000 (---------------)  + I yamamoto
	0x0022fc43, // n0x0a70 c0x0000 (---------------)  + I zao
	0x0024d643, // n0x0a71 c0x0000 (---------------)  + I aya
	0x00224085, // n0x0a72 c0x0000 (---------------)  + I ebino
	0x00319c06, // n0x0a73 c0x0000 (---------------)  + I gokase
	0x0028e545, // n0x0a74 c0x0000 (---------------)  + I hyuga
	0x0028f388, // n0x0a75 c0x0000 (---------------)  + I kadogawa
	0x00281d8a, // n0x0a76 c0x0000 (---------------)  + I kawaminami
	0x002eca04, // n0x0a77 c0x0000 (---------------)  + I kijo
	0x002acc08, // n0x0a78 c0x0000 (---------------)  + I kitagawa
	0x00298a08, // n0x0a79 c0x0000 (---------------)  + I kitakata
	0x0025e507, // n0x0a7a c0x0000 (---------------)  + I kitaura
	0x00324c49, // n0x0a7b c0x0000 (---------------)  + I kobayashi
	0x0029d188, // n0x0a7c c0x0000 (---------------)  + I kunitomi
	0x00227507, // n0x0a7d c0x0000 (---------------)  + I kushima
	0x0029f106, // n0x0a7e c0x0000 (---------------)  + I mimata
	0x0021574a, // n0x0a7f c0x0000 (---------------)  + I miyakonojo
	0x00277b48, // n0x0a80 c0x0000 (---------------)  + I miyazaki
	0x002e7d49, // n0x0a81 c0x0000 (---------------)  + I morotsuka
	0x002c8fc8, // n0x0a82 c0x0000 (---------------)  + I nichinan
	0x00307989, // n0x0a83 c0x0000 (---------------)  + I nishimera
	0x00313ac7, // n0x0a84 c0x0000 (---------------)  + I nobeoka
	0x002d1505, // n0x0a85 c0x0000 (---------------)  + I saito
	0x0028d9c6, // n0x0a86 c0x0000 (---------------)  + I shiiba
	0x002ccd08, // n0x0a87 c0x0000 (---------------)  + I shintomi
	0x0023aac8, // n0x0a88 c0x0000 (---------------)  + I takaharu
	0x00298b88, // n0x0a89 c0x0000 (---------------)  + I takanabe
	0x002da488, // n0x0a8a c0x0000 (---------------)  + I takazaki
	0x00235045, // n0x0a8b c0x0000 (---------------)  + I tsuno
	0x002028c4, // n0x0a8c c0x0000 (---------------)  + I achi
	0x0030eb88, // n0x0a8d c0x0000 (---------------)  + I agematsu
	0x002a2f44, // n0x0a8e c0x0000 (---------------)  + I anan
	0x0030f284, // n0x0a8f c0x0000 (---------------)  + I aoki
	0x002a5e85, // n0x0a90 c0x0000 (---------------)  + I asahi
	0x00277687, // n0x0a91 c0x0000 (---------------)  + I azumino
	0x0025e109, // n0x0a92 c0x0000 (---------------)  + I chikuhoku
	0x002b5947, // n0x0a93 c0x0000 (---------------)  + I chikuma
	0x00206cc5, // n0x0a94 c0x0000 (---------------)  + I chino
	0x00260a86, // n0x0a95 c0x0000 (---------------)  + I fujimi
	0x0026d4c6, // n0x0a96 c0x0000 (---------------)  + I hakuba
	0x0020da84, // n0x0a97 c0x0000 (---------------)  + I hara
	0x00286486, // n0x0a98 c0x0000 (---------------)  + I hiraya
	0x0026a1c4, // n0x0a99 c0x0000 (---------------)  + I iida
	0x00276cc6, // n0x0a9a c0x0000 (---------------)  + I iijima
	0x0020b786, // n0x0a9b c0x0000 (---------------)  + I iiyama
	0x0025dc46, // n0x0a9c c0x0000 (---------------)  + I iizuna
	0x00205505, // n0x0a9d c0x0000 (---------------)  + I ikeda
	0x0028f247, // n0x0a9e c0x0000 (---------------)  + I ikusaka
	0x00208ac3, // n0x0a9f c0x0000 (---------------)  + I ina
	0x00349e09, // n0x0aa0 c0x0000 (---------------)  + I karuizawa
	0x002d6108, // n0x0aa1 c0x0000 (---------------)  + I kawakami
	0x00227384, // n0x0aa2 c0x0000 (---------------)  + I kiso
	0x0022738d, // n0x0aa3 c0x0000 (---------------)  + I kisofukushima
	0x0027bbc8, // n0x0aa4 c0x0000 (---------------)  + I kitaaiki
	0x002a1248, // n0x0aa5 c0x0000 (---------------)  + I komagane
	0x002e7cc6, // n0x0aa6 c0x0000 (---------------)  + I komoro
	0x0032d809, // n0x0aa7 c0x0000 (---------------)  + I matsukawa
	0x00218ec9, // n0x0aa8 c0x0000 (---------------)  + I matsumoto
	0x002289c5, // n0x0aa9 c0x0000 (---------------)  + I miasa
	0x00281e8a, // n0x0aaa c0x0000 (---------------)  + I minamiaiki
	0x0023f64a, // n0x0aab c0x0000 (---------------)  + I minamimaki
	0x0024074c, // n0x0aac c0x0000 (---------------)  + I minamiminowa
	0x002408c6, // n0x0aad c0x0000 (---------------)  + I minowa
	0x00260f46, // n0x0aae c0x0000 (---------------)  + I miyada
	0x002aba06, // n0x0aaf c0x0000 (---------------)  + I miyota
	0x00251ec9, // n0x0ab0 c0x0000 (---------------)  + I mochizuki
	0x0030f046, // n0x0ab1 c0x0000 (---------------)  + I nagano
	0x0021d206, // n0x0ab2 c0x0000 (---------------)  + I nagawa
	0x002ebd06, // n0x0ab3 c0x0000 (---------------)  + I nagiso
	0x002a1cc8, // n0x0ab4 c0x0000 (---------------)  + I nakagawa
	0x0020ff86, // n0x0ab5 c0x0000 (---------------)  + I nakano
	0x00217c8b, // n0x0ab6 c0x0000 (---------------)  + I nozawaonsen
	0x00277805, // n0x0ab7 c0x0000 (---------------)  + I obuse
	0x0022b205, // n0x0ab8 c0x0000 (---------------)  + I ogawa
	0x002611c5, // n0x0ab9 c0x0000 (---------------)  + I okaya
	0x00230586, // n0x0aba c0x0000 (---------------)  + I omachi
	0x00206c03, // n0x0abb c0x0000 (---------------)  + I omi
	0x00239406, // n0x0abc c0x0000 (---------------)  + I ookuwa
	0x00250647, // n0x0abd c0x0000 (---------------)  + I ooshika
	0x002a0905, // n0x0abe c0x0000 (---------------)  + I otaki
	0x0026fd05, // n0x0abf c0x0000 (---------------)  + I otari
	0x00290e45, // n0x0ac0 c0x0000 (---------------)  + I sakae
	0x002d4f86, // n0x0ac1 c0x0000 (---------------)  + I sakaki
	0x00228a84, // n0x0ac2 c0x0000 (---------------)  + I saku
	0x0032bb06, // n0x0ac3 c0x0000 (---------------)  + I sakuho
	0x002c7fc9, // n0x0ac4 c0x0000 (---------------)  + I shimosuwa
	0x0023040c, // n0x0ac5 c0x0000 (---------------)  + I shinanomachi
	0x002cd748, // n0x0ac6 c0x0000 (---------------)  + I shiojiri
	0x0024f504, // n0x0ac7 c0x0000 (---------------)  + I suwa
	0x002e8a06, // n0x0ac8 c0x0000 (---------------)  + I suzaka
	0x00217b06, // n0x0ac9 c0x0000 (---------------)  + I takagi
	0x00273d88, // n0x0aca c0x0000 (---------------)  + I takamori
	0x002d6ac8, // n0x0acb c0x0000 (---------------)  + I takayama
	0x00230309, // n0x0acc c0x0000 (---------------)  + I tateshina
	0x00234fc7, // n0x0acd c0x0000 (---------------)  + I tatsuno
	0x002c1a89, // n0x0ace c0x0000 (---------------)  + I togakushi
	0x00266986, // n0x0acf c0x0000 (---------------)  + I togura
	0x00277ac4, // n0x0ad0 c0x0000 (---------------)  + I tomi
	0x00269fc4, // n0x0ad1 c0x0000 (---------------)  + I ueda
	0x0026b8c4, // n0x0ad2 c0x0000 (---------------)  + I wada
	0x00266548, // n0x0ad3 c0x0000 (---------------)  + I yamagata
	0x0025df4a, // n0x0ad4 c0x0000 (---------------)  + I yamanouchi
	0x003062c6, // n0x0ad5 c0x0000 (---------------)  + I yasaka
	0x003111c7, // n0x0ad6 c0x0000 (---------------)  + I yasuoka
	0x0023e2c7, // n0x0ad7 c0x0000 (---------------)  + I chijiwa
	0x0026a745, // n0x0ad8 c0x0000 (---------------)  + I futsu
	0x002ca5c4, // n0x0ad9 c0x0000 (---------------)  + I goto
	0x00273746, // n0x0ada c0x0000 (---------------)  + I hasami
	0x002957c6, // n0x0adb c0x0000 (---------------)  + I hirado
	0x00205c03, // n0x0adc c0x0000 (---------------)  + I iki
	0x002d5f47, // n0x0add c0x0000 (---------------)  + I isahaya
	0x002826c8, // n0x0ade c0x0000 (---------------)  + I kawatana
	0x00228b0a, // n0x0adf c0x0000 (---------------)  + I kuchinotsu
	0x002d7108, // n0x0ae0 c0x0000 (---------------)  + I matsuura
	0x002e9c88, // n0x0ae1 c0x0000 (---------------)  + I nagasaki
	0x0030f685, // n0x0ae2 c0x0000 (---------------)  + I obama
	0x00295905, // n0x0ae3 c0x0000 (---------------)  + I omura
	0x002c19c5, // n0x0ae4 c0x0000 (---------------)  + I oseto
	0x0026ab06, // n0x0ae5 c0x0000 (---------------)  + I saikai
	0x00275346, // n0x0ae6 c0x0000 (---------------)  + I sasebo
	0x002b3105, // n0x0ae7 c0x0000 (---------------)  + I seihi
	0x002fa789, // n0x0ae8 c0x0000 (---------------)  + I shimabara
	0x002ca3cc, // n0x0ae9 c0x0000 (---------------)  + I shinkamigoto
	0x00238747, // n0x0aea c0x0000 (---------------)  + I togitsu
	0x0027dc48, // n0x0aeb c0x0000 (---------------)  + I tsushima
	0x00272dc5, // n0x0aec c0x0000 (---------------)  + I unzen
	0x00625ec4, // n0x0aed c0x0001 (---------------)  ! I city
	0x002236c4, // n0x0aee c0x0000 (---------------)  + I ando
	0x00329944, // n0x0aef c0x0000 (---------------)  + I gose
	0x00255dc6, // n0x0af0 c0x0000 (---------------)  + I heguri
	0x00283e8e, // n0x0af1 c0x0000 (---------------)  + I higashiyoshino
	0x002bbd87, // n0x0af2 c0x0000 (---------------)  + I ikaruga
	0x0022b405, // n0x0af3 c0x0000 (---------------)  + I ikoma
	0x0024d48c, // n0x0af4 c0x0000 (---------------)  + I kamikitayama
	0x002cf987, // n0x0af5 c0x0000 (---------------)  + I kanmaki
	0x0020b047, // n0x0af6 c0x0000 (---------------)  + I kashiba
	0x0020d949, // n0x0af7 c0x0000 (---------------)  + I kashihara
	0x0028a1c9, // n0x0af8 c0x0000 (---------------)  + I katsuragi
	0x00265905, // n0x0af9 c0x0000 (---------------)  + I kawai
	0x002d6108, // n0x0afa c0x0000 (---------------)  + I kawakami
	0x00200f09, // n0x0afb c0x0000 (---------------)  + I kawanishi
	0x00290145, // n0x0afc c0x0000 (---------------)  + I koryo
	0x002a0848, // n0x0afd c0x0000 (---------------)  + I kurotaki
	0x002b2d46, // n0x0afe c0x0000 (---------------)  + I mitsue
	0x00206e06, // n0x0aff c0x0000 (---------------)  + I miyake
	0x00334484, // n0x0b00 c0x0000 (---------------)  + I nara
	0x00224148, // n0x0b01 c0x0000 (---------------)  + I nosegawa
	0x0025a643, // n0x0b02 c0x0000 (---------------)  + I oji
	0x002ed244, // n0x0b03 c0x0000 (---------------)  + I ouda
	0x0030c485, // n0x0b04 c0x0000 (---------------)  + I oyodo
	0x002a2747, // n0x0b05 c0x0000 (---------------)  + I sakurai
	0x00246745, // n0x0b06 c0x0000 (---------------)  + I sango
	0x0020e609, // n0x0b07 c0x0000 (---------------)  + I shimoichi
	0x0032228d, // n0x0b08 c0x0000 (---------------)  + I shimokitayama
	0x002c91c6, // n0x0b09 c0x0000 (---------------)  + I shinjo
	0x00309c04, // n0x0b0a c0x0000 (---------------)  + I soni
	0x002d1848, // n0x0b0b c0x0000 (---------------)  + I takatori
	0x0020a60a, // n0x0b0c c0x0000 (---------------)  + I tawaramoto
	0x00274987, // n0x0b0d c0x0000 (---------------)  + I tenkawa
	0x002e1645, // n0x0b0e c0x0000 (---------------)  + I tenri
	0x00224a03, // n0x0b0f c0x0000 (---------------)  + I uda
	0x002834ce, // n0x0b10 c0x0000 (---------------)  + I yamatokoriyama
	0x0024d68c, // n0x0b11 c0x0000 (---------------)  + I yamatotakada
	0x002cd587, // n0x0b12 c0x0000 (---------------)  + I yamazoe
	0x00284047, // n0x0b13 c0x0000 (---------------)  + I yoshino
	0x00204883, // n0x0b14 c0x0000 (---------------)  + I aga
	0x0030f085, // n0x0b15 c0x0000 (---------------)  + I agano
	0x00329945, // n0x0b16 c0x0000 (---------------)  + I gosen
	0x0027e688, // n0x0b17 c0x0000 (---------------)  + I itoigawa
	0x0027ab09, // n0x0b18 c0x0000 (---------------)  + I izumozaki
	0x00207186, // n0x0b19 c0x0000 (---------------)  + I joetsu
	0x00273e04, // n0x0b1a c0x0000 (---------------)  + I kamo
	0x002d6846, // n0x0b1b c0x0000 (---------------)  + I kariwa
	0x002176cb, // n0x0b1c c0x0000 (---------------)  + I kashiwazaki
	0x0025690c, // n0x0b1d c0x0000 (---------------)  + I minamiuonuma
	0x00264a07, // n0x0b1e c0x0000 (---------------)  + I mitsuke
	0x002b2c05, // n0x0b1f c0x0000 (---------------)  + I muika
	0x0026f708, // n0x0b20 c0x0000 (---------------)  + I murakami
	0x002246c5, // n0x0b21 c0x0000 (---------------)  + I myoko
	0x002bfa07, // n0x0b22 c0x0000 (---------------)  + I nagaoka
	0x002871c7, // n0x0b23 c0x0000 (---------------)  + I niigata
	0x0028ed05, // n0x0b24 c0x0000 (---------------)  + I ojiya
	0x00206c03, // n0x0b25 c0x0000 (---------------)  + I omi
	0x0022eac4, // n0x0b26 c0x0000 (---------------)  + I sado
	0x00248245, // n0x0b27 c0x0000 (---------------)  + I sanjo
	0x002ed145, // n0x0b28 c0x0000 (---------------)  + I seiro
	0x002ed146, // n0x0b29 c0x0000 (---------------)  + I seirou
	0x002c7dc8, // n0x0b2a c0x0000 (---------------)  + I sekikawa
	0x0020b0c7, // n0x0b2b c0x0000 (---------------)  + I shibata
	0x002a78c6, // n0x0b2c c0x0000 (---------------)  + I tagami
	0x00279a86, // n0x0b2d c0x0000 (---------------)  + I tainai
	0x00309686, // n0x0b2e c0x0000 (---------------)  + I tochio
	0x00294189, // n0x0b2f c0x0000 (---------------)  + I tokamachi
	0x00345147, // n0x0b30 c0x0000 (---------------)  + I tsubame
	0x0026cac6, // n0x0b31 c0x0000 (---------------)  + I tsunan
	0x00256a86, // n0x0b32 c0x0000 (---------------)  + I uonuma
	0x002b5486, // n0x0b33 c0x0000 (---------------)  + I yahiko
	0x002c9345, // n0x0b34 c0x0000 (---------------)  + I yoita
	0x002237c6, // n0x0b35 c0x0000 (---------------)  + I yuzawa
	0x0033de85, // n0x0b36 c0x0000 (---------------)  + I beppu
	0x00206a48, // n0x0b37 c0x0000 (---------------)  + I bungoono
	0x0029988b, // n0x0b38 c0x0000 (---------------)  + I bungotakada
	0x00273546, // n0x0b39 c0x0000 (---------------)  + I hasama
	0x0023e304, // n0x0b3a c0x0000 (---------------)  + I hiji
	0x002cf109, // n0x0b3b c0x0000 (---------------)  + I himeshima
	0x00286d44, // n0x0b3c c0x0000 (---------------)  + I hita
	0x002b2cc8, // n0x0b3d c0x0000 (---------------)  + I kamitsue
	0x0031eac7, // n0x0b3e c0x0000 (---------------)  + I kokonoe
	0x00330f84, // n0x0b3f c0x0000 (---------------)  + I kuju
	0x0029c748, // n0x0b40 c0x0000 (---------------)  + I kunisaki
	0x002a32c4, // n0x0b41 c0x0000 (---------------)  + I kusu
	0x002c9384, // n0x0b42 c0x0000 (---------------)  + I oita
	0x0026b6c5, // n0x0b43 c0x0000 (---------------)  + I saiki
	0x0029b386, // n0x0b44 c0x0000 (---------------)  + I taketa
	0x002b75c7, // n0x0b45 c0x0000 (---------------)  + I tsukumi
	0x0022dec3, // n0x0b46 c0x0000 (---------------)  + I usa
	0x00282f45, // n0x0b47 c0x0000 (---------------)  + I usuki
	0x002654c4, // n0x0b48 c0x0000 (---------------)  + I yufu
	0x002b6946, // n0x0b49 c0x0000 (---------------)  + I akaiwa
	0x00228a48, // n0x0b4a c0x0000 (---------------)  + I asakuchi
	0x002b5185, // n0x0b4b c0x0000 (---------------)  + I bizen
	0x00277189, // n0x0b4c c0x0000 (---------------)  + I hayashima
	0x002555c5, // n0x0b4d c0x0000 (---------------)  + I ibara
	0x0030f8c8, // n0x0b4e c0x0000 (---------------)  + I kagamino
	0x00200c47, // n0x0b4f c0x0000 (---------------)  + I kasaoka
	0x002fc788, // n0x0b50 c0x0000 (---------------)  + I kibichuo
	0x0029be87, // n0x0b51 c0x0000 (---------------)  + I kumenan
	0x00335fc9, // n0x0b52 c0x0000 (---------------)  + I kurashiki
	0x002eb986, // n0x0b53 c0x0000 (---------------)  + I maniwa
	0x002aaf86, // n0x0b54 c0x0000 (---------------)  + I misaki
	0x002ebd04, // n0x0b55 c0x0000 (---------------)  + I nagi
	0x002d7a05, // n0x0b56 c0x0000 (---------------)  + I niimi
	0x0021958c, // n0x0b57 c0x0000 (---------------)  + I nishiawakura
	0x002611c7, // n0x0b58 c0x0000 (---------------)  + I okayama
	0x002618c7, // n0x0b59 c0x0000 (---------------)  + I satosho
	0x0023e188, // n0x0b5a c0x0000 (---------------)  + I setouchi
	0x002c91c6, // n0x0b5b c0x0000 (---------------)  + I shinjo
	0x002e81c4, // n0x0b5c c0x0000 (---------------)  + I shoo
	0x0029f684, // n0x0b5d c0x0000 (---------------)  + I soja
	0x002ac8c9, // n0x0b5e c0x0000 (---------------)  + I takahashi
	0x002abb06, // n0x0b5f c0x0000 (---------------)  + I tamano
	0x0027e207, // n0x0b60 c0x0000 (---------------)  + I tsuyama
	0x00292644, // n0x0b61 c0x0000 (---------------)  + I wake
	0x002758c6, // n0x0b62 c0x0000 (---------------)  + I yakage
	0x00207ec5, // n0x0b63 c0x0000 (---------------)  + I aguni
	0x00287047, // n0x0b64 c0x0000 (---------------)  + I ginowan
	0x00217c06, // n0x0b65 c0x0000 (---------------)  + I ginoza
	0x00253ac9, // n0x0b66 c0x0000 (---------------)  + I gushikami
	0x003108c7, // n0x0b67 c0x0000 (---------------)  + I haebaru
	0x00278307, // n0x0b68 c0x0000 (---------------)  + I higashi
	0x00285fc6, // n0x0b69 c0x0000 (---------------)  + I hirara
	0x002eb005, // n0x0b6a c0x0000 (---------------)  + I iheya
	0x00265288, // n0x0b6b c0x0000 (---------------)  + I ishigaki
	0x002a2c88, // n0x0b6c c0x0000 (---------------)  + I ishikawa
	0x0020ac46, // n0x0b6d c0x0000 (---------------)  + I itoman
	0x002b51c5, // n0x0b6e c0x0000 (---------------)  + I izena
	0x00344506, // n0x0b6f c0x0000 (---------------)  + I kadena
	0x00207883, // n0x0b70 c0x0000 (---------------)  + I kin
	0x0027e509, // n0x0b71 c0x0000 (---------------)  + I kitadaito
	0x0028208e, // n0x0b72 c0x0000 (---------------)  + I kitanakagusuku
	0x0029bb48, // n0x0b73 c0x0000 (---------------)  + I kumejima
	0x00336408, // n0x0b74 c0x0000 (---------------)  + I kunigami
	0x0020aa4b, // n0x0b75 c0x0000 (---------------)  + I minamidaito
	0x002773c6, // n0x0b76 c0x0000 (---------------)  + I motobu
	0x00205344, // n0x0b77 c0x0000 (---------------)  + I nago
	0x00267c84, // n0x0b78 c0x0000 (---------------)  + I naha
	0x0028218a, // n0x0b79 c0x0000 (---------------)  + I nakagusuku
	0x00212b87, // n0x0b7a c0x0000 (---------------)  + I nakijin
	0x0026cb85, // n0x0b7b c0x0000 (---------------)  + I nanjo
	0x00234649, // n0x0b7c c0x0000 (---------------)  + I nishihara
	0x0029f045, // n0x0b7d c0x0000 (---------------)  + I ogimi
	0x0030f2c7, // n0x0b7e c0x0000 (---------------)  + I okinawa
	0x002121c4, // n0x0b7f c0x0000 (---------------)  + I onna
	0x00301907, // n0x0b80 c0x0000 (---------------)  + I shimoji
	0x002f1b08, // n0x0b81 c0x0000 (---------------)  + I taketomi
	0x002d0fc6, // n0x0b82 c0x0000 (---------------)  + I tarama
	0x002aa2c9, // n0x0b83 c0x0000 (---------------)  + I tokashiki
	0x0029d28a, // n0x0b84 c0x0000 (---------------)  + I tomigusuku
	0x00212b06, // n0x0b85 c0x0000 (---------------)  + I tonaki
	0x0027b706, // n0x0b86 c0x0000 (---------------)  + I urasoe
	0x0028d145, // n0x0b87 c0x0000 (---------------)  + I uruma
	0x0032c445, // n0x0b88 c0x0000 (---------------)  + I yaese
	0x0031a707, // n0x0b89 c0x0000 (---------------)  + I yomitan
	0x00350648, // n0x0b8a c0x0000 (---------------)  + I yonabaru
	0x00207e08, // n0x0b8b c0x0000 (---------------)  + I yonaguni
	0x00227986, // n0x0b8c c0x0000 (---------------)  + I zamami
	0x002ffbc5, // n0x0b8d c0x0000 (---------------)  + I abeno
	0x002b4cce, // n0x0b8e c0x0000 (---------------)  + I chihayaakasaka
	0x002f8704, // n0x0b8f c0x0000 (---------------)  + I chuo
	0x0020abc5, // n0x0b90 c0x0000 (---------------)  + I daito
	0x00260409, // n0x0b91 c0x0000 (---------------)  + I fujiidera
	0x00265708, // n0x0b92 c0x0000 (---------------)  + I habikino
	0x00270786, // n0x0b93 c0x0000 (---------------)  + I hannan
	0x002809cc, // n0x0b94 c0x0000 (---------------)  + I higashiosaka
	0x00281990, // n0x0b95 c0x0000 (---------------)  + I higashisumiyoshi
	0x00283acf, // n0x0b96 c0x0000 (---------------)  + I higashiyodogawa
	0x00285048, // n0x0b97 c0x0000 (---------------)  + I hirakata
	0x00329287, // n0x0b98 c0x0000 (---------------)  + I ibaraki
	0x00205505, // n0x0b99 c0x0000 (---------------)  + I ikeda
	0x00275ec5, // n0x0b9a c0x0000 (---------------)  + I izumi
	0x002b7449, // n0x0b9b c0x0000 (---------------)  + I izumiotsu
	0x00275ec9, // n0x0b9c c0x0000 (---------------)  + I izumisano
	0x0021ca86, // n0x0b9d c0x0000 (---------------)  + I kadoma
	0x002e43c7, // n0x0b9e c0x0000 (---------------)  + I kaizuka
	0x002a2f05, // n0x0b9f c0x0000 (---------------)  + I kanan
	0x00215d09, // n0x0ba0 c0x0000 (---------------)  + I kashiwara
	0x0032d506, // n0x0ba1 c0x0000 (---------------)  + I katano
	0x0030ee8d, // n0x0ba2 c0x0000 (---------------)  + I kawachinagano
	0x0026b789, // n0x0ba3 c0x0000 (---------------)  + I kishiwada
	0x0023a944, // n0x0ba4 c0x0000 (---------------)  + I kita
	0x0029b8c8, // n0x0ba5 c0x0000 (---------------)  + I kumatori
	0x0030ec49, // n0x0ba6 c0x0000 (---------------)  + I matsubara
	0x00306486, // n0x0ba7 c0x0000 (---------------)  + I minato
	0x00260b85, // n0x0ba8 c0x0000 (---------------)  + I minoh
	0x002aaf86, // n0x0ba9 c0x0000 (---------------)  + I misaki
	0x002f95c9, // n0x0baa c0x0000 (---------------)  + I moriguchi
	0x002ac2c8, // n0x0bab c0x0000 (---------------)  + I neyagawa
	0x00201005, // n0x0bac c0x0000 (---------------)  + I nishi
	0x0020e844, // n0x0bad c0x0000 (---------------)  + I nose
	0x00280b8b, // n0x0bae c0x0000 (---------------)  + I osakasayama
	0x00306345, // n0x0baf c0x0000 (---------------)  + I sakai
	0x00272486, // n0x0bb0 c0x0000 (---------------)  + I sayama
	0x0024f986, // n0x0bb1 c0x0000 (---------------)  + I sennan
	0x002e0406, // n0x0bb2 c0x0000 (---------------)  + I settsu
	0x00324dcb, // n0x0bb3 c0x0000 (---------------)  + I shijonawate
	0x00277289, // n0x0bb4 c0x0000 (---------------)  + I shimamoto
	0x002923c5, // n0x0bb5 c0x0000 (---------------)  + I suita
	0x00249647, // n0x0bb6 c0x0000 (---------------)  + I tadaoka
	0x00200546, // n0x0bb7 c0x0000 (---------------)  + I taishi
	0x00267146, // n0x0bb8 c0x0000 (---------------)  + I tajiri
	0x003296c8, // n0x0bb9 c0x0000 (---------------)  + I takaishi
	0x00267609, // n0x0bba c0x0000 (---------------)  + I takatsuki
	0x002afd8c, // n0x0bbb c0x0000 (---------------)  + I tondabayashi
	0x00252ec8, // n0x0bbc c0x0000 (---------------)  + I toyonaka
	0x0025c5c6, // n0x0bbd c0x0000 (---------------)  + I toyono
	0x002e8903, // n0x0bbe c0x0000 (---------------)  + I yao
	0x002343c6, // n0x0bbf c0x0000 (---------------)  + I ariake
	0x0028d805, // n0x0bc0 c0x0000 (---------------)  + I arita
	0x00263a48, // n0x0bc1 c0x0000 (---------------)  + I fukudomi
	0x00221506, // n0x0bc2 c0x0000 (---------------)  + I genkai
	0x00313e88, // n0x0bc3 c0x0000 (---------------)  + I hamatama
	0x00307885, // n0x0bc4 c0x0000 (---------------)  + I hizen
	0x00325705, // n0x0bc5 c0x0000 (---------------)  + I imari
	0x002e4708, // n0x0bc6 c0x0000 (---------------)  + I kamimine
	0x00294887, // n0x0bc7 c0x0000 (---------------)  + I kanzaki
	0x002a7507, // n0x0bc8 c0x0000 (---------------)  + I karatsu
	0x0029b507, // n0x0bc9 c0x0000 (---------------)  + I kashima
	0x0023a948, // n0x0bca c0x0000 (---------------)  + I kitagata
	0x003293c8, // n0x0bcb c0x0000 (---------------)  + I kitahata
	0x00271906, // n0x0bcc c0x0000 (---------------)  + I kiyama
	0x00295c07, // n0x0bcd c0x0000 (---------------)  + I kouhoku
	0x002a60c7, // n0x0bce c0x0000 (---------------)  + I kyuragi
	0x0028d6ca, // n0x0bcf c0x0000 (---------------)  + I nishiarita
	0x00238783, // n0x0bd0 c0x0000 (---------------)  + I ogi
	0x00230586, // n0x0bd1 c0x0000 (---------------)  + I omachi
	0x0023e245, // n0x0bd2 c0x0000 (---------------)  + I ouchi
	0x00259b04, // n0x0bd3 c0x0000 (---------------)  + I saga
	0x00262209, // n0x0bd4 c0x0000 (---------------)  + I shiroishi
	0x00335f44, // n0x0bd5 c0x0000 (---------------)  + I taku
	0x0021eb44, // n0x0bd6 c0x0000 (---------------)  + I tara
	0x0027bec4, // n0x0bd7 c0x0000 (---------------)  + I tosu
	0x0028404b, // n0x0bd8 c0x0000 (---------------)  + I yoshinogari
	0x0030edc7, // n0x0bd9 c0x0000 (---------------)  + I arakawa
	0x002b4f05, // n0x0bda c0x0000 (---------------)  + I asaka
	0x002784c8, // n0x0bdb c0x0000 (---------------)  + I chichibu
	0x00260a86, // n0x0bdc c0x0000 (---------------)  + I fujimi
	0x00260a88, // n0x0bdd c0x0000 (---------------)  + I fujimino
	0x00262fc6, // n0x0bde c0x0000 (---------------)  + I fukaya
	0x00270d05, // n0x0bdf c0x0000 (---------------)  + I hanno
	0x00271245, // n0x0be0 c0x0000 (---------------)  + I hanyu
	0x00274b46, // n0x0be1 c0x0000 (---------------)  + I hasuda
	0x00275748, // n0x0be2 c0x0000 (---------------)  + I hatogaya
	0x00275a48, // n0x0be3 c0x0000 (---------------)  + I hatoyama
	0x002623c6, // n0x0be4 c0x0000 (---------------)  + I hidaka
	0x0027830f, // n0x0be5 c0x0000 (---------------)  + I higashichichibu
	0x0027dfd0, // n0x0be6 c0x0000 (---------------)  + I higashimatsuyama
	0x0020edc5, // n0x0be7 c0x0000 (---------------)  + I honjo
	0x00208ac3, // n0x0be8 c0x0000 (---------------)  + I ina
	0x002e3dc5, // n0x0be9 c0x0000 (---------------)  + I iruma
	0x0028f9c8, // n0x0bea c0x0000 (---------------)  + I iwatsuki
	0x00275dc9, // n0x0beb c0x0000 (---------------)  + I kamiizumi
	0x002a8548, // n0x0bec c0x0000 (---------------)  + I kamikawa
	0x002e7f08, // n0x0bed c0x0000 (---------------)  + I kamisato
	0x0021ae88, // n0x0bee c0x0000 (---------------)  + I kasukabe
	0x002b4fc7, // n0x0bef c0x0000 (---------------)  + I kawagoe
	0x00260749, // n0x0bf0 c0x0000 (---------------)  + I kawaguchi
	0x00314088, // n0x0bf1 c0x0000 (---------------)  + I kawajima
	0x0022ef84, // n0x0bf2 c0x0000 (---------------)  + I kazo
	0x0027bd48, // n0x0bf3 c0x0000 (---------------)  + I kitamoto
	0x00285949, // n0x0bf4 c0x0000 (---------------)  + I koshigaya
	0x00296207, // n0x0bf5 c0x0000 (---------------)  + I kounosu
	0x0029d484, // n0x0bf6 c0x0000 (---------------)  + I kuki
	0x002b5a08, // n0x0bf7 c0x0000 (---------------)  + I kumagaya
	0x0028f00a, // n0x0bf8 c0x0000 (---------------)  + I matsubushi
	0x00310a86, // n0x0bf9 c0x0000 (---------------)  + I minano
	0x00279206, // n0x0bfa c0x0000 (---------------)  + I misato
	0x00226649, // n0x0bfb c0x0000 (---------------)  + I miyashiro
	0x00281bc7, // n0x0bfc c0x0000 (---------------)  + I miyoshi
	0x002b0388, // n0x0bfd c0x0000 (---------------)  + I moroyama
	0x0021a288, // n0x0bfe c0x0000 (---------------)  + I nagatoro
	0x00344d48, // n0x0bff c0x0000 (---------------)  + I namegawa
	0x0034abc5, // n0x0c00 c0x0000 (---------------)  + I niiza
	0x00254b05, // n0x0c01 c0x0000 (---------------)  + I ogano
	0x0022b205, // n0x0c02 c0x0000 (---------------)  + I ogawa
	0x00329905, // n0x0c03 c0x0000 (---------------)  + I ogose
	0x00301507, // n0x0c04 c0x0000 (---------------)  + I okegawa
	0x00206dc5, // n0x0c05 c0x0000 (---------------)  + I omiya
	0x002a0905, // n0x0c06 c0x0000 (---------------)  + I otaki
	0x0033f486, // n0x0c07 c0x0000 (---------------)  + I ranzan
	0x002a8487, // n0x0c08 c0x0000 (---------------)  + I ryokami
	0x002a3b07, // n0x0c09 c0x0000 (---------------)  + I saitama
	0x0028f306, // n0x0c0a c0x0000 (---------------)  + I sakado
	0x002b4605, // n0x0c0b c0x0000 (---------------)  + I satte
	0x00272486, // n0x0c0c c0x0000 (---------------)  + I sayama
	0x002aa3c5, // n0x0c0d c0x0000 (---------------)  + I shiki
	0x002cf808, // n0x0c0e c0x0000 (---------------)  + I shiraoka
	0x00313784, // n0x0c0f c0x0000 (---------------)  + I soka
	0x002aa1c6, // n0x0c10 c0x0000 (---------------)  + I sugito
	0x0020d704, // n0x0c11 c0x0000 (---------------)  + I toda
	0x002fb748, // n0x0c12 c0x0000 (---------------)  + I tokigawa
	0x002ca90a, // n0x0c13 c0x0000 (---------------)  + I tokorozawa
	0x003186cc, // n0x0c14 c0x0000 (---------------)  + I tsurugashima
	0x0021c005, // n0x0c15 c0x0000 (---------------)  + I urawa
	0x0022b2c6, // n0x0c16 c0x0000 (---------------)  + I warabi
	0x002aff46, // n0x0c17 c0x0000 (---------------)  + I yashio
	0x00319046, // n0x0c18 c0x0000 (---------------)  + I yokoze
	0x0025c644, // n0x0c19 c0x0000 (---------------)  + I yono
	0x0020d805, // n0x0c1a c0x0000 (---------------)  + I yorii
	0x00262e07, // n0x0c1b c0x0000 (---------------)  + I yoshida
	0x00281c49, // n0x0c1c c0x0000 (---------------)  + I yoshikawa
	0x00287cc7, // n0x0c1d c0x0000 (---------------)  + I yoshimi
	0x00625ec4, // n0x0c1e c0x0001 (---------------)  ! I city
	0x00625ec4, // n0x0c1f c0x0001 (---------------)  ! I city
	0x002ea645, // n0x0c20 c0x0000 (---------------)  + I aisho
	0x002ed784, // n0x0c21 c0x0000 (---------------)  + I gamo
	0x0028038a, // n0x0c22 c0x0000 (---------------)  + I higashiomi
	0x00260906, // n0x0c23 c0x0000 (---------------)  + I hikone
	0x0024d2c4, // n0x0c24 c0x0000 (---------------)  + I koka
	0x002d9945, // n0x0c25 c0x0000 (---------------)  + I konan
	0x00292945, // n0x0c26 c0x0000 (---------------)  + I kosei
	0x002956c4, // n0x0c27 c0x0000 (---------------)  + I koto
	0x00268007, // n0x0c28 c0x0000 (---------------)  + I kusatsu
	0x00255547, // n0x0c29 c0x0000 (---------------)  + I maibara
	0x002af248, // n0x0c2a c0x0000 (---------------)  + I moriyama
	0x00344108, // n0x0c2b c0x0000 (---------------)  + I nagahama
	0x0021dbc9, // n0x0c2c c0x0000 (---------------)  + I nishiazai
	0x00239088, // n0x0c2d c0x0000 (---------------)  + I notogawa
	0x0028054b, // n0x0c2e c0x0000 (---------------)  + I omihachiman
	0x00227284, // n0x0c2f c0x0000 (---------------)  + I otsu
	0x002668c5, // n0x0c30 c0x0000 (---------------)  + I ritto
	0x002a05c5, // n0x0c31 c0x0000 (---------------)  + I ryuoh
	0x0029b489, // n0x0c32 c0x0000 (---------------)  + I takashima
	0x00267609, // n0x0c33 c0x0000 (---------------)  + I takatsuki
	0x002cf008, // n0x0c34 c0x0000 (---------------)  + I torahime
	0x00309248, // n0x0c35 c0x0000 (---------------)  + I toyosato
	0x0025e6c4, // n0x0c36 c0x0000 (---------------)  + I yasu
	0x00217b45, // n0x0c37 c0x0000 (---------------)  + I akagi
	0x0020b5c3, // n0x0c38 c0x0000 (---------------)  + I ama
	0x00227245, // n0x0c39 c0x0000 (---------------)  + I gotsu
	0x00287e86, // n0x0c3a c0x0000 (---------------)  + I hamada
	0x0027a94c, // n0x0c3b c0x0000 (---------------)  + I higashiizumo
	0x00279086, // n0x0c3c c0x0000 (---------------)  + I hikawa
	0x002dba86, // n0x0c3d c0x0000 (---------------)  + I hikimi
	0x00270a05, // n0x0c3e c0x0000 (---------------)  + I izumo
	0x002d5008, // n0x0c3f c0x0000 (---------------)  + I kakinoki
	0x002b1fc6, // n0x0c40 c0x0000 (---------------)  + I masuda
	0x00307086, // n0x0c41 c0x0000 (---------------)  + I matsue
	0x00279206, // n0x0c42 c0x0000 (---------------)  + I misato
	0x002284cc, // n0x0c43 c0x0000 (---------------)  + I nishinoshima
	0x00257f04, // n0x0c44 c0x0000 (---------------)  + I ohda
	0x003097ca, // n0x0c45 c0x0000 (---------------)  + I okinoshima
	0x00270948, // n0x0c46 c0x0000 (---------------)  + I okuizumo
	0x0027a787, // n0x0c47 c0x0000 (---------------)  + I shimane
	0x00342306, // n0x0c48 c0x0000 (---------------)  + I tamayu
	0x0024f4c7, // n0x0c49 c0x0000 (---------------)  + I tsuwano
	0x002c41c5, // n0x0c4a c0x0000 (---------------)  + I unnan
	0x00286586, // n0x0c4b c0x0000 (---------------)  + I yakumo
	0x0030e706, // n0x0c4c c0x0000 (---------------)  + I yasugi
	0x00316047, // n0x0c4d c0x0000 (---------------)  + I yatsuka
	0x0028e6c4, // n0x0c4e c0x0000 (---------------)  + I arai
	0x002d8dc5, // n0x0c4f c0x0000 (---------------)  + I atami
	0x00260404, // n0x0c50 c0x0000 (---------------)  + I fuji
	0x002cda87, // n0x0c51 c0x0000 (---------------)  + I fujieda
	0x00260648, // n0x0c52 c0x0000 (---------------)  + I fujikawa
	0x00260dca, // n0x0c53 c0x0000 (---------------)  + I fujinomiya
	0x00265107, // n0x0c54 c0x0000 (---------------)  + I fukuroi
	0x00225a47, // n0x0c55 c0x0000 (---------------)  + I gotemba
	0x00329207, // n0x0c56 c0x0000 (---------------)  + I haibara
	0x00224809, // n0x0c57 c0x0000 (---------------)  + I hamamatsu
	0x0027a94a, // n0x0c58 c0x0000 (---------------)  + I higashiizu
	0x0020ac43, // n0x0c59 c0x0000 (---------------)  + I ito
	0x0028f585, // n0x0c5a c0x0000 (---------------)  + I iwata
	0x00201183, // n0x0c5b c0x0000 (---------------)  + I izu
	0x002ad389, // n0x0c5c c0x0000 (---------------)  + I izunokuni
	0x00263388, // n0x0c5d c0x0000 (---------------)  + I kakegawa
	0x002d1fc7, // n0x0c5e c0x0000 (---------------)  + I kannami
	0x002a8649, // n0x0c5f c0x0000 (---------------)  + I kawanehon
	0x002a2d86, // n0x0c60 c0x0000 (---------------)  + I kawazu
	0x002007c8, // n0x0c61 c0x0000 (---------------)  + I kikugawa
	0x00290b85, // n0x0c62 c0x0000 (---------------)  + I kosai
	0x0026cdca, // n0x0c63 c0x0000 (---------------)  + I makinohara
	0x002af3c9, // n0x0c64 c0x0000 (---------------)  + I matsuzaki
	0x0023cdc9, // n0x0c65 c0x0000 (---------------)  + I minamiizu
	0x002d6fc7, // n0x0c66 c0x0000 (---------------)  + I mishima
	0x00276ec9, // n0x0c67 c0x0000 (---------------)  + I morimachi
	0x0025db48, // n0x0c68 c0x0000 (---------------)  + I nishiizu
	0x002e5706, // n0x0c69 c0x0000 (---------------)  + I numazu
	0x0022b488, // n0x0c6a c0x0000 (---------------)  + I omaezaki
	0x0022fd87, // n0x0c6b c0x0000 (---------------)  + I shimada
	0x0022a207, // n0x0c6c c0x0000 (---------------)  + I shimizu
	0x002508c7, // n0x0c6d c0x0000 (---------------)  + I shimoda
	0x002d1e48, // n0x0c6e c0x0000 (---------------)  + I shizuoka
	0x002ce2c6, // n0x0c6f c0x0000 (---------------)  + I susono
	0x0028edc5, // n0x0c70 c0x0000 (---------------)  + I yaizu
	0x00262e07, // n0x0c71 c0x0000 (---------------)  + I yoshida
	0x0027b208, // n0x0c72 c0x0000 (---------------)  + I ashikaga
	0x0032df44, // n0x0c73 c0x0000 (---------------)  + I bato
	0x00312b04, // n0x0c74 c0x0000 (---------------)  + I haga
	0x002d6307, // n0x0c75 c0x0000 (---------------)  + I ichikai
	0x0030cb07, // n0x0c76 c0x0000 (---------------)  + I iwafune
	0x00200d8a, // n0x0c77 c0x0000 (---------------)  + I kaminokawa
	0x002e5686, // n0x0c78 c0x0000 (---------------)  + I kanuma
	0x0031130a, // n0x0c79 c0x0000 (---------------)  + I karasuyama
	0x0029f547, // n0x0c7a c0x0000 (---------------)  + I kuroiso
	0x002f84c7, // n0x0c7b c0x0000 (---------------)  + I mashiko
	0x00299804, // n0x0c7c c0x0000 (---------------)  + I mibu
	0x00321404, // n0x0c7d c0x0000 (---------------)  + I moka
	0x0021fa06, // n0x0c7e c0x0000 (---------------)  + I motegi
	0x002f7a44, // n0x0c7f c0x0000 (---------------)  + I nasu
	0x002f7a4c, // n0x0c80 c0x0000 (---------------)  + I nasushiobara
	0x00213a05, // n0x0c81 c0x0000 (---------------)  + I nikko
	0x0027ca49, // n0x0c82 c0x0000 (---------------)  + I nishikata
	0x0030fa44, // n0x0c83 c0x0000 (---------------)  + I nogi
	0x00295785, // n0x0c84 c0x0000 (---------------)  + I ohira
	0x0020a588, // n0x0c85 c0x0000 (---------------)  + I ohtawara
	0x0020b545, // n0x0c86 c0x0000 (---------------)  + I oyama
	0x002a2746, // n0x0c87 c0x0000 (---------------)  + I sakura
	0x00276004, // n0x0c88 c0x0000 (---------------)  + I sano
	0x002c86ca, // n0x0c89 c0x0000 (---------------)  + I shimotsuke
	0x002cdc46, // n0x0c8a c0x0000 (---------------)  + I shioya
	0x0028170a, // n0x0c8b c0x0000 (---------------)  + I takanezawa
	0x0032dfc7, // n0x0c8c c0x0000 (---------------)  + I tochigi
	0x00294645, // n0x0c8d c0x0000 (---------------)  + I tsuga
	0x00218485, // n0x0c8e c0x0000 (---------------)  + I ujiie
	0x0026a78a, // n0x0c8f c0x0000 (---------------)  + I utsunomiya
	0x0025efc5, // n0x0c90 c0x0000 (---------------)  + I yaita
	0x00284786, // n0x0c91 c0x0000 (---------------)  + I aizumi
	0x002a2f44, // n0x0c92 c0x0000 (---------------)  + I anan
	0x0029c146, // n0x0c93 c0x0000 (---------------)  + I ichiba
	0x0031a7c5, // n0x0c94 c0x0000 (---------------)  + I itano
	0x002215c6, // n0x0c95 c0x0000 (---------------)  + I kainan
	0x002b1d4c, // n0x0c96 c0x0000 (---------------)  + I komatsushima
	0x0029b64a, // n0x0c97 c0x0000 (---------------)  + I matsushige
	0x0023f744, // n0x0c98 c0x0000 (---------------)  + I mima
	0x0020aa46, // n0x0c99 c0x0000 (---------------)  + I minami
	0x00281bc7, // n0x0c9a c0x0000 (---------------)  + I miyoshi
	0x002b2344, // n0x0c9b c0x0000 (---------------)  + I mugi
	0x002a1cc8, // n0x0c9c c0x0000 (---------------)  + I nakagawa
	0x002fb646, // n0x0c9d c0x0000 (---------------)  + I naruto
	0x002b4b49, // n0x0c9e c0x0000 (---------------)  + I sanagochi
	0x002d0389, // n0x0c9f c0x0000 (---------------)  + I shishikui
	0x002ccac9, // n0x0ca0 c0x0000 (---------------)  + I tokushima
	0x0022a606, // n0x0ca1 c0x0000 (---------------)  + I wajiki
	0x0022fe86, // n0x0ca2 c0x0000 (---------------)  + I adachi
	0x0022b5c7, // n0x0ca3 c0x0000 (---------------)  + I akiruno
	0x002fa6c8, // n0x0ca4 c0x0000 (---------------)  + I akishima
	0x0022fc89, // n0x0ca5 c0x0000 (---------------)  + I aogashima
	0x0030edc7, // n0x0ca6 c0x0000 (---------------)  + I arakawa
	0x00233f86, // n0x0ca7 c0x0000 (---------------)  + I bunkyo
	0x00202907, // n0x0ca8 c0x0000 (---------------)  + I chiyoda
	0x00304245, // n0x0ca9 c0x0000 (---------------)  + I chofu
	0x002f8704, // n0x0caa c0x0000 (---------------)  + I chuo
	0x0022b187, // n0x0cab c0x0000 (---------------)  + I edogawa
	0x0032e185, // n0x0cac c0x0000 (---------------)  + I fuchu
	0x0026b605, // n0x0cad c0x0000 (---------------)  + I fussa
	0x00247947, // n0x0cae c0x0000 (---------------)  + I hachijo
	0x0028ebc8, // n0x0caf c0x0000 (---------------)  + I hachioji
	0x0026f686, // n0x0cb0 c0x0000 (---------------)  + I hamura
	0x0027d18d, // n0x0cb1 c0x0000 (---------------)  + I higashikurume
	0x0027e88f, // n0x0cb2 c0x0000 (---------------)  + I higashimurayama
	0x0028330d, // n0x0cb3 c0x0000 (---------------)  + I higashiyamato
	0x00200644, // n0x0cb4 c0x0000 (---------------)  + I hino
	0x002357c6, // n0x0cb5 c0x0000 (---------------)  + I hinode
	0x002b8ac8, // n0x0cb6 c0x0000 (---------------)  + I hinohara
	0x002ebcc5, // n0x0cb7 c0x0000 (---------------)  + I inagi
	0x0028d888, // n0x0cb8 c0x0000 (---------------)  + I itabashi
	0x002d280a, // n0x0cb9 c0x0000 (---------------)  + I katsushika
	0x0023a944, // n0x0cba c0x0000 (---------------)  + I kita
	0x00311646, // n0x0cbb c0x0000 (---------------)  + I kiyose
	0x002b2a47, // n0x0cbc c0x0000 (---------------)  + I kodaira
	0x002f2307, // n0x0cbd c0x0000 (---------------)  + I koganei
	0x0021fc49, // n0x0cbe c0x0000 (---------------)  + I kokubunji
	0x0022b445, // n0x0cbf c0x0000 (---------------)  + I komae
	0x002956c4, // n0x0cc0 c0x0000 (---------------)  + I koto
	0x002970ca, // n0x0cc1 c0x0000 (---------------)  + I kouzushima
	0x0029cbc9, // n0x0cc2 c0x0000 (---------------)  + I kunitachi
	0x00276fc7, // n0x0cc3 c0x0000 (---------------)  + I machida
	0x002d1cc6, // n0x0cc4 c0x0000 (---------------)  + I meguro
	0x00306486, // n0x0cc5 c0x0000 (---------------)  + I minato
	0x00217a86, // n0x0cc6 c0x0000 (---------------)  + I mitaka
	0x00239606, // n0x0cc7 c0x0000 (---------------)  + I mizuho
	0x002b85cf, // n0x0cc8 c0x0000 (---------------)  + I musashimurayama
	0x002b8989, // n0x0cc9 c0x0000 (---------------)  + I musashino
	0x0020ff86, // n0x0cca c0x0000 (---------------)  + I nakano
	0x00325646, // n0x0ccb c0x0000 (---------------)  + I nerima
	0x002fb0c9, // n0x0ccc c0x0000 (---------------)  + I ogasawara
	0x00295d07, // n0x0ccd c0x0000 (---------------)  + I okutama
	0x00211243, // n0x0cce c0x0000 (---------------)  + I ome
	0x00228646, // n0x0ccf c0x0000 (---------------)  + I oshima
	0x00213103, // n0x0cd0 c0x0000 (---------------)  + I ota
	0x003512c8, // n0x0cd1 c0x0000 (---------------)  + I setagaya
	0x00294dc7, // n0x0cd2 c0x0000 (---------------)  + I shibuya
	0x00285249, // n0x0cd3 c0x0000 (---------------)  + I shinagawa
	0x002ca0c8, // n0x0cd4 c0x0000 (---------------)  + I shinjuku
	0x002a7648, // n0x0cd5 c0x0000 (---------------)  + I suginami
	0x0027bf46, // n0x0cd6 c0x0000 (---------------)  + I sumida
	0x00292489, // n0x0cd7 c0x0000 (---------------)  + I tachikawa
	0x00238685, // n0x0cd8 c0x0000 (---------------)  + I taito
	0x00295dc4, // n0x0cd9 c0x0000 (---------------)  + I tama
	0x002b9f07, // n0x0cda c0x0000 (---------------)  + I toshima
	0x00251f45, // n0x0cdb c0x0000 (---------------)  + I chizu
	0x00200644, // n0x0cdc c0x0000 (---------------)  + I hino
	0x0026b248, // n0x0cdd c0x0000 (---------------)  + I kawahara
	0x00205e44, // n0x0cde c0x0000 (---------------)  + I koge
	0x00295a47, // n0x0cdf c0x0000 (---------------)  + I kotoura
	0x002ba546, // n0x0ce0 c0x0000 (---------------)  + I misasa
	0x0024fa45, // n0x0ce1 c0x0000 (---------------)  + I nanbu
	0x002c8fc8, // n0x0ce2 c0x0000 (---------------)  + I nichinan
	0x0030634b, // n0x0ce3 c0x0000 (---------------)  + I sakaiminato
	0x0031ddc7, // n0x0ce4 c0x0000 (---------------)  + I tottori
	0x0026aa06, // n0x0ce5 c0x0000 (---------------)  + I wakasa
	0x002ab904, // n0x0ce6 c0x0000 (---------------)  + I yazu
	0x002052c6, // n0x0ce7 c0x0000 (---------------)  + I yonago
	0x002a5e85, // n0x0ce8 c0x0000 (---------------)  + I asahi
	0x0032e185, // n0x0ce9 c0x0000 (---------------)  + I fuchu
	0x00264909, // n0x0cea c0x0000 (---------------)  + I fukumitsu
	0x00267c09, // n0x0ceb c0x0000 (---------------)  + I funahashi
	0x0022a244, // n0x0cec c0x0000 (---------------)  + I himi
	0x0022a285, // n0x0ced c0x0000 (---------------)  + I imizu
	0x0020aa85, // n0x0cee c0x0000 (---------------)  + I inami
	0x0026cc46, // n0x0cef c0x0000 (---------------)  + I johana
	0x002d6208, // n0x0cf0 c0x0000 (---------------)  + I kamiichi
	0x0029e686, // n0x0cf1 c0x0000 (---------------)  + I kurobe
	0x0028250b, // n0x0cf2 c0x0000 (---------------)  + I nakaniikawa
	0x00318b4a, // n0x0cf3 c0x0000 (---------------)  + I namerikawa
	0x002940c5, // n0x0cf4 c0x0000 (---------------)  + I nanto
	0x002712c6, // n0x0cf5 c0x0000 (---------------)  + I nyuzen
	0x002ffb45, // n0x0cf6 c0x0000 (---------------)  + I oyabe
	0x00204f45, // n0x0cf7 c0x0000 (---------------)  + I taira
	0x002c9407, // n0x0cf8 c0x0000 (---------------)  + I takaoka
	0x00231e48, // n0x0cf9 c0x0000 (---------------)  + I tateyama
	0x00239104, // n0x0cfa c0x0000 (---------------)  + I toga
	0x00299706, // n0x0cfb c0x0000 (---------------)  + I tonami
	0x00218dc6, // n0x0cfc c0x0000 (---------------)  + I toyama
	0x0025dd07, // n0x0cfd c0x0000 (---------------)  + I unazuki
	0x002fc904, // n0x0cfe c0x0000 (---------------)  + I uozu
	0x002638c6, // n0x0cff c0x0000 (---------------)  + I yamada
	0x0021b8c5, // n0x0d00 c0x0000 (---------------)  + I arida
	0x0021b8c9, // n0x0d01 c0x0000 (---------------)  + I aridagawa
	0x00230084, // n0x0d02 c0x0000 (---------------)  + I gobo
	0x002ca749, // n0x0d03 c0x0000 (---------------)  + I hashimoto
	0x002623c6, // n0x0d04 c0x0000 (---------------)  + I hidaka
	0x002a1508, // n0x0d05 c0x0000 (---------------)  + I hirogawa
	0x0020aa85, // n0x0d06 c0x0000 (---------------)  + I inami
	0x0023e3c5, // n0x0d07 c0x0000 (---------------)  + I iwade
	0x002215c6, // n0x0d08 c0x0000 (---------------)  + I kainan
	0x002afc89, // n0x0d09 c0x0000 (---------------)  + I kamitonda
	0x0028a1c9, // n0x0d0a c0x0000 (---------------)  + I katsuragi
	0x002dbb06, // n0x0d0b c0x0000 (---------------)  + I kimino
	0x00265808, // n0x0d0c c0x0000 (---------------)  + I kinokawa
	0x0024d588, // n0x0d0d c0x0000 (---------------)  + I kitayama
	0x002ffb04, // n0x0d0e c0x0000 (---------------)  + I koya
	0x00297bc4, // n0x0d0f c0x0000 (---------------)  + I koza
	0x00297bc8, // n0x0d10 c0x0000 (---------------)  + I kozagawa
	0x002f2f88, // n0x0d11 c0x0000 (---------------)  + I kudoyama
	0x002c1b89, // n0x0d12 c0x0000 (---------------)  + I kushimoto
	0x00287e06, // n0x0d13 c0x0000 (---------------)  + I mihama
	0x00279206, // n0x0d14 c0x0000 (---------------)  + I misato
	0x002efecd, // n0x0d15 c0x0000 (---------------)  + I nachikatsuura
	0x002c8bc6, // n0x0d16 c0x0000 (---------------)  + I shingu
	0x002cdf09, // n0x0d17 c0x0000 (---------------)  + I shirahama
	0x002deac5, // n0x0d18 c0x0000 (---------------)  + I taiji
	0x0031ca06, // n0x0d19 c0x0000 (---------------)  + I tanabe
	0x00291608, // n0x0d1a c0x0000 (---------------)  + I wakayama
	0x002ee205, // n0x0d1b c0x0000 (---------------)  + I yuasa
	0x002a6104, // n0x0d1c c0x0000 (---------------)  + I yura
	0x002a5e85, // n0x0d1d c0x0000 (---------------)  + I asahi
	0x00266fc8, // n0x0d1e c0x0000 (---------------)  + I funagata
	0x00280149, // n0x0d1f c0x0000 (---------------)  + I higashine
	0x002604c4, // n0x0d20 c0x0000 (---------------)  + I iide
	0x002a9786, // n0x0d21 c0x0000 (---------------)  + I kahoku
	0x0020b40a, // n0x0d22 c0x0000 (---------------)  + I kaminoyama
	0x002cd488, // n0x0d23 c0x0000 (---------------)  + I kaneyama
	0x00200f09, // n0x0d24 c0x0000 (---------------)  + I kawanishi
	0x0033e44a, // n0x0d25 c0x0000 (---------------)  + I mamurogawa
	0x002a85c6, // n0x0d26 c0x0000 (---------------)  + I mikawa
	0x0027ea48, // n0x0d27 c0x0000 (---------------)  + I murayama
	0x00344605, // n0x0d28 c0x0000 (---------------)  + I nagai
	0x002d4688, // n0x0d29 c0x0000 (---------------)  + I nakayama
	0x0029bf85, // n0x0d2a c0x0000 (---------------)  + I nanyo
	0x002a2c49, // n0x0d2b c0x0000 (---------------)  + I nishikawa
	0x002f87c9, // n0x0d2c c0x0000 (---------------)  + I obanazawa
	0x002071c2, // n0x0d2d c0x0000 (---------------)  + I oe
	0x00247f45, // n0x0d2e c0x0000 (---------------)  + I oguni
	0x00260c46, // n0x0d2f c0x0000 (---------------)  + I ohkura
	0x00262307, // n0x0d30 c0x0000 (---------------)  + I oishida
	0x00259b05, // n0x0d31 c0x0000 (---------------)  + I sagae
	0x00267506, // n0x0d32 c0x0000 (---------------)  + I sakata
	0x002ee2c8, // n0x0d33 c0x0000 (---------------)  + I sakegawa
	0x002c91c6, // n0x0d34 c0x0000 (---------------)  + I shinjo
	0x002cfd49, // n0x0d35 c0x0000 (---------------)  + I shirataka
	0x002619c6, // n0x0d36 c0x0000 (---------------)  + I shonai
	0x00329548, // n0x0d37 c0x0000 (---------------)  + I takahata
	0x0028b585, // n0x0d38 c0x0000 (---------------)  + I tendo
	0x0028c546, // n0x0d39 c0x0000 (---------------)  + I tozawa
	0x00207248, // n0x0d3a c0x0000 (---------------)  + I tsuruoka
	0x00266548, // n0x0d3b c0x0000 (---------------)  + I yamagata
	0x0020b808, // n0x0d3c c0x0000 (---------------)  + I yamanobe
	0x00258648, // n0x0d3d c0x0000 (---------------)  + I yonezawa
	0x002237c4, // n0x0d3e c0x0000 (---------------)  + I yuza
	0x00223903, // n0x0d3f c0x0000 (---------------)  + I abu
	0x002cff84, // n0x0d40 c0x0000 (---------------)  + I hagi
	0x002cc386, // n0x0d41 c0x0000 (---------------)  + I hikari
	0x00304284, // n0x0d42 c0x0000 (---------------)  + I hofu
	0x00336347, // n0x0d43 c0x0000 (---------------)  + I iwakuni
	0x00306f89, // n0x0d44 c0x0000 (---------------)  + I kudamatsu
	0x002aad85, // n0x0d45 c0x0000 (---------------)  + I mitou
	0x0021a286, // n0x0d46 c0x0000 (---------------)  + I nagato
	0x00228646, // n0x0d47 c0x0000 (---------------)  + I oshima
	0x002c7c0b, // n0x0d48 c0x0000 (---------------)  + I shimonoseki
	0x00294006, // n0x0d49 c0x0000 (---------------)  + I shunan
	0x002f3286, // n0x0d4a c0x0000 (---------------)  + I tabuse
	0x002f1d88, // n0x0d4b c0x0000 (---------------)  + I tokuyama
	0x0026fc46, // n0x0d4c c0x0000 (---------------)  + I toyota
	0x00248dc3, // n0x0d4d c0x0000 (---------------)  + I ube
	0x00223583, // n0x0d4e c0x0000 (---------------)  + I yuu
	0x002f8704, // n0x0d4f c0x0000 (---------------)  + I chuo
	0x00294d45, // n0x0d50 c0x0000 (---------------)  + I doshi
	0x00265547, // n0x0d51 c0x0000 (---------------)  + I fuefuki
	0x00260648, // n0x0d52 c0x0000 (---------------)  + I fujikawa
	0x0026064f, // n0x0d53 c0x0000 (---------------)  + I fujikawaguchiko
	0x00262d0b, // n0x0d54 c0x0000 (---------------)  + I fujiyoshida
	0x002d6008, // n0x0d55 c0x0000 (---------------)  + I hayakawa
	0x002a9806, // n0x0d56 c0x0000 (---------------)  + I hokuto
	0x0027900e, // n0x0d57 c0x0000 (---------------)  + I ichikawamisato
	0x002215c3, // n0x0d58 c0x0000 (---------------)  + I kai
	0x002fce44, // n0x0d59 c0x0000 (---------------)  + I kofu
	0x00293f85, // n0x0d5a c0x0000 (---------------)  + I koshu
	0x00295546, // n0x0d5b c0x0000 (---------------)  + I kosuge
	0x0027384b, // n0x0d5c c0x0000 (---------------)  + I minami-alps
	0x00277746, // n0x0d5d c0x0000 (---------------)  + I minobu
	0x00229c09, // n0x0d5e c0x0000 (---------------)  + I nakamichi
	0x0024fa45, // n0x0d5f c0x0000 (---------------)  + I nanbu
	0x0034de48, // n0x0d60 c0x0000 (---------------)  + I narusawa
	0x00217f08, // n0x0d61 c0x0000 (---------------)  + I nirasaki
	0x0028a08c, // n0x0d62 c0x0000 (---------------)  + I nishikatsura
	0x00284086, // n0x0d63 c0x0000 (---------------)  + I oshino
	0x00227286, // n0x0d64 c0x0000 (---------------)  + I otsuki
	0x002d3145, // n0x0d65 c0x0000 (---------------)  + I showa
	0x0026ba48, // n0x0d66 c0x0000 (---------------)  + I tabayama
	0x00207245, // n0x0d67 c0x0000 (---------------)  + I tsuru
	0x00243608, // n0x0d68 c0x0000 (---------------)  + I uenohara
	0x0028374a, // n0x0d69 c0x0000 (---------------)  + I yamanakako
	0x00330b49, // n0x0d6a c0x0000 (---------------)  + I yamanashi
	0x00625ec4, // n0x0d6b c0x0001 (---------------)  ! I city
	0x002104c3, // n0x0d6c c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0d6d c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0d6e c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0d6f c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0d70 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0d71 c0x0000 (---------------)  + I org
	0x002b5183, // n0x0d72 c0x0000 (---------------)  + I biz
	0x002104c3, // n0x0d73 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0d74 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0d75 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x0d76 c0x0000 (---------------)  + I info
	0x00239bc3, // n0x0d77 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0d78 c0x0000 (---------------)  + I org
	0x00202f43, // n0x0d79 c0x0000 (---------------)  + I ass
	0x00202f44, // n0x0d7a c0x0000 (---------------)  + I asso
	0x002104c3, // n0x0d7b c0x0000 (---------------)  + I com
	0x00236044, // n0x0d7c c0x0000 (---------------)  + I coop
	0x002ceec3, // n0x0d7d c0x0000 (---------------)  + I edu
	0x0022fa44, // n0x0d7e c0x0000 (---------------)  + I gouv
	0x002150c3, // n0x0d7f c0x0000 (---------------)  + I gov
	0x002910c7, // n0x0d80 c0x0000 (---------------)  + I medecin
	0x0025f683, // n0x0d81 c0x0000 (---------------)  + I mil
	0x002006c3, // n0x0d82 c0x0000 (---------------)  + I nom
	0x00253e08, // n0x0d83 c0x0000 (---------------)  + I notaires
	0x002453c3, // n0x0d84 c0x0000 (---------------)  + I org
	0x002bb40b, // n0x0d85 c0x0000 (---------------)  + I pharmaciens
	0x00259843, // n0x0d86 c0x0000 (---------------)  + I prd
	0x0020e2c6, // n0x0d87 c0x0000 (---------------)  + I presse
	0x0023d502, // n0x0d88 c0x0000 (---------------)  + I tm
	0x002c670b, // n0x0d89 c0x0000 (---------------)  + I veterinaire
	0x002ceec3, // n0x0d8a c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0d8b c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0d8c c0x0000 (---------------)  + I net
	0x002453c3, // n0x0d8d c0x0000 (---------------)  + I org
	0x002104c3, // n0x0d8e c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0d8f c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0d90 c0x0000 (---------------)  + I gov
	0x002453c3, // n0x0d91 c0x0000 (---------------)  + I org
	0x0023ba83, // n0x0d92 c0x0000 (---------------)  + I rep
	0x00209943, // n0x0d93 c0x0000 (---------------)  + I tra
	0x002028c2, // n0x0d94 c0x0000 (---------------)  + I ac
	0x00031c88, // n0x0d95 c0x0000 (---------------)  +   blogspot
	0x0022f305, // n0x0d96 c0x0000 (---------------)  + I busan
	0x0031f988, // n0x0d97 c0x0000 (---------------)  + I chungbuk
	0x00324488, // n0x0d98 c0x0000 (---------------)  + I chungnam
	0x00208f82, // n0x0d99 c0x0000 (---------------)  + I co
	0x002ed2c5, // n0x0d9a c0x0000 (---------------)  + I daegu
	0x00224a47, // n0x0d9b c0x0000 (---------------)  + I daejeon
	0x002016c2, // n0x0d9c c0x0000 (---------------)  + I es
	0x00229e47, // n0x0d9d c0x0000 (---------------)  + I gangwon
	0x002053c2, // n0x0d9e c0x0000 (---------------)  + I go
	0x0025b8c7, // n0x0d9f c0x0000 (---------------)  + I gwangju
	0x002f3649, // n0x0da0 c0x0000 (---------------)  + I gyeongbuk
	0x00343cc8, // n0x0da1 c0x0000 (---------------)  + I gyeonggi
	0x00344bc9, // n0x0da2 c0x0000 (---------------)  + I gyeongnam
	0x00211c42, // n0x0da3 c0x0000 (---------------)  + I hs
	0x0024e907, // n0x0da4 c0x0000 (---------------)  + I incheon
	0x0031bb04, // n0x0da5 c0x0000 (---------------)  + I jeju
	0x00224b07, // n0x0da6 c0x0000 (---------------)  + I jeonbuk
	0x00318a47, // n0x0da7 c0x0000 (---------------)  + I jeonnam
	0x00243242, // n0x0da8 c0x0000 (---------------)  + I kg
	0x0025f683, // n0x0da9 c0x0000 (---------------)  + I mil
	0x00222fc2, // n0x0daa c0x0000 (---------------)  + I ms
	0x00205f42, // n0x0dab c0x0000 (---------------)  + I ne
	0x00204282, // n0x0dac c0x0000 (---------------)  + I or
	0x00208682, // n0x0dad c0x0000 (---------------)  + I pe
	0x00202142, // n0x0dae c0x0000 (---------------)  + I re
	0x00201e42, // n0x0daf c0x0000 (---------------)  + I sc
	0x002be645, // n0x0db0 c0x0000 (---------------)  + I seoul
	0x00223605, // n0x0db1 c0x0000 (---------------)  + I ulsan
	0x002104c3, // n0x0db2 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0db3 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0db4 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0db5 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0db6 c0x0000 (---------------)  + I org
	0x002104c3, // n0x0db7 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0db8 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0db9 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0dba c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0dbb c0x0000 (---------------)  + I net
	0x002453c3, // n0x0dbc c0x0000 (---------------)  + I org
	0x00000401, // n0x0dbd c0x0000 (---------------)  +   c
	0x002104c3, // n0x0dbe c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0dbf c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0dc0 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x0dc1 c0x0000 (---------------)  + I info
	0x0021fe43, // n0x0dc2 c0x0000 (---------------)  + I int
	0x00239bc3, // n0x0dc3 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0dc4 c0x0000 (---------------)  + I org
	0x0020f983, // n0x0dc5 c0x0000 (---------------)  + I per
	0x002104c3, // n0x0dc6 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0dc7 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0dc8 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0dc9 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0dca c0x0000 (---------------)  + I org
	0x00208f82, // n0x0dcb c0x0000 (---------------)  + I co
	0x002104c3, // n0x0dcc c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0dcd c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0dce c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0dcf c0x0000 (---------------)  + I net
	0x002453c3, // n0x0dd0 c0x0000 (---------------)  + I org
	0x002a3984, // n0x0dd1 c0x0000 (---------------)  + I assn
	0x002104c3, // n0x0dd2 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0dd3 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0dd4 c0x0000 (---------------)  + I gov
	0x00243283, // n0x0dd5 c0x0000 (---------------)  + I grp
	0x0028ba85, // n0x0dd6 c0x0000 (---------------)  + I hotel
	0x0021fe43, // n0x0dd7 c0x0000 (---------------)  + I int
	0x00231743, // n0x0dd8 c0x0000 (---------------)  + I ltd
	0x00239bc3, // n0x0dd9 c0x0000 (---------------)  + I net
	0x00206ac3, // n0x0dda c0x0000 (---------------)  + I ngo
	0x002453c3, // n0x0ddb c0x0000 (---------------)  + I org
	0x00204343, // n0x0ddc c0x0000 (---------------)  + I sch
	0x002a3f83, // n0x0ddd c0x0000 (---------------)  + I soc
	0x00209243, // n0x0dde c0x0000 (---------------)  + I web
	0x002104c3, // n0x0ddf c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0de0 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0de1 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0de2 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0de3 c0x0000 (---------------)  + I org
	0x00208f82, // n0x0de4 c0x0000 (---------------)  + I co
	0x002453c3, // n0x0de5 c0x0000 (---------------)  + I org
	0x002150c3, // n0x0de6 c0x0000 (---------------)  + I gov
	0x00299d43, // n0x0de7 c0x0000 (---------------)  + I asn
	0x002104c3, // n0x0de8 c0x0000 (---------------)  + I com
	0x00232044, // n0x0de9 c0x0000 (---------------)  + I conf
	0x002ceec3, // n0x0dea c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0deb c0x0000 (---------------)  + I gov
	0x0020ab82, // n0x0dec c0x0000 (---------------)  + I id
	0x0025f683, // n0x0ded c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x0dee c0x0000 (---------------)  + I net
	0x002453c3, // n0x0def c0x0000 (---------------)  + I org
	0x002104c3, // n0x0df0 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0df1 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0df2 c0x0000 (---------------)  + I gov
	0x0020ab82, // n0x0df3 c0x0000 (---------------)  + I id
	0x002382c3, // n0x0df4 c0x0000 (---------------)  + I med
	0x00239bc3, // n0x0df5 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0df6 c0x0000 (---------------)  + I org
	0x002c1843, // n0x0df7 c0x0000 (---------------)  + I plc
	0x00204343, // n0x0df8 c0x0000 (---------------)  + I sch
	0x002028c2, // n0x0df9 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x0dfa c0x0000 (---------------)  + I co
	0x002150c3, // n0x0dfb c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0dfc c0x0000 (---------------)  + I net
	0x002453c3, // n0x0dfd c0x0000 (---------------)  + I org
	0x0020e2c5, // n0x0dfe c0x0000 (---------------)  + I press
	0x00202f44, // n0x0dff c0x0000 (---------------)  + I asso
	0x0023d502, // n0x0e00 c0x0000 (---------------)  + I tm
	0x002028c2, // n0x0e01 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x0e02 c0x0000 (---------------)  + I co
	0x002ceec3, // n0x0e03 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0e04 c0x0000 (---------------)  + I gov
	0x00238803, // n0x0e05 c0x0000 (---------------)  + I its
	0x00239bc3, // n0x0e06 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0e07 c0x0000 (---------------)  + I org
	0x002c5804, // n0x0e08 c0x0000 (---------------)  + I priv
	0x002104c3, // n0x0e09 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0e0a c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0e0b c0x0000 (---------------)  + I gov
	0x0025f683, // n0x0e0c c0x0000 (---------------)  + I mil
	0x002006c3, // n0x0e0d c0x0000 (---------------)  + I nom
	0x002453c3, // n0x0e0e c0x0000 (---------------)  + I org
	0x00259843, // n0x0e0f c0x0000 (---------------)  + I prd
	0x0023d502, // n0x0e10 c0x0000 (---------------)  + I tm
	0x002104c3, // n0x0e11 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0e12 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0e13 c0x0000 (---------------)  + I gov
	0x002180c3, // n0x0e14 c0x0000 (---------------)  + I inf
	0x002d16c4, // n0x0e15 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x0e16 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0e17 c0x0000 (---------------)  + I org
	0x002104c3, // n0x0e18 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0e19 c0x0000 (---------------)  + I edu
	0x0022fa44, // n0x0e1a c0x0000 (---------------)  + I gouv
	0x002150c3, // n0x0e1b c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0e1c c0x0000 (---------------)  + I net
	0x002453c3, // n0x0e1d c0x0000 (---------------)  + I org
	0x0020e2c6, // n0x0e1e c0x0000 (---------------)  + I presse
	0x002ceec3, // n0x0e1f c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0e20 c0x0000 (---------------)  + I gov
	0x00016043, // n0x0e21 c0x0000 (---------------)  +   nyc
	0x002453c3, // n0x0e22 c0x0000 (---------------)  + I org
	0x002104c3, // n0x0e23 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x0e24 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x0e25 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0e26 c0x0000 (---------------)  + I net
	0x002453c3, // n0x0e27 c0x0000 (---------------)  + I org
	0x00031c88, // n0x0e28 c0x0000 (---------------)  +   blogspot
	0x002150c3, // n0x0e29 c0x0000 (---------------)  + I gov
	0x002028c2, // n0x0e2a c0x0000 (---------------)  + I ac
	0x00208f82, // n0x0e2b c0x0000 (---------------)  + I co
	0x002104c3, // n0x0e2c c0x0000 (---------------)  + I com
	0x002150c3, // n0x0e2d c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x0e2e c0x0000 (---------------)  + I net
	0x00204282, // n0x0e2f c0x0000 (---------------)  + I or
	0x002453c3, // n0x0e30 c0x0000 (---------------)  + I org
	0x00352bc7, // n0x0e31 c0x0000 (---------------)  + I academy
	0x0020638b, // n0x0e32 c0x0000 (---------------)  + I agriculture
	0x00204f83, // n0x0e33 c0x0000 (---------------)  + I air
	0x002dbe08, // n0x0e34 c0x0000 (---------------)  + I airguard
	0x002fa447, // n0x0e35 c0x0000 (---------------)  + I alabama
	0x00203306, // n0x0e36 c0x0000 (---------------)  + I alaska
	0x002a4dc5, // n0x0e37 c0x0000 (---------------)  + I amber
	0x002066c9, // n0x0e38 c0x0000 (---------------)  + I ambulance
	0x0033f748, // n0x0e39 c0x0000 (---------------)  + I american
	0x0033f749, // n0x0e3a c0x0000 (---------------)  + I americana
	0x0033f750, // n0x0e3b c0x0000 (---------------)  + I americanantiques
	0x0034524b, // n0x0e3c c0x0000 (---------------)  + I americanart
	0x002a4c09, // n0x0e3d c0x0000 (---------------)  + I amsterdam
	0x00200a83, // n0x0e3e c0x0000 (---------------)  + I and
	0x00237d09, // n0x0e3f c0x0000 (---------------)  + I annefrank
	0x00233606, // n0x0e40 c0x0000 (---------------)  + I anthro
	0x0023360c, // n0x0e41 c0x0000 (---------------)  + I anthropology
	0x0022f3c8, // n0x0e42 c0x0000 (---------------)  + I antiques
	0x00269748, // n0x0e43 c0x0000 (---------------)  + I aquarium
	0x00307489, // n0x0e44 c0x0000 (---------------)  + I arboretum
	0x002c32ce, // n0x0e45 c0x0000 (---------------)  + I archaeological
	0x0032b34b, // n0x0e46 c0x0000 (---------------)  + I archaeology
	0x00240b4c, // n0x0e47 c0x0000 (---------------)  + I architecture
	0x0020c703, // n0x0e48 c0x0000 (---------------)  + I art
	0x0034544c, // n0x0e49 c0x0000 (---------------)  + I artanddesign
	0x002ec609, // n0x0e4a c0x0000 (---------------)  + I artcenter
	0x0020c707, // n0x0e4b c0x0000 (---------------)  + I artdeco
	0x0031974c, // n0x0e4c c0x0000 (---------------)  + I arteducation
	0x00234b8a, // n0x0e4d c0x0000 (---------------)  + I artgallery
	0x0023fec4, // n0x0e4e c0x0000 (---------------)  + I arts
	0x002a244d, // n0x0e4f c0x0000 (---------------)  + I artsandcrafts
	0x002ec4c8, // n0x0e50 c0x0000 (---------------)  + I asmatart
	0x0020894d, // n0x0e51 c0x0000 (---------------)  + I assassination
	0x002059c6, // n0x0e52 c0x0000 (---------------)  + I assisi
	0x002bae4b, // n0x0e53 c0x0000 (---------------)  + I association
	0x00224509, // n0x0e54 c0x0000 (---------------)  + I astronomy
	0x002da347, // n0x0e55 c0x0000 (---------------)  + I atlanta
	0x002f7f46, // n0x0e56 c0x0000 (---------------)  + I austin
	0x00224309, // n0x0e57 c0x0000 (---------------)  + I australia
	0x002eb24a, // n0x0e58 c0x0000 (---------------)  + I automotive
	0x002262c8, // n0x0e59 c0x0000 (---------------)  + I aviation
	0x0023bf44, // n0x0e5a c0x0000 (---------------)  + I axis
	0x002bfd47, // n0x0e5b c0x0000 (---------------)  + I badajoz
	0x00295007, // n0x0e5c c0x0000 (---------------)  + I baghdad
	0x00292844, // n0x0e5d c0x0000 (---------------)  + I bahn
	0x002ed404, // n0x0e5e c0x0000 (---------------)  + I bale
	0x002d8589, // n0x0e5f c0x0000 (---------------)  + I baltimore
	0x002e9ac9, // n0x0e60 c0x0000 (---------------)  + I barcelona
	0x0028bd08, // n0x0e61 c0x0000 (---------------)  + I baseball
	0x00318285, // n0x0e62 c0x0000 (---------------)  + I basel
	0x00211b85, // n0x0e63 c0x0000 (---------------)  + I baths
	0x00272c46, // n0x0e64 c0x0000 (---------------)  + I bauern
	0x002a2309, // n0x0e65 c0x0000 (---------------)  + I beauxarts
	0x0020b98d, // n0x0e66 c0x0000 (---------------)  + I beeldengeluid
	0x00269e48, // n0x0e67 c0x0000 (---------------)  + I bellevue
	0x00272b47, // n0x0e68 c0x0000 (---------------)  + I bergbau
	0x002a4e48, // n0x0e69 c0x0000 (---------------)  + I berkeley
	0x003414c6, // n0x0e6a c0x0000 (---------------)  + I berlin
	0x003421c4, // n0x0e6b c0x0000 (---------------)  + I bern
	0x0022b905, // n0x0e6c c0x0000 (---------------)  + I bible
	0x00205646, // n0x0e6d c0x0000 (---------------)  + I bilbao
	0x002097c4, // n0x0e6e c0x0000 (---------------)  + I bill
	0x0020c607, // n0x0e6f c0x0000 (---------------)  + I birdart
	0x0020db8a, // n0x0e70 c0x0000 (---------------)  + I birthplace
	0x00212184, // n0x0e71 c0x0000 (---------------)  + I bonn
	0x00212a46, // n0x0e72 c0x0000 (---------------)  + I boston
	0x002130c9, // n0x0e73 c0x0000 (---------------)  + I botanical
	0x002130cf, // n0x0e74 c0x0000 (---------------)  + I botanicalgarden
	0x0021534d, // n0x0e75 c0x0000 (---------------)  + I botanicgarden
	0x00215f46, // n0x0e76 c0x0000 (---------------)  + I botany
	0x002185d0, // n0x0e77 c0x0000 (---------------)  + I brandywinevalley
	0x00219206, // n0x0e78 c0x0000 (---------------)  + I brasil
	0x0021ab87, // n0x0e79 c0x0000 (---------------)  + I bristol
	0x0021c547, // n0x0e7a c0x0000 (---------------)  + I british
	0x0021d38f, // n0x0e7b c0x0000 (---------------)  + I britishcolumbia
	0x0021e009, // n0x0e7c c0x0000 (---------------)  + I broadcast
	0x00220ec6, // n0x0e7d c0x0000 (---------------)  + I brunel
	0x00222007, // n0x0e7e c0x0000 (---------------)  + I brussel
	0x00222008, // n0x0e7f c0x0000 (---------------)  + I brussels
	0x002226c9, // n0x0e80 c0x0000 (---------------)  + I bruxelles
	0x00349948, // n0x0e81 c0x0000 (---------------)  + I building
	0x002bf047, // n0x0e82 c0x0000 (---------------)  + I burghof
	0x0022f303, // n0x0e83 c0x0000 (---------------)  + I bus
	0x002774c6, // n0x0e84 c0x0000 (---------------)  + I bushey
	0x002c0188, // n0x0e85 c0x0000 (---------------)  + I cadaques
	0x002f930a, // n0x0e86 c0x0000 (---------------)  + I california
	0x0024b909, // n0x0e87 c0x0000 (---------------)  + I cambridge
	0x00246283, // n0x0e88 c0x0000 (---------------)  + I can
	0x0029d846, // n0x0e89 c0x0000 (---------------)  + I canada
	0x0029954a, // n0x0e8a c0x0000 (---------------)  + I capebreton
	0x002253c7, // n0x0e8b c0x0000 (---------------)  + I carrier
	0x0031958a, // n0x0e8c c0x0000 (---------------)  + I cartoonart
	0x00351e0e, // n0x0e8d c0x0000 (---------------)  + I casadelamoneda
	0x0021e146, // n0x0e8e c0x0000 (---------------)  + I castle
	0x00338507, // n0x0e8f c0x0000 (---------------)  + I castres
	0x002a2a06, // n0x0e90 c0x0000 (---------------)  + I celtic
	0x0023c546, // n0x0e91 c0x0000 (---------------)  + I center
	0x0025490b, // n0x0e92 c0x0000 (---------------)  + I chattanooga
	0x00258dca, // n0x0e93 c0x0000 (---------------)  + I cheltenham
	0x002411cd, // n0x0e94 c0x0000 (---------------)  + I chesapeakebay
	0x0022ff47, // n0x0e95 c0x0000 (---------------)  + I chicago
	0x00230648, // n0x0e96 c0x0000 (---------------)  + I children
	0x00230649, // n0x0e97 c0x0000 (---------------)  + I childrens
	0x0023064f, // n0x0e98 c0x0000 (---------------)  + I childrensgarden
	0x0028aa8c, // n0x0e99 c0x0000 (---------------)  + I chiropractic
	0x002d2489, // n0x0e9a c0x0000 (---------------)  + I chocolate
	0x0033324e, // n0x0e9b c0x0000 (---------------)  + I christiansburg
	0x002cb48a, // n0x0e9c c0x0000 (---------------)  + I cincinnati
	0x002911c6, // n0x0e9d c0x0000 (---------------)  + I cinema
	0x0034ca46, // n0x0e9e c0x0000 (---------------)  + I circus
	0x00226c8c, // n0x0e9f c0x0000 (---------------)  + I civilisation
	0x0022820c, // n0x0ea0 c0x0000 (---------------)  + I civilization
	0x002287c8, // n0x0ea1 c0x0000 (---------------)  + I civilwar
	0x00229007, // n0x0ea2 c0x0000 (---------------)  + I clinton
	0x00200b45, // n0x0ea3 c0x0000 (---------------)  + I clock
	0x0020c844, // n0x0ea4 c0x0000 (---------------)  + I coal
	0x00316a8e, // n0x0ea5 c0x0000 (---------------)  + I coastaldefence
	0x00278a44, // n0x0ea6 c0x0000 (---------------)  + I cody
	0x0024c087, // n0x0ea7 c0x0000 (---------------)  + I coldwar
	0x0024580a, // n0x0ea8 c0x0000 (---------------)  + I collection
	0x00239ed4, // n0x0ea9 c0x0000 (---------------)  + I colonialwilliamsburg
	0x0022e00f, // n0x0eaa c0x0000 (---------------)  + I coloradoplateau
	0x0021d548, // n0x0eab c0x0000 (---------------)  + I columbia
	0x0022f1c8, // n0x0eac c0x0000 (---------------)  + I columbus
	0x00214a0d, // n0x0ead c0x0000 (---------------)  + I communication
	0x00214a0e, // n0x0eae c0x0000 (---------------)  + I communications
	0x00296d09, // n0x0eaf c0x0000 (---------------)  + I community
	0x00230e88, // n0x0eb0 c0x0000 (---------------)  + I computer
	0x00230e8f, // n0x0eb1 c0x0000 (---------------)  + I computerhistory
	0x0023488c, // n0x0eb2 c0x0000 (---------------)  + I contemporary
	0x0023488f, // n0x0eb3 c0x0000 (---------------)  + I contemporaryart
	0x00235507, // n0x0eb4 c0x0000 (---------------)  + I convent
	0x0023654a, // n0x0eb5 c0x0000 (---------------)  + I copenhagen
	0x0023750b, // n0x0eb6 c0x0000 (---------------)  + I corporation
	0x002377c8, // n0x0eb7 c0x0000 (---------------)  + I corvette
	0x00238187, // n0x0eb8 c0x0000 (---------------)  + I costume
	0x0026ee0d, // n0x0eb9 c0x0000 (---------------)  + I countryestate
	0x00238b46, // n0x0eba c0x0000 (---------------)  + I county
	0x002a2606, // n0x0ebb c0x0000 (---------------)  + I crafts
	0x00239289, // n0x0ebc c0x0000 (---------------)  + I cranbrook
	0x002f9d48, // n0x0ebd c0x0000 (---------------)  + I creation
	0x0023c348, // n0x0ebe c0x0000 (---------------)  + I cultural
	0x0023c34e, // n0x0ebf c0x0000 (---------------)  + I culturalcenter
	0x00206487, // n0x0ec0 c0x0000 (---------------)  + I culture
	0x002bb985, // n0x0ec1 c0x0000 (---------------)  + I cyber
	0x0023d305, // n0x0ec2 c0x0000 (---------------)  + I cymru
	0x00236a04, // n0x0ec3 c0x0000 (---------------)  + I dali
	0x00259e46, // n0x0ec4 c0x0000 (---------------)  + I dallas
	0x0028bc08, // n0x0ec5 c0x0000 (---------------)  + I database
	0x00298f03, // n0x0ec6 c0x0000 (---------------)  + I ddr
	0x0025428e, // n0x0ec7 c0x0000 (---------------)  + I decorativearts
	0x0026f1c8, // n0x0ec8 c0x0000 (---------------)  + I delaware
	0x0026274b, // n0x0ec9 c0x0000 (---------------)  + I delmenhorst
	0x002f8b87, // n0x0eca c0x0000 (---------------)  + I denmark
	0x0023e485, // n0x0ecb c0x0000 (---------------)  + I depot
	0x00252b46, // n0x0ecc c0x0000 (---------------)  + I design
	0x0028c3c7, // n0x0ecd c0x0000 (---------------)  + I detroit
	0x002c7788, // n0x0ece c0x0000 (---------------)  + I dinosaur
	0x002a7189, // n0x0ecf c0x0000 (---------------)  + I discovery
	0x0026a545, // n0x0ed0 c0x0000 (---------------)  + I dolls
	0x0026af48, // n0x0ed1 c0x0000 (---------------)  + I donostia
	0x002df786, // n0x0ed2 c0x0000 (---------------)  + I durham
	0x0026e8ca, // n0x0ed3 c0x0000 (---------------)  + I eastafrica
	0x00316989, // n0x0ed4 c0x0000 (---------------)  + I eastcoast
	0x00319809, // n0x0ed5 c0x0000 (---------------)  + I education
	0x0031980b, // n0x0ed6 c0x0000 (---------------)  + I educational
	0x0031c3c8, // n0x0ed7 c0x0000 (---------------)  + I egyptian
	0x00292709, // n0x0ed8 c0x0000 (---------------)  + I eisenbahn
	0x00318346, // n0x0ed9 c0x0000 (---------------)  + I elburg
	0x0034f30a, // n0x0eda c0x0000 (---------------)  + I elvendrell
	0x00318e0a, // n0x0edb c0x0000 (---------------)  + I embroidery
	0x003192cc, // n0x0edc c0x0000 (---------------)  + I encyclopedic
	0x002a8fc7, // n0x0edd c0x0000 (---------------)  + I england
	0x00343aca, // n0x0ede c0x0000 (---------------)  + I entomology
	0x0021340b, // n0x0edf c0x0000 (---------------)  + I environment
	0x00213419, // n0x0ee0 c0x0000 (---------------)  + I environmentalconservation
	0x0033f248, // n0x0ee1 c0x0000 (---------------)  + I epilepsy
	0x0020e345, // n0x0ee2 c0x0000 (---------------)  + I essex
	0x0026efc6, // n0x0ee3 c0x0000 (---------------)  + I estate
	0x002fba49, // n0x0ee4 c0x0000 (---------------)  + I ethnology
	0x00201346, // n0x0ee5 c0x0000 (---------------)  + I exeter
	0x0020ddca, // n0x0ee6 c0x0000 (---------------)  + I exhibition
	0x00308946, // n0x0ee7 c0x0000 (---------------)  + I family
	0x00223e04, // n0x0ee8 c0x0000 (---------------)  + I farm
	0x0033788d, // n0x0ee9 c0x0000 (---------------)  + I farmequipment
	0x00223e07, // n0x0eea c0x0000 (---------------)  + I farmers
	0x0022d609, // n0x0eeb c0x0000 (---------------)  + I farmstead
	0x0023dbc5, // n0x0eec c0x0000 (---------------)  + I field
	0x0023dd08, // n0x0eed c0x0000 (---------------)  + I figueres
	0x0023f349, // n0x0eee c0x0000 (---------------)  + I filatelia
	0x0023f584, // n0x0eef c0x0000 (---------------)  + I film
	0x0023fdc7, // n0x0ef0 c0x0000 (---------------)  + I fineart
	0x0023fdc8, // n0x0ef1 c0x0000 (---------------)  + I finearts
	0x00240187, // n0x0ef2 c0x0000 (---------------)  + I finland
	0x00325b48, // n0x0ef3 c0x0000 (---------------)  + I flanders
	0x00242b07, // n0x0ef4 c0x0000 (---------------)  + I florida
	0x00245245, // n0x0ef5 c0x0000 (---------------)  + I force
	0x00246d4c, // n0x0ef6 c0x0000 (---------------)  + I fortmissoula
	0x00247749, // n0x0ef7 c0x0000 (---------------)  + I fortworth
	0x002d010a, // n0x0ef8 c0x0000 (---------------)  + I foundation
	0x00336cc9, // n0x0ef9 c0x0000 (---------------)  + I francaise
	0x00237e09, // n0x0efa c0x0000 (---------------)  + I frankfurt
	0x0032540c, // n0x0efb c0x0000 (---------------)  + I franziskaner
	0x002108cb, // n0x0efc c0x0000 (---------------)  + I freemasonry
	0x00249988, // n0x0efd c0x0000 (---------------)  + I freiburg
	0x0024a488, // n0x0efe c0x0000 (---------------)  + I fribourg
	0x0024a944, // n0x0eff c0x0000 (---------------)  + I frog
	0x00268488, // n0x0f00 c0x0000 (---------------)  + I fundacio
	0x00268d09, // n0x0f01 c0x0000 (---------------)  + I furniture
	0x00234c47, // n0x0f02 c0x0000 (---------------)  + I gallery
	0x00213306, // n0x0f03 c0x0000 (---------------)  + I garden
	0x002c20c7, // n0x0f04 c0x0000 (---------------)  + I gateway
	0x002330c9, // n0x0f05 c0x0000 (---------------)  + I geelvinck
	0x002f910b, // n0x0f06 c0x0000 (---------------)  + I gemological
	0x002d2f87, // n0x0f07 c0x0000 (---------------)  + I geology
	0x0030b147, // n0x0f08 c0x0000 (---------------)  + I georgia
	0x0030fac7, // n0x0f09 c0x0000 (---------------)  + I giessen
	0x002088c4, // n0x0f0a c0x0000 (---------------)  + I glas
	0x002088c5, // n0x0f0b c0x0000 (---------------)  + I glass
	0x0028a785, // n0x0f0c c0x0000 (---------------)  + I gorge
	0x002fd94b, // n0x0f0d c0x0000 (---------------)  + I grandrapids
	0x00339e84, // n0x0f0e c0x0000 (---------------)  + I graz
	0x00257a08, // n0x0f0f c0x0000 (---------------)  + I guernsey
	0x002490ca, // n0x0f10 c0x0000 (---------------)  + I halloffame
	0x002df847, // n0x0f11 c0x0000 (---------------)  + I hamburg
	0x00333c87, // n0x0f12 c0x0000 (---------------)  + I handson
	0x002730d2, // n0x0f13 c0x0000 (---------------)  + I harvestcelebration
	0x00276bc6, // n0x0f14 c0x0000 (---------------)  + I hawaii
	0x0021a586, // n0x0f15 c0x0000 (---------------)  + I health
	0x002b6d4e, // n0x0f16 c0x0000 (---------------)  + I heimatunduhren
	0x002ff986, // n0x0f17 c0x0000 (---------------)  + I hellas
	0x00298888, // n0x0f18 c0x0000 (---------------)  + I helsinki
	0x002e5ccf, // n0x0f19 c0x0000 (---------------)  + I hembygdsforbund
	0x0033f088, // n0x0f1a c0x0000 (---------------)  + I heritage
	0x0026e508, // n0x0f1b c0x0000 (---------------)  + I histoire
	0x002fdf8a, // n0x0f1c c0x0000 (---------------)  + I historical
	0x002fdf91, // n0x0f1d c0x0000 (---------------)  + I historicalsociety
	0x0028680e, // n0x0f1e c0x0000 (---------------)  + I historichouses
	0x0020418a, // n0x0f1f c0x0000 (---------------)  + I historisch
	0x0020418c, // n0x0f20 c0x0000 (---------------)  + I historisches
	0x00231087, // n0x0f21 c0x0000 (---------------)  + I history
	0x00231090, // n0x0f22 c0x0000 (---------------)  + I historyofscience
	0x00205108, // n0x0f23 c0x0000 (---------------)  + I horology
	0x002722c5, // n0x0f24 c0x0000 (---------------)  + I house
	0x0028caca, // n0x0f25 c0x0000 (---------------)  + I humanities
	0x0020980c, // n0x0f26 c0x0000 (---------------)  + I illustration
	0x002cf28d, // n0x0f27 c0x0000 (---------------)  + I imageandsound
	0x0020ca86, // n0x0f28 c0x0000 (---------------)  + I indian
	0x0020ca87, // n0x0f29 c0x0000 (---------------)  + I indiana
	0x0020ca8c, // n0x0f2a c0x0000 (---------------)  + I indianapolis
	0x0021260c, // n0x0f2b c0x0000 (---------------)  + I indianmarket
	0x0021fe4c, // n0x0f2c c0x0000 (---------------)  + I intelligence
	0x0029358b, // n0x0f2d c0x0000 (---------------)  + I interactive
	0x002696c4, // n0x0f2e c0x0000 (---------------)  + I iraq
	0x002134c4, // n0x0f2f c0x0000 (---------------)  + I iron
	0x00332649, // n0x0f30 c0x0000 (---------------)  + I isleofman
	0x003081c7, // n0x0f31 c0x0000 (---------------)  + I jamison
	0x0025d509, // n0x0f32 c0x0000 (---------------)  + I jefferson
	0x002dc189, // n0x0f33 c0x0000 (---------------)  + I jerusalem
	0x0031b107, // n0x0f34 c0x0000 (---------------)  + I jewelry
	0x0034a686, // n0x0f35 c0x0000 (---------------)  + I jewish
	0x0034a689, // n0x0f36 c0x0000 (---------------)  + I jewishart
	0x0028fcc3, // n0x0f37 c0x0000 (---------------)  + I jfk
	0x0021594a, // n0x0f38 c0x0000 (---------------)  + I journalism
	0x002fab87, // n0x0f39 c0x0000 (---------------)  + I judaica
	0x002037cb, // n0x0f3a c0x0000 (---------------)  + I judygarland
	0x0024104a, // n0x0f3b c0x0000 (---------------)  + I juedisches
	0x0031bb84, // n0x0f3c c0x0000 (---------------)  + I juif
	0x00316186, // n0x0f3d c0x0000 (---------------)  + I karate
	0x002cc409, // n0x0f3e c0x0000 (---------------)  + I karikatur
	0x0031c804, // n0x0f3f c0x0000 (---------------)  + I kids
	0x00213aca, // n0x0f40 c0x0000 (---------------)  + I koebenhavn
	0x0026ad05, // n0x0f41 c0x0000 (---------------)  + I koeln
	0x0029dd45, // n0x0f42 c0x0000 (---------------)  + I kunst
	0x0029dd4d, // n0x0f43 c0x0000 (---------------)  + I kunstsammlung
	0x0029e08e, // n0x0f44 c0x0000 (---------------)  + I kunstunddesign
	0x002f13c5, // n0x0f45 c0x0000 (---------------)  + I labor
	0x0033b8c6, // n0x0f46 c0x0000 (---------------)  + I labour
	0x00288947, // n0x0f47 c0x0000 (---------------)  + I lajolla
	0x00270fca, // n0x0f48 c0x0000 (---------------)  + I lancashire
	0x00209046, // n0x0f49 c0x0000 (---------------)  + I landes
	0x002e6e84, // n0x0f4a c0x0000 (---------------)  + I lans
	0x002e3747, // n0x0f4b c0x0000 (---------------)  + I larsson
	0x0025f54b, // n0x0f4c c0x0000 (---------------)  + I lewismiller
	0x00341587, // n0x0f4d c0x0000 (---------------)  + I lincoln
	0x002ea544, // n0x0f4e c0x0000 (---------------)  + I linz
	0x00336746, // n0x0f4f c0x0000 (---------------)  + I living
	0x0033674d, // n0x0f50 c0x0000 (---------------)  + I livinghistory
	0x002a93cc, // n0x0f51 c0x0000 (---------------)  + I localhistory
	0x002ad006, // n0x0f52 c0x0000 (---------------)  + I london
	0x00209c8a, // n0x0f53 c0x0000 (---------------)  + I losangeles
	0x0020e106, // n0x0f54 c0x0000 (---------------)  + I louvre
	0x00249f48, // n0x0f55 c0x0000 (---------------)  + I loyalist
	0x003048c7, // n0x0f56 c0x0000 (---------------)  + I lucerne
	0x0022d0ca, // n0x0f57 c0x0000 (---------------)  + I luxembourg
	0x00231846, // n0x0f58 c0x0000 (---------------)  + I luzern
	0x0022fe43, // n0x0f59 c0x0000 (---------------)  + I mad
	0x0025a246, // n0x0f5a c0x0000 (---------------)  + I madrid
	0x002c0008, // n0x0f5b c0x0000 (---------------)  + I mallorca
	0x0028074a, // n0x0f5c c0x0000 (---------------)  + I manchester
	0x00261307, // n0x0f5d c0x0000 (---------------)  + I mansion
	0x00261308, // n0x0f5e c0x0000 (---------------)  + I mansions
	0x00318944, // n0x0f5f c0x0000 (---------------)  + I manx
	0x00227647, // n0x0f60 c0x0000 (---------------)  + I marburg
	0x00253288, // n0x0f61 c0x0000 (---------------)  + I maritime
	0x00331208, // n0x0f62 c0x0000 (---------------)  + I maritimo
	0x0027ddc8, // n0x0f63 c0x0000 (---------------)  + I maryland
	0x00284a4a, // n0x0f64 c0x0000 (---------------)  + I marylhurst
	0x002e2905, // n0x0f65 c0x0000 (---------------)  + I media
	0x002382c7, // n0x0f66 c0x0000 (---------------)  + I medical
	0x00250e13, // n0x0f67 c0x0000 (---------------)  + I medizinhistorisches
	0x0027d446, // n0x0f68 c0x0000 (---------------)  + I meeres
	0x002ea388, // n0x0f69 c0x0000 (---------------)  + I memorial
	0x002dc809, // n0x0f6a c0x0000 (---------------)  + I mesaverde
	0x00229d08, // n0x0f6b c0x0000 (---------------)  + I michigan
	0x0027bfcb, // n0x0f6c c0x0000 (---------------)  + I midatlantic
	0x002ad5c8, // n0x0f6d c0x0000 (---------------)  + I military
	0x0025f684, // n0x0f6e c0x0000 (---------------)  + I mill
	0x002e4806, // n0x0f6f c0x0000 (---------------)  + I miners
	0x00289546, // n0x0f70 c0x0000 (---------------)  + I mining
	0x0029b1c9, // n0x0f71 c0x0000 (---------------)  + I minnesota
	0x0032a687, // n0x0f72 c0x0000 (---------------)  + I missile
	0x00246e48, // n0x0f73 c0x0000 (---------------)  + I missoula
	0x00286686, // n0x0f74 c0x0000 (---------------)  + I modern
	0x00214544, // n0x0f75 c0x0000 (---------------)  + I moma
	0x002ac245, // n0x0f76 c0x0000 (---------------)  + I money
	0x002ac4c8, // n0x0f77 c0x0000 (---------------)  + I monmouth
	0x002ace0a, // n0x0f78 c0x0000 (---------------)  + I monticello
	0x002ad7c8, // n0x0f79 c0x0000 (---------------)  + I montreal
	0x002b0906, // n0x0f7a c0x0000 (---------------)  + I moscow
	0x00280e4a, // n0x0f7b c0x0000 (---------------)  + I motorcycle
	0x00272788, // n0x0f7c c0x0000 (---------------)  + I muenchen
	0x002b2148, // n0x0f7d c0x0000 (---------------)  + I muenster
	0x002b3b08, // n0x0f7e c0x0000 (---------------)  + I mulhouse
	0x002b42c6, // n0x0f7f c0x0000 (---------------)  + I muncie
	0x002b8cc6, // n0x0f80 c0x0000 (---------------)  + I museet
	0x00341a8c, // n0x0f81 c0x0000 (---------------)  + I museumcenter
	0x002b9790, // n0x0f82 c0x0000 (---------------)  + I museumvereniging
	0x002aa905, // n0x0f83 c0x0000 (---------------)  + I music
	0x00208b08, // n0x0f84 c0x0000 (---------------)  + I national
	0x002cb610, // n0x0f85 c0x0000 (---------------)  + I nationalfirearms
	0x0033ee90, // n0x0f86 c0x0000 (---------------)  + I nationalheritage
	0x0033f5ce, // n0x0f87 c0x0000 (---------------)  + I nativeamerican
	0x0034170e, // n0x0f88 c0x0000 (---------------)  + I naturalhistory
	0x00341714, // n0x0f89 c0x0000 (---------------)  + I naturalhistorymuseum
	0x00201c8f, // n0x0f8a c0x0000 (---------------)  + I naturalsciences
	0x00202046, // n0x0f8b c0x0000 (---------------)  + I nature
	0x00204051, // n0x0f8c c0x0000 (---------------)  + I naturhistorisches
	0x00208293, // n0x0f8d c0x0000 (---------------)  + I natuurwetenschappen
	0x00208708, // n0x0f8e c0x0000 (---------------)  + I naumburg
	0x0020e005, // n0x0f8f c0x0000 (---------------)  + I naval
	0x002f4608, // n0x0f90 c0x0000 (---------------)  + I nebraska
	0x0024ae45, // n0x0f91 c0x0000 (---------------)  + I neues
	0x002f9a4c, // n0x0f92 c0x0000 (---------------)  + I newhampshire
	0x00223389, // n0x0f93 c0x0000 (---------------)  + I newjersey
	0x00278889, // n0x0f94 c0x0000 (---------------)  + I newmexico
	0x002c1e47, // n0x0f95 c0x0000 (---------------)  + I newport
	0x0030cc49, // n0x0f96 c0x0000 (---------------)  + I newspaper
	0x0023b807, // n0x0f97 c0x0000 (---------------)  + I newyork
	0x002ce946, // n0x0f98 c0x0000 (---------------)  + I niepce
	0x0022b707, // n0x0f99 c0x0000 (---------------)  + I norfolk
	0x00209505, // n0x0f9a c0x0000 (---------------)  + I north
	0x00231983, // n0x0f9b c0x0000 (---------------)  + I nrw
	0x002990c9, // n0x0f9c c0x0000 (---------------)  + I nuernberg
	0x002538c9, // n0x0f9d c0x0000 (---------------)  + I nuremberg
	0x00216043, // n0x0f9e c0x0000 (---------------)  + I nyc
	0x00319dc4, // n0x0f9f c0x0000 (---------------)  + I nyny
	0x00342d8d, // n0x0fa0 c0x0000 (---------------)  + I oceanographic
	0x003519cf, // n0x0fa1 c0x0000 (---------------)  + I oceanographique
	0x00295305, // n0x0fa2 c0x0000 (---------------)  + I omaha
	0x002f4506, // n0x0fa3 c0x0000 (---------------)  + I online
	0x0022c247, // n0x0fa4 c0x0000 (---------------)  + I ontario
	0x00259207, // n0x0fa5 c0x0000 (---------------)  + I openair
	0x0026c646, // n0x0fa6 c0x0000 (---------------)  + I oregon
	0x0026c64b, // n0x0fa7 c0x0000 (---------------)  + I oregontrail
	0x00287945, // n0x0fa8 c0x0000 (---------------)  + I otago
	0x00350106, // n0x0fa9 c0x0000 (---------------)  + I oxford
	0x00258c47, // n0x0faa c0x0000 (---------------)  + I pacific
	0x0022cd09, // n0x0fab c0x0000 (---------------)  + I paderborn
	0x0025fbc6, // n0x0fac c0x0000 (---------------)  + I palace
	0x00342c85, // n0x0fad c0x0000 (---------------)  + I paleo
	0x00222f0b, // n0x0fae c0x0000 (---------------)  + I palmsprings
	0x00226b06, // n0x0faf c0x0000 (---------------)  + I panama
	0x0024bc45, // n0x0fb0 c0x0000 (---------------)  + I paris
	0x0032c888, // n0x0fb1 c0x0000 (---------------)  + I pasadena
	0x002bb808, // n0x0fb2 c0x0000 (---------------)  + I pharmacy
	0x002bc10c, // n0x0fb3 c0x0000 (---------------)  + I philadelphia
	0x002bc110, // n0x0fb4 c0x0000 (---------------)  + I philadelphiaarea
	0x002bc7c9, // n0x0fb5 c0x0000 (---------------)  + I philately
	0x002bca07, // n0x0fb6 c0x0000 (---------------)  + I phoenix
	0x002bce4b, // n0x0fb7 c0x0000 (---------------)  + I photography
	0x002be506, // n0x0fb8 c0x0000 (---------------)  + I pilots
	0x002bef0a, // n0x0fb9 c0x0000 (---------------)  + I pittsburgh
	0x002c07cb, // n0x0fba c0x0000 (---------------)  + I planetarium
	0x002c0d0a, // n0x0fbb c0x0000 (---------------)  + I plantation
	0x002c0f86, // n0x0fbc c0x0000 (---------------)  + I plants
	0x002c1705, // n0x0fbd c0x0000 (---------------)  + I plaza
	0x002fa346, // n0x0fbe c0x0000 (---------------)  + I portal
	0x0029fc48, // n0x0fbf c0x0000 (---------------)  + I portland
	0x002c1f0a, // n0x0fc0 c0x0000 (---------------)  + I portlligat
	0x0021469c, // n0x0fc1 c0x0000 (---------------)  + I posts-and-telecommunications
	0x002c448c, // n0x0fc2 c0x0000 (---------------)  + I preservation
	0x002c4788, // n0x0fc3 c0x0000 (---------------)  + I presidio
	0x0020e2c5, // n0x0fc4 c0x0000 (---------------)  + I press
	0x002c6187, // n0x0fc5 c0x0000 (---------------)  + I project
	0x0029d706, // n0x0fc6 c0x0000 (---------------)  + I public
	0x0033df45, // n0x0fc7 c0x0000 (---------------)  + I pubol
	0x00351cc6, // n0x0fc8 c0x0000 (---------------)  + I quebec
	0x0026c808, // n0x0fc9 c0x0000 (---------------)  + I railroad
	0x0028f6c7, // n0x0fca c0x0000 (---------------)  + I railway
	0x002c31c8, // n0x0fcb c0x0000 (---------------)  + I research
	0x0033860a, // n0x0fcc c0x0000 (---------------)  + I resistance
	0x0022c34c, // n0x0fcd c0x0000 (---------------)  + I riodejaneiro
	0x002c14c9, // n0x0fce c0x0000 (---------------)  + I rochester
	0x00350407, // n0x0fcf c0x0000 (---------------)  + I rockart
	0x002952c4, // n0x0fd0 c0x0000 (---------------)  + I roma
	0x0023ac46, // n0x0fd1 c0x0000 (---------------)  + I russia
	0x0026e08a, // n0x0fd2 c0x0000 (---------------)  + I saintlouis
	0x002dc285, // n0x0fd3 c0x0000 (---------------)  + I salem
	0x0023680c, // n0x0fd4 c0x0000 (---------------)  + I salvadordali
	0x0023dec8, // n0x0fd5 c0x0000 (---------------)  + I salzburg
	0x002db848, // n0x0fd6 c0x0000 (---------------)  + I sandiego
	0x0024558c, // n0x0fd7 c0x0000 (---------------)  + I sanfrancisco
	0x0024eecc, // n0x0fd8 c0x0000 (---------------)  + I santabarbara
	0x00251289, // n0x0fd9 c0x0000 (---------------)  + I santacruz
	0x00252247, // n0x0fda c0x0000 (---------------)  + I santafe
	0x0027620c, // n0x0fdb c0x0000 (---------------)  + I saskatchewan
	0x0027f584, // n0x0fdc c0x0000 (---------------)  + I satx
	0x0028cd0a, // n0x0fdd c0x0000 (---------------)  + I savannahga
	0x0022198c, // n0x0fde c0x0000 (---------------)  + I schlesisches
	0x0025ae8b, // n0x0fdf c0x0000 (---------------)  + I schoenbrunn
	0x002d548b, // n0x0fe0 c0x0000 (---------------)  + I schokoladen
	0x002daa06, // n0x0fe1 c0x0000 (---------------)  + I school
	0x0031e807, // n0x0fe2 c0x0000 (---------------)  + I schweiz
	0x00201e47, // n0x0fe3 c0x0000 (---------------)  + I science
	0x002312cf, // n0x0fe4 c0x0000 (---------------)  + I science-fiction
	0x002e0c11, // n0x0fe5 c0x0000 (---------------)  + I scienceandhistory
	0x0033ea12, // n0x0fe6 c0x0000 (---------------)  + I scienceandindustry
	0x002e6f4d, // n0x0fe7 c0x0000 (---------------)  + I sciencecenter
	0x002e6f4e, // n0x0fe8 c0x0000 (---------------)  + I sciencecenters
	0x002e728e, // n0x0fe9 c0x0000 (---------------)  + I sciencehistory
	0x00201e48, // n0x0fea c0x0000 (---------------)  + I sciences
	0x00201e52, // n0x0feb c0x0000 (---------------)  + I sciencesnaturelles
	0x00208f48, // n0x0fec c0x0000 (---------------)  + I scotland
	0x002e5347, // n0x0fed c0x0000 (---------------)  + I seaport
	0x0031bf8a, // n0x0fee c0x0000 (---------------)  + I settlement
	0x0020f088, // n0x0fef c0x0000 (---------------)  + I settlers
	0x002ff945, // n0x0ff0 c0x0000 (---------------)  + I shell
	0x0030134a, // n0x0ff1 c0x0000 (---------------)  + I sherbrooke
	0x00205ac7, // n0x0ff2 c0x0000 (---------------)  + I sibenik
	0x002f5144, // n0x0ff3 c0x0000 (---------------)  + I silk
	0x0021dac3, // n0x0ff4 c0x0000 (---------------)  + I ski
	0x0021b585, // n0x0ff5 c0x0000 (---------------)  + I skole
	0x002fe207, // n0x0ff6 c0x0000 (---------------)  + I society
	0x002d8347, // n0x0ff7 c0x0000 (---------------)  + I sologne
	0x002cf48e, // n0x0ff8 c0x0000 (---------------)  + I soundandvision
	0x002d730d, // n0x0ff9 c0x0000 (---------------)  + I southcarolina
	0x002d7749, // n0x0ffa c0x0000 (---------------)  + I southwest
	0x002d7f45, // n0x0ffb c0x0000 (---------------)  + I space
	0x002d9c83, // n0x0ffc c0x0000 (---------------)  + I spy
	0x002d9ec6, // n0x0ffd c0x0000 (---------------)  + I square
	0x0024d0c5, // n0x0ffe c0x0000 (---------------)  + I stadt
	0x00224e88, // n0x0fff c0x0000 (---------------)  + I stalbans
	0x002d8f49, // n0x1000 c0x0000 (---------------)  + I starnberg
	0x0026f005, // n0x1001 c0x0000 (---------------)  + I state
	0x0026f00f, // n0x1002 c0x0000 (---------------)  + I stateofdelaware
	0x002a4147, // n0x1003 c0x0000 (---------------)  + I station
	0x002c6405, // n0x1004 c0x0000 (---------------)  + I steam
	0x0035340a, // n0x1005 c0x0000 (---------------)  + I steiermark
	0x002dca46, // n0x1006 c0x0000 (---------------)  + I stjohn
	0x002dcf89, // n0x1007 c0x0000 (---------------)  + I stockholm
	0x002ddccc, // n0x1008 c0x0000 (---------------)  + I stpetersburg
	0x002de449, // n0x1009 c0x0000 (---------------)  + I stuttgart
	0x00218a06, // n0x100a c0x0000 (---------------)  + I suisse
	0x00248ecc, // n0x100b c0x0000 (---------------)  + I surgeonshall
	0x002e0506, // n0x100c c0x0000 (---------------)  + I surrey
	0x002dff08, // n0x100d c0x0000 (---------------)  + I svizzera
	0x00289f46, // n0x100e c0x0000 (---------------)  + I sweden
	0x00263e46, // n0x100f c0x0000 (---------------)  + I sydney
	0x002e7c04, // n0x1010 c0x0000 (---------------)  + I tank
	0x00345f43, // n0x1011 c0x0000 (---------------)  + I tcm
	0x003449ca, // n0x1012 c0x0000 (---------------)  + I technology
	0x002c53d1, // n0x1013 c0x0000 (---------------)  + I telekommunikation
	0x002362ca, // n0x1014 c0x0000 (---------------)  + I television
	0x00237945, // n0x1015 c0x0000 (---------------)  + I texas
	0x00239907, // n0x1016 c0x0000 (---------------)  + I textile
	0x002fc247, // n0x1017 c0x0000 (---------------)  + I theater
	0x00253384, // n0x1018 c0x0000 (---------------)  + I time
	0x0025338b, // n0x1019 c0x0000 (---------------)  + I timekeeping
	0x002f34c8, // n0x101a c0x0000 (---------------)  + I topology
	0x0029b9c6, // n0x101b c0x0000 (---------------)  + I torino
	0x0023e205, // n0x101c c0x0000 (---------------)  + I touch
	0x0024c504, // n0x101d c0x0000 (---------------)  + I town
	0x0034a889, // n0x101e c0x0000 (---------------)  + I transport
	0x002b0804, // n0x101f c0x0000 (---------------)  + I tree
	0x00265d87, // n0x1020 c0x0000 (---------------)  + I trolley
	0x002de645, // n0x1021 c0x0000 (---------------)  + I trust
	0x002de647, // n0x1022 c0x0000 (---------------)  + I trustee
	0x002b6f85, // n0x1023 c0x0000 (---------------)  + I uhren
	0x0020a9c3, // n0x1024 c0x0000 (---------------)  + I ulm
	0x002e5208, // n0x1025 c0x0000 (---------------)  + I undersea
	0x00207f4a, // n0x1026 c0x0000 (---------------)  + I university
	0x0022dec3, // n0x1027 c0x0000 (---------------)  + I usa
	0x0022f34a, // n0x1028 c0x0000 (---------------)  + I usantiques
	0x002fb346, // n0x1029 c0x0000 (---------------)  + I usarts
	0x0026ed8f, // n0x102a c0x0000 (---------------)  + I uscountryestate
	0x0034cb49, // n0x102b c0x0000 (---------------)  + I usculture
	0x00254210, // n0x102c c0x0000 (---------------)  + I usdecorativearts
	0x00292ec8, // n0x102d c0x0000 (---------------)  + I usgarden
	0x002b0b89, // n0x102e c0x0000 (---------------)  + I ushistory
	0x002b3947, // n0x102f c0x0000 (---------------)  + I ushuaia
	0x003366cf, // n0x1030 c0x0000 (---------------)  + I uslivinghistory
	0x00235e84, // n0x1031 c0x0000 (---------------)  + I utah
	0x0022fac4, // n0x1032 c0x0000 (---------------)  + I uvic
	0x00218846, // n0x1033 c0x0000 (---------------)  + I valley
	0x0029af86, // n0x1034 c0x0000 (---------------)  + I vantaa
	0x0027510a, // n0x1035 c0x0000 (---------------)  + I versailles
	0x002da1c6, // n0x1036 c0x0000 (---------------)  + I viking
	0x0030ea87, // n0x1037 c0x0000 (---------------)  + I village
	0x002e2f48, // n0x1038 c0x0000 (---------------)  + I virginia
	0x002e3147, // n0x1039 c0x0000 (---------------)  + I virtual
	0x002e3307, // n0x103a c0x0000 (---------------)  + I virtuel
	0x002f0a0a, // n0x103b c0x0000 (---------------)  + I vlaanderen
	0x002e504b, // n0x103c c0x0000 (---------------)  + I volkenkunde
	0x00263505, // n0x103d c0x0000 (---------------)  + I wales
	0x0033e648, // n0x103e c0x0000 (---------------)  + I wallonie
	0x0020a683, // n0x103f c0x0000 (---------------)  + I war
	0x0020014c, // n0x1040 c0x0000 (---------------)  + I washingtondc
	0x0021ba8f, // n0x1041 c0x0000 (---------------)  + I watch-and-clock
	0x0020094d, // n0x1042 c0x0000 (---------------)  + I watchandclock
	0x002d7887, // n0x1043 c0x0000 (---------------)  + I western
	0x00225709, // n0x1044 c0x0000 (---------------)  + I westfalen
	0x002a1ec7, // n0x1045 c0x0000 (---------------)  + I whaling
	0x002c9cc8, // n0x1046 c0x0000 (---------------)  + I wildlife
	0x0023a0cc, // n0x1047 c0x0000 (---------------)  + I williamsburg
	0x0031cf88, // n0x1048 c0x0000 (---------------)  + I windmill
	0x00227dc8, // n0x1049 c0x0000 (---------------)  + I workshop
	0x002e760e, // n0x104a c0x0000 (---------------)  + I xn--9dbhblg6di
	0x002f6694, // n0x104b c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x002f6ba4, // n0x104c c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x00308bca, // n0x104d c0x0000 (---------------)  + I xn--h1aegh
	0x0031e24b, // n0x104e c0x0000 (---------------)  + I xn--lns-qla
	0x0023b8c4, // n0x104f c0x0000 (---------------)  + I york
	0x0023b8c9, // n0x1050 c0x0000 (---------------)  + I yorkshire
	0x003116c8, // n0x1051 c0x0000 (---------------)  + I yosemite
	0x0028eac5, // n0x1052 c0x0000 (---------------)  + I youth
	0x0026f40a, // n0x1053 c0x0000 (---------------)  + I zoological
	0x0022f007, // n0x1054 c0x0000 (---------------)  + I zoology
	0x002251c4, // n0x1055 c0x0000 (---------------)  + I aero
	0x002b5183, // n0x1056 c0x0000 (---------------)  + I biz
	0x002104c3, // n0x1057 c0x0000 (---------------)  + I com
	0x00236044, // n0x1058 c0x0000 (---------------)  + I coop
	0x002ceec3, // n0x1059 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x105a c0x0000 (---------------)  + I gov
	0x002180c4, // n0x105b c0x0000 (---------------)  + I info
	0x0021fe43, // n0x105c c0x0000 (---------------)  + I int
	0x0025f683, // n0x105d c0x0000 (---------------)  + I mil
	0x002b9786, // n0x105e c0x0000 (---------------)  + I museum
	0x002d16c4, // n0x105f c0x0000 (---------------)  + I name
	0x00239bc3, // n0x1060 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1061 c0x0000 (---------------)  + I org
	0x002c5983, // n0x1062 c0x0000 (---------------)  + I pro
	0x002028c2, // n0x1063 c0x0000 (---------------)  + I ac
	0x002b5183, // n0x1064 c0x0000 (---------------)  + I biz
	0x00208f82, // n0x1065 c0x0000 (---------------)  + I co
	0x002104c3, // n0x1066 c0x0000 (---------------)  + I com
	0x00236044, // n0x1067 c0x0000 (---------------)  + I coop
	0x002ceec3, // n0x1068 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1069 c0x0000 (---------------)  + I gov
	0x0021fe43, // n0x106a c0x0000 (---------------)  + I int
	0x002b9786, // n0x106b c0x0000 (---------------)  + I museum
	0x00239bc3, // n0x106c c0x0000 (---------------)  + I net
	0x002453c3, // n0x106d c0x0000 (---------------)  + I org
	0x00031c88, // n0x106e c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x106f c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1070 c0x0000 (---------------)  + I edu
	0x00230083, // n0x1071 c0x0000 (---------------)  + I gob
	0x00239bc3, // n0x1072 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1073 c0x0000 (---------------)  + I org
	0x002104c3, // n0x1074 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1075 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1076 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x1077 c0x0000 (---------------)  + I mil
	0x002d16c4, // n0x1078 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x1079 c0x0000 (---------------)  + I net
	0x002453c3, // n0x107a c0x0000 (---------------)  + I org
	0x0068bb08, // n0x107b c0x0001 (---------------)  ! I teledata
	0x00200402, // n0x107c c0x0000 (---------------)  + I ca
	0x00201942, // n0x107d c0x0000 (---------------)  + I cc
	0x00208f82, // n0x107e c0x0000 (---------------)  + I co
	0x002104c3, // n0x107f c0x0000 (---------------)  + I com
	0x00203a42, // n0x1080 c0x0000 (---------------)  + I dr
	0x00200242, // n0x1081 c0x0000 (---------------)  + I in
	0x002180c4, // n0x1082 c0x0000 (---------------)  + I info
	0x0020adc4, // n0x1083 c0x0000 (---------------)  + I mobi
	0x0032a542, // n0x1084 c0x0000 (---------------)  + I mx
	0x002d16c4, // n0x1085 c0x0000 (---------------)  + I name
	0x00204282, // n0x1086 c0x0000 (---------------)  + I or
	0x002453c3, // n0x1087 c0x0000 (---------------)  + I org
	0x002c5983, // n0x1088 c0x0000 (---------------)  + I pro
	0x002daa06, // n0x1089 c0x0000 (---------------)  + I school
	0x0027ecc2, // n0x108a c0x0000 (---------------)  + I tv
	0x00202342, // n0x108b c0x0000 (---------------)  + I us
	0x0021c282, // n0x108c c0x0000 (---------------)  + I ws
	0x31e1a783, // n0x108d c0x00c7 (n0x108f-n0x1090)  o I her
	0x32204183, // n0x108e c0x00c8 (n0x1090-n0x1091)  o I his
	0x00045386, // n0x108f c0x0000 (---------------)  +   forgot
	0x00045386, // n0x1090 c0x0000 (---------------)  +   forgot
	0x00202f44, // n0x1091 c0x0000 (---------------)  + I asso
	0x00002bcc, // n0x1092 c0x0000 (---------------)  +   at-band-camp
	0x0000be47, // n0x1093 c0x0000 (---------------)  +   blogdns
	0x0001e988, // n0x1094 c0x0000 (---------------)  +   broke-it
	0x000721ca, // n0x1095 c0x0000 (---------------)  +   buyshouses
	0x0002c08a, // n0x1096 c0x0000 (---------------)  +   cloudfront
	0x00032888, // n0x1097 c0x0000 (---------------)  +   dnsalias
	0x0005a447, // n0x1098 c0x0000 (---------------)  +   dnsdojo
	0x00030187, // n0x1099 c0x0000 (---------------)  +   does-it
	0x0010c549, // n0x109a c0x0000 (---------------)  +   dontexist
	0x00078ac8, // n0x109b c0x0000 (---------------)  +   dynalias
	0x0003bbc9, // n0x109c c0x0000 (---------------)  +   dynathome
	0x0008b5cd, // n0x109d c0x0000 (---------------)  +   endofinternet
	0x32f05246, // n0x109e c0x00cb (n0x10bd-n0x10bf)  o I fastly
	0x0004b507, // n0x109f c0x0000 (---------------)  +   from-az
	0x0004bf47, // n0x10a0 c0x0000 (---------------)  +   from-co
	0x0004fd07, // n0x10a1 c0x0000 (---------------)  +   from-la
	0x00057c07, // n0x10a2 c0x0000 (---------------)  +   from-ny
	0x00072c02, // n0x10a3 c0x0000 (---------------)  +   gb
	0x00034e47, // n0x10a4 c0x0000 (---------------)  +   gets-it
	0x00058f8c, // n0x10a5 c0x0000 (---------------)  +   ham-radio-op
	0x00011207, // n0x10a6 c0x0000 (---------------)  +   homeftp
	0x0012c746, // n0x10a7 c0x0000 (---------------)  +   homeip
	0x00089109, // n0x10a8 c0x0000 (---------------)  +   homelinux
	0x000896c8, // n0x10a9 c0x0000 (---------------)  +   homeunix
	0x0003d6c2, // n0x10aa c0x0000 (---------------)  +   hu
	0x0010c80b, // n0x10ab c0x0000 (---------------)  +   in-the-band
	0x00105049, // n0x10ac c0x0000 (---------------)  +   is-a-chef
	0x0005a6c9, // n0x10ad c0x0000 (---------------)  +   is-a-geek
	0x00043088, // n0x10ae c0x0000 (---------------)  +   isa-geek
	0x00090082, // n0x10af c0x0000 (---------------)  +   jp
	0x000a0209, // n0x10b0 c0x0000 (---------------)  +   kicks-ass
	0x00016f8d, // n0x10b1 c0x0000 (---------------)  +   office-on-the
	0x000c2e47, // n0x10b2 c0x0000 (---------------)  +   podzone
	0x000b114d, // n0x10b3 c0x0000 (---------------)  +   scrapper-site
	0x00000482, // n0x10b4 c0x0000 (---------------)  +   se
	0x00108ec6, // n0x10b5 c0x0000 (---------------)  +   selfip
	0x000b3c88, // n0x10b6 c0x0000 (---------------)  +   sells-it
	0x000c10c8, // n0x10b7 c0x0000 (---------------)  +   servebbs
	0x000c1288, // n0x10b8 c0x0000 (---------------)  +   serveftp
	0x0001a688, // n0x10b9 c0x0000 (---------------)  +   thruhere
	0x00003ec2, // n0x10ba c0x0000 (---------------)  +   uk
	0x00017306, // n0x10bb c0x0000 (---------------)  +   webhop
	0x00002702, // n0x10bc c0x0000 (---------------)  +   za
	0x332c5c04, // n0x10bd c0x00cc (n0x10bf-n0x10c1)  o I prod
	0x33648903, // n0x10be c0x00cd (n0x10c1-n0x10c4)  o I ssl
	0x00000101, // n0x10bf c0x0000 (---------------)  +   a
	0x000a2046, // n0x10c0 c0x0000 (---------------)  +   global
	0x00000101, // n0x10c1 c0x0000 (---------------)  +   a
	0x00000001, // n0x10c2 c0x0000 (---------------)  +   b
	0x000a2046, // n0x10c3 c0x0000 (---------------)  +   global
	0x0023fec4, // n0x10c4 c0x0000 (---------------)  + I arts
	0x002104c3, // n0x10c5 c0x0000 (---------------)  + I com
	0x00240684, // n0x10c6 c0x0000 (---------------)  + I firm
	0x002180c4, // n0x10c7 c0x0000 (---------------)  + I info
	0x00239bc3, // n0x10c8 c0x0000 (---------------)  + I net
	0x00248705, // n0x10c9 c0x0000 (---------------)  + I other
	0x0020f983, // n0x10ca c0x0000 (---------------)  + I per
	0x002a8343, // n0x10cb c0x0000 (---------------)  + I rec
	0x002dd805, // n0x10cc c0x0000 (---------------)  + I store
	0x00209243, // n0x10cd c0x0000 (---------------)  + I web
	0x002104c3, // n0x10ce c0x0000 (---------------)  + I com
	0x002ceec3, // n0x10cf c0x0000 (---------------)  + I edu
	0x002150c3, // n0x10d0 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x10d1 c0x0000 (---------------)  + I mil
	0x0020adc4, // n0x10d2 c0x0000 (---------------)  + I mobi
	0x002d16c4, // n0x10d3 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x10d4 c0x0000 (---------------)  + I net
	0x002453c3, // n0x10d5 c0x0000 (---------------)  + I org
	0x00204343, // n0x10d6 c0x0000 (---------------)  + I sch
	0x00031c88, // n0x10d7 c0x0000 (---------------)  +   blogspot
	0x00223ac2, // n0x10d8 c0x0000 (---------------)  + I bv
	0x00008f82, // n0x10d9 c0x0000 (---------------)  +   co
	0x34a01602, // n0x10da c0x00d2 (n0x13b0-n0x13b1)  + I aa
	0x002fad08, // n0x10db c0x0000 (---------------)  + I aarborte
	0x00221746, // n0x10dc c0x0000 (---------------)  + I aejrie
	0x00207406, // n0x10dd c0x0000 (---------------)  + I afjord
	0x002210c7, // n0x10de c0x0000 (---------------)  + I agdenes
	0x34e03682, // n0x10df c0x00d3 (n0x13b1-n0x13b2)  + I ah
	0x3526ec08, // n0x10e0 c0x00d4 (n0x13b2-n0x13b3)  o I akershus
	0x0027988a, // n0x10e1 c0x0000 (---------------)  + I aknoluokta
	0x00203b48, // n0x10e2 c0x0000 (---------------)  + I akrehamn
	0x00201dc2, // n0x10e3 c0x0000 (---------------)  + I al
	0x00203609, // n0x10e4 c0x0000 (---------------)  + I alaheadju
	0x00263547, // n0x10e5 c0x0000 (---------------)  + I alesund
	0x00213286, // n0x10e6 c0x0000 (---------------)  + I algard
	0x0030fd89, // n0x10e7 c0x0000 (---------------)  + I alstahaug
	0x00238404, // n0x10e8 c0x0000 (---------------)  + I alta
	0x00203206, // n0x10e9 c0x0000 (---------------)  + I alvdal
	0x002f98c4, // n0x10ea c0x0000 (---------------)  + I amli
	0x0020a744, // n0x10eb c0x0000 (---------------)  + I amot
	0x00246989, // n0x10ec c0x0000 (---------------)  + I andasuolo
	0x00349846, // n0x10ed c0x0000 (---------------)  + I andebu
	0x002236c5, // n0x10ee c0x0000 (---------------)  + I andoy
	0x0024a805, // n0x10ef c0x0000 (---------------)  + I ardal
	0x0024e047, // n0x10f0 c0x0000 (---------------)  + I aremark
	0x002d9f87, // n0x10f1 c0x0000 (---------------)  + I arendal
	0x0024a744, // n0x10f2 c0x0000 (---------------)  + I arna
	0x00221306, // n0x10f3 c0x0000 (---------------)  + I aseral
	0x0025ac05, // n0x10f4 c0x0000 (---------------)  + I asker
	0x002d8b45, // n0x10f5 c0x0000 (---------------)  + I askim
	0x002ffa85, // n0x10f6 c0x0000 (---------------)  + I askoy
	0x0033a347, // n0x10f7 c0x0000 (---------------)  + I askvoll
	0x002f89c5, // n0x10f8 c0x0000 (---------------)  + I asnes
	0x002f7849, // n0x10f9 c0x0000 (---------------)  + I audnedaln
	0x0022e345, // n0x10fa c0x0000 (---------------)  + I aukra
	0x002c78c4, // n0x10fb c0x0000 (---------------)  + I aure
	0x00349747, // n0x10fc c0x0000 (---------------)  + I aurland
	0x002a7f8e, // n0x10fd c0x0000 (---------------)  + I aurskog-holand
	0x002ec009, // n0x10fe c0x0000 (---------------)  + I austevoll
	0x002b6c09, // n0x10ff c0x0000 (---------------)  + I austrheim
	0x0023ea46, // n0x1100 c0x0000 (---------------)  + I averoy
	0x00308048, // n0x1101 c0x0000 (---------------)  + I badaddja
	0x002bf7cb, // n0x1102 c0x0000 (---------------)  + I bahcavuotna
	0x0028dacc, // n0x1103 c0x0000 (---------------)  + I bahccavuotna
	0x00288bc6, // n0x1104 c0x0000 (---------------)  + I baidar
	0x0032b207, // n0x1105 c0x0000 (---------------)  + I bajddar
	0x002a2105, // n0x1106 c0x0000 (---------------)  + I balat
	0x002ed40a, // n0x1107 c0x0000 (---------------)  + I balestrand
	0x0028be09, // n0x1108 c0x0000 (---------------)  + I ballangen
	0x002a6349, // n0x1109 c0x0000 (---------------)  + I balsfjord
	0x0034ed06, // n0x110a c0x0000 (---------------)  + I bamble
	0x002df6c5, // n0x110b c0x0000 (---------------)  + I bardu
	0x00310985, // n0x110c c0x0000 (---------------)  + I barum
	0x00338d09, // n0x110d c0x0000 (---------------)  + I batsfjord
	0x002b560b, // n0x110e c0x0000 (---------------)  + I bearalvahki
	0x00263146, // n0x110f c0x0000 (---------------)  + I beardu
	0x0021b006, // n0x1110 c0x0000 (---------------)  + I beiarn
	0x00241b04, // n0x1111 c0x0000 (---------------)  + I berg
	0x00241b06, // n0x1112 c0x0000 (---------------)  + I bergen
	0x002bba08, // n0x1113 c0x0000 (---------------)  + I berlevag
	0x00202ac6, // n0x1114 c0x0000 (---------------)  + I bievat
	0x00259d86, // n0x1115 c0x0000 (---------------)  + I bindal
	0x0020d008, // n0x1116 c0x0000 (---------------)  + I birkenes
	0x0020eb47, // n0x1117 c0x0000 (---------------)  + I bjarkoy
	0x0020f749, // n0x1118 c0x0000 (---------------)  + I bjerkreim
	0x0020fac5, // n0x1119 c0x0000 (---------------)  + I bjugn
	0x00031c88, // n0x111a c0x0000 (---------------)  +   blogspot
	0x00230104, // n0x111b c0x0000 (---------------)  + I bodo
	0x00275444, // n0x111c c0x0000 (---------------)  + I bokn
	0x00211a05, // n0x111d c0x0000 (---------------)  + I bomlo
	0x00219889, // n0x111e c0x0000 (---------------)  + I bremanger
	0x0021f547, // n0x111f c0x0000 (---------------)  + I bronnoy
	0x0021f54b, // n0x1120 c0x0000 (---------------)  + I bronnoysund
	0x0022014a, // n0x1121 c0x0000 (---------------)  + I brumunddal
	0x002232c5, // n0x1122 c0x0000 (---------------)  + I bryne
	0x35606742, // n0x1123 c0x00d5 (n0x13b3-n0x13b4)  + I bu
	0x00240f07, // n0x1124 c0x0000 (---------------)  + I budejju
	0x35a78648, // n0x1125 c0x00d6 (n0x13b4-n0x13b5)  o I buskerud
	0x00214087, // n0x1126 c0x0000 (---------------)  + I bygland
	0x002cb005, // n0x1127 c0x0000 (---------------)  + I bykle
	0x002a91ca, // n0x1128 c0x0000 (---------------)  + I cahcesuolo
	0x00008f82, // n0x1129 c0x0000 (---------------)  +   co
	0x0022e7cb, // n0x112a c0x0000 (---------------)  + I davvenjarga
	0x0026a04a, // n0x112b c0x0000 (---------------)  + I davvesiida
	0x00350246, // n0x112c c0x0000 (---------------)  + I deatnu
	0x0023e483, // n0x112d c0x0000 (---------------)  + I dep
	0x002a9b8d, // n0x112e c0x0000 (---------------)  + I dielddanuorri
	0x002eb58c, // n0x112f c0x0000 (---------------)  + I divtasvuodna
	0x002b664d, // n0x1130 c0x0000 (---------------)  + I divttasvuotna
	0x0021a1c5, // n0x1131 c0x0000 (---------------)  + I donna
	0x0032fd05, // n0x1132 c0x0000 (---------------)  + I dovre
	0x00298f47, // n0x1133 c0x0000 (---------------)  + I drammen
	0x00351649, // n0x1134 c0x0000 (---------------)  + I drangedal
	0x00203a46, // n0x1135 c0x0000 (---------------)  + I drobak
	0x00229845, // n0x1136 c0x0000 (---------------)  + I dyroy
	0x0029a108, // n0x1137 c0x0000 (---------------)  + I egersund
	0x00272a43, // n0x1138 c0x0000 (---------------)  + I eid
	0x00324788, // n0x1139 c0x0000 (---------------)  + I eidfjord
	0x00272a48, // n0x113a c0x0000 (---------------)  + I eidsberg
	0x002a58c7, // n0x113b c0x0000 (---------------)  + I eidskog
	0x002f4908, // n0x113c c0x0000 (---------------)  + I eidsvoll
	0x002a9989, // n0x113d c0x0000 (---------------)  + I eigersund
	0x002fcf47, // n0x113e c0x0000 (---------------)  + I elverum
	0x00205f07, // n0x113f c0x0000 (---------------)  + I enebakk
	0x0030fc08, // n0x1140 c0x0000 (---------------)  + I engerdal
	0x002e9104, // n0x1141 c0x0000 (---------------)  + I etne
	0x002e9107, // n0x1142 c0x0000 (---------------)  + I etnedal
	0x002058c8, // n0x1143 c0x0000 (---------------)  + I evenassi
	0x00213e86, // n0x1144 c0x0000 (---------------)  + I evenes
	0x00350f0f, // n0x1145 c0x0000 (---------------)  + I evje-og-hornnes
	0x002bf247, // n0x1146 c0x0000 (---------------)  + I farsund
	0x0031bc46, // n0x1147 c0x0000 (---------------)  + I fauske
	0x00252385, // n0x1148 c0x0000 (---------------)  + I fedje
	0x00319f43, // n0x1149 c0x0000 (---------------)  + I fet
	0x00329f47, // n0x114a c0x0000 (---------------)  + I fetsund
	0x00333143, // n0x114b c0x0000 (---------------)  + I fhs
	0x00240346, // n0x114c c0x0000 (---------------)  + I finnoy
	0x00240a46, // n0x114d c0x0000 (---------------)  + I fitjar
	0x00241506, // n0x114e c0x0000 (---------------)  + I fjaler
	0x002769c5, // n0x114f c0x0000 (---------------)  + I fjell
	0x0024cfc3, // n0x1150 c0x0000 (---------------)  + I fla
	0x0024cfc8, // n0x1151 c0x0000 (---------------)  + I flakstad
	0x0032e909, // n0x1152 c0x0000 (---------------)  + I flatanger
	0x0024174b, // n0x1153 c0x0000 (---------------)  + I flekkefjord
	0x00241a08, // n0x1154 c0x0000 (---------------)  + I flesberg
	0x002427c5, // n0x1155 c0x0000 (---------------)  + I flora
	0x00242cc5, // n0x1156 c0x0000 (---------------)  + I floro
	0x35f32782, // n0x1157 c0x00d7 (n0x13b5-n0x13b6)  + I fm
	0x0022b7c9, // n0x1158 c0x0000 (---------------)  + I folkebibl
	0x002438c7, // n0x1159 c0x0000 (---------------)  + I folldal
	0x00350185, // n0x115a c0x0000 (---------------)  + I forde
	0x00246887, // n0x115b c0x0000 (---------------)  + I forsand
	0x00248106, // n0x115c c0x0000 (---------------)  + I fosnes
	0x00322085, // n0x115d c0x0000 (---------------)  + I frana
	0x0024944b, // n0x115e c0x0000 (---------------)  + I fredrikstad
	0x00249984, // n0x115f c0x0000 (---------------)  + I frei
	0x0024a945, // n0x1160 c0x0000 (---------------)  + I frogn
	0x0024aa87, // n0x1161 c0x0000 (---------------)  + I froland
	0x0025ec46, // n0x1162 c0x0000 (---------------)  + I frosta
	0x0025ef05, // n0x1163 c0x0000 (---------------)  + I froya
	0x00268687, // n0x1164 c0x0000 (---------------)  + I fuoisku
	0x00268a47, // n0x1165 c0x0000 (---------------)  + I fuossko
	0x002d1484, // n0x1166 c0x0000 (---------------)  + I fusa
	0x0026d04a, // n0x1167 c0x0000 (---------------)  + I fylkesbibl
	0x0026d2c8, // n0x1168 c0x0000 (---------------)  + I fyresdal
	0x00344689, // n0x1169 c0x0000 (---------------)  + I gaivuotna
	0x0022ea05, // n0x116a c0x0000 (---------------)  + I galsa
	0x0021ad46, // n0x116b c0x0000 (---------------)  + I gamvik
	0x002bbbca, // n0x116c c0x0000 (---------------)  + I gangaviika
	0x002bbec6, // n0x116d c0x0000 (---------------)  + I gaular
	0x0024dac7, // n0x116e c0x0000 (---------------)  + I gausdal
	0x00343e4d, // n0x116f c0x0000 (---------------)  + I giehtavuoatna
	0x002a8a49, // n0x1170 c0x0000 (---------------)  + I gildeskal
	0x00327685, // n0x1171 c0x0000 (---------------)  + I giske
	0x002d9147, // n0x1172 c0x0000 (---------------)  + I gjemnes
	0x002ea1c8, // n0x1173 c0x0000 (---------------)  + I gjerdrum
	0x00318488, // n0x1174 c0x0000 (---------------)  + I gjerstad
	0x00349b07, // n0x1175 c0x0000 (---------------)  + I gjesdal
	0x00350a46, // n0x1176 c0x0000 (---------------)  + I gjovik
	0x002277c7, // n0x1177 c0x0000 (---------------)  + I gloppen
	0x002a6603, // n0x1178 c0x0000 (---------------)  + I gol
	0x002fd944, // n0x1179 c0x0000 (---------------)  + I gran
	0x00302d85, // n0x117a c0x0000 (---------------)  + I grane
	0x00320387, // n0x117b c0x0000 (---------------)  + I granvin
	0x00335689, // n0x117c c0x0000 (---------------)  + I gratangen
	0x0023d808, // n0x117d c0x0000 (---------------)  + I grimstad
	0x00333585, // n0x117e c0x0000 (---------------)  + I grong
	0x00243584, // n0x117f c0x0000 (---------------)  + I grue
	0x00249b45, // n0x1180 c0x0000 (---------------)  + I gulen
	0x0025360d, // n0x1181 c0x0000 (---------------)  + I guovdageaidnu
	0x00200a42, // n0x1182 c0x0000 (---------------)  + I ha
	0x002953c6, // n0x1183 c0x0000 (---------------)  + I habmer
	0x00308e06, // n0x1184 c0x0000 (---------------)  + I hadsel
	0x0032290a, // n0x1185 c0x0000 (---------------)  + I hagebostad
	0x0026de46, // n0x1186 c0x0000 (---------------)  + I halden
	0x0026dfc5, // n0x1187 c0x0000 (---------------)  + I halsa
	0x00344205, // n0x1188 c0x0000 (---------------)  + I hamar
	0x00344207, // n0x1189 c0x0000 (---------------)  + I hamaroy
	0x0026e70c, // n0x118a c0x0000 (---------------)  + I hammarfeasta
	0x00236bca, // n0x118b c0x0000 (---------------)  + I hammerfest
	0x00271446, // n0x118c c0x0000 (---------------)  + I hapmir
	0x002aac85, // n0x118d c0x0000 (---------------)  + I haram
	0x00272986, // n0x118e c0x0000 (---------------)  + I hareid
	0x00272f07, // n0x118f c0x0000 (---------------)  + I harstad
	0x00274cc6, // n0x1190 c0x0000 (---------------)  + I hasvik
	0x002768cc, // n0x1191 c0x0000 (---------------)  + I hattfjelldal
	0x0030fec9, // n0x1192 c0x0000 (---------------)  + I haugesund
	0x36244c47, // n0x1193 c0x00d8 (n0x13b6-n0x13b9)  o I hedmark
	0x0024ed85, // n0x1194 c0x0000 (---------------)  + I hemne
	0x0024ed86, // n0x1195 c0x0000 (---------------)  + I hemnes
	0x00277fc8, // n0x1196 c0x0000 (---------------)  + I hemsedal
	0x00286c05, // n0x1197 c0x0000 (---------------)  + I herad
	0x00288005, // n0x1198 c0x0000 (---------------)  + I hitra
	0x00288248, // n0x1199 c0x0000 (---------------)  + I hjartdal
	0x0028844a, // n0x119a c0x0000 (---------------)  + I hjelmeland
	0x36621a02, // n0x119b c0x00d9 (n0x13b9-n0x13ba)  + I hl
	0x36a71702, // n0x119c c0x00da (n0x13ba-n0x13bb)  + I hm
	0x002d2185, // n0x119d c0x0000 (---------------)  + I hobol
	0x002bf143, // n0x119e c0x0000 (---------------)  + I hof
	0x0032bc08, // n0x119f c0x0000 (---------------)  + I hokksund
	0x002886c3, // n0x11a0 c0x0000 (---------------)  + I hol
	0x00288d44, // n0x11a1 c0x0000 (---------------)  + I hole
	0x002dd0cb, // n0x11a2 c0x0000 (---------------)  + I holmestrand
	0x00345a08, // n0x11a3 c0x0000 (---------------)  + I holtalen
	0x002e2a88, // n0x11a4 c0x0000 (---------------)  + I honefoss
	0x36ea6f89, // n0x11a5 c0x00db (n0x13bb-n0x13bc)  o I hordaland
	0x0028b289, // n0x11a6 c0x0000 (---------------)  + I hornindal
	0x0028b4c6, // n0x11a7 c0x0000 (---------------)  + I horten
	0x0028c048, // n0x11a8 c0x0000 (---------------)  + I hoyanger
	0x0028c249, // n0x11a9 c0x0000 (---------------)  + I hoylandet
	0x0028cf86, // n0x11aa c0x0000 (---------------)  + I hurdal
	0x0028d105, // n0x11ab c0x0000 (---------------)  + I hurum
	0x0023da46, // n0x11ac c0x0000 (---------------)  + I hvaler
	0x0031a089, // n0x11ad c0x0000 (---------------)  + I hyllestad
	0x002b64c7, // n0x11ae c0x0000 (---------------)  + I ibestad
	0x0029ebc6, // n0x11af c0x0000 (---------------)  + I idrett
	0x002e0887, // n0x11b0 c0x0000 (---------------)  + I inderoy
	0x002eb407, // n0x11b1 c0x0000 (---------------)  + I iveland
	0x00257984, // n0x11b2 c0x0000 (---------------)  + I ivgu
	0x37219389, // n0x11b3 c0x00dc (n0x13bc-n0x13bd)  + I jan-mayen
	0x00256348, // n0x11b4 c0x0000 (---------------)  + I jessheim
	0x00315448, // n0x11b5 c0x0000 (---------------)  + I jevnaker
	0x002c8d47, // n0x11b6 c0x0000 (---------------)  + I jolster
	0x002abcc6, // n0x11b7 c0x0000 (---------------)  + I jondal
	0x00247a89, // n0x11b8 c0x0000 (---------------)  + I jorpeland
	0x002073c7, // n0x11b9 c0x0000 (---------------)  + I kafjord
	0x002e450a, // n0x11ba c0x0000 (---------------)  + I karasjohka
	0x002e6ac8, // n0x11bb c0x0000 (---------------)  + I karasjok
	0x002a6907, // n0x11bc c0x0000 (---------------)  + I karlsoy
	0x0031a5c6, // n0x11bd c0x0000 (---------------)  + I karmoy
	0x0031fb4a, // n0x11be c0x0000 (---------------)  + I kautokeino
	0x00252088, // n0x11bf c0x0000 (---------------)  + I kirkenes
	0x0028fd45, // n0x11c0 c0x0000 (---------------)  + I klabu
	0x00222e05, // n0x11c1 c0x0000 (---------------)  + I klepp
	0x002c0607, // n0x11c2 c0x0000 (---------------)  + I kommune
	0x002dfcc9, // n0x11c3 c0x0000 (---------------)  + I kongsberg
	0x002f520b, // n0x11c4 c0x0000 (---------------)  + I kongsvinger
	0x0031e5c8, // n0x11c5 c0x0000 (---------------)  + I kopervik
	0x0022e3c9, // n0x11c6 c0x0000 (---------------)  + I kraanghke
	0x00299307, // n0x11c7 c0x0000 (---------------)  + I kragero
	0x0029a30c, // n0x11c8 c0x0000 (---------------)  + I kristiansand
	0x0029a78c, // n0x11c9 c0x0000 (---------------)  + I kristiansund
	0x0029aa8a, // n0x11ca c0x0000 (---------------)  + I krodsherad
	0x0029ad0c, // n0x11cb c0x0000 (---------------)  + I krokstadelva
	0x002a4788, // n0x11cc c0x0000 (---------------)  + I kvafjord
	0x002a4988, // n0x11cd c0x0000 (---------------)  + I kvalsund
	0x002a4b84, // n0x11ce c0x0000 (---------------)  + I kvam
	0x002a5049, // n0x11cf c0x0000 (---------------)  + I kvanangen
	0x002a5289, // n0x11d0 c0x0000 (---------------)  + I kvinesdal
	0x002a54ca, // n0x11d1 c0x0000 (---------------)  + I kvinnherad
	0x002a5749, // n0x11d2 c0x0000 (---------------)  + I kviteseid
	0x002a5a87, // n0x11d3 c0x0000 (---------------)  + I kvitsoy
	0x002015cc, // n0x11d4 c0x0000 (---------------)  + I laakesvuemie
	0x0024fe46, // n0x11d5 c0x0000 (---------------)  + I lahppi
	0x0023f088, // n0x11d6 c0x0000 (---------------)  + I langevag
	0x002bbf86, // n0x11d7 c0x0000 (---------------)  + I lardal
	0x0031e486, // n0x11d8 c0x0000 (---------------)  + I larvik
	0x00327587, // n0x11d9 c0x0000 (---------------)  + I lavagis
	0x00328588, // n0x11da c0x0000 (---------------)  + I lavangen
	0x0034ee0b, // n0x11db c0x0000 (---------------)  + I leangaviika
	0x002cb0c7, // n0x11dc c0x0000 (---------------)  + I lebesby
	0x00281049, // n0x11dd c0x0000 (---------------)  + I leikanger
	0x00284e09, // n0x11de c0x0000 (---------------)  + I leirfjord
	0x0020aec7, // n0x11df c0x0000 (---------------)  + I leirvik
	0x002a6684, // n0x11e0 c0x0000 (---------------)  + I leka
	0x002c2847, // n0x11e1 c0x0000 (---------------)  + I leksvik
	0x002da106, // n0x11e2 c0x0000 (---------------)  + I lenvik
	0x002415c6, // n0x11e3 c0x0000 (---------------)  + I lerdal
	0x00222845, // n0x11e4 c0x0000 (---------------)  + I lesja
	0x002de248, // n0x11e5 c0x0000 (---------------)  + I levanger
	0x002f9944, // n0x11e6 c0x0000 (---------------)  + I lier
	0x002f9946, // n0x11e7 c0x0000 (---------------)  + I lierne
	0x00236a8b, // n0x11e8 c0x0000 (---------------)  + I lillehammer
	0x002db709, // n0x11e9 c0x0000 (---------------)  + I lillesand
	0x002d8a46, // n0x11ea c0x0000 (---------------)  + I lindas
	0x0034f549, // n0x11eb c0x0000 (---------------)  + I lindesnes
	0x00211ac6, // n0x11ec c0x0000 (---------------)  + I loabat
	0x00246b48, // n0x11ed c0x0000 (---------------)  + I lodingen
	0x002f1903, // n0x11ee c0x0000 (---------------)  + I lom
	0x0021ef45, // n0x11ef c0x0000 (---------------)  + I loppa
	0x002c22c9, // n0x11f0 c0x0000 (---------------)  + I lorenskog
	0x0020c905, // n0x11f1 c0x0000 (---------------)  + I loten
	0x002d4344, // n0x11f2 c0x0000 (---------------)  + I lund
	0x0025cb06, // n0x11f3 c0x0000 (---------------)  + I lunner
	0x00226045, // n0x11f4 c0x0000 (---------------)  + I luroy
	0x00228086, // n0x11f5 c0x0000 (---------------)  + I luster
	0x002e6107, // n0x11f6 c0x0000 (---------------)  + I lyngdal
	0x00308a46, // n0x11f7 c0x0000 (---------------)  + I lyngen
	0x0027ebcb, // n0x11f8 c0x0000 (---------------)  + I malatvuopmi
	0x0034f207, // n0x11f9 c0x0000 (---------------)  + I malselv
	0x003099c6, // n0x11fa c0x0000 (---------------)  + I malvik
	0x003327c6, // n0x11fb c0x0000 (---------------)  + I mandal
	0x0024e106, // n0x11fc c0x0000 (---------------)  + I marker
	0x0024a709, // n0x11fd c0x0000 (---------------)  + I marnardal
	0x00293d0a, // n0x11fe c0x0000 (---------------)  + I masfjorden
	0x0031d605, // n0x11ff c0x0000 (---------------)  + I masoy
	0x002b050d, // n0x1200 c0x0000 (---------------)  + I matta-varjjat
	0x00288546, // n0x1201 c0x0000 (---------------)  + I meland
	0x002492c6, // n0x1202 c0x0000 (---------------)  + I meldal
	0x00254106, // n0x1203 c0x0000 (---------------)  + I melhus
	0x00249ec5, // n0x1204 c0x0000 (---------------)  + I meloy
	0x0026eb47, // n0x1205 c0x0000 (---------------)  + I meraker
	0x00227a87, // n0x1206 c0x0000 (---------------)  + I midsund
	0x0027adce, // n0x1207 c0x0000 (---------------)  + I midtre-gauldal
	0x0025f683, // n0x1208 c0x0000 (---------------)  + I mil
	0x002abc89, // n0x1209 c0x0000 (---------------)  + I mjondalen
	0x00291c09, // n0x120a c0x0000 (---------------)  + I mo-i-rana
	0x002ed807, // n0x120b c0x0000 (---------------)  + I moareke
	0x00331387, // n0x120c c0x0000 (---------------)  + I modalen
	0x00296b45, // n0x120d c0x0000 (---------------)  + I modum
	0x00210545, // n0x120e c0x0000 (---------------)  + I molde
	0x376d86cf, // n0x120f c0x00dd (n0x13bd-n0x13bf)  o I more-og-romsdal
	0x002b0dc7, // n0x1210 c0x0000 (---------------)  + I mosjoen
	0x002b0f88, // n0x1211 c0x0000 (---------------)  + I moskenes
	0x002b1904, // n0x1212 c0x0000 (---------------)  + I moss
	0x002b1c06, // n0x1213 c0x0000 (---------------)  + I mosvik
	0x37a3d382, // n0x1214 c0x00de (n0x13bf-n0x13c0)  + I mr
	0x002b4546, // n0x1215 c0x0000 (---------------)  + I muosat
	0x002b9786, // n0x1216 c0x0000 (---------------)  + I museum
	0x00291dce, // n0x1217 c0x0000 (---------------)  + I naamesjevuemie
	0x003245ca, // n0x1218 c0x0000 (---------------)  + I namdalseid
	0x0025cf06, // n0x1219 c0x0000 (---------------)  + I namsos
	0x002f21ca, // n0x121a c0x0000 (---------------)  + I namsskogan
	0x00342a49, // n0x121b c0x0000 (---------------)  + I nannestad
	0x0033b545, // n0x121c c0x0000 (---------------)  + I naroy
	0x002f9f08, // n0x121d c0x0000 (---------------)  + I narviika
	0x002f80c6, // n0x121e c0x0000 (---------------)  + I narvik
	0x00209ac8, // n0x121f c0x0000 (---------------)  + I naustdal
	0x0020fe08, // n0x1220 c0x0000 (---------------)  + I navuotna
	0x0029190b, // n0x1221 c0x0000 (---------------)  + I nedre-eiker
	0x002211c5, // n0x1222 c0x0000 (---------------)  + I nesna
	0x002f8a48, // n0x1223 c0x0000 (---------------)  + I nesodden
	0x0020d14c, // n0x1224 c0x0000 (---------------)  + I nesoddtangen
	0x00213f47, // n0x1225 c0x0000 (---------------)  + I nesseby
	0x00351206, // n0x1226 c0x0000 (---------------)  + I nesset
	0x0022cf08, // n0x1227 c0x0000 (---------------)  + I nissedal
	0x00203488, // n0x1228 c0x0000 (---------------)  + I nittedal
	0x37e31642, // n0x1229 c0x00df (n0x13c0-n0x13c1)  + I nl
	0x00232c8b, // n0x122a c0x0000 (---------------)  + I nord-aurdal
	0x002ffc89, // n0x122b c0x0000 (---------------)  + I nord-fron
	0x002ecd09, // n0x122c c0x0000 (---------------)  + I nord-odal
	0x002eda07, // n0x122d c0x0000 (---------------)  + I norddal
	0x0031cc48, // n0x122e c0x0000 (---------------)  + I nordkapp
	0x38210e88, // n0x122f c0x00e0 (n0x13c1-n0x13c5)  o I nordland
	0x002161cb, // n0x1230 c0x0000 (---------------)  + I nordre-land
	0x00254bc9, // n0x1231 c0x0000 (---------------)  + I nordreisa
	0x003045cd, // n0x1232 c0x0000 (---------------)  + I nore-og-uvdal
	0x00210088, // n0x1233 c0x0000 (---------------)  + I notodden
	0x00305948, // n0x1234 c0x0000 (---------------)  + I notteroy
	0x38604e02, // n0x1235 c0x00e1 (n0x13c5-n0x13c6)  + I nt
	0x003105c4, // n0x1236 c0x0000 (---------------)  + I odda
	0x38a16f82, // n0x1237 c0x00e2 (n0x13c6-n0x13c7)  + I of
	0x002760c6, // n0x1238 c0x0000 (---------------)  + I oksnes
	0x38e051c2, // n0x1239 c0x00e3 (n0x13c7-n0x13c8)  + I ol
	0x002d448a, // n0x123a c0x0000 (---------------)  + I omasvuotna
	0x00227f46, // n0x123b c0x0000 (---------------)  + I oppdal
	0x00229688, // n0x123c c0x0000 (---------------)  + I oppegard
	0x00222a88, // n0x123d c0x0000 (---------------)  + I orkanger
	0x0022ba86, // n0x123e c0x0000 (---------------)  + I orkdal
	0x00258986, // n0x123f c0x0000 (---------------)  + I orland
	0x002c6fc6, // n0x1240 c0x0000 (---------------)  + I orskog
	0x00262905, // n0x1241 c0x0000 (---------------)  + I orsta
	0x00237b44, // n0x1242 c0x0000 (---------------)  + I osen
	0x3921eec4, // n0x1243 c0x00e4 (n0x13c8-n0x13c9)  + I oslo
	0x0029d006, // n0x1244 c0x0000 (---------------)  + I osoyro
	0x002a8dc7, // n0x1245 c0x0000 (---------------)  + I osteroy
	0x396e1847, // n0x1246 c0x00e5 (n0x13c9-n0x13ca)  o I ostfold
	0x0027478b, // n0x1247 c0x0000 (---------------)  + I ostre-toten
	0x00270e09, // n0x1248 c0x0000 (---------------)  + I overhalla
	0x0032fd4a, // n0x1249 c0x0000 (---------------)  + I ovre-eiker
	0x00344344, // n0x124a c0x0000 (---------------)  + I oyer
	0x002b7188, // n0x124b c0x0000 (---------------)  + I oygarden
	0x0029e98d, // n0x124c c0x0000 (---------------)  + I oystre-slidre
	0x002c3b49, // n0x124d c0x0000 (---------------)  + I porsanger
	0x002c3d88, // n0x124e c0x0000 (---------------)  + I porsangu
	0x002c4049, // n0x124f c0x0000 (---------------)  + I porsgrunn
	0x002c5804, // n0x1250 c0x0000 (---------------)  + I priv
	0x0024cd44, // n0x1251 c0x0000 (---------------)  + I rade
	0x00264fc5, // n0x1252 c0x0000 (---------------)  + I radoy
	0x002fa94b, // n0x1253 c0x0000 (---------------)  + I rahkkeravju
	0x00345986, // n0x1254 c0x0000 (---------------)  + I raholt
	0x0029ce45, // n0x1255 c0x0000 (---------------)  + I raisa
	0x00279f09, // n0x1256 c0x0000 (---------------)  + I rakkestad
	0x002213c8, // n0x1257 c0x0000 (---------------)  + I ralingen
	0x00285504, // n0x1258 c0x0000 (---------------)  + I rana
	0x002ed589, // n0x1259 c0x0000 (---------------)  + I randaberg
	0x002bff45, // n0x125a c0x0000 (---------------)  + I rauma
	0x002d9fc8, // n0x125b c0x0000 (---------------)  + I rendalen
	0x00240dc7, // n0x125c c0x0000 (---------------)  + I rennebu
	0x002b7008, // n0x125d c0x0000 (---------------)  + I rennesoy
	0x002cc606, // n0x125e c0x0000 (---------------)  + I rindal
	0x00233e47, // n0x125f c0x0000 (---------------)  + I ringebu
	0x002a9e49, // n0x1260 c0x0000 (---------------)  + I ringerike
	0x00223089, // n0x1261 c0x0000 (---------------)  + I ringsaker
	0x0024bcc5, // n0x1262 c0x0000 (---------------)  + I risor
	0x00259a45, // n0x1263 c0x0000 (---------------)  + I rissa
	0x39a03942, // n0x1264 c0x00e6 (n0x13ca-n0x13cb)  + I rl
	0x002c7684, // n0x1265 c0x0000 (---------------)  + I roan
	0x0029e8c5, // n0x1266 c0x0000 (---------------)  + I rodoy
	0x003072c6, // n0x1267 c0x0000 (---------------)  + I rollag
	0x002d4ec5, // n0x1268 c0x0000 (---------------)  + I romsa
	0x0022c5c7, // n0x1269 c0x0000 (---------------)  + I romskog
	0x0021b485, // n0x126a c0x0000 (---------------)  + I roros
	0x0025ec84, // n0x126b c0x0000 (---------------)  + I rost
	0x002a8ec6, // n0x126c c0x0000 (---------------)  + I royken
	0x0023eb07, // n0x126d c0x0000 (---------------)  + I royrvik
	0x0023d3c6, // n0x126e c0x0000 (---------------)  + I ruovat
	0x00234d85, // n0x126f c0x0000 (---------------)  + I rygge
	0x00229308, // n0x1270 c0x0000 (---------------)  + I salangen
	0x0022f585, // n0x1271 c0x0000 (---------------)  + I salat
	0x002316c7, // n0x1272 c0x0000 (---------------)  + I saltdal
	0x00242589, // n0x1273 c0x0000 (---------------)  + I samnanger
	0x0029a50a, // n0x1274 c0x0000 (---------------)  + I sandefjord
	0x0026db47, // n0x1275 c0x0000 (---------------)  + I sandnes
	0x0026db4c, // n0x1276 c0x0000 (---------------)  + I sandnessjoen
	0x00223686, // n0x1277 c0x0000 (---------------)  + I sandoy
	0x00269049, // n0x1278 c0x0000 (---------------)  + I sarpsborg
	0x00285e85, // n0x1279 c0x0000 (---------------)  + I sauda
	0x00286b48, // n0x127a c0x0000 (---------------)  + I sauherad
	0x00222103, // n0x127b c0x0000 (---------------)  + I sel
	0x00318305, // n0x127c c0x0000 (---------------)  + I selbu
	0x0031ba45, // n0x127d c0x0000 (---------------)  + I selje
	0x003514c7, // n0x127e c0x0000 (---------------)  + I seljord
	0x39e38cc2, // n0x127f c0x00e7 (n0x13cb-n0x13cc)  + I sf
	0x00219e07, // n0x1280 c0x0000 (---------------)  + I siellak
	0x002d3286, // n0x1281 c0x0000 (---------------)  + I sigdal
	0x002192c6, // n0x1282 c0x0000 (---------------)  + I siljan
	0x002d3c06, // n0x1283 c0x0000 (---------------)  + I sirdal
	0x002033c6, // n0x1284 c0x0000 (---------------)  + I skanit
	0x0028e348, // n0x1285 c0x0000 (---------------)  + I skanland
	0x002f4745, // n0x1286 c0x0000 (---------------)  + I skaun
	0x0031bd07, // n0x1287 c0x0000 (---------------)  + I skedsmo
	0x0031bd0d, // n0x1288 c0x0000 (---------------)  + I skedsmokorset
	0x0021dac3, // n0x1289 c0x0000 (---------------)  + I ski
	0x0021dac5, // n0x128a c0x0000 (---------------)  + I skien
	0x003531c7, // n0x128b c0x0000 (---------------)  + I skierva
	0x002c65c8, // n0x128c c0x0000 (---------------)  + I skiptvet
	0x002797c5, // n0x128d c0x0000 (---------------)  + I skjak
	0x002f8ec8, // n0x128e c0x0000 (---------------)  + I skjervoy
	0x0025d406, // n0x128f c0x0000 (---------------)  + I skodje
	0x00248947, // n0x1290 c0x0000 (---------------)  + I slattum
	0x00288885, // n0x1291 c0x0000 (---------------)  + I smola
	0x00221246, // n0x1292 c0x0000 (---------------)  + I snaase
	0x00225045, // n0x1293 c0x0000 (---------------)  + I snasa
	0x0022abca, // n0x1294 c0x0000 (---------------)  + I snillfjord
	0x002a3a06, // n0x1295 c0x0000 (---------------)  + I snoasa
	0x0025c287, // n0x1296 c0x0000 (---------------)  + I sogndal
	0x0026b4c5, // n0x1297 c0x0000 (---------------)  + I sogne
	0x002d0807, // n0x1298 c0x0000 (---------------)  + I sokndal
	0x002b8f44, // n0x1299 c0x0000 (---------------)  + I sola
	0x002d42c6, // n0x129a c0x0000 (---------------)  + I solund
	0x002d4885, // n0x129b c0x0000 (---------------)  + I somna
	0x00216b4b, // n0x129c c0x0000 (---------------)  + I sondre-land
	0x003082c9, // n0x129d c0x0000 (---------------)  + I songdalen
	0x0025730a, // n0x129e c0x0000 (---------------)  + I sor-aurdal
	0x0024bd48, // n0x129f c0x0000 (---------------)  + I sor-fron
	0x002d5748, // n0x12a0 c0x0000 (---------------)  + I sor-odal
	0x002d594c, // n0x12a1 c0x0000 (---------------)  + I sor-varanger
	0x002d5c47, // n0x12a2 c0x0000 (---------------)  + I sorfold
	0x002d5e08, // n0x12a3 c0x0000 (---------------)  + I sorreisa
	0x002d6cc8, // n0x12a4 c0x0000 (---------------)  + I sortland
	0x002d6ec5, // n0x12a5 c0x0000 (---------------)  + I sorum
	0x002d970a, // n0x12a6 c0x0000 (---------------)  + I spjelkavik
	0x002d9c89, // n0x12a7 c0x0000 (---------------)  + I spydeberg
	0x3a202482, // n0x12a8 c0x00e8 (n0x13cc-n0x13cd)  + I st
	0x002d2e86, // n0x12a9 c0x0000 (---------------)  + I stange
	0x0026f004, // n0x12aa c0x0000 (---------------)  + I stat
	0x00284c49, // n0x12ab c0x0000 (---------------)  + I stathelle
	0x00301d09, // n0x12ac c0x0000 (---------------)  + I stavanger
	0x00248507, // n0x12ad c0x0000 (---------------)  + I stavern
	0x002966c7, // n0x12ae c0x0000 (---------------)  + I steigen
	0x002dc009, // n0x12af c0x0000 (---------------)  + I steinkjer
	0x002dcbc8, // n0x12b0 c0x0000 (---------------)  + I stjordal
	0x002dcbcf, // n0x12b1 c0x0000 (---------------)  + I stjordalshalsen
	0x00290a06, // n0x12b2 c0x0000 (---------------)  + I stokke
	0x002dd38b, // n0x12b3 c0x0000 (---------------)  + I stor-elvdal
	0x002dd645, // n0x12b4 c0x0000 (---------------)  + I stord
	0x002dd647, // n0x12b5 c0x0000 (---------------)  + I stordal
	0x002dda89, // n0x12b6 c0x0000 (---------------)  + I storfjord
	0x002dd206, // n0x12b7 c0x0000 (---------------)  + I strand
	0x002ed507, // n0x12b8 c0x0000 (---------------)  + I stranda
	0x0033ed85, // n0x12b9 c0x0000 (---------------)  + I stryn
	0x00232684, // n0x12ba c0x0000 (---------------)  + I sula
	0x00203106, // n0x12bb c0x0000 (---------------)  + I suldal
	0x0021f704, // n0x12bc c0x0000 (---------------)  + I sund
	0x002a3347, // n0x12bd c0x0000 (---------------)  + I sunndal
	0x0032cc88, // n0x12be c0x0000 (---------------)  + I surnadal
	0x3a6df5c8, // n0x12bf c0x00e9 (n0x13cd-n0x13ce)  + I svalbard
	0x002dfa05, // n0x12c0 c0x0000 (---------------)  + I sveio
	0x002dfb47, // n0x12c1 c0x0000 (---------------)  + I svelvik
	0x0028af49, // n0x12c2 c0x0000 (---------------)  + I sykkylven
	0x00282104, // n0x12c3 c0x0000 (---------------)  + I tana
	0x002d9a88, // n0x12c4 c0x0000 (---------------)  + I tananger
	0x3aad2648, // n0x12c5 c0x00ea (n0x13ce-n0x13d0)  o I telemark
	0x00253384, // n0x12c6 c0x0000 (---------------)  + I time
	0x00233a88, // n0x12c7 c0x0000 (---------------)  + I tingvoll
	0x002f8004, // n0x12c8 c0x0000 (---------------)  + I tinn
	0x0023fb89, // n0x12c9 c0x0000 (---------------)  + I tjeldsund
	0x00249e05, // n0x12ca c0x0000 (---------------)  + I tjome
	0x3ae3d502, // n0x12cb c0x00eb (n0x13d0-n0x13d1)  + I tm
	0x00290a45, // n0x12cc c0x0000 (---------------)  + I tokke
	0x0021ac85, // n0x12cd c0x0000 (---------------)  + I tolga
	0x00306588, // n0x12ce c0x0000 (---------------)  + I tonsberg
	0x00235347, // n0x12cf c0x0000 (---------------)  + I torsken
	0x3b209942, // n0x12d0 c0x00ec (n0x13d1-n0x13d2)  + I tr
	0x002b27c5, // n0x12d1 c0x0000 (---------------)  + I trana
	0x002dad06, // n0x12d2 c0x0000 (---------------)  + I tranby
	0x00326d46, // n0x12d3 c0x0000 (---------------)  + I tranoy
	0x002c7648, // n0x12d4 c0x0000 (---------------)  + I troandin
	0x002e4b08, // n0x12d5 c0x0000 (---------------)  + I trogstad
	0x002d4e86, // n0x12d6 c0x0000 (---------------)  + I tromsa
	0x002d8246, // n0x12d7 c0x0000 (---------------)  + I tromso
	0x00236fc9, // n0x12d8 c0x0000 (---------------)  + I trondheim
	0x002f5086, // n0x12d9 c0x0000 (---------------)  + I trysil
	0x0034768b, // n0x12da c0x0000 (---------------)  + I tvedestrand
	0x00225f45, // n0x12db c0x0000 (---------------)  + I tydal
	0x0020efc6, // n0x12dc c0x0000 (---------------)  + I tynset
	0x00238c48, // n0x12dd c0x0000 (---------------)  + I tysfjord
	0x002fe346, // n0x12de c0x0000 (---------------)  + I tysnes
	0x00296ec6, // n0x12df c0x0000 (---------------)  + I tysvar
	0x002be70a, // n0x12e0 c0x0000 (---------------)  + I ullensaker
	0x0035080a, // n0x12e1 c0x0000 (---------------)  + I ullensvang
	0x00255105, // n0x12e2 c0x0000 (---------------)  + I ulvik
	0x00266287, // n0x12e3 c0x0000 (---------------)  + I unjarga
	0x0025bc06, // n0x12e4 c0x0000 (---------------)  + I utsira
	0x3b602b82, // n0x12e5 c0x00ed (n0x13d2-n0x13d3)  + I va
	0x00353307, // n0x12e6 c0x0000 (---------------)  + I vaapste
	0x0025c1c5, // n0x12e7 c0x0000 (---------------)  + I vadso
	0x002bbb44, // n0x12e8 c0x0000 (---------------)  + I vaga
	0x002bbb45, // n0x12e9 c0x0000 (---------------)  + I vagan
	0x0023f1c6, // n0x12ea c0x0000 (---------------)  + I vagsoy
	0x002875c7, // n0x12eb c0x0000 (---------------)  + I vaksdal
	0x00218845, // n0x12ec c0x0000 (---------------)  + I valle
	0x002de2c4, // n0x12ed c0x0000 (---------------)  + I vang
	0x0021f108, // n0x12ee c0x0000 (---------------)  + I vanylven
	0x00296f85, // n0x12ef c0x0000 (---------------)  + I vardo
	0x002f4f07, // n0x12f0 c0x0000 (---------------)  + I varggat
	0x00207d05, // n0x12f1 c0x0000 (---------------)  + I varoy
	0x0022ab05, // n0x12f2 c0x0000 (---------------)  + I vefsn
	0x002937c4, // n0x12f3 c0x0000 (---------------)  + I vega
	0x002937c9, // n0x12f4 c0x0000 (---------------)  + I vegarshei
	0x0025aa48, // n0x12f5 c0x0000 (---------------)  + I vennesla
	0x00337bc6, // n0x12f6 c0x0000 (---------------)  + I verdal
	0x00261646, // n0x12f7 c0x0000 (---------------)  + I verran
	0x002f5d46, // n0x12f8 c0x0000 (---------------)  + I vestby
	0x3bad4008, // n0x12f9 c0x00ee (n0x13d3-n0x13d4)  o I vestfold
	0x002daf07, // n0x12fa c0x0000 (---------------)  + I vestnes
	0x0034af0d, // n0x12fb c0x0000 (---------------)  + I vestre-slidre
	0x002e140c, // n0x12fc c0x0000 (---------------)  + I vestre-toten
	0x002e1a09, // n0x12fd c0x0000 (---------------)  + I vestvagoy
	0x002e1c49, // n0x12fe c0x0000 (---------------)  + I vevelstad
	0x3bf15ac2, // n0x12ff c0x00ef (n0x13d4-n0x13d5)  + I vf
	0x0034a443, // n0x1300 c0x0000 (---------------)  + I vgs
	0x0020afc3, // n0x1301 c0x0000 (---------------)  + I vik
	0x0023ec05, // n0x1302 c0x0000 (---------------)  + I vikna
	0x0032048a, // n0x1303 c0x0000 (---------------)  + I vindafjord
	0x002f4d46, // n0x1304 c0x0000 (---------------)  + I voagat
	0x0022e705, // n0x1305 c0x0000 (---------------)  + I volda
	0x002e6644, // n0x1306 c0x0000 (---------------)  + I voss
	0x002e664b, // n0x1307 c0x0000 (---------------)  + I vossevangen
	0x002e82cc, // n0x1308 c0x0000 (---------------)  + I xn--andy-ira
	0x002e92cc, // n0x1309 c0x0000 (---------------)  + I xn--asky-ira
	0x002e95d5, // n0x130a c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x002edf8d, // n0x130b c0x0000 (---------------)  + I xn--avery-yua
	0x002ee70f, // n0x130c c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x002eead2, // n0x130d c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x002eef4f, // n0x130e c0x0000 (---------------)  + I xn--berlevg-jxa
	0x002ef312, // n0x130f c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x002ef793, // n0x1310 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x002efc4d, // n0x1311 c0x0000 (---------------)  + I xn--bidr-5nac
	0x002f020d, // n0x1312 c0x0000 (---------------)  + I xn--bievt-0qa
	0x002f054e, // n0x1313 c0x0000 (---------------)  + I xn--bjarky-fya
	0x002f0c8e, // n0x1314 c0x0000 (---------------)  + I xn--bjddar-pta
	0x002f118c, // n0x1315 c0x0000 (---------------)  + I xn--blt-elab
	0x002f150c, // n0x1316 c0x0000 (---------------)  + I xn--bmlo-gra
	0x002f1f8b, // n0x1317 c0x0000 (---------------)  + I xn--bod-2na
	0x002f268e, // n0x1318 c0x0000 (---------------)  + I xn--brnny-wuac
	0x002f3cd2, // n0x1319 c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x002f4b0c, // n0x131a c0x0000 (---------------)  + I xn--brum-voa
	0x002f54d0, // n0x131b c0x0000 (---------------)  + I xn--btsfjord-9za
	0x002fd292, // n0x131c c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x002fd70c, // n0x131d c0x0000 (---------------)  + I xn--dnna-gra
	0x002fe84d, // n0x131e c0x0000 (---------------)  + I xn--drbak-wua
	0x002feb8c, // n0x131f c0x0000 (---------------)  + I xn--dyry-ira
	0x002fee91, // n0x1320 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x002ff2cd, // n0x1321 c0x0000 (---------------)  + I xn--finny-yua
	0x00301f4d, // n0x1322 c0x0000 (---------------)  + I xn--fjord-lra
	0x0030228a, // n0x1323 c0x0000 (---------------)  + I xn--fl-zia
	0x0030250c, // n0x1324 c0x0000 (---------------)  + I xn--flor-jra
	0x00302b4c, // n0x1325 c0x0000 (---------------)  + I xn--frde-gra
	0x00302ecc, // n0x1326 c0x0000 (---------------)  + I xn--frna-woa
	0x00303c4c, // n0x1327 c0x0000 (---------------)  + I xn--frya-hra
	0x003053d3, // n0x1328 c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x00305b50, // n0x1329 c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x00305f50, // n0x132a c0x0000 (---------------)  + I xn--givuotna-8ya
	0x0030678d, // n0x132b c0x0000 (---------------)  + I xn--gjvik-wua
	0x00306acc, // n0x132c c0x0000 (---------------)  + I xn--gls-elac
	0x00308789, // n0x132d c0x0000 (---------------)  + I xn--h-2fa
	0x0030a50d, // n0x132e c0x0000 (---------------)  + I xn--hbmer-xqa
	0x0030a853, // n0x132f c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x0030bb51, // n0x1330 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x0030bf93, // n0x1331 c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0030ce8f, // n0x1332 c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0030d24c, // n0x1333 c0x0000 (---------------)  + I xn--hobl-ira
	0x0030d54f, // n0x1334 c0x0000 (---------------)  + I xn--holtlen-hxa
	0x0030d90d, // n0x1335 c0x0000 (---------------)  + I xn--hpmir-xqa
	0x0030dc4f, // n0x1336 c0x0000 (---------------)  + I xn--hyanger-q1a
	0x0030e010, // n0x1337 c0x0000 (---------------)  + I xn--hylandet-54a
	0x0030e40e, // n0x1338 c0x0000 (---------------)  + I xn--indery-fya
	0x00310ece, // n0x1339 c0x0000 (---------------)  + I xn--jlster-bya
	0x003118d0, // n0x133a c0x0000 (---------------)  + I xn--jrpeland-54a
	0x00311ccd, // n0x133b c0x0000 (---------------)  + I xn--karmy-yua
	0x0031200e, // n0x133c c0x0000 (---------------)  + I xn--kfjord-iua
	0x0031238c, // n0x133d c0x0000 (---------------)  + I xn--klbu-woa
	0x00312693, // n0x133e c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x0031318e, // n0x133f c0x0000 (---------------)  + I xn--krager-gya
	0x003143d0, // n0x1340 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x003147d1, // n0x1341 c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x00314c0f, // n0x1342 c0x0000 (---------------)  + I xn--krehamn-dxa
	0x00314fd3, // n0x1343 c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0031564d, // n0x1344 c0x0000 (---------------)  + I xn--ksnes-uua
	0x0031598f, // n0x1345 c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x00315d4e, // n0x1346 c0x0000 (---------------)  + I xn--kvitsy-fya
	0x00316310, // n0x1347 c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x00316709, // n0x1348 c0x0000 (---------------)  + I xn--l-1fa
	0x00316e10, // n0x1349 c0x0000 (---------------)  + I xn--laheadju-7ya
	0x0031740f, // n0x134a c0x0000 (---------------)  + I xn--langevg-jxa
	0x00317a8f, // n0x134b c0x0000 (---------------)  + I xn--ldingen-q1a
	0x00317e52, // n0x134c c0x0000 (---------------)  + I xn--leagaviika-52b
	0x0031aa0e, // n0x134d c0x0000 (---------------)  + I xn--lesund-hua
	0x0031b2cd, // n0x134e c0x0000 (---------------)  + I xn--lgrd-poac
	0x0031d74d, // n0x134f c0x0000 (---------------)  + I xn--lhppi-xqa
	0x0031da8d, // n0x1350 c0x0000 (---------------)  + I xn--linds-pra
	0x0031ec8d, // n0x1351 c0x0000 (---------------)  + I xn--loabt-0qa
	0x0031efcd, // n0x1352 c0x0000 (---------------)  + I xn--lrdal-sra
	0x0031f310, // n0x1353 c0x0000 (---------------)  + I xn--lrenskog-54a
	0x0031f70b, // n0x1354 c0x0000 (---------------)  + I xn--lt-liac
	0x0032014c, // n0x1355 c0x0000 (---------------)  + I xn--lten-gra
	0x0032070c, // n0x1356 c0x0000 (---------------)  + I xn--lury-ira
	0x00320a0c, // n0x1357 c0x0000 (---------------)  + I xn--mely-ira
	0x00320d0e, // n0x1358 c0x0000 (---------------)  + I xn--merker-kua
	0x00326410, // n0x1359 c0x0000 (---------------)  + I xn--mjndalen-64a
	0x00326ed2, // n0x135a c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x0032734b, // n0x135b c0x0000 (---------------)  + I xn--mli-tla
	0x003277ce, // n0x135c c0x0000 (---------------)  + I xn--mlselv-iua
	0x00327b4e, // n0x135d c0x0000 (---------------)  + I xn--moreke-jua
	0x00327ece, // n0x135e c0x0000 (---------------)  + I xn--mosjen-eya
	0x0032834b, // n0x135f c0x0000 (---------------)  + I xn--mot-tla
	0x3c328796, // n0x1360 c0x00f0 (n0x13d5-n0x13d7)  o I xn--mre-og-romsdal-qqb
	0x00328f0d, // n0x1361 c0x0000 (---------------)  + I xn--msy-ula0h
	0x00329a94, // n0x1362 c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x0032a10d, // n0x1363 c0x0000 (---------------)  + I xn--muost-0qa
	0x0032ad55, // n0x1364 c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0032be0d, // n0x1365 c0x0000 (---------------)  + I xn--nry-yla5g
	0x0032c14f, // n0x1366 c0x0000 (---------------)  + I xn--nttery-byae
	0x0032ce8f, // n0x1367 c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0032eb4f, // n0x1368 c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0032ef0e, // n0x1369 c0x0000 (---------------)  + I xn--ostery-fya
	0x0032f48d, // n0x136a c0x0000 (---------------)  + I xn--osyro-wua
	0x00330451, // n0x136b c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x00331a0c, // n0x136c c0x0000 (---------------)  + I xn--rady-ira
	0x00331d0c, // n0x136d c0x0000 (---------------)  + I xn--rdal-poa
	0x0033200b, // n0x136e c0x0000 (---------------)  + I xn--rde-ula
	0x003322cc, // n0x136f c0x0000 (---------------)  + I xn--rdy-0nab
	0x0033294f, // n0x1370 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00332d12, // n0x1371 c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x0033370d, // n0x1372 c0x0000 (---------------)  + I xn--rholt-mra
	0x0033420c, // n0x1373 c0x0000 (---------------)  + I xn--risa-5na
	0x003346cc, // n0x1374 c0x0000 (---------------)  + I xn--risr-ira
	0x003349cd, // n0x1375 c0x0000 (---------------)  + I xn--rland-uua
	0x00334d0f, // n0x1376 c0x0000 (---------------)  + I xn--rlingen-mxa
	0x003350ce, // n0x1377 c0x0000 (---------------)  + I xn--rmskog-bya
	0x0033544c, // n0x1378 c0x0000 (---------------)  + I xn--rros-gra
	0x003358cd, // n0x1379 c0x0000 (---------------)  + I xn--rskog-uua
	0x00335c0b, // n0x137a c0x0000 (---------------)  + I xn--rst-0na
	0x00336a8c, // n0x137b c0x0000 (---------------)  + I xn--rsta-fra
	0x0033700d, // n0x137c c0x0000 (---------------)  + I xn--ryken-vua
	0x0033734e, // n0x137d c0x0000 (---------------)  + I xn--ryrvik-bya
	0x003376c9, // n0x137e c0x0000 (---------------)  + I xn--s-1fa
	0x00338893, // n0x137f c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x003395cd, // n0x1380 c0x0000 (---------------)  + I xn--sandy-yua
	0x0033990d, // n0x1381 c0x0000 (---------------)  + I xn--seral-lra
	0x00339c4c, // n0x1382 c0x0000 (---------------)  + I xn--sgne-gra
	0x00339f8e, // n0x1383 c0x0000 (---------------)  + I xn--skierv-uta
	0x0033a50f, // n0x1384 c0x0000 (---------------)  + I xn--skjervy-v1a
	0x0033a8cc, // n0x1385 c0x0000 (---------------)  + I xn--skjk-soa
	0x0033abcd, // n0x1386 c0x0000 (---------------)  + I xn--sknit-yqa
	0x0033af0f, // n0x1387 c0x0000 (---------------)  + I xn--sknland-fxa
	0x0033b2cc, // n0x1388 c0x0000 (---------------)  + I xn--slat-5na
	0x0033b68c, // n0x1389 c0x0000 (---------------)  + I xn--slt-elab
	0x0033ba4c, // n0x138a c0x0000 (---------------)  + I xn--smla-hra
	0x0033bd4c, // n0x138b c0x0000 (---------------)  + I xn--smna-gra
	0x0033c04d, // n0x138c c0x0000 (---------------)  + I xn--snase-nra
	0x0033c392, // n0x138d c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0033c84c, // n0x138e c0x0000 (---------------)  + I xn--snes-poa
	0x0033cb4c, // n0x138f c0x0000 (---------------)  + I xn--snsa-roa
	0x0033ce51, // n0x1390 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0033d28f, // n0x1391 c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0033d64f, // n0x1392 c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x0033da13, // n0x1393 c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x0033fe0e, // n0x1394 c0x0000 (---------------)  + I xn--srfold-bya
	0x0034018f, // n0x1395 c0x0000 (---------------)  + I xn--srreisa-q1a
	0x0034054c, // n0x1396 c0x0000 (---------------)  + I xn--srum-gra
	0x3c74084e, // n0x1397 c0x00f1 (n0x13d7-n0x13d8)  o I xn--stfold-9xa
	0x00340bcf, // n0x1398 c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x00340f96, // n0x1399 c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x00341d92, // n0x139a c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x003434cc, // n0x139b c0x0000 (---------------)  + I xn--tjme-hra
	0x0034604f, // n0x139c c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x0034640d, // n0x139d c0x0000 (---------------)  + I xn--trany-yua
	0x0034674f, // n0x139e c0x0000 (---------------)  + I xn--trgstad-r1a
	0x00346b0c, // n0x139f c0x0000 (---------------)  + I xn--trna-woa
	0x00346e0d, // n0x13a0 c0x0000 (---------------)  + I xn--troms-zua
	0x0034714d, // n0x13a1 c0x0000 (---------------)  + I xn--tysvr-vra
	0x00347c0e, // n0x13a2 c0x0000 (---------------)  + I xn--unjrga-rta
	0x0034838c, // n0x13a3 c0x0000 (---------------)  + I xn--vads-jra
	0x0034868c, // n0x13a4 c0x0000 (---------------)  + I xn--vard-jra
	0x00348990, // n0x13a5 c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x00348d91, // n0x13a6 c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x003491cb, // n0x13a7 c0x0000 (---------------)  + I xn--vg-yiab
	0x0034a04c, // n0x13a8 c0x0000 (---------------)  + I xn--vgan-qoa
	0x0034a34e, // n0x13a9 c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x0034ba51, // n0x13aa c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0034be8e, // n0x13ab c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0034c20d, // n0x13ac c0x0000 (---------------)  + I xn--vry-yla5g
	0x0034dc0b, // n0x13ad c0x0000 (---------------)  + I xn--yer-zna
	0x0034e38f, // n0x13ae c0x0000 (---------------)  + I xn--ygarden-p1a
	0x0034fa54, // n0x13af c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x00223142, // n0x13b0 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13b1 c0x0000 (---------------)  + I gs
	0x0020d143, // n0x13b2 c0x0000 (---------------)  + I nes
	0x00223142, // n0x13b3 c0x0000 (---------------)  + I gs
	0x0020d143, // n0x13b4 c0x0000 (---------------)  + I nes
	0x00223142, // n0x13b5 c0x0000 (---------------)  + I gs
	0x00209cc2, // n0x13b6 c0x0000 (---------------)  + I os
	0x0023da85, // n0x13b7 c0x0000 (---------------)  + I valer
	0x0034b74c, // n0x13b8 c0x0000 (---------------)  + I xn--vler-qoa
	0x00223142, // n0x13b9 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13ba c0x0000 (---------------)  + I gs
	0x00209cc2, // n0x13bb c0x0000 (---------------)  + I os
	0x00223142, // n0x13bc c0x0000 (---------------)  + I gs
	0x002781c5, // n0x13bd c0x0000 (---------------)  + I heroy
	0x0029a505, // n0x13be c0x0000 (---------------)  + I sande
	0x00223142, // n0x13bf c0x0000 (---------------)  + I gs
	0x00223142, // n0x13c0 c0x0000 (---------------)  + I gs
	0x00207c82, // n0x13c1 c0x0000 (---------------)  + I bo
	0x002781c5, // n0x13c2 c0x0000 (---------------)  + I heroy
	0x002ee4c9, // n0x13c3 c0x0000 (---------------)  + I xn--b-5ga
	0x0030b84c, // n0x13c4 c0x0000 (---------------)  + I xn--hery-ira
	0x00223142, // n0x13c5 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13c6 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13c7 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13c8 c0x0000 (---------------)  + I gs
	0x0023da85, // n0x13c9 c0x0000 (---------------)  + I valer
	0x00223142, // n0x13ca c0x0000 (---------------)  + I gs
	0x00223142, // n0x13cb c0x0000 (---------------)  + I gs
	0x00223142, // n0x13cc c0x0000 (---------------)  + I gs
	0x00223142, // n0x13cd c0x0000 (---------------)  + I gs
	0x00207c82, // n0x13ce c0x0000 (---------------)  + I bo
	0x002ee4c9, // n0x13cf c0x0000 (---------------)  + I xn--b-5ga
	0x00223142, // n0x13d0 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13d1 c0x0000 (---------------)  + I gs
	0x00223142, // n0x13d2 c0x0000 (---------------)  + I gs
	0x0029a505, // n0x13d3 c0x0000 (---------------)  + I sande
	0x00223142, // n0x13d4 c0x0000 (---------------)  + I gs
	0x0029a505, // n0x13d5 c0x0000 (---------------)  + I sande
	0x0030b84c, // n0x13d6 c0x0000 (---------------)  + I xn--hery-ira
	0x0034b74c, // n0x13d7 c0x0000 (---------------)  + I xn--vler-qoa
	0x002b5183, // n0x13d8 c0x0000 (---------------)  + I biz
	0x002104c3, // n0x13d9 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x13da c0x0000 (---------------)  + I edu
	0x002150c3, // n0x13db c0x0000 (---------------)  + I gov
	0x002180c4, // n0x13dc c0x0000 (---------------)  + I info
	0x00239bc3, // n0x13dd c0x0000 (---------------)  + I net
	0x002453c3, // n0x13de c0x0000 (---------------)  + I org
	0x00023ec8, // n0x13df c0x0000 (---------------)  +   merseine
	0x000bb704, // n0x13e0 c0x0000 (---------------)  +   mine
	0x000e4948, // n0x13e1 c0x0000 (---------------)  +   shacknet
	0x3d608f82, // n0x13e2 c0x00f5 (n0x13e3-n0x13e4)  o I co
	0x00031c88, // n0x13e3 c0x0000 (---------------)  +   blogspot
	0x00208f82, // n0x13e4 c0x0000 (---------------)  + I co
	0x002104c3, // n0x13e5 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x13e6 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x13e7 c0x0000 (---------------)  + I gov
	0x002382c3, // n0x13e8 c0x0000 (---------------)  + I med
	0x006e290a, // n0x13e9 c0x0001 (---------------)  ! I mediaphone
	0x002b9786, // n0x13ea c0x0000 (---------------)  + I museum
	0x00610246, // n0x13eb c0x0001 (---------------)  ! I nawras
	0x0061024d, // n0x13ec c0x0001 (---------------)  ! I nawrastelecom
	0x00239bc3, // n0x13ed c0x0000 (---------------)  + I net
	0x0060acca, // n0x13ee c0x0001 (---------------)  ! I omanmobile
	0x00614588, // n0x13ef c0x0001 (---------------)  ! I omanpost
	0x006c52c7, // n0x13f0 c0x0001 (---------------)  ! I omantel
	0x002453c3, // n0x13f1 c0x0000 (---------------)  + I org
	0x002c5983, // n0x13f2 c0x0000 (---------------)  + I pro
	0x006ea80c, // n0x13f3 c0x0001 (---------------)  ! I rakpetroleum
	0x00689dc7, // n0x13f4 c0x0001 (---------------)  ! I siemens
	0x0065d688, // n0x13f5 c0x0001 (---------------)  ! I songfest
	0x006ada0c, // n0x13f6 c0x0001 (---------------)  ! I statecouncil
	0x00013e42, // n0x13f7 c0x0000 (---------------)  +   ae
	0x0000be47, // n0x13f8 c0x0000 (---------------)  +   blogdns
	0x000bc5c8, // n0x13f9 c0x0000 (---------------)  +   blogsite
	0x0006c052, // n0x13fa c0x0000 (---------------)  +   boldlygoingnowhere
	0x00032888, // n0x13fb c0x0000 (---------------)  +   dnsalias
	0x0005a447, // n0x13fc c0x0000 (---------------)  +   dnsdojo
	0x0002eb4b, // n0x13fd c0x0000 (---------------)  +   doesntexist
	0x0010c549, // n0x13fe c0x0000 (---------------)  +   dontexist
	0x00032787, // n0x13ff c0x0000 (---------------)  +   doomdns
	0x0005a386, // n0x1400 c0x0000 (---------------)  +   dvrdns
	0x00078ac8, // n0x1401 c0x0000 (---------------)  +   dynalias
	0x3e007546, // n0x1402 c0x00f8 (n0x142c-n0x142e)  +   dyndns
	0x0008b5cd, // n0x1403 c0x0000 (---------------)  +   endofinternet
	0x00145b90, // n0x1404 c0x0000 (---------------)  +   endoftheinternet
	0x00050cc7, // n0x1405 c0x0000 (---------------)  +   from-me
	0x00074609, // n0x1406 c0x0000 (---------------)  +   game-host
	0x00045446, // n0x1407 c0x0000 (---------------)  +   gotdns
	0x0003970a, // n0x1408 c0x0000 (---------------)  +   hobby-site
	0x000465c7, // n0x1409 c0x0000 (---------------)  +   homedns
	0x00011207, // n0x140a c0x0000 (---------------)  +   homeftp
	0x00089109, // n0x140b c0x0000 (---------------)  +   homelinux
	0x000896c8, // n0x140c c0x0000 (---------------)  +   homeunix
	0x0003bfce, // n0x140d c0x0000 (---------------)  +   is-a-bruinsfan
	0x0007ce0e, // n0x140e c0x0000 (---------------)  +   is-a-candidate
	0x000a28cf, // n0x140f c0x0000 (---------------)  +   is-a-celticsfan
	0x00105049, // n0x1410 c0x0000 (---------------)  +   is-a-chef
	0x0005a6c9, // n0x1411 c0x0000 (---------------)  +   is-a-geek
	0x0006f9cb, // n0x1412 c0x0000 (---------------)  +   is-a-knight
	0x0008d2cf, // n0x1413 c0x0000 (---------------)  +   is-a-linux-user
	0x00095f0c, // n0x1414 c0x0000 (---------------)  +   is-a-patsfan
	0x000a44cb, // n0x1415 c0x0000 (---------------)  +   is-a-soxfan
	0x000d0048, // n0x1416 c0x0000 (---------------)  +   is-found
	0x000e1747, // n0x1417 c0x0000 (---------------)  +   is-lost
	0x000f2488, // n0x1418 c0x0000 (---------------)  +   is-saved
	0x00107e4b, // n0x1419 c0x0000 (---------------)  +   is-very-bad
	0x0010e84c, // n0x141a c0x0000 (---------------)  +   is-very-evil
	0x0011034c, // n0x141b c0x0000 (---------------)  +   is-very-good
	0x0011df4c, // n0x141c c0x0000 (---------------)  +   is-very-nice
	0x00126a4d, // n0x141d c0x0000 (---------------)  +   is-very-sweet
	0x00043088, // n0x141e c0x0000 (---------------)  +   isa-geek
	0x000a0209, // n0x141f c0x0000 (---------------)  +   kicks-ass
	0x000c0a4b, // n0x1420 c0x0000 (---------------)  +   misconfused
	0x000c2e47, // n0x1421 c0x0000 (---------------)  +   podzone
	0x000bc44a, // n0x1422 c0x0000 (---------------)  +   readmyblog
	0x00108ec6, // n0x1423 c0x0000 (---------------)  +   selfip
	0x0012c50d, // n0x1424 c0x0000 (---------------)  +   sellsyourhome
	0x000c10c8, // n0x1425 c0x0000 (---------------)  +   servebbs
	0x000c1288, // n0x1426 c0x0000 (---------------)  +   serveftp
	0x000db249, // n0x1427 c0x0000 (---------------)  +   servegame
	0x000ddfcc, // n0x1428 c0x0000 (---------------)  +   stuff-4-sale
	0x00002342, // n0x1429 c0x0000 (---------------)  +   us
	0x00017306, // n0x142a c0x0000 (---------------)  +   webhop
	0x00002702, // n0x142b c0x0000 (---------------)  +   za
	0x000053c2, // n0x142c c0x0000 (---------------)  +   go
	0x00011204, // n0x142d c0x0000 (---------------)  +   home
	0x00210d03, // n0x142e c0x0000 (---------------)  + I abo
	0x002028c2, // n0x142f c0x0000 (---------------)  + I ac
	0x002104c3, // n0x1430 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1431 c0x0000 (---------------)  + I edu
	0x00230083, // n0x1432 c0x0000 (---------------)  + I gob
	0x00200243, // n0x1433 c0x0000 (---------------)  + I ing
	0x002382c3, // n0x1434 c0x0000 (---------------)  + I med
	0x00239bc3, // n0x1435 c0x0000 (---------------)  + I net
	0x002006c3, // n0x1436 c0x0000 (---------------)  + I nom
	0x002453c3, // n0x1437 c0x0000 (---------------)  + I org
	0x002c7b43, // n0x1438 c0x0000 (---------------)  + I sld
	0x002104c3, // n0x1439 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x143a c0x0000 (---------------)  + I edu
	0x00230083, // n0x143b c0x0000 (---------------)  + I gob
	0x0025f683, // n0x143c c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x143d c0x0000 (---------------)  + I net
	0x002006c3, // n0x143e c0x0000 (---------------)  + I nom
	0x002453c3, // n0x143f c0x0000 (---------------)  + I org
	0x002104c3, // n0x1440 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1441 c0x0000 (---------------)  + I edu
	0x002453c3, // n0x1442 c0x0000 (---------------)  + I org
	0x002104c3, // n0x1443 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1444 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1445 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1446 c0x0000 (---------------)  + I i
	0x0025f683, // n0x1447 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1448 c0x0000 (---------------)  + I net
	0x00206ac3, // n0x1449 c0x0000 (---------------)  + I ngo
	0x002453c3, // n0x144a c0x0000 (---------------)  + I org
	0x002b5183, // n0x144b c0x0000 (---------------)  + I biz
	0x002104c3, // n0x144c c0x0000 (---------------)  + I com
	0x002ceec3, // n0x144d c0x0000 (---------------)  + I edu
	0x00249243, // n0x144e c0x0000 (---------------)  + I fam
	0x00230083, // n0x144f c0x0000 (---------------)  + I gob
	0x00319c03, // n0x1450 c0x0000 (---------------)  + I gok
	0x0026c703, // n0x1451 c0x0000 (---------------)  + I gon
	0x00287a03, // n0x1452 c0x0000 (---------------)  + I gop
	0x0021ee83, // n0x1453 c0x0000 (---------------)  + I gos
	0x002150c3, // n0x1454 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x1455 c0x0000 (---------------)  + I info
	0x00239bc3, // n0x1456 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1457 c0x0000 (---------------)  + I org
	0x00209243, // n0x1458 c0x0000 (---------------)  + I web
	0x0025f2c5, // n0x1459 c0x0000 (---------------)  + I 6bone
	0x002fc084, // n0x145a c0x0000 (---------------)  + I agro
	0x00253803, // n0x145b c0x0000 (---------------)  + I aid
	0x0020c703, // n0x145c c0x0000 (---------------)  + I art
	0x0023d4c3, // n0x145d c0x0000 (---------------)  + I atm
	0x002d2b48, // n0x145e c0x0000 (---------------)  + I augustow
	0x002eb244, // n0x145f c0x0000 (---------------)  + I auto
	0x00279d0a, // n0x1460 c0x0000 (---------------)  + I babia-gora
	0x00298d06, // n0x1461 c0x0000 (---------------)  + I bedzin
	0x00349447, // n0x1462 c0x0000 (---------------)  + I beskidy
	0x0021d68a, // n0x1463 c0x0000 (---------------)  + I bialowieza
	0x002908c9, // n0x1464 c0x0000 (---------------)  + I bialystok
	0x00200007, // n0x1465 c0x0000 (---------------)  + I bielawa
	0x0020258a, // n0x1466 c0x0000 (---------------)  + I bieszczady
	0x002b5183, // n0x1467 c0x0000 (---------------)  + I biz
	0x002d220b, // n0x1468 c0x0000 (---------------)  + I boleslawiec
	0x002cb209, // n0x1469 c0x0000 (---------------)  + I bydgoszcz
	0x00255345, // n0x146a c0x0000 (---------------)  + I bytom
	0x002b4387, // n0x146b c0x0000 (---------------)  + I cieszyn
	0x00008f82, // n0x146c c0x0000 (---------------)  +   co
	0x002104c3, // n0x146d c0x0000 (---------------)  + I com
	0x00339387, // n0x146e c0x0000 (---------------)  + I czeladz
	0x002167c5, // n0x146f c0x0000 (---------------)  + I czest
	0x002a6549, // n0x1470 c0x0000 (---------------)  + I dlugoleka
	0x002ceec3, // n0x1471 c0x0000 (---------------)  + I edu
	0x00220fc6, // n0x1472 c0x0000 (---------------)  + I elblag
	0x002d97c3, // n0x1473 c0x0000 (---------------)  + I elk
	0x002d3303, // n0x1474 c0x0000 (---------------)  + I gda
	0x002e5a06, // n0x1475 c0x0000 (---------------)  + I gdansk
	0x002fbf46, // n0x1476 c0x0000 (---------------)  + I gdynia
	0x0027ff87, // n0x1477 c0x0000 (---------------)  + I gliwice
	0x0031ce46, // n0x1478 c0x0000 (---------------)  + I glogow
	0x00229b45, // n0x1479 c0x0000 (---------------)  + I gmina
	0x003456c7, // n0x147a c0x0000 (---------------)  + I gniezno
	0x0029f387, // n0x147b c0x0000 (---------------)  + I gorlice
	0x3fe150c3, // n0x147c c0x00ff (n0x1504-n0x150d)  + I gov
	0x002f1747, // n0x147d c0x0000 (---------------)  + I grajewo
	0x00288843, // n0x147e c0x0000 (---------------)  + I gsm
	0x002fc4c5, // n0x147f c0x0000 (---------------)  + I ilawa
	0x002180c4, // n0x1480 c0x0000 (---------------)  + I info
	0x00261b03, // n0x1481 c0x0000 (---------------)  + I irc
	0x0029f708, // n0x1482 c0x0000 (---------------)  + I jaworzno
	0x0025244c, // n0x1483 c0x0000 (---------------)  + I jelenia-gora
	0x0028ff45, // n0x1484 c0x0000 (---------------)  + I jgora
	0x0029c306, // n0x1485 c0x0000 (---------------)  + I kalisz
	0x00339247, // n0x1486 c0x0000 (---------------)  + I karpacz
	0x003504c7, // n0x1487 c0x0000 (---------------)  + I kartuzy
	0x00255207, // n0x1488 c0x0000 (---------------)  + I kaszuby
	0x00264388, // n0x1489 c0x0000 (---------------)  + I katowice
	0x0022bccf, // n0x148a c0x0000 (---------------)  + I kazimierz-dolny
	0x002ed945, // n0x148b c0x0000 (---------------)  + I kepno
	0x002344c7, // n0x148c c0x0000 (---------------)  + I ketrzyn
	0x002b2907, // n0x148d c0x0000 (---------------)  + I klodzko
	0x00288e8a, // n0x148e c0x0000 (---------------)  + I kobierzyce
	0x00299f49, // n0x148f c0x0000 (---------------)  + I kolobrzeg
	0x002e5b45, // n0x1490 c0x0000 (---------------)  + I konin
	0x002e6c8a, // n0x1491 c0x0000 (---------------)  + I konskowola
	0x00299b46, // n0x1492 c0x0000 (---------------)  + I krakow
	0x002a3745, // n0x1493 c0x0000 (---------------)  + I kutno
	0x002b9104, // n0x1494 c0x0000 (---------------)  + I lapy
	0x0022b9c6, // n0x1495 c0x0000 (---------------)  + I lebork
	0x0021b647, // n0x1496 c0x0000 (---------------)  + I legnica
	0x002edb87, // n0x1497 c0x0000 (---------------)  + I lezajsk
	0x002ec208, // n0x1498 c0x0000 (---------------)  + I limanowa
	0x003537c5, // n0x1499 c0x0000 (---------------)  + I lomza
	0x002166c6, // n0x149a c0x0000 (---------------)  + I lowicz
	0x00259d05, // n0x149b c0x0000 (---------------)  + I lubin
	0x0031d145, // n0x149c c0x0000 (---------------)  + I lukow
	0x00216604, // n0x149d c0x0000 (---------------)  + I mail
	0x00222987, // n0x149e c0x0000 (---------------)  + I malbork
	0x0028e18a, // n0x149f c0x0000 (---------------)  + I malopolska
	0x0021c188, // n0x14a0 c0x0000 (---------------)  + I mazowsze
	0x002e5786, // n0x14a1 c0x0000 (---------------)  + I mazury
	0x002fd0c5, // n0x14a2 c0x0000 (---------------)  + I mbone
	0x002382c3, // n0x14a3 c0x0000 (---------------)  + I med
	0x002e2905, // n0x14a4 c0x0000 (---------------)  + I media
	0x002d8e86, // n0x14a5 c0x0000 (---------------)  + I miasta
	0x00201806, // n0x14a6 c0x0000 (---------------)  + I mielec
	0x00292086, // n0x14a7 c0x0000 (---------------)  + I mielno
	0x0025f683, // n0x14a8 c0x0000 (---------------)  + I mil
	0x00333987, // n0x14a9 c0x0000 (---------------)  + I mragowo
	0x002b2885, // n0x14aa c0x0000 (---------------)  + I naklo
	0x00239bc3, // n0x14ab c0x0000 (---------------)  + I net
	0x00206ac3, // n0x14ac c0x0000 (---------------)  + I ngo
	0x0033e78d, // n0x14ad c0x0000 (---------------)  + I nieruchomosci
	0x002006c3, // n0x14ae c0x0000 (---------------)  + I nom
	0x002ec308, // n0x14af c0x0000 (---------------)  + I nowaruda
	0x00319e44, // n0x14b0 c0x0000 (---------------)  + I nysa
	0x00262bc5, // n0x14b1 c0x0000 (---------------)  + I olawa
	0x00288d86, // n0x14b2 c0x0000 (---------------)  + I olecko
	0x002dab06, // n0x14b3 c0x0000 (---------------)  + I olkusz
	0x0020eec7, // n0x14b4 c0x0000 (---------------)  + I olsztyn
	0x00217407, // n0x14b5 c0x0000 (---------------)  + I opoczno
	0x0034b5c5, // n0x14b6 c0x0000 (---------------)  + I opole
	0x002453c3, // n0x14b7 c0x0000 (---------------)  + I org
	0x002a3107, // n0x14b8 c0x0000 (---------------)  + I ostroda
	0x0031fd89, // n0x14b9 c0x0000 (---------------)  + I ostroleka
	0x00338309, // n0x14ba c0x0000 (---------------)  + I ostrowiec
	0x002268ca, // n0x14bb c0x0000 (---------------)  + I ostrowwlkp
	0x002cea02, // n0x14bc c0x0000 (---------------)  + I pc
	0x002fc484, // n0x14bd c0x0000 (---------------)  + I pila
	0x002bec84, // n0x14be c0x0000 (---------------)  + I pisz
	0x002c2707, // n0x14bf c0x0000 (---------------)  + I podhale
	0x002c2b48, // n0x14c0 c0x0000 (---------------)  + I podlasie
	0x0024a249, // n0x14c1 c0x0000 (---------------)  + I polkowice
	0x0021d989, // n0x14c2 c0x0000 (---------------)  + I pomorskie
	0x002c3647, // n0x14c3 c0x0000 (---------------)  + I pomorze
	0x00207a86, // n0x14c4 c0x0000 (---------------)  + I powiat
	0x002c4306, // n0x14c5 c0x0000 (---------------)  + I poznan
	0x002c5804, // n0x14c6 c0x0000 (---------------)  + I priv
	0x002c598a, // n0x14c7 c0x0000 (---------------)  + I prochowice
	0x002c6c88, // n0x14c8 c0x0000 (---------------)  + I pruszkow
	0x002c6e89, // n0x14c9 c0x0000 (---------------)  + I przeworsk
	0x00309e06, // n0x14ca c0x0000 (---------------)  + I pulawy
	0x00295845, // n0x14cb c0x0000 (---------------)  + I radom
	0x0021c048, // n0x14cc c0x0000 (---------------)  + I rawa-maz
	0x002ad8ca, // n0x14cd c0x0000 (---------------)  + I realestate
	0x00202143, // n0x14ce c0x0000 (---------------)  + I rel
	0x002a9646, // n0x14cf c0x0000 (---------------)  + I rybnik
	0x002c3747, // n0x14d0 c0x0000 (---------------)  + I rzeszow
	0x00276005, // n0x14d1 c0x0000 (---------------)  + I sanok
	0x00319d05, // n0x14d2 c0x0000 (---------------)  + I sejny
	0x0020e3c3, // n0x14d3 c0x0000 (---------------)  + I sex
	0x00227ec4, // n0x14d4 c0x0000 (---------------)  + I shop
	0x002c2c87, // n0x14d5 c0x0000 (---------------)  + I siedlce
	0x00222dc5, // n0x14d6 c0x0000 (---------------)  + I sklep
	0x00268b47, // n0x14d7 c0x0000 (---------------)  + I skoczow
	0x0025ab85, // n0x14d8 c0x0000 (---------------)  + I slask
	0x002d3e46, // n0x14d9 c0x0000 (---------------)  + I slupsk
	0x002d4d85, // n0x14da c0x0000 (---------------)  + I sopot
	0x0023a843, // n0x14db c0x0000 (---------------)  + I sos
	0x0025cfc9, // n0x14dc c0x0000 (---------------)  + I sosnowiec
	0x0026298c, // n0x14dd c0x0000 (---------------)  + I stalowa-wola
	0x002a0e4c, // n0x14de c0x0000 (---------------)  + I starachowice
	0x0025ed08, // n0x14df c0x0000 (---------------)  + I stargard
	0x002c8107, // n0x14e0 c0x0000 (---------------)  + I suwalki
	0x002e0108, // n0x14e1 c0x0000 (---------------)  + I swidnica
	0x002e068a, // n0x14e2 c0x0000 (---------------)  + I swiebodzin
	0x002e0a4b, // n0x14e3 c0x0000 (---------------)  + I swinoujscie
	0x002cb348, // n0x14e4 c0x0000 (---------------)  + I szczecin
	0x002ecb88, // n0x14e5 c0x0000 (---------------)  + I szczytno
	0x0029c406, // n0x14e6 c0x0000 (---------------)  + I szkola
	0x0027c605, // n0x14e7 c0x0000 (---------------)  + I targi
	0x0031c1ca, // n0x14e8 c0x0000 (---------------)  + I tarnobrzeg
	0x0023c885, // n0x14e9 c0x0000 (---------------)  + I tgory
	0x0023d502, // n0x14ea c0x0000 (---------------)  + I tm
	0x002aae07, // n0x14eb c0x0000 (---------------)  + I tourism
	0x0029ed06, // n0x14ec c0x0000 (---------------)  + I travel
	0x00206545, // n0x14ed c0x0000 (---------------)  + I turek
	0x002e54c9, // n0x14ee c0x0000 (---------------)  + I turystyka
	0x00319fc5, // n0x14ef c0x0000 (---------------)  + I tychy
	0x00277886, // n0x14f0 c0x0000 (---------------)  + I usenet
	0x002947c5, // n0x14f1 c0x0000 (---------------)  + I ustka
	0x002b5c89, // n0x14f2 c0x0000 (---------------)  + I walbrzych
	0x00228906, // n0x14f3 c0x0000 (---------------)  + I warmia
	0x0024c188, // n0x14f4 c0x0000 (---------------)  + I warszawa
	0x002a1e43, // n0x14f5 c0x0000 (---------------)  + I waw
	0x002255c6, // n0x14f6 c0x0000 (---------------)  + I wegrow
	0x0025ca46, // n0x14f7 c0x0000 (---------------)  + I wielun
	0x0031d245, // n0x14f8 c0x0000 (---------------)  + I wlocl
	0x0031d249, // n0x14f9 c0x0000 (---------------)  + I wloclawek
	0x002601c9, // n0x14fa c0x0000 (---------------)  + I wodzislaw
	0x002f1887, // n0x14fb c0x0000 (---------------)  + I wolomin
	0x0023b304, // n0x14fc c0x0000 (---------------)  + I wroc
	0x0023b307, // n0x14fd c0x0000 (---------------)  + I wroclaw
	0x0021d889, // n0x14fe c0x0000 (---------------)  + I zachpomor
	0x00237c45, // n0x14ff c0x0000 (---------------)  + I zagan
	0x002500c8, // n0x1500 c0x0000 (---------------)  + I zakopane
	0x0022d4c5, // n0x1501 c0x0000 (---------------)  + I zarow
	0x00225d85, // n0x1502 c0x0000 (---------------)  + I zgora
	0x00239c89, // n0x1503 c0x0000 (---------------)  + I zgorzelec
	0x00211382, // n0x1504 c0x0000 (---------------)  + I pa
	0x00202e82, // n0x1505 c0x0000 (---------------)  + I po
	0x00202fc2, // n0x1506 c0x0000 (---------------)  + I so
	0x002b1502, // n0x1507 c0x0000 (---------------)  + I sr
	0x00260009, // n0x1508 c0x0000 (---------------)  + I starostwo
	0x00200882, // n0x1509 c0x0000 (---------------)  + I ug
	0x00205d82, // n0x150a c0x0000 (---------------)  + I um
	0x00207a44, // n0x150b c0x0000 (---------------)  + I upow
	0x002394c2, // n0x150c c0x0000 (---------------)  + I uw
	0x00208f82, // n0x150d c0x0000 (---------------)  + I co
	0x002ceec3, // n0x150e c0x0000 (---------------)  + I edu
	0x002150c3, // n0x150f c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x1510 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1511 c0x0000 (---------------)  + I org
	0x002028c2, // n0x1512 c0x0000 (---------------)  + I ac
	0x002b5183, // n0x1513 c0x0000 (---------------)  + I biz
	0x002104c3, // n0x1514 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1515 c0x0000 (---------------)  + I edu
	0x00202443, // n0x1516 c0x0000 (---------------)  + I est
	0x002150c3, // n0x1517 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x1518 c0x0000 (---------------)  + I info
	0x002602c4, // n0x1519 c0x0000 (---------------)  + I isla
	0x002d16c4, // n0x151a c0x0000 (---------------)  + I name
	0x00239bc3, // n0x151b c0x0000 (---------------)  + I net
	0x002453c3, // n0x151c c0x0000 (---------------)  + I org
	0x002c5983, // n0x151d c0x0000 (---------------)  + I pro
	0x002c5e84, // n0x151e c0x0000 (---------------)  + I prof
	0x00271e83, // n0x151f c0x0000 (---------------)  + I aca
	0x00234383, // n0x1520 c0x0000 (---------------)  + I bar
	0x0022ccc3, // n0x1521 c0x0000 (---------------)  + I cpa
	0x0020bac3, // n0x1522 c0x0000 (---------------)  + I eng
	0x0025ba03, // n0x1523 c0x0000 (---------------)  + I jur
	0x002000c3, // n0x1524 c0x0000 (---------------)  + I law
	0x002382c3, // n0x1525 c0x0000 (---------------)  + I med
	0x002104c3, // n0x1526 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1527 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1528 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x1529 c0x0000 (---------------)  + I net
	0x002453c3, // n0x152a c0x0000 (---------------)  + I org
	0x002c2283, // n0x152b c0x0000 (---------------)  + I plo
	0x002ea0c3, // n0x152c c0x0000 (---------------)  + I sec
	0x00031c88, // n0x152d c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x152e c0x0000 (---------------)  + I com
	0x002ceec3, // n0x152f c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1530 c0x0000 (---------------)  + I gov
	0x0021fe43, // n0x1531 c0x0000 (---------------)  + I int
	0x00239bc3, // n0x1532 c0x0000 (---------------)  + I net
	0x00244944, // n0x1533 c0x0000 (---------------)  + I nome
	0x002453c3, // n0x1534 c0x0000 (---------------)  + I org
	0x0029d704, // n0x1535 c0x0000 (---------------)  + I publ
	0x002d2a85, // n0x1536 c0x0000 (---------------)  + I belau
	0x00208f82, // n0x1537 c0x0000 (---------------)  + I co
	0x00203582, // n0x1538 c0x0000 (---------------)  + I ed
	0x002053c2, // n0x1539 c0x0000 (---------------)  + I go
	0x00205f42, // n0x153a c0x0000 (---------------)  + I ne
	0x00204282, // n0x153b c0x0000 (---------------)  + I or
	0x002104c3, // n0x153c c0x0000 (---------------)  + I com
	0x00236044, // n0x153d c0x0000 (---------------)  + I coop
	0x002ceec3, // n0x153e c0x0000 (---------------)  + I edu
	0x002150c3, // n0x153f c0x0000 (---------------)  + I gov
	0x0025f683, // n0x1540 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1541 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1542 c0x0000 (---------------)  + I org
	0x002104c3, // n0x1543 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1544 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1545 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x1546 c0x0000 (---------------)  + I mil
	0x002d16c4, // n0x1547 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x1548 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1549 c0x0000 (---------------)  + I org
	0x00204343, // n0x154a c0x0000 (---------------)  + I sch
	0x00202f44, // n0x154b c0x0000 (---------------)  + I asso
	0x00031c88, // n0x154c c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x154d c0x0000 (---------------)  + I com
	0x002006c3, // n0x154e c0x0000 (---------------)  + I nom
	0x0023fec4, // n0x154f c0x0000 (---------------)  + I arts
	0x00031c88, // n0x1550 c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x1551 c0x0000 (---------------)  + I com
	0x00240684, // n0x1552 c0x0000 (---------------)  + I firm
	0x002180c4, // n0x1553 c0x0000 (---------------)  + I info
	0x002006c3, // n0x1554 c0x0000 (---------------)  + I nom
	0x00204e02, // n0x1555 c0x0000 (---------------)  + I nt
	0x002453c3, // n0x1556 c0x0000 (---------------)  + I org
	0x002a8343, // n0x1557 c0x0000 (---------------)  + I rec
	0x002dd805, // n0x1558 c0x0000 (---------------)  + I store
	0x0023d502, // n0x1559 c0x0000 (---------------)  + I tm
	0x0023b483, // n0x155a c0x0000 (---------------)  + I www
	0x002028c2, // n0x155b c0x0000 (---------------)  + I ac
	0x00208f82, // n0x155c c0x0000 (---------------)  + I co
	0x002ceec3, // n0x155d c0x0000 (---------------)  + I edu
	0x002150c3, // n0x155e c0x0000 (---------------)  + I gov
	0x00200242, // n0x155f c0x0000 (---------------)  + I in
	0x002453c3, // n0x1560 c0x0000 (---------------)  + I org
	0x002028c2, // n0x1561 c0x0000 (---------------)  + I ac
	0x00202747, // n0x1562 c0x0000 (---------------)  + I adygeya
	0x002dea45, // n0x1563 c0x0000 (---------------)  + I altai
	0x0026f6c4, // n0x1564 c0x0000 (---------------)  + I amur
	0x002c64c6, // n0x1565 c0x0000 (---------------)  + I amursk
	0x002f8c8b, // n0x1566 c0x0000 (---------------)  + I arkhangelsk
	0x00247349, // n0x1567 c0x0000 (---------------)  + I astrakhan
	0x0029c246, // n0x1568 c0x0000 (---------------)  + I baikal
	0x00328cc9, // n0x1569 c0x0000 (---------------)  + I bashkiria
	0x0029e788, // n0x156a c0x0000 (---------------)  + I belgorod
	0x0020c603, // n0x156b c0x0000 (---------------)  + I bir
	0x00222c87, // n0x156c c0x0000 (---------------)  + I bryansk
	0x0024fb08, // n0x156d c0x0000 (---------------)  + I buryatia
	0x0033c783, // n0x156e c0x0000 (---------------)  + I cbg
	0x00258dc4, // n0x156f c0x0000 (---------------)  + I chel
	0x0025d1cb, // n0x1570 c0x0000 (---------------)  + I chelyabinsk
	0x002a1ac5, // n0x1571 c0x0000 (---------------)  + I chita
	0x0032e208, // n0x1572 c0x0000 (---------------)  + I chukotka
	0x003317c9, // n0x1573 c0x0000 (---------------)  + I chuvashia
	0x00345f83, // n0x1574 c0x0000 (---------------)  + I cmw
	0x002104c3, // n0x1575 c0x0000 (---------------)  + I com
	0x002d2d88, // n0x1576 c0x0000 (---------------)  + I dagestan
	0x00263247, // n0x1577 c0x0000 (---------------)  + I dudinka
	0x0025fd06, // n0x1578 c0x0000 (---------------)  + I e-burg
	0x002ceec3, // n0x1579 c0x0000 (---------------)  + I edu
	0x003168c7, // n0x157a c0x0000 (---------------)  + I fareast
	0x002150c3, // n0x157b c0x0000 (---------------)  + I gov
	0x002421c6, // n0x157c c0x0000 (---------------)  + I grozny
	0x0021fe43, // n0x157d c0x0000 (---------------)  + I int
	0x00271547, // n0x157e c0x0000 (---------------)  + I irkutsk
	0x0027fa87, // n0x157f c0x0000 (---------------)  + I ivanovo
	0x0031e947, // n0x1580 c0x0000 (---------------)  + I izhevsk
	0x00222905, // n0x1581 c0x0000 (---------------)  + I jamal
	0x0020eb83, // n0x1582 c0x0000 (---------------)  + I jar
	0x0023ee4b, // n0x1583 c0x0000 (---------------)  + I joshkar-ola
	0x002edd08, // n0x1584 c0x0000 (---------------)  + I k-uralsk
	0x002a8bc8, // n0x1585 c0x0000 (---------------)  + I kalmykia
	0x002a6706, // n0x1586 c0x0000 (---------------)  + I kaluga
	0x002c9549, // n0x1587 c0x0000 (---------------)  + I kamchatka
	0x00224c87, // n0x1588 c0x0000 (---------------)  + I karelia
	0x002e3b05, // n0x1589 c0x0000 (---------------)  + I kazan
	0x00333204, // n0x158a c0x0000 (---------------)  + I kchr
	0x0022e588, // n0x158b c0x0000 (---------------)  + I kemerovo
	0x00244dca, // n0x158c c0x0000 (---------------)  + I khabarovsk
	0x00245009, // n0x158d c0x0000 (---------------)  + I khakassia
	0x002f5cc3, // n0x158e c0x0000 (---------------)  + I khv
	0x00264e05, // n0x158f c0x0000 (---------------)  + I kirov
	0x0031e783, // n0x1590 c0x0000 (---------------)  + I kms
	0x002ce586, // n0x1591 c0x0000 (---------------)  + I koenig
	0x002b82c4, // n0x1592 c0x0000 (---------------)  + I komi
	0x002951c8, // n0x1593 c0x0000 (---------------)  + I kostroma
	0x00299ccb, // n0x1594 c0x0000 (---------------)  + I krasnoyarsk
	0x0026d545, // n0x1595 c0x0000 (---------------)  + I kuban
	0x0029e506, // n0x1596 c0x0000 (---------------)  + I kurgan
	0x002a1145, // n0x1597 c0x0000 (---------------)  + I kursk
	0x002a1708, // n0x1598 c0x0000 (---------------)  + I kustanai
	0x002a3887, // n0x1599 c0x0000 (---------------)  + I kuzbass
	0x00349c87, // n0x159a c0x0000 (---------------)  + I lipetsk
	0x002912c7, // n0x159b c0x0000 (---------------)  + I magadan
	0x0030f748, // n0x159c c0x0000 (---------------)  + I magnitka
	0x0021cb84, // n0x159d c0x0000 (---------------)  + I mari
	0x0021cb87, // n0x159e c0x0000 (---------------)  + I mari-el
	0x00325746, // n0x159f c0x0000 (---------------)  + I marine
	0x0025f683, // n0x15a0 c0x0000 (---------------)  + I mil
	0x002af048, // n0x15a1 c0x0000 (---------------)  + I mordovia
	0x002b1486, // n0x15a2 c0x0000 (---------------)  + I mosreg
	0x0022c643, // n0x15a3 c0x0000 (---------------)  + I msk
	0x002b4748, // n0x15a4 c0x0000 (---------------)  + I murmansk
	0x002ba0c5, // n0x15a5 c0x0000 (---------------)  + I mytis
	0x002d4948, // n0x15a6 c0x0000 (---------------)  + I nakhodka
	0x00319a07, // n0x15a7 c0x0000 (---------------)  + I nalchik
	0x00239bc3, // n0x15a8 c0x0000 (---------------)  + I net
	0x002bea03, // n0x15a9 c0x0000 (---------------)  + I nkz
	0x00270d84, // n0x15aa c0x0000 (---------------)  + I nnov
	0x00217547, // n0x15ab c0x0000 (---------------)  + I norilsk
	0x00212f43, // n0x15ac c0x0000 (---------------)  + I nov
	0x0027fb4b, // n0x15ad c0x0000 (---------------)  + I novosibirsk
	0x00215c83, // n0x15ae c0x0000 (---------------)  + I nsk
	0x0022c604, // n0x15af c0x0000 (---------------)  + I omsk
	0x002dd888, // n0x15b0 c0x0000 (---------------)  + I orenburg
	0x002453c3, // n0x15b1 c0x0000 (---------------)  + I org
	0x00290185, // n0x15b2 c0x0000 (---------------)  + I oryol
	0x0021b545, // n0x15b3 c0x0000 (---------------)  + I oskol
	0x002b6106, // n0x15b4 c0x0000 (---------------)  + I palana
	0x002278c5, // n0x15b5 c0x0000 (---------------)  + I penza
	0x002ba484, // n0x15b6 c0x0000 (---------------)  + I perm
	0x00208642, // n0x15b7 c0x0000 (---------------)  + I pp
	0x002d3f05, // n0x15b8 c0x0000 (---------------)  + I pskov
	0x002c7143, // n0x15b9 c0x0000 (---------------)  + I ptz
	0x002b918a, // n0x15ba c0x0000 (---------------)  + I pyatigorsk
	0x0021b103, // n0x15bb c0x0000 (---------------)  + I rnd
	0x00279609, // n0x15bc c0x0000 (---------------)  + I rubtsovsk
	0x0021c886, // n0x15bd c0x0000 (---------------)  + I ryazan
	0x00264148, // n0x15be c0x0000 (---------------)  + I sakhalin
	0x002735c6, // n0x15bf c0x0000 (---------------)  + I samara
	0x002614c7, // n0x15c0 c0x0000 (---------------)  + I saratov
	0x002d3408, // n0x15c1 c0x0000 (---------------)  + I simbirsk
	0x00215b48, // n0x15c2 c0x0000 (---------------)  + I smolensk
	0x002d4203, // n0x15c3 c0x0000 (---------------)  + I snz
	0x002d8503, // n0x15c4 c0x0000 (---------------)  + I spb
	0x0024a0c9, // n0x15c5 c0x0000 (---------------)  + I stavropol
	0x002e1a83, // n0x15c6 c0x0000 (---------------)  + I stv
	0x002ac046, // n0x15c7 c0x0000 (---------------)  + I surgut
	0x0033f3c6, // n0x15c8 c0x0000 (---------------)  + I syzran
	0x00207bc6, // n0x15c9 c0x0000 (---------------)  + I tambov
	0x0022f689, // n0x15ca c0x0000 (---------------)  + I tatarstan
	0x00231ac4, // n0x15cb c0x0000 (---------------)  + I test
	0x0020ac83, // n0x15cc c0x0000 (---------------)  + I tom
	0x002b81c5, // n0x15cd c0x0000 (---------------)  + I tomsk
	0x002fb449, // n0x15ce c0x0000 (---------------)  + I tsaritsyn
	0x0022bc43, // n0x15cf c0x0000 (---------------)  + I tsk
	0x002e36c4, // n0x15d0 c0x0000 (---------------)  + I tula
	0x002f4e84, // n0x15d1 c0x0000 (---------------)  + I tuva
	0x00337b84, // n0x15d2 c0x0000 (---------------)  + I tver
	0x00208146, // n0x15d3 c0x0000 (---------------)  + I tyumen
	0x002fc9c3, // n0x15d4 c0x0000 (---------------)  + I udm
	0x002fc9c8, // n0x15d5 c0x0000 (---------------)  + I udmurtia
	0x00246f88, // n0x15d6 c0x0000 (---------------)  + I ulan-ude
	0x00257706, // n0x15d7 c0x0000 (---------------)  + I vdonsk
	0x002e390b, // n0x15d8 c0x0000 (---------------)  + I vladikavkaz
	0x002e3c48, // n0x15d9 c0x0000 (---------------)  + I vladimir
	0x002e414b, // n0x15da c0x0000 (---------------)  + I vladivostok
	0x002e4e09, // n0x15db c0x0000 (---------------)  + I volgograd
	0x002e5907, // n0x15dc c0x0000 (---------------)  + I vologda
	0x002e62c8, // n0x15dd c0x0000 (---------------)  + I voronezh
	0x002e6903, // n0x15de c0x0000 (---------------)  + I vrn
	0x002e69c6, // n0x15df c0x0000 (---------------)  + I vyatka
	0x002eb0c7, // n0x15e0 c0x0000 (---------------)  + I yakutia
	0x0027eb45, // n0x15e1 c0x0000 (---------------)  + I yamal
	0x002f0849, // n0x15e2 c0x0000 (---------------)  + I yaroslavl
	0x002fbc4d, // n0x15e3 c0x0000 (---------------)  + I yekaterinburg
	0x00263f91, // n0x15e4 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x0024b685, // n0x15e5 c0x0000 (---------------)  + I zgrad
	0x002028c2, // n0x15e6 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x15e7 c0x0000 (---------------)  + I co
	0x002104c3, // n0x15e8 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x15e9 c0x0000 (---------------)  + I edu
	0x0022fa44, // n0x15ea c0x0000 (---------------)  + I gouv
	0x002150c3, // n0x15eb c0x0000 (---------------)  + I gov
	0x0021fe43, // n0x15ec c0x0000 (---------------)  + I int
	0x0025f683, // n0x15ed c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x15ee c0x0000 (---------------)  + I net
	0x002104c3, // n0x15ef c0x0000 (---------------)  + I com
	0x002ceec3, // n0x15f0 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x15f1 c0x0000 (---------------)  + I gov
	0x002382c3, // n0x15f2 c0x0000 (---------------)  + I med
	0x00239bc3, // n0x15f3 c0x0000 (---------------)  + I net
	0x002453c3, // n0x15f4 c0x0000 (---------------)  + I org
	0x00294403, // n0x15f5 c0x0000 (---------------)  + I pub
	0x00204343, // n0x15f6 c0x0000 (---------------)  + I sch
	0x002104c3, // n0x15f7 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x15f8 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x15f9 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x15fa c0x0000 (---------------)  + I net
	0x002453c3, // n0x15fb c0x0000 (---------------)  + I org
	0x002104c3, // n0x15fc c0x0000 (---------------)  + I com
	0x002ceec3, // n0x15fd c0x0000 (---------------)  + I edu
	0x002150c3, // n0x15fe c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x15ff c0x0000 (---------------)  + I net
	0x002453c3, // n0x1600 c0x0000 (---------------)  + I org
	0x002104c3, // n0x1601 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1602 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1603 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x1604 c0x0000 (---------------)  + I info
	0x002382c3, // n0x1605 c0x0000 (---------------)  + I med
	0x00239bc3, // n0x1606 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1607 c0x0000 (---------------)  + I org
	0x0027ecc2, // n0x1608 c0x0000 (---------------)  + I tv
	0x00200101, // n0x1609 c0x0000 (---------------)  + I a
	0x002028c2, // n0x160a c0x0000 (---------------)  + I ac
	0x00200001, // n0x160b c0x0000 (---------------)  + I b
	0x002ee802, // n0x160c c0x0000 (---------------)  + I bd
	0x00031c88, // n0x160d c0x0000 (---------------)  +   blogspot
	0x002185c5, // n0x160e c0x0000 (---------------)  + I brand
	0x00200401, // n0x160f c0x0000 (---------------)  + I c
	0x002003c1, // n0x1610 c0x0000 (---------------)  + I d
	0x00200081, // n0x1611 c0x0000 (---------------)  + I e
	0x00201ac1, // n0x1612 c0x0000 (---------------)  + I f
	0x0023da02, // n0x1613 c0x0000 (---------------)  + I fh
	0x00333144, // n0x1614 c0x0000 (---------------)  + I fhsk
	0x0023da03, // n0x1615 c0x0000 (---------------)  + I fhv
	0x002002c1, // n0x1616 c0x0000 (---------------)  + I g
	0x00200201, // n0x1617 c0x0000 (---------------)  + I h
	0x00200041, // n0x1618 c0x0000 (---------------)  + I i
	0x002007c1, // n0x1619 c0x0000 (---------------)  + I k
	0x002b4907, // n0x161a c0x0000 (---------------)  + I komforb
	0x002b93cf, // n0x161b c0x0000 (---------------)  + I kommunalforbund
	0x002d35c6, // n0x161c c0x0000 (---------------)  + I komvux
	0x002000c1, // n0x161d c0x0000 (---------------)  + I l
	0x00288a86, // n0x161e c0x0000 (---------------)  + I lanbib
	0x00200741, // n0x161f c0x0000 (---------------)  + I m
	0x00200281, // n0x1620 c0x0000 (---------------)  + I n
	0x00203d0e, // n0x1621 c0x0000 (---------------)  + I naturbruksgymn
	0x00200341, // n0x1622 c0x0000 (---------------)  + I o
	0x002453c3, // n0x1623 c0x0000 (---------------)  + I org
	0x00202e81, // n0x1624 c0x0000 (---------------)  + I p
	0x002c7205, // n0x1625 c0x0000 (---------------)  + I parti
	0x00208642, // n0x1626 c0x0000 (---------------)  + I pp
	0x0020e2c5, // n0x1627 c0x0000 (---------------)  + I press
	0x00200501, // n0x1628 c0x0000 (---------------)  + I r
	0x002001c1, // n0x1629 c0x0000 (---------------)  + I s
	0x002e2c04, // n0x162a c0x0000 (---------------)  + I sshn
	0x00200301, // n0x162b c0x0000 (---------------)  + I t
	0x0023d502, // n0x162c c0x0000 (---------------)  + I tm
	0x00200881, // n0x162d c0x0000 (---------------)  + I u
	0x00200141, // n0x162e c0x0000 (---------------)  + I w
	0x00201381, // n0x162f c0x0000 (---------------)  + I x
	0x002027c1, // n0x1630 c0x0000 (---------------)  + I y
	0x002011c1, // n0x1631 c0x0000 (---------------)  + I z
	0x00031c88, // n0x1632 c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x1633 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1634 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1635 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x1636 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1637 c0x0000 (---------------)  + I org
	0x0020f983, // n0x1638 c0x0000 (---------------)  + I per
	0x002104c3, // n0x1639 c0x0000 (---------------)  + I com
	0x002150c3, // n0x163a c0x0000 (---------------)  + I gov
	0x0025f683, // n0x163b c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x163c c0x0000 (---------------)  + I net
	0x002453c3, // n0x163d c0x0000 (---------------)  + I org
	0x00031c88, // n0x163e c0x0000 (---------------)  +   blogspot
	0x002104c3, // n0x163f c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1640 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1641 c0x0000 (---------------)  + I gov
	0x00239bc3, // n0x1642 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1643 c0x0000 (---------------)  + I org
	0x0020c703, // n0x1644 c0x0000 (---------------)  + I art
	0x002104c3, // n0x1645 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1646 c0x0000 (---------------)  + I edu
	0x0022fa44, // n0x1647 c0x0000 (---------------)  + I gouv
	0x002453c3, // n0x1648 c0x0000 (---------------)  + I org
	0x00297805, // n0x1649 c0x0000 (---------------)  + I perso
	0x00207f44, // n0x164a c0x0000 (---------------)  + I univ
	0x002104c3, // n0x164b c0x0000 (---------------)  + I com
	0x00239bc3, // n0x164c c0x0000 (---------------)  + I net
	0x002453c3, // n0x164d c0x0000 (---------------)  + I org
	0x00208f82, // n0x164e c0x0000 (---------------)  + I co
	0x002104c3, // n0x164f c0x0000 (---------------)  + I com
	0x002325c9, // n0x1650 c0x0000 (---------------)  + I consulado
	0x002ceec3, // n0x1651 c0x0000 (---------------)  + I edu
	0x00225b09, // n0x1652 c0x0000 (---------------)  + I embaixada
	0x002150c3, // n0x1653 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x1654 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1655 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1656 c0x0000 (---------------)  + I org
	0x002c4988, // n0x1657 c0x0000 (---------------)  + I principe
	0x00253fc7, // n0x1658 c0x0000 (---------------)  + I saotome
	0x002dd805, // n0x1659 c0x0000 (---------------)  + I store
	0x002104c3, // n0x165a c0x0000 (---------------)  + I com
	0x002ceec3, // n0x165b c0x0000 (---------------)  + I edu
	0x00230083, // n0x165c c0x0000 (---------------)  + I gob
	0x002453c3, // n0x165d c0x0000 (---------------)  + I org
	0x00249483, // n0x165e c0x0000 (---------------)  + I red
	0x002150c3, // n0x165f c0x0000 (---------------)  + I gov
	0x002104c3, // n0x1660 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1661 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1662 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x1663 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1664 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1665 c0x0000 (---------------)  + I org
	0x002028c2, // n0x1666 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x1667 c0x0000 (---------------)  + I co
	0x002453c3, // n0x1668 c0x0000 (---------------)  + I org
	0x00031c88, // n0x1669 c0x0000 (---------------)  +   blogspot
	0x002028c2, // n0x166a c0x0000 (---------------)  + I ac
	0x00208f82, // n0x166b c0x0000 (---------------)  + I co
	0x002053c2, // n0x166c c0x0000 (---------------)  + I go
	0x00200242, // n0x166d c0x0000 (---------------)  + I in
	0x00200e02, // n0x166e c0x0000 (---------------)  + I mi
	0x00239bc3, // n0x166f c0x0000 (---------------)  + I net
	0x00204282, // n0x1670 c0x0000 (---------------)  + I or
	0x002028c2, // n0x1671 c0x0000 (---------------)  + I ac
	0x002b5183, // n0x1672 c0x0000 (---------------)  + I biz
	0x00208f82, // n0x1673 c0x0000 (---------------)  + I co
	0x002104c3, // n0x1674 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1675 c0x0000 (---------------)  + I edu
	0x002053c2, // n0x1676 c0x0000 (---------------)  + I go
	0x002150c3, // n0x1677 c0x0000 (---------------)  + I gov
	0x0021fe43, // n0x1678 c0x0000 (---------------)  + I int
	0x0025f683, // n0x1679 c0x0000 (---------------)  + I mil
	0x002d16c4, // n0x167a c0x0000 (---------------)  + I name
	0x00239bc3, // n0x167b c0x0000 (---------------)  + I net
	0x002131c3, // n0x167c c0x0000 (---------------)  + I nic
	0x002453c3, // n0x167d c0x0000 (---------------)  + I org
	0x00231ac4, // n0x167e c0x0000 (---------------)  + I test
	0x00209243, // n0x167f c0x0000 (---------------)  + I web
	0x002150c3, // n0x1680 c0x0000 (---------------)  + I gov
	0x00208f82, // n0x1681 c0x0000 (---------------)  + I co
	0x002104c3, // n0x1682 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1683 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1684 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x1685 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1686 c0x0000 (---------------)  + I net
	0x002006c3, // n0x1687 c0x0000 (---------------)  + I nom
	0x002453c3, // n0x1688 c0x0000 (---------------)  + I org
	0x002fb907, // n0x1689 c0x0000 (---------------)  + I agrinet
	0x002104c3, // n0x168a c0x0000 (---------------)  + I com
	0x0031b907, // n0x168b c0x0000 (---------------)  + I defense
	0x002e9006, // n0x168c c0x0000 (---------------)  + I edunet
	0x002084c3, // n0x168d c0x0000 (---------------)  + I ens
	0x0023fdc3, // n0x168e c0x0000 (---------------)  + I fin
	0x002150c3, // n0x168f c0x0000 (---------------)  + I gov
	0x0020ca83, // n0x1690 c0x0000 (---------------)  + I ind
	0x002180c4, // n0x1691 c0x0000 (---------------)  + I info
	0x0026e104, // n0x1692 c0x0000 (---------------)  + I intl
	0x00296c46, // n0x1693 c0x0000 (---------------)  + I mincom
	0x00201c83, // n0x1694 c0x0000 (---------------)  + I nat
	0x00239bc3, // n0x1695 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1696 c0x0000 (---------------)  + I org
	0x00297805, // n0x1697 c0x0000 (---------------)  + I perso
	0x00342244, // n0x1698 c0x0000 (---------------)  + I rnrt
	0x00257ac3, // n0x1699 c0x0000 (---------------)  + I rns
	0x00272d43, // n0x169a c0x0000 (---------------)  + I rnu
	0x002aae07, // n0x169b c0x0000 (---------------)  + I tourism
	0x00240d45, // n0x169c c0x0000 (---------------)  + I turen
	0x002104c3, // n0x169d c0x0000 (---------------)  + I com
	0x002ceec3, // n0x169e c0x0000 (---------------)  + I edu
	0x002150c3, // n0x169f c0x0000 (---------------)  + I gov
	0x0025f683, // n0x16a0 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x16a1 c0x0000 (---------------)  + I net
	0x002453c3, // n0x16a2 c0x0000 (---------------)  + I org
	0x49601f42, // n0x16a3 c0x0125 (n0x16a5-n0x16a6)  o I nc
	0x006131c3, // n0x16a4 c0x0001 (---------------)  ! I nic
	0x002150c3, // n0x16a5 c0x0000 (---------------)  + I gov
	0x002251c4, // n0x16a6 c0x0000 (---------------)  + I aero
	0x002b5183, // n0x16a7 c0x0000 (---------------)  + I biz
	0x00208f82, // n0x16a8 c0x0000 (---------------)  + I co
	0x002104c3, // n0x16a9 c0x0000 (---------------)  + I com
	0x00236044, // n0x16aa c0x0000 (---------------)  + I coop
	0x002ceec3, // n0x16ab c0x0000 (---------------)  + I edu
	0x002150c3, // n0x16ac c0x0000 (---------------)  + I gov
	0x002180c4, // n0x16ad c0x0000 (---------------)  + I info
	0x0021fe43, // n0x16ae c0x0000 (---------------)  + I int
	0x00285dc4, // n0x16af c0x0000 (---------------)  + I jobs
	0x0020adc4, // n0x16b0 c0x0000 (---------------)  + I mobi
	0x002b9786, // n0x16b1 c0x0000 (---------------)  + I museum
	0x002d16c4, // n0x16b2 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x16b3 c0x0000 (---------------)  + I net
	0x002453c3, // n0x16b4 c0x0000 (---------------)  + I org
	0x002c5983, // n0x16b5 c0x0000 (---------------)  + I pro
	0x0029ed06, // n0x16b6 c0x0000 (---------------)  + I travel
	0x00043b8b, // n0x16b7 c0x0000 (---------------)  +   better-than
	0x00007546, // n0x16b8 c0x0000 (---------------)  +   dyndns
	0x0001714a, // n0x16b9 c0x0000 (---------------)  +   on-the-web
	0x00133aca, // n0x16ba c0x0000 (---------------)  +   worse-than
	0x00031c88, // n0x16bb c0x0000 (---------------)  +   blogspot
	0x00259cc4, // n0x16bc c0x0000 (---------------)  + I club
	0x002104c3, // n0x16bd c0x0000 (---------------)  + I com
	0x002b5144, // n0x16be c0x0000 (---------------)  + I ebiz
	0x002ceec3, // n0x16bf c0x0000 (---------------)  + I edu
	0x00274604, // n0x16c0 c0x0000 (---------------)  + I game
	0x002150c3, // n0x16c1 c0x0000 (---------------)  + I gov
	0x0025a343, // n0x16c2 c0x0000 (---------------)  + I idv
	0x0025f683, // n0x16c3 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x16c4 c0x0000 (---------------)  + I net
	0x002453c3, // n0x16c5 c0x0000 (---------------)  + I org
	0x002f748b, // n0x16c6 c0x0000 (---------------)  + I xn--czrw28b
	0x0034748a, // n0x16c7 c0x0000 (---------------)  + I xn--uc0atv
	0x0035218c, // n0x16c8 c0x0000 (---------------)  + I xn--zf0ao64a
	0x002028c2, // n0x16c9 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x16ca c0x0000 (---------------)  + I co
	0x002053c2, // n0x16cb c0x0000 (---------------)  + I go
	0x0028ba85, // n0x16cc c0x0000 (---------------)  + I hotel
	0x002180c4, // n0x16cd c0x0000 (---------------)  + I info
	0x00208202, // n0x16ce c0x0000 (---------------)  + I me
	0x0025f683, // n0x16cf c0x0000 (---------------)  + I mil
	0x0020adc4, // n0x16d0 c0x0000 (---------------)  + I mobi
	0x00205f42, // n0x16d1 c0x0000 (---------------)  + I ne
	0x00204282, // n0x16d2 c0x0000 (---------------)  + I or
	0x00201e42, // n0x16d3 c0x0000 (---------------)  + I sc
	0x0027ecc2, // n0x16d4 c0x0000 (---------------)  + I tv
	0x002ba989, // n0x16d5 c0x0000 (---------------)  + I cherkassy
	0x00263cc8, // n0x16d6 c0x0000 (---------------)  + I cherkasy
	0x0027c249, // n0x16d7 c0x0000 (---------------)  + I chernigov
	0x0027f8c9, // n0x16d8 c0x0000 (---------------)  + I chernihiv
	0x00289bca, // n0x16d9 c0x0000 (---------------)  + I chernivtsi
	0x0028ad4a, // n0x16da c0x0000 (---------------)  + I chernovtsy
	0x00200c02, // n0x16db c0x0000 (---------------)  + I ck
	0x0022dc82, // n0x16dc c0x0000 (---------------)  + I cn
	0x00208f82, // n0x16dd c0x0000 (---------------)  + I co
	0x002104c3, // n0x16de c0x0000 (---------------)  + I com
	0x00239282, // n0x16df c0x0000 (---------------)  + I cr
	0x0023b546, // n0x16e0 c0x0000 (---------------)  + I crimea
	0x00317902, // n0x16e1 c0x0000 (---------------)  + I cv
	0x00207602, // n0x16e2 c0x0000 (---------------)  + I dn
	0x0031a28e, // n0x16e3 c0x0000 (---------------)  + I dnepropetrovsk
	0x00338f0e, // n0x16e4 c0x0000 (---------------)  + I dnipropetrovsk
	0x00263b47, // n0x16e5 c0x0000 (---------------)  + I dominic
	0x002ad0c7, // n0x16e6 c0x0000 (---------------)  + I donetsk
	0x002c0cc2, // n0x16e7 c0x0000 (---------------)  + I dp
	0x002ceec3, // n0x16e8 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x16e9 c0x0000 (---------------)  + I gov
	0x00201a82, // n0x16ea c0x0000 (---------------)  + I if
	0x00200242, // n0x16eb c0x0000 (---------------)  + I in
	0x00352e8f, // n0x16ec c0x0000 (---------------)  + I ivano-frankivsk
	0x00244dc2, // n0x16ed c0x0000 (---------------)  + I kh
	0x00257847, // n0x16ee c0x0000 (---------------)  + I kharkiv
	0x0025a8c7, // n0x16ef c0x0000 (---------------)  + I kharkov
	0x00309b07, // n0x16f0 c0x0000 (---------------)  + I kherson
	0x002716cc, // n0x16f1 c0x0000 (---------------)  + I khmelnitskiy
	0x00274e0c, // n0x16f2 c0x0000 (---------------)  + I khmelnytskyi
	0x00205844, // n0x16f3 c0x0000 (---------------)  + I kiev
	0x00264e0a, // n0x16f4 c0x0000 (---------------)  + I kirovograd
	0x0031e782, // n0x16f5 c0x0000 (---------------)  + I km
	0x00203b82, // n0x16f6 c0x0000 (---------------)  + I kr
	0x0029b104, // n0x16f7 c0x0000 (---------------)  + I krym
	0x00203f02, // n0x16f8 c0x0000 (---------------)  + I ks
	0x002a4782, // n0x16f9 c0x0000 (---------------)  + I kv
	0x00275044, // n0x16fa c0x0000 (---------------)  + I kyiv
	0x002132c2, // n0x16fb c0x0000 (---------------)  + I lg
	0x00206502, // n0x16fc c0x0000 (---------------)  + I lt
	0x002a6787, // n0x16fd c0x0000 (---------------)  + I lugansk
	0x0022bbc5, // n0x16fe c0x0000 (---------------)  + I lutsk
	0x00203242, // n0x16ff c0x0000 (---------------)  + I lv
	0x00233c44, // n0x1700 c0x0000 (---------------)  + I lviv
	0x00326902, // n0x1701 c0x0000 (---------------)  + I mk
	0x00352d08, // n0x1702 c0x0000 (---------------)  + I mykolaiv
	0x00239bc3, // n0x1703 c0x0000 (---------------)  + I net
	0x00213d08, // n0x1704 c0x0000 (---------------)  + I nikolaev
	0x00202a02, // n0x1705 c0x0000 (---------------)  + I od
	0x00235885, // n0x1706 c0x0000 (---------------)  + I odesa
	0x0032ba06, // n0x1707 c0x0000 (---------------)  + I odessa
	0x002453c3, // n0x1708 c0x0000 (---------------)  + I org
	0x0020dcc2, // n0x1709 c0x0000 (---------------)  + I pl
	0x002c3007, // n0x170a c0x0000 (---------------)  + I poltava
	0x00208642, // n0x170b c0x0000 (---------------)  + I pp
	0x002c5845, // n0x170c c0x0000 (---------------)  + I rivne
	0x00238fc5, // n0x170d c0x0000 (---------------)  + I rovno
	0x0020af82, // n0x170e c0x0000 (---------------)  + I rv
	0x00231c42, // n0x170f c0x0000 (---------------)  + I sb
	0x002f338a, // n0x1710 c0x0000 (---------------)  + I sebastopol
	0x0034b44a, // n0x1711 c0x0000 (---------------)  + I sevastopol
	0x00215b42, // n0x1712 c0x0000 (---------------)  + I sm
	0x00296344, // n0x1713 c0x0000 (---------------)  + I sumy
	0x00201402, // n0x1714 c0x0000 (---------------)  + I te
	0x002fc348, // n0x1715 c0x0000 (---------------)  + I ternopil
	0x00204d42, // n0x1716 c0x0000 (---------------)  + I uz
	0x00251448, // n0x1717 c0x0000 (---------------)  + I uzhgorod
	0x002e2607, // n0x1718 c0x0000 (---------------)  + I vinnica
	0x002e2d09, // n0x1719 c0x0000 (---------------)  + I vinnytsia
	0x00213cc2, // n0x171a c0x0000 (---------------)  + I vn
	0x002e6085, // n0x171b c0x0000 (---------------)  + I volyn
	0x002dea05, // n0x171c c0x0000 (---------------)  + I yalta
	0x0029864b, // n0x171d c0x0000 (---------------)  + I zaporizhzhe
	0x0035388c, // n0x171e c0x0000 (---------------)  + I zaporizhzhia
	0x002e6448, // n0x171f c0x0000 (---------------)  + I zhitomir
	0x00270588, // n0x1720 c0x0000 (---------------)  + I zhytomyr
	0x002c71c2, // n0x1721 c0x0000 (---------------)  + I zp
	0x0020ef82, // n0x1722 c0x0000 (---------------)  + I zt
	0x002028c2, // n0x1723 c0x0000 (---------------)  + I ac
	0x00208f82, // n0x1724 c0x0000 (---------------)  + I co
	0x002104c3, // n0x1725 c0x0000 (---------------)  + I com
	0x002053c2, // n0x1726 c0x0000 (---------------)  + I go
	0x00205f42, // n0x1727 c0x0000 (---------------)  + I ne
	0x00204282, // n0x1728 c0x0000 (---------------)  + I or
	0x002453c3, // n0x1729 c0x0000 (---------------)  + I org
	0x00201e42, // n0x172a c0x0000 (---------------)  + I sc
	0x0060be42, // n0x172b c0x0001 (---------------)  ! I bl
	0x0061c54f, // n0x172c c0x0001 (---------------)  ! I british-library
	0x4b608f82, // n0x172d c0x012d (n0x1736-n0x1737)  o I co
	0x006dac83, // n0x172e c0x0001 (---------------)  ! I jet
	0x00650983, // n0x172f c0x0001 (---------------)  ! I mod
	0x00608b19, // n0x1730 c0x0001 (---------------)  ! I national-library-scotland
	0x00620f83, // n0x1731 c0x0001 (---------------)  ! I nel
	0x006131c3, // n0x1732 c0x0001 (---------------)  ! I nic
	0x00631643, // n0x1733 c0x0001 (---------------)  ! I nls
	0x0070900a, // n0x1734 c0x0001 (---------------)  ! I parliament
	0x01604343, // n0x1735 c0x0005 (---------------)* o I sch
	0x00031c88, // n0x1736 c0x0000 (---------------)  +   blogspot
	0x4be00782, // n0x1737 c0x012f (n0x1776-n0x1779)  + I ak
	0x4c201dc2, // n0x1738 c0x0130 (n0x1779-n0x177c)  + I al
	0x4c603902, // n0x1739 c0x0131 (n0x177c-n0x177f)  + I ar
	0x4ca00182, // n0x173a c0x0132 (n0x177f-n0x1782)  + I as
	0x4ce0b342, // n0x173b c0x0133 (n0x1782-n0x1785)  + I az
	0x4d200402, // n0x173c c0x0134 (n0x1785-n0x1788)  + I ca
	0x4d608f82, // n0x173d c0x0135 (n0x1788-n0x178b)  + I co
	0x4da31542, // n0x173e c0x0136 (n0x178b-n0x178e)  + I ct
	0x4de003c2, // n0x173f c0x0137 (n0x178e-n0x1791)  + I dc
	0x4e209102, // n0x1740 c0x0138 (n0x1791-n0x1794)  + I de
	0x002e01c3, // n0x1741 c0x0000 (---------------)  + I dni
	0x00252383, // n0x1742 c0x0000 (---------------)  + I fed
	0x4e641742, // n0x1743 c0x0139 (n0x1794-n0x1797)  + I fl
	0x4ea008c2, // n0x1744 c0x013a (n0x1797-n0x179a)  + I ga
	0x4ee07f02, // n0x1745 c0x013b (n0x179a-n0x179d)  + I gu
	0x4f200202, // n0x1746 c0x013c (n0x179d-n0x179f)  + I hi
	0x4f601102, // n0x1747 c0x013d (n0x179f-n0x17a2)  + I ia
	0x4fa0ab82, // n0x1748 c0x013e (n0x17a2-n0x17a5)  + I id
	0x4fe05682, // n0x1749 c0x013f (n0x17a5-n0x17a8)  + I il
	0x50200242, // n0x174a c0x0140 (n0x17a8-n0x17ab)  + I in
	0x000caf45, // n0x174b c0x0000 (---------------)  +   is-by
	0x00226dc3, // n0x174c c0x0000 (---------------)  + I isa
	0x0031c804, // n0x174d c0x0000 (---------------)  + I kids
	0x50603f02, // n0x174e c0x0141 (n0x17ab-n0x17ae)  + I ks
	0x50a1ed02, // n0x174f c0x0142 (n0x17ae-n0x17b1)  + I ky
	0x50e000c2, // n0x1750 c0x0143 (n0x17b1-n0x17b4)  + I la
	0x0009fd4b, // n0x1751 c0x0000 (---------------)  +   land-4-sale
	0x51200742, // n0x1752 c0x0144 (n0x17b4-n0x17b7)  + I ma
	0x51a106c2, // n0x1753 c0x0146 (n0x17ba-n0x17bd)  + I md
	0x51e08202, // n0x1754 c0x0147 (n0x17bd-n0x17c0)  + I me
	0x52200e02, // n0x1755 c0x0148 (n0x17c0-n0x17c3)  + I mi
	0x52603cc2, // n0x1756 c0x0149 (n0x17c3-n0x17c6)  + I mn
	0x52a0a782, // n0x1757 c0x014a (n0x17c6-n0x17c9)  + I mo
	0x52e22fc2, // n0x1758 c0x014b (n0x17c9-n0x17cc)  + I ms
	0x53252e82, // n0x1759 c0x014c (n0x17cc-n0x17cf)  + I mt
	0x53601f42, // n0x175a c0x014d (n0x17cf-n0x17d2)  + I nc
	0x53a00382, // n0x175b c0x014e (n0x17d2-n0x17d5)  + I nd
	0x53e05f42, // n0x175c c0x014f (n0x17d5-n0x17d8)  + I ne
	0x54213c02, // n0x175d c0x0150 (n0x17d8-n0x17db)  + I nh
	0x5460ee42, // n0x175e c0x0151 (n0x17db-n0x17de)  + I nj
	0x54a0ad82, // n0x175f c0x0152 (n0x17de-n0x17e1)  + I nm
	0x00225003, // n0x1760 c0x0000 (---------------)  + I nsn
	0x54e13442, // n0x1761 c0x0153 (n0x17e1-n0x17e4)  + I nv
	0x55216042, // n0x1762 c0x0154 (n0x17e4-n0x17e7)  + I ny
	0x5560a582, // n0x1763 c0x0155 (n0x17e7-n0x17ea)  + I oh
	0x55a00d42, // n0x1764 c0x0156 (n0x17ea-n0x17ed)  + I ok
	0x55e04282, // n0x1765 c0x0157 (n0x17ed-n0x17f0)  + I or
	0x56211382, // n0x1766 c0x0158 (n0x17f0-n0x17f3)  + I pa
	0x5660e2c2, // n0x1767 c0x0159 (n0x17f3-n0x17f6)  + I pr
	0x56a042c2, // n0x1768 c0x015a (n0x17f6-n0x17f9)  + I ri
	0x56e01e42, // n0x1769 c0x015b (n0x17f9-n0x17fc)  + I sc
	0x5724db82, // n0x176a c0x015c (n0x17fc-n0x17ff)  + I sd
	0x000ddfcc, // n0x176b c0x0000 (---------------)  +   stuff-4-sale
	0x5760ff42, // n0x176c c0x015d (n0x17ff-n0x1802)  + I tn
	0x57a5b602, // n0x176d c0x015e (n0x1802-n0x1805)  + I tx
	0x57e0a2c2, // n0x176e c0x015f (n0x1805-n0x1808)  + I ut
	0x58202b82, // n0x176f c0x0160 (n0x1808-n0x180b)  + I va
	0x5860afc2, // n0x1770 c0x0161 (n0x180b-n0x180e)  + I vi
	0x58a5c582, // n0x1771 c0x0162 (n0x180e-n0x1811)  + I vt
	0x58e00142, // n0x1772 c0x0163 (n0x1811-n0x1814)  + I wa
	0x59207b02, // n0x1773 c0x0164 (n0x1814-n0x1817)  + I wi
	0x5965cdc2, // n0x1774 c0x0165 (n0x1817-n0x181a)  + I wv
	0x59a3b882, // n0x1775 c0x0166 (n0x181a-n0x181d)  + I wy
	0x00201942, // n0x1776 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1777 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1778 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1779 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x177a c0x0000 (---------------)  + I k12
	0x00208d43, // n0x177b c0x0000 (---------------)  + I lib
	0x00201942, // n0x177c c0x0000 (---------------)  + I cc
	0x002edec3, // n0x177d c0x0000 (---------------)  + I k12
	0x00208d43, // n0x177e c0x0000 (---------------)  + I lib
	0x00201942, // n0x177f c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1780 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1781 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1782 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1783 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1784 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1785 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1786 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1787 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1788 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1789 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x178a c0x0000 (---------------)  + I lib
	0x00201942, // n0x178b c0x0000 (---------------)  + I cc
	0x002edec3, // n0x178c c0x0000 (---------------)  + I k12
	0x00208d43, // n0x178d c0x0000 (---------------)  + I lib
	0x00201942, // n0x178e c0x0000 (---------------)  + I cc
	0x002edec3, // n0x178f c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1790 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1791 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1792 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1793 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1794 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1795 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1796 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1797 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1798 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1799 c0x0000 (---------------)  + I lib
	0x00201942, // n0x179a c0x0000 (---------------)  + I cc
	0x002edec3, // n0x179b c0x0000 (---------------)  + I k12
	0x00208d43, // n0x179c c0x0000 (---------------)  + I lib
	0x00201942, // n0x179d c0x0000 (---------------)  + I cc
	0x00208d43, // n0x179e c0x0000 (---------------)  + I lib
	0x00201942, // n0x179f c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17a0 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17a1 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17a2 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17a3 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17a4 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17a5 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17a6 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17a7 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17a8 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17a9 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17aa c0x0000 (---------------)  + I lib
	0x00201942, // n0x17ab c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17ac c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17ad c0x0000 (---------------)  + I lib
	0x00201942, // n0x17ae c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17af c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17b0 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17b1 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17b2 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17b3 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17b4 c0x0000 (---------------)  + I cc
	0x516edec3, // n0x17b5 c0x0145 (n0x17b7-n0x17ba)  + I k12
	0x00208d43, // n0x17b6 c0x0000 (---------------)  + I lib
	0x0031b5c4, // n0x17b7 c0x0000 (---------------)  + I chtr
	0x002c1446, // n0x17b8 c0x0000 (---------------)  + I paroch
	0x002c75c3, // n0x17b9 c0x0000 (---------------)  + I pvt
	0x00201942, // n0x17ba c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17bb c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17bc c0x0000 (---------------)  + I lib
	0x00201942, // n0x17bd c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17be c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17bf c0x0000 (---------------)  + I lib
	0x00201942, // n0x17c0 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17c1 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17c2 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17c3 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17c4 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17c5 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17c6 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17c7 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17c8 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17c9 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17ca c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17cb c0x0000 (---------------)  + I lib
	0x00201942, // n0x17cc c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17cd c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17ce c0x0000 (---------------)  + I lib
	0x00201942, // n0x17cf c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17d0 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17d1 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17d2 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17d3 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17d4 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17d5 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17d6 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17d7 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17d8 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17d9 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17da c0x0000 (---------------)  + I lib
	0x00201942, // n0x17db c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17dc c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17dd c0x0000 (---------------)  + I lib
	0x00201942, // n0x17de c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17df c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17e0 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17e1 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17e2 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17e3 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17e4 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17e5 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17e6 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17e7 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17e8 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17e9 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17ea c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17eb c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17ec c0x0000 (---------------)  + I lib
	0x00201942, // n0x17ed c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17ee c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17ef c0x0000 (---------------)  + I lib
	0x00201942, // n0x17f0 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17f1 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17f2 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17f3 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17f4 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17f5 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17f6 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17f7 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17f8 c0x0000 (---------------)  + I lib
	0x00201942, // n0x17f9 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17fa c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17fb c0x0000 (---------------)  + I lib
	0x00201942, // n0x17fc c0x0000 (---------------)  + I cc
	0x002edec3, // n0x17fd c0x0000 (---------------)  + I k12
	0x00208d43, // n0x17fe c0x0000 (---------------)  + I lib
	0x00201942, // n0x17ff c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1800 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1801 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1802 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1803 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1804 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1805 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1806 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1807 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1808 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1809 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x180a c0x0000 (---------------)  + I lib
	0x00201942, // n0x180b c0x0000 (---------------)  + I cc
	0x002edec3, // n0x180c c0x0000 (---------------)  + I k12
	0x00208d43, // n0x180d c0x0000 (---------------)  + I lib
	0x00201942, // n0x180e c0x0000 (---------------)  + I cc
	0x002edec3, // n0x180f c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1810 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1811 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1812 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1813 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1814 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1815 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1816 c0x0000 (---------------)  + I lib
	0x00201942, // n0x1817 c0x0000 (---------------)  + I cc
	0x002edec3, // n0x1818 c0x0000 (---------------)  + I k12
	0x00208d43, // n0x1819 c0x0000 (---------------)  + I lib
	0x00201942, // n0x181a c0x0000 (---------------)  + I cc
	0x002edec3, // n0x181b c0x0000 (---------------)  + I k12
	0x00208d43, // n0x181c c0x0000 (---------------)  + I lib
	0x002104c3, // n0x181d c0x0000 (---------------)  + I com
	0x002ceec3, // n0x181e c0x0000 (---------------)  + I edu
	0x002ed383, // n0x181f c0x0000 (---------------)  + I gub
	0x0025f683, // n0x1820 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1821 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1822 c0x0000 (---------------)  + I org
	0x00208f82, // n0x1823 c0x0000 (---------------)  + I co
	0x002104c3, // n0x1824 c0x0000 (---------------)  + I com
	0x00239bc3, // n0x1825 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1826 c0x0000 (---------------)  + I org
	0x002104c3, // n0x1827 c0x0000 (---------------)  + I com
	0x002ceec3, // n0x1828 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1829 c0x0000 (---------------)  + I gov
	0x0025f683, // n0x182a c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x182b c0x0000 (---------------)  + I net
	0x002453c3, // n0x182c c0x0000 (---------------)  + I org
	0x00208f82, // n0x182d c0x0000 (---------------)  + I co
	0x002104c3, // n0x182e c0x0000 (---------------)  + I com
	0x002fd1c3, // n0x182f c0x0000 (---------------)  + I e12
	0x002ceec3, // n0x1830 c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1831 c0x0000 (---------------)  + I gov
	0x002180c4, // n0x1832 c0x0000 (---------------)  + I info
	0x0025f683, // n0x1833 c0x0000 (---------------)  + I mil
	0x00239bc3, // n0x1834 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1835 c0x0000 (---------------)  + I org
	0x00209243, // n0x1836 c0x0000 (---------------)  + I web
	0x00208f82, // n0x1837 c0x0000 (---------------)  + I co
	0x002104c3, // n0x1838 c0x0000 (---------------)  + I com
	0x002edec3, // n0x1839 c0x0000 (---------------)  + I k12
	0x00239bc3, // n0x183a c0x0000 (---------------)  + I net
	0x002453c3, // n0x183b c0x0000 (---------------)  + I org
	0x002028c2, // n0x183c c0x0000 (---------------)  + I ac
	0x002b5183, // n0x183d c0x0000 (---------------)  + I biz
	0x002104c3, // n0x183e c0x0000 (---------------)  + I com
	0x002ceec3, // n0x183f c0x0000 (---------------)  + I edu
	0x002150c3, // n0x1840 c0x0000 (---------------)  + I gov
	0x0021a586, // n0x1841 c0x0000 (---------------)  + I health
	0x002180c4, // n0x1842 c0x0000 (---------------)  + I info
	0x0021fe43, // n0x1843 c0x0000 (---------------)  + I int
	0x002d16c4, // n0x1844 c0x0000 (---------------)  + I name
	0x00239bc3, // n0x1845 c0x0000 (---------------)  + I net
	0x002453c3, // n0x1846 c0x0000 (---------------)  + I org
	0x002c5983, // n0x1847 c0x0000 (---------------)  + I pro
	0x002104c3, // n0x1848 c0x0000 (---------------)  + I com
	0x00007546, // n0x1849 c0x0000 (---------------)  +   dyndns
	0x002ceec3, // n0x184a c0x0000 (---------------)  + I edu
	0x002150c3, // n0x184b c0x0000 (---------------)  + I gov
	0x000963c6, // n0x184c c0x0000 (---------------)  +   mypets
	0x00239bc3, // n0x184d c0x0000 (---------------)  + I net
	0x002453c3, // n0x184e c0x0000 (---------------)  + I org
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x005dc171, // c0x0006 (n0x0171-n0x0177)  +
	0x005e0177, // c0x0007 (n0x0177-n0x0178)  +
	0x005fc178, // c0x0008 (n0x0178-n0x017f)  +
	0x0076017f, // c0x0009 (n0x017f-n0x01d8)  +
	0x007741d8, // c0x000a (n0x01d8-n0x01dd)  +
	0x007881dd, // c0x000b (n0x01dd-n0x01e2)  +
	0x007981e2, // c0x000c (n0x01e2-n0x01e6)  +
	0x007b01e6, // c0x000d (n0x01e6-n0x01ec)  +
	0x007c01ec, // c0x000e (n0x01ec-n0x01f0)  +
	0x007d81f0, // c0x000f (n0x01f0-n0x01f6)  +
	0x007f81f6, // c0x0010 (n0x01f6-n0x01fe)  +
	0x007fc1fe, // c0x0011 (n0x01fe-n0x01ff)  +
	0x208141ff, // c0x0012 (n0x01ff-n0x0205)  o
	0x00818205, // c0x0013 (n0x0205-n0x0206)  +
	0x00834206, // c0x0014 (n0x0206-n0x020d)  +
	0x0083820d, // c0x0015 (n0x020d-n0x020e)  +
	0x2088420e, // c0x0016 (n0x020e-n0x0221)  o
	0x00888221, // c0x0017 (n0x0221-n0x0222)  +
	0x008a8222, // c0x0018 (n0x0222-n0x022a)  +
	0x008c422a, // c0x0019 (n0x022a-n0x0231)  +
	0x008c8231, // c0x001a (n0x0231-n0x0232)  +
	0x008f8232, // c0x001b (n0x0232-n0x023e)  +
	0x0092023e, // c0x001c (n0x023e-n0x0248)  +
	0x00940248, // c0x001d (n0x0248-n0x0250)  +
	0x00948250, // c0x001e (n0x0250-n0x0252)  +
	0x0094c252, // c0x001f (n0x0252-n0x0253)  +
	0x009dc253, // c0x0020 (n0x0253-n0x0277)  +
	0x009f0277, // c0x0021 (n0x0277-n0x027c)  +
	0x00a0427c, // c0x0022 (n0x027c-n0x0281)  +
	0x00a20281, // c0x0023 (n0x0281-n0x0288)  +
	0x00a30288, // c0x0024 (n0x0288-n0x028c)  +
	0x00a4428c, // c0x0025 (n0x028c-n0x0291)  +
	0x00a68291, // c0x0026 (n0x0291-n0x029a)  +
	0x00b7c29a, // c0x0027 (n0x029a-n0x02df)  +
	0x00b802df, // c0x0028 (n0x02df-n0x02e0)  +
	0x00b942e0, // c0x0029 (n0x02e0-n0x02e5)  +
	0x00ba82e5, // c0x002a (n0x02e5-n0x02ea)  +
	0x00bb02ea, // c0x002b (n0x02ea-n0x02ec)  +
	0x00bc02ec, // c0x002c (n0x02ec-n0x02f0)  +
	0x00bd42f0, // c0x002d (n0x02f0-n0x02f5)  +
	0x00c182f5, // c0x002e (n0x02f5-n0x0306)  +
	0x00c28306, // c0x002f (n0x0306-n0x030a)  +
	0x00c2c30a, // c0x0030 (n0x030a-n0x030b)  +
	0x00c3030b, // c0x0031 (n0x030b-n0x030c)  +
	0x00c3430c, // c0x0032 (n0x030c-n0x030d)  +
	0x00c7030d, // c0x0033 (n0x030d-n0x031c)  +
	0x60c7431c, // c0x0034 (n0x031c-n0x031d)* o
	0x00c8431d, // c0x0035 (n0x031d-n0x0321)  +
	0x00c88321, // c0x0036 (n0x0321-n0x0322)  +
	0x00d38322, // c0x0037 (n0x0322-n0x034e)  +
	0x00d6c34e, // c0x0038 (n0x034e-n0x035b)  +
	0x0105035b, // c0x0039 (n0x035b-n0x0414)  +
	0x210ac414, // c0x003a (n0x0414-n0x042b)  o
	0x010cc42b, // c0x003b (n0x042b-n0x0433)  +
	0x010d4433, // c0x003c (n0x0433-n0x0435)  +
	0x010f0435, // c0x003d (n0x0435-n0x043c)  +
	0x0110843c, // c0x003e (n0x043c-n0x0442)  +
	0x0110c442, // c0x003f (n0x0442-n0x0443)  +
	0x0111c443, // c0x0040 (n0x0443-n0x0447)  +
	0x01124447, // c0x0041 (n0x0447-n0x0449)  +
	0x01128449, // c0x0042 (n0x0449-n0x044a)  +
	0x0114844a, // c0x0043 (n0x044a-n0x0452)  +
	0x0114c452, // c0x0044 (n0x0452-n0x0453)  +
	0x01160453, // c0x0045 (n0x0453-n0x0458)  +
	0x01188458, // c0x0046 (n0x0458-n0x0462)  +
	0x011a8462, // c0x0047 (n0x0462-n0x046a)  +
	0x011d846a, // c0x0048 (n0x046a-n0x0476)  +
	0x01200476, // c0x0049 (n0x0476-n0x0480)  +
	0x01224480, // c0x004a (n0x0480-n0x0489)  +
	0x01238489, // c0x004b (n0x0489-n0x048e)  +
	0x0123c48e, // c0x004c (n0x048e-n0x048f)  +
	0x0124848f, // c0x004d (n0x048f-n0x0492)  +
	0x012a8492, // c0x004e (n0x0492-n0x04aa)  +
	0x012c44aa, // c0x004f (n0x04aa-n0x04b1)  +
	0x012d84b1, // c0x0050 (n0x04b1-n0x04b6)  +
	0x012ec4b6, // c0x0051 (n0x04b6-n0x04bb)  +
	0x013044bb, // c0x0052 (n0x04bb-n0x04c1)  +
	0x2131c4c1, // c0x0053 (n0x04c1-n0x04c7)  o
	0x013344c7, // c0x0054 (n0x04c7-n0x04cd)  +
	0x0134c4cd, // c0x0055 (n0x04cd-n0x04d3)  +
	0x013684d3, // c0x0056 (n0x04d3-n0x04da)  +
	0x013744da, // c0x0057 (n0x04da-n0x04dd)  +
	0x013cc4dd, // c0x0058 (n0x04dd-n0x04f3)  +
	0x013e44f3, // c0x0059 (n0x04f3-n0x04f9)  +
	0x013f44f9, // c0x005a (n0x04f9-n0x04fd)  +
	0x014384fd, // c0x005b (n0x04fd-n0x050e)  +
	0x014b850e, // c0x005c (n0x050e-n0x052e)  +
	0x014e052e, // c0x005d (n0x052e-n0x0538)  +
	0x014e8538, // c0x005e (n0x0538-n0x053a)  +
	0x614ec53a, // c0x005f (n0x053a-n0x053b)* o
	0x214f053b, // c0x0060 (n0x053b-n0x053c)  o
	0x0150853c, // c0x0061 (n0x053c-n0x0542)  +
	0x01510542, // c0x0062 (n0x0542-n0x0544)  +
	0x01544544, // c0x0063 (n0x0544-n0x0551)  +
	0x0156c551, // c0x0064 (n0x0551-n0x055b)  +
	0x0157055b, // c0x0065 (n0x055b-n0x055c)  +
	0x0157855c, // c0x0066 (n0x055c-n0x055e)  +
	0x0159055e, // c0x0067 (n0x055e-n0x0564)  +
	0x015b4564, // c0x0068 (n0x0564-n0x056d)  +
	0x015cc56d, // c0x0069 (n0x056d-n0x0573)  +
	0x01a24573, // c0x006a (n0x0573-n0x0689)  +
	0x01a38689, // c0x006b (n0x0689-n0x068e)  +
	0x01a5868e, // c0x006c (n0x068e-n0x0696)  +
	0x01b58696, // c0x006d (n0x0696-n0x06d6)  +
	0x01c2c6d6, // c0x006e (n0x06d6-n0x070b)  +
	0x01c9c70b, // c0x006f (n0x070b-n0x0727)  +
	0x01cf4727, // c0x0070 (n0x0727-n0x073d)  +
	0x01ddc73d, // c0x0071 (n0x073d-n0x0777)  +
	0x01e34777, // c0x0072 (n0x0777-n0x078d)  +
	0x01e7078d, // c0x0073 (n0x078d-n0x079c)  +
	0x01f6c79c, // c0x0074 (n0x079c-n0x07db)  +
	0x020387db, // c0x0075 (n0x07db-n0x080e)  +
	0x020d080e, // c0x0076 (n0x080e-n0x0834)  +
	0x02160834, // c0x0077 (n0x0834-n0x0858)  +
	0x021c4858, // c0x0078 (n0x0858-n0x0871)  +
	0x023fc871, // c0x0079 (n0x0871-n0x08ff)  +
	0x024b48ff, // c0x007a (n0x08ff-n0x092d)  +
	0x0258092d, // c0x007b (n0x092d-n0x0960)  +
	0x025cc960, // c0x007c (n0x0960-n0x0973)  +
	0x02658973, // c0x007d (n0x0973-n0x0996)  +
	0x02694996, // c0x007e (n0x0996-n0x09a5)  +
	0x026e49a5, // c0x007f (n0x09a5-n0x09b9)  +
	0x0275c9b9, // c0x0080 (n0x09b9-n0x09d7)  +
	0x627609d7, // c0x0081 (n0x09d7-n0x09d8)* o
	0x627649d8, // c0x0082 (n0x09d8-n0x09d9)* o
	0x627689d9, // c0x0083 (n0x09d9-n0x09da)* o
	0x027e49da, // c0x0084 (n0x09da-n0x09f9)  +
	0x0284c9f9, // c0x0085 (n0x09f9-n0x0a13)  +
	0x028c8a13, // c0x0086 (n0x0a13-n0x0a32)  +
	0x02940a32, // c0x0087 (n0x0a32-n0x0a50)  +
	0x029c4a50, // c0x0088 (n0x0a50-n0x0a71)  +
	0x02a30a71, // c0x0089 (n0x0a71-n0x0a8c)  +
	0x02b5ca8c, // c0x008a (n0x0a8c-n0x0ad7)  +
	0x02bb4ad7, // c0x008b (n0x0ad7-n0x0aed)  +
	0x62bb8aed, // c0x008c (n0x0aed-n0x0aee)* o
	0x02c50aee, // c0x008d (n0x0aee-n0x0b14)  +
	0x02cd8b14, // c0x008e (n0x0b14-n0x0b36)  +
	0x02d24b36, // c0x008f (n0x0b36-n0x0b49)  +
	0x02d8cb49, // c0x0090 (n0x0b49-n0x0b63)  +
	0x02e34b63, // c0x0091 (n0x0b63-n0x0b8d)  +
	0x02efcb8d, // c0x0092 (n0x0b8d-n0x0bbf)  +
	0x02f64bbf, // c0x0093 (n0x0bbf-n0x0bd9)  +
	0x03078bd9, // c0x0094 (n0x0bd9-n0x0c1e)  +
	0x6307cc1e, // c0x0095 (n0x0c1e-n0x0c1f)* o
	0x63080c1f, // c0x0096 (n0x0c1f-n0x0c20)* o
	0x030dcc20, // c0x0097 (n0x0c20-n0x0c37)  +
	0x03138c37, // c0x0098 (n0x0c37-n0x0c4e)  +
	0x031c8c4e, // c0x0099 (n0x0c4e-n0x0c72)  +
	0x03244c72, // c0x009a (n0x0c72-n0x0c91)  +
	0x03288c91, // c0x009b (n0x0c91-n0x0ca2)  +
	0x0336cca2, // c0x009c (n0x0ca2-n0x0cdb)  +
	0x033a0cdb, // c0x009d (n0x0cdb-n0x0ce8)  +
	0x03400ce8, // c0x009e (n0x0ce8-n0x0d00)  +
	0x03474d00, // c0x009f (n0x0d00-n0x0d1d)  +
	0x034fcd1d, // c0x00a0 (n0x0d1d-n0x0d3f)  +
	0x0353cd3f, // c0x00a1 (n0x0d3f-n0x0d4f)  +
	0x035acd4f, // c0x00a2 (n0x0d4f-n0x0d6b)  +
	0x635b0d6b, // c0x00a3 (n0x0d6b-n0x0d6c)* o
	0x035c8d6c, // c0x00a4 (n0x0d6c-n0x0d72)  +
	0x035e4d72, // c0x00a5 (n0x0d72-n0x0d79)  +
	0x03628d79, // c0x00a6 (n0x0d79-n0x0d8a)  +
	0x03638d8a, // c0x00a7 (n0x0d8a-n0x0d8e)  +
	0x23650d8e, // c0x00a8 (n0x0d8e-n0x0d94)  o
	0x036c8d94, // c0x00a9 (n0x0d94-n0x0db2)  +
	0x036dcdb2, // c0x00aa (n0x0db2-n0x0db7)  +
	0x036f4db7, // c0x00ab (n0x0db7-n0x0dbd)  +
	0x03718dbd, // c0x00ac (n0x0dbd-n0x0dc6)  +
	0x2372cdc6, // c0x00ad (n0x0dc6-n0x0dcb)  o
	0x03744dcb, // c0x00ae (n0x0dcb-n0x0dd1)  +
	0x0377cdd1, // c0x00af (n0x0dd1-n0x0ddf)  +
	0x23790ddf, // c0x00b0 (n0x0ddf-n0x0de4)  o
	0x03798de4, // c0x00b1 (n0x0de4-n0x0de6)  +
	0x0379cde6, // c0x00b2 (n0x0de6-n0x0de7)  +
	0x037c0de7, // c0x00b3 (n0x0de7-n0x0df0)  +
	0x037e4df0, // c0x00b4 (n0x0df0-n0x0df9)  +
	0x037fcdf9, // c0x00b5 (n0x0df9-n0x0dff)  +
	0x03804dff, // c0x00b6 (n0x0dff-n0x0e01)  +
	0x03824e01, // c0x00b7 (n0x0e01-n0x0e09)  +
	0x03844e09, // c0x00b8 (n0x0e09-n0x0e11)  +
	0x03860e11, // c0x00b9 (n0x0e11-n0x0e18)  +
	0x0387ce18, // c0x00ba (n0x0e18-n0x0e1f)  +
	0x0388ce1f, // c0x00bb (n0x0e1f-n0x0e23)  +
	0x038a0e23, // c0x00bc (n0x0e23-n0x0e28)  +
	0x038a8e28, // c0x00bd (n0x0e28-n0x0e2a)  +
	0x038c4e2a, // c0x00be (n0x0e2a-n0x0e31)  +
	0x04154e31, // c0x00bf (n0x0e31-n0x1055)  +
	0x0418d055, // c0x00c0 (n0x1055-n0x1063)  +
	0x041b9063, // c0x00c1 (n0x1063-n0x106e)  +
	0x041d106e, // c0x00c2 (n0x106e-n0x1074)  +
	0x041ed074, // c0x00c3 (n0x1074-n0x107b)  +
	0x641f107b, // c0x00c4 (n0x107b-n0x107c)* o
	0x0423507c, // c0x00c5 (n0x107c-n0x108d)  +
	0x0423d08d, // c0x00c6 (n0x108d-n0x108f)  +
	0x2424108f, // c0x00c7 (n0x108f-n0x1090)  o
	0x24245090, // c0x00c8 (n0x1090-n0x1091)  o
	0x04249091, // c0x00c9 (n0x1091-n0x1092)  +
	0x042f5092, // c0x00ca (n0x1092-n0x10bd)  +
	0x242fd0bd, // c0x00cb (n0x10bd-n0x10bf)  o
	0x243050bf, // c0x00cc (n0x10bf-n0x10c1)  o
	0x243110c1, // c0x00cd (n0x10c1-n0x10c4)  o
	0x043390c4, // c0x00ce (n0x10c4-n0x10ce)  +
	0x0435d0ce, // c0x00cf (n0x10ce-n0x10d7)  +
	0x043690d7, // c0x00d0 (n0x10d7-n0x10da)  +
	0x04ec10da, // c0x00d1 (n0x10da-n0x13b0)  +
	0x04ec53b0, // c0x00d2 (n0x13b0-n0x13b1)  +
	0x04ec93b1, // c0x00d3 (n0x13b1-n0x13b2)  +
	0x24ecd3b2, // c0x00d4 (n0x13b2-n0x13b3)  o
	0x04ed13b3, // c0x00d5 (n0x13b3-n0x13b4)  +
	0x24ed53b4, // c0x00d6 (n0x13b4-n0x13b5)  o
	0x04ed93b5, // c0x00d7 (n0x13b5-n0x13b6)  +
	0x24ee53b6, // c0x00d8 (n0x13b6-n0x13b9)  o
	0x04ee93b9, // c0x00d9 (n0x13b9-n0x13ba)  +
	0x04eed3ba, // c0x00da (n0x13ba-n0x13bb)  +
	0x24ef13bb, // c0x00db (n0x13bb-n0x13bc)  o
	0x04ef53bc, // c0x00dc (n0x13bc-n0x13bd)  +
	0x24efd3bd, // c0x00dd (n0x13bd-n0x13bf)  o
	0x04f013bf, // c0x00de (n0x13bf-n0x13c0)  +
	0x04f053c0, // c0x00df (n0x13c0-n0x13c1)  +
	0x24f153c1, // c0x00e0 (n0x13c1-n0x13c5)  o
	0x04f193c5, // c0x00e1 (n0x13c5-n0x13c6)  +
	0x04f1d3c6, // c0x00e2 (n0x13c6-n0x13c7)  +
	0x04f213c7, // c0x00e3 (n0x13c7-n0x13c8)  +
	0x04f253c8, // c0x00e4 (n0x13c8-n0x13c9)  +
	0x24f293c9, // c0x00e5 (n0x13c9-n0x13ca)  o
	0x04f2d3ca, // c0x00e6 (n0x13ca-n0x13cb)  +
	0x04f313cb, // c0x00e7 (n0x13cb-n0x13cc)  +
	0x04f353cc, // c0x00e8 (n0x13cc-n0x13cd)  +
	0x04f393cd, // c0x00e9 (n0x13cd-n0x13ce)  +
	0x24f413ce, // c0x00ea (n0x13ce-n0x13d0)  o
	0x04f453d0, // c0x00eb (n0x13d0-n0x13d1)  +
	0x04f493d1, // c0x00ec (n0x13d1-n0x13d2)  +
	0x04f4d3d2, // c0x00ed (n0x13d2-n0x13d3)  +
	0x24f513d3, // c0x00ee (n0x13d3-n0x13d4)  o
	0x04f553d4, // c0x00ef (n0x13d4-n0x13d5)  +
	0x24f5d3d5, // c0x00f0 (n0x13d5-n0x13d7)  o
	0x24f613d7, // c0x00f1 (n0x13d7-n0x13d8)  o
	0x04f7d3d8, // c0x00f2 (n0x13d8-n0x13df)  +
	0x04f893df, // c0x00f3 (n0x13df-n0x13e2)  +
	0x64f8d3e2, // c0x00f4 (n0x13e2-n0x13e3)* o
	0x24f913e3, // c0x00f5 (n0x13e3-n0x13e4)  o
	0x04fdd3e4, // c0x00f6 (n0x13e4-n0x13f7)  +
	0x050b13f7, // c0x00f7 (n0x13f7-n0x142c)  +
	0x050b942c, // c0x00f8 (n0x142c-n0x142e)  +
	0x050e542e, // c0x00f9 (n0x142e-n0x1439)  +
	0x05101439, // c0x00fa (n0x1439-n0x1440)  +
	0x0510d440, // c0x00fb (n0x1440-n0x1443)  +
	0x0512d443, // c0x00fc (n0x1443-n0x144b)  +
	0x0516544b, // c0x00fd (n0x144b-n0x1459)  +
	0x05411459, // c0x00fe (n0x1459-n0x1504)  +
	0x05435504, // c0x00ff (n0x1504-n0x150d)  +
	0x0544950d, // c0x0100 (n0x150d-n0x1512)  +
	0x0547d512, // c0x0101 (n0x1512-n0x151f)  +
	0x0549951f, // c0x0102 (n0x151f-n0x1526)  +
	0x054b5526, // c0x0103 (n0x1526-n0x152d)  +
	0x054d952d, // c0x0104 (n0x152d-n0x1536)  +
	0x054f1536, // c0x0105 (n0x1536-n0x153c)  +
	0x0550d53c, // c0x0106 (n0x153c-n0x1543)  +
	0x0552d543, // c0x0107 (n0x1543-n0x154b)  +
	0x0553d54b, // c0x0108 (n0x154b-n0x154f)  +
	0x0556d54f, // c0x0109 (n0x154f-n0x155b)  +
	0x0558555b, // c0x010a (n0x155b-n0x1561)  +
	0x05799561, // c0x010b (n0x1561-n0x15e6)  +
	0x057bd5e6, // c0x010c (n0x15e6-n0x15ef)  +
	0x057dd5ef, // c0x010d (n0x15ef-n0x15f7)  +
	0x057f15f7, // c0x010e (n0x15f7-n0x15fc)  +
	0x058055fc, // c0x010f (n0x15fc-n0x1601)  +
	0x05825601, // c0x0110 (n0x1601-n0x1609)  +
	0x058c9609, // c0x0111 (n0x1609-n0x1632)  +
	0x058e5632, // c0x0112 (n0x1632-n0x1639)  +
	0x058f9639, // c0x0113 (n0x1639-n0x163e)  +
	0x058fd63e, // c0x0114 (n0x163e-n0x163f)  +
	0x0591163f, // c0x0115 (n0x163f-n0x1644)  +
	0x0592d644, // c0x0116 (n0x1644-n0x164b)  +
	0x0593964b, // c0x0117 (n0x164b-n0x164e)  +
	0x0596964e, // c0x0118 (n0x164e-n0x165a)  +
	0x0597d65a, // c0x0119 (n0x165a-n0x165f)  +
	0x0598165f, // c0x011a (n0x165f-n0x1660)  +
	0x05999660, // c0x011b (n0x1660-n0x1666)  +
	0x059a5666, // c0x011c (n0x1666-n0x1669)  +
	0x059a9669, // c0x011d (n0x1669-n0x166a)  +
	0x059c566a, // c0x011e (n0x166a-n0x1671)  +
	0x05a01671, // c0x011f (n0x1671-n0x1680)  +
	0x05a05680, // c0x0120 (n0x1680-n0x1681)  +
	0x05a25681, // c0x0121 (n0x1681-n0x1689)  +
	0x05a75689, // c0x0122 (n0x1689-n0x169d)  +
	0x05a8d69d, // c0x0123 (n0x169d-n0x16a3)  +
	0x65a956a3, // c0x0124 (n0x16a3-n0x16a5)* o
	0x25a996a5, // c0x0125 (n0x16a5-n0x16a6)  o
	0x05add6a6, // c0x0126 (n0x16a6-n0x16b7)  +
	0x05aed6b7, // c0x0127 (n0x16b7-n0x16bb)  +
	0x05b256bb, // c0x0128 (n0x16bb-n0x16c9)  +
	0x25b556c9, // c0x0129 (n0x16c9-n0x16d5)  o
	0x05c8d6d5, // c0x012a (n0x16d5-n0x1723)  +
	0x05cad723, // c0x012b (n0x1723-n0x172b)  +
	0x65cd972b, // c0x012c (n0x172b-n0x1736)* o
	0x25cdd736, // c0x012d (n0x1736-n0x1737)  o
	0x05dd9737, // c0x012e (n0x1737-n0x1776)  +
	0x05de5776, // c0x012f (n0x1776-n0x1779)  +
	0x05df1779, // c0x0130 (n0x1779-n0x177c)  +
	0x05dfd77c, // c0x0131 (n0x177c-n0x177f)  +
	0x05e0977f, // c0x0132 (n0x177f-n0x1782)  +
	0x05e15782, // c0x0133 (n0x1782-n0x1785)  +
	0x05e21785, // c0x0134 (n0x1785-n0x1788)  +
	0x05e2d788, // c0x0135 (n0x1788-n0x178b)  +
	0x05e3978b, // c0x0136 (n0x178b-n0x178e)  +
	0x05e4578e, // c0x0137 (n0x178e-n0x1791)  +
	0x05e51791, // c0x0138 (n0x1791-n0x1794)  +
	0x05e5d794, // c0x0139 (n0x1794-n0x1797)  +
	0x05e69797, // c0x013a (n0x1797-n0x179a)  +
	0x05e7579a, // c0x013b (n0x179a-n0x179d)  +
	0x05e7d79d, // c0x013c (n0x179d-n0x179f)  +
	0x05e8979f, // c0x013d (n0x179f-n0x17a2)  +
	0x05e957a2, // c0x013e (n0x17a2-n0x17a5)  +
	0x05ea17a5, // c0x013f (n0x17a5-n0x17a8)  +
	0x05ead7a8, // c0x0140 (n0x17a8-n0x17ab)  +
	0x05eb97ab, // c0x0141 (n0x17ab-n0x17ae)  +
	0x05ec57ae, // c0x0142 (n0x17ae-n0x17b1)  +
	0x05ed17b1, // c0x0143 (n0x17b1-n0x17b4)  +
	0x05edd7b4, // c0x0144 (n0x17b4-n0x17b7)  +
	0x05ee97b7, // c0x0145 (n0x17b7-n0x17ba)  +
	0x05ef57ba, // c0x0146 (n0x17ba-n0x17bd)  +
	0x05f017bd, // c0x0147 (n0x17bd-n0x17c0)  +
	0x05f0d7c0, // c0x0148 (n0x17c0-n0x17c3)  +
	0x05f197c3, // c0x0149 (n0x17c3-n0x17c6)  +
	0x05f257c6, // c0x014a (n0x17c6-n0x17c9)  +
	0x05f317c9, // c0x014b (n0x17c9-n0x17cc)  +
	0x05f3d7cc, // c0x014c (n0x17cc-n0x17cf)  +
	0x05f497cf, // c0x014d (n0x17cf-n0x17d2)  +
	0x05f557d2, // c0x014e (n0x17d2-n0x17d5)  +
	0x05f617d5, // c0x014f (n0x17d5-n0x17d8)  +
	0x05f6d7d8, // c0x0150 (n0x17d8-n0x17db)  +
	0x05f797db, // c0x0151 (n0x17db-n0x17de)  +
	0x05f857de, // c0x0152 (n0x17de-n0x17e1)  +
	0x05f917e1, // c0x0153 (n0x17e1-n0x17e4)  +
	0x05f9d7e4, // c0x0154 (n0x17e4-n0x17e7)  +
	0x05fa97e7, // c0x0155 (n0x17e7-n0x17ea)  +
	0x05fb57ea, // c0x0156 (n0x17ea-n0x17ed)  +
	0x05fc17ed, // c0x0157 (n0x17ed-n0x17f0)  +
	0x05fcd7f0, // c0x0158 (n0x17f0-n0x17f3)  +
	0x05fd97f3, // c0x0159 (n0x17f3-n0x17f6)  +
	0x05fe57f6, // c0x015a (n0x17f6-n0x17f9)  +
	0x05ff17f9, // c0x015b (n0x17f9-n0x17fc)  +
	0x05ffd7fc, // c0x015c (n0x17fc-n0x17ff)  +
	0x060097ff, // c0x015d (n0x17ff-n0x1802)  +
	0x06015802, // c0x015e (n0x1802-n0x1805)  +
	0x06021805, // c0x015f (n0x1805-n0x1808)  +
	0x0602d808, // c0x0160 (n0x1808-n0x180b)  +
	0x0603980b, // c0x0161 (n0x180b-n0x180e)  +
	0x0604580e, // c0x0162 (n0x180e-n0x1811)  +
	0x06051811, // c0x0163 (n0x1811-n0x1814)  +
	0x0605d814, // c0x0164 (n0x1814-n0x1817)  +
	0x06069817, // c0x0165 (n0x1817-n0x181a)  +
	0x0607581a, // c0x0166 (n0x181a-n0x181d)  +
	0x0608d81d, // c0x0167 (n0x181d-n0x1823)  +
	0x0609d823, // c0x0168 (n0x1823-n0x1827)  +
	0x060b5827, // c0x0169 (n0x1827-n0x182d)  +
	0x060dd82d, // c0x016a (n0x182d-n0x1837)  +
	0x060f1837, // c0x016b (n0x1837-n0x183c)  +
	0x0612183c, // c0x016c (n0x183c-n0x1848)  +
	0x0613d848, // c0x016d (n0x1848-n0x184f)  +
}
