// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/container/v1beta1/cluster_service.proto

package container

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Possible values for Effect in taint.
type NodeTaint_Effect int32

const (
	// Not set
	NodeTaint_EFFECT_UNSPECIFIED NodeTaint_Effect = 0
	// NoSchedule
	NodeTaint_NO_SCHEDULE NodeTaint_Effect = 1
	// PreferNoSchedule
	NodeTaint_PREFER_NO_SCHEDULE NodeTaint_Effect = 2
	// NoExecute
	NodeTaint_NO_EXECUTE NodeTaint_Effect = 3
)

var NodeTaint_Effect_name = map[int32]string{
	0: "EFFECT_UNSPECIFIED",
	1: "NO_SCHEDULE",
	2: "PREFER_NO_SCHEDULE",
	3: "NO_EXECUTE",
}

var NodeTaint_Effect_value = map[string]int32{
	"EFFECT_UNSPECIFIED": 0,
	"NO_SCHEDULE":        1,
	"PREFER_NO_SCHEDULE": 2,
	"NO_EXECUTE":         3,
}

func (x NodeTaint_Effect) String() string {
	return proto.EnumName(NodeTaint_Effect_name, int32(x))
}

func (NodeTaint_Effect) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{2, 0}
}

// Istio auth mode, https://istio.io/docs/concepts/security/mutual-tls.html
type IstioConfig_IstioAuthMode int32

const (
	// auth not enabled
	IstioConfig_AUTH_NONE IstioConfig_IstioAuthMode = 0
	// auth mutual TLS enabled
	IstioConfig_AUTH_MUTUAL_TLS IstioConfig_IstioAuthMode = 1
)

var IstioConfig_IstioAuthMode_name = map[int32]string{
	0: "AUTH_NONE",
	1: "AUTH_MUTUAL_TLS",
}

var IstioConfig_IstioAuthMode_value = map[string]int32{
	"AUTH_NONE":       0,
	"AUTH_MUTUAL_TLS": 1,
}

func (x IstioConfig_IstioAuthMode) String() string {
	return proto.EnumName(IstioConfig_IstioAuthMode_name, int32(x))
}

func (IstioConfig_IstioAuthMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{11, 0}
}

// Allowed Network Policy providers.
type NetworkPolicy_Provider int32

const (
	// Not set
	NetworkPolicy_PROVIDER_UNSPECIFIED NetworkPolicy_Provider = 0
	// Tigera (Calico Felix).
	NetworkPolicy_CALICO NetworkPolicy_Provider = 1
)

var NetworkPolicy_Provider_name = map[int32]string{
	0: "PROVIDER_UNSPECIFIED",
	1: "CALICO",
}

var NetworkPolicy_Provider_value = map[string]int32{
	"PROVIDER_UNSPECIFIED": 0,
	"CALICO":               1,
}

func (x NetworkPolicy_Provider) String() string {
	return proto.EnumName(NetworkPolicy_Provider_name, int32(x))
}

func (NetworkPolicy_Provider) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{15, 0}
}

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
	// The DEGRADED state indicates the cluster requires user action to restore
	// full functionality. Details can be found in the `statusMessage` field.
	Cluster_DEGRADED Cluster_Status = 6
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "ERROR",
	6: "DEGRADED",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"ERROR":              5,
	"DEGRADED":           6,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{20, 0}
}

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
	// The operation is aborting.
	Operation_ABORTING Operation_Status = 4
)

var Operation_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
	4: "ABORTING",
}

var Operation_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PENDING":            1,
	"RUNNING":            2,
	"DONE":               3,
	"ABORTING":           4,
}

func (x Operation_Status) String() string {
	return proto.EnumName(Operation_Status_name, int32(x))
}

func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{22, 0}
}

// Operation type.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// Cluster create.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// Cluster delete.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// A master upgrade.
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node upgrade.
	Operation_UPGRADE_NODES Operation_Type = 4
	// Cluster repair.
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// Cluster update.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// Node pool create.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// Node pool delete.
	Operation_DELETE_NODE_POOL Operation_Type = 8
	// Set node pool management.
	Operation_SET_NODE_POOL_MANAGEMENT Operation_Type = 9
	// Automatic node pool repair.
	Operation_AUTO_REPAIR_NODES Operation_Type = 10
	// Automatic node upgrade.
	Operation_AUTO_UPGRADE_NODES Operation_Type = 11
	// Set labels.
	Operation_SET_LABELS Operation_Type = 12
	// Set/generate master auth materials
	Operation_SET_MASTER_AUTH Operation_Type = 13
	// Set node pool size.
	Operation_SET_NODE_POOL_SIZE Operation_Type = 14
	// Updates network policy for a cluster.
	Operation_SET_NETWORK_POLICY Operation_Type = 15
	// Set the maintenance policy.
	Operation_SET_MAINTENANCE_POLICY Operation_Type = 16
)

var Operation_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "CREATE_CLUSTER",
	2:  "DELETE_CLUSTER",
	3:  "UPGRADE_MASTER",
	4:  "UPGRADE_NODES",
	5:  "REPAIR_CLUSTER",
	6:  "UPDATE_CLUSTER",
	7:  "CREATE_NODE_POOL",
	8:  "DELETE_NODE_POOL",
	9:  "SET_NODE_POOL_MANAGEMENT",
	10: "AUTO_REPAIR_NODES",
	11: "AUTO_UPGRADE_NODES",
	12: "SET_LABELS",
	13: "SET_MASTER_AUTH",
	14: "SET_NODE_POOL_SIZE",
	15: "SET_NETWORK_POLICY",
	16: "SET_MAINTENANCE_POLICY",
}

var Operation_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":         0,
	"CREATE_CLUSTER":           1,
	"DELETE_CLUSTER":           2,
	"UPGRADE_MASTER":           3,
	"UPGRADE_NODES":            4,
	"REPAIR_CLUSTER":           5,
	"UPDATE_CLUSTER":           6,
	"CREATE_NODE_POOL":         7,
	"DELETE_NODE_POOL":         8,
	"SET_NODE_POOL_MANAGEMENT": 9,
	"AUTO_REPAIR_NODES":        10,
	"AUTO_UPGRADE_NODES":       11,
	"SET_LABELS":               12,
	"SET_MASTER_AUTH":          13,
	"SET_NODE_POOL_SIZE":       14,
	"SET_NETWORK_POLICY":       15,
	"SET_MAINTENANCE_POLICY":   16,
}

func (x Operation_Type) String() string {
	return proto.EnumName(Operation_Type_name, int32(x))
}

func (Operation_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{22, 1}
}

// Operation type: what type update to perform.
type SetMasterAuthRequest_Action int32

const (
	// Operation is unknown and will error out.
	SetMasterAuthRequest_UNKNOWN SetMasterAuthRequest_Action = 0
	// Set the password to a user generated value.
	SetMasterAuthRequest_SET_PASSWORD SetMasterAuthRequest_Action = 1
	// Generate a new password and set it to that.
	SetMasterAuthRequest_GENERATE_PASSWORD SetMasterAuthRequest_Action = 2
	// Set the username.  If an empty username is provided, basic authentication
	// is disabled for the cluster.  If a non-empty username is provided, basic
	// authentication is enabled, with either a provided password or a generated
	// one.
	SetMasterAuthRequest_SET_USERNAME SetMasterAuthRequest_Action = 3
)

var SetMasterAuthRequest_Action_name = map[int32]string{
	0: "UNKNOWN",
	1: "SET_PASSWORD",
	2: "GENERATE_PASSWORD",
	3: "SET_USERNAME",
}

var SetMasterAuthRequest_Action_value = map[string]int32{
	"UNKNOWN":           0,
	"SET_PASSWORD":      1,
	"GENERATE_PASSWORD": 2,
	"SET_USERNAME":      3,
}

func (x SetMasterAuthRequest_Action) String() string {
	return proto.EnumName(SetMasterAuthRequest_Action_name, int32(x))
}

func (SetMasterAuthRequest_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{34, 0}
}

// The current status of the node pool instance.
type NodePool_Status int32

const (
	// Not set.
	NodePool_STATUS_UNSPECIFIED NodePool_Status = 0
	// The PROVISIONING state indicates the node pool is being created.
	NodePool_PROVISIONING NodePool_Status = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	NodePool_RUNNING NodePool_Status = 2
	// The RUNNING_WITH_ERROR state indicates the node pool has been created
	// and is partially usable. Some error state has occurred and some
	// functionality may be impaired. Customer may need to reissue a request
	// or trigger a new update.
	NodePool_RUNNING_WITH_ERROR NodePool_Status = 3
	// The RECONCILING state indicates that some work is actively being done on
	// the node pool, such as upgrading node software. Details can
	// be found in the `statusMessage` field.
	NodePool_RECONCILING NodePool_Status = 4
	// The STOPPING state indicates the node pool is being deleted.
	NodePool_STOPPING NodePool_Status = 5
	// The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	NodePool_ERROR NodePool_Status = 6
)

var NodePool_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RUNNING_WITH_ERROR",
	4: "RECONCILING",
	5: "STOPPING",
	6: "ERROR",
}

var NodePool_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RUNNING_WITH_ERROR": 3,
	"RECONCILING":        4,
	"STOPPING":           5,
	"ERROR":              6,
}

func (x NodePool_Status) String() string {
	return proto.EnumName(NodePool_Status_name, int32(x))
}

func (NodePool_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{48, 0}
}

// NodeMetadata is the configuration for if and how to expose the node
// metadata to the workload running on the node.
type WorkloadMetadataConfig_NodeMetadata int32

const (
	// Not set.
	WorkloadMetadataConfig_UNSPECIFIED WorkloadMetadataConfig_NodeMetadata = 0
	// Prevent workloads not in hostNetwork from accessing certain VM metadata,
	// specifically kube-env, which contains Kubelet credentials, and the
	// instance identity token.
	//
	// Metadata concealment is a temporary security solution available while the
	// bootstrapping process for cluster nodes is being redesigned with
	// significant security improvements.  This feature is scheduled to be
	// deprecated in the future and later removed.
	WorkloadMetadataConfig_SECURE WorkloadMetadataConfig_NodeMetadata = 1
	// Expose all VM metadata to pods.
	WorkloadMetadataConfig_EXPOSE WorkloadMetadataConfig_NodeMetadata = 2
)

var WorkloadMetadataConfig_NodeMetadata_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "SECURE",
	2: "EXPOSE",
}

var WorkloadMetadataConfig_NodeMetadata_value = map[string]int32{
	"UNSPECIFIED": 0,
	"SECURE":      1,
	"EXPOSE":      2,
}

func (x WorkloadMetadataConfig_NodeMetadata) String() string {
	return proto.EnumName(WorkloadMetadataConfig_NodeMetadata_name, int32(x))
}

func (WorkloadMetadataConfig_NodeMetadata) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{69, 0}
}

// LocationType is the type of GKE location, regional or zonal.
type Location_LocationType int32

const (
	// LOCATION_TYPE_UNSPECIFIED means the location type was not determined.
	Location_LOCATION_TYPE_UNSPECIFIED Location_LocationType = 0
	// A GKE Location where Zonal clusters can be created.
	Location_ZONE Location_LocationType = 1
	// A GKE Location where Regional clusters can be created.
	Location_REGION Location_LocationType = 2
)

var Location_LocationType_name = map[int32]string{
	0: "LOCATION_TYPE_UNSPECIFIED",
	1: "ZONE",
	2: "REGION",
}

var Location_LocationType_value = map[string]int32{
	"LOCATION_TYPE_UNSPECIFIED": 0,
	"ZONE":                      1,
	"REGION":                    2,
}

func (x Location_LocationType) String() string {
	return proto.EnumName(Location_LocationType_name, int32(x))
}

func (Location_LocationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{74, 0}
}

// Code for each condition
type StatusCondition_Code int32

const (
	// UNKNOWN indicates a generic condition.
	StatusCondition_UNKNOWN StatusCondition_Code = 0
	// GCE_STOCKOUT indicates a Google Compute Engine stockout.
	StatusCondition_GCE_STOCKOUT StatusCondition_Code = 1
	// GKE_SERVICE_ACCOUNT_DELETED indicates that the user deleted their robot
	// service account.
	StatusCondition_GKE_SERVICE_ACCOUNT_DELETED StatusCondition_Code = 2
	// Google Compute Engine quota was exceeded.
	StatusCondition_GCE_QUOTA_EXCEEDED StatusCondition_Code = 3
	// Cluster state was manually changed by an SRE due to a system logic error.
	StatusCondition_SET_BY_OPERATOR StatusCondition_Code = 4
	// Unable to perform an encrypt operation against the CloudKMS key used for
	// etcd level encryption.
	// More codes TBA
	StatusCondition_CLOUD_KMS_KEY_ERROR StatusCondition_Code = 7
)

var StatusCondition_Code_name = map[int32]string{
	0: "UNKNOWN",
	1: "GCE_STOCKOUT",
	2: "GKE_SERVICE_ACCOUNT_DELETED",
	3: "GCE_QUOTA_EXCEEDED",
	4: "SET_BY_OPERATOR",
	7: "CLOUD_KMS_KEY_ERROR",
}

var StatusCondition_Code_value = map[string]int32{
	"UNKNOWN":                     0,
	"GCE_STOCKOUT":                1,
	"GKE_SERVICE_ACCOUNT_DELETED": 2,
	"GCE_QUOTA_EXCEEDED":          3,
	"SET_BY_OPERATOR":             4,
	"CLOUD_KMS_KEY_ERROR":         7,
}

func (x StatusCondition_Code) String() string {
	return proto.EnumName(StatusCondition_Code_name, int32(x))
}

func (StatusCondition_Code) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{75, 0}
}

// Status shows the current usage of a secondary IP range.
type UsableSubnetworkSecondaryRange_Status int32

const (
	// UNKNOWN is the zero value of the Status enum. It's not a valid status.
	UsableSubnetworkSecondaryRange_UNKNOWN UsableSubnetworkSecondaryRange_Status = 0
	// UNUSED denotes that this range is unclaimed by any cluster.
	UsableSubnetworkSecondaryRange_UNUSED UsableSubnetworkSecondaryRange_Status = 1
	// IN_USE_SERVICE denotes that this range is claimed by a cluster for
	// services. It cannot be used for other clusters.
	UsableSubnetworkSecondaryRange_IN_USE_SERVICE UsableSubnetworkSecondaryRange_Status = 2
	// IN_USE_SHAREABLE_POD denotes this range was created by the network admin
	// and is currently claimed by a cluster for pods. It can only be used by
	// other clusters as a pod range.
	UsableSubnetworkSecondaryRange_IN_USE_SHAREABLE_POD UsableSubnetworkSecondaryRange_Status = 3
	// IN_USE_MANAGED_POD denotes this range was created by GKE and is claimed
	// for pods. It cannot be used for other clusters.
	UsableSubnetworkSecondaryRange_IN_USE_MANAGED_POD UsableSubnetworkSecondaryRange_Status = 4
)

var UsableSubnetworkSecondaryRange_Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNUSED",
	2: "IN_USE_SERVICE",
	3: "IN_USE_SHAREABLE_POD",
	4: "IN_USE_MANAGED_POD",
}

var UsableSubnetworkSecondaryRange_Status_value = map[string]int32{
	"UNKNOWN":              0,
	"UNUSED":               1,
	"IN_USE_SERVICE":       2,
	"IN_USE_SHAREABLE_POD": 3,
	"IN_USE_MANAGED_POD":   4,
}

func (x UsableSubnetworkSecondaryRange_Status) String() string {
	return proto.EnumName(UsableSubnetworkSecondaryRange_Status_name, int32(x))
}

func (UsableSubnetworkSecondaryRange_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{79, 0}
}

// State of etcd encryption.
type DatabaseEncryption_State int32

const (
	// Should never be set
	DatabaseEncryption_UNKNOWN DatabaseEncryption_State = 0
	// Secrets in etcd are encrypted.
	DatabaseEncryption_ENCRYPTED DatabaseEncryption_State = 1
	// Secrets in etcd are stored in plain text (at etcd level) - this is
	// unrelated to Google Compute Engine level full disk encryption.
	DatabaseEncryption_DECRYPTED DatabaseEncryption_State = 2
)

var DatabaseEncryption_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "ENCRYPTED",
	2: "DECRYPTED",
}

var DatabaseEncryption_State_value = map[string]int32{
	"UNKNOWN":   0,
	"ENCRYPTED": 1,
	"DECRYPTED": 2,
}

func (x DatabaseEncryption_State) String() string {
	return proto.EnumName(DatabaseEncryption_State_name, int32(x))
}

func (DatabaseEncryption_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{84, 0}
}

// Parameters that describe the nodes in a cluster.
type NodeConfig struct {
	// The name of a Google Compute Engine [machine
	// type](/compute/docs/machine-types) (e.g.
	// `n1-standard-1`).
	//
	// If unspecified, the default machine type is
	// `n1-standard-1`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container Registry](/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs. If
	// no Service Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the reserved keys:
	//  "cluster-location"
	//  "cluster-name"
	//  "cluster-uid"
	//  "configure-sh"
	//  "containerd-configure-sh"
	//  "enable-oslogin"
	//  "gci-ensure-gke-docker"
	//  "gci-metrics-enabled"
	//  "gci-update-strategy"
	//  "instance-template"
	//  "kube-env"
	//  "startup-script"
	//  "user-data"
	//  "disable-address-manager"
	//  "windows-startup-script-ps1"
	//  "common-psm1"
	//  "k8s-node-setup-psm1"
	//  "install-ssh-psm1"
	//  "user-profile-psm1"
	//  "serial-port-logging-enable"
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The image type to use for this node. Note that for a given image type,
	// the latest version of it will be used.
	ImageType string `protobuf:"bytes,5,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The map of Kubernetes labels (key/value pairs) to be applied to each node.
	// These will added in addition to any default label(s) that
	// Kubernetes may apply to the node.
	// In case of conflict in label keys, the applied set may differ depending on
	// the Kubernetes version -- it's best to assume the behavior is undefined
	// and conflicts should be avoided.
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of local SSD disks to be attached to the node.
	//
	// The limit for this value is dependent upon the maximum number of
	// disks available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd
	// for more information.
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Whether the nodes are created as preemptible VM instances. See:
	// https://cloud.google.com/compute/docs/instances/preemptible for more
	// inforamtion about preemptible VM instances.
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// A list of hardware accelerators to be attached to each node.
	// See https://cloud.google.com/compute/docs/gpus for more information about
	// support for GPUs.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,11,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Type of the disk attached to each node (e.g. 'pd-standard' or 'pd-ssd')
	//
	// If unspecified, the default disk type is 'pd-standard'
	DiskType string `protobuf:"bytes,12,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Minimum CPU platform to be used by this instance. The instance may be
	// scheduled on the specified or newer CPU platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// <code>minCpuPlatform: &quot;Intel Haswell&quot;</code> or
	// <code>minCpuPlatform: &quot;Intel Sandy Bridge&quot;</code>. For more
	// information, read [how to specify min CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	// To unset the min cpu platform field pass "automatic" as field value.
	MinCpuPlatform string `protobuf:"bytes,13,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// The workload metadata configuration for this node.
	WorkloadMetadataConfig *WorkloadMetadataConfig `protobuf:"bytes,14,opt,name=workload_metadata_config,json=workloadMetadataConfig,proto3" json:"workload_metadata_config,omitempty"`
	// List of kubernetes taints to be applied to each node.
	//
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Taints []*NodeTaint `protobuf:"bytes,15,rep,name=taints,proto3" json:"taints,omitempty"`
	// Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,20,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                `json:"-"`
	XXX_unrecognized       []byte                  `json:"-"`
	XXX_sizecache          int32                   `json:"-"`
}

func (m *NodeConfig) Reset()         { *m = NodeConfig{} }
func (m *NodeConfig) String() string { return proto.CompactTextString(m) }
func (*NodeConfig) ProtoMessage()    {}
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{0}
}

func (m *NodeConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeConfig.Unmarshal(m, b)
}
func (m *NodeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeConfig.Marshal(b, m, deterministic)
}
func (m *NodeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeConfig.Merge(m, src)
}
func (m *NodeConfig) XXX_Size() int {
	return xxx_messageInfo_NodeConfig.Size(m)
}
func (m *NodeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NodeConfig proto.InternalMessageInfo

func (m *NodeConfig) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *NodeConfig) GetDiskSizeGb() int32 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *NodeConfig) GetOauthScopes() []string {
	if m != nil {
		return m.OauthScopes
	}
	return nil
}

func (m *NodeConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *NodeConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeConfig) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *NodeConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NodeConfig) GetLocalSsdCount() int32 {
	if m != nil {
		return m.LocalSsdCount
	}
	return 0
}

func (m *NodeConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *NodeConfig) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

func (m *NodeConfig) GetAccelerators() []*AcceleratorConfig {
	if m != nil {
		return m.Accelerators
	}
	return nil
}

func (m *NodeConfig) GetDiskType() string {
	if m != nil {
		return m.DiskType
	}
	return ""
}

func (m *NodeConfig) GetMinCpuPlatform() string {
	if m != nil {
		return m.MinCpuPlatform
	}
	return ""
}

func (m *NodeConfig) GetWorkloadMetadataConfig() *WorkloadMetadataConfig {
	if m != nil {
		return m.WorkloadMetadataConfig
	}
	return nil
}

func (m *NodeConfig) GetTaints() []*NodeTaint {
	if m != nil {
		return m.Taints
	}
	return nil
}

func (m *NodeConfig) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if m != nil {
		return m.ShieldedInstanceConfig
	}
	return nil
}

// A set of Shielded Instance options.
type ShieldedInstanceConfig struct {
	// Defines whether the instance has Secure Boot enabled.
	//
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the
	// boot process if signature verification fails.
	EnableSecureBoot bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3" json:"enable_secure_boot,omitempty"`
	// Defines whether the instance has integrity monitoring enabled.
	//
	// Enables monitoring and attestation of the boot integrity of the instance.
	// The attestation is performed against the integrity policy baseline. This
	// baseline is initially derived from the implicitly trusted boot image when
	// the instance is created.
	EnableIntegrityMonitoring bool     `protobuf:"varint,2,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *ShieldedInstanceConfig) Reset()         { *m = ShieldedInstanceConfig{} }
func (m *ShieldedInstanceConfig) String() string { return proto.CompactTextString(m) }
func (*ShieldedInstanceConfig) ProtoMessage()    {}
func (*ShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{1}
}

func (m *ShieldedInstanceConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShieldedInstanceConfig.Unmarshal(m, b)
}
func (m *ShieldedInstanceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShieldedInstanceConfig.Marshal(b, m, deterministic)
}
func (m *ShieldedInstanceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShieldedInstanceConfig.Merge(m, src)
}
func (m *ShieldedInstanceConfig) XXX_Size() int {
	return xxx_messageInfo_ShieldedInstanceConfig.Size(m)
}
func (m *ShieldedInstanceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShieldedInstanceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShieldedInstanceConfig proto.InternalMessageInfo

func (m *ShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if m != nil {
		return m.EnableSecureBoot
	}
	return false
}

func (m *ShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if m != nil {
		return m.EnableIntegrityMonitoring
	}
	return false
}

// Kubernetes taint is comprised of three fields: key, value, and effect. Effect
// can only be one of three types:  NoSchedule, PreferNoSchedule or NoExecute.
//
// For more information, including usage and the valid values, see:
// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
type NodeTaint struct {
	// Key for taint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value for taint.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Effect for taint.
	Effect               NodeTaint_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=google.container.v1beta1.NodeTaint_Effect" json:"effect,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *NodeTaint) Reset()         { *m = NodeTaint{} }
func (m *NodeTaint) String() string { return proto.CompactTextString(m) }
func (*NodeTaint) ProtoMessage()    {}
func (*NodeTaint) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{2}
}

func (m *NodeTaint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeTaint.Unmarshal(m, b)
}
func (m *NodeTaint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeTaint.Marshal(b, m, deterministic)
}
func (m *NodeTaint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeTaint.Merge(m, src)
}
func (m *NodeTaint) XXX_Size() int {
	return xxx_messageInfo_NodeTaint.Size(m)
}
func (m *NodeTaint) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeTaint.DiscardUnknown(m)
}

var xxx_messageInfo_NodeTaint proto.InternalMessageInfo

func (m *NodeTaint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *NodeTaint) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *NodeTaint) GetEffect() NodeTaint_Effect {
	if m != nil {
		return m.Effect
	}
	return NodeTaint_EFFECT_UNSPECIFIED
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	// The username to use for HTTP basic authentication to the master endpoint.
	// For clusters v1.6.0 and later, basic authentication can be disabled by
	// leaving username unspecified (or setting it to the empty string).
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.  If a password is provided for cluster creation, username
	// must be non-empty.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Configuration for client certificate authentication on the cluster. For
	// clusters before v1.12, if no configuration is specified, a client
	// certificate is issued.
	ClientCertificateConfig *ClientCertificateConfig `protobuf:"bytes,3,opt,name=client_certificate_config,json=clientCertificateConfig,proto3" json:"client_certificate_config,omitempty"`
	// [Output only] Base64-encoded public certificate that is the root of
	// trust for the cluster.
	ClusterCaCertificate string `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// [Output only] Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// [Output only] Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey            string   `protobuf:"bytes,102,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterAuth) Reset()         { *m = MasterAuth{} }
func (m *MasterAuth) String() string { return proto.CompactTextString(m) }
func (*MasterAuth) ProtoMessage()    {}
func (*MasterAuth) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{3}
}

func (m *MasterAuth) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuth.Unmarshal(m, b)
}
func (m *MasterAuth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuth.Marshal(b, m, deterministic)
}
func (m *MasterAuth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuth.Merge(m, src)
}
func (m *MasterAuth) XXX_Size() int {
	return xxx_messageInfo_MasterAuth.Size(m)
}
func (m *MasterAuth) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuth.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuth proto.InternalMessageInfo

func (m *MasterAuth) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *MasterAuth) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *MasterAuth) GetClientCertificateConfig() *ClientCertificateConfig {
	if m != nil {
		return m.ClientCertificateConfig
	}
	return nil
}

func (m *MasterAuth) GetClusterCaCertificate() string {
	if m != nil {
		return m.ClusterCaCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientKey() string {
	if m != nil {
		return m.ClientKey
	}
	return ""
}

// Configuration for client certificates on the cluster.
type ClientCertificateConfig struct {
	// Issue a client certificate.
	IssueClientCertificate bool     `protobuf:"varint,1,opt,name=issue_client_certificate,json=issueClientCertificate,proto3" json:"issue_client_certificate,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *ClientCertificateConfig) Reset()         { *m = ClientCertificateConfig{} }
func (m *ClientCertificateConfig) String() string { return proto.CompactTextString(m) }
func (*ClientCertificateConfig) ProtoMessage()    {}
func (*ClientCertificateConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{4}
}

func (m *ClientCertificateConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientCertificateConfig.Unmarshal(m, b)
}
func (m *ClientCertificateConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientCertificateConfig.Marshal(b, m, deterministic)
}
func (m *ClientCertificateConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientCertificateConfig.Merge(m, src)
}
func (m *ClientCertificateConfig) XXX_Size() int {
	return xxx_messageInfo_ClientCertificateConfig.Size(m)
}
func (m *ClientCertificateConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientCertificateConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClientCertificateConfig proto.InternalMessageInfo

func (m *ClientCertificateConfig) GetIssueClientCertificate() bool {
	if m != nil {
		return m.IssueClientCertificate
	}
	return false
}

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing,proto3" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling,proto3" json:"horizontal_pod_autoscaling,omitempty"`
	// Configuration for the Kubernetes Dashboard.
	// This addon is deprecated, and will be disabled in 1.15. It is recommended
	// to use the Cloud Console to manage and monitor your Kubernetes clusters,
	// workloads and applications. For more information, see:
	// https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
	KubernetesDashboard *KubernetesDashboard `protobuf:"bytes,3,opt,name=kubernetes_dashboard,json=kubernetesDashboard,proto3" json:"kubernetes_dashboard,omitempty"` // Deprecated: Do not use.
	// Configuration for NetworkPolicy. This only tracks whether the addon
	// is enabled or not on the Master, it does not track whether network policy
	// is enabled for the nodes.
	NetworkPolicyConfig *NetworkPolicyConfig `protobuf:"bytes,4,opt,name=network_policy_config,json=networkPolicyConfig,proto3" json:"network_policy_config,omitempty"`
	// Configuration for Istio, an open platform to connect, manage, and secure
	// microservices.
	IstioConfig *IstioConfig `protobuf:"bytes,5,opt,name=istio_config,json=istioConfig,proto3" json:"istio_config,omitempty"`
	// Configuration for the Cloud Run addon. The `IstioConfig` addon must be
	// enabled in order to enable Cloud Run addon. This option can only be enabled
	// at cluster creation time.
	CloudRunConfig       *CloudRunConfig `protobuf:"bytes,7,opt,name=cloud_run_config,json=cloudRunConfig,proto3" json:"cloud_run_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *AddonsConfig) Reset()         { *m = AddonsConfig{} }
func (m *AddonsConfig) String() string { return proto.CompactTextString(m) }
func (*AddonsConfig) ProtoMessage()    {}
func (*AddonsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{5}
}

func (m *AddonsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddonsConfig.Unmarshal(m, b)
}
func (m *AddonsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddonsConfig.Marshal(b, m, deterministic)
}
func (m *AddonsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddonsConfig.Merge(m, src)
}
func (m *AddonsConfig) XXX_Size() int {
	return xxx_messageInfo_AddonsConfig.Size(m)
}
func (m *AddonsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AddonsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AddonsConfig proto.InternalMessageInfo

func (m *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if m != nil {
		return m.HttpLoadBalancing
	}
	return nil
}

func (m *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if m != nil {
		return m.HorizontalPodAutoscaling
	}
	return nil
}

// Deprecated: Do not use.
func (m *AddonsConfig) GetKubernetesDashboard() *KubernetesDashboard {
	if m != nil {
		return m.KubernetesDashboard
	}
	return nil
}

func (m *AddonsConfig) GetNetworkPolicyConfig() *NetworkPolicyConfig {
	if m != nil {
		return m.NetworkPolicyConfig
	}
	return nil
}

func (m *AddonsConfig) GetIstioConfig() *IstioConfig {
	if m != nil {
		return m.IstioConfig
	}
	return nil
}

func (m *AddonsConfig) GetCloudRunConfig() *CloudRunConfig {
	if m != nil {
		return m.CloudRunConfig
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HttpLoadBalancing) Reset()         { *m = HttpLoadBalancing{} }
func (m *HttpLoadBalancing) String() string { return proto.CompactTextString(m) }
func (*HttpLoadBalancing) ProtoMessage()    {}
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{6}
}

func (m *HttpLoadBalancing) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HttpLoadBalancing.Unmarshal(m, b)
}
func (m *HttpLoadBalancing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HttpLoadBalancing.Marshal(b, m, deterministic)
}
func (m *HttpLoadBalancing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpLoadBalancing.Merge(m, src)
}
func (m *HttpLoadBalancing) XXX_Size() int {
	return xxx_messageInfo_HttpLoadBalancing.Size(m)
}
func (m *HttpLoadBalancing) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpLoadBalancing.DiscardUnknown(m)
}

var xxx_messageInfo_HttpLoadBalancing proto.InternalMessageInfo

func (m *HttpLoadBalancing) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that a Heapster pod is running in the cluster,
	// which is also used by the Cloud Monitoring service.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HorizontalPodAutoscaling) Reset()         { *m = HorizontalPodAutoscaling{} }
func (m *HorizontalPodAutoscaling) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscaling) ProtoMessage()    {}
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{7}
}

func (m *HorizontalPodAutoscaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HorizontalPodAutoscaling.Unmarshal(m, b)
}
func (m *HorizontalPodAutoscaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HorizontalPodAutoscaling.Marshal(b, m, deterministic)
}
func (m *HorizontalPodAutoscaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscaling.Merge(m, src)
}
func (m *HorizontalPodAutoscaling) XXX_Size() int {
	return xxx_messageInfo_HorizontalPodAutoscaling.Size(m)
}
func (m *HorizontalPodAutoscaling) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscaling.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscaling proto.InternalMessageInfo

func (m *HorizontalPodAutoscaling) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for the Kubernetes Dashboard.
type KubernetesDashboard struct {
	// Whether the Kubernetes Dashboard is enabled for this cluster.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KubernetesDashboard) Reset()         { *m = KubernetesDashboard{} }
func (m *KubernetesDashboard) String() string { return proto.CompactTextString(m) }
func (*KubernetesDashboard) ProtoMessage()    {}
func (*KubernetesDashboard) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{8}
}

func (m *KubernetesDashboard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KubernetesDashboard.Unmarshal(m, b)
}
func (m *KubernetesDashboard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KubernetesDashboard.Marshal(b, m, deterministic)
}
func (m *KubernetesDashboard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KubernetesDashboard.Merge(m, src)
}
func (m *KubernetesDashboard) XXX_Size() int {
	return xxx_messageInfo_KubernetesDashboard.Size(m)
}
func (m *KubernetesDashboard) XXX_DiscardUnknown() {
	xxx_messageInfo_KubernetesDashboard.DiscardUnknown(m)
}

var xxx_messageInfo_KubernetesDashboard proto.InternalMessageInfo

func (m *KubernetesDashboard) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for NetworkPolicy. This only tracks whether the addon
// is enabled or not on the Master, it does not track whether network policy
// is enabled for the nodes.
type NetworkPolicyConfig struct {
	// Whether NetworkPolicy is enabled for this cluster.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkPolicyConfig) Reset()         { *m = NetworkPolicyConfig{} }
func (m *NetworkPolicyConfig) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyConfig) ProtoMessage()    {}
func (*NetworkPolicyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{9}
}

func (m *NetworkPolicyConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkPolicyConfig.Unmarshal(m, b)
}
func (m *NetworkPolicyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkPolicyConfig.Marshal(b, m, deterministic)
}
func (m *NetworkPolicyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyConfig.Merge(m, src)
}
func (m *NetworkPolicyConfig) XXX_Size() int {
	return xxx_messageInfo_NetworkPolicyConfig.Size(m)
}
func (m *NetworkPolicyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyConfig proto.InternalMessageInfo

func (m *NetworkPolicyConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for private clusters.
type PrivateClusterConfig struct {
	// Whether nodes have internal IP addresses only. If enabled, all nodes are
	// given only RFC 1918 private addresses and communicate with the master via
	// private networking.
	EnablePrivateNodes bool `protobuf:"varint,1,opt,name=enable_private_nodes,json=enablePrivateNodes,proto3" json:"enable_private_nodes,omitempty"`
	// Whether the master's internal IP address is used as the cluster endpoint.
	EnablePrivateEndpoint bool `protobuf:"varint,2,opt,name=enable_private_endpoint,json=enablePrivateEndpoint,proto3" json:"enable_private_endpoint,omitempty"`
	// The IP range in CIDR notation to use for the hosted master network. This
	// range will be used for assigning internal IP addresses to the master or
	// set of masters, as well as the ILB VIP. This range must not overlap with
	// any other ranges in use within the cluster's network.
	MasterIpv4CidrBlock string `protobuf:"bytes,3,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Output only. The internal IP address of this cluster's master endpoint.
	PrivateEndpoint string `protobuf:"bytes,4,opt,name=private_endpoint,json=privateEndpoint,proto3" json:"private_endpoint,omitempty"`
	// Output only. The external IP address of this cluster's master endpoint.
	PublicEndpoint       string   `protobuf:"bytes,5,opt,name=public_endpoint,json=publicEndpoint,proto3" json:"public_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrivateClusterConfig) Reset()         { *m = PrivateClusterConfig{} }
func (m *PrivateClusterConfig) String() string { return proto.CompactTextString(m) }
func (*PrivateClusterConfig) ProtoMessage()    {}
func (*PrivateClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{10}
}

func (m *PrivateClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrivateClusterConfig.Unmarshal(m, b)
}
func (m *PrivateClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrivateClusterConfig.Marshal(b, m, deterministic)
}
func (m *PrivateClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrivateClusterConfig.Merge(m, src)
}
func (m *PrivateClusterConfig) XXX_Size() int {
	return xxx_messageInfo_PrivateClusterConfig.Size(m)
}
func (m *PrivateClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PrivateClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PrivateClusterConfig proto.InternalMessageInfo

func (m *PrivateClusterConfig) GetEnablePrivateNodes() bool {
	if m != nil {
		return m.EnablePrivateNodes
	}
	return false
}

func (m *PrivateClusterConfig) GetEnablePrivateEndpoint() bool {
	if m != nil {
		return m.EnablePrivateEndpoint
	}
	return false
}

func (m *PrivateClusterConfig) GetMasterIpv4CidrBlock() string {
	if m != nil {
		return m.MasterIpv4CidrBlock
	}
	return ""
}

func (m *PrivateClusterConfig) GetPrivateEndpoint() string {
	if m != nil {
		return m.PrivateEndpoint
	}
	return ""
}

func (m *PrivateClusterConfig) GetPublicEndpoint() string {
	if m != nil {
		return m.PublicEndpoint
	}
	return ""
}

// Configuration options for Istio addon.
type IstioConfig struct {
	// Whether Istio is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// The specified Istio auth mode, either none, or mutual TLS.
	Auth                 IstioConfig_IstioAuthMode `protobuf:"varint,2,opt,name=auth,proto3,enum=google.container.v1beta1.IstioConfig_IstioAuthMode" json:"auth,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *IstioConfig) Reset()         { *m = IstioConfig{} }
func (m *IstioConfig) String() string { return proto.CompactTextString(m) }
func (*IstioConfig) ProtoMessage()    {}
func (*IstioConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{11}
}

func (m *IstioConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioConfig.Unmarshal(m, b)
}
func (m *IstioConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioConfig.Marshal(b, m, deterministic)
}
func (m *IstioConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioConfig.Merge(m, src)
}
func (m *IstioConfig) XXX_Size() int {
	return xxx_messageInfo_IstioConfig.Size(m)
}
func (m *IstioConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioConfig.DiscardUnknown(m)
}

var xxx_messageInfo_IstioConfig proto.InternalMessageInfo

func (m *IstioConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *IstioConfig) GetAuth() IstioConfig_IstioAuthMode {
	if m != nil {
		return m.Auth
	}
	return IstioConfig_AUTH_NONE
}

// Configuration options for the Cloud Run feature.
type CloudRunConfig struct {
	// Whether Cloud Run addon is enabled for this cluster.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudRunConfig) Reset()         { *m = CloudRunConfig{} }
func (m *CloudRunConfig) String() string { return proto.CompactTextString(m) }
func (*CloudRunConfig) ProtoMessage()    {}
func (*CloudRunConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{12}
}

func (m *CloudRunConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudRunConfig.Unmarshal(m, b)
}
func (m *CloudRunConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudRunConfig.Marshal(b, m, deterministic)
}
func (m *CloudRunConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudRunConfig.Merge(m, src)
}
func (m *CloudRunConfig) XXX_Size() int {
	return xxx_messageInfo_CloudRunConfig.Size(m)
}
func (m *CloudRunConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudRunConfig.DiscardUnknown(m)
}

var xxx_messageInfo_CloudRunConfig proto.InternalMessageInfo

func (m *CloudRunConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for the master authorized networks feature. Enabled
// master authorized networks will disallow all external traffic to access
// Kubernetes master through HTTPS except traffic from the given CIDR blocks,
// Google Compute Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	// Whether or not master authorized networks is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// cidr_blocks define up to 10 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks           []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,2,rep,name=cidr_blocks,json=cidrBlocks,proto3" json:"cidr_blocks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *MasterAuthorizedNetworksConfig) Reset()         { *m = MasterAuthorizedNetworksConfig{} }
func (m *MasterAuthorizedNetworksConfig) String() string { return proto.CompactTextString(m) }
func (*MasterAuthorizedNetworksConfig) ProtoMessage()    {}
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{13}
}

func (m *MasterAuthorizedNetworksConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig.Unmarshal(m, b)
}
func (m *MasterAuthorizedNetworksConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig.Marshal(b, m, deterministic)
}
func (m *MasterAuthorizedNetworksConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuthorizedNetworksConfig.Merge(m, src)
}
func (m *MasterAuthorizedNetworksConfig) XXX_Size() int {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig.Size(m)
}
func (m *MasterAuthorizedNetworksConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuthorizedNetworksConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuthorizedNetworksConfig proto.InternalMessageInfo

func (m *MasterAuthorizedNetworksConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if m != nil {
		return m.CidrBlocks
	}
	return nil
}

// CidrBlock contains an optional name and one CIDR block.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	// display_name is an optional field for users to identify CIDR blocks.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// cidr_block must be specified in CIDR notation.
	CidrBlock            string   `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*m = MasterAuthorizedNetworksConfig_CidrBlock{}
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) String() string { return proto.CompactTextString(m) }
func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage()    {}
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{13, 0}
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Unmarshal(m, b)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Marshal(b, m, deterministic)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Merge(m, src)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Size() int {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Size(m)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock proto.InternalMessageInfo

func (m *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if m != nil {
		return m.CidrBlock
	}
	return ""
}

// Configuration for the legacy Attribute Based Access Control authorization
// mode.
type LegacyAbac struct {
	// Whether the ABAC authorizer is enabled for this cluster. When enabled,
	// identities in the system, including service accounts, nodes, and
	// controllers, will have statically granted permissions beyond those
	// provided by the RBAC configuration or IAM.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LegacyAbac) Reset()         { *m = LegacyAbac{} }
func (m *LegacyAbac) String() string { return proto.CompactTextString(m) }
func (*LegacyAbac) ProtoMessage()    {}
func (*LegacyAbac) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{14}
}

func (m *LegacyAbac) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LegacyAbac.Unmarshal(m, b)
}
func (m *LegacyAbac) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LegacyAbac.Marshal(b, m, deterministic)
}
func (m *LegacyAbac) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LegacyAbac.Merge(m, src)
}
func (m *LegacyAbac) XXX_Size() int {
	return xxx_messageInfo_LegacyAbac.Size(m)
}
func (m *LegacyAbac) XXX_DiscardUnknown() {
	xxx_messageInfo_LegacyAbac.DiscardUnknown(m)
}

var xxx_messageInfo_LegacyAbac proto.InternalMessageInfo

func (m *LegacyAbac) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration options for the NetworkPolicy feature.
// https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
type NetworkPolicy struct {
	// The selected network policy provider.
	Provider NetworkPolicy_Provider `protobuf:"varint,1,opt,name=provider,proto3,enum=google.container.v1beta1.NetworkPolicy_Provider" json:"provider,omitempty"`
	// Whether network policy is enabled on the cluster.
	Enabled              bool     `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkPolicy) Reset()         { *m = NetworkPolicy{} }
func (m *NetworkPolicy) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicy) ProtoMessage()    {}
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{15}
}

func (m *NetworkPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkPolicy.Unmarshal(m, b)
}
func (m *NetworkPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkPolicy.Marshal(b, m, deterministic)
}
func (m *NetworkPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicy.Merge(m, src)
}
func (m *NetworkPolicy) XXX_Size() int {
	return xxx_messageInfo_NetworkPolicy.Size(m)
}
func (m *NetworkPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicy proto.InternalMessageInfo

func (m *NetworkPolicy) GetProvider() NetworkPolicy_Provider {
	if m != nil {
		return m.Provider
	}
	return NetworkPolicy_PROVIDER_UNSPECIFIED
}

func (m *NetworkPolicy) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration for controlling how IPs are allocated in the cluster.
type IPAllocationPolicy struct {
	// Whether alias IPs will be used for pod IPs in the cluster.
	UseIpAliases bool `protobuf:"varint,1,opt,name=use_ip_aliases,json=useIpAliases,proto3" json:"use_ip_aliases,omitempty"`
	// Whether a new subnetwork will be created automatically for the cluster.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	CreateSubnetwork bool `protobuf:"varint,2,opt,name=create_subnetwork,json=createSubnetwork,proto3" json:"create_subnetwork,omitempty"`
	// A custom subnetwork name to be used if `create_subnetwork` is true.  If
	// this field is empty, then an automatic name will be chosen for the new
	// subnetwork.
	SubnetworkName string `protobuf:"bytes,3,opt,name=subnetwork_name,json=subnetworkName,proto3" json:"subnetwork_name,omitempty"`
	// This field is deprecated, use cluster_ipv4_cidr_block.
	ClusterIpv4Cidr string `protobuf:"bytes,4,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"` // Deprecated: Do not use.
	// This field is deprecated, use node_ipv4_cidr_block.
	NodeIpv4Cidr string `protobuf:"bytes,5,opt,name=node_ipv4_cidr,json=nodeIpv4Cidr,proto3" json:"node_ipv4_cidr,omitempty"` // Deprecated: Do not use.
	// This field is deprecated, use services_ipv4_cidr_block.
	ServicesIpv4Cidr string `protobuf:"bytes,6,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"` // Deprecated: Do not use.
	// The name of the secondary range to be used for the cluster CIDR
	// block.  The secondary range will be used for pod IP
	// addresses. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases and
	// create_subnetwork is false.
	ClusterSecondaryRangeName string `protobuf:"bytes,7,opt,name=cluster_secondary_range_name,json=clusterSecondaryRangeName,proto3" json:"cluster_secondary_range_name,omitempty"`
	// The name of the secondary range to be used as for the services
	// CIDR block.  The secondary range will be used for service
	// ClusterIPs. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases and
	// create_subnetwork is false.
	ServicesSecondaryRangeName string `protobuf:"bytes,8,opt,name=services_secondary_range_name,json=servicesSecondaryRangeName,proto3" json:"services_secondary_range_name,omitempty"`
	// The IP address range for the cluster pod IPs. If this field is set, then
	// `cluster.cluster_ipv4_cidr` must be left blank.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ClusterIpv4CidrBlock string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock,proto3" json:"cluster_ipv4_cidr_block,omitempty"`
	// The IP address range of the instance IPs in this cluster.
	//
	// This is applicable only if `create_subnetwork` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	NodeIpv4CidrBlock string `protobuf:"bytes,10,opt,name=node_ipv4_cidr_block,json=nodeIpv4CidrBlock,proto3" json:"node_ipv4_cidr_block,omitempty"`
	// The IP address range of the services IPs in this cluster. If blank, a range
	// will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ServicesIpv4CidrBlock string `protobuf:"bytes,11,opt,name=services_ipv4_cidr_block,json=servicesIpv4CidrBlock,proto3" json:"services_ipv4_cidr_block,omitempty"`
	// If true, allow allocation of cluster CIDR ranges that overlap with certain
	// kinds of network routes. By default we do not allow cluster CIDR ranges to
	// intersect with any user declared routes. With allow_route_overlap == true,
	// we allow overlapping with CIDR ranges that are larger than the cluster CIDR
	// range.
	//
	// If this field is set to true, then cluster and services CIDRs must be
	// fully-specified (e.g. `10.96.0.0/14`, but not `/14`), which means:
	// 1) When `use_ip_aliases` is true, `cluster_ipv4_cidr_block` and
	//    `services_ipv4_cidr_block` must be fully-specified.
	// 2) When `use_ip_aliases` is false, `cluster.cluster_ipv4_cidr` muse be
	//    fully-specified.
	AllowRouteOverlap bool `protobuf:"varint,12,opt,name=allow_route_overlap,json=allowRouteOverlap,proto3" json:"allow_route_overlap,omitempty"`
	// The IP address range of the Cloud TPUs in this cluster. If unspecified, a
	// range will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// If unspecified, the range will use the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	TpuIpv4CidrBlock     string   `protobuf:"bytes,13,opt,name=tpu_ipv4_cidr_block,json=tpuIpv4CidrBlock,proto3" json:"tpu_ipv4_cidr_block,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPAllocationPolicy) Reset()         { *m = IPAllocationPolicy{} }
func (m *IPAllocationPolicy) String() string { return proto.CompactTextString(m) }
func (*IPAllocationPolicy) ProtoMessage()    {}
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{16}
}

func (m *IPAllocationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IPAllocationPolicy.Unmarshal(m, b)
}
func (m *IPAllocationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IPAllocationPolicy.Marshal(b, m, deterministic)
}
func (m *IPAllocationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAllocationPolicy.Merge(m, src)
}
func (m *IPAllocationPolicy) XXX_Size() int {
	return xxx_messageInfo_IPAllocationPolicy.Size(m)
}
func (m *IPAllocationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAllocationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_IPAllocationPolicy proto.InternalMessageInfo

func (m *IPAllocationPolicy) GetUseIpAliases() bool {
	if m != nil {
		return m.UseIpAliases
	}
	return false
}

func (m *IPAllocationPolicy) GetCreateSubnetwork() bool {
	if m != nil {
		return m.CreateSubnetwork
	}
	return false
}

func (m *IPAllocationPolicy) GetSubnetworkName() string {
	if m != nil {
		return m.SubnetworkName
	}
	return ""
}

// Deprecated: Do not use.
func (m *IPAllocationPolicy) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (m *IPAllocationPolicy) GetNodeIpv4Cidr() string {
	if m != nil {
		return m.NodeIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (m *IPAllocationPolicy) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterSecondaryRangeName() string {
	if m != nil {
		return m.ClusterSecondaryRangeName
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesSecondaryRangeName() string {
	if m != nil {
		return m.ServicesSecondaryRangeName
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if m != nil {
		return m.ClusterIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetNodeIpv4CidrBlock() string {
	if m != nil {
		return m.NodeIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesIpv4CidrBlock() string {
	if m != nil {
		return m.ServicesIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetAllowRouteOverlap() bool {
	if m != nil {
		return m.AllowRouteOverlap
	}
	return false
}

func (m *IPAllocationPolicy) GetTpuIpv4CidrBlock() string {
	if m != nil {
		return m.TpuIpv4CidrBlock
	}
	return ""
}

// Configuration for Binary Authorization.
type BinaryAuthorization struct {
	// Enable Binary Authorization for this cluster. If enabled, all container
	// images will be validated by Google Binauthz.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BinaryAuthorization) Reset()         { *m = BinaryAuthorization{} }
func (m *BinaryAuthorization) String() string { return proto.CompactTextString(m) }
func (*BinaryAuthorization) ProtoMessage()    {}
func (*BinaryAuthorization) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{17}
}

func (m *BinaryAuthorization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinaryAuthorization.Unmarshal(m, b)
}
func (m *BinaryAuthorization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinaryAuthorization.Marshal(b, m, deterministic)
}
func (m *BinaryAuthorization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinaryAuthorization.Merge(m, src)
}
func (m *BinaryAuthorization) XXX_Size() int {
	return xxx_messageInfo_BinaryAuthorization.Size(m)
}
func (m *BinaryAuthorization) XXX_DiscardUnknown() {
	xxx_messageInfo_BinaryAuthorization.DiscardUnknown(m)
}

var xxx_messageInfo_BinaryAuthorization proto.InternalMessageInfo

func (m *BinaryAuthorization) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration for the PodSecurityPolicy feature.
type PodSecurityPolicyConfig struct {
	// Enable the PodSecurityPolicy controller for this cluster. If enabled, pods
	// must be valid under a PodSecurityPolicy to be created.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSecurityPolicyConfig) Reset()         { *m = PodSecurityPolicyConfig{} }
func (m *PodSecurityPolicyConfig) String() string { return proto.CompactTextString(m) }
func (*PodSecurityPolicyConfig) ProtoMessage()    {}
func (*PodSecurityPolicyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{18}
}

func (m *PodSecurityPolicyConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodSecurityPolicyConfig.Unmarshal(m, b)
}
func (m *PodSecurityPolicyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodSecurityPolicyConfig.Marshal(b, m, deterministic)
}
func (m *PodSecurityPolicyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSecurityPolicyConfig.Merge(m, src)
}
func (m *PodSecurityPolicyConfig) XXX_Size() int {
	return xxx_messageInfo_PodSecurityPolicyConfig.Size(m)
}
func (m *PodSecurityPolicyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSecurityPolicyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PodSecurityPolicyConfig proto.InternalMessageInfo

func (m *PodSecurityPolicyConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration for returning group information from authenticators.
type AuthenticatorGroupsConfig struct {
	// Whether this cluster should return group membership lookups
	// during authentication using a group of security groups.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name of the security group-of-groups to be used. Only relevant
	// if enabled = true.
	SecurityGroup        string   `protobuf:"bytes,2,opt,name=security_group,json=securityGroup,proto3" json:"security_group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthenticatorGroupsConfig) Reset()         { *m = AuthenticatorGroupsConfig{} }
func (m *AuthenticatorGroupsConfig) String() string { return proto.CompactTextString(m) }
func (*AuthenticatorGroupsConfig) ProtoMessage()    {}
func (*AuthenticatorGroupsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{19}
}

func (m *AuthenticatorGroupsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AuthenticatorGroupsConfig.Unmarshal(m, b)
}
func (m *AuthenticatorGroupsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AuthenticatorGroupsConfig.Marshal(b, m, deterministic)
}
func (m *AuthenticatorGroupsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthenticatorGroupsConfig.Merge(m, src)
}
func (m *AuthenticatorGroupsConfig) XXX_Size() int {
	return xxx_messageInfo_AuthenticatorGroupsConfig.Size(m)
}
func (m *AuthenticatorGroupsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthenticatorGroupsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AuthenticatorGroupsConfig proto.InternalMessageInfo

func (m *AuthenticatorGroupsConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *AuthenticatorGroupsConfig) GetSecurityGroup() string {
	if m != nil {
		return m.SecurityGroup
	}
	return ""
}

// A Google Kubernetes Engine cluster.
type Cluster struct {
	// The name of this cluster. The name must be unique within this project
	// and location (e.g. zone or region), and can be up to 40 characters with
	// the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	//
	// This field is deprecated, use node_pool.initial_node_count instead.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"` // Deprecated: Do not use.
	// Parameters used in creating the cluster's nodes.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool. (For configuration of each node pool, see
	// `node_pool.config`)
	//
	// If unspecified, the defaults are used.
	// This field is deprecated, use node_pool.config instead.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"` // Deprecated: Do not use.
	// The authentication information for accessing the master endpoint.
	// If unspecified, the defaults are used:
	// For clusters before v1.12, if master_auth is unspecified, `username` will
	// be set to "admin", a random password will be generated, and a client
	// certificate will be issued.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth,proto3" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com` - the Google Cloud Logging service.
	// * `none` - no logs will be exported from the cluster.
	// * if left as an empty string,`logging.googleapis.com` will be used.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
	// * `none` - no metrics will be exported from the cluster.
	// * if left as an empty string, `monitoring.googleapis.com` will be used.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// cluster is connected. If left unspecified, the `default` network
	// will be used. On output this shows the network ID instead of
	// the name.
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](/compute/docs/subnetworks) to which the
	// cluster is connected. On output this shows the subnetwork ID instead of
	// the name.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// The node pools associated with this cluster.
	// This field should not be set if "node_config" or "initial_node_count" are
	// specified.
	NodePools []*NodePool `protobuf:"bytes,12,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	// The list of Google Compute Engine
	// [zones](/compute/docs/zones#available) in which the cluster's nodes
	// should be located.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// Kubernetes alpha features are enabled on this cluster. This includes alpha
	// API groups (e.g. v1beta1) and features that may not be production ready in
	// the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after
	// creation.
	EnableKubernetesAlpha bool `protobuf:"varint,14,opt,name=enable_kubernetes_alpha,json=enableKubernetesAlpha,proto3" json:"enable_kubernetes_alpha,omitempty"`
	// The resource labels for the cluster to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels map[string]string `protobuf:"bytes,15,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The fingerprint of the set of labels for this cluster.
	LabelFingerprint string `protobuf:"bytes,16,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// Configuration for the legacy ABAC authorization mode.
	LegacyAbac *LegacyAbac `protobuf:"bytes,18,opt,name=legacy_abac,json=legacyAbac,proto3" json:"legacy_abac,omitempty"`
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,19,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Configuration for cluster IP allocation.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,20,opt,name=ip_allocation_policy,json=ipAllocationPolicy,proto3" json:"ip_allocation_policy,omitempty"`
	// The configuration options for master authorized networks feature.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,22,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
	// Configure the maintenance policy for this cluster.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,23,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Configuration for Binary Authorization.
	BinaryAuthorization *BinaryAuthorization `protobuf:"bytes,24,opt,name=binary_authorization,json=binaryAuthorization,proto3" json:"binary_authorization,omitempty"`
	// Configuration for the PodSecurityPolicy feature.
	PodSecurityPolicyConfig *PodSecurityPolicyConfig `protobuf:"bytes,25,opt,name=pod_security_policy_config,json=podSecurityPolicyConfig,proto3" json:"pod_security_policy_config,omitempty"`
	// Cluster-level autoscaling configuration.
	Autoscaling *ClusterAutoscaling `protobuf:"bytes,26,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// Configuration for cluster networking.
	NetworkConfig *NetworkConfig `protobuf:"bytes,27,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// If this is a private cluster setup. Private clusters are clusters that, by
	// default have no external IP addresses on the nodes and where nodes and the
	// master communicate over private IP addresses.
	// This field is deprecated, use private_cluster_config.enable_private_nodes
	// instead.
	PrivateCluster bool `protobuf:"varint,28,opt,name=private_cluster,json=privateCluster,proto3" json:"private_cluster,omitempty"` // Deprecated: Do not use.
	// The IP prefix in CIDR notation to use for the hosted master network.
	// This prefix will be used for assigning private IP addresses to the
	// master or set of masters, as well as the ILB VIP.
	// This field is deprecated, use
	// private_cluster_config.master_ipv4_cidr_block instead.
	MasterIpv4CidrBlock string `protobuf:"bytes,29,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"` // Deprecated: Do not use.
	// The default constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool of this cluster. Only honored
	// if cluster created with IP Alias support.
	DefaultMaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,30,opt,name=default_max_pods_constraint,json=defaultMaxPodsConstraint,proto3" json:"default_max_pods_constraint,omitempty"`
	// Configuration for exporting resource usages. Resource usage export is
	// disabled when this config unspecified.
	ResourceUsageExportConfig *ResourceUsageExportConfig `protobuf:"bytes,33,opt,name=resource_usage_export_config,json=resourceUsageExportConfig,proto3" json:"resource_usage_export_config,omitempty"`
	// Configuration controlling RBAC group membership information.
	AuthenticatorGroupsConfig *AuthenticatorGroupsConfig `protobuf:"bytes,34,opt,name=authenticator_groups_config,json=authenticatorGroupsConfig,proto3" json:"authenticator_groups_config,omitempty"`
	// Configuration for private cluster.
	PrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,37,opt,name=private_cluster_config,json=privateClusterConfig,proto3" json:"private_cluster_config,omitempty"`
	// Cluster-level Vertical Pod Autoscaling configuration.
	VerticalPodAutoscaling *VerticalPodAutoscaling `protobuf:"bytes,39,opt,name=vertical_pod_autoscaling,json=verticalPodAutoscaling,proto3" json:"vertical_pod_autoscaling,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use location instead.
	Zone string `protobuf:"bytes,101,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// [Output only] The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The initial Kubernetes version for this cluster.  Valid versions are those
	// found in validMasterVersions returned by getServerConfig.  The version can
	// be upgraded over time; such upgrades are reflected in
	// currentMasterVersion and currentNodeVersion.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "","-": picks the default Kubernetes version
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion,proto3" json:"initial_cluster_version,omitempty"`
	// [Output only] The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion,proto3" json:"current_master_version,omitempty"`
	// [Output only] Deprecated, use
	// [NodePool.version](/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools)
	// instead. The current version of the node software components.
	// If they are currently at multiple versions because they're in the process
	// of being upgraded, this reflects the minimum version of all nodes.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion,proto3" json:"current_node_version,omitempty"` // Deprecated: Do not use.
	// [Output only] The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// [Output only] The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,proto3,enum=google.container.v1beta1.Cluster_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// cluster, if available.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"` // Deprecated: Do not use.
	// [Output only] The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr`
	// range. This field will only be set when cluster is in route-based network
	// mode.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize,proto3" json:"node_ipv4_cidr_size,omitempty"`
	// [Output only] The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"`
	// Deprecated. Use node_pools.instance_group_urls.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"` // Deprecated: Do not use.
	// [Output only]  The number of nodes currently in the cluster. Deprecated.
	// Call Kubernetes API directly to retrieve node information.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount,proto3" json:"current_node_count,omitempty"` // Deprecated: Do not use.
	// [Output only] The time the cluster will be automatically
	// deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `protobuf:"bytes,113,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/regions-zones/regions-zones#available) or
	// [region](/compute/docs/regions-zones/regions-zones#available) in which
	// the cluster resides.
	Location string `protobuf:"bytes,114,opt,name=location,proto3" json:"location,omitempty"`
	// Enable the ability to use Cloud TPUs in this cluster.
	EnableTpu bool `protobuf:"varint,115,opt,name=enable_tpu,json=enableTpu,proto3" json:"enable_tpu,omitempty"`
	// [Output only] The IP address range of the Cloud TPUs in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`).
	TpuIpv4CidrBlock string `protobuf:"bytes,116,opt,name=tpu_ipv4_cidr_block,json=tpuIpv4CidrBlock,proto3" json:"tpu_ipv4_cidr_block,omitempty"`
	// Configuration of etcd encryption.
	DatabaseEncryption *DatabaseEncryption `protobuf:"bytes,38,opt,name=database_encryption,json=databaseEncryption,proto3" json:"database_encryption,omitempty"`
	// Which conditions caused the current cluster state.
	Conditions           []*StatusCondition `protobuf:"bytes,118,rep,name=conditions,proto3" json:"conditions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{20}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

// Deprecated: Do not use.
func (m *Cluster) GetNodeConfig() *NodeConfig {
	if m != nil {
		return m.NodeConfig
	}
	return nil
}

func (m *Cluster) GetMasterAuth() *MasterAuth {
	if m != nil {
		return m.MasterAuth
	}
	return nil
}

func (m *Cluster) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *Cluster) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *Cluster) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *Cluster) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

func (m *Cluster) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *Cluster) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func (m *Cluster) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

func (m *Cluster) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *Cluster) GetEnableKubernetesAlpha() bool {
	if m != nil {
		return m.EnableKubernetesAlpha
	}
	return false
}

func (m *Cluster) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *Cluster) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

func (m *Cluster) GetLegacyAbac() *LegacyAbac {
	if m != nil {
		return m.LegacyAbac
	}
	return nil
}

func (m *Cluster) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *Cluster) GetIpAllocationPolicy() *IPAllocationPolicy {
	if m != nil {
		return m.IpAllocationPolicy
	}
	return nil
}

func (m *Cluster) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if m != nil {
		return m.MasterAuthorizedNetworksConfig
	}
	return nil
}

func (m *Cluster) GetMaintenancePolicy() *MaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *Cluster) GetBinaryAuthorization() *BinaryAuthorization {
	if m != nil {
		return m.BinaryAuthorization
	}
	return nil
}

func (m *Cluster) GetPodSecurityPolicyConfig() *PodSecurityPolicyConfig {
	if m != nil {
		return m.PodSecurityPolicyConfig
	}
	return nil
}

func (m *Cluster) GetAutoscaling() *ClusterAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *Cluster) GetNetworkConfig() *NetworkConfig {
	if m != nil {
		return m.NetworkConfig
	}
	return nil
}

// Deprecated: Do not use.
func (m *Cluster) GetPrivateCluster() bool {
	if m != nil {
		return m.PrivateCluster
	}
	return false
}

// Deprecated: Do not use.
func (m *Cluster) GetMasterIpv4CidrBlock() string {
	if m != nil {
		return m.MasterIpv4CidrBlock
	}
	return ""
}

func (m *Cluster) GetDefaultMaxPodsConstraint() *MaxPodsConstraint {
	if m != nil {
		return m.DefaultMaxPodsConstraint
	}
	return nil
}

func (m *Cluster) GetResourceUsageExportConfig() *ResourceUsageExportConfig {
	if m != nil {
		return m.ResourceUsageExportConfig
	}
	return nil
}

func (m *Cluster) GetAuthenticatorGroupsConfig() *AuthenticatorGroupsConfig {
	if m != nil {
		return m.AuthenticatorGroupsConfig
	}
	return nil
}

func (m *Cluster) GetPrivateClusterConfig() *PrivateClusterConfig {
	if m != nil {
		return m.PrivateClusterConfig
	}
	return nil
}

func (m *Cluster) GetVerticalPodAutoscaling() *VerticalPodAutoscaling {
	if m != nil {
		return m.VerticalPodAutoscaling
	}
	return nil
}

func (m *Cluster) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Cluster) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Cluster) GetInitialClusterVersion() string {
	if m != nil {
		return m.InitialClusterVersion
	}
	return ""
}

func (m *Cluster) GetCurrentMasterVersion() string {
	if m != nil {
		return m.CurrentMasterVersion
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetCurrentNodeVersion() string {
	if m != nil {
		return m.CurrentNodeVersion
	}
	return ""
}

func (m *Cluster) GetCreateTime() string {
	if m != nil {
		return m.CreateTime
	}
	return ""
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

// Deprecated: Do not use.
func (m *Cluster) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Cluster) GetNodeIpv4CidrSize() int32 {
	if m != nil {
		return m.NodeIpv4CidrSize
	}
	return 0
}

func (m *Cluster) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

// Deprecated: Do not use.
func (m *Cluster) GetCurrentNodeCount() int32 {
	if m != nil {
		return m.CurrentNodeCount
	}
	return 0
}

func (m *Cluster) GetExpireTime() string {
	if m != nil {
		return m.ExpireTime
	}
	return ""
}

func (m *Cluster) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Cluster) GetEnableTpu() bool {
	if m != nil {
		return m.EnableTpu
	}
	return false
}

func (m *Cluster) GetTpuIpv4CidrBlock() string {
	if m != nil {
		return m.TpuIpv4CidrBlock
	}
	return ""
}

func (m *Cluster) GetDatabaseEncryption() *DatabaseEncryption {
	if m != nil {
		return m.DatabaseEncryption
	}
	return nil
}

func (m *Cluster) GetConditions() []*StatusCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	// The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion,proto3" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - the Google Cloud Monitoring
	// service with Kubernetes-native resource model
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService,proto3" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig,proto3" json:"desired_addons_config,omitempty"`
	// The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family",
	// "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
	// is specified and there is more than one node pool on the cluster.
	DesiredNodePoolId string `protobuf:"bytes,7,opt,name=desired_node_pool_id,json=desiredNodePoolId,proto3" json:"desired_node_pool_id,omitempty"`
	// The desired image type for the node pool.
	// NOTE: Set the "desired_node_pool" field as well.
	DesiredImageType string `protobuf:"bytes,8,opt,name=desired_image_type,json=desiredImageType,proto3" json:"desired_image_type,omitempty"`
	// Autoscaler configuration for the node pool specified in
	// desired_node_pool_id. If there is only one pool in the
	// cluster and desired_node_pool_id is not provided then
	// the change applies to that single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `protobuf:"bytes,9,opt,name=desired_node_pool_autoscaling,json=desiredNodePoolAutoscaling,proto3" json:"desired_node_pool_autoscaling,omitempty"`
	// The desired list of Google Compute Engine
	// [zones](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	DesiredLocations []string `protobuf:"bytes,10,rep,name=desired_locations,json=desiredLocations,proto3" json:"desired_locations,omitempty"`
	// The desired configuration options for master authorized networks feature.
	DesiredMasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,12,opt,name=desired_master_authorized_networks_config,json=desiredMasterAuthorizedNetworksConfig,proto3" json:"desired_master_authorized_networks_config,omitempty"`
	// The desired configuration options for the PodSecurityPolicy feature.
	DesiredPodSecurityPolicyConfig *PodSecurityPolicyConfig `protobuf:"bytes,14,opt,name=desired_pod_security_policy_config,json=desiredPodSecurityPolicyConfig,proto3" json:"desired_pod_security_policy_config,omitempty"`
	// Cluster-level autoscaling configuration.
	DesiredClusterAutoscaling *ClusterAutoscaling `protobuf:"bytes,15,opt,name=desired_cluster_autoscaling,json=desiredClusterAutoscaling,proto3" json:"desired_cluster_autoscaling,omitempty"`
	// The desired configuration options for the Binary Authorization feature.
	DesiredBinaryAuthorization *BinaryAuthorization `protobuf:"bytes,16,opt,name=desired_binary_authorization,json=desiredBinaryAuthorization,proto3" json:"desired_binary_authorization,omitempty"`
	// The logging service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "logging.googleapis.com/kubernetes" - the Google Cloud Logging
	// service with Kubernetes-native resource model
	// * "logging.googleapis.com" - the Google Cloud Logging service
	// * "none" - no logs will be exported from the cluster
	DesiredLoggingService string `protobuf:"bytes,19,opt,name=desired_logging_service,json=desiredLoggingService,proto3" json:"desired_logging_service,omitempty"`
	// The desired configuration for exporting resource usage.
	DesiredResourceUsageExportConfig *ResourceUsageExportConfig `protobuf:"bytes,21,opt,name=desired_resource_usage_export_config,json=desiredResourceUsageExportConfig,proto3" json:"desired_resource_usage_export_config,omitempty"`
	// Cluster-level Vertical Pod Autoscaling configuration.
	DesiredVerticalPodAutoscaling *VerticalPodAutoscaling `protobuf:"bytes,22,opt,name=desired_vertical_pod_autoscaling,json=desiredVerticalPodAutoscaling,proto3" json:"desired_vertical_pod_autoscaling,omitempty"`
	// The desired config of Intra-node visibility.
	DesiredIntraNodeVisibilityConfig *IntraNodeVisibilityConfig `protobuf:"bytes,26,opt,name=desired_intra_node_visibility_config,json=desiredIntraNodeVisibilityConfig,proto3" json:"desired_intra_node_visibility_config,omitempty"`
	// The Kubernetes version to change the master to. The only valid value is the
	// latest supported version.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	DesiredMasterVersion string   `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion,proto3" json:"desired_master_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterUpdate) Reset()         { *m = ClusterUpdate{} }
func (m *ClusterUpdate) String() string { return proto.CompactTextString(m) }
func (*ClusterUpdate) ProtoMessage()    {}
func (*ClusterUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{21}
}

func (m *ClusterUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterUpdate.Unmarshal(m, b)
}
func (m *ClusterUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterUpdate.Marshal(b, m, deterministic)
}
func (m *ClusterUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterUpdate.Merge(m, src)
}
func (m *ClusterUpdate) XXX_Size() int {
	return xxx_messageInfo_ClusterUpdate.Size(m)
}
func (m *ClusterUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterUpdate proto.InternalMessageInfo

func (m *ClusterUpdate) GetDesiredNodeVersion() string {
	if m != nil {
		return m.DesiredNodeVersion
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredMonitoringService() string {
	if m != nil {
		return m.DesiredMonitoringService
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.DesiredAddonsConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredNodePoolId() string {
	if m != nil {
		return m.DesiredNodePoolId
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredImageType() string {
	if m != nil {
		return m.DesiredImageType
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredNodePoolAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.DesiredNodePoolAutoscaling
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredLocations() []string {
	if m != nil {
		return m.DesiredLocations
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if m != nil {
		return m.DesiredMasterAuthorizedNetworksConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredPodSecurityPolicyConfig() *PodSecurityPolicyConfig {
	if m != nil {
		return m.DesiredPodSecurityPolicyConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredClusterAutoscaling() *ClusterAutoscaling {
	if m != nil {
		return m.DesiredClusterAutoscaling
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredBinaryAuthorization() *BinaryAuthorization {
	if m != nil {
		return m.DesiredBinaryAuthorization
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredLoggingService() string {
	if m != nil {
		return m.DesiredLoggingService
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredResourceUsageExportConfig() *ResourceUsageExportConfig {
	if m != nil {
		return m.DesiredResourceUsageExportConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredVerticalPodAutoscaling() *VerticalPodAutoscaling {
	if m != nil {
		return m.DesiredVerticalPodAutoscaling
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredIntraNodeVisibilityConfig() *IntraNodeVisibilityConfig {
	if m != nil {
		return m.DesiredIntraNodeVisibilityConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterVersion() string {
	if m != nil {
		return m.DesiredMasterVersion
	}
	return ""
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	// The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation
	// is taking place.
	// This field is deprecated, use location instead.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.container.v1beta1.Operation_Type" json:"operation_type,omitempty"`
	// The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,proto3,enum=google.container.v1beta1.Operation_Status" json:"status,omitempty"`
	// Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail,proto3" json:"detail,omitempty"`
	// If an error has occurred, a textual description of the error.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"` // Deprecated: Do not use.
	// Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Server-defined URL for the target of the operation.
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink,proto3" json:"target_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/regions-zones/regions-zones#available) or
	// [region](/compute/docs/regions-zones/regions-zones#available) in which
	// the cluster resides.
	Location string `protobuf:"bytes,9,opt,name=location,proto3" json:"location,omitempty"`
	// [Output only] The time the operation started, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	StartTime string `protobuf:"bytes,10,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// [Output only] The time the operation completed, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	EndTime string `protobuf:"bytes,11,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// [Output only] Progress information for an operation.
	Progress *OperationProgress `protobuf:"bytes,12,opt,name=progress,proto3" json:"progress,omitempty"`
	// Which conditions caused the current cluster state.
	ClusterConditions []*StatusCondition `protobuf:"bytes,13,rep,name=cluster_conditions,json=clusterConditions,proto3" json:"cluster_conditions,omitempty"`
	// Which conditions caused the current node pool state.
	NodepoolConditions   []*StatusCondition `protobuf:"bytes,14,rep,name=nodepool_conditions,json=nodepoolConditions,proto3" json:"nodepool_conditions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{22}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *Operation) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Operation) GetOperationType() Operation_Type {
	if m != nil {
		return m.OperationType
	}
	return Operation_TYPE_UNSPECIFIED
}

func (m *Operation) GetStatus() Operation_Status {
	if m != nil {
		return m.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (m *Operation) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

// Deprecated: Do not use.
func (m *Operation) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Operation) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *Operation) GetTargetLink() string {
	if m != nil {
		return m.TargetLink
	}
	return ""
}

func (m *Operation) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Operation) GetStartTime() string {
	if m != nil {
		return m.StartTime
	}
	return ""
}

func (m *Operation) GetEndTime() string {
	if m != nil {
		return m.EndTime
	}
	return ""
}

func (m *Operation) GetProgress() *OperationProgress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (m *Operation) GetClusterConditions() []*StatusCondition {
	if m != nil {
		return m.ClusterConditions
	}
	return nil
}

func (m *Operation) GetNodepoolConditions() []*StatusCondition {
	if m != nil {
		return m.NodepoolConditions
	}
	return nil
}

// Information about operation (or operation stage) progress.
type OperationProgress struct {
	// A non-parameterized string describing an operation stage.
	// Unset for single-stage operations.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Status of an operation stage.
	// Unset for single-stage operations.
	Status Operation_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.container.v1beta1.Operation_Status" json:"status,omitempty"`
	// Progress metric bundle, for example:
	//   metrics: [{name: "nodes done",     int_value: 15},
	//             {name: "nodes total",    int_value: 32}]
	// or
	//   metrics: [{name: "progress",       double_value: 0.56},
	//             {name: "progress scale", double_value: 1.0}]
	Metrics []*OperationProgress_Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Substages of an operation or a stage.
	Stages               []*OperationProgress `protobuf:"bytes,4,rep,name=stages,proto3" json:"stages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OperationProgress) Reset()         { *m = OperationProgress{} }
func (m *OperationProgress) String() string { return proto.CompactTextString(m) }
func (*OperationProgress) ProtoMessage()    {}
func (*OperationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{23}
}

func (m *OperationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationProgress.Unmarshal(m, b)
}
func (m *OperationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationProgress.Marshal(b, m, deterministic)
}
func (m *OperationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationProgress.Merge(m, src)
}
func (m *OperationProgress) XXX_Size() int {
	return xxx_messageInfo_OperationProgress.Size(m)
}
func (m *OperationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_OperationProgress proto.InternalMessageInfo

func (m *OperationProgress) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OperationProgress) GetStatus() Operation_Status {
	if m != nil {
		return m.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (m *OperationProgress) GetMetrics() []*OperationProgress_Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *OperationProgress) GetStages() []*OperationProgress {
	if m != nil {
		return m.Stages
	}
	return nil
}

// Progress metric is (string, int|float|string) pair.
type OperationProgress_Metric struct {
	// Metric name, required.
	// e.g., "nodes total", "percent done"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Strictly one of the values is required.
	//
	// Types that are valid to be assigned to Value:
	//	*OperationProgress_Metric_IntValue
	//	*OperationProgress_Metric_DoubleValue
	//	*OperationProgress_Metric_StringValue
	Value                isOperationProgress_Metric_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *OperationProgress_Metric) Reset()         { *m = OperationProgress_Metric{} }
func (m *OperationProgress_Metric) String() string { return proto.CompactTextString(m) }
func (*OperationProgress_Metric) ProtoMessage()    {}
func (*OperationProgress_Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{23, 0}
}

func (m *OperationProgress_Metric) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationProgress_Metric.Unmarshal(m, b)
}
func (m *OperationProgress_Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationProgress_Metric.Marshal(b, m, deterministic)
}
func (m *OperationProgress_Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationProgress_Metric.Merge(m, src)
}
func (m *OperationProgress_Metric) XXX_Size() int {
	return xxx_messageInfo_OperationProgress_Metric.Size(m)
}
func (m *OperationProgress_Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationProgress_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_OperationProgress_Metric proto.InternalMessageInfo

func (m *OperationProgress_Metric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isOperationProgress_Metric_Value interface {
	isOperationProgress_Metric_Value()
}

type OperationProgress_Metric_IntValue struct {
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type OperationProgress_Metric_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type OperationProgress_Metric_StringValue struct {
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*OperationProgress_Metric_IntValue) isOperationProgress_Metric_Value() {}

func (*OperationProgress_Metric_DoubleValue) isOperationProgress_Metric_Value() {}

func (*OperationProgress_Metric_StringValue) isOperationProgress_Metric_Value() {}

func (m *OperationProgress_Metric) GetValue() isOperationProgress_Metric_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *OperationProgress_Metric) GetIntValue() int64 {
	if x, ok := m.GetValue().(*OperationProgress_Metric_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *OperationProgress_Metric) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*OperationProgress_Metric_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *OperationProgress_Metric) GetStringValue() string {
	if x, ok := m.GetValue().(*OperationProgress_Metric_StringValue); ok {
		return x.StringValue
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OperationProgress_Metric) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OperationProgress_Metric_IntValue)(nil),
		(*OperationProgress_Metric_DoubleValue)(nil),
		(*OperationProgress_Metric_StringValue)(nil),
	}
}

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. A [cluster
	// resource](/container-engine/reference/rest/v1beta1/projects.zones.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The parent (project and location) where the cluster will be created.
	// Specified in the format 'projects/*/locations/*'.
	Parent               string   `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{24}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CreateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *CreateClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to retrieve.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster) of the cluster to retrieve.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{25}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{26}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolVersionRequest updates the version of a node pool.
type UpdateNodePoolRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// Required. The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	NodeVersion string `protobuf:"bytes,5,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// Required. The desired image type for the node pool.
	ImageType string `protobuf:"bytes,6,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The desired image type for the node pool.
	WorkloadMetadataConfig *WorkloadMetadataConfig `protobuf:"bytes,14,opt,name=workload_metadata_config,json=workloadMetadataConfig,proto3" json:"workload_metadata_config,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to
	// update. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateNodePoolRequest) Reset()         { *m = UpdateNodePoolRequest{} }
func (m *UpdateNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNodePoolRequest) ProtoMessage()    {}
func (*UpdateNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{27}
}

func (m *UpdateNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNodePoolRequest.Unmarshal(m, b)
}
func (m *UpdateNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNodePoolRequest.Merge(m, src)
}
func (m *UpdateNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNodePoolRequest.Size(m)
}
func (m *UpdateNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetNodeVersion() string {
	if m != nil {
		return m.NodeVersion
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetWorkloadMetadataConfig() *WorkloadMetadataConfig {
	if m != nil {
		return m.WorkloadMetadataConfig
	}
	return nil
}

func (m *UpdateNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
type SetNodePoolAutoscalingRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// Required. Autoscaling configuration for the node pool.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,5,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to set
	// autoscaler settings. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNodePoolAutoscalingRequest) Reset()         { *m = SetNodePoolAutoscalingRequest{} }
func (m *SetNodePoolAutoscalingRequest) String() string { return proto.CompactTextString(m) }
func (*SetNodePoolAutoscalingRequest) ProtoMessage()    {}
func (*SetNodePoolAutoscalingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{28}
}

func (m *SetNodePoolAutoscalingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNodePoolAutoscalingRequest.Unmarshal(m, b)
}
func (m *SetNodePoolAutoscalingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNodePoolAutoscalingRequest.Marshal(b, m, deterministic)
}
func (m *SetNodePoolAutoscalingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNodePoolAutoscalingRequest.Merge(m, src)
}
func (m *SetNodePoolAutoscalingRequest) XXX_Size() int {
	return xxx_messageInfo_SetNodePoolAutoscalingRequest.Size(m)
}
func (m *SetNodePoolAutoscalingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNodePoolAutoscalingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNodePoolAutoscalingRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolAutoscalingRequest) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *SetNodePoolAutoscalingRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLoggingServiceRequest sets the logging service of a cluster.
type SetLoggingServiceRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The logging service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "logging.googleapis.com" - the Google Cloud Logging service
	// * "none" - no metrics will be exported from the cluster
	LoggingService string `protobuf:"bytes,4,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set logging.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLoggingServiceRequest) Reset()         { *m = SetLoggingServiceRequest{} }
func (m *SetLoggingServiceRequest) String() string { return proto.CompactTextString(m) }
func (*SetLoggingServiceRequest) ProtoMessage()    {}
func (*SetLoggingServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{29}
}

func (m *SetLoggingServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLoggingServiceRequest.Unmarshal(m, b)
}
func (m *SetLoggingServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLoggingServiceRequest.Marshal(b, m, deterministic)
}
func (m *SetLoggingServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLoggingServiceRequest.Merge(m, src)
}
func (m *SetLoggingServiceRequest) XXX_Size() int {
	return xxx_messageInfo_SetLoggingServiceRequest.Size(m)
}
func (m *SetLoggingServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLoggingServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLoggingServiceRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLoggingServiceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLoggingServiceRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMonitoringServiceRequest sets the monitoring service of a cluster.
type SetMonitoringServiceRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	MonitoringService string `protobuf:"bytes,4,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set monitoring.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMonitoringServiceRequest) Reset()         { *m = SetMonitoringServiceRequest{} }
func (m *SetMonitoringServiceRequest) String() string { return proto.CompactTextString(m) }
func (*SetMonitoringServiceRequest) ProtoMessage()    {}
func (*SetMonitoringServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{30}
}

func (m *SetMonitoringServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMonitoringServiceRequest.Unmarshal(m, b)
}
func (m *SetMonitoringServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMonitoringServiceRequest.Marshal(b, m, deterministic)
}
func (m *SetMonitoringServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMonitoringServiceRequest.Merge(m, src)
}
func (m *SetMonitoringServiceRequest) XXX_Size() int {
	return xxx_messageInfo_SetMonitoringServiceRequest.Size(m)
}
func (m *SetMonitoringServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMonitoringServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMonitoringServiceRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetMonitoringServiceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMonitoringServiceRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMonitoringServiceRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetAddonsRequest sets the addons associated with the cluster.
type SetAddonsConfigRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The desired configurations for the various addons available to run in the
	// cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,4,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name (project, location, cluster) of the cluster to set addons.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetAddonsConfigRequest) Reset()         { *m = SetAddonsConfigRequest{} }
func (m *SetAddonsConfigRequest) String() string { return proto.CompactTextString(m) }
func (*SetAddonsConfigRequest) ProtoMessage()    {}
func (*SetAddonsConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{31}
}

func (m *SetAddonsConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetAddonsConfigRequest.Unmarshal(m, b)
}
func (m *SetAddonsConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetAddonsConfigRequest.Marshal(b, m, deterministic)
}
func (m *SetAddonsConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetAddonsConfigRequest.Merge(m, src)
}
func (m *SetAddonsConfigRequest) XXX_Size() int {
	return xxx_messageInfo_SetAddonsConfigRequest.Size(m)
}
func (m *SetAddonsConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetAddonsConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetAddonsConfigRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetAddonsConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetAddonsConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetAddonsConfigRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetAddonsConfigRequest) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *SetAddonsConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLocationsRequest sets the locations of the cluster.
type SetLocationsRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The desired list of Google Compute Engine
	// [zones](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	Locations []string `protobuf:"bytes,4,rep,name=locations,proto3" json:"locations,omitempty"`
	// The name (project, location, cluster) of the cluster to set locations.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLocationsRequest) Reset()         { *m = SetLocationsRequest{} }
func (m *SetLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*SetLocationsRequest) ProtoMessage()    {}
func (*SetLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{32}
}

func (m *SetLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLocationsRequest.Unmarshal(m, b)
}
func (m *SetLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLocationsRequest.Marshal(b, m, deterministic)
}
func (m *SetLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLocationsRequest.Merge(m, src)
}
func (m *SetLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_SetLocationsRequest.Size(m)
}
func (m *SetLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLocationsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLocationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLocationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLocationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLocationsRequest) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *SetLocationsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateMasterRequest updates the master of the cluster.
type UpdateMasterRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The Kubernetes version to change the master to.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	MasterVersion string `protobuf:"bytes,4,opt,name=master_version,json=masterVersion,proto3" json:"master_version,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateMasterRequest) Reset()         { *m = UpdateMasterRequest{} }
func (m *UpdateMasterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateMasterRequest) ProtoMessage()    {}
func (*UpdateMasterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{33}
}

func (m *UpdateMasterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateMasterRequest.Unmarshal(m, b)
}
func (m *UpdateMasterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateMasterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateMasterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateMasterRequest.Merge(m, src)
}
func (m *UpdateMasterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateMasterRequest.Size(m)
}
func (m *UpdateMasterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateMasterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateMasterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateMasterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateMasterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateMasterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateMasterRequest) GetMasterVersion() string {
	if m != nil {
		return m.MasterVersion
	}
	return ""
}

func (m *UpdateMasterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMasterAuthRequest updates the admin password of a cluster.
type SetMasterAuthRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The exact form of action to be taken on the master auth.
	Action SetMasterAuthRequest_Action `protobuf:"varint,4,opt,name=action,proto3,enum=google.container.v1beta1.SetMasterAuthRequest_Action" json:"action,omitempty"`
	// Required. A description of the update.
	Update *MasterAuth `protobuf:"bytes,5,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to set auth.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMasterAuthRequest) Reset()         { *m = SetMasterAuthRequest{} }
func (m *SetMasterAuthRequest) String() string { return proto.CompactTextString(m) }
func (*SetMasterAuthRequest) ProtoMessage()    {}
func (*SetMasterAuthRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{34}
}

func (m *SetMasterAuthRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMasterAuthRequest.Unmarshal(m, b)
}
func (m *SetMasterAuthRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMasterAuthRequest.Marshal(b, m, deterministic)
}
func (m *SetMasterAuthRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMasterAuthRequest.Merge(m, src)
}
func (m *SetMasterAuthRequest) XXX_Size() int {
	return xxx_messageInfo_SetMasterAuthRequest.Size(m)
}
func (m *SetMasterAuthRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMasterAuthRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMasterAuthRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetMasterAuthRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMasterAuthRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMasterAuthRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMasterAuthRequest) GetAction() SetMasterAuthRequest_Action {
	if m != nil {
		return m.Action
	}
	return SetMasterAuthRequest_UNKNOWN
}

func (m *SetMasterAuthRequest) GetUpdate() *MasterAuth {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *SetMasterAuthRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to delete.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster) of the cluster to delete.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{35}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides, or "-" for all zones.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The parent (project and location) where the clusters will be listed.
	// Specified in the format 'projects/*/locations/*'.
	// Location "-" matches all zones and all regions.
	Parent               string   `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{36}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListClustersRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones         []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{37}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, operation id) of the operation to get.
	// Specified in the format 'projects/*/locations/*/operations/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOperationRequest) Reset()         { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()    {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{38}
}

func (m *GetOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOperationRequest.Unmarshal(m, b)
}
func (m *GetOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOperationRequest.Marshal(b, m, deterministic)
}
func (m *GetOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOperationRequest.Merge(m, src)
}
func (m *GetOperationRequest) XXX_Size() int {
	return xxx_messageInfo_GetOperationRequest.Size(m)
}
func (m *GetOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOperationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *GetOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) to return operations for, or `-` for
	// all zones. This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The parent (project and location) where the operations will be listed.
	// Specified in the format 'projects/*/locations/*'.
	// Location "-" matches all zones and all regions.
	Parent               string   `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOperationsRequest) Reset()         { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()    {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{39}
}

func (m *ListOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOperationsRequest.Unmarshal(m, b)
}
func (m *ListOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOperationsRequest.Merge(m, src)
}
func (m *ListOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListOperationsRequest.Size(m)
}
func (m *ListOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListOperationsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListOperationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListOperationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListOperationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, operation id) of the operation to cancel.
	// Specified in the format 'projects/*/locations/*/operations/*'.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelOperationRequest) Reset()         { *m = CancelOperationRequest{} }
func (m *CancelOperationRequest) String() string { return proto.CompactTextString(m) }
func (*CancelOperationRequest) ProtoMessage()    {}
func (*CancelOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{40}
}

func (m *CancelOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelOperationRequest.Unmarshal(m, b)
}
func (m *CancelOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelOperationRequest.Marshal(b, m, deterministic)
}
func (m *CancelOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelOperationRequest.Merge(m, src)
}
func (m *CancelOperationRequest) XXX_Size() int {
	return xxx_messageInfo_CancelOperationRequest.Size(m)
}
func (m *CancelOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelOperationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CancelOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CancelOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *CancelOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *CancelOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones         []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOperationsResponse) Reset()         { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()    {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{41}
}

func (m *ListOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOperationsResponse.Unmarshal(m, b)
}
func (m *ListOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOperationsResponse.Merge(m, src)
}
func (m *ListOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListOperationsResponse.Size(m)
}
func (m *ListOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOperationsResponse proto.InternalMessageInfo

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListOperationsResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// Gets the current Kubernetes Engine service configuration.
type GetServerConfigRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) to return operations for.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The name (project and location) of the server config to get,
	// specified in the format 'projects/*/locations/*'.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServerConfigRequest) Reset()         { *m = GetServerConfigRequest{} }
func (m *GetServerConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetServerConfigRequest) ProtoMessage()    {}
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{42}
}

func (m *GetServerConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServerConfigRequest.Unmarshal(m, b)
}
func (m *GetServerConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServerConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetServerConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServerConfigRequest.Merge(m, src)
}
func (m *GetServerConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetServerConfigRequest.Size(m)
}
func (m *GetServerConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServerConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServerConfigRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetServerConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetServerConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetServerConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Kubernetes Engine service configuration.
type ServerConfig struct {
	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion,proto3" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions,proto3" json:"valid_node_versions,omitempty"`
	// Default image type.
	DefaultImageType string `protobuf:"bytes,4,opt,name=default_image_type,json=defaultImageType,proto3" json:"default_image_type,omitempty"`
	// List of valid image types.
	ValidImageTypes []string `protobuf:"bytes,5,rep,name=valid_image_types,json=validImageTypes,proto3" json:"valid_image_types,omitempty"`
	// List of valid master versions.
	ValidMasterVersions  []string `protobuf:"bytes,6,rep,name=valid_master_versions,json=validMasterVersions,proto3" json:"valid_master_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerConfig) Reset()         { *m = ServerConfig{} }
func (m *ServerConfig) String() string { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()    {}
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{43}
}

func (m *ServerConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerConfig.Unmarshal(m, b)
}
func (m *ServerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerConfig.Marshal(b, m, deterministic)
}
func (m *ServerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerConfig.Merge(m, src)
}
func (m *ServerConfig) XXX_Size() int {
	return xxx_messageInfo_ServerConfig.Size(m)
}
func (m *ServerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServerConfig proto.InternalMessageInfo

func (m *ServerConfig) GetDefaultClusterVersion() string {
	if m != nil {
		return m.DefaultClusterVersion
	}
	return ""
}

func (m *ServerConfig) GetValidNodeVersions() []string {
	if m != nil {
		return m.ValidNodeVersions
	}
	return nil
}

func (m *ServerConfig) GetDefaultImageType() string {
	if m != nil {
		return m.DefaultImageType
	}
	return ""
}

func (m *ServerConfig) GetValidImageTypes() []string {
	if m != nil {
		return m.ValidImageTypes
	}
	return nil
}

func (m *ServerConfig) GetValidMasterVersions() []string {
	if m != nil {
		return m.ValidMasterVersions
	}
	return nil
}

// CreateNodePoolRequest creates a node pool for a cluster.
type CreateNodePoolRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The node pool to create.
	NodePool *NodePool `protobuf:"bytes,4,opt,name=node_pool,json=nodePool,proto3" json:"node_pool,omitempty"`
	// The parent (project, location, cluster id) where the node pool will be
	// created. Specified in the format
	// 'projects/*/locations/*/clusters/*'.
	Parent               string   `protobuf:"bytes,6,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNodePoolRequest) Reset()         { *m = CreateNodePoolRequest{} }
func (m *CreateNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNodePoolRequest) ProtoMessage()    {}
func (*CreateNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{44}
}

func (m *CreateNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNodePoolRequest.Unmarshal(m, b)
}
func (m *CreateNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *CreateNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNodePoolRequest.Merge(m, src)
}
func (m *CreateNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNodePoolRequest.Size(m)
}
func (m *CreateNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CreateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CreateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *CreateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateNodePoolRequest) GetNodePool() *NodePool {
	if m != nil {
		return m.NodePool
	}
	return nil
}

func (m *CreateNodePoolRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// DeleteNodePoolRequest deletes a node pool for a cluster.
type DeleteNodePoolRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool to delete.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster, node pool id) of the node pool to
	// delete. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNodePoolRequest) Reset()         { *m = DeleteNodePoolRequest{} }
func (m *DeleteNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNodePoolRequest) ProtoMessage()    {}
func (*DeleteNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{45}
}

func (m *DeleteNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNodePoolRequest.Unmarshal(m, b)
}
func (m *DeleteNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNodePoolRequest.Merge(m, src)
}
func (m *DeleteNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNodePoolRequest.Size(m)
}
func (m *DeleteNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListNodePoolsRequest lists the node pool(s) for a cluster.
type ListNodePoolsRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The parent (project, location, cluster id) where the node pools will be
	// listed. Specified in the format 'projects/*/locations/*/clusters/*'.
	Parent               string   `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodePoolsRequest) Reset()         { *m = ListNodePoolsRequest{} }
func (m *ListNodePoolsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNodePoolsRequest) ProtoMessage()    {}
func (*ListNodePoolsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{46}
}

func (m *ListNodePoolsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodePoolsRequest.Unmarshal(m, b)
}
func (m *ListNodePoolsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodePoolsRequest.Marshal(b, m, deterministic)
}
func (m *ListNodePoolsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodePoolsRequest.Merge(m, src)
}
func (m *ListNodePoolsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNodePoolsRequest.Size(m)
}
func (m *ListNodePoolsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodePoolsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodePoolsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListNodePoolsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListNodePoolsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListNodePoolsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListNodePoolsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetNodePoolRequest retrieves a node pool for a cluster.
type GetNodePoolRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster, node pool id) of the node pool to
	// get. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNodePoolRequest) Reset()         { *m = GetNodePoolRequest{} }
func (m *GetNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*GetNodePoolRequest) ProtoMessage()    {}
func (*GetNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{47}
}

func (m *GetNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNodePoolRequest.Unmarshal(m, b)
}
func (m *GetNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *GetNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNodePoolRequest.Merge(m, src)
}
func (m *GetNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_GetNodePoolRequest.Size(m)
}
func (m *GetNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *GetNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// NodePool contains the name and configuration for a cluster's node pool.
// Node pools are a set of nodes (i.e. VM's), with a common configuration and
// specification, under the control of the cluster master. They may have a set
// of Kubernetes labels applied to them, which may be used to reference them
// during pod scheduling. They may also be resized up or down, to accommodate
// the workload.
type NodePool struct {
	// The name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The node configuration of the pool.
	Config *NodeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The initial node count for the pool. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The version of the Kubernetes of this node.
	Version string `protobuf:"bytes,101,opt,name=version,proto3" json:"version,omitempty"`
	// [Output only] The resource URLs of the [managed instance
	// groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with this node pool.
	InstanceGroupUrls []string `protobuf:"bytes,102,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"`
	// [Output only] The status of the nodes in this pool instance.
	Status NodePool_Status `protobuf:"varint,103,opt,name=status,proto3,enum=google.container.v1beta1.NodePool_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// node pool instance, if available.
	StatusMessage string `protobuf:"bytes,104,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"` // Deprecated: Do not use.
	// Autoscaler configuration for this NodePool. Autoscaler is enabled
	// only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool.
	MaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,6,opt,name=max_pods_constraint,json=maxPodsConstraint,proto3" json:"max_pods_constraint,omitempty"`
	// Which conditions caused the current node pool state.
	Conditions []*StatusCondition `protobuf:"bytes,105,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// [Output only] The pod CIDR block size per node in this node pool.
	PodIpv4CidrSize      int32    `protobuf:"varint,7,opt,name=pod_ipv4_cidr_size,json=podIpv4CidrSize,proto3" json:"pod_ipv4_cidr_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodePool) Reset()         { *m = NodePool{} }
func (m *NodePool) String() string { return proto.CompactTextString(m) }
func (*NodePool) ProtoMessage()    {}
func (*NodePool) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{48}
}

func (m *NodePool) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodePool.Unmarshal(m, b)
}
func (m *NodePool) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodePool.Marshal(b, m, deterministic)
}
func (m *NodePool) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodePool.Merge(m, src)
}
func (m *NodePool) XXX_Size() int {
	return xxx_messageInfo_NodePool.Size(m)
}
func (m *NodePool) XXX_DiscardUnknown() {
	xxx_messageInfo_NodePool.DiscardUnknown(m)
}

var xxx_messageInfo_NodePool proto.InternalMessageInfo

func (m *NodePool) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodePool) GetConfig() *NodeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NodePool) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *NodePool) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *NodePool) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *NodePool) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *NodePool) GetStatus() NodePool_Status {
	if m != nil {
		return m.Status
	}
	return NodePool_STATUS_UNSPECIFIED
}

// Deprecated: Do not use.
func (m *NodePool) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *NodePool) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *NodePool) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

func (m *NodePool) GetMaxPodsConstraint() *MaxPodsConstraint {
	if m != nil {
		return m.MaxPodsConstraint
	}
	return nil
}

func (m *NodePool) GetConditions() []*StatusCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *NodePool) GetPodIpv4CidrSize() int32 {
	if m != nil {
		return m.PodIpv4CidrSize
	}
	return 0
}

// NodeManagement defines the set of node management services turned on for the
// node pool.
type NodeManagement struct {
	// Whether the nodes will be automatically upgraded.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade,proto3" json:"auto_upgrade,omitempty"`
	// Whether the nodes will be automatically repaired.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
	// Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions       *AutoUpgradeOptions `protobuf:"bytes,10,opt,name=upgrade_options,json=upgradeOptions,proto3" json:"upgrade_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NodeManagement) Reset()         { *m = NodeManagement{} }
func (m *NodeManagement) String() string { return proto.CompactTextString(m) }
func (*NodeManagement) ProtoMessage()    {}
func (*NodeManagement) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{49}
}

func (m *NodeManagement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeManagement.Unmarshal(m, b)
}
func (m *NodeManagement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeManagement.Marshal(b, m, deterministic)
}
func (m *NodeManagement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeManagement.Merge(m, src)
}
func (m *NodeManagement) XXX_Size() int {
	return xxx_messageInfo_NodeManagement.Size(m)
}
func (m *NodeManagement) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeManagement.DiscardUnknown(m)
}

var xxx_messageInfo_NodeManagement proto.InternalMessageInfo

func (m *NodeManagement) GetAutoUpgrade() bool {
	if m != nil {
		return m.AutoUpgrade
	}
	return false
}

func (m *NodeManagement) GetAutoRepair() bool {
	if m != nil {
		return m.AutoRepair
	}
	return false
}

func (m *NodeManagement) GetUpgradeOptions() *AutoUpgradeOptions {
	if m != nil {
		return m.UpgradeOptions
	}
	return nil
}

// AutoUpgradeOptions defines the set of options for the user to control how
// the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	// [Output only] This field is set when upgrades are about to commence
	// with the approximate start time for the upgrades, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `protobuf:"bytes,1,opt,name=auto_upgrade_start_time,json=autoUpgradeStartTime,proto3" json:"auto_upgrade_start_time,omitempty"`
	// [Output only] This field is set when upgrades are about to commence
	// with the description of the upgrade.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoUpgradeOptions) Reset()         { *m = AutoUpgradeOptions{} }
func (m *AutoUpgradeOptions) String() string { return proto.CompactTextString(m) }
func (*AutoUpgradeOptions) ProtoMessage()    {}
func (*AutoUpgradeOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{50}
}

func (m *AutoUpgradeOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoUpgradeOptions.Unmarshal(m, b)
}
func (m *AutoUpgradeOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoUpgradeOptions.Marshal(b, m, deterministic)
}
func (m *AutoUpgradeOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoUpgradeOptions.Merge(m, src)
}
func (m *AutoUpgradeOptions) XXX_Size() int {
	return xxx_messageInfo_AutoUpgradeOptions.Size(m)
}
func (m *AutoUpgradeOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoUpgradeOptions.DiscardUnknown(m)
}

var xxx_messageInfo_AutoUpgradeOptions proto.InternalMessageInfo

func (m *AutoUpgradeOptions) GetAutoUpgradeStartTime() string {
	if m != nil {
		return m.AutoUpgradeStartTime
	}
	return ""
}

func (m *AutoUpgradeOptions) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// MaintenancePolicy defines the maintenance policy to be used for the cluster.
type MaintenancePolicy struct {
	// Specifies the maintenance window in which maintenance may be performed.
	Window *MaintenanceWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// A hash identifying the version of this policy, so that updates to fields of
	// the policy won't accidentally undo intermediate changes (and so that users
	// of the API unaware of some fields won't accidentally remove other fields).
	// Make a <code>get()</code> request to the cluster to get the current
	// resource version and include it with requests to set the policy.
	ResourceVersion      string   `protobuf:"bytes,3,opt,name=resource_version,json=resourceVersion,proto3" json:"resource_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MaintenancePolicy) Reset()         { *m = MaintenancePolicy{} }
func (m *MaintenancePolicy) String() string { return proto.CompactTextString(m) }
func (*MaintenancePolicy) ProtoMessage()    {}
func (*MaintenancePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{51}
}

func (m *MaintenancePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MaintenancePolicy.Unmarshal(m, b)
}
func (m *MaintenancePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MaintenancePolicy.Marshal(b, m, deterministic)
}
func (m *MaintenancePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MaintenancePolicy.Merge(m, src)
}
func (m *MaintenancePolicy) XXX_Size() int {
	return xxx_messageInfo_MaintenancePolicy.Size(m)
}
func (m *MaintenancePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MaintenancePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MaintenancePolicy proto.InternalMessageInfo

func (m *MaintenancePolicy) GetWindow() *MaintenanceWindow {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *MaintenancePolicy) GetResourceVersion() string {
	if m != nil {
		return m.ResourceVersion
	}
	return ""
}

// MaintenanceWindow defines the maintenance window to be used for the cluster.
type MaintenanceWindow struct {
	// Unimplemented, reserved for future use.
	// HourlyMaintenanceWindow hourly_maintenance_window = 1;
	//
	// Types that are valid to be assigned to Policy:
	//	*MaintenanceWindow_DailyMaintenanceWindow
	//	*MaintenanceWindow_RecurringWindow
	Policy isMaintenanceWindow_Policy `protobuf_oneof:"policy"`
	// Exceptions to maintenance window. Non-emergency maintenance should not
	// occur in these windows.
	MaintenanceExclusions map[string]*TimeWindow `protobuf:"bytes,4,rep,name=maintenance_exclusions,json=maintenanceExclusions,proto3" json:"maintenance_exclusions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_unrecognized      []byte                 `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *MaintenanceWindow) Reset()         { *m = MaintenanceWindow{} }
func (m *MaintenanceWindow) String() string { return proto.CompactTextString(m) }
func (*MaintenanceWindow) ProtoMessage()    {}
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{52}
}

func (m *MaintenanceWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MaintenanceWindow.Unmarshal(m, b)
}
func (m *MaintenanceWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MaintenanceWindow.Marshal(b, m, deterministic)
}
func (m *MaintenanceWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MaintenanceWindow.Merge(m, src)
}
func (m *MaintenanceWindow) XXX_Size() int {
	return xxx_messageInfo_MaintenanceWindow.Size(m)
}
func (m *MaintenanceWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_MaintenanceWindow.DiscardUnknown(m)
}

var xxx_messageInfo_MaintenanceWindow proto.InternalMessageInfo

type isMaintenanceWindow_Policy interface {
	isMaintenanceWindow_Policy()
}

type MaintenanceWindow_DailyMaintenanceWindow struct {
	DailyMaintenanceWindow *DailyMaintenanceWindow `protobuf:"bytes,2,opt,name=daily_maintenance_window,json=dailyMaintenanceWindow,proto3,oneof"`
}

type MaintenanceWindow_RecurringWindow struct {
	RecurringWindow *RecurringTimeWindow `protobuf:"bytes,3,opt,name=recurring_window,json=recurringWindow,proto3,oneof"`
}

func (*MaintenanceWindow_DailyMaintenanceWindow) isMaintenanceWindow_Policy() {}

func (*MaintenanceWindow_RecurringWindow) isMaintenanceWindow_Policy() {}

func (m *MaintenanceWindow) GetPolicy() isMaintenanceWindow_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *MaintenanceWindow) GetDailyMaintenanceWindow() *DailyMaintenanceWindow {
	if x, ok := m.GetPolicy().(*MaintenanceWindow_DailyMaintenanceWindow); ok {
		return x.DailyMaintenanceWindow
	}
	return nil
}

func (m *MaintenanceWindow) GetRecurringWindow() *RecurringTimeWindow {
	if x, ok := m.GetPolicy().(*MaintenanceWindow_RecurringWindow); ok {
		return x.RecurringWindow
	}
	return nil
}

func (m *MaintenanceWindow) GetMaintenanceExclusions() map[string]*TimeWindow {
	if m != nil {
		return m.MaintenanceExclusions
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MaintenanceWindow) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MaintenanceWindow_DailyMaintenanceWindow)(nil),
		(*MaintenanceWindow_RecurringWindow)(nil),
	}
}

// Represents an arbitrary window of time.
type TimeWindow struct {
	// The time that the window first starts.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time that the window ends. The end time should take place after the
	// start time.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimeWindow) Reset()         { *m = TimeWindow{} }
func (m *TimeWindow) String() string { return proto.CompactTextString(m) }
func (*TimeWindow) ProtoMessage()    {}
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{53}
}

func (m *TimeWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeWindow.Unmarshal(m, b)
}
func (m *TimeWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeWindow.Marshal(b, m, deterministic)
}
func (m *TimeWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeWindow.Merge(m, src)
}
func (m *TimeWindow) XXX_Size() int {
	return xxx_messageInfo_TimeWindow.Size(m)
}
func (m *TimeWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeWindow.DiscardUnknown(m)
}

var xxx_messageInfo_TimeWindow proto.InternalMessageInfo

func (m *TimeWindow) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimeWindow) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Represents an arbitrary window of time that recurs.
type RecurringTimeWindow struct {
	// The window of the first recurrence.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
	// this window reccurs. They go on for the span of time between the start and
	// end time.
	//
	// For example, to have something repeat every weekday, you'd use:
	//   <code>FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR</code>
	// To repeat some window daily (equivalent to the DailyMaintenanceWindow):
	//   <code>FREQ=DAILY</code>
	// For the first weekend of every month:
	//   <code>FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU</code>
	// This specifies how frequently the window starts. Eg, if you wanted to have
	// a 9-5 UTC-4 window every weekday, you'd use something like:
	// <code>
	//   start time = 2019-01-01T09:00:00-0400
	//   end time = 2019-01-01T17:00:00-0400
	//   recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
	// </code>
	// Windows can span multiple days. Eg, to make the window encompass every
	// weekend from midnight Saturday till the last minute of Sunday UTC:
	// <code>
	//   start time = 2019-01-05T00:00:00Z
	//   end time = 2019-01-07T23:59:00Z
	//   recurrence = FREQ=WEEKLY;BYDAY=SA
	// </code>
	// Note the start and end time's specific dates are largely arbitrary except
	// to specify duration of the window and when it first starts.
	// The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
	Recurrence           string   `protobuf:"bytes,2,opt,name=recurrence,proto3" json:"recurrence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RecurringTimeWindow) Reset()         { *m = RecurringTimeWindow{} }
func (m *RecurringTimeWindow) String() string { return proto.CompactTextString(m) }
func (*RecurringTimeWindow) ProtoMessage()    {}
func (*RecurringTimeWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{54}
}

func (m *RecurringTimeWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecurringTimeWindow.Unmarshal(m, b)
}
func (m *RecurringTimeWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecurringTimeWindow.Marshal(b, m, deterministic)
}
func (m *RecurringTimeWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecurringTimeWindow.Merge(m, src)
}
func (m *RecurringTimeWindow) XXX_Size() int {
	return xxx_messageInfo_RecurringTimeWindow.Size(m)
}
func (m *RecurringTimeWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_RecurringTimeWindow.DiscardUnknown(m)
}

var xxx_messageInfo_RecurringTimeWindow proto.InternalMessageInfo

func (m *RecurringTimeWindow) GetWindow() *TimeWindow {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *RecurringTimeWindow) GetRecurrence() string {
	if m != nil {
		return m.Recurrence
	}
	return ""
}

// Time window specified for daily maintenance operations.
type DailyMaintenanceWindow struct {
	// Time within the maintenance window to start the maintenance operations.
	// It must be in format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
	StartTime string `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// [Output only] Duration of the time window, automatically chosen to be
	// smallest possible in the given scenario.
	Duration             string   `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DailyMaintenanceWindow) Reset()         { *m = DailyMaintenanceWindow{} }
func (m *DailyMaintenanceWindow) String() string { return proto.CompactTextString(m) }
func (*DailyMaintenanceWindow) ProtoMessage()    {}
func (*DailyMaintenanceWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{55}
}

func (m *DailyMaintenanceWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DailyMaintenanceWindow.Unmarshal(m, b)
}
func (m *DailyMaintenanceWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DailyMaintenanceWindow.Marshal(b, m, deterministic)
}
func (m *DailyMaintenanceWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DailyMaintenanceWindow.Merge(m, src)
}
func (m *DailyMaintenanceWindow) XXX_Size() int {
	return xxx_messageInfo_DailyMaintenanceWindow.Size(m)
}
func (m *DailyMaintenanceWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_DailyMaintenanceWindow.DiscardUnknown(m)
}

var xxx_messageInfo_DailyMaintenanceWindow proto.InternalMessageInfo

func (m *DailyMaintenanceWindow) GetStartTime() string {
	if m != nil {
		return m.StartTime
	}
	return ""
}

func (m *DailyMaintenanceWindow) GetDuration() string {
	if m != nil {
		return m.Duration
	}
	return ""
}

// SetNodePoolManagementRequest sets the node management properties of a node
// pool.
type SetNodePoolManagementRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// Required. NodeManagement configuration for the node pool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// management properties. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNodePoolManagementRequest) Reset()         { *m = SetNodePoolManagementRequest{} }
func (m *SetNodePoolManagementRequest) String() string { return proto.CompactTextString(m) }
func (*SetNodePoolManagementRequest) ProtoMessage()    {}
func (*SetNodePoolManagementRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{56}
}

func (m *SetNodePoolManagementRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNodePoolManagementRequest.Unmarshal(m, b)
}
func (m *SetNodePoolManagementRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNodePoolManagementRequest.Marshal(b, m, deterministic)
}
func (m *SetNodePoolManagementRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNodePoolManagementRequest.Merge(m, src)
}
func (m *SetNodePoolManagementRequest) XXX_Size() int {
	return xxx_messageInfo_SetNodePoolManagementRequest.Size(m)
}
func (m *SetNodePoolManagementRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNodePoolManagementRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNodePoolManagementRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

func (m *SetNodePoolManagementRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolSizeRequest sets the size a node
// pool.
type SetNodePoolSizeRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// Required. The desired node count for the pool.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// size.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNodePoolSizeRequest) Reset()         { *m = SetNodePoolSizeRequest{} }
func (m *SetNodePoolSizeRequest) String() string { return proto.CompactTextString(m) }
func (*SetNodePoolSizeRequest) ProtoMessage()    {}
func (*SetNodePoolSizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{57}
}

func (m *SetNodePoolSizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNodePoolSizeRequest.Unmarshal(m, b)
}
func (m *SetNodePoolSizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNodePoolSizeRequest.Marshal(b, m, deterministic)
}
func (m *SetNodePoolSizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNodePoolSizeRequest.Merge(m, src)
}
func (m *SetNodePoolSizeRequest) XXX_Size() int {
	return xxx_messageInfo_SetNodePoolSizeRequest.Size(m)
}
func (m *SetNodePoolSizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNodePoolSizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNodePoolSizeRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolSizeRequest) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *SetNodePoolSizeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
// NodePool upgrade. This will be an no-op if the last upgrade successfully
// completed.
type RollbackNodePoolUpgradeRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to rollback.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the node pool to rollback.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster, node pool id) of the node poll to
	// rollback upgrade.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackNodePoolUpgradeRequest) Reset()         { *m = RollbackNodePoolUpgradeRequest{} }
func (m *RollbackNodePoolUpgradeRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackNodePoolUpgradeRequest) ProtoMessage()    {}
func (*RollbackNodePoolUpgradeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{58}
}

func (m *RollbackNodePoolUpgradeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackNodePoolUpgradeRequest.Unmarshal(m, b)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackNodePoolUpgradeRequest.Marshal(b, m, deterministic)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackNodePoolUpgradeRequest.Merge(m, src)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackNodePoolUpgradeRequest.Size(m)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackNodePoolUpgradeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackNodePoolUpgradeRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListNodePoolsResponse is the result of ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	// A list of node pools for a cluster.
	NodePools            []*NodePool `protobuf:"bytes,1,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ListNodePoolsResponse) Reset()         { *m = ListNodePoolsResponse{} }
func (m *ListNodePoolsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNodePoolsResponse) ProtoMessage()    {}
func (*ListNodePoolsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{59}
}

func (m *ListNodePoolsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodePoolsResponse.Unmarshal(m, b)
}
func (m *ListNodePoolsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodePoolsResponse.Marshal(b, m, deterministic)
}
func (m *ListNodePoolsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodePoolsResponse.Merge(m, src)
}
func (m *ListNodePoolsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNodePoolsResponse.Size(m)
}
func (m *ListNodePoolsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodePoolsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodePoolsResponse proto.InternalMessageInfo

func (m *ListNodePoolsResponse) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

// ClusterAutoscaling contains global, per-cluster information
// required by Cluster Autoscaler to automatically adjust
// the size of the cluster and create/delete
// node pools based on the current needs.
type ClusterAutoscaling struct {
	// Enables automatic node pool creation and deletion.
	EnableNodeAutoprovisioning bool `protobuf:"varint,1,opt,name=enable_node_autoprovisioning,json=enableNodeAutoprovisioning,proto3" json:"enable_node_autoprovisioning,omitempty"`
	// Contains global constraints regarding minimum and maximum
	// amount of resources in the cluster.
	ResourceLimits []*ResourceLimit `protobuf:"bytes,2,rep,name=resource_limits,json=resourceLimits,proto3" json:"resource_limits,omitempty"`
	// AutoprovisioningNodePoolDefaults contains defaults for a node pool
	// created by NAP.
	AutoprovisioningNodePoolDefaults *AutoprovisioningNodePoolDefaults `protobuf:"bytes,4,opt,name=autoprovisioning_node_pool_defaults,json=autoprovisioningNodePoolDefaults,proto3" json:"autoprovisioning_node_pool_defaults,omitempty"`
	// The list of Google Compute Engine [zones](/compute/docs/zones#available)
	// in which the NodePool's nodes can be created by NAP.
	AutoprovisioningLocations []string `protobuf:"bytes,5,rep,name=autoprovisioning_locations,json=autoprovisioningLocations,proto3" json:"autoprovisioning_locations,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *ClusterAutoscaling) Reset()         { *m = ClusterAutoscaling{} }
func (m *ClusterAutoscaling) String() string { return proto.CompactTextString(m) }
func (*ClusterAutoscaling) ProtoMessage()    {}
func (*ClusterAutoscaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{60}
}

func (m *ClusterAutoscaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterAutoscaling.Unmarshal(m, b)
}
func (m *ClusterAutoscaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterAutoscaling.Marshal(b, m, deterministic)
}
func (m *ClusterAutoscaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterAutoscaling.Merge(m, src)
}
func (m *ClusterAutoscaling) XXX_Size() int {
	return xxx_messageInfo_ClusterAutoscaling.Size(m)
}
func (m *ClusterAutoscaling) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterAutoscaling.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterAutoscaling proto.InternalMessageInfo

func (m *ClusterAutoscaling) GetEnableNodeAutoprovisioning() bool {
	if m != nil {
		return m.EnableNodeAutoprovisioning
	}
	return false
}

func (m *ClusterAutoscaling) GetResourceLimits() []*ResourceLimit {
	if m != nil {
		return m.ResourceLimits
	}
	return nil
}

func (m *ClusterAutoscaling) GetAutoprovisioningNodePoolDefaults() *AutoprovisioningNodePoolDefaults {
	if m != nil {
		return m.AutoprovisioningNodePoolDefaults
	}
	return nil
}

func (m *ClusterAutoscaling) GetAutoprovisioningLocations() []string {
	if m != nil {
		return m.AutoprovisioningLocations
	}
	return nil
}

// AutoprovisioningNodePoolDefaults contains defaults for a node pool created
// by NAP.
type AutoprovisioningNodePoolDefaults struct {
	// Scopes that are used by NAP when creating node pools. If oauth_scopes are
	// specified, service_account should be empty.
	OauthScopes []string `protobuf:"bytes,1,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs. If
	// service_account is specified, scopes should be empty.
	ServiceAccount       string   `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoprovisioningNodePoolDefaults) Reset()         { *m = AutoprovisioningNodePoolDefaults{} }
func (m *AutoprovisioningNodePoolDefaults) String() string { return proto.CompactTextString(m) }
func (*AutoprovisioningNodePoolDefaults) ProtoMessage()    {}
func (*AutoprovisioningNodePoolDefaults) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{61}
}

func (m *AutoprovisioningNodePoolDefaults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoprovisioningNodePoolDefaults.Unmarshal(m, b)
}
func (m *AutoprovisioningNodePoolDefaults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoprovisioningNodePoolDefaults.Marshal(b, m, deterministic)
}
func (m *AutoprovisioningNodePoolDefaults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoprovisioningNodePoolDefaults.Merge(m, src)
}
func (m *AutoprovisioningNodePoolDefaults) XXX_Size() int {
	return xxx_messageInfo_AutoprovisioningNodePoolDefaults.Size(m)
}
func (m *AutoprovisioningNodePoolDefaults) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoprovisioningNodePoolDefaults.DiscardUnknown(m)
}

var xxx_messageInfo_AutoprovisioningNodePoolDefaults proto.InternalMessageInfo

func (m *AutoprovisioningNodePoolDefaults) GetOauthScopes() []string {
	if m != nil {
		return m.OauthScopes
	}
	return nil
}

func (m *AutoprovisioningNodePoolDefaults) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

// Contains information about amount of some resource in the cluster.
// For memory, value should be in GB.
type ResourceLimit struct {
	// Resource name "cpu", "memory" or gpu-specific string.
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Minimum amount of the resource in the cluster.
	Minimum int64 `protobuf:"varint,2,opt,name=minimum,proto3" json:"minimum,omitempty"`
	// Maximum amount of the resource in the cluster.
	Maximum              int64    `protobuf:"varint,3,opt,name=maximum,proto3" json:"maximum,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceLimit) Reset()         { *m = ResourceLimit{} }
func (m *ResourceLimit) String() string { return proto.CompactTextString(m) }
func (*ResourceLimit) ProtoMessage()    {}
func (*ResourceLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{62}
}

func (m *ResourceLimit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceLimit.Unmarshal(m, b)
}
func (m *ResourceLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceLimit.Marshal(b, m, deterministic)
}
func (m *ResourceLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceLimit.Merge(m, src)
}
func (m *ResourceLimit) XXX_Size() int {
	return xxx_messageInfo_ResourceLimit.Size(m)
}
func (m *ResourceLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceLimit.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceLimit proto.InternalMessageInfo

func (m *ResourceLimit) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *ResourceLimit) GetMinimum() int64 {
	if m != nil {
		return m.Minimum
	}
	return 0
}

func (m *ResourceLimit) GetMaximum() int64 {
	if m != nil {
		return m.Maximum
	}
	return 0
}

// NodePoolAutoscaling contains information required by cluster autoscaler to
// adjust the size of the node pool to the current cluster usage.
type NodePoolAutoscaling struct {
	// Is autoscaling enabled for this node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Minimum number of nodes in the NodePool. Must be >= 1 and <=
	// max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Maximum number of nodes in the NodePool. Must be >= min_node_count. There
	// has to enough quota to scale up the cluster.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
	// Can this node pool be deleted automatically.
	Autoprovisioned      bool     `protobuf:"varint,4,opt,name=autoprovisioned,proto3" json:"autoprovisioned,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodePoolAutoscaling) Reset()         { *m = NodePoolAutoscaling{} }
func (m *NodePoolAutoscaling) String() string { return proto.CompactTextString(m) }
func (*NodePoolAutoscaling) ProtoMessage()    {}
func (*NodePoolAutoscaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{63}
}

func (m *NodePoolAutoscaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodePoolAutoscaling.Unmarshal(m, b)
}
func (m *NodePoolAutoscaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodePoolAutoscaling.Marshal(b, m, deterministic)
}
func (m *NodePoolAutoscaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodePoolAutoscaling.Merge(m, src)
}
func (m *NodePoolAutoscaling) XXX_Size() int {
	return xxx_messageInfo_NodePoolAutoscaling.Size(m)
}
func (m *NodePoolAutoscaling) XXX_DiscardUnknown() {
	xxx_messageInfo_NodePoolAutoscaling.DiscardUnknown(m)
}

var xxx_messageInfo_NodePoolAutoscaling proto.InternalMessageInfo

func (m *NodePoolAutoscaling) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *NodePoolAutoscaling) GetMinNodeCount() int32 {
	if m != nil {
		return m.MinNodeCount
	}
	return 0
}

func (m *NodePoolAutoscaling) GetMaxNodeCount() int32 {
	if m != nil {
		return m.MaxNodeCount
	}
	return 0
}

func (m *NodePoolAutoscaling) GetAutoprovisioned() bool {
	if m != nil {
		return m.Autoprovisioned
	}
	return false
}

// SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
// Engine cluster, which will in turn set them for Google Compute Engine
// resources used by that cluster
type SetLabelsRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. The labels to set for that cluster.
	ResourceLabels map[string]string `protobuf:"bytes,4,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The fingerprint of the previous set of labels for this resource,
	// used to detect conflicts. The fingerprint is initially generated by
	// Kubernetes Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a <code>get()</code> request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `protobuf:"bytes,5,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// The name (project, location, cluster id) of the cluster to set labels.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLabelsRequest) Reset()         { *m = SetLabelsRequest{} }
func (m *SetLabelsRequest) String() string { return proto.CompactTextString(m) }
func (*SetLabelsRequest) ProtoMessage()    {}
func (*SetLabelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{64}
}

func (m *SetLabelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLabelsRequest.Unmarshal(m, b)
}
func (m *SetLabelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLabelsRequest.Marshal(b, m, deterministic)
}
func (m *SetLabelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLabelsRequest.Merge(m, src)
}
func (m *SetLabelsRequest) XXX_Size() int {
	return xxx_messageInfo_SetLabelsRequest.Size(m)
}
func (m *SetLabelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLabelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLabelsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLabelsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLabelsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLabelsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLabelsRequest) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *SetLabelsRequest) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

func (m *SetLabelsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
// a cluster.
type SetLegacyAbacRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Whether ABAC authorization will be enabled in the cluster.
	Enabled bool `protobuf:"varint,4,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name (project, location, cluster id) of the cluster to set legacy abac.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLegacyAbacRequest) Reset()         { *m = SetLegacyAbacRequest{} }
func (m *SetLegacyAbacRequest) String() string { return proto.CompactTextString(m) }
func (*SetLegacyAbacRequest) ProtoMessage()    {}
func (*SetLegacyAbacRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{65}
}

func (m *SetLegacyAbacRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLegacyAbacRequest.Unmarshal(m, b)
}
func (m *SetLegacyAbacRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLegacyAbacRequest.Marshal(b, m, deterministic)
}
func (m *SetLegacyAbacRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLegacyAbacRequest.Merge(m, src)
}
func (m *SetLegacyAbacRequest) XXX_Size() int {
	return xxx_messageInfo_SetLegacyAbacRequest.Size(m)
}
func (m *SetLegacyAbacRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLegacyAbacRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLegacyAbacRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLegacyAbacRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLegacyAbacRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLegacyAbacRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *SetLegacyAbacRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// StartIPRotationRequest creates a new IP for the cluster and then performs
// a node upgrade on each node pool to point to the new IP.
type StartIPRotationRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster id) of the cluster to start IP
	// rotation. Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to rotate credentials during IP rotation.
	RotateCredentials    bool     `protobuf:"varint,7,opt,name=rotate_credentials,json=rotateCredentials,proto3" json:"rotate_credentials,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartIPRotationRequest) Reset()         { *m = StartIPRotationRequest{} }
func (m *StartIPRotationRequest) String() string { return proto.CompactTextString(m) }
func (*StartIPRotationRequest) ProtoMessage()    {}
func (*StartIPRotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{66}
}

func (m *StartIPRotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartIPRotationRequest.Unmarshal(m, b)
}
func (m *StartIPRotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartIPRotationRequest.Marshal(b, m, deterministic)
}
func (m *StartIPRotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartIPRotationRequest.Merge(m, src)
}
func (m *StartIPRotationRequest) XXX_Size() int {
	return xxx_messageInfo_StartIPRotationRequest.Size(m)
}
func (m *StartIPRotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartIPRotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartIPRotationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *StartIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *StartIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *StartIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StartIPRotationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *StartIPRotationRequest) GetRotateCredentials() bool {
	if m != nil {
		return m.RotateCredentials
	}
	return false
}

// CompleteIPRotationRequest moves the cluster master back into single-IP mode.
type CompleteIPRotationRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster id) of the cluster to complete IP
	// rotation. Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompleteIPRotationRequest) Reset()         { *m = CompleteIPRotationRequest{} }
func (m *CompleteIPRotationRequest) String() string { return proto.CompactTextString(m) }
func (*CompleteIPRotationRequest) ProtoMessage()    {}
func (*CompleteIPRotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{67}
}

func (m *CompleteIPRotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteIPRotationRequest.Unmarshal(m, b)
}
func (m *CompleteIPRotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteIPRotationRequest.Marshal(b, m, deterministic)
}
func (m *CompleteIPRotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteIPRotationRequest.Merge(m, src)
}
func (m *CompleteIPRotationRequest) XXX_Size() int {
	return xxx_messageInfo_CompleteIPRotationRequest.Size(m)
}
func (m *CompleteIPRotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteIPRotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteIPRotationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CompleteIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CompleteIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *CompleteIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// AcceleratorConfig represents a Hardware Accelerator request.
type AcceleratorConfig struct {
	// The number of the accelerator cards exposed to an instance.
	AcceleratorCount int64 `protobuf:"varint,1,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
	// The accelerator type resource name. List of supported accelerators
	// [here](/compute/docs/gpus)
	AcceleratorType      string   `protobuf:"bytes,2,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceleratorConfig) Reset()         { *m = AcceleratorConfig{} }
func (m *AcceleratorConfig) String() string { return proto.CompactTextString(m) }
func (*AcceleratorConfig) ProtoMessage()    {}
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{68}
}

func (m *AcceleratorConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceleratorConfig.Unmarshal(m, b)
}
func (m *AcceleratorConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceleratorConfig.Marshal(b, m, deterministic)
}
func (m *AcceleratorConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceleratorConfig.Merge(m, src)
}
func (m *AcceleratorConfig) XXX_Size() int {
	return xxx_messageInfo_AcceleratorConfig.Size(m)
}
func (m *AcceleratorConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceleratorConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AcceleratorConfig proto.InternalMessageInfo

func (m *AcceleratorConfig) GetAcceleratorCount() int64 {
	if m != nil {
		return m.AcceleratorCount
	}
	return 0
}

func (m *AcceleratorConfig) GetAcceleratorType() string {
	if m != nil {
		return m.AcceleratorType
	}
	return ""
}

// WorkloadMetadataConfig defines the metadata configuration to expose to
// workloads on the node pool.
type WorkloadMetadataConfig struct {
	// NodeMetadata is the configuration for how to expose metadata to the
	// workloads running on the node.
	NodeMetadata         WorkloadMetadataConfig_NodeMetadata `protobuf:"varint,1,opt,name=node_metadata,json=nodeMetadata,proto3,enum=google.container.v1beta1.WorkloadMetadataConfig_NodeMetadata" json:"node_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *WorkloadMetadataConfig) Reset()         { *m = WorkloadMetadataConfig{} }
func (m *WorkloadMetadataConfig) String() string { return proto.CompactTextString(m) }
func (*WorkloadMetadataConfig) ProtoMessage()    {}
func (*WorkloadMetadataConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{69}
}

func (m *WorkloadMetadataConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkloadMetadataConfig.Unmarshal(m, b)
}
func (m *WorkloadMetadataConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkloadMetadataConfig.Marshal(b, m, deterministic)
}
func (m *WorkloadMetadataConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkloadMetadataConfig.Merge(m, src)
}
func (m *WorkloadMetadataConfig) XXX_Size() int {
	return xxx_messageInfo_WorkloadMetadataConfig.Size(m)
}
func (m *WorkloadMetadataConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkloadMetadataConfig.DiscardUnknown(m)
}

var xxx_messageInfo_WorkloadMetadataConfig proto.InternalMessageInfo

func (m *WorkloadMetadataConfig) GetNodeMetadata() WorkloadMetadataConfig_NodeMetadata {
	if m != nil {
		return m.NodeMetadata
	}
	return WorkloadMetadataConfig_UNSPECIFIED
}

// SetNetworkPolicyRequest enables/disables network policy for a cluster.
type SetNetworkPolicyRequest struct {
	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Required. Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,4,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set networking
	// policy. Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNetworkPolicyRequest) Reset()         { *m = SetNetworkPolicyRequest{} }
func (m *SetNetworkPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*SetNetworkPolicyRequest) ProtoMessage()    {}
func (*SetNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{70}
}

func (m *SetNetworkPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNetworkPolicyRequest.Unmarshal(m, b)
}
func (m *SetNetworkPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNetworkPolicyRequest.Marshal(b, m, deterministic)
}
func (m *SetNetworkPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNetworkPolicyRequest.Merge(m, src)
}
func (m *SetNetworkPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_SetNetworkPolicyRequest.Size(m)
}
func (m *SetNetworkPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNetworkPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNetworkPolicyRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNetworkPolicyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNetworkPolicyRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNetworkPolicyRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *SetNetworkPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMaintenancePolicyRequest sets the maintenance policy for a cluster.
type SetMaintenancePolicyRequest struct {
	// Required. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The maintenance policy to be set for the cluster. An empty field
	// clears the existing maintenance policy.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,4,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set maintenance
	// policy.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMaintenancePolicyRequest) Reset()         { *m = SetMaintenancePolicyRequest{} }
func (m *SetMaintenancePolicyRequest) String() string { return proto.CompactTextString(m) }
func (*SetMaintenancePolicyRequest) ProtoMessage()    {}
func (*SetMaintenancePolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{71}
}

func (m *SetMaintenancePolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMaintenancePolicyRequest.Unmarshal(m, b)
}
func (m *SetMaintenancePolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMaintenancePolicyRequest.Marshal(b, m, deterministic)
}
func (m *SetMaintenancePolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMaintenancePolicyRequest.Merge(m, src)
}
func (m *SetMaintenancePolicyRequest) XXX_Size() int {
	return xxx_messageInfo_SetMaintenancePolicyRequest.Size(m)
}
func (m *SetMaintenancePolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMaintenancePolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMaintenancePolicyRequest proto.InternalMessageInfo

func (m *SetMaintenancePolicyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetMaintenancePolicy() *MaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *SetMaintenancePolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListLocationsRequest is used to request the locations that offer GKE.
type ListLocationsRequest struct {
	// Required. Contains the name of the resource requested.
	// Specified in the format 'projects/*'.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLocationsRequest) Reset()         { *m = ListLocationsRequest{} }
func (m *ListLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListLocationsRequest) ProtoMessage()    {}
func (*ListLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{72}
}

func (m *ListLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLocationsRequest.Unmarshal(m, b)
}
func (m *ListLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLocationsRequest.Marshal(b, m, deterministic)
}
func (m *ListLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLocationsRequest.Merge(m, src)
}
func (m *ListLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListLocationsRequest.Size(m)
}
func (m *ListLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListLocationsRequest proto.InternalMessageInfo

func (m *ListLocationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// ListLocationsResponse returns the list of all GKE locations and their
// recommendation state.
type ListLocationsResponse struct {
	// A full list of GKE locations.
	Locations []*Location `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	// Only return ListLocationsResponse that occur after the page_token. This
	// value should be populated from the ListLocationsResponse.next_page_token if
	// that response token was set (which happens when listing more Locations than
	// fit in a single ListLocationsResponse).
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLocationsResponse) Reset()         { *m = ListLocationsResponse{} }
func (m *ListLocationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListLocationsResponse) ProtoMessage()    {}
func (*ListLocationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{73}
}

func (m *ListLocationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLocationsResponse.Unmarshal(m, b)
}
func (m *ListLocationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLocationsResponse.Marshal(b, m, deterministic)
}
func (m *ListLocationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLocationsResponse.Merge(m, src)
}
func (m *ListLocationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListLocationsResponse.Size(m)
}
func (m *ListLocationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLocationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListLocationsResponse proto.InternalMessageInfo

func (m *ListLocationsResponse) GetLocations() []*Location {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *ListLocationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Location returns the location name, and if the location is recommended
// for GKE cluster scheduling.
type Location struct {
	// Contains the type of location this Location is for.
	// Regional or Zonal.
	Type Location_LocationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.container.v1beta1.Location_LocationType" json:"type,omitempty"`
	// Contains the name of the resource requested.
	// Specified in the format 'projects/*/locations/*'.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Whether the location is recomended for GKE cluster scheduling.
	Recommended          bool     `protobuf:"varint,3,opt,name=recommended,proto3" json:"recommended,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Location) Reset()         { *m = Location{} }
func (m *Location) String() string { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()    {}
func (*Location) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{74}
}

func (m *Location) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Location.Unmarshal(m, b)
}
func (m *Location) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Location.Marshal(b, m, deterministic)
}
func (m *Location) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Location.Merge(m, src)
}
func (m *Location) XXX_Size() int {
	return xxx_messageInfo_Location.Size(m)
}
func (m *Location) XXX_DiscardUnknown() {
	xxx_messageInfo_Location.DiscardUnknown(m)
}

var xxx_messageInfo_Location proto.InternalMessageInfo

func (m *Location) GetType() Location_LocationType {
	if m != nil {
		return m.Type
	}
	return Location_LOCATION_TYPE_UNSPECIFIED
}

func (m *Location) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Location) GetRecommended() bool {
	if m != nil {
		return m.Recommended
	}
	return false
}

// StatusCondition describes why a cluster or a node pool has a certain status
// (e.g., ERROR or DEGRADED).
type StatusCondition struct {
	// Machine-friendly representation of the condition
	Code StatusCondition_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.container.v1beta1.StatusCondition_Code" json:"code,omitempty"`
	// Human-friendly representation of the condition
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatusCondition) Reset()         { *m = StatusCondition{} }
func (m *StatusCondition) String() string { return proto.CompactTextString(m) }
func (*StatusCondition) ProtoMessage()    {}
func (*StatusCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{75}
}

func (m *StatusCondition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCondition.Unmarshal(m, b)
}
func (m *StatusCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCondition.Marshal(b, m, deterministic)
}
func (m *StatusCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCondition.Merge(m, src)
}
func (m *StatusCondition) XXX_Size() int {
	return xxx_messageInfo_StatusCondition.Size(m)
}
func (m *StatusCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCondition.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCondition proto.InternalMessageInfo

func (m *StatusCondition) GetCode() StatusCondition_Code {
	if m != nil {
		return m.Code
	}
	return StatusCondition_UNKNOWN
}

func (m *StatusCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// NetworkConfig reports the relative names of network & subnetwork.
type NetworkConfig struct {
	// Output only. The relative name of the Google Compute Engine
	// [network][google.container.v1beta1.NetworkConfig.network](/compute/docs/networks-and-firewalls#networks) to which
	// the cluster is connected.
	// Example: projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The relative name of the Google Compute Engine
	// [subnetwork](/compute/docs/vpc) to which the cluster is connected.
	// Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Whether Intra-node visibility is enabled for this cluster.
	// This makes same node pod to pod traffic visible for VPC network.
	EnableIntraNodeVisibility bool     `protobuf:"varint,5,opt,name=enable_intra_node_visibility,json=enableIntraNodeVisibility,proto3" json:"enable_intra_node_visibility,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *NetworkConfig) Reset()         { *m = NetworkConfig{} }
func (m *NetworkConfig) String() string { return proto.CompactTextString(m) }
func (*NetworkConfig) ProtoMessage()    {}
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{76}
}

func (m *NetworkConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkConfig.Unmarshal(m, b)
}
func (m *NetworkConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkConfig.Marshal(b, m, deterministic)
}
func (m *NetworkConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkConfig.Merge(m, src)
}
func (m *NetworkConfig) XXX_Size() int {
	return xxx_messageInfo_NetworkConfig.Size(m)
}
func (m *NetworkConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkConfig proto.InternalMessageInfo

func (m *NetworkConfig) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *NetworkConfig) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func (m *NetworkConfig) GetEnableIntraNodeVisibility() bool {
	if m != nil {
		return m.EnableIntraNodeVisibility
	}
	return false
}

// ListUsableSubnetworksRequest requests the list of usable subnetworks.
// available to a user for creating clusters.
type ListUsableSubnetworksRequest struct {
	// Required. The parent project where subnetworks are usable.
	// Specified in the format 'projects/*'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filtering currently only supports equality on the networkProjectId and must
	// be in the form: "networkProjectId=[PROJECTID]", where `networkProjectId`
	// is the project which owns the listed subnetworks. This defaults to the
	// parent project ID.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The max number of results per page that should be returned. If the number
	// of available results is larger than `page_size`, a `next_page_token` is
	// returned which can be used to get the next page of results in subsequent
	// requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set this to the nextPageToken returned by
	// previous list requests to get the next page of results.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsableSubnetworksRequest) Reset()         { *m = ListUsableSubnetworksRequest{} }
func (m *ListUsableSubnetworksRequest) String() string { return proto.CompactTextString(m) }
func (*ListUsableSubnetworksRequest) ProtoMessage()    {}
func (*ListUsableSubnetworksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{77}
}

func (m *ListUsableSubnetworksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUsableSubnetworksRequest.Unmarshal(m, b)
}
func (m *ListUsableSubnetworksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUsableSubnetworksRequest.Marshal(b, m, deterministic)
}
func (m *ListUsableSubnetworksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsableSubnetworksRequest.Merge(m, src)
}
func (m *ListUsableSubnetworksRequest) XXX_Size() int {
	return xxx_messageInfo_ListUsableSubnetworksRequest.Size(m)
}
func (m *ListUsableSubnetworksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsableSubnetworksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsableSubnetworksRequest proto.InternalMessageInfo

func (m *ListUsableSubnetworksRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListUsableSubnetworksRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListUsableSubnetworksRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListUsableSubnetworksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// ListUsableSubnetworksResponse is the response of
// ListUsableSubnetworksRequest.
type ListUsableSubnetworksResponse struct {
	// A list of usable subnetworks in the specified network project.
	Subnetworks []*UsableSubnetwork `protobuf:"bytes,1,rep,name=subnetworks,proto3" json:"subnetworks,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `page_size`, use the
	// `next_page_token` as a value for the query parameter `page_token` in the
	// next request. The value will become empty when there are no more pages.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsableSubnetworksResponse) Reset()         { *m = ListUsableSubnetworksResponse{} }
func (m *ListUsableSubnetworksResponse) String() string { return proto.CompactTextString(m) }
func (*ListUsableSubnetworksResponse) ProtoMessage()    {}
func (*ListUsableSubnetworksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{78}
}

func (m *ListUsableSubnetworksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUsableSubnetworksResponse.Unmarshal(m, b)
}
func (m *ListUsableSubnetworksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUsableSubnetworksResponse.Marshal(b, m, deterministic)
}
func (m *ListUsableSubnetworksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsableSubnetworksResponse.Merge(m, src)
}
func (m *ListUsableSubnetworksResponse) XXX_Size() int {
	return xxx_messageInfo_ListUsableSubnetworksResponse.Size(m)
}
func (m *ListUsableSubnetworksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsableSubnetworksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsableSubnetworksResponse proto.InternalMessageInfo

func (m *ListUsableSubnetworksResponse) GetSubnetworks() []*UsableSubnetwork {
	if m != nil {
		return m.Subnetworks
	}
	return nil
}

func (m *ListUsableSubnetworksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Secondary IP range of a usable subnetwork.
type UsableSubnetworkSecondaryRange struct {
	// The name associated with this subnetwork secondary range, used when adding
	// an alias IP range to a VM instance.
	RangeName string `protobuf:"bytes,1,opt,name=range_name,json=rangeName,proto3" json:"range_name,omitempty"`
	// The range of IP addresses belonging to this subnetwork secondary range.
	IpCidrRange string `protobuf:"bytes,2,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// This field is to determine the status of the secondary range programmably.
	Status               UsableSubnetworkSecondaryRange_Status `protobuf:"varint,3,opt,name=status,proto3,enum=google.container.v1beta1.UsableSubnetworkSecondaryRange_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *UsableSubnetworkSecondaryRange) Reset()         { *m = UsableSubnetworkSecondaryRange{} }
func (m *UsableSubnetworkSecondaryRange) String() string { return proto.CompactTextString(m) }
func (*UsableSubnetworkSecondaryRange) ProtoMessage()    {}
func (*UsableSubnetworkSecondaryRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{79}
}

func (m *UsableSubnetworkSecondaryRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UsableSubnetworkSecondaryRange.Unmarshal(m, b)
}
func (m *UsableSubnetworkSecondaryRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UsableSubnetworkSecondaryRange.Marshal(b, m, deterministic)
}
func (m *UsableSubnetworkSecondaryRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsableSubnetworkSecondaryRange.Merge(m, src)
}
func (m *UsableSubnetworkSecondaryRange) XXX_Size() int {
	return xxx_messageInfo_UsableSubnetworkSecondaryRange.Size(m)
}
func (m *UsableSubnetworkSecondaryRange) XXX_DiscardUnknown() {
	xxx_messageInfo_UsableSubnetworkSecondaryRange.DiscardUnknown(m)
}

var xxx_messageInfo_UsableSubnetworkSecondaryRange proto.InternalMessageInfo

func (m *UsableSubnetworkSecondaryRange) GetRangeName() string {
	if m != nil {
		return m.RangeName
	}
	return ""
}

func (m *UsableSubnetworkSecondaryRange) GetIpCidrRange() string {
	if m != nil {
		return m.IpCidrRange
	}
	return ""
}

func (m *UsableSubnetworkSecondaryRange) GetStatus() UsableSubnetworkSecondaryRange_Status {
	if m != nil {
		return m.Status
	}
	return UsableSubnetworkSecondaryRange_UNKNOWN
}

// UsableSubnetwork resource returns the subnetwork name, its associated network
// and the primary CIDR range.
type UsableSubnetwork struct {
	// Subnetwork Name.
	// Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `protobuf:"bytes,1,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Network Name.
	// Example: projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// The range of internal addresses that are owned by this subnetwork.
	IpCidrRange string `protobuf:"bytes,3,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// Secondary IP ranges.
	SecondaryIpRanges []*UsableSubnetworkSecondaryRange `protobuf:"bytes,4,rep,name=secondary_ip_ranges,json=secondaryIpRanges,proto3" json:"secondary_ip_ranges,omitempty"`
	// A human readable status message representing the reasons for cases where
	// the caller cannot use the secondary ranges under the subnet. For example if
	// the secondary_ip_ranges is empty due to a permission issue, an insufficient
	// permission message will be given by status_message.
	StatusMessage        string   `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UsableSubnetwork) Reset()         { *m = UsableSubnetwork{} }
func (m *UsableSubnetwork) String() string { return proto.CompactTextString(m) }
func (*UsableSubnetwork) ProtoMessage()    {}
func (*UsableSubnetwork) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{80}
}

func (m *UsableSubnetwork) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UsableSubnetwork.Unmarshal(m, b)
}
func (m *UsableSubnetwork) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UsableSubnetwork.Marshal(b, m, deterministic)
}
func (m *UsableSubnetwork) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsableSubnetwork.Merge(m, src)
}
func (m *UsableSubnetwork) XXX_Size() int {
	return xxx_messageInfo_UsableSubnetwork.Size(m)
}
func (m *UsableSubnetwork) XXX_DiscardUnknown() {
	xxx_messageInfo_UsableSubnetwork.DiscardUnknown(m)
}

var xxx_messageInfo_UsableSubnetwork proto.InternalMessageInfo

func (m *UsableSubnetwork) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func (m *UsableSubnetwork) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *UsableSubnetwork) GetIpCidrRange() string {
	if m != nil {
		return m.IpCidrRange
	}
	return ""
}

func (m *UsableSubnetwork) GetSecondaryIpRanges() []*UsableSubnetworkSecondaryRange {
	if m != nil {
		return m.SecondaryIpRanges
	}
	return nil
}

func (m *UsableSubnetwork) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

// VerticalPodAutoscaling contains global, per-cluster information
// required by Vertical Pod Autoscaler to automatically adjust
// the resources of pods controlled by it.
type VerticalPodAutoscaling struct {
	// Enables vertical pod autoscaling.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VerticalPodAutoscaling) Reset()         { *m = VerticalPodAutoscaling{} }
func (m *VerticalPodAutoscaling) String() string { return proto.CompactTextString(m) }
func (*VerticalPodAutoscaling) ProtoMessage()    {}
func (*VerticalPodAutoscaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{81}
}

func (m *VerticalPodAutoscaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VerticalPodAutoscaling.Unmarshal(m, b)
}
func (m *VerticalPodAutoscaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VerticalPodAutoscaling.Marshal(b, m, deterministic)
}
func (m *VerticalPodAutoscaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerticalPodAutoscaling.Merge(m, src)
}
func (m *VerticalPodAutoscaling) XXX_Size() int {
	return xxx_messageInfo_VerticalPodAutoscaling.Size(m)
}
func (m *VerticalPodAutoscaling) XXX_DiscardUnknown() {
	xxx_messageInfo_VerticalPodAutoscaling.DiscardUnknown(m)
}

var xxx_messageInfo_VerticalPodAutoscaling proto.InternalMessageInfo

func (m *VerticalPodAutoscaling) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// IntraNodeVisibilityConfig contains the desired config of the intra-node
// visibility on this cluster.
type IntraNodeVisibilityConfig struct {
	// Enables intra node visibility for this cluster.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntraNodeVisibilityConfig) Reset()         { *m = IntraNodeVisibilityConfig{} }
func (m *IntraNodeVisibilityConfig) String() string { return proto.CompactTextString(m) }
func (*IntraNodeVisibilityConfig) ProtoMessage()    {}
func (*IntraNodeVisibilityConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{82}
}

func (m *IntraNodeVisibilityConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntraNodeVisibilityConfig.Unmarshal(m, b)
}
func (m *IntraNodeVisibilityConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntraNodeVisibilityConfig.Marshal(b, m, deterministic)
}
func (m *IntraNodeVisibilityConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntraNodeVisibilityConfig.Merge(m, src)
}
func (m *IntraNodeVisibilityConfig) XXX_Size() int {
	return xxx_messageInfo_IntraNodeVisibilityConfig.Size(m)
}
func (m *IntraNodeVisibilityConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_IntraNodeVisibilityConfig.DiscardUnknown(m)
}

var xxx_messageInfo_IntraNodeVisibilityConfig proto.InternalMessageInfo

func (m *IntraNodeVisibilityConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Constraints applied to pods.
type MaxPodsConstraint struct {
	// Constraint enforced on the max num of pods per node.
	MaxPodsPerNode       int64    `protobuf:"varint,1,opt,name=max_pods_per_node,json=maxPodsPerNode,proto3" json:"max_pods_per_node,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MaxPodsConstraint) Reset()         { *m = MaxPodsConstraint{} }
func (m *MaxPodsConstraint) String() string { return proto.CompactTextString(m) }
func (*MaxPodsConstraint) ProtoMessage()    {}
func (*MaxPodsConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{83}
}

func (m *MaxPodsConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MaxPodsConstraint.Unmarshal(m, b)
}
func (m *MaxPodsConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MaxPodsConstraint.Marshal(b, m, deterministic)
}
func (m *MaxPodsConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MaxPodsConstraint.Merge(m, src)
}
func (m *MaxPodsConstraint) XXX_Size() int {
	return xxx_messageInfo_MaxPodsConstraint.Size(m)
}
func (m *MaxPodsConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_MaxPodsConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_MaxPodsConstraint proto.InternalMessageInfo

func (m *MaxPodsConstraint) GetMaxPodsPerNode() int64 {
	if m != nil {
		return m.MaxPodsPerNode
	}
	return 0
}

// Configuration of etcd encryption.
type DatabaseEncryption struct {
	// Denotes the state of etcd encryption.
	State DatabaseEncryption_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.container.v1beta1.DatabaseEncryption_State" json:"state,omitempty"`
	// Name of CloudKMS key to use for the encryption of secrets in etcd.
	// Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
	KeyName              string   `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatabaseEncryption) Reset()         { *m = DatabaseEncryption{} }
func (m *DatabaseEncryption) String() string { return proto.CompactTextString(m) }
func (*DatabaseEncryption) ProtoMessage()    {}
func (*DatabaseEncryption) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{84}
}

func (m *DatabaseEncryption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatabaseEncryption.Unmarshal(m, b)
}
func (m *DatabaseEncryption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatabaseEncryption.Marshal(b, m, deterministic)
}
func (m *DatabaseEncryption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatabaseEncryption.Merge(m, src)
}
func (m *DatabaseEncryption) XXX_Size() int {
	return xxx_messageInfo_DatabaseEncryption.Size(m)
}
func (m *DatabaseEncryption) XXX_DiscardUnknown() {
	xxx_messageInfo_DatabaseEncryption.DiscardUnknown(m)
}

var xxx_messageInfo_DatabaseEncryption proto.InternalMessageInfo

func (m *DatabaseEncryption) GetState() DatabaseEncryption_State {
	if m != nil {
		return m.State
	}
	return DatabaseEncryption_UNKNOWN
}

func (m *DatabaseEncryption) GetKeyName() string {
	if m != nil {
		return m.KeyName
	}
	return ""
}

// Configuration for exporting cluster resource usages.
type ResourceUsageExportConfig struct {
	// Configuration to use BigQuery as usage export destination.
	BigqueryDestination *ResourceUsageExportConfig_BigQueryDestination `protobuf:"bytes,1,opt,name=bigquery_destination,json=bigqueryDestination,proto3" json:"bigquery_destination,omitempty"`
	// Whether to enable network egress metering for this cluster. If enabled, a
	// daemonset will be created in the cluster to meter network egress traffic.
	EnableNetworkEgressMetering bool `protobuf:"varint,2,opt,name=enable_network_egress_metering,json=enableNetworkEgressMetering,proto3" json:"enable_network_egress_metering,omitempty"`
	// Configuration to enable resource consumption metering.
	ConsumptionMeteringConfig *ResourceUsageExportConfig_ConsumptionMeteringConfig `protobuf:"bytes,3,opt,name=consumption_metering_config,json=consumptionMeteringConfig,proto3" json:"consumption_metering_config,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                                             `json:"-"`
	XXX_unrecognized          []byte                                               `json:"-"`
	XXX_sizecache             int32                                                `json:"-"`
}

func (m *ResourceUsageExportConfig) Reset()         { *m = ResourceUsageExportConfig{} }
func (m *ResourceUsageExportConfig) String() string { return proto.CompactTextString(m) }
func (*ResourceUsageExportConfig) ProtoMessage()    {}
func (*ResourceUsageExportConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{85}
}

func (m *ResourceUsageExportConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceUsageExportConfig.Unmarshal(m, b)
}
func (m *ResourceUsageExportConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceUsageExportConfig.Marshal(b, m, deterministic)
}
func (m *ResourceUsageExportConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceUsageExportConfig.Merge(m, src)
}
func (m *ResourceUsageExportConfig) XXX_Size() int {
	return xxx_messageInfo_ResourceUsageExportConfig.Size(m)
}
func (m *ResourceUsageExportConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceUsageExportConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceUsageExportConfig proto.InternalMessageInfo

func (m *ResourceUsageExportConfig) GetBigqueryDestination() *ResourceUsageExportConfig_BigQueryDestination {
	if m != nil {
		return m.BigqueryDestination
	}
	return nil
}

func (m *ResourceUsageExportConfig) GetEnableNetworkEgressMetering() bool {
	if m != nil {
		return m.EnableNetworkEgressMetering
	}
	return false
}

func (m *ResourceUsageExportConfig) GetConsumptionMeteringConfig() *ResourceUsageExportConfig_ConsumptionMeteringConfig {
	if m != nil {
		return m.ConsumptionMeteringConfig
	}
	return nil
}

// Parameters for using BigQuery as the destination of resource usage export.
type ResourceUsageExportConfig_BigQueryDestination struct {
	// The ID of a BigQuery Dataset.
	DatasetId            string   `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceUsageExportConfig_BigQueryDestination) Reset() {
	*m = ResourceUsageExportConfig_BigQueryDestination{}
}
func (m *ResourceUsageExportConfig_BigQueryDestination) String() string {
	return proto.CompactTextString(m)
}
func (*ResourceUsageExportConfig_BigQueryDestination) ProtoMessage() {}
func (*ResourceUsageExportConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{85, 0}
}

func (m *ResourceUsageExportConfig_BigQueryDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceUsageExportConfig_BigQueryDestination.Unmarshal(m, b)
}
func (m *ResourceUsageExportConfig_BigQueryDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceUsageExportConfig_BigQueryDestination.Marshal(b, m, deterministic)
}
func (m *ResourceUsageExportConfig_BigQueryDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceUsageExportConfig_BigQueryDestination.Merge(m, src)
}
func (m *ResourceUsageExportConfig_BigQueryDestination) XXX_Size() int {
	return xxx_messageInfo_ResourceUsageExportConfig_BigQueryDestination.Size(m)
}
func (m *ResourceUsageExportConfig_BigQueryDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceUsageExportConfig_BigQueryDestination.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceUsageExportConfig_BigQueryDestination proto.InternalMessageInfo

func (m *ResourceUsageExportConfig_BigQueryDestination) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

// Parameters for controlling consumption metering.
type ResourceUsageExportConfig_ConsumptionMeteringConfig struct {
	// Whether to enable consumption metering for this cluster. If enabled, a
	// second BigQuery table will be created to hold resource consumption
	// records.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) Reset() {
	*m = ResourceUsageExportConfig_ConsumptionMeteringConfig{}
}
func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) String() string {
	return proto.CompactTextString(m)
}
func (*ResourceUsageExportConfig_ConsumptionMeteringConfig) ProtoMessage() {}
func (*ResourceUsageExportConfig_ConsumptionMeteringConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e39a67f424410134, []int{85, 1}
}

func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceUsageExportConfig_ConsumptionMeteringConfig.Unmarshal(m, b)
}
func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceUsageExportConfig_ConsumptionMeteringConfig.Marshal(b, m, deterministic)
}
func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceUsageExportConfig_ConsumptionMeteringConfig.Merge(m, src)
}
func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) XXX_Size() int {
	return xxx_messageInfo_ResourceUsageExportConfig_ConsumptionMeteringConfig.Size(m)
}
func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceUsageExportConfig_ConsumptionMeteringConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceUsageExportConfig_ConsumptionMeteringConfig proto.InternalMessageInfo

func (m *ResourceUsageExportConfig_ConsumptionMeteringConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func init() {
	proto.RegisterEnum("google.container.v1beta1.NodeTaint_Effect", NodeTaint_Effect_name, NodeTaint_Effect_value)
	proto.RegisterEnum("google.container.v1beta1.IstioConfig_IstioAuthMode", IstioConfig_IstioAuthMode_name, IstioConfig_IstioAuthMode_value)
	proto.RegisterEnum("google.container.v1beta1.NetworkPolicy_Provider", NetworkPolicy_Provider_name, NetworkPolicy_Provider_value)
	proto.RegisterEnum("google.container.v1beta1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("google.container.v1beta1.Operation_Status", Operation_Status_name, Operation_Status_value)
	proto.RegisterEnum("google.container.v1beta1.Operation_Type", Operation_Type_name, Operation_Type_value)
	proto.RegisterEnum("google.container.v1beta1.SetMasterAuthRequest_Action", SetMasterAuthRequest_Action_name, SetMasterAuthRequest_Action_value)
	proto.RegisterEnum("google.container.v1beta1.NodePool_Status", NodePool_Status_name, NodePool_Status_value)
	proto.RegisterEnum("google.container.v1beta1.WorkloadMetadataConfig_NodeMetadata", WorkloadMetadataConfig_NodeMetadata_name, WorkloadMetadataConfig_NodeMetadata_value)
	proto.RegisterEnum("google.container.v1beta1.Location_LocationType", Location_LocationType_name, Location_LocationType_value)
	proto.RegisterEnum("google.container.v1beta1.StatusCondition_Code", StatusCondition_Code_name, StatusCondition_Code_value)
	proto.RegisterEnum("google.container.v1beta1.UsableSubnetworkSecondaryRange_Status", UsableSubnetworkSecondaryRange_Status_name, UsableSubnetworkSecondaryRange_Status_value)
	proto.RegisterEnum("google.container.v1beta1.DatabaseEncryption_State", DatabaseEncryption_State_name, DatabaseEncryption_State_value)
	proto.RegisterType((*NodeConfig)(nil), "google.container.v1beta1.NodeConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1beta1.NodeConfig.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1beta1.NodeConfig.MetadataEntry")
	proto.RegisterType((*ShieldedInstanceConfig)(nil), "google.container.v1beta1.ShieldedInstanceConfig")
	proto.RegisterType((*NodeTaint)(nil), "google.container.v1beta1.NodeTaint")
	proto.RegisterType((*MasterAuth)(nil), "google.container.v1beta1.MasterAuth")
	proto.RegisterType((*ClientCertificateConfig)(nil), "google.container.v1beta1.ClientCertificateConfig")
	proto.RegisterType((*AddonsConfig)(nil), "google.container.v1beta1.AddonsConfig")
	proto.RegisterType((*HttpLoadBalancing)(nil), "google.container.v1beta1.HttpLoadBalancing")
	proto.RegisterType((*HorizontalPodAutoscaling)(nil), "google.container.v1beta1.HorizontalPodAutoscaling")
	proto.RegisterType((*KubernetesDashboard)(nil), "google.container.v1beta1.KubernetesDashboard")
	proto.RegisterType((*NetworkPolicyConfig)(nil), "google.container.v1beta1.NetworkPolicyConfig")
	proto.RegisterType((*PrivateClusterConfig)(nil), "google.container.v1beta1.PrivateClusterConfig")
	proto.RegisterType((*IstioConfig)(nil), "google.container.v1beta1.IstioConfig")
	proto.RegisterType((*CloudRunConfig)(nil), "google.container.v1beta1.CloudRunConfig")
	proto.RegisterType((*MasterAuthorizedNetworksConfig)(nil), "google.container.v1beta1.MasterAuthorizedNetworksConfig")
	proto.RegisterType((*MasterAuthorizedNetworksConfig_CidrBlock)(nil), "google.container.v1beta1.MasterAuthorizedNetworksConfig.CidrBlock")
	proto.RegisterType((*LegacyAbac)(nil), "google.container.v1beta1.LegacyAbac")
	proto.RegisterType((*NetworkPolicy)(nil), "google.container.v1beta1.NetworkPolicy")
	proto.RegisterType((*IPAllocationPolicy)(nil), "google.container.v1beta1.IPAllocationPolicy")
	proto.RegisterType((*BinaryAuthorization)(nil), "google.container.v1beta1.BinaryAuthorization")
	proto.RegisterType((*PodSecurityPolicyConfig)(nil), "google.container.v1beta1.PodSecurityPolicyConfig")
	proto.RegisterType((*AuthenticatorGroupsConfig)(nil), "google.container.v1beta1.AuthenticatorGroupsConfig")
	proto.RegisterType((*Cluster)(nil), "google.container.v1beta1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1beta1.Cluster.ResourceLabelsEntry")
	proto.RegisterType((*ClusterUpdate)(nil), "google.container.v1beta1.ClusterUpdate")
	proto.RegisterType((*Operation)(nil), "google.container.v1beta1.Operation")
	proto.RegisterType((*OperationProgress)(nil), "google.container.v1beta1.OperationProgress")
	proto.RegisterType((*OperationProgress_Metric)(nil), "google.container.v1beta1.OperationProgress.Metric")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.container.v1beta1.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.container.v1beta1.GetClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.container.v1beta1.UpdateClusterRequest")
	proto.RegisterType((*UpdateNodePoolRequest)(nil), "google.container.v1beta1.UpdateNodePoolRequest")
	proto.RegisterType((*SetNodePoolAutoscalingRequest)(nil), "google.container.v1beta1.SetNodePoolAutoscalingRequest")
	proto.RegisterType((*SetLoggingServiceRequest)(nil), "google.container.v1beta1.SetLoggingServiceRequest")
	proto.RegisterType((*SetMonitoringServiceRequest)(nil), "google.container.v1beta1.SetMonitoringServiceRequest")
	proto.RegisterType((*SetAddonsConfigRequest)(nil), "google.container.v1beta1.SetAddonsConfigRequest")
	proto.RegisterType((*SetLocationsRequest)(nil), "google.container.v1beta1.SetLocationsRequest")
	proto.RegisterType((*UpdateMasterRequest)(nil), "google.container.v1beta1.UpdateMasterRequest")
	proto.RegisterType((*SetMasterAuthRequest)(nil), "google.container.v1beta1.SetMasterAuthRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.container.v1beta1.DeleteClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.container.v1beta1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.container.v1beta1.ListClustersResponse")
	proto.RegisterType((*GetOperationRequest)(nil), "google.container.v1beta1.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.container.v1beta1.ListOperationsRequest")
	proto.RegisterType((*CancelOperationRequest)(nil), "google.container.v1beta1.CancelOperationRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.container.v1beta1.ListOperationsResponse")
	proto.RegisterType((*GetServerConfigRequest)(nil), "google.container.v1beta1.GetServerConfigRequest")
	proto.RegisterType((*ServerConfig)(nil), "google.container.v1beta1.ServerConfig")
	proto.RegisterType((*CreateNodePoolRequest)(nil), "google.container.v1beta1.CreateNodePoolRequest")
	proto.RegisterType((*DeleteNodePoolRequest)(nil), "google.container.v1beta1.DeleteNodePoolRequest")
	proto.RegisterType((*ListNodePoolsRequest)(nil), "google.container.v1beta1.ListNodePoolsRequest")
	proto.RegisterType((*GetNodePoolRequest)(nil), "google.container.v1beta1.GetNodePoolRequest")
	proto.RegisterType((*NodePool)(nil), "google.container.v1beta1.NodePool")
	proto.RegisterType((*NodeManagement)(nil), "google.container.v1beta1.NodeManagement")
	proto.RegisterType((*AutoUpgradeOptions)(nil), "google.container.v1beta1.AutoUpgradeOptions")
	proto.RegisterType((*MaintenancePolicy)(nil), "google.container.v1beta1.MaintenancePolicy")
	proto.RegisterType((*MaintenanceWindow)(nil), "google.container.v1beta1.MaintenanceWindow")
	proto.RegisterMapType((map[string]*TimeWindow)(nil), "google.container.v1beta1.MaintenanceWindow.MaintenanceExclusionsEntry")
	proto.RegisterType((*TimeWindow)(nil), "google.container.v1beta1.TimeWindow")
	proto.RegisterType((*RecurringTimeWindow)(nil), "google.container.v1beta1.RecurringTimeWindow")
	proto.RegisterType((*DailyMaintenanceWindow)(nil), "google.container.v1beta1.DailyMaintenanceWindow")
	proto.RegisterType((*SetNodePoolManagementRequest)(nil), "google.container.v1beta1.SetNodePoolManagementRequest")
	proto.RegisterType((*SetNodePoolSizeRequest)(nil), "google.container.v1beta1.SetNodePoolSizeRequest")
	proto.RegisterType((*RollbackNodePoolUpgradeRequest)(nil), "google.container.v1beta1.RollbackNodePoolUpgradeRequest")
	proto.RegisterType((*ListNodePoolsResponse)(nil), "google.container.v1beta1.ListNodePoolsResponse")
	proto.RegisterType((*ClusterAutoscaling)(nil), "google.container.v1beta1.ClusterAutoscaling")
	proto.RegisterType((*AutoprovisioningNodePoolDefaults)(nil), "google.container.v1beta1.AutoprovisioningNodePoolDefaults")
	proto.RegisterType((*ResourceLimit)(nil), "google.container.v1beta1.ResourceLimit")
	proto.RegisterType((*NodePoolAutoscaling)(nil), "google.container.v1beta1.NodePoolAutoscaling")
	proto.RegisterType((*SetLabelsRequest)(nil), "google.container.v1beta1.SetLabelsRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1beta1.SetLabelsRequest.ResourceLabelsEntry")
	proto.RegisterType((*SetLegacyAbacRequest)(nil), "google.container.v1beta1.SetLegacyAbacRequest")
	proto.RegisterType((*StartIPRotationRequest)(nil), "google.container.v1beta1.StartIPRotationRequest")
	proto.RegisterType((*CompleteIPRotationRequest)(nil), "google.container.v1beta1.CompleteIPRotationRequest")
	proto.RegisterType((*AcceleratorConfig)(nil), "google.container.v1beta1.AcceleratorConfig")
	proto.RegisterType((*WorkloadMetadataConfig)(nil), "google.container.v1beta1.WorkloadMetadataConfig")
	proto.RegisterType((*SetNetworkPolicyRequest)(nil), "google.container.v1beta1.SetNetworkPolicyRequest")
	proto.RegisterType((*SetMaintenancePolicyRequest)(nil), "google.container.v1beta1.SetMaintenancePolicyRequest")
	proto.RegisterType((*ListLocationsRequest)(nil), "google.container.v1beta1.ListLocationsRequest")
	proto.RegisterType((*ListLocationsResponse)(nil), "google.container.v1beta1.ListLocationsResponse")
	proto.RegisterType((*Location)(nil), "google.container.v1beta1.Location")
	proto.RegisterType((*StatusCondition)(nil), "google.container.v1beta1.StatusCondition")
	proto.RegisterType((*NetworkConfig)(nil), "google.container.v1beta1.NetworkConfig")
	proto.RegisterType((*ListUsableSubnetworksRequest)(nil), "google.container.v1beta1.ListUsableSubnetworksRequest")
	proto.RegisterType((*ListUsableSubnetworksResponse)(nil), "google.container.v1beta1.ListUsableSubnetworksResponse")
	proto.RegisterType((*UsableSubnetworkSecondaryRange)(nil), "google.container.v1beta1.UsableSubnetworkSecondaryRange")
	proto.RegisterType((*UsableSubnetwork)(nil), "google.container.v1beta1.UsableSubnetwork")
	proto.RegisterType((*VerticalPodAutoscaling)(nil), "google.container.v1beta1.VerticalPodAutoscaling")
	proto.RegisterType((*IntraNodeVisibilityConfig)(nil), "google.container.v1beta1.IntraNodeVisibilityConfig")
	proto.RegisterType((*MaxPodsConstraint)(nil), "google.container.v1beta1.MaxPodsConstraint")
	proto.RegisterType((*DatabaseEncryption)(nil), "google.container.v1beta1.DatabaseEncryption")
	proto.RegisterType((*ResourceUsageExportConfig)(nil), "google.container.v1beta1.ResourceUsageExportConfig")
	proto.RegisterType((*ResourceUsageExportConfig_BigQueryDestination)(nil), "google.container.v1beta1.ResourceUsageExportConfig.BigQueryDestination")
	proto.RegisterType((*ResourceUsageExportConfig_ConsumptionMeteringConfig)(nil), "google.container.v1beta1.ResourceUsageExportConfig.ConsumptionMeteringConfig")
}

func init() {
	proto.RegisterFile("google/container/v1beta1/cluster_service.proto", fileDescriptor_e39a67f424410134)
}

var fileDescriptor_e39a67f424410134 = []byte{
	// 7996 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x7d, 0x6d, 0x6c, 0x24, 0xc9,
	0x75, 0xd8, 0xf5, 0xf0, 0xfb, 0x91, 0x1c, 0x0e, 0x8b, 0x5c, 0xee, 0xec, 0xec, 0xc7, 0xed, 0xf5,
	0x9d, 0x6e, 0x3f, 0x6e, 0x8f, 0xbc, 0xdb, 0xfb, 0xd4, 0x9e, 0x4e, 0xd2, 0x70, 0xd8, 0xc7, 0x65,
	0x96, 0x9c, 0x19, 0xf5, 0x0c, 0xf7, 0x74, 0xab, 0x8b, 0x3b, 0xcd, 0x99, 0xda, 0x61, 0xdf, 0xce,
	0x74, 0xf7, 0x75, 0xf7, 0xec, 0x2e, 0xef, 0xb0, 0x06, 0x24, 0x05, 0x89, 0x15, 0x24, 0x12, 0xa4,
	0x58, 0x36, 0xe2, 0x20, 0x89, 0x83, 0x44, 0x88, 0x2c, 0xc7, 0x88, 0x1d, 0xc7, 0xb0, 0xe3, 0x04,
	0x4e, 0x64, 0xcb, 0x40, 0x20, 0x04, 0xf9, 0x61, 0x19, 0x09, 0xbc, 0x08, 0x10, 0x05, 0x88, 0x03,
	0xe4, 0x4f, 0x10, 0x44, 0x40, 0x12, 0x38, 0x70, 0x10, 0xd4, 0x57, 0x77, 0xf5, 0x4c, 0x4f, 0xcf,
	0x90, 0xdc, 0xdb, 0x3b, 0xfd, 0xe2, 0x74, 0x55, 0xbd, 0x57, 0xaf, 0x5e, 0xbd, 0xaa, 0x7a, 0xef,
	0xd5, 0x7b, 0x45, 0x58, 0x6d, 0x39, 0x4e, 0xab, 0x8d, 0xd7, 0x1a, 0x8e, 0x1d, 0x98, 0x96, 0x8d,
	0xbd, 0xb5, 0xbb, 0x2f, 0xee, 0xe1, 0xc0, 0x7c, 0x71, 0xad, 0xd1, 0xee, 0xfa, 0x01, 0xf6, 0x0c,
	0x1f, 0x7b, 0x77, 0xad, 0x06, 0x5e, 0x75, 0x3d, 0x27, 0x70, 0x50, 0x9e, 0xb5, 0x5f, 0x0d, 0xdb,
	0xaf, 0xf2, 0xf6, 0x85, 0x33, 0x1c, 0x93, 0xe9, 0x5a, 0x6b, 0xa6, 0x6d, 0x3b, 0x81, 0x19, 0x58,
	0x8e, 0xed, 0x33, 0xb8, 0xc2, 0x49, 0xa9, 0xb6, 0xd1, 0xb6, 0xb0, 0x1d, 0xf0, 0x8a, 0x27, 0xa5,
	0x8a, 0xdb, 0x16, 0x6e, 0x37, 0x8d, 0x3d, 0xbc, 0x6f, 0xde, 0xb5, 0x1c, 0x8f, 0x37, 0x38, 0xcd,
	0x1b, 0xd0, 0xaf, 0xbd, 0xee, 0xed, 0x35, 0xdc, 0x71, 0x83, 0x83, 0x1e, 0xe8, 0xb0, 0x32, 0xb0,
	0x3a, 0xd8, 0x0f, 0xcc, 0x8e, 0xcb, 0x1a, 0xa8, 0x7f, 0x32, 0x05, 0x50, 0x76, 0x9a, 0xb8, 0xe4,
	0xd8, 0xb7, 0xad, 0x16, 0x7a, 0x0a, 0xe6, 0x3a, 0x66, 0x63, 0xdf, 0xb2, 0xb1, 0x11, 0x1c, 0xb8,
	0x38, 0xaf, 0x9c, 0x57, 0x2e, 0xce, 0xe8, 0xb3, 0xbc, 0xac, 0x7e, 0xe0, 0x62, 0x74, 0x1e, 0xe6,
	0x9a, 0x96, 0x7f, 0xc7, 0xf0, 0xad, 0x0f, 0xb0, 0xd1, 0xda, 0xcb, 0x67, 0xce, 0x2b, 0x17, 0x27,
	0x74, 0x20, 0x65, 0x35, 0xeb, 0x03, 0xbc, 0xb9, 0x47, 0x90, 0x38, 0x66, 0x37, 0xd8, 0x37, 0xfc,
	0x86, 0xe3, 0x62, 0x3f, 0x3f, 0x76, 0x7e, 0x8c, 0x20, 0xa1, 0x65, 0x35, 0x5a, 0x84, 0x2e, 0xc0,
	0x02, 0xe7, 0x9b, 0x61, 0x36, 0x1a, 0x4e, 0xd7, 0x0e, 0xf2, 0x33, 0xb4, 0xab, 0x2c, 0x2f, 0x2e,
	0xb2, 0x52, 0x54, 0x86, 0xe9, 0x0e, 0x0e, 0xcc, 0xa6, 0x19, 0x98, 0xf9, 0xf1, 0xf3, 0x63, 0x17,
	0x67, 0xaf, 0x5e, 0x5d, 0x1d, 0xc4, 0xe2, 0xd5, 0x68, 0x20, 0xab, 0x3b, 0x1c, 0x48, 0xb3, 0x03,
	0xef, 0x40, 0x0f, 0x71, 0xa0, 0xb3, 0x00, 0x56, 0xc7, 0x6c, 0xf1, 0xe1, 0x4d, 0xd0, 0x3e, 0x67,
	0x68, 0x09, 0x1d, 0xdc, 0x75, 0x98, 0x6c, 0x9b, 0x7b, 0xb8, 0xed, 0xe7, 0x27, 0x69, 0x67, 0x2f,
	0x8c, 0xd4, 0xd9, 0x36, 0x05, 0x61, 0x5d, 0x71, 0x78, 0xf4, 0x2c, 0x2c, 0xb4, 0x9d, 0x86, 0xd9,
	0x36, 0x7c, 0xbf, 0x69, 0xb0, 0x11, 0x4e, 0x51, 0x4e, 0xcd, 0xd3, 0xe2, 0x9a, 0xdf, 0x2c, 0xd1,
	0x01, 0x22, 0x18, 0x0f, 0xcc, 0x96, 0x9f, 0x9f, 0xa6, 0x4c, 0xa2, 0xbf, 0xd1, 0x79, 0x98, 0x75,
	0x3d, 0x4c, 0xe6, 0xd1, 0xda, 0x6b, 0xe3, 0x3c, 0x9c, 0x57, 0x2e, 0x4e, 0xeb, 0x72, 0x11, 0xaa,
	0xc0, 0x9c, 0xd9, 0x68, 0xe0, 0x36, 0xf6, 0xcc, 0xc0, 0xf1, 0xfc, 0xfc, 0x2c, 0xa5, 0xf6, 0xb9,
	0xc1, 0xd4, 0x16, 0xa3, 0xd6, 0x8c, 0x68, 0x3d, 0x86, 0x00, 0x9d, 0x86, 0x19, 0x3a, 0xab, 0x94,
	0x2d, 0x73, 0x94, 0x2d, 0xd3, 0xa4, 0x80, 0x72, 0xe5, 0x22, 0xe4, 0x3a, 0x96, 0x6d, 0x34, 0xdc,
	0xae, 0xe1, 0xb6, 0xcd, 0xe0, 0xb6, 0xe3, 0x75, 0xf2, 0xf3, 0x6c, 0xba, 0x3a, 0x96, 0x5d, 0x72,
	0xbb, 0x55, 0x5e, 0x8a, 0xde, 0x83, 0xfc, 0x3d, 0xc7, 0xbb, 0xd3, 0x76, 0xcc, 0xa6, 0x21, 0x78,
	0x6e, 0x34, 0x68, 0x87, 0xf9, 0xec, 0x79, 0x25, 0x9d, 0xa3, 0x6f, 0x73, 0x48, 0x31, 0x77, 0x9c,
	0xd0, 0x95, 0x7b, 0x89, 0xe5, 0xe8, 0x0d, 0x98, 0x24, 0x08, 0x02, 0x3f, 0xbf, 0x40, 0x47, 0xff,
	0x74, 0xfa, 0x5c, 0xd5, 0x49, 0x5b, 0x9d, 0x83, 0x10, 0x42, 0xfd, 0x7d, 0xb2, 0x9c, 0x70, 0xd3,
	0xb0, 0x6c, 0x3f, 0x30, 0xed, 0x06, 0x16, 0x84, 0x2e, 0x0f, 0x23, 0xb4, 0xc6, 0x21, 0xb7, 0x38,
	0xa0, 0x20, 0xd4, 0x4f, 0x2c, 0x2f, 0xbc, 0x01, 0xf3, 0x31, 0x71, 0x44, 0x39, 0x18, 0xbb, 0x83,
	0x0f, 0xf8, 0xe2, 0x22, 0x3f, 0xd1, 0x32, 0x4c, 0xdc, 0x35, 0xdb, 0x5d, 0x4c, 0x57, 0xd3, 0x8c,
	0xce, 0x3e, 0xae, 0x65, 0x5e, 0x57, 0x0a, 0x9f, 0x86, 0x59, 0x49, 0xbc, 0x0e, 0x03, 0xaa, 0xfe,
	0x15, 0x05, 0x56, 0x92, 0x49, 0x45, 0x57, 0x00, 0x61, 0xdb, 0xdc, 0x6b, 0x63, 0xc3, 0xc7, 0x8d,
	0xae, 0x87, 0x8d, 0x3d, 0xc7, 0x09, 0x28, 0xd6, 0x69, 0x3d, 0xc7, 0x6a, 0x6a, 0xb4, 0x62, 0xdd,
	0x71, 0x02, 0xf4, 0x59, 0x38, 0xcd, 0x5b, 0x5b, 0x76, 0x80, 0x5b, 0x9e, 0x15, 0x1c, 0x18, 0x1d,
	0xc7, 0xb6, 0x02, 0xc7, 0xb3, 0xec, 0x16, 0xed, 0x78, 0x5a, 0x3f, 0xc5, 0x9a, 0x6c, 0x89, 0x16,
	0x3b, 0x61, 0x03, 0xf5, 0x8f, 0x14, 0x98, 0x09, 0xa7, 0x60, 0xd4, 0x21, 0xa0, 0x75, 0x98, 0xc4,
	0xb7, 0x6f, 0xe3, 0x46, 0x90, 0x1f, 0x3b, 0xaf, 0x5c, 0xcc, 0x5e, 0xbd, 0x3c, 0xc2, 0xfc, 0xae,
	0x6a, 0x14, 0x42, 0xe7, 0x90, 0xea, 0x3b, 0x30, 0xc9, 0x4a, 0xd0, 0x0a, 0x20, 0xed, 0xad, 0xb7,
	0xb4, 0x52, 0xdd, 0xd8, 0x2d, 0xd7, 0xaa, 0x5a, 0x69, 0xeb, 0xad, 0x2d, 0x6d, 0x23, 0xf7, 0x04,
	0x5a, 0x80, 0xd9, 0x72, 0xc5, 0xa8, 0x95, 0xae, 0x6b, 0x1b, 0xbb, 0xdb, 0x5a, 0x4e, 0x21, 0x0d,
	0xab, 0xba, 0xf6, 0x96, 0xa6, 0x1b, 0x72, 0x79, 0x06, 0x65, 0x01, 0xca, 0x15, 0x43, 0xfb, 0xa2,
	0x56, 0xda, 0xad, 0x6b, 0xb9, 0x31, 0xf5, 0xb7, 0x33, 0x00, 0x3b, 0x26, 0x39, 0x02, 0x8a, 0xdd,
	0x60, 0x1f, 0x15, 0x60, 0xba, 0xeb, 0x63, 0xcf, 0x36, 0x3b, 0x62, 0xd7, 0x0c, 0xbf, 0x49, 0x9d,
	0x6b, 0xfa, 0xfe, 0x3d, 0xc7, 0x6b, 0xf2, 0x21, 0x86, 0xdf, 0xa8, 0x03, 0xa7, 0xd8, 0x7e, 0x6f,
	0x34, 0xb0, 0x17, 0x58, 0xb7, 0xad, 0x86, 0x19, 0x84, 0x92, 0x38, 0x46, 0x25, 0xf1, 0xc5, 0xc1,
	0x03, 0x2f, 0x51, 0xd0, 0x52, 0x04, 0xc9, 0x45, 0xf1, 0x64, 0x23, 0xb9, 0x02, 0xbd, 0x0c, 0x2b,
	0xe2, 0xe0, 0x6a, 0x98, 0x72, 0x97, 0xf9, 0x26, 0x25, 0x6c, 0x99, 0xd7, 0x96, 0x4c, 0x09, 0x16,
	0x3d, 0x0f, 0xa8, 0x9f, 0xc8, 0x3c, 0xa6, 0x10, 0x8b, 0x7d, 0x5d, 0x91, 0x4d, 0x96, 0x37, 0x27,
	0x13, 0x7d, 0x9b, 0x6d, 0xb2, 0xac, 0xe4, 0x06, 0x3e, 0x50, 0x6b, 0x70, 0x72, 0x00, 0xdd, 0xe8,
	0x75, 0xc8, 0x5b, 0xbe, 0xdf, 0xc5, 0x46, 0x42, 0x77, 0x4c, 0x3a, 0x57, 0x68, 0x7d, 0x1f, 0xbc,
	0xfa, 0x83, 0x71, 0x98, 0x2b, 0x36, 0x9b, 0x8e, 0xed, 0x73, 0x54, 0x5f, 0x82, 0xa5, 0xfd, 0x20,
	0x70, 0x0d, 0xba, 0x17, 0xed, 0x99, 0x6d, 0xd3, 0x6e, 0x10, 0x61, 0x55, 0x28, 0x4b, 0x53, 0x76,
	0xca, 0xeb, 0x41, 0xe0, 0x6e, 0x3b, 0x66, 0x73, 0x5d, 0x80, 0xe8, 0x8b, 0xfb, 0xbd, 0x45, 0xc8,
	0x85, 0xc2, 0xbe, 0xe3, 0x59, 0x1f, 0x10, 0xe8, 0xb6, 0xe1, 0x3a, 0x4d, 0xc3, 0xec, 0x06, 0x8e,
	0xdf, 0x30, 0xdb, 0x62, 0x41, 0xa4, 0x1e, 0x54, 0xd7, 0x43, 0xd8, 0xaa, 0xd3, 0x2c, 0x46, 0x90,
	0x7a, 0x7e, 0x7f, 0x40, 0x0d, 0x6a, 0xc2, 0xf2, 0x9d, 0xee, 0x1e, 0xf6, 0x6c, 0x1c, 0x60, 0xdf,
	0x68, 0x9a, 0xfe, 0xfe, 0x9e, 0x63, 0x7a, 0x4d, 0x2e, 0x22, 0xcf, 0x0f, 0xee, 0xeb, 0x46, 0x08,
	0xb5, 0x21, 0x80, 0xd6, 0x33, 0x79, 0x45, 0x5f, 0xba, 0xd3, 0x5f, 0x81, 0x4c, 0x38, 0x61, 0xe3,
	0x80, 0x6c, 0xb8, 0x86, 0xeb, 0xb4, 0xad, 0xc6, 0x81, 0x90, 0xc4, 0xf1, 0x61, 0xdd, 0x94, 0x19,
	0x58, 0x95, 0x42, 0x71, 0x29, 0x5c, 0xb2, 0xfb, 0x0b, 0xd1, 0x75, 0x98, 0xb3, 0xfc, 0xc0, 0x72,
	0x04, 0xe6, 0x09, 0x8a, 0xf9, 0x53, 0x83, 0x31, 0x6f, 0x91, 0xd6, 0x1c, 0xe3, 0xac, 0x15, 0x7d,
	0x20, 0x1d, 0x72, 0x8d, 0xb6, 0xd3, 0x6d, 0x1a, 0x5e, 0xd7, 0x16, 0xd8, 0xa6, 0x28, 0xb6, 0x8b,
	0x69, 0x2b, 0xc6, 0xe9, 0x36, 0xf5, 0xae, 0xcd, 0x11, 0x66, 0x1b, 0xb1, 0x6f, 0x75, 0x0d, 0x16,
	0xfb, 0x04, 0x80, 0xac, 0xdf, 0xa6, 0xe5, 0x93, 0xdd, 0xad, 0xc9, 0xa5, 0x30, 0xfc, 0x56, 0x5f,
	0x85, 0xfc, 0xa0, 0xd9, 0x4c, 0x85, 0x7b, 0x11, 0x96, 0x12, 0x66, 0x66, 0x18, 0x48, 0x02, 0x97,
	0x53, 0x41, 0xbe, 0x96, 0x81, 0xe5, 0xaa, 0x67, 0xdd, 0x25, 0x2b, 0x8c, 0x2f, 0x6c, 0x06, 0xf4,
	0x02, 0x2c, 0xf3, 0x2d, 0xdd, 0x65, 0xd5, 0x86, 0xed, 0x34, 0xb1, 0xcf, 0x11, 0xf0, 0xc3, 0x81,
	0x43, 0x92, 0xdd, 0xd5, 0x47, 0xaf, 0xc2, 0xc9, 0x1e, 0x08, 0x6c, 0x37, 0x5d, 0xc7, 0xb2, 0x03,
	0x7e, 0x00, 0x9c, 0x88, 0x01, 0x69, 0xbc, 0x12, 0xbd, 0x04, 0x2b, 0x1d, 0xba, 0x4d, 0x1a, 0x96,
	0x7b, 0xf7, 0x65, 0xa3, 0x61, 0x35, 0x3d, 0x63, 0xaf, 0xed, 0x34, 0xee, 0x50, 0xd1, 0x9d, 0xd1,
	0x97, 0x58, 0xed, 0x96, 0x7b, 0xf7, 0xe5, 0x92, 0xd5, 0xf4, 0xd6, 0x49, 0x15, 0xba, 0x04, 0xb9,
	0xbe, 0x5e, 0xc6, 0x69, 0xf3, 0x05, 0xb7, 0x07, 0xff, 0x05, 0x58, 0x70, 0xbb, 0x7b, 0x6d, 0xab,
	0x11, 0xb5, 0x64, 0x6a, 0x5d, 0x96, 0x15, 0x8b, 0x86, 0xea, 0x3f, 0x52, 0x60, 0x56, 0x92, 0xa5,
	0x34, 0xbe, 0xa1, 0x4d, 0x18, 0x27, 0xda, 0x2a, 0x1d, 0x59, 0xf6, 0xea, 0x4b, 0x23, 0x09, 0x27,
	0xfb, 0x4d, 0x0e, 0x83, 0x1d, 0xa7, 0x89, 0x75, 0x8a, 0x40, 0x7d, 0x09, 0xe6, 0x63, 0xc5, 0x68,
	0x1e, 0x66, 0x8a, 0xbb, 0xf5, 0xeb, 0x46, 0xb9, 0x52, 0xd6, 0x72, 0x4f, 0xa0, 0x25, 0x58, 0xa0,
	0x9f, 0x3b, 0xbb, 0xf5, 0xdd, 0xe2, 0xb6, 0x51, 0xdf, 0xae, 0xe5, 0x14, 0xf5, 0x0a, 0x64, 0xe3,
	0x62, 0x9a, 0x3a, 0xc7, 0xff, 0x5d, 0x81, 0x73, 0xd1, 0x41, 0x44, 0x64, 0x11, 0x37, 0xb9, 0x9c,
	0x88, 0xbd, 0x30, 0x0f, 0x53, 0x6c, 0x72, 0x04, 0xb4, 0xf8, 0x44, 0x0d, 0x98, 0x8d, 0x66, 0xc4,
	0xcf, 0x67, 0xa8, 0x26, 0xb5, 0x3e, 0x78, 0xbc, 0xe9, 0x1d, 0xad, 0x86, 0x33, 0xa8, 0x43, 0x43,
	0xfc, 0xf4, 0x0b, 0x3b, 0x30, 0x13, 0x4d, 0xed, 0x53, 0xd4, 0x7e, 0x70, 0xdb, 0xe6, 0x81, 0x21,
	0x1d, 0x96, 0xb3, 0xbc, 0xac, 0x4c, 0xce, 0x4b, 0x72, 0x7e, 0x44, 0x62, 0x92, 0xe1, 0xe7, 0x87,
	0xc0, 0xa0, 0x3e, 0x0b, 0xb0, 0x8d, 0x5b, 0x66, 0xe3, 0xa0, 0xb8, 0x67, 0x36, 0x06, 0x8f, 0x4d,
	0xfd, 0x15, 0x05, 0xe6, 0x63, 0x0b, 0x06, 0x6d, 0xc3, 0xb4, 0xeb, 0x39, 0x77, 0xad, 0x26, 0xf6,
	0x68, 0xe3, 0x6c, 0xaa, 0x82, 0x2f, 0x83, 0xae, 0x56, 0x39, 0x9c, 0x1e, 0x62, 0x90, 0x7b, 0xce,
	0xc4, 0x7b, 0x7e, 0x01, 0xa6, 0xab, 0x51, 0xab, 0xe5, 0xaa, 0x5e, 0xb9, 0xb9, 0xb5, 0xa1, 0xe9,
	0x3d, 0xaa, 0x07, 0xc0, 0x64, 0xa9, 0xb8, 0xbd, 0x55, 0xaa, 0xe4, 0x14, 0xf5, 0x97, 0x27, 0x00,
	0x6d, 0x55, 0x8b, 0x6d, 0x62, 0x1c, 0x10, 0xbb, 0x90, 0x13, 0xfc, 0x0c, 0x64, 0xbb, 0x3e, 0x36,
	0x2c, 0xd7, 0x30, 0xdb, 0x96, 0xe9, 0x87, 0x0b, 0x74, 0xae, 0xeb, 0xe3, 0x2d, 0xb7, 0xc8, 0xca,
	0xd0, 0x73, 0xb0, 0xd8, 0xf0, 0x30, 0x59, 0x2c, 0x7e, 0x77, 0x8f, 0xef, 0xb9, 0x9c, 0xa4, 0x1c,
	0xab, 0xa8, 0x85, 0xe5, 0xd4, 0xf4, 0x0a, 0xbf, 0xd8, 0x14, 0x8c, 0x71, 0xd3, 0x2b, 0x2c, 0xa6,
	0xb3, 0xb0, 0x0a, 0x8b, 0x42, 0x55, 0x08, 0x57, 0x2e, 0x5b, 0x84, 0xf4, 0xfc, 0x58, 0xe0, 0x95,
	0x62, 0xe1, 0xa2, 0x8b, 0x90, 0x25, 0x7b, 0x88, 0xd4, 0x78, 0x22, 0x6c, 0x3c, 0x47, 0x6a, 0xc2,
	0x96, 0x2f, 0x00, 0xe2, 0x66, 0x9e, 0x2f, 0xb5, 0x9e, 0x0c, 0x5b, 0xe7, 0x44, 0x6d, 0x08, 0xf1,
	0x39, 0x38, 0x13, 0xd9, 0xdb, 0x0d, 0xc7, 0x6e, 0x9a, 0xde, 0x81, 0xe1, 0x99, 0x76, 0x0b, 0xb3,
	0x11, 0x4c, 0xd1, 0x11, 0x9c, 0xe2, 0x6d, 0x6a, 0xa2, 0x89, 0x4e, 0x5a, 0xd0, 0xc1, 0x14, 0xe1,
	0x6c, 0xd8, 0x65, 0x22, 0x86, 0x69, 0x8a, 0xa1, 0x20, 0x1a, 0x25, 0xa0, 0x78, 0x05, 0x4e, 0xf6,
	0xf1, 0x83, 0x8b, 0xe8, 0x4c, 0x4c, 0x77, 0x8a, 0x6f, 0x65, 0x6b, 0xb0, 0x1c, 0x67, 0x0b, 0x87,
	0x01, 0xa6, 0x3d, 0xc9, 0x8c, 0x61, 0x00, 0xaf, 0x41, 0xbe, 0x9f, 0x3b, 0x1c, 0x68, 0x96, 0x02,
	0x9d, 0xe8, 0xe5, 0x0f, 0x03, 0x5c, 0x85, 0x25, 0xb3, 0xdd, 0x76, 0xee, 0x19, 0x9e, 0xd3, 0x0d,
	0xb0, 0xe1, 0xdc, 0xc5, 0x5e, 0xdb, 0x74, 0xa9, 0x35, 0x37, 0xad, 0x2f, 0xd2, 0x2a, 0x9d, 0xd4,
	0x54, 0x58, 0x05, 0x7a, 0x1e, 0x96, 0x02, 0xb7, 0xdb, 0xd7, 0x07, 0xb3, 0xec, 0x72, 0x81, 0xdb,
	0x8d, 0xa1, 0x57, 0xd7, 0x60, 0x69, 0xdd, 0xb2, 0x4d, 0xef, 0x40, 0xac, 0x7e, 0x2a, 0xa8, 0x29,
	0xeb, 0xef, 0x25, 0x38, 0x59, 0x75, 0x9a, 0xd4, 0x8e, 0xb0, 0x82, 0x83, 0xd8, 0x99, 0x35, 0x18,
	0xe8, 0x5d, 0x38, 0x45, 0xf0, 0x63, 0x3b, 0x20, 0x7a, 0x9d, 0xe3, 0x6d, 0x7a, 0x4e, 0xd7, 0x1d,
	0xbe, 0x8f, 0x7d, 0x0a, 0xb2, 0x3e, 0xef, 0xc8, 0x68, 0x11, 0x10, 0xbe, 0x6d, 0xcc, 0x8b, 0x52,
	0x8a, 0x47, 0xfd, 0xc3, 0x02, 0x4c, 0xf1, 0x83, 0x90, 0x58, 0xde, 0xd2, 0x06, 0x44, 0x7f, 0x13,
	0xcb, 0xbb, 0x89, 0xfd, 0x86, 0x67, 0xb9, 0x64, 0x6c, 0x1c, 0x87, 0x5c, 0x44, 0x64, 0xd7, 0xb2,
	0xad, 0xc0, 0x32, 0xdb, 0xf4, 0xc4, 0xe4, 0xa6, 0x3d, 0x59, 0x41, 0x13, 0x4c, 0x76, 0x79, 0x2d,
	0x73, 0x0f, 0x10, 0x0b, 0x7f, 0x0b, 0x66, 0x79, 0x4b, 0x49, 0x93, 0x7a, 0x66, 0x14, 0xc7, 0x02,
	0x45, 0x08, 0x76, 0xe4, 0x9e, 0xd1, 0x60, 0x96, 0x9f, 0xa5, 0xf4, 0x74, 0x9a, 0x18, 0x86, 0x2a,
	0xda, 0xad, 0x75, 0xe8, 0x44, 0xb6, 0xca, 0x05, 0x58, 0x68, 0x3b, 0xad, 0x96, 0x65, 0xb7, 0x84,
	0xf7, 0x8a, 0x2d, 0x3e, 0x3d, 0xcb, 0x8b, 0x6b, 0xac, 0x94, 0xe8, 0xfd, 0x91, 0x9d, 0x17, 0xb6,
	0x65, 0x8b, 0x6d, 0x31, 0xaa, 0x11, 0xcd, 0xf3, 0x30, 0x25, 0x76, 0x1f, 0xb6, 0x9c, 0xc4, 0x27,
	0xba, 0x9c, 0xb4, 0x97, 0xb0, 0x55, 0xd3, 0xb7, 0x8f, 0xdc, 0x80, 0x79, 0x93, 0x2a, 0xf2, 0x82,
	0x63, 0x40, 0x87, 0xf9, 0x6c, 0x8a, 0x73, 0x43, 0xd2, 0xfb, 0xf5, 0x39, 0x53, 0xb6, 0x02, 0xce,
	0x01, 0x48, 0x7b, 0x22, 0x5b, 0x3e, 0x52, 0x09, 0x2a, 0x02, 0xe5, 0xaf, 0xe1, 0x3a, 0x4e, 0xdb,
	0xcf, 0xcf, 0xd1, 0xe3, 0x4f, 0x4d, 0x9f, 0x9b, 0xaa, 0xe3, 0xb4, 0xf5, 0x19, 0x9b, 0xff, 0xf2,
	0xd1, 0x19, 0x98, 0x11, 0xbb, 0xb6, 0x9f, 0x9f, 0xa7, 0x6e, 0x9c, 0xa8, 0x40, 0x52, 0x9b, 0x24,
	0xf5, 0xdd, 0x6c, 0xbb, 0xfb, 0x26, 0x75, 0x88, 0x84, 0x6a, 0x53, 0xa4, 0x0c, 0x16, 0x49, 0x25,
	0xfa, 0x19, 0x58, 0xf0, 0xb0, 0xef, 0x74, 0xbd, 0x06, 0x36, 0xb8, 0x4b, 0x8a, 0xb9, 0x39, 0x5e,
	0x49, 0xd3, 0x6d, 0x29, 0x27, 0x57, 0x75, 0x0e, 0x28, 0xfb, 0xa5, 0xb2, 0x5e, 0xac, 0x90, 0x9c,
	0x19, 0x14, 0xad, 0x71, 0xdb, 0xb2, 0x5b, 0xd8, 0x73, 0x3d, 0xa2, 0x38, 0xe5, 0xd8, 0xd2, 0xa7,
	0x15, 0x6f, 0x45, 0xe5, 0x44, 0xee, 0xda, 0xf4, 0xc4, 0x35, 0xcc, 0x3d, 0xb3, 0x91, 0x47, 0xc3,
	0xe4, 0x2e, 0x3a, 0x9e, 0x75, 0x68, 0x47, 0x47, 0x75, 0x19, 0xb2, 0x71, 0xeb, 0x22, 0xbf, 0x44,
	0x31, 0x5d, 0x18, 0xf1, 0x10, 0xd6, 0xe7, 0x63, 0x06, 0x05, 0xfa, 0x19, 0x58, 0xa6, 0x27, 0xa3,
	0xe0, 0xb6, 0xc0, 0xca, 0x1c, 0x38, 0x57, 0x52, 0xb4, 0xb6, 0xbe, 0x93, 0x56, 0x47, 0x96, 0xdb,
	0x77, 0xfa, 0x7e, 0x55, 0x81, 0xa7, 0xa4, 0xf5, 0xc6, 0x34, 0x1e, 0x83, 0xd3, 0x10, 0x8a, 0xe7,
	0x0a, 0xed, 0xed, 0xf5, 0xa3, 0xea, 0x4c, 0xfa, 0xb9, 0x4e, 0xba, 0xf2, 0x76, 0x0b, 0x50, 0xc7,
	0xb4, 0xec, 0x00, 0xdb, 0xd4, 0x49, 0xc5, 0xc7, 0x78, 0x72, 0x98, 0x1d, 0xbb, 0x13, 0xc1, 0xf0,
	0x21, 0x2e, 0x76, 0x7a, 0x8b, 0xd0, 0x5f, 0x82, 0xe5, 0x3d, 0xba, 0xa7, 0x87, 0x03, 0xa4, 0xe3,
	0xcf, 0xe7, 0x87, 0x99, 0x7b, 0x09, 0x27, 0x81, 0xbe, 0xb4, 0x97, 0x70, 0x3c, 0xd8, 0x50, 0x20,
	0xe6, 0x71, 0xb8, 0x39, 0xc7, 0xcd, 0xca, 0x53, 0xc3, 0x1c, 0x1c, 0x03, 0x0e, 0x10, 0xfd, 0xa4,
	0x3b, 0xe0, 0x64, 0x29, 0xc3, 0xac, 0x6c, 0x8a, 0x17, 0x86, 0x89, 0x02, 0x5f, 0x33, 0xb2, 0x11,
	0x2e, 0x23, 0x90, 0x65, 0x96, 0xd3, 0x7c, 0x7a, 0x44, 0x99, 0xe5, 0x94, 0x0a, 0x99, 0xe5, 0xf4,
	0x3d, 0x07, 0xc2, 0x82, 0x31, 0xf8, 0xc6, 0x97, 0x3f, 0x43, 0xf6, 0x01, 0xba, 0xd7, 0x67, 0xdd,
	0x98, 0xad, 0x86, 0x5e, 0x1b, 0x68, 0x3b, 0x9d, 0x0d, 0x95, 0xa5, 0x44, 0xfb, 0xe9, 0x3d, 0x38,
	0xdd, 0xc4, 0xb7, 0xcd, 0x6e, 0x3b, 0x30, 0x3a, 0xe6, 0x7d, 0xc3, 0x75, 0x9a, 0x54, 0x5c, 0xfd,
	0xc0, 0x23, 0x22, 0x90, 0x3f, 0x37, 0x5c, 0x78, 0xee, 0x57, 0x9d, 0x26, 0x91, 0x40, 0x0e, 0xa2,
	0xe7, 0x39, 0xbe, 0xbe, 0x1a, 0x14, 0xc0, 0x99, 0x70, 0xa7, 0xea, 0xfa, 0x66, 0x0b, 0x1b, 0xf8,
	0xbe, 0xeb, 0x78, 0x81, 0xe0, 0xd7, 0x53, 0xb4, 0xb3, 0x14, 0x1b, 0x4a, 0x6c, 0x57, 0xbb, 0x04,
	0x58, 0xa3, 0xb0, 0x9c, 0x77, 0xa7, 0xbc, 0x41, 0x55, 0xc8, 0x87, 0xd3, 0xa6, 0xac, 0x27, 0xb0,
	0x53, 0x3f, 0x5c, 0x94, 0xea, 0xb0, 0x4e, 0x07, 0x2a, 0x19, 0xfa, 0x29, 0x73, 0xa0, 0xfe, 0xd1,
	0x84, 0x95, 0x9e, 0xc9, 0x13, 0xfd, 0x7d, 0x8a, 0xf6, 0xb7, 0x9a, 0x22, 0xc8, 0x09, 0x56, 0xb8,
	0xbe, 0xec, 0x26, 0xd9, 0xe6, 0xef, 0x41, 0xfe, 0x2e, 0xf6, 0x48, 0xff, 0xfd, 0xae, 0xa5, 0x0b,
	0xc3, 0x7c, 0xd3, 0x37, 0x39, 0x64, 0x8f, 0x63, 0x69, 0xe5, 0x6e, 0x62, 0x39, 0x3a, 0x0d, 0x33,
	0x3e, 0x6e, 0xdf, 0x36, 0xda, 0x96, 0x7d, 0x87, 0xbb, 0x00, 0xa7, 0x49, 0xc1, 0xb6, 0x65, 0xdf,
	0x41, 0x2b, 0x30, 0xfe, 0x81, 0x63, 0x73, 0x47, 0x1f, 0x15, 0x36, 0xfa, 0x4d, 0xac, 0xd1, 0xd0,
	0xd6, 0x66, 0xde, 0xbd, 0xf0, 0x9b, 0x9c, 0x77, 0x42, 0x3f, 0x12, 0x2c, 0xba, 0x8b, 0x3d, 0x9f,
	0x6c, 0x2a, 0x2d, 0xa6, 0xbc, 0xf2, 0x6a, 0x3e, 0xe6, 0x9b, 0xac, 0x92, 0x3a, 0x26, 0xbb, 0x9e,
	0x87, 0x6d, 0x22, 0xb1, 0x31, 0xb0, 0x7d, 0xae, 0x5c, 0xb3, 0x5a, 0xb6, 0x99, 0x46, 0x50, 0xa2,
	0x9c, 0x69, 0x63, 0x02, 0xc6, 0x0a, 0x29, 0x46, 0xbc, 0x9e, 0x9c, 0xdc, 0x02, 0xea, 0x49, 0x98,
	0xe5, 0xf6, 0x52, 0x60, 0x75, 0x70, 0xfe, 0x3d, 0xa6, 0x15, 0xb0, 0xa2, 0xba, 0xd5, 0xc1, 0xe8,
	0xf3, 0x30, 0xe9, 0x07, 0x66, 0xd0, 0xf5, 0xf3, 0x77, 0xa8, 0x95, 0x78, 0x71, 0xf8, 0x99, 0x5b,
	0xa3, 0xed, 0x75, 0x0e, 0x87, 0x2e, 0x41, 0x96, 0xfd, 0x32, 0x3a, 0xd8, 0x27, 0xc2, 0x9b, 0x6f,
	0x87, 0x24, 0xcd, 0xb3, 0x9a, 0x1d, 0x56, 0x41, 0xd4, 0xf0, 0x1e, 0x03, 0xc1, 0xb7, 0x3e, 0xc0,
	0xf9, 0x0e, 0xbd, 0x2d, 0xca, 0xc9, 0xf6, 0x41, 0xcd, 0xfa, 0x00, 0xa3, 0x2b, 0x89, 0xc6, 0x93,
	0xcd, 0x4e, 0xee, 0x3e, 0xc3, 0xe9, 0x2a, 0x2c, 0x85, 0xd7, 0x1b, 0x74, 0x85, 0x18, 0x5d, 0xaf,
	0xed, 0xe7, 0x1d, 0xa2, 0xa6, 0x50, 0x62, 0x16, 0x45, 0x35, 0x15, 0xf4, 0x5d, 0xaf, 0xed, 0x13,
	0x15, 0x37, 0xc6, 0x54, 0xa6, 0xe2, 0xba, 0x91, 0x8a, 0x2b, 0xb1, 0x94, 0xa9, 0xb8, 0x4f, 0xc2,
	0x2c, 0xbe, 0xef, 0x5a, 0x1e, 0x67, 0xe8, 0xfb, 0x8c, 0xa1, 0xac, 0x88, 0x32, 0xb4, 0x00, 0xd3,
	0xe2, 0x6c, 0xcd, 0x7b, 0x4c, 0x62, 0xc4, 0x37, 0xb1, 0xf6, 0xb9, 0x86, 0x14, 0xb8, 0xdd, 0xbc,
	0x4f, 0x95, 0xa2, 0x19, 0x56, 0x52, 0x77, 0xbb, 0x83, 0xac, 0x94, 0x20, 0xd9, 0x4a, 0x41, 0x7f,
	0x11, 0x96, 0x9a, 0x66, 0x60, 0xee, 0x99, 0x3e, 0x36, 0xb0, 0xdd, 0xf0, 0x0e, 0x98, 0x26, 0xff,
	0xec, 0xb0, 0x73, 0x60, 0x83, 0x03, 0x69, 0x21, 0x8c, 0x8e, 0x9a, 0x7d, 0x65, 0x68, 0x0b, 0x80,
	0x18, 0x86, 0x16, 0xd3, 0xf6, 0xee, 0x52, 0x8d, 0xec, 0x52, 0xca, 0x4d, 0x11, 0x9d, 0xe9, 0x92,
	0x80, 0xd0, 0x25, 0xe0, 0x42, 0x11, 0x96, 0x12, 0x14, 0xb5, 0x43, 0xdd, 0xf0, 0xdc, 0x83, 0x49,
	0xd6, 0x03, 0x5a, 0x01, 0x54, 0xab, 0x17, 0xeb, 0xbb, 0xb5, 0x1e, 0x1f, 0x43, 0x0e, 0xe6, 0xa8,
	0xf7, 0xa1, 0xb6, 0x55, 0x29, 0x6f, 0x95, 0x37, 0x73, 0x0a, 0x9a, 0x85, 0x29, 0x7d, 0xb7, 0x4c,
	0x3f, 0x32, 0x68, 0x01, 0x66, 0x75, 0xad, 0x54, 0x29, 0x97, 0xb6, 0xb6, 0x49, 0xc1, 0x18, 0x9a,
	0x83, 0xe9, 0x5a, 0xbd, 0x52, 0xad, 0x92, 0xaf, 0x71, 0x34, 0x03, 0x13, 0x9a, 0xae, 0x57, 0xf4,
	0xdc, 0x04, 0xa9, 0xd8, 0xd0, 0x36, 0xf5, 0xe2, 0x86, 0xb6, 0x91, 0x9b, 0x54, 0xbf, 0x3f, 0x0b,
	0xf3, 0x5c, 0xf2, 0x77, 0xdd, 0xa6, 0x19, 0x60, 0xf4, 0x02, 0x2c, 0x37, 0xb1, 0x6f, 0x79, 0x44,
	0x41, 0x92, 0x57, 0x22, 0xf3, 0xda, 0x21, 0x5e, 0x27, 0xaf, 0xc2, 0xcf, 0x40, 0x41, 0x40, 0x24,
	0x18, 0x19, 0xcc, 0x87, 0x97, 0xe7, 0x2d, 0x76, 0xfa, 0x6c, 0x8d, 0x5b, 0x70, 0x42, 0x40, 0xc7,
	0xad, 0x85, 0xc9, 0x43, 0x59, 0x0b, 0x4b, 0x1c, 0x49, 0xec, 0xea, 0x60, 0xad, 0x67, 0x2c, 0xc4,
	0x38, 0x30, 0xac, 0xa6, 0x30, 0x7c, 0xa4, 0xb1, 0x10, 0x0b, 0x60, 0xab, 0x49, 0xd6, 0xa4, 0x00,
	0x90, 0x6e, 0x97, 0x99, 0x0d, 0x94, 0xe3, 0x35, 0x5b, 0xe1, 0x25, 0xb3, 0x0b, 0x67, 0xfb, 0xd1,
	0xcb, 0x9b, 0xfc, 0xcc, 0x50, 0x67, 0x3b, 0xef, 0x5a, 0xde, 0xe1, 0x0b, 0x3d, 0x64, 0xc9, 0xbb,
	0xfc, 0x73, 0x20, 0x88, 0x36, 0x22, 0x53, 0x05, 0xa8, 0xa9, 0x22, 0xc8, 0xdb, 0x0e, 0x2d, 0x96,
	0x6f, 0x29, 0x70, 0x29, 0x9c, 0x98, 0xa1, 0xda, 0xef, 0xdc, 0x31, 0xb5, 0xdf, 0x4f, 0x89, 0x19,
	0x4e, 0x57, 0x82, 0x1f, 0x80, 0x2a, 0x68, 0x4a, 0x51, 0x27, 0xb3, 0x47, 0x55, 0x27, 0xcf, 0x71,
	0xe4, 0x83, 0xfc, 0x15, 0x6d, 0xa2, 0x4f, 0xb1, 0xee, 0xc5, 0xa9, 0x26, 0x4f, 0xd8, 0xc2, 0x11,
	0xb4, 0xcc, 0x53, 0x1c, 0x61, 0x7f, 0x15, 0x72, 0xe0, 0x8c, 0xe8, 0x2d, 0x51, 0x3b, 0xcf, 0x1d,
	0x45, 0x3b, 0x17, 0xf2, 0x91, 0xe4, 0xc3, 0x79, 0x15, 0x4e, 0x46, 0xf2, 0x11, 0x77, 0x0c, 0x2c,
	0xb1, 0x43, 0x3b, 0x94, 0x92, 0x98, 0x7f, 0xe0, 0xab, 0x0a, 0x3c, 0x23, 0x00, 0x53, 0x75, 0xc0,
	0x13, 0x47, 0xd7, 0x01, 0xcf, 0xf3, 0x0e, 0x06, 0xb6, 0x40, 0x07, 0x20, 0xda, 0x18, 0x03, 0xf5,
	0xa6, 0x95, 0x23, 0xea, 0x4d, 0x62, 0xa5, 0x26, 0x57, 0xc7, 0x18, 0x60, 0xd9, 0x81, 0x67, 0xf2,
	0xcd, 0xcf, 0xf2, 0xad, 0x3d, 0xab, 0x4d, 0x04, 0x94, 0x33, 0xa0, 0x30, 0x8c, 0x01, 0x5b, 0x04,
	0x9a, 0x6e, 0x8f, 0x21, 0x6c, 0x0f, 0x03, 0x06, 0xb6, 0x20, 0xba, 0x53, 0xcf, 0x82, 0x15, 0xbb,
	0x2f, 0xbf, 0xd4, 0x8d, 0xad, 0x31, 0xbe, 0xff, 0xaa, 0xff, 0x6b, 0x1a, 0x66, 0x2a, 0x2e, 0xf6,
	0x98, 0x08, 0x24, 0x79, 0xc3, 0x84, 0xfe, 0x97, 0xe9, 0xd1, 0xff, 0x2a, 0x90, 0x75, 0x04, 0x20,
	0xdb, 0xea, 0xc6, 0x86, 0xa9, 0x49, 0x61, 0x47, 0xab, 0x64, 0x0b, 0xd4, 0xe7, 0x43, 0x78, 0xba,
	0x23, 0xae, 0x87, 0xfa, 0xd6, 0xf8, 0xb0, 0xab, 0xfe, 0x08, 0x51, 0x8f, 0xc6, 0xb5, 0x02, 0x93,
	0x4d, 0x1c, 0x98, 0x56, 0x9b, 0xef, 0xbb, 0xfc, 0x2b, 0x41, 0x13, 0x9b, 0x18, 0xa4, 0x89, 0xc5,
	0x94, 0xe1, 0xc9, 0x1e, 0x65, 0xf8, 0x49, 0x98, 0x0d, 0x4c, 0xaf, 0x85, 0x03, 0x56, 0xcd, 0xce,
	0x02, 0x60, 0x45, 0xb4, 0x81, 0xac, 0xe3, 0xcc, 0xf4, 0xeb, 0x38, 0x7e, 0x60, 0x7a, 0x01, 0xd3,
	0x8f, 0x98, 0xeb, 0x77, 0x86, 0x96, 0x50, 0xf5, 0xe8, 0x14, 0x55, 0xa8, 0x59, 0x25, 0xf3, 0x51,
	0x4d, 0x61, 0xbb, 0x49, 0xab, 0x36, 0xe9, 0x95, 0x45, 0xcb, 0xc3, 0xbe, 0xcf, 0xf7, 0xda, 0xe7,
	0x46, 0x60, 0x4e, 0x95, 0x83, 0xe8, 0x21, 0x30, 0xfa, 0x22, 0x20, 0xc9, 0x66, 0x11, 0x1a, 0xcc,
	0xfc, 0x61, 0x35, 0x18, 0xe1, 0xc7, 0x0b, 0x4b, 0x7c, 0x74, 0x8b, 0x29, 0xb0, 0xf4, 0x18, 0x93,
	0x50, 0x67, 0x0f, 0x8b, 0x1a, 0x09, 0x2c, 0x11, 0x6e, 0x55, 0x1f, 0xaa, 0xe1, 0xcc, 0xc2, 0x54,
	0x55, 0x2b, 0x6f, 0x24, 0x28, 0x37, 0xd3, 0x30, 0xbe, 0x51, 0x29, 0x6b, 0x4c, 0xab, 0x29, 0xae,
	0x57, 0xf4, 0x3a, 0xd5, 0x6a, 0xd4, 0x3f, 0xcf, 0xc0, 0x38, 0x15, 0xbb, 0x65, 0xc8, 0xd5, 0xdf,
	0xa9, 0x6a, 0x3d, 0x08, 0x11, 0x64, 0x4b, 0xba, 0x56, 0xac, 0x6b, 0x46, 0x69, 0x7b, 0xb7, 0x56,
	0xd7, 0xf4, 0x9c, 0x42, 0xca, 0x36, 0xb4, 0x6d, 0x4d, 0x2a, 0xcb, 0x90, 0xb2, 0xdd, 0x2a, 0xd5,
	0x88, 0x8c, 0x9d, 0x22, 0x2d, 0x1b, 0x43, 0x8b, 0x30, 0x2f, 0xca, 0xca, 0x95, 0x0d, 0xad, 0x96,
	0x1b, 0x27, 0xcd, 0x74, 0xad, 0x5a, 0xdc, 0xd2, 0x43, 0xd0, 0x09, 0x06, 0xba, 0x21, 0x77, 0x31,
	0x49, 0x88, 0xe1, 0xdd, 0x12, 0x48, 0xa3, 0x5a, 0xa9, 0x6c, 0xe7, 0xa6, 0x48, 0x29, 0xef, 0x38,
	0x2a, 0x9d, 0x46, 0x67, 0x20, 0x5f, 0xd3, 0xea, 0x51, 0x91, 0xb1, 0x53, 0x2c, 0x17, 0x37, 0xb5,
	0x1d, 0xad, 0x5c, 0xcf, 0xcd, 0xa0, 0x13, 0xb0, 0x58, 0xdc, 0xad, 0x57, 0x0c, 0xde, 0x2d, 0x23,
	0x04, 0x08, 0x03, 0x69, 0x71, 0x9c, 0xc0, 0x59, 0x94, 0x05, 0x20, 0xc8, 0xb6, 0x8b, 0xeb, 0xda,
	0x76, 0x2d, 0x37, 0x87, 0x96, 0x60, 0x81, 0x7c, 0xb3, 0x31, 0x19, 0xc5, 0xdd, 0xfa, 0xf5, 0xdc,
	0x3c, 0xe5, 0x7e, 0xac, 0xc7, 0xda, 0xd6, 0x2d, 0x2d, 0x97, 0x0d, 0xcb, 0xb5, 0xfa, 0xdb, 0x15,
	0xfd, 0x86, 0x51, 0xad, 0x6c, 0x6f, 0x95, 0xde, 0xc9, 0x2d, 0xa0, 0x02, 0xac, 0x30, 0x24, 0x5b,
	0xe5, 0xba, 0x56, 0x2e, 0x96, 0x4b, 0x9a, 0xa8, 0xcb, 0xa9, 0xdf, 0x18, 0x83, 0xc5, 0x3e, 0x49,
	0x4d, 0xdc, 0x80, 0xa2, 0x7d, 0x21, 0x73, 0xe4, 0x7d, 0x61, 0x1b, 0xa6, 0x3a, 0x38, 0xf0, 0xac,
	0x06, 0x0b, 0x44, 0x4c, 0x8d, 0xcb, 0xe8, 0xa3, 0x6a, 0x75, 0x87, 0x82, 0xea, 0x02, 0x05, 0x2a,
	0x51, 0x8a, 0x5a, 0xd8, 0xe7, 0xd1, 0x88, 0x87, 0x5a, 0x8c, 0x1c, 0xb4, 0xf0, 0x75, 0x05, 0x26,
	0x19, 0xe2, 0xc4, 0x51, 0x9f, 0x85, 0x19, 0xcb, 0x0e, 0x8c, 0x48, 0xe7, 0x1f, 0xbb, 0xfe, 0x84,
	0x3e, 0x6d, 0xd9, 0xc1, 0x4d, 0x1a, 0x17, 0xf5, 0x34, 0xcc, 0x35, 0x9d, 0x2e, 0xb1, 0x97, 0x58,
	0x0b, 0xb2, 0xf7, 0x2a, 0xd7, 0x9f, 0xd0, 0x67, 0x59, 0x69, 0xd8, 0xc8, 0x0f, 0xa8, 0x42, 0xcd,
	0x1a, 0x51, 0x35, 0x9c, 0x34, 0x62, 0xa5, 0xb4, 0xd1, 0xfa, 0x14, 0x37, 0x2c, 0xd4, 0xdf, 0x50,
	0x60, 0xb9, 0x44, 0xcd, 0x5f, 0xae, 0x8d, 0xe8, 0xf8, 0xfd, 0x2e, 0xf6, 0x03, 0xf4, 0x0c, 0x80,
	0xeb, 0x39, 0xef, 0xe1, 0x46, 0x40, 0xf4, 0x5f, 0x4a, 0xe4, 0xfa, 0xc4, 0x8f, 0x8b, 0x64, 0xef,
	0x9c, 0xe1, 0x15, 0x5b, 0x4d, 0x74, 0x2a, 0x76, 0x4e, 0xf0, 0x7a, 0x76, 0x54, 0x7c, 0x1e, 0xa6,
	0x84, 0x9b, 0x8b, 0x45, 0xaa, 0x3c, 0x35, 0x54, 0x49, 0x5a, 0x1f, 0xfb, 0x71, 0x31, 0xa3, 0x0b,
	0x30, 0xb2, 0xaf, 0xbb, 0x26, 0x31, 0x37, 0xb9, 0x49, 0xc0, 0xbf, 0xd4, 0xaf, 0x2b, 0xb0, 0xb8,
	0x89, 0x83, 0x47, 0x4d, 0xf0, 0x33, 0x00, 0xe1, 0x4d, 0x05, 0x8b, 0xae, 0x89, 0x10, 0x88, 0x9b,
	0x8a, 0x66, 0x38, 0x6d, 0x13, 0xd1, 0xb4, 0xa9, 0xff, 0x41, 0x81, 0x65, 0x66, 0x0c, 0x7d, 0x3c,
	0x34, 0x6d, 0xc0, 0x64, 0x97, 0x76, 0xcf, 0xaf, 0x98, 0x2e, 0x0c, 0xe5, 0x34, 0xa3, 0x96, 0xf1,
	0x9b, 0xc3, 0x26, 0x8e, 0xec, 0x27, 0x19, 0x38, 0xc1, 0xda, 0x86, 0xf7, 0x1f, 0x8f, 0x77, 0x68,
	0x17, 0x60, 0x2e, 0x66, 0x88, 0x8d, 0xcb, 0xed, 0xc0, 0x8e, 0x0c, 0xb1, 0x67, 0x79, 0x43, 0xa1,
	0xff, 0xb0, 0xa3, 0x9e, 0x0e, 0x90, 0x5e, 0xc2, 0x09, 0xdb, 0x53, 0x8d, 0x85, 0x01, 0x4f, 0x46,
	0xad, 0xa4, 0x58, 0xe0, 0xc7, 0x19, 0xcb, 0x2a, 0xb8, 0x3e, 0x2d, 0x71, 0xfd, 0x6f, 0x65, 0xe0,
	0x6c, 0x0d, 0x07, 0x49, 0xb6, 0xde, 0x27, 0x94, 0xfb, 0xf5, 0xb8, 0xef, 0x7d, 0xe2, 0x08, 0x66,
	0x2c, 0x9f, 0x2b, 0xd9, 0x03, 0x2f, 0x78, 0x33, 0x29, 0xf1, 0xe6, 0xfb, 0x0a, 0xe4, 0x6b, 0x38,
	0x88, 0x9b, 0x23, 0x87, 0x63, 0xcb, 0xc9, 0x18, 0x5b, 0x68, 0xb7, 0x87, 0x61, 0xca, 0x95, 0xfe,
	0x3b, 0xd4, 0xf1, 0x08, 0x53, 0xef, 0x45, 0x6a, 0xd2, 0xaa, 0xfa, 0xb7, 0x0a, 0x9c, 0xae, 0xe1,
	0xa0, 0xcf, 0xb5, 0xf1, 0x98, 0x67, 0xf7, 0x6a, 0xe2, 0x1d, 0xaf, 0x34, 0x96, 0x84, 0x8b, 0xde,
	0xa4, 0x29, 0xf9, 0x53, 0x05, 0x56, 0x6a, 0x38, 0x88, 0x79, 0x57, 0x1e, 0xef, 0x48, 0xaa, 0xbd,
	0x17, 0xc7, 0xe3, 0x87, 0x71, 0x05, 0xb1, 0xc1, 0xc6, 0x6f, 0x8f, 0x93, 0xc6, 0xf9, 0x9b, 0x0a,
	0x2c, 0x51, 0xd1, 0xe3, 0xfe, 0x92, 0xc7, 0x3c, 0xc8, 0xa7, 0xe4, 0xdb, 0xe6, 0x71, 0xea, 0xc6,
	0x65, 0x1b, 0x57, 0x74, 0xe5, 0x9c, 0x44, 0xf5, 0xbf, 0x54, 0x60, 0x89, 0x6d, 0xe1, 0xcc, 0x08,
	0x7c, 0xcc, 0x54, 0x5f, 0x86, 0x6c, 0x8f, 0x65, 0x2a, 0x09, 0xd8, 0x7c, 0x27, 0xe6, 0xd3, 0x17,
	0xe4, 0x4f, 0x49, 0xe4, 0xff, 0x59, 0x06, 0x96, 0xc9, 0x5a, 0x89, 0xe2, 0x19, 0x1e, 0x2f, 0xfd,
	0x3a, 0x4c, 0x9a, 0x8d, 0x40, 0xd0, 0x9d, 0x4d, 0xbb, 0x84, 0x4f, 0x22, 0x73, 0xb5, 0x48, 0x81,
	0xf9, 0x49, 0xcb, 0x30, 0xa1, 0x62, 0x78, 0x5e, 0x1f, 0x22, 0x8e, 0x23, 0xf9, 0xb0, 0x96, 0x59,
	0x55, 0x85, 0x49, 0xd6, 0x1b, 0x31, 0x86, 0x76, 0xcb, 0x37, 0xca, 0x95, 0xb7, 0xcb, 0xcc, 0x11,
	0x4c, 0x14, 0xf2, 0x6a, 0xb1, 0x56, 0x7b, 0xbb, 0xa2, 0x6f, 0xe4, 0x14, 0x62, 0x26, 0x6c, 0x6a,
	0x65, 0x4d, 0x27, 0x26, 0x47, 0x58, 0x9c, 0x11, 0x0d, 0x77, 0x6b, 0x9a, 0x5e, 0x2e, 0xee, 0x68,
	0xb9, 0x31, 0xf5, 0x9b, 0x0a, 0x2c, 0x6f, 0xe0, 0x36, 0xfe, 0xb8, 0x14, 0x1b, 0x31, 0xca, 0x71,
	0x69, 0x94, 0x36, 0x2c, 0x6d, 0x5b, 0xbe, 0xd0, 0xfe, 0x1e, 0xdd, 0x22, 0x8c, 0xb4, 0xcd, 0xf1,
	0x98, 0xb6, 0xf9, 0x01, 0x2c, 0xc7, 0xfb, 0xf3, 0x5d, 0xc7, 0xf6, 0x31, 0x7a, 0x13, 0xa6, 0x39,
	0xa1, 0x7e, 0x5e, 0xa1, 0x16, 0xc1, 0x70, 0x05, 0x57, 0x0f, 0x41, 0xd0, 0xd3, 0x30, 0xdf, 0xb1,
	0x7c, 0x9f, 0xec, 0xbc, 0xa4, 0x7b, 0x16, 0x80, 0x39, 0xa3, 0xcf, 0xf1, 0xc2, 0x5b, 0xa4, 0x4c,
	0xfd, 0x79, 0x05, 0x96, 0x36, 0x71, 0x10, 0xda, 0x13, 0x8f, 0x6c, 0xb0, 0x17, 0x61, 0x2e, 0xf2,
	0xe3, 0xf4, 0x4e, 0xc0, 0x6c, 0x58, 0x35, 0x40, 0xdf, 0x75, 0xe1, 0x04, 0x61, 0x49, 0x48, 0xd6,
	0x47, 0x3f, 0x09, 0xbf, 0xa8, 0xc0, 0x4a, 0xc9, 0xb4, 0x1b, 0xb8, 0xfd, 0x49, 0xe0, 0x85, 0x2c,
	0x8e, 0x5f, 0x51, 0x60, 0xa5, 0x97, 0x19, 0x5c, 0x42, 0x4a, 0x00, 0x21, 0xb4, 0x90, 0x91, 0xa7,
	0x47, 0xb0, 0x1a, 0x75, 0x09, 0x6c, 0x34, 0x39, 0xe9, 0xc0, 0xca, 0x26, 0x0e, 0xc8, 0x19, 0x1d,
	0x5e, 0x30, 0x3f, 0x2a, 0xee, 0x24, 0x8d, 0xf9, 0x2f, 0x67, 0x60, 0x4e, 0xee, 0x8c, 0x79, 0x91,
	0x59, 0xd0, 0x41, 0xef, 0xd5, 0xaf, 0x22, 0xbc, 0xc8, 0xb4, 0xba, 0xe7, 0xea, 0x77, 0x15, 0x96,
	0xee, 0x9a, 0x6d, 0x2b, 0x7e, 0x71, 0x24, 0xd2, 0x06, 0x17, 0x69, 0x95, 0x74, 0x6f, 0xe4, 0xb3,
	0xdb, 0x16, 0xd6, 0x8f, 0xa4, 0xc4, 0x8f, 0x8b, 0xdb, 0x16, 0x5a, 0x13, 0xdd, 0xb6, 0x5c, 0x06,
	0x86, 0x42, 0x6a, 0xeb, 0xe7, 0x27, 0x28, 0xee, 0x05, 0x5a, 0x11, 0x36, 0xf5, 0xd1, 0x55, 0x38,
	0xc1, 0xda, 0xc6, 0x0f, 0x2b, 0x96, 0x0d, 0x38, 0xa3, 0x33, 0x32, 0x63, 0x5e, 0x54, 0x5f, 0xfd,
	0x8f, 0x0a, 0x9c, 0x60, 0xb6, 0xf3, 0xc7, 0x64, 0x1c, 0x6d, 0xc0, 0x4c, 0xa8, 0x9e, 0x73, 0x95,
	0x67, 0x84, 0x08, 0x36, 0x76, 0x90, 0x4c, 0x0b, 0xed, 0x5d, 0x5a, 0x73, 0x93, 0xb1, 0x35, 0xf7,
	0x2f, 0x14, 0x38, 0xc1, 0x36, 0xff, 0x4f, 0xba, 0xed, 0x97, 0xa4, 0xf6, 0x7c, 0x5b, 0x61, 0xfb,
	0xb6, 0xa0, 0xfd, 0x71, 0x6b, 0x6b, 0x83, 0x9c, 0x17, 0xbf, 0xa3, 0x00, 0xda, 0x8c, 0x6c, 0xbb,
	0x9f, 0x26, 0x96, 0xfe, 0x68, 0x12, 0xa6, 0x05, 0xdd, 0x89, 0xee, 0xab, 0xcf, 0xc0, 0x24, 0xd7,
	0xbf, 0x33, 0xa3, 0x87, 0xba, 0xea, 0x1c, 0x86, 0x2c, 0xee, 0x41, 0xf1, 0xb5, 0x09, 0xb1, 0xb5,
	0xa9, 0xe1, 0x2b, 0x79, 0x98, 0x12, 0xfb, 0x0f, 0x4b, 0x55, 0x13, 0x9f, 0x64, 0xc7, 0x49, 0x8a,
	0x8a, 0xb8, 0xcd, 0x76, 0x9c, 0xfe, 0x88, 0x88, 0x62, 0xe8, 0x87, 0x6c, 0x51, 0xf5, 0xef, 0xd2,
	0xf0, 0xf5, 0x35, 0x3c, 0x20, 0x64, 0x7f, 0xd0, 0x35, 0x44, 0x25, 0x6e, 0x46, 0x8f, 0x1f, 0xe5,
	0x36, 0x38, 0x66, 0x41, 0x5f, 0x07, 0xe8, 0x98, 0xb6, 0xd9, 0xc2, 0x1d, 0x21, 0x89, 0xa9, 0x29,
	0x52, 0x04, 0xdf, 0x4e, 0xd8, 0x5e, 0x97, 0x60, 0xd1, 0x97, 0x60, 0x29, 0x29, 0x9e, 0x6c, 0xf2,
	0xf0, 0xf1, 0x64, 0x8b, 0x9d, 0xbe, 0x40, 0xb2, 0x78, 0x6c, 0x85, 0x75, 0x8c, 0xd8, 0x0a, 0xf4,
	0x1c, 0x20, 0xd7, 0x69, 0xf6, 0x86, 0xd4, 0xb0, 0x04, 0xec, 0x05, 0xd7, 0x69, 0xca, 0x11, 0x35,
	0xea, 0x97, 0x95, 0xe3, 0x86, 0x51, 0xac, 0x00, 0xe2, 0x1f, 0xc6, 0xdb, 0x5b, 0xf5, 0xeb, 0x06,
	0x0b, 0x9a, 0x18, 0xeb, 0x0d, 0xaf, 0x18, 0x8f, 0x85, 0x57, 0x4c, 0x44, 0xe1, 0x15, 0x93, 0xea,
	0xaf, 0x2a, 0x90, 0x8d, 0xf3, 0x1d, 0x3d, 0x05, 0x73, 0x64, 0x12, 0x8d, 0xae, 0xdb, 0xf2, 0xcc,
	0xa6, 0xc8, 0x7f, 0xa4, 0x13, 0xbb, 0xcb, 0x8a, 0xd0, 0x93, 0x4c, 0x52, 0x0c, 0x0f, 0xbb, 0xa6,
	0xe5, 0xf1, 0x94, 0x0f, 0x20, 0x45, 0x3a, 0x2d, 0x41, 0xbb, 0xb0, 0xc0, 0xc1, 0x0d, 0xc7, 0x15,
	0xd7, 0xfe, 0x43, 0xee, 0xaa, 0x8b, 0x51, 0x07, 0x15, 0x06, 0xa3, 0x67, 0xbb, 0xb1, 0x6f, 0xb5,
	0x03, 0xa8, 0xbf, 0x15, 0x7a, 0x05, 0x4e, 0xca, 0x04, 0x1b, 0xd2, 0x8d, 0x17, 0xdb, 0x1f, 0x96,
	0x25, 0xda, 0x6b, 0xe1, 0xe5, 0xd7, 0xd0, 0x98, 0x7b, 0xf5, 0xab, 0x0a, 0x2c, 0xf6, 0x85, 0xb3,
	0xa2, 0x12, 0x4c, 0xde, 0xb3, 0xec, 0xa6, 0x73, 0x6f, 0x78, 0x4e, 0xa7, 0x04, 0xfc, 0x36, 0x05,
	0xd1, 0x39, 0x28, 0xba, 0x04, 0xb9, 0xf0, 0xe2, 0x5a, 0x6c, 0x16, 0x2c, 0x1d, 0x26, 0x0c, 0xbf,
	0x16, 0xf7, 0xa5, 0xff, 0x7e, 0x2c, 0x46, 0x05, 0x43, 0x84, 0xda, 0x90, 0x6f, 0x9a, 0x56, 0xfb,
	0xc0, 0x90, 0x63, 0x74, 0x39, 0x5d, 0x99, 0x61, 0x5e, 0xc2, 0x0d, 0x02, 0xd9, 0x87, 0xf3, 0xfa,
	0x13, 0xfa, 0x4a, 0x33, 0xb1, 0x06, 0xdd, 0x22, 0xe4, 0x36, 0xba, 0x1e, 0xf5, 0xd5, 0xf0, 0x5e,
	0x86, 0x66, 0x80, 0xea, 0x02, 0x82, 0xb0, 0x3b, 0xec, 0x62, 0x21, 0x44, 0xc4, 0x71, 0x3f, 0x80,
	0x15, 0x79, 0x0c, 0xf8, 0x3e, 0x39, 0x30, 0x42, 0x37, 0xc3, 0xec, 0xd5, 0xb7, 0x0e, 0xc1, 0x5f,
	0xb9, 0x44, 0x0b, 0x11, 0xb1, 0x48, 0xf4, 0x13, 0x9d, 0xa4, 0xba, 0x82, 0x0d, 0x85, 0xc1, 0x40,
	0x09, 0x51, 0x51, 0xd7, 0xe4, 0xa8, 0xa8, 0xd4, 0x53, 0x26, 0x1a, 0xb6, 0x14, 0x3b, 0xb5, 0x3e,
	0x0d, 0x93, 0x2c, 0x78, 0x44, 0xfd, 0x59, 0x80, 0xa8, 0x09, 0xfa, 0x74, 0xec, 0xaa, 0x96, 0x89,
	0x56, 0x41, 0x20, 0x17, 0xef, 0x68, 0x50, 0x9c, 0xf4, 0x1d, 0x0d, 0xf9, 0x1a, 0xf7, 0x15, 0xe9,
	0x1a, 0x37, 0x33, 0x14, 0x50, 0x5c, 0xf1, 0xaa, 0x3e, 0x2c, 0x25, 0x4c, 0x11, 0x39, 0x47, 0x63,
	0xf2, 0x3d, 0xda, 0x08, 0x85, 0x60, 0x9f, 0x03, 0x60, 0x13, 0x8c, 0xed, 0x86, 0x88, 0x1c, 0x93,
	0x4a, 0xd4, 0x1a, 0xac, 0x24, 0x4b, 0x5f, 0xcf, 0x5d, 0x75, 0xa6, 0xf7, 0xae, 0xba, 0x00, 0xd3,
	0xcd, 0x2e, 0xb3, 0x4b, 0xf8, 0x4a, 0x09, 0xbf, 0xd5, 0x6f, 0x66, 0xe0, 0x8c, 0xe4, 0xb2, 0x96,
	0x0e, 0x91, 0x4f, 0xa8, 0x82, 0xb3, 0x73, 0x9c, 0x93, 0x91, 0xa9, 0xd0, 0xf2, 0xf1, 0x98, 0xe4,
	0x8f, 0xf9, 0x31, 0xf3, 0x8b, 0x0a, 0x9e, 0x90, 0x13, 0xe7, 0x93, 0xca, 0x0d, 0x95, 0x27, 0xc3,
	0x30, 0x9d, 0x6b, 0x82, 0x06, 0x7c, 0x32, 0xe7, 0xa2, 0x1d, 0x6a, 0x5c, 0x49, 0x43, 0xfc, 0x81,
	0x02, 0xe7, 0x74, 0xa7, 0xdd, 0xde, 0x33, 0x1b, 0x77, 0xc4, 0x38, 0xf9, 0x36, 0xff, 0xd3, 0xa4,
	0xd9, 0xde, 0x62, 0x0e, 0x0d, 0xc9, 0x56, 0xe0, 0x26, 0x7c, 0x3c, 0x49, 0x48, 0x39, 0x42, 0x92,
	0x90, 0xfa, 0x93, 0x0c, 0xa0, 0x84, 0x48, 0xaf, 0xcf, 0xc3, 0x19, 0x1e, 0xfb, 0x4a, 0x3b, 0x20,
	0xe7, 0x23, 0x4d, 0x2f, 0x25, 0x3b, 0x9f, 0x78, 0xad, 0x60, 0x5a, 0x2f, 0xb0, 0x36, 0x04, 0x6f,
	0xb1, 0xa7, 0x05, 0xaa, 0xca, 0x79, 0x42, 0x56, 0xc7, 0x0a, 0x44, 0x12, 0xef, 0x85, 0xe1, 0xc1,
	0x56, 0xdb, 0xa4, 0xbd, 0x94, 0x19, 0x44, 0xc1, 0xd1, 0xd7, 0x14, 0x78, 0xba, 0x97, 0x10, 0x29,
	0x50, 0x91, 0x1b, 0xd8, 0x3e, 0xd7, 0x4b, 0xaf, 0xa5, 0x2b, 0x12, 0x32, 0x12, 0xc1, 0x97, 0x0d,
	0x8e, 0x41, 0x3f, 0x6f, 0x0e, 0x69, 0x81, 0xde, 0x84, 0x42, 0x1f, 0x29, 0x91, 0xfb, 0x9b, 0x59,
	0xf1, 0xa7, 0x7a, 0x5b, 0x84, 0xae, 0x79, 0xd5, 0x86, 0xf3, 0xc3, 0x88, 0xe8, 0x7b, 0xad, 0x48,
	0x19, 0xe9, 0xb5, 0xa2, 0x4c, 0xd2, 0x6b, 0x45, 0xea, 0x3e, 0xcc, 0xc7, 0x78, 0x8b, 0x9e, 0x86,
	0xf9, 0x70, 0x76, 0xa4, 0x07, 0x95, 0xe6, 0x44, 0x21, 0xf5, 0x50, 0xe4, 0x61, 0xaa, 0x63, 0xd9,
	0x56, 0xa7, 0xdb, 0x61, 0xb7, 0xfd, 0xba, 0xf8, 0xa4, 0x35, 0xe6, 0x7d, 0x5a, 0x33, 0xc6, 0x6b,
	0xd8, 0xa7, 0xfa, 0x1d, 0x05, 0x96, 0x92, 0x22, 0x3d, 0x07, 0x67, 0x48, 0x3e, 0x03, 0xd9, 0x8e,
	0x65, 0xcb, 0x46, 0x15, 0x7b, 0xb9, 0x69, 0xae, 0x63, 0xd9, 0x91, 0x41, 0x45, 0x5a, 0x99, 0xf7,
	0xfb, 0x4d, 0xaf, 0xb9, 0x8e, 0x79, 0x3f, 0x6a, 0x75, 0x11, 0x16, 0x62, 0x4c, 0xc7, 0x6c, 0xa5,
	0x4d, 0xeb, 0xbd, 0xc5, 0xea, 0xff, 0xc8, 0x40, 0xae, 0x86, 0x03, 0x16, 0xe0, 0xfc, 0x98, 0x37,
	0x83, 0x76, 0x7f, 0x0a, 0x1d, 0xd3, 0x64, 0x3e, 0x9b, 0xea, 0xbd, 0x8f, 0xd1, 0x9a, 0x94, 0x4b,
	0xc7, 0xaf, 0xf8, 0x7a, 0x12, 0xea, 0x5e, 0x48, 0x4a, 0xa8, 0x93, 0xee, 0x9f, 0xfb, 0xb3, 0xea,
	0x12, 0xb6, 0xd2, 0x47, 0x11, 0x14, 0xfe, 0xeb, 0x0a, 0xbd, 0x2b, 0x91, 0x72, 0xf0, 0x1e, 0x2f,
	0xdb, 0xcf, 0x46, 0x22, 0x48, 0x85, 0x82, 0xc7, 0x73, 0x08, 0x39, 0x4c, 0xda, 0x79, 0x7f, 0x9f,
	0x9c, 0x91, 0x44, 0xc3, 0xd8, 0xaa, 0xea, 0xfc, 0x61, 0xb4, 0x8f, 0xe9, 0x8e, 0x41, 0xa2, 0x0a,
	0x3d, 0x0f, 0xc8, 0x23, 0xd4, 0x60, 0xa3, 0xe1, 0xe1, 0x26, 0xb6, 0x03, 0xcb, 0x6c, 0xfb, 0x74,
	0xb6, 0xa6, 0xf5, 0x45, 0x56, 0x53, 0x8a, 0x2a, 0xd4, 0x5f, 0x50, 0xe0, 0x54, 0xc9, 0xe9, 0xb8,
	0x6d, 0x1c, 0xe0, 0x8f, 0x7d, 0x1c, 0xf2, 0xf1, 0x7c, 0x07, 0x16, 0xfb, 0x9e, 0xff, 0x42, 0xcf,
	0xc1, 0xa2, 0xf4, 0x00, 0x18, 0x5f, 0xeb, 0x0a, 0xdd, 0x64, 0x72, 0xa6, 0xdc, 0x9a, 0xac, 0xf7,
	0x4b, 0x20, 0x97, 0xb1, 0x9d, 0x8c, 0xc9, 0xdd, 0x82, 0x54, 0x4e, 0x36, 0x33, 0xf5, 0xb7, 0x14,
	0x58, 0x49, 0x0e, 0x7e, 0x40, 0x7b, 0x30, 0x4f, 0xf7, 0x95, 0xf0, 0x41, 0x37, 0xf6, 0x04, 0xc3,
	0x9b, 0x87, 0x8d, 0xa2, 0x60, 0x6a, 0x18, 0x2f, 0x62, 0x4f, 0x0b, 0x88, 0x2f, 0xf5, 0x35, 0x98,
	0x93, 0x6b, 0x89, 0x05, 0xde, 0xf7, 0xe8, 0x42, 0x4d, 0x2b, 0xed, 0xea, 0x5a, 0x4e, 0x21, 0xbf,
	0xb5, 0x2f, 0x56, 0x2b, 0x35, 0x2d, 0x97, 0x51, 0xff, 0x9b, 0x02, 0x27, 0x89, 0x9a, 0x16, 0xcb,
	0x37, 0x7d, 0xbc, 0x73, 0x57, 0xeb, 0x4b, 0x8f, 0x1d, 0x3f, 0x54, 0x7a, 0x2c, 0xbf, 0x4d, 0x8d,
	0xe7, 0xc8, 0x26, 0x2d, 0xb7, 0x9f, 0xf0, 0xc8, 0x83, 0xbe, 0x0c, 0x51, 0x3e, 0x5e, 0x35, 0x61,
	0xbc, 0x4c, 0x0f, 0x1c, 0x21, 0x7c, 0x42, 0x4d, 0x18, 0x2b, 0x03, 0x8e, 0x46, 0x6a, 0x24, 0xa6,
	0xb4, 0x8e, 0x1f, 0x3a, 0xa5, 0x55, 0x04, 0x28, 0xf4, 0xf9, 0x06, 0x92, 0xee, 0xab, 0x5e, 0x62,
	0xae, 0xe0, 0xbe, 0x8b, 0xfb, 0xd3, 0xa1, 0x8f, 0x56, 0x1a, 0xa9, 0x70, 0xd4, 0x7e, 0x59, 0x61,
	0x4a, 0xa1, 0x04, 0xc5, 0x95, 0xc2, 0xcf, 0xcb, 0x17, 0xf1, 0x43, 0x75, 0x42, 0x01, 0x2f, 0xdf,
	0xd3, 0x3f, 0x0b, 0x0b, 0x36, 0xbe, 0x1f, 0x18, 0x2e, 0xbd, 0x97, 0x70, 0xee, 0x60, 0xe1, 0xfc,
	0x98, 0x27, 0xc5, 0x55, 0xb3, 0x85, 0xeb, 0xa4, 0x50, 0xfd, 0xa1, 0x02, 0xd3, 0x02, 0x1e, 0x95,
	0x60, 0x3c, 0x54, 0x24, 0xb2, 0x57, 0xd7, 0x86, 0xf7, 0x18, 0xfe, 0xa0, 0x81, 0xd7, 0x14, 0x38,
	0x64, 0x4f, 0x26, 0xfe, 0xf4, 0x81, 0x87, 0x1b, 0x4e, 0xa7, 0x83, 0xed, 0x26, 0x66, 0x13, 0x37,
	0xad, 0xcb, 0x45, 0x6a, 0x09, 0xe6, 0x64, 0x5c, 0xe8, 0x2c, 0x9c, 0xda, 0xae, 0x94, 0x8a, 0xf5,
	0xad, 0x4a, 0xd9, 0x48, 0x88, 0xa3, 0x9d, 0x86, 0xf1, 0x5b, 0x95, 0x32, 0x5f, 0x67, 0xba, 0xb6,
	0xb9, 0x55, 0x29, 0xe7, 0x32, 0xea, 0xff, 0x53, 0x60, 0xa1, 0xc7, 0x73, 0x87, 0xd6, 0x61, 0xbc,
	0xe1, 0x34, 0xc5, 0x98, 0x56, 0x47, 0x76, 0xf9, 0xad, 0x96, 0xe8, 0x43, 0x3b, 0x04, 0x96, 0xaa,
	0x4a, 0xdc, 0xb1, 0xca, 0x46, 0x25, 0x3e, 0xd5, 0xbf, 0xae, 0xc0, 0x38, 0x69, 0xd8, 0x77, 0x1f,
	0xbe, 0x59, 0xd2, 0x8c, 0x5a, 0xbd, 0x52, 0xba, 0x51, 0xd9, 0xad, 0xe7, 0x14, 0xf4, 0x24, 0x9c,
	0xde, 0xbc, 0xa1, 0x19, 0x35, 0x4d, 0xbf, 0xb9, 0x55, 0xd2, 0x8c, 0x62, 0xa9, 0x54, 0xd9, 0x2d,
	0xd7, 0x0d, 0x16, 0x7e, 0xbb, 0xc1, 0xbc, 0x7c, 0x04, 0xe4, 0x0b, 0xbb, 0x95, 0x7a, 0xd1, 0xd0,
	0xbe, 0x58, 0xd2, 0xb4, 0x0d, 0x6d, 0x23, 0x37, 0x26, 0x02, 0x66, 0xd7, 0xdf, 0x31, 0x2a, 0x55,
	0x4d, 0x2f, 0xd6, 0x2b, 0x7a, 0x6e, 0x1c, 0x9d, 0x84, 0xa5, 0xd2, 0x76, 0x65, 0x77, 0xc3, 0xb8,
	0xb1, 0x53, 0x33, 0x6e, 0x68, 0xef, 0x70, 0x9f, 0xe0, 0x94, 0xfa, 0xd7, 0xa2, 0x57, 0x69, 0xa2,
	0x57, 0x2d, 0xc4, 0x03, 0x05, 0x4a, 0xfc, 0xd9, 0x84, 0xf8, 0xeb, 0x05, 0x99, 0xbe, 0xd7, 0x0b,
	0x3e, 0x17, 0x9a, 0x0f, 0x89, 0xc9, 0x07, 0x54, 0xfc, 0xe5, 0x97, 0xf9, 0x7a, 0xf3, 0x07, 0xd4,
	0x6f, 0x28, 0x70, 0x86, 0x88, 0xf7, 0x2e, 0x7d, 0x4b, 0x28, 0x7a, 0x25, 0x66, 0xa4, 0xc5, 0x81,
	0x56, 0x60, 0xf2, 0xb6, 0xd5, 0x0e, 0xb0, 0xc7, 0x49, 0xe3, 0x5f, 0xe8, 0x34, 0xcc, 0x50, 0x99,
	0xa6, 0x4e, 0x57, 0xa6, 0x3f, 0x4e, 0x93, 0x02, 0x9a, 0xbf, 0x78, 0x16, 0x40, 0x12, 0x78, 0x76,
	0x6b, 0x47, 0x9b, 0x33, 0x61, 0xff, 0xb6, 0x02, 0x67, 0x07, 0x50, 0xc4, 0x17, 0xde, 0x36, 0xcc,
	0x46, 0x2c, 0x10, 0x4b, 0x2f, 0x25, 0x32, 0xb8, 0x17, 0x93, 0x2e, 0x83, 0x8f, 0xbc, 0x08, 0xbf,
	0x93, 0x81, 0x73, 0xbd, 0x98, 0xe2, 0x8f, 0xc4, 0x90, 0x91, 0x49, 0x0f, 0xca, 0xb0, 0xa9, 0x9c,
	0xf1, 0xc2, 0xf7, 0x63, 0x54, 0x98, 0xb7, 0x5c, 0xe6, 0x8d, 0xa6, 0x85, 0xc2, 0xd3, 0x69, 0xb9,
	0x25, 0xab, 0xe9, 0x31, 0x14, 0x6f, 0x87, 0x17, 0x0d, 0x2c, 0xa3, 0xe2, 0x73, 0xa3, 0x0f, 0x2b,
	0x4e, 0x4c, 0xcf, 0xf5, 0x83, 0xda, 0x0a, 0x5d, 0xdc, 0xb1, 0x55, 0x00, 0x30, 0xb9, 0x5b, 0xde,
	0xad, 0x69, 0x1b, 0x2c, 0xc6, 0x7d, 0xab, 0x6c, 0xec, 0xd6, 0xc2, 0x25, 0x90, 0xcb, 0xa0, 0x3c,
	0x2c, 0x8b, 0xb2, 0xeb, 0x45, 0x5d, 0x2b, 0xae, 0x6f, 0x6b, 0x46, 0xb5, 0x42, 0x84, 0x7e, 0x05,
	0x10, 0xaf, 0x61, 0xb1, 0xe7, 0x1b, 0xb4, 0x7c, 0x5c, 0xfd, 0x72, 0x06, 0x72, 0xbd, 0xa4, 0xf5,
	0xc8, 0xb1, 0xd2, 0x27, 0xc7, 0xd2, 0x0a, 0xc8, 0xc4, 0x57, 0x40, 0x1f, 0xd3, 0xc6, 0xfa, 0x99,
	0xb6, 0x0f, 0x4b, 0xd1, 0x93, 0x3e, 0x96, 0xcb, 0x1a, 0x0a, 0x5d, 0xff, 0xf5, 0xa3, 0x72, 0x50,
	0x5f, 0x0c, 0x91, 0x6e, 0xb9, 0xb4, 0xc4, 0xa7, 0xaf, 0xcc, 0x24, 0xe4, 0x92, 0xf4, 0x5c, 0xe0,
	0xa8, 0x57, 0x61, 0x65, 0x40, 0xbe, 0xd0, 0xe0, 0x77, 0x6f, 0x5e, 0x81, 0x53, 0x83, 0x13, 0x7c,
	0x06, 0x83, 0x7d, 0x16, 0x16, 0xfb, 0x33, 0xf2, 0x2f, 0xc1, 0x62, 0x78, 0x4b, 0xe3, 0x62, 0x8f,
	0x6e, 0x0b, 0x5c, 0xb7, 0xcb, 0xf2, 0x6b, 0x97, 0x2a, 0xf6, 0x48, 0x4f, 0xea, 0xaf, 0x29, 0x80,
	0xfa, 0x53, 0x5f, 0xd1, 0x75, 0x98, 0x20, 0x43, 0xc2, 0x3c, 0xee, 0xfe, 0xea, 0x61, 0xf2, 0x66,
	0xa9, 0xe8, 0x61, 0x9d, 0x21, 0x40, 0xa7, 0x60, 0xfa, 0x0e, 0x8e, 0x3d, 0xf5, 0x35, 0x75, 0x07,
	0xd3, 0x67, 0xbe, 0xd4, 0xab, 0x30, 0x41, 0x9b, 0xc6, 0x45, 0x72, 0x1e, 0x66, 0xb4, 0x72, 0x49,
	0x7f, 0xa7, 0x5a, 0xa7, 0x52, 0x39, 0x0f, 0x33, 0x1b, 0x9a, 0xf8, 0xcc, 0xa8, 0x7f, 0x32, 0x06,
	0xa7, 0x06, 0x67, 0x82, 0x7d, 0x00, 0xcb, 0x7b, 0x56, 0xeb, 0xfd, 0x2e, 0xf6, 0x0e, 0x8c, 0x26,
	0xf6, 0x03, 0xcb, 0x66, 0x7e, 0x4a, 0xe6, 0x40, 0xdd, 0x3c, 0x42, 0xfa, 0xd9, 0xea, 0xba, 0xd5,
	0xfa, 0x02, 0xc1, 0xb7, 0x11, 0xa1, 0xd3, 0x97, 0x44, 0x27, 0x52, 0x21, 0x2a, 0xc1, 0x39, 0xe1,
	0xca, 0xe1, 0x4a, 0x1c, 0xa6, 0x51, 0xff, 0x44, 0xdd, 0xc5, 0xd2, 0x3b, 0xa9, 0xfc, 0x29, 0x55,
	0x7e, 0x04, 0x68, 0xb4, 0xcd, 0x0e, 0x6f, 0x82, 0xfe, 0x86, 0x02, 0xa7, 0x1b, 0x8e, 0xed, 0x77,
	0x3b, 0x94, 0x95, 0x21, 0x6c, 0xfc, 0x41, 0xd0, 0x9d, 0xa3, 0x0c, 0xa4, 0x14, 0xa1, 0x15, 0xdd,
	0x89, 0x07, 0x0f, 0x1a, 0x83, 0xaa, 0x0a, 0x2f, 0xc3, 0x52, 0x02, 0x03, 0xc8, 0x4e, 0x47, 0xb4,
	0x6b, 0x1f, 0x47, 0x0a, 0xa2, 0x3e, 0xc3, 0x4b, 0xb6, 0x9a, 0x85, 0x57, 0x88, 0x21, 0x34, 0x00,
	0xe5, 0x60, 0x59, 0xbe, 0xfa, 0x4f, 0xb6, 0x20, 0xcb, 0x7d, 0x64, 0xcc, 0xc9, 0xea, 0xa1, 0x9f,
	0x28, 0x30, 0x27, 0xc7, 0x5d, 0xa1, 0x94, 0x6b, 0x8e, 0x84, 0x78, 0xb0, 0xc2, 0xea, 0xa8, 0xcd,
	0xd9, 0xd9, 0xa2, 0x7e, 0x55, 0x79, 0x58, 0x5c, 0x88, 0x74, 0xdf, 0x2b, 0x44, 0xa3, 0xfd, 0xca,
	0x8f, 0xfe, 0xcb, 0xdf, 0xcc, 0xdc, 0x41, 0x2f, 0x86, 0x2f, 0x7f, 0x7f, 0xc8, 0x8e, 0xbf, 0x37,
	0x79, 0x3b, 0x7f, 0xed, 0xf2, 0x5a, 0xa8, 0xd4, 0xad, 0x5d, 0x7e, 0x20, 0x5e, 0x06, 0xf7, 0x6f,
	0xbd, 0x8a, 0x5e, 0x0e, 0x81, 0xc2, 0xc6, 0x1f, 0x46, 0xe8, 0x1f, 0xac, 0xd1, 0x60, 0x9e, 0xb5,
	0x0f, 0xc9, 0x9f, 0x08, 0x0e, 0xfd, 0x99, 0x02, 0x10, 0xa5, 0x36, 0xa0, 0x14, 0x8d, 0xb8, 0x2f,
	0x01, 0xa2, 0x30, 0x3c, 0xfc, 0x4c, 0xfd, 0xdb, 0xca, 0xc3, 0x62, 0xa1, 0x67, 0x90, 0x57, 0x22,
	0x9d, 0x9d, 0x8e, 0xf7, 0xbe, 0x3c, 0x5e, 0xb2, 0x78, 0x07, 0x8c, 0x36, 0x24, 0x7a, 0xed, 0xf2,
	0x83, 0x5b, 0x25, 0x54, 0x3c, 0xca, 0x78, 0xd7, 0x3e, 0x8c, 0x3a, 0x7f, 0x80, 0xfe, 0x8f, 0x02,
	0xf3, 0xb1, 0x5c, 0x14, 0x94, 0x32, 0x89, 0x49, 0x49, 0x2b, 0x85, 0x51, 0xa2, 0xab, 0xd4, 0x6f,
	0x2a, 0x0f, 0x8b, 0x27, 0x07, 0x30, 0x81, 0x72, 0xe0, 0x7d, 0xf5, 0xf0, 0x33, 0x7e, 0x4d, 0xb9,
	0x7c, 0xeb, 0xd3, 0xea, 0x91, 0x26, 0xfd, 0x9a, 0x72, 0x19, 0x7d, 0x23, 0x03, 0xf3, 0xb1, 0x0c,
	0x92, 0xb4, 0xa1, 0x27, 0xa5, 0x9a, 0x8c, 0x36, 0xf4, 0xef, 0x2a, 0x0f, 0x8b, 0x4f, 0x0d, 0x9e,
	0xff, 0x2b, 0x2c, 0xb8, 0x94, 0x32, 0xe1, 0x67, 0x0b, 0x87, 0x17, 0x03, 0xc2, 0x84, 0xb7, 0x0a,
	0xc7, 0x97, 0x04, 0xc2, 0x91, 0x5f, 0xca, 0x40, 0x36, 0x9e, 0x79, 0x82, 0xd6, 0x86, 0xb1, 0xa4,
	0x27, 0xa8, 0x66, 0x34, 0x9e, 0xfc, 0x86, 0x42, 0xc7, 0xfb, 0x3d, 0xa5, 0xf0, 0xe6, 0x61, 0x07,
	0xbc, 0x16, 0x7a, 0xf9, 0xf9, 0xe0, 0x6f, 0xab, 0xe6, 0xb1, 0x07, 0x2f, 0x21, 0xfd, 0x50, 0xbe,
	0xd1, 0x78, 0xb0, 0xc6, 0x66, 0x87, 0x30, 0xe7, 0xf7, 0x32, 0xb1, 0x9b, 0x25, 0x59, 0xcf, 0x78,
	0x2d, 0xd5, 0xc3, 0x39, 0x38, 0xa5, 0x64, 0x34, 0x66, 0xfd, 0x21, 0x63, 0xd6, 0xef, 0x29, 0xea,
	0xf6, 0xf1, 0x98, 0xe5, 0xe3, 0x40, 0xa2, 0x81, 0xf0, 0xee, 0x8e, 0x7a, 0xfb, 0x23, 0xe4, 0x9d,
	0x19, 0xeb, 0x0c, 0xfd, 0xb3, 0x0c, 0x2c, 0xf6, 0x65, 0x91, 0xa0, 0xab, 0xe9, 0xde, 0xe1, 0xa4,
	0x94, 0x93, 0x51, 0xd9, 0xf6, 0xb0, 0x78, 0x39, 0x65, 0xdd, 0xf5, 0xe4, 0x93, 0x50, 0x1e, 0x7f,
	0x53, 0x51, 0x3f, 0x73, 0xf8, 0x15, 0xe8, 0x87, 0x74, 0x12, 0x9e, 0x96, 0xd5, 0xad, 0xe3, 0xf3,
	0xb4, 0x1d, 0xe2, 0x43, 0x7f, 0xc0, 0x83, 0xf1, 0xfb, 0xd2, 0x42, 0x86, 0x44, 0xc5, 0x0f, 0x48,
	0x74, 0x19, 0x8d, 0x79, 0xff, 0x4e, 0x79, 0x58, 0x7c, 0x3e, 0x85, 0x79, 0xfd, 0x39, 0x2c, 0x94,
	0x7f, 0xbf, 0xa8, 0xa8, 0x9f, 0x3b, 0x12, 0xff, 0x22, 0x6a, 0x09, 0x0b, 0xbf, 0x20, 0x49, 0xfa,
	0x91, 0x59, 0xd8, 0x91, 0x51, 0xa2, 0x7f, 0x9c, 0x81, 0x85, 0x9e, 0x7c, 0x19, 0xf4, 0x42, 0x2a,
	0x03, 0x13, 0x52, 0x6b, 0x46, 0xe3, 0xdd, 0xf7, 0x95, 0x87, 0xc5, 0x8b, 0x29, 0xbc, 0x8b, 0x65,
	0xcd, 0x50, 0xb6, 0x7d, 0x43, 0x51, 0xdf, 0x38, 0x12, 0xdb, 0x18, 0x8d, 0x84, 0x65, 0x3b, 0xea,
	0xf5, 0xe3, 0xb3, 0xcc, 0x14, 0xe8, 0xd0, 0x77, 0x69, 0xb4, 0x71, 0xe4, 0x87, 0x4b, 0xd3, 0x04,
	0x13, 0xd2, 0x73, 0x46, 0x63, 0xd4, 0x1f, 0x28, 0x0f, 0x8b, 0xcf, 0xa4, 0xae, 0x50, 0x8e, 0x95,
	0x32, 0xe9, 0xdb, 0x8a, 0xfa, 0xd9, 0x23, 0xae, 0x4d, 0x5e, 0x45, 0xf8, 0x54, 0x55, 0x6f, 0x3c,
	0x8a, 0xd5, 0x19, 0x61, 0x44, 0xdf, 0xcb, 0xc0, 0x9c, 0x9c, 0xeb, 0x93, 0xc6, 0xaa, 0x84, 0x9c,
	0xa0, 0xd1, 0x37, 0xb3, 0x4b, 0x69, 0xeb, 0x31, 0x16, 0x41, 0x4d, 0xf9, 0xf5, 0xad, 0x23, 0xf1,
	0xab, 0x2b, 0x51, 0xf8, 0xc8, 0xe4, 0xaa, 0x23, 0xd0, 0xa1, 0x9f, 0xcb, 0xc0, 0x7c, 0x2c, 0x65,
	0x27, 0x4d, 0xe7, 0x4a, 0xca, 0xed, 0x19, 0x8d, 0x5d, 0x7f, 0x9f, 0x1d, 0x99, 0xbf, 0x74, 0xe4,
	0xed, 0x28, 0xec, 0x96, 0xf0, 0xa0, 0xae, 0x56, 0x8e, 0xaf, 0x5e, 0xf5, 0x62, 0x45, 0x5f, 0xc9,
	0xc0, 0x7c, 0x2c, 0xcf, 0x27, 0x8d, 0x15, 0x49, 0x09, 0x41, 0xa3, 0xb1, 0x62, 0x24, 0xf3, 0xe3,
	0xf2, 0x51, 0xcc, 0x8f, 0xcb, 0x8f, 0xc0, 0xfc, 0xf8, 0x73, 0x05, 0xb2, 0xf1, 0x4c, 0x8e, 0x34,
	0x8d, 0x33, 0x31, 0x01, 0xa6, 0xf0, 0xc2, 0xe8, 0x00, 0xdc, 0xee, 0xfc, 0xab, 0x83, 0xec, 0x4e,
	0x07, 0xbd, 0x34, 0xb2, 0x15, 0x12, 0xe5, 0x8b, 0xdc, 0x7a, 0x1d, 0xbd, 0x7a, 0x18, 0x56, 0x48,
	0x99, 0x26, 0x3f, 0x97, 0x81, 0x39, 0x39, 0xd9, 0x28, 0x6d, 0xf3, 0x48, 0x48, 0x4a, 0x1a, 0x4d,
	0x04, 0xfe, 0x81, 0xf2, 0xb0, 0x78, 0xa6, 0x57, 0x04, 0xe4, 0xf4, 0x1b, 0x66, 0x7c, 0xc8, 0x63,
	0x4f, 0x13, 0x82, 0x88, 0x7c, 0x22, 0x06, 0x9b, 0x48, 0x3b, 0xda, 0xd8, 0xd7, 0x3e, 0x94, 0x49,
	0x78, 0x80, 0x7e, 0x21, 0x03, 0x0b, 0x3d, 0xe9, 0x46, 0x69, 0x27, 0x74, 0x72, 0x66, 0x52, 0x61,
	0xa5, 0x2f, 0x04, 0x50, 0xeb, 0xb8, 0xc1, 0x81, 0xfa, 0x3b, 0x23, 0xf1, 0xe0, 0x5b, 0x8a, 0x7a,
	0xed, 0x08, 0x4c, 0xb8, 0xd6, 0xa0, 0xc4, 0x1c, 0x41, 0x75, 0x19, 0xc8, 0x8e, 0x08, 0x25, 0xfa,
	0xdf, 0x0a, 0x2c, 0xf4, 0x64, 0x1a, 0xa5, 0x31, 0x26, 0x39, 0x29, 0xa9, 0xf0, 0x6c, 0xda, 0x3e,
	0x1b, 0x35, 0x57, 0xbf, 0x36, 0x68, 0x6d, 0xbc, 0x3f, 0xa2, 0x7c, 0x3c, 0x58, 0xf3, 0x25, 0x7c,
	0xb7, 0xae, 0xa1, 0xd7, 0x0f, 0xc3, 0x10, 0x06, 0xcb, 0xb3, 0x13, 0xbe, 0x93, 0x81, 0xf9, 0x58,
	0x8c, 0x18, 0x1a, 0xe2, 0x61, 0xea, 0x4d, 0x3c, 0x29, 0xac, 0x8d, 0xdc, 0x9e, 0x6f, 0x0d, 0xff,
	0x74, 0x84, 0xed, 0xf2, 0xeb, 0x0a, 0x7a, 0x73, 0xc4, 0x6d, 0x42, 0xde, 0x31, 0x23, 0x43, 0xe9,
	0xd6, 0x0e, 0xba, 0xf1, 0x08, 0xed, 0x2e, 0xf4, 0xeb, 0x19, 0x98, 0x95, 0xf2, 0x5b, 0xd0, 0x95,
	0x54, 0xe9, 0xe8, 0xb5, 0xd8, 0x47, 0x88, 0xad, 0xa3, 0xf6, 0xc0, 0x85, 0x14, 0xfd, 0x43, 0x36,
	0xfc, 0x28, 0x8f, 0xfe, 0x4e, 0x8c, 0x47, 0x47, 0xb0, 0x56, 0x6f, 0xbd, 0x8b, 0x6e, 0x7d, 0x74,
	0xb6, 0x29, 0xfa, 0xd5, 0x0c, 0x64, 0xe3, 0x79, 0x64, 0x69, 0x07, 0x4f, 0x62, 0xc6, 0xd9, 0x68,
	0x9b, 0xef, 0xef, 0x0f, 0x51, 0x72, 0x43, 0xb2, 0x28, 0xdb, 0x7e, 0x5e, 0x51, 0x8f, 0x27, 0x5a,
	0x8f, 0x4c, 0xc7, 0x95, 0x31, 0xa2, 0xdf, 0xce, 0x40, 0x36, 0x9e, 0x96, 0x96, 0xc6, 0xad, 0xc4,
	0x04, 0xb6, 0xd1, 0xed, 0xce, 0x43, 0xca, 0xd9, 0xe5, 0xe3, 0xca, 0xd9, 0xe5, 0x8f, 0x52, 0xce,
	0xfe, 0x73, 0x06, 0x4e, 0x0e, 0x08, 0xd6, 0x45, 0x29, 0x97, 0x65, 0xe9, 0xf1, 0xbd, 0xa3, 0xf1,
	0xf2, 0xbf, 0x1e, 0x96, 0x97, 0xbf, 0xa5, 0xa8, 0x6f, 0x1d, 0xcf, 0xc3, 0xe4, 0x71, 0xb2, 0x89,
	0x14, 0xee, 0xab, 0x8d, 0x8f, 0x8e, 0xaf, 0x72, 0x4f, 0xe8, 0x7f, 0x66, 0xe0, 0x44, 0x62, 0x1c,
	0x3c, 0x7a, 0x75, 0x24, 0xc7, 0x5c, 0x5f, 0xe0, 0xfc, 0x68, 0xfc, 0xfd, 0xbf, 0xca, 0xc3, 0xe2,
	0xd5, 0x11, 0xf9, 0x7b, 0x25, 0x0a, 0x5b, 0xa7, 0xac, 0xfe, 0x57, 0x8a, 0xb4, 0x46, 0x8f, 0xea,
	0xcc, 0x8b, 0xe8, 0x26, 0xfc, 0xee, 0xa8, 0xfb, 0x1f, 0xa1, 0x2f, 0xaf, 0xb7, 0x3b, 0xf4, 0x83,
	0x0c, 0xcc, 0x84, 0xe1, 0x9b, 0xe8, 0xf2, 0xe8, 0x31, 0x9e, 0xa3, 0x31, 0xf7, 0x4f, 0x95, 0x87,
	0xc5, 0xcf, 0xa4, 0x30, 0xb7, 0x27, 0xd4, 0xf4, 0x4a, 0x5f, 0x30, 0x28, 0x65, 0xf3, 0xdf, 0x53,
	0xd4, 0xd2, 0x91, 0x0c, 0xc0, 0x78, 0x54, 0x28, 0x61, 0xef, 0xae, 0x5a, 0x3d, 0x3e, 0x7b, 0xbd,
	0x5e, 0xb4, 0xe8, 0x7b, 0xcc, 0x20, 0x96, 0xfe, 0xc3, 0x52, 0xba, 0x41, 0xdc, 0x17, 0x67, 0x3a,
	0xba, 0xab, 0x45, 0x4d, 0x61, 0x27, 0xbf, 0x14, 0x3c, 0x9e, 0x13, 0x2f, 0xa2, 0xed, 0x91, 0x39,
	0xf1, 0xda, 0x32, 0x4a, 0xf4, 0x6b, 0x19, 0x1a, 0xcd, 0x24, 0x07, 0xae, 0xa6, 0x3a, 0xf1, 0x12,
	0x63, 0x5c, 0x47, 0x3f, 0xb6, 0x87, 0xe9, 0x81, 0x7f, 0x57, 0x51, 0x8b, 0x47, 0x60, 0x14, 0xa5,
	0xca, 0x15, 0x54, 0x11, 0x56, 0xdd, 0x54, 0xbf, 0xf0, 0x08, 0x1c, 0x0c, 0x7d, 0x78, 0xd1, 0x3f,
	0xcf, 0x00, 0xea, 0x8f, 0x91, 0x45, 0x29, 0xef, 0xa2, 0x0e, 0x8c, 0xa8, 0x1d, 0x8d, 0x6b, 0xff,
	0x66, 0x04, 0xae, 0xfd, 0x43, 0x45, 0xdd, 0x38, 0x3c, 0xd7, 0x1a, 0x82, 0xb0, 0x18, 0xe3, 0xde,
	0x51, 0xeb, 0xc7, 0x67, 0x5c, 0x22, 0x6a, 0x62, 0x7b, 0x2c, 0xf4, 0x24, 0x12, 0x0d, 0x71, 0x18,
	0x27, 0xe4, 0x1c, 0x8d, 0xc6, 0xb5, 0xdf, 0x65, 0xde, 0xaa, 0xdf, 0x54, 0x54, 0xed, 0xd8, 0x67,
	0x02, 0xe9, 0x9c, 0x70, 0xa6, 0xa5, 0xee, 0x7d, 0xb4, 0xa7, 0x01, 0xef, 0x08, 0xfd, 0x6b, 0x96,
	0x72, 0x10, 0xff, 0xcf, 0x6f, 0x2f, 0xa6, 0x33, 0x2a, 0x21, 0xea, 0x77, 0x34, 0x4e, 0xfd, 0x68,
	0x88, 0x1b, 0x34, 0x1e, 0xd0, 0x4b, 0xb9, 0xfa, 0xcb, 0x8a, 0xba, 0x7e, 0xa4, 0xdd, 0x2c, 0x46,
	0x25, 0x61, 0xe9, 0xdb, 0xaa, 0xfe, 0x48, 0xdc, 0x80, 0xbd, 0x88, 0xd1, 0x1f, 0x8b, 0xe7, 0x96,
	0x7a, 0xe3, 0x6a, 0x87, 0xbd, 0x7b, 0x94, 0x1c, 0x50, 0x3c, 0x1a, 0x2b, 0xff, 0xd3, 0xb0, 0x1b,
	0x9e, 0xbe, 0x88, 0x61, 0xca, 0xce, 0xef, 0x1e, 0x41, 0x47, 0xe4, 0xca, 0x4a, 0x0f, 0xb5, 0x84,
	0xa5, 0x5f, 0x52, 0x6f, 0x3e, 0x22, 0xcf, 0x6a, 0x3f, 0x72, 0xf4, 0xc7, 0x3c, 0x98, 0xb8, 0x2f,
	0xb6, 0x31, 0x4d, 0x2d, 0x4c, 0x0b, 0xcf, 0x2c, 0xbc, 0x76, 0x68, 0x38, 0xee, 0x55, 0xf8, 0x0b,
	0x0f, 0x8b, 0x3c, 0x8a, 0x93, 0x32, 0xf1, 0x0d, 0xf4, 0xe9, 0x14, 0x23, 0xef, 0xc1, 0x9a, 0xd9,
	0x6a, 0x79, 0xb8, 0x65, 0x06, 0xb8, 0xb9, 0xd6, 0xed, 0x23, 0xfe, 0x57, 0x14, 0xe6, 0x14, 0x89,
	0xee, 0x66, 0x86, 0x38, 0x45, 0xfa, 0x2e, 0x67, 0xd6, 0x46, 0x6e, 0xcf, 0xc9, 0x7f, 0x2d, 0x4e,
	0xfe, 0x45, 0xf4, 0x6c, 0x2a, 0xf9, 0xa1, 0x14, 0x14, 0xb6, 0x7f, 0x58, 0xcc, 0x47, 0x9d, 0xb0,
	0x5e, 0x4d, 0xd7, 0xf2, 0x57, 0x1b, 0x4e, 0xe7, 0x8f, 0x8a, 0xab, 0xfb, 0x41, 0xe0, 0xfa, 0xd7,
	0xd6, 0xd6, 0xee, 0xdd, 0xbb, 0xd7, 0x53, 0xb9, 0x66, 0x76, 0x83, 0xfd, 0x35, 0xfa, 0xdf, 0x62,
	0x9f, 0x17, 0xff, 0x04, 0x7d, 0xfd, 0x77, 0x15, 0x38, 0xd3, 0x70, 0x3a, 0x03, 0xa9, 0x5f, 0x5f,
	0x2a, 0x89, 0xff, 0x48, 0x48, 0xaf, 0x24, 0xab, 0x9e, 0x13, 0x38, 0x55, 0xe5, 0x56, 0x91, 0x03,
	0xb4, 0x9c, 0xb6, 0x69, 0xb7, 0x56, 0x1d, 0xaf, 0xb5, 0xd6, 0xc2, 0x36, 0x75, 0x10, 0xae, 0x45,
	0xdd, 0xae, 0x85, 0xf8, 0xc4, 0xe0, 0xde, 0x08, 0x4b, 0xbe, 0x97, 0x39, 0xb7, 0xc9, 0x70, 0xd0,
	0xff, 0x14, 0xba, 0x5a, 0x0a, 0xbb, 0xbe, 0xf9, 0xe2, 0x3a, 0x69, 0xfa, 0x43, 0xd1, 0xe0, 0x5d,
	0xda, 0xe0, 0xdd, 0xb0, 0xc1, 0xbb, 0x37, 0x19, 0xae, 0xbd, 0x49, 0xda, 0xdf, 0x4b, 0xff, 0x3f,
	0x00, 0x00, 0xff, 0xff, 0x25, 0xa1, 0xd1, 0x68, 0xe3, 0x80, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ClusterManagerClient is the client API for ClusterManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterManagerClient interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details for a specific cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the Kubelet creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range the cluster is using.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the settings for a specific cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the version and/or image type of a specific node pool.
	UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the autoscaling settings of a specific node pool.
	SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the logging service for a specific cluster.
	SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the monitoring service for a specific cluster.
	SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the addons for a specific cluster.
	SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the locations for a specific cluster.
	SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the master for a specific cluster.
	UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets master auth materials. Currently supports changing the admin password
	// or a specific cluster, either via password generation or explicitly setting
	// the password.
	SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster,
	// such as load balancer resources, are not deleted if they weren't present
	// when the cluster was initially created.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all operations in a project in the specified zone or all zones.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns configuration info about the Google Kubernetes Engine service.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error)
	// Retrieves the requested node pool.
	GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Rolls back a previously Aborted or Failed NodePool upgrade.
	// This makes no changes if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts master IP rotation.
	StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the size for a specific node pool.
	SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables Network Policy for a cluster.
	SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists subnetworks that can be used for creating clusters in a project.
	ListUsableSubnetworks(ctx context.Context, in *ListUsableSubnetworksRequest, opts ...grpc.CallOption) (*ListUsableSubnetworksResponse, error)
	// Fetches locations that offer Google Kubernetes Engine.
	ListLocations(ctx context.Context, in *ListLocationsRequest, opts ...grpc.CallOption) (*ListLocationsResponse, error)
}

type clusterManagerClient struct {
	cc *grpc.ClientConn
}

func NewClusterManagerClient(cc *grpc.ClientConn) ClusterManagerClient {
	return &clusterManagerClient{cc}
}

func (c *clusterManagerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/UpdateNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNodePoolAutoscaling", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLoggingService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetMonitoringService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetAddonsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/UpdateMaster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetMasterAuth", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CancelOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error) {
	out := new(ListNodePoolsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListNodePools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error) {
	out := new(NodePool)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CreateNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/DeleteNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/RollbackNodePoolUpgrade", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNodePoolManagement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLegacyAbac", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/StartIPRotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CompleteIPRotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNodePoolSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetMaintenancePolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListUsableSubnetworks(ctx context.Context, in *ListUsableSubnetworksRequest, opts ...grpc.CallOption) (*ListUsableSubnetworksResponse, error) {
	out := new(ListUsableSubnetworksResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListUsableSubnetworks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListLocations(ctx context.Context, in *ListLocationsRequest, opts ...grpc.CallOption) (*ListLocationsResponse, error) {
	out := new(ListLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterManagerServer is the server API for ClusterManager service.
type ClusterManagerServer interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details for a specific cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the Kubelet creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range the cluster is using.
	CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error)
	// Updates the settings for a specific cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error)
	// Updates the version and/or image type of a specific node pool.
	UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*Operation, error)
	// Sets the autoscaling settings of a specific node pool.
	SetNodePoolAutoscaling(context.Context, *SetNodePoolAutoscalingRequest) (*Operation, error)
	// Sets the logging service for a specific cluster.
	SetLoggingService(context.Context, *SetLoggingServiceRequest) (*Operation, error)
	// Sets the monitoring service for a specific cluster.
	SetMonitoringService(context.Context, *SetMonitoringServiceRequest) (*Operation, error)
	// Sets the addons for a specific cluster.
	SetAddonsConfig(context.Context, *SetAddonsConfigRequest) (*Operation, error)
	// Sets the locations for a specific cluster.
	SetLocations(context.Context, *SetLocationsRequest) (*Operation, error)
	// Updates the master for a specific cluster.
	UpdateMaster(context.Context, *UpdateMasterRequest) (*Operation, error)
	// Sets master auth materials. Currently supports changing the admin password
	// or a specific cluster, either via password generation or explicitly setting
	// the password.
	SetMasterAuth(context.Context, *SetMasterAuthRequest) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster,
	// such as load balancer resources, are not deleted if they weren't present
	// when the cluster was initially created.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error)
	// Lists all operations in a project in the specified zone or all zones.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(context.Context, *CancelOperationRequest) (*empty.Empty, error)
	// Returns configuration info about the Google Kubernetes Engine service.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error)
	// Retrieves the requested node pool.
	GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(context.Context, *CreateNodePoolRequest) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*Operation, error)
	// Rolls back a previously Aborted or Failed NodePool upgrade.
	// This makes no changes if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(context.Context, *RollbackNodePoolUpgradeRequest) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(context.Context, *SetNodePoolManagementRequest) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(context.Context, *SetLabelsRequest) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(context.Context, *SetLegacyAbacRequest) (*Operation, error)
	// Starts master IP rotation.
	StartIPRotation(context.Context, *StartIPRotationRequest) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(context.Context, *CompleteIPRotationRequest) (*Operation, error)
	// Sets the size for a specific node pool.
	SetNodePoolSize(context.Context, *SetNodePoolSizeRequest) (*Operation, error)
	// Enables or disables Network Policy for a cluster.
	SetNetworkPolicy(context.Context, *SetNetworkPolicyRequest) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(context.Context, *SetMaintenancePolicyRequest) (*Operation, error)
	// Lists subnetworks that can be used for creating clusters in a project.
	ListUsableSubnetworks(context.Context, *ListUsableSubnetworksRequest) (*ListUsableSubnetworksResponse, error)
	// Fetches locations that offer Google Kubernetes Engine.
	ListLocations(context.Context, *ListLocationsRequest) (*ListLocationsResponse, error)
}

// UnimplementedClusterManagerServer can be embedded to have forward compatible implementations.
type UnimplementedClusterManagerServer struct {
}

func (*UnimplementedClusterManagerServer) ListClusters(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedClusterManagerServer) GetCluster(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedClusterManagerServer) CreateCluster(ctx context.Context, req *CreateClusterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateCluster(ctx context.Context, req *UpdateClusterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateNodePool(ctx context.Context, req *UpdateNodePoolRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolAutoscaling(ctx context.Context, req *SetNodePoolAutoscalingRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodePoolAutoscaling not implemented")
}
func (*UnimplementedClusterManagerServer) SetLoggingService(ctx context.Context, req *SetLoggingServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLoggingService not implemented")
}
func (*UnimplementedClusterManagerServer) SetMonitoringService(ctx context.Context, req *SetMonitoringServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMonitoringService not implemented")
}
func (*UnimplementedClusterManagerServer) SetAddonsConfig(ctx context.Context, req *SetAddonsConfigRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAddonsConfig not implemented")
}
func (*UnimplementedClusterManagerServer) SetLocations(ctx context.Context, req *SetLocationsRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLocations not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateMaster(ctx context.Context, req *UpdateMasterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMaster not implemented")
}
func (*UnimplementedClusterManagerServer) SetMasterAuth(ctx context.Context, req *SetMasterAuthRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMasterAuth not implemented")
}
func (*UnimplementedClusterManagerServer) DeleteCluster(ctx context.Context, req *DeleteClusterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedClusterManagerServer) ListOperations(ctx context.Context, req *ListOperationsRequest) (*ListOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterManagerServer) GetOperation(ctx context.Context, req *GetOperationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOperation not implemented")
}
func (*UnimplementedClusterManagerServer) CancelOperation(ctx context.Context, req *CancelOperationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelOperation not implemented")
}
func (*UnimplementedClusterManagerServer) GetServerConfig(ctx context.Context, req *GetServerConfigRequest) (*ServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServerConfig not implemented")
}
func (*UnimplementedClusterManagerServer) ListNodePools(ctx context.Context, req *ListNodePoolsRequest) (*ListNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodePools not implemented")
}
func (*UnimplementedClusterManagerServer) GetNodePool(ctx context.Context, req *GetNodePoolRequest) (*NodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) CreateNodePool(ctx context.Context, req *CreateNodePoolRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) DeleteNodePool(ctx context.Context, req *DeleteNodePoolRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) RollbackNodePoolUpgrade(ctx context.Context, req *RollbackNodePoolUpgradeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackNodePoolUpgrade not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolManagement(ctx context.Context, req *SetNodePoolManagementRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodePoolManagement not implemented")
}
func (*UnimplementedClusterManagerServer) SetLabels(ctx context.Context, req *SetLabelsRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (*UnimplementedClusterManagerServer) SetLegacyAbac(ctx context.Context, req *SetLegacyAbacRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLegacyAbac not implemented")
}
func (*UnimplementedClusterManagerServer) StartIPRotation(ctx context.Context, req *StartIPRotationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartIPRotation not implemented")
}
func (*UnimplementedClusterManagerServer) CompleteIPRotation(ctx context.Context, req *CompleteIPRotationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteIPRotation not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolSize(ctx context.Context, req *SetNodePoolSizeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodePoolSize not implemented")
}
func (*UnimplementedClusterManagerServer) SetNetworkPolicy(ctx context.Context, req *SetNetworkPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNetworkPolicy not implemented")
}
func (*UnimplementedClusterManagerServer) SetMaintenancePolicy(ctx context.Context, req *SetMaintenancePolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMaintenancePolicy not implemented")
}
func (*UnimplementedClusterManagerServer) ListUsableSubnetworks(ctx context.Context, req *ListUsableSubnetworksRequest) (*ListUsableSubnetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUsableSubnetworks not implemented")
}
func (*UnimplementedClusterManagerServer) ListLocations(ctx context.Context, req *ListLocationsRequest) (*ListLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLocations not implemented")
}

func RegisterClusterManagerServer(s *grpc.Server, srv ClusterManagerServer) {
	s.RegisterService(&_ClusterManager_serviceDesc, srv)
}

func _ClusterManager_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/UpdateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, req.(*UpdateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolAutoscaling_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolAutoscalingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNodePoolAutoscaling",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, req.(*SetNodePoolAutoscalingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLoggingService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLoggingServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLoggingService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, req.(*SetLoggingServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMonitoringService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMonitoringServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetMonitoringService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, req.(*SetMonitoringServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetAddonsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAddonsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetAddonsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, req.(*SetAddonsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLocations(ctx, req.(*SetLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/UpdateMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, req.(*UpdateMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMasterAuth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMasterAuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetMasterAuth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, req.(*SetMasterAuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListNodePools(ctx, req.(*ListNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetNodePool(ctx, req.(*GetNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CreateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, req.(*CreateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/DeleteNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, req.(*DeleteNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_RollbackNodePoolUpgrade_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackNodePoolUpgradeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/RollbackNodePoolUpgrade",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, req.(*RollbackNodePoolUpgradeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolManagement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolManagementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNodePoolManagement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, req.(*SetNodePoolManagementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLabels(ctx, req.(*SetLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLegacyAbac_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLegacyAbacRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLegacyAbac",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, req.(*SetLegacyAbacRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_StartIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/StartIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, req.(*StartIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CompleteIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CompleteIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, req.(*CompleteIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNodePoolSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, req.(*SetNodePoolSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, req.(*SetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMaintenancePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMaintenancePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetMaintenancePolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, req.(*SetMaintenancePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListUsableSubnetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsableSubnetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListUsableSubnetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListUsableSubnetworks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListUsableSubnetworks(ctx, req.(*ListUsableSubnetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListLocations(ctx, req.(*ListLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.container.v1beta1.ClusterManager",
	HandlerType: (*ClusterManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _ClusterManager_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterManager_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterManager_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterManager_UpdateCluster_Handler,
		},
		{
			MethodName: "UpdateNodePool",
			Handler:    _ClusterManager_UpdateNodePool_Handler,
		},
		{
			MethodName: "SetNodePoolAutoscaling",
			Handler:    _ClusterManager_SetNodePoolAutoscaling_Handler,
		},
		{
			MethodName: "SetLoggingService",
			Handler:    _ClusterManager_SetLoggingService_Handler,
		},
		{
			MethodName: "SetMonitoringService",
			Handler:    _ClusterManager_SetMonitoringService_Handler,
		},
		{
			MethodName: "SetAddonsConfig",
			Handler:    _ClusterManager_SetAddonsConfig_Handler,
		},
		{
			MethodName: "SetLocations",
			Handler:    _ClusterManager_SetLocations_Handler,
		},
		{
			MethodName: "UpdateMaster",
			Handler:    _ClusterManager_UpdateMaster_Handler,
		},
		{
			MethodName: "SetMasterAuth",
			Handler:    _ClusterManager_SetMasterAuth_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterManager_DeleteCluster_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterManager_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _ClusterManager_GetOperation_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _ClusterManager_CancelOperation_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _ClusterManager_GetServerConfig_Handler,
		},
		{
			MethodName: "ListNodePools",
			Handler:    _ClusterManager_ListNodePools_Handler,
		},
		{
			MethodName: "GetNodePool",
			Handler:    _ClusterManager_GetNodePool_Handler,
		},
		{
			MethodName: "CreateNodePool",
			Handler:    _ClusterManager_CreateNodePool_Handler,
		},
		{
			MethodName: "DeleteNodePool",
			Handler:    _ClusterManager_DeleteNodePool_Handler,
		},
		{
			MethodName: "RollbackNodePoolUpgrade",
			Handler:    _ClusterManager_RollbackNodePoolUpgrade_Handler,
		},
		{
			MethodName: "SetNodePoolManagement",
			Handler:    _ClusterManager_SetNodePoolManagement_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ClusterManager_SetLabels_Handler,
		},
		{
			MethodName: "SetLegacyAbac",
			Handler:    _ClusterManager_SetLegacyAbac_Handler,
		},
		{
			MethodName: "StartIPRotation",
			Handler:    _ClusterManager_StartIPRotation_Handler,
		},
		{
			MethodName: "CompleteIPRotation",
			Handler:    _ClusterManager_CompleteIPRotation_Handler,
		},
		{
			MethodName: "SetNodePoolSize",
			Handler:    _ClusterManager_SetNodePoolSize_Handler,
		},
		{
			MethodName: "SetNetworkPolicy",
			Handler:    _ClusterManager_SetNetworkPolicy_Handler,
		},
		{
			MethodName: "SetMaintenancePolicy",
			Handler:    _ClusterManager_SetMaintenancePolicy_Handler,
		},
		{
			MethodName: "ListUsableSubnetworks",
			Handler:    _ClusterManager_ListUsableSubnetworks_Handler,
		},
		{
			MethodName: "ListLocations",
			Handler:    _ClusterManager_ListLocations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/container/v1beta1/cluster_service.proto",
}
