#ifndef _MOVE_GENERATOR_DIALOG_H
#define _MOVE_GENERATOR_DIALOG_H
#include <qdialog.h>
#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"

class QSpinBox;
class QTableView;
class MoveGeneratorDialog : public QDialog
{
Q_OBJECT
public:
  MoveGeneratorDialog(const osl::state::SimpleState &state,
		      const osl::stl::vector<osl::Move> &moves,
		      int limit, 
		      osl::Move next = osl::Move::INVALID(),
		      QWidget *parent = 0, const char *name = 0);
public slots:
  void setStatus(const osl::state::SimpleState &state,
		 const osl::stl::vector<osl::Move> &moves,
		 int limit, osl::Move next_move);
private slots:
  void setLimit(int limit);
private:
  void updateMoves();
  QTableView *view;
  QSpinBox *spinBox;
  int limit;
  osl::state::SimpleState state;
  osl::stl::vector<osl::Move> moves;
  osl::Move next_move;
};

#endif // _MOVE_GENERATOR_DIALOG_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
