// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.keymap;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import org.jetbrains.annotations.NonNls;

import java.util.Map;
import java.util.Set;

public abstract class KeymapsTestCase extends KeymapsTestCaseBase {
  // @formatter:off
  @NonNls @SuppressWarnings({"HardCodedStringLiteral"})
  protected static final Map<String, String[][]> DEFAULT_DUPLICATES = new THashMap<String, String[][]>(){{
    put("$default", new String[][] {
    { "ADD",                      "ExpandTreeNode", "Graph.ZoomIn"},
    { "BACK_SPACE",               "EditorBackSpace", "Images.Thumbnails.UpFolder"},
    { "ENTER",                    "Console.Execute", "Console.TableResult.EditValue", "DirDiffMenu.SynchronizeDiff", "EditorChooseLookupItem",
                                  "EditorEnter", "Images.Thumbnails.EnterAction", "NextTemplateVariable", "PropertyInspectorActions.EditValue",
                                  "SearchEverywhere.SelectItem"},
    { "F2",                       "GotoNextError", "GuiDesigner.EditComponent", "GuiDesigner.EditGroup", "Console.TableResult.EditValue", "XDebugger.SetValue", "Arrangement.Rule.Edit", "Git.Reword.Commit", "ShelvedChanges.Rename", "ChangesView.Rename"},
    { "alt ENTER",                "ShowIntentionActions", "Console.TableResult.EditValue"},
    { "F5",                       "UML.ApplyCurrentLayout", "CopyElement"},
    { "F7",                       "NextDiff", "StepInto"},
    { "INSERT",                   "EditorToggleInsertState", "UsageView.Include", "DomElementsTreeView.AddElement", "DomCollectionControl.Add", "XDebugger.NewWatch"},
    { "SUBTRACT",                 "CollapseTreeNode", "Graph.ZoomOut"},
    { "TAB",                      "EditorChooseLookupItemReplace", "NextTemplateVariable", "NextParameter", "EditorIndentSelection",
                                  "EditorTab", "NextTemplateParameter", "ExpandLiveTemplateByTab", "BraceOrQuoteOut",
                                  "SearchEverywhere.CompleteCommand", "SearchEverywhere.NextTab"},
    { "LEFT",                     "EditorLeft", "Vcs.Log.GoToChild"},
    { "RIGHT",                    "EditorRight", "Vcs.Log.GoToParent"},
    { "alt DOWN",                 "ShowContent", "MethodDown", "Arrangement.Rule.Match.Condition.Move.Down"},
    { "alt UP",                   "MethodUp", "Arrangement.Rule.Match.Condition.Move.Up"},
    { "alt F1",                   "SelectIn", "ProjectViewChangeView"},
    { "alt INSERT",               "FileChooser.NewFolder", "Generate", "NewElement"},
    { "alt LEFT",                 "Diff.PrevChange", "PreviousTab"},
    { "alt RIGHT",                "Diff.NextChange", "NextTab"},
    { "control F10",              "Android.HotswapChanges", "UpdateRunningApplication"},
    { "control 1",                "FileChooser.GotoHome", "GotoBookmark1", "DuplicatesForm.SendToLeft"},
    { "control 2",                "FileChooser.GotoProject", "GotoBookmark2", "DuplicatesForm.SendToRight"},
    { "control 3",                "GotoBookmark3", "FileChooser.GotoModule"},
    { "control ADD",              "ExpandAll", "ExpandExpandableComponent", "ExpandRegion"},
    { "control DIVIDE",           "CommentByLineComment", "Images.Editor.ActualSize", "UML.ActualSize"},
    { "control DOWN",             "EditorScrollDown", "EditorLookupDown", "MethodOverloadSwitchDown", "SearchEverywhere.NavigateToNextGroup"},
    { "control ENTER",            "Console.Execute.Multiline", "DirDiffMenu.SynchronizeDiff.All", "EditorSplitLine", "ViewSource", "PyExecuteCellAction"},
    { "control EQUALS",           "ExpandAll", "ExpandExpandableComponent", "ExpandRegion"},
    { "control F5",               "Refresh", "Rerun"},
    { "control D",                "EditorDuplicate", "Diff.ShowDiff", "CompareTwoFiles", "SendEOF", "FileChooser.GotoDesktop"},
    { "control L",                "FindNext", "Vcs.Log.FocusTextFilter"},
    { "control M",                "EditorScrollToCenter", "Vcs.ShowMessageHistory", "TodoViewGroupByShowModules"},
    { "control F",                "TodoViewGroupByFlattenPackage", "Find"},
    { "control N",                "FileChooser.NewFolder", "GotoClass", "GotoChangedFile"},
    { "control P",                "ChangesView.GroupBy.Directory", "FileChooser.TogglePathShowing", "ParameterInfo", "TodoViewGroupByShowPackages"},
    { "control R",                "Replace", "org.jetbrains.plugins.ruby.rails.console.ReloadSources"},
    { "control SLASH",            "CommentByLineComment", "Images.Editor.ActualSize", "UML.ActualSize"},
    { "control SPACE",            "CodeCompletion", "ChangesView.SetDefault"},
    { "control U",                "GotoSuperMethod", "CommanderSwapPanels"},
    { "control UP",               "EditorScrollUp", "EditorLookupUp", "MethodOverloadSwitchUp", "SearchEverywhere.NavigateToPrevGroup"},
    { "control SUBTRACT",         "CollapseAll", "CollapseExpandableComponent", "CollapseRegion"},
    { "control alt A",            "ChangesView.AddUnversioned", "Diagram.DeselectAll"},
    { "control alt K",            "Git.Commit.And.Push.Executor", "Hg.Commit.And.Push.Executor"},
    { "control alt E",            "PerforceDirect.Edit", "Console.History.Browse"},
    { "control alt DOWN",         "NextOccurence", "Console.TableResult.NextPage"},
    { "control alt G",            "DatabaseView.SqlGenerator", "org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsPopupAction", "Mvc.RunTarget"},
    { "control alt R",            "org.jetbrains.plugins.ruby.tasks.rake.actions.RakeTasksPopupAction", "Django.RunManageTaskAction"},
    { "control alt UP",           "PreviousOccurence", "Console.TableResult.PreviousPage"},
    { "control alt N",            "Inline", "Console.TableResult.SetNull"},
    { "ctrl alt H",               "CallHierarchy", "ChangesView.ShelveSilently"},
    { "ctrl alt U",               "ShowUmlDiagramPopup", "ChangesView.UnshelveSilently"}, 
    { "control MINUS",            "CollapseAll", "CollapseExpandableComponent", "CollapseRegion"},
    { "control PERIOD",           "EditorChooseLookupItemDot", "CollapseSelection"},
    { "shift DELETE",             "$Cut", "Maven.Uml.Exclude"},
    { "shift ENTER",              "CollapseExpandableComponent", "Console.TableResult.EditValueMaximized", "DatabaseView.PropertiesAction", "EditorStartNewLine", "ExpandExpandableComponent", "OpenElementInNewWindow"},
    { "shift F4",                 "Debugger.EditTypeSource", "EditSourceInNewWindow"},
    { "shift F6",                 "RenameElement", "Git.Reword.Commit", "ShelvedChanges.Rename", "ChangesView.Rename"},
    { "shift F7",                 "PreviousDiff", "SmartStepInto"},
    { "shift TAB",                "PreviousTemplateVariable", "PrevParameter", "EditorUnindentSelection", "PrevTemplateParameter", "SearchEverywhere.PrevTab"},
    { "shift alt L",              "org.jetbrains.plugins.ruby.console.LoadInIrbConsoleAction", "context.load"},
    { "shift alt M",              "ChangesView.Move", "Vcs.MoveChangedLinesToChangelist"},
    { "shift control D",          "TagDocumentationNavigation", "Diff.ShowSettingsPopup", "Uml.ShowDiff", "Console.TableResult.CompareCells"},
    { "shift control DOWN",       "ResizeToolWindowDown", "MoveStatementDown"},
    { "shift control ENTER",      "EditorCompleteStatement", "Console.Jpa.GenerateSql"},
    { "shift control F10",        "Console.Open", "RunClass", "RunTargetAction"},
    { "shift control F8",         "ViewBreakpoints", "EditBreakpoint"},
    { "shift control G",          "ClassTemplateNavigation", "GoToClass"},
    { "shift control LEFT",       "EditorPreviousWordWithSelection", "ResizeToolWindowLeft", },
    { "shift control RIGHT",      "EditorNextWordWithSelection", "ResizeToolWindowRight", },
    { "shift control T",          "GotoTest", "Images.ShowThumbnails", "RunDashboard.ShowConfigurations"},
    { "shift control UP",         "ResizeToolWindowUp", "MoveStatementUp"},
    { "shift control alt D",      "UML.ShowChanges", "Console.TableResult.CloneColumn"},
    { "shift control U",          "ShelveChanges.UnshelveWithDialog", "EditorToggleCase"},
    { "shift control alt ENTER",  "Console.Jpa.GenerateDDL", "Console.Transaction.Commit"},
    { "control E",                "RecentFiles", "Vcs.ShowMessageHistory"},
    { "control alt Z",            "Vcs.RollbackChangedLines", "ChangesView.Revert"},
    { "control TAB",              "Switcher", "Diff.FocusOppositePane"},
    { "shift control TAB",        "Switcher", "Diff.FocusOppositePaneAndScroll"},
    { "ctrl alt ENTER",           "EditorStartNewLineBefore", "QuickActionPopup"},
    { "button2",                  "EditorPasteFromX11", "GotoDeclaration"}, // False positive: see DefaultKeymapImpl, PasteFromX11Action.update()
    { "ctrl alt F",               "IntroduceField", "ShowFilterPopup"},
    { "PAGE_DOWN",                "EditorPageDown", "SearchEverywhere.NavigateToNextGroup"},
    { "PAGE_UP",                  "EditorPageUp", "SearchEverywhere.NavigateToPrevGroup"},
    });
    put("Mac OS X 10.5+", new String[][] {
    { "BACK_SPACE",               "$Delete", "EditorBackSpace", "Images.Thumbnails.UpFolder"},
    { "shift BACK_SPACE",         "EditorBackSpace", "UsageView.Include"},
    { "meta BACK_SPACE",          "EditorDeleteLine", "$Delete"},
    { "control LEFT",             "Diff.PrevChange", "PreviousTab"},
    { "control RIGHT",            "Diff.NextChange", "NextTab"},
    { "control DOWN",             "ShowContent", "EditorLookupDown", "MethodDown"},
    { "control UP",               "EditorLookupUp", "MethodUp"},
    { "control TAB",              "Switcher", "Diff.FocusOppositePane"},
    { "shift control TAB",        "Switcher", "Diff.FocusOppositePaneAndScroll"},
    { "meta L",                   "Vcs.Log.FocusTextFilter", "GotoLine"},
    { "meta R",                   "Refresh", "Rerun", "Replace", "org.jetbrains.plugins.ruby.rails.console.ReloadSources"},
    { "control O",                "ExportToTextFile", "OverrideMethods", },
    { "control ENTER",            "Generate", "NewElement", "PyExecuteCellAction"},
    { "control SPACE",            "CodeCompletion", "ChangesView.SetDefault"},
    { "ctrl meta R",              "Android.HotswapChanges", "RerunTests"},
    { "meta 1",                   "ActivateProjectToolWindow", "FileChooser.GotoHome", "DuplicatesForm.SendToLeft"},
    { "meta 2",                   "ActivateFavoritesToolWindow", "FileChooser.GotoProject", "DuplicatesForm.SendToRight"},
    { "meta 3",                   "ActivateFindToolWindow", "FileChooser.GotoModule"},
    { "meta M",                   "MinimizeCurrentWindow", "TodoViewGroupByShowModules"},
    { "meta N",                   "FileChooser.NewFolder", "Generate", "NewElement"},
    { "meta O",                   "GotoClass", "GotoChangedFile"},
    { "shift meta G",             "ClassTemplateNavigation", "GoToClass", "FindPrevious"},
    { "shift meta M",             "ChangesView.Move", "Vcs.MoveChangedLinesToChangelist"},
    { "shift meta LEFT",          "EditorLineStartWithSelection", "ResizeToolWindowLeft", },
    { "shift meta RIGHT",         "EditorLineEndWithSelection", "ResizeToolWindowRight", },
    { "shift meta CLOSE_BRACKET", "Diff.NextChange", "NextTab"},
    { "shift meta OPEN_BRACKET",  "Diff.PrevChange", "PreviousTab"},
    { "alt R",                    "Django.RunManageTaskAction", "org.jetbrains.plugins.ruby.tasks.rake.actions.RakeTasksPopupAction"},
    { "alt DOWN",                 "EditorUnSelectWord", "Arrangement.Rule.Match.Condition.Move.Down", "MethodOverloadSwitchDown"},
    { "alt UP",                   "EditorSelectWord", "Arrangement.Rule.Match.Condition.Move.Up", "MethodOverloadSwitchUp"},
    { "ctrl m",                   "EditorMatchBrace", "Vcs.ShowMessageHistory"},
    { "meta UP",                  "ShowNavBar", "SearchEverywhere.NavigateToPrevGroup"},
    { "meta DOWN",                "EditSource", "SearchEverywhere.NavigateToNextGroup"},
    });
    put("Mac OS X", new String[][] {
    { "BACK_SPACE",               "$Delete", "EditorBackSpace", "Images.Thumbnails.UpFolder"},
    { "control LEFT",             "Diff.PrevChange", "PreviousTab"},
    { "control RIGHT",            "Diff.NextChange", "NextTab"},
    { "control DOWN",             "EditorLookupDown", "ShowContent", "MethodDown"},
    { "control UP",               "EditorLookupUp", "MethodUp"},
    { "control ENTER",            "Generate", "NewElement", "PyExecuteCellAction"},
    { "control F5",               "Refresh", "Rerun"},
    { "control TAB",              "Switcher", "Diff.FocusOppositePane"},
    { "control N",                "Generate", "NewElement"},
    { "shift control TAB",        "Switcher", "Diff.FocusOppositePaneAndScroll"},
    { "meta M",                   "MinimizeCurrentWindow", "TodoViewGroupByShowModules"},
    { "meta 1",                   "ActivateProjectToolWindow", "FileChooser.GotoHome", "DuplicatesForm.SendToLeft"},
    { "meta 2",                   "ActivateFavoritesToolWindow", "FileChooser.GotoProject", "DuplicatesForm.SendToRight"},
    { "meta 3",                   "ActivateFindToolWindow", "FileChooser.GotoModule"},
    { "shift meta LEFT",          "EditorLineStartWithSelection", "ResizeToolWindowLeft", },
    { "shift meta RIGHT",         "EditorLineEndWithSelection", "ResizeToolWindowRight", },
    { "alt R",                    "Django.RunManageTaskAction", "org.jetbrains.plugins.ruby.tasks.rake.actions.RakeTasksPopupAction"},
    });
    put("Emacs", new String[][] {
    { "TAB",                      "EditorChooseLookupItemReplace", "NextTemplateVariable", "NextParameter", "EditorIndentSelection",
                                  "EmacsStyleIndent", "NextTemplateParameter", "ExpandLiveTemplateByTab", "BraceOrQuoteOut",
                                  "SearchEverywhere.CompleteCommand", "SearchEverywhere.NextTab"},
    { "alt SLASH",                "CodeCompletion", "HippieCompletion"},
    { "control D",                "$Delete", "Diff.ShowDiff", "CompareTwoFiles", "SendEOF", "FileChooser.GotoDesktop"},
    { "control K",                "EditorCutLineEnd", "CheckinProject"},
    { "control L",                "EditorScrollToCenter", "Vcs.Log.FocusTextFilter"},
    { "control M",                "EditorEnter", "EditorChooseLookupItem", "NextTemplateVariable", "Console.Execute", "TodoViewGroupByShowModules"},
    { "control N",                "EditorDown", "FileChooser.NewFolder"},
    { "control F",                "EditorRight", "TodoViewGroupByFlattenPackage"},
    { "control P",                "ChangesView.GroupBy.Directory", "EditorUp", "FileChooser.TogglePathShowing","TodoViewGroupByShowPackages"},
    { "control R",                "org.jetbrains.plugins.ruby.rails.console.ReloadSources", "FindPrevious"},
    { "control SLASH",            "$Undo", "Images.Editor.ActualSize", "UML.ActualSize"},
    { "control SPACE",            "EditorToggleStickySelection", "ChangesView.SetDefault"},
    { "control X,N",              "Diff.NextChange", "NextTab"},
    { "control X,P",              "Diff.PrevChange", "PreviousTab"},
    { "control UP",               "EditorBackwardParagraph", "EditorLookupUp", "MethodOverloadSwitchUp", "SearchEverywhere.NavigateToPrevGroup"},
    { "control DOWN",             "EditorForwardParagraph", "EditorLookupDown", "MethodOverloadSwitchDown", "SearchEverywhere.NavigateToNextGroup"},
    { "control alt A",            "MethodUp", "ChangesView.AddUnversioned", "Diagram.DeselectAll"},
    { "control alt E",            "MethodDown", "PerforceDirect.Edit", "Console.History.Browse"},
    { "control alt G",            "GotoDeclaration", "org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsPopupAction", "Mvc.RunTarget"},
    { "control alt S",            "ShowSettings", "Find"},
    { "shift alt S",              "FindUsages", "context.save"},
    { "shift alt G",              "GotoChangedFile", "GotoClass", "hg4idea.QGotoFromPatches"},
    { "shift alt P",              "ParameterInfo", "hg4idea.QPushAction"},
    { "shift control X",          SECOND_STROKE, "com.jetbrains.php.framework.FrameworkRunConsoleAction"},
    });
    put("Visual Studio", new String[][] {
    { "F5",                       "Resume", "UML.ApplyCurrentLayout"},
    { "F7",                       "NextDiff", "CompileDirty"},
    { "alt F2",                   "ShowBookmarks", "WebOpenInAction"},
    { "alt F8",                   "ReformatCode", "ForceStepInto", "EvaluateExpression"},
    { "control COMMA",            "GotoClass", "GotoChangedFile"},
    { "control F1",               "ExternalJavaDoc", "ShowErrorDescription"},
    { "control F10",              "Android.HotswapChanges", "RunToCursor", "UpdateRunningApplication"},
    { "control N",                "FileChooser.NewFolder", "Generate", },
    { "control P",                "ChangesView.GroupBy.Directory", "FileChooser.TogglePathShowing", "Print", "TodoViewGroupByShowPackages"},
    { "control alt F",            "ReformatCode", "IntroduceField", "ShowFilterPopup"},
    { "shift F12",                "RestoreDefaultLayout", "FindUsagesInFile"},
    { "shift F2",                 "GotoPreviousError", "GotoDeclaration"},
    { "shift control F7",         "FindUsagesInFile", "HighlightUsagesInFile"},
    { "shift control I",          "ImplementMethods", "QuickImplementations"},
    { "alt F9",                   "ViewBreakpoints", "EditBreakpoint"},
    { "alt MULTIPLY",             "ShowExecutionPoint", "Images.Thumbnails.ToggleRecursive"},
    { "shift alt U",              "GotoPrevElementUnderCaretUsage", "ToggleCamelSnakeCase"},
    { "shift alt D",              "GotoNextElementUnderCaretUsage", "hg4idea.QFold"}
    });
    put("Default for XWin", new String[][] {
    { "shift ctrl alt button1",   "EditorAddRectangularSelectionOnMouseDrag", "QuickEvaluateExpression"},
    });
    put("Default for GNOME", new String[][] {
    { "shift alt 1",              "SelectIn", "ProjectViewChangeView"},
    { "shift alt 7",              "IDEtalk.SearchUserHistory", "FindUsages"},
    { "shift alt LEFT",           "PreviousEditorTab", "Back"},
    { "shift alt RIGHT",          "NextEditorTab", "Forward"},
    });
    put("Default for KDE", new String[][] {
    { "control 1",                "FileChooser.GotoHome", "ShowErrorDescription", "DuplicatesForm.SendToLeft"},
    { "control 2",                "FileChooser.GotoProject", "Stop", "DuplicatesForm.SendToRight"},
    { "control 3",                "FindWordAtCaret", "FileChooser.GotoModule"},
    { "control 5",                "Refresh", "Rerun"},
    { "shift alt 1",              "SelectIn", "ProjectViewChangeView"},
    { "shift alt 7",              "IDEtalk.SearchUserHistory", "FindUsages"},
    { "shift alt L",              "ReformatCode", "org.jetbrains.plugins.ruby.console.LoadInIrbConsoleAction", "context.load"},
    });
    put("Eclipse", new String[][] {
    { "F2",                       "Console.TableResult.EditValue", "QuickJavaDoc", "XDebugger.SetValue", "Arrangement.Rule.Edit"},
    { "F5",                       "UML.ApplyCurrentLayout", "StepInto"},
    { "alt DOWN",                 "ShowContent", "MoveStatementDown", "Arrangement.Rule.Match.Condition.Move.Down"},
    { "alt UP",                   "MoveStatementUp", "Arrangement.Rule.Match.Condition.Move.Up"},
    { "alt HOME",                 "ViewNavigationBar", "ShowNavBar"},
    { "control F10",              "Android.HotswapChanges", "ShowPopupMenu", "UpdateRunningApplication"},
    { "control D",                "EditorDeleteLine", "Diff.ShowDiff", "CompareTwoFiles", "SendEOF", "FileChooser.GotoDesktop"},
    { "control L",                "Vcs.Log.FocusTextFilter", "GotoLine"},
    { "control N",                "ShowPopupMenu", "FileChooser.NewFolder"},
    { "control P",                "ChangesView.GroupBy.Directory", "FileChooser.TogglePathShowing", "Print", "TodoViewGroupByShowPackages"},
    { "control R",                "RunToCursor", "org.jetbrains.plugins.ruby.rails.console.ReloadSources"},
    { "control U",                "EvaluateExpression", "CommanderSwapPanels"},
    { "control F",                "Replace", "TodoViewGroupByFlattenPackage"},
    { "control PAGE_DOWN",        "Diff.NextChange", "NextTab"},
    { "control PAGE_UP",          "Diff.PrevChange", "PreviousTab"},
    { "control F6",               "Diff.NextChange", "NextTab"},
    { "control alt DOWN",         "Console.TableResult.NextPage", "EditorDuplicateLines"},
    { "control alt E",            "Console.History.Browse", "ExecuteInPyConsoleAction", "PerforceDirect.Edit"},
    { "control alt LEFT",         "Diff.NextChange", "NextTab"},
    { "control alt RIGHT",        "Diff.PrevChange", "PreviousTab"},
    { "shift alt D",              "hg4idea.QFold", "Debug"},
    { "shift alt G",              "RerunTests", "hg4idea.QGotoFromPatches"},
    { "shift alt L",              "IntroduceVariable", "org.jetbrains.plugins.ruby.console.LoadInIrbConsoleAction", "context.load"},
    { "shift alt P",              "hg4idea.QPushAction", "ImplementMethods"},
    { "shift alt R",              "RenameElement", "Git.Reword.Commit", "ShelvedChanges.Rename", "ChangesView.Rename"},
    { "shift alt S",              "ShowPopupMenu", "context.save"},
    { "shift alt T",              "ShowPopupMenu", "tasks.switch"},
    { "shift control DOWN",       "ResizeToolWindowDown", "MethodDown"},
    { "shift control E",          "EditSource", "RecentChangedFiles"},
    { "shift control F6",         "ChangeTypeSignature", "Diff.PrevChange", "PreviousTab"},
    { "shift control F11",        "ToggleBookmark", "FocusTracer"},
    { "shift control G",          "FindUsagesInFile", "ClassTemplateNavigation", "GoToClass"},
    { "shift control I",          "QuickImplementations", "XDebugger.Inspect"},
    { "shift control UP",         "ResizeToolWindowUp", "MethodUp"},
    { "shift control K",          "Vcs.Push", "FindPrevious"},
    { "shift control X",          "EditorToggleCase", "com.jetbrains.php.framework.FrameworkRunConsoleAction"},
    { "shift control T",          "GotoClass", "GotoChangedFile"},
    });
    put("NetBeans 6.5", new String[][] {
    { "F4",                       "RunToCursor", "EditSource"},
    { "F5",                       "Debugger.ResumeThread", "Resume", "UML.ApplyCurrentLayout"},
    { "alt DOWN",                 "GotoNextElementUnderCaretUsage", "ShowContent", "Arrangement.Rule.Match.Condition.Move.Down"},
    { "alt UP",                   "GotoPrevElementUnderCaretUsage", "Arrangement.Rule.Match.Condition.Move.Up"},
    { "control 1",                "ActivateProjectToolWindow", "DuplicatesForm.SendToLeft"},
    { "control 2",                "ActivateProjectToolWindow", "FileChooser.GotoProject", "DuplicatesForm.SendToRight"},
    { "control 3",                "ActivateProjectToolWindow", "FileChooser.GotoModule"},
    { "control BACK_SPACE",       "EditorDeleteToWordStart", "ToggleDockMode"},
    { "control DIVIDE",           "CollapseRegionRecursively", "Images.Editor.ActualSize", "UML.ActualSize"},
    { "control M",                "Vcs.ShowMessageHistory", "Move", "TodoViewGroupByShowModules"},
    { "control N",                "NewElement", "FileChooser.NewFolder"},
    { "control R",                "RenameElement", "org.jetbrains.plugins.ruby.rails.console.ReloadSources", "Git.Reword.Commit", "ShelvedChanges.Rename", "ChangesView.Rename"},
    { "control U",                SECOND_STROKE, "CommanderSwapPanels"},
    { "control O",                "GotoClass", "GotoChangedFile"},
    { "control PERIOD",           "GotoNextError", "EditorChooseLookupItemDot"},
    { "control PAGE_DOWN",        "Diff.NextChange", "NextTab"},
    { "control PAGE_UP",          "Diff.PrevChange", "PreviousTab"},
    { "control alt DOWN",         "MethodDown", "NextOccurence", "Console.TableResult.NextPage"},
    { "control alt UP",           "MethodUp", "PreviousOccurence", "Console.TableResult.PreviousPage"},
    { "shift F4",                 "RecentFiles", "Debugger.EditTypeSource", "Vcs.ShowMessageHistory", "EditSourceInNewWindow"},
    { "shift alt F9",             "ChooseDebugConfiguration", "ValidateXml", "ValidateJsp"},
    { "shift alt D",              "ToggleFloatingMode", "hg4idea.QFold"},
    { "shift control DOWN",       "EditorDuplicate", "ResizeToolWindowDown", },
    { "shift control F7",         "HighlightUsagesInFile", "XDebugger.NewWatch"},
    { "shift control UP",         "EditorDuplicate", "ResizeToolWindowUp", },
    { "shift control alt P",      "Print", "Graph.Print"},
    { "shift control K",          "HippieCompletion", "Vcs.Push"},
    { "control alt E",            "Console.History.Browse", "ExecuteInPyConsoleAction", "PerforceDirect.Edit"},
    });
    put("JBuilder", new String[][] {
    { "F2",                       "EditorTab", "GuiDesigner.EditComponent", "GuiDesigner.EditGroup", "Console.TableResult.EditValue", "XDebugger.SetValue", "Arrangement.Rule.Edit", "Git.Reword.Commit", "ShelvedChanges.Rename", "ChangesView.Rename"},
    { "F5",                       "ToggleBreakpointEnabled", "UML.ApplyCurrentLayout"},
    { "TAB",                      "EditorChooseLookupItemReplace", "NextTemplateVariable", "NextParameter", "EditorIndentSelection",
                                  "EmacsStyleIndent", "NextTemplateParameter", "ExpandLiveTemplateByTab", "BraceOrQuoteOut",
                                  "SearchEverywhere.CompleteCommand", "SearchEverywhere.NextTab"},
    { "control F6",               "PreviousEditorTab", "PreviousTab", },
    { "control L",                "Vcs.Log.FocusTextFilter", "EditorSelectLine"},
    { "control M",                "Vcs.ShowMessageHistory", "OverrideMethods", "TodoViewGroupByShowModules"},
    { "control P",                "ChangesView.GroupBy.Directory", "FileChooser.TogglePathShowing", "FindInPath", "TodoViewGroupByShowPackages"},
    { "shift control A",          "SaveAll", "GotoAction"},
    { "shift control E",          "RecentChangedFiles", "ExtractMethod"},
    { "shift control ENTER",      "FindUsages", "Console.Jpa.GenerateSql"},
    { "shift control F6",         "NextTab", "ChangeTypeSignature"},
    { "shift control G",          "GotoSymbol", "ClassTemplateNavigation", "GoToClass"},
    { "shift control X",          "EditorToggleShowWhitespaces", "com.jetbrains.php.framework.FrameworkRunConsoleAction"},
    });
    put("Eclipse (Mac OS X)", new String[][] {
    { "meta BACK_SPACE",          "EditorDeleteToWordStart", "$Delete"},
    { "F2",                       "Console.TableResult.EditValue", "QuickJavaDoc", "XDebugger.SetValue", "Arrangement.Rule.Edit", "Git.Reword.Commit", "ShelvedChanges.Rename", "ChangesView.Rename"},
    { "F3",                       "GotoDeclaration", "EditSource"},
    { "F5",                       "StepInto", "UML.ApplyCurrentLayout"},
    { "alt DOWN",                 "MoveStatementDown", "Arrangement.Rule.Match.Condition.Move.Down", "MethodOverloadSwitchDown"},
    { "alt UP",                   "MoveStatementUp", "Arrangement.Rule.Match.Condition.Move.Up", "MethodOverloadSwitchUp"},
    { "control PERIOD",           "EditorChooseLookupItemDot", "HippieCompletion"},
    { "meta 1",                   "FileChooser.GotoHome", "ShowIntentionActions", "DuplicatesForm.SendToLeft"},
    { "meta 3",                   "FileChooser.GotoModule", "GotoAction"},
    { "meta D",                   "EditorDeleteLine", "Diff.ShowDiff", "CompareTwoFiles", "SendEOF", "FileChooser.GotoDesktop"},
    { "meta I",                   "DatabaseView.PropertiesAction", "AutoIndentLines"},
    { "meta P",                   "ChangesView.GroupBy.Directory", "FileChooser.TogglePathShowing", "Print", "TodoViewGroupByShowPackages"},
    { "meta R",                   "org.jetbrains.plugins.ruby.rails.console.ReloadSources", "RunToCursor"},
    { "meta U",                   "CommanderSwapPanels", "EvaluateExpression"},
    { "meta W",                   "CloseContent", "CloseActiveTab"},
    { "meta F6",                  "Diff.NextChange", "NextTab"},
    { "shift meta T",             "GotoClass", "GotoChangedFile"},
    { "meta alt LEFT",            "Diff.PrevChange", "PreviousTab"},
    { "meta alt RIGHT",           "Diff.NextChange", "NextTab"},
    { "meta alt DOWN",            "Console.TableResult.NextPage", "EditorDuplicateLines"},
    { "shift meta F11",           "Run", "FocusTracer"},
    { "shift meta G",             "ClassTemplateNavigation", "GoToClass", "FindUsages"},
    { "shift meta K",             "Vcs.Push", "FindPrevious"},
    { "shift meta X",             "EditorToggleCase", "com.jetbrains.php.framework.FrameworkRunConsoleAction"},
    { "shift meta U",             "FindUsagesInFile", "ShelveChanges.UnshelveWithDialog"},
    { "shift meta F6",            "Diff.PrevChange", "PreviousTab"},
    { "control shift alt Z",      "Vcs.RollbackChangedLines", "ChangesView.Revert"},
    { "meta alt H",               "ChangesView.ShelveSilently", "RunDashboard.ShowConfigurations"}
    });
  }};
  // @formatter:on

  @NonNls protected static final Set<String> DEFAULT_UNKNOWN_ACTION_IDS = ContainerUtil.set(
    "ActivateVersionControlToolWindow", "ActivateFavoritesToolWindow", "ActivateCommanderToolWindow", "ActivateDebugToolWindow",
    "ActivateFindToolWindow",
    "ActivateHierarchyToolWindow", "ActivateMessagesToolWindow", "ActivateProjectToolWindow", "ActivateRunToolWindow",
    "ActivateStructureToolWindow", "ActivateTODOToolWindow", "ActivateWebToolWindow", "ActivatePaletteToolWindow",
    "ActivateTerminalToolWindow",
    "IDEtalk.SearchUserHistory", "IDEtalk.SearchUserHistory", "IDEtalk.Rename",
    ""
  );

  @NonNls protected static final Set<String> DEFAULT_BOUND_ACTIONS = ContainerUtil.set(
    "EditorDelete"
  );
}
