/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetpopup.h"
#include "widgetoptions.h"

#include <QtGui>

//La fentre qui apparat quand on clique sur le menu "Licence" est diffrente des 4 autres fentres de ce type
//(elle possde deux boutons en plus), d'o le boolen "est_fenetre_licence" pour dterminer dans quel cas on se trouve
WidgetPopup::WidgetPopup( QWidget* parent, bool est_fenetre_licence, QString nomFichier, QString titreFenetre)
	 : QDialog( parent) {
	//titre de fentre
	if(titreFenetre!=QString("")) {
		setWindowTitle(titreFenetre);
	}
		
	//un layout vertical pour le QDialog WidgetPopup
	QVBoxLayout *vboxPopup = new QVBoxLayout( this );
	vboxPopup->setSpacing(0);
	vboxPopup->setMargin(0);
	
	//deux layouts horizontaux dans lesquels on placera le texte pour l'un, le ou les boutons pour l'autre
	QWidget *horizontalLayout1 = new QWidget( this );
	QWidget *horizontalLayout2 = new QWidget( this );
	QHBoxLayout *hboxLayout1 = new QHBoxLayout(horizontalLayout1);
	QHBoxLayout *hboxLayout2 = new QHBoxLayout(horizontalLayout2);
	
	hboxLayout1->setSpacing(0);
	hboxLayout1->setMargin(0);
	hboxLayout2->setSpacing(0);
	hboxLayout2->setMargin(0);
	
	vboxPopup->addWidget( horizontalLayout1 );
	vboxPopup->addWidget( horizontalLayout2 );
	
	//le cadre de texte
	QTextBrowser *textEditPopup = new QTextBrowser( horizontalLayout1 );
	
	//la taille du texte, dont dpend la taille de la fentre au lancement
	textEditPopup->setMinimumWidth(600);
	textEditPopup->setMinimumHeight(400);
	
	//paramtres du texte
	textEditPopup->setReadOnly( TRUE );
	textEditPopup->setOpenExternalLinks( TRUE );	//pour utiliser un navigateur pour ouvrir les liens externes
	
	if(nomFichier!=QString("")) {
		QFile fichier(nomFichier);
		fichier.open( QIODevice::ReadOnly );
		QTextStream textestream( &fichier );
		if (nomFichier.contains("ja")) {
			textestream.setCodec("UTF-8");		//textes en japonais
		}
		else{
			textestream.setCodec("ISO 8859-1");	//textes en franais ou anglais
		}
		textEditPopup->setHtml(textestream.readAll());	//lecture du texte du fichier
		fichier.close();
	}
	
	hboxLayout1->addWidget(textEditPopup);
	
	//les boutons "Licence", "Traduction", que l'on affiche ou non suivant le cas
	if (est_fenetre_licence){
		QPushButton *pbLicence = new QPushButton( tr("Licence GPL"), horizontalLayout2 );
		pbLicence->setFont( font_normal );
		connect( pbLicence, SIGNAL( clicked() ), this, SLOT( ouvre_licence() ) );
		
		hboxLayout2->addStretch(1);
		hboxLayout2->addWidget(pbLicence);
		hboxLayout2->addStretch(1);
		
		//Ajout d'une traduction pour les non-anglophones
		if (WidgetOptions::langue!="en") {
			QPushButton *pbTraduction = new QPushButton( tr("Traduction de la GPL"), horizontalLayout2 );
			pbTraduction->setFont( font_normal );
			hboxLayout2->addWidget(pbTraduction);
			connect( pbTraduction, SIGNAL( clicked() ), this, SLOT( ouvre_traduction() ) );
		}
	}
	
	//le bouton "OK" que l'on affiche de toute faon
	QPushButton* pbOk = new QPushButton( tr("OK"), horizontalLayout2 );
	pbOk->setFont( font_normal );
	//Il capte le focus au lancement, ce qui permet de juste avoir  appuyer sur "Entre" pour sortir de la fentre
	pbOk->setFocus();
	hboxLayout2->addStretch(1);
	hboxLayout2->addWidget(pbOk);
	hboxLayout2->addStretch(1);
	
	//on ferme la fentre quand on clique sur "OK"
	connect( pbOk, SIGNAL( clicked() ), this, SLOT( close() ) );
}

//fonction d'affichage d'une fentre contenant la GPL en anglais
//traduction ou non suivant boolen
void WidgetPopup::ouvre_licence() {
	lire_texte(false);
}

//fonction d'affichage d'une fentre contenant la GPL en franais
void WidgetPopup::ouvre_traduction() {
	lire_texte(true);
}

void WidgetPopup::lire_texte(bool traduction) {
	if(traduction) {
		WidgetPopup popup( this, false, QString(tr(":/txt/gpl-fr.html")),
						QString(tr("Traduction de la Licence GNU GPL")));
		popup.exec();
	} else {
		WidgetPopup popup( this, false, QString(":/txt/gpl-en.html"),
						QString(tr("Licence originale (anglais) GNU GPL")));
		popup.exec();
	}
}
