#ifndef ADDRESSBOOKNOTIFICATIONS_H
#define ADDRESSBOOKNOTIFICATIONS_H

#include "notificationmanager.h"
#include "../network/msnnotificationconnection.h"

// Forward declarations
class NotificationManager;
class AddressBookService;


/**
 * @brief All notifications that relate to AddressBookService (contact/group added/deleted)
 *
 * Notification is made via a popup balloon and a sound (which can be customized)
 *
 * @author Timo Tambet <ttambet@gmail.com>
 * @ingroup Notification
 */
class AddressBookNotifications : public QObject
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    AddressBookNotifications( NotificationManager* manager );

  public slots:
    // Notify the user about this event (a contact has contacted the user)
    void                  notify( const QString& id, AddressBookService::AddressBookUpdate updateType  );

  private slots:
    // Execute the action triggered in a notification
    void                  activate( NotificationManager::EventSettings settings, NotificationManager::Buttons button );

  private:  // Private properties
    // The notification manager instance
    NotificationManager  *manager_;

};

#endif
