/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef TITLEWIDGET_H
#define TITLEWIDGET_H

#include <QWidget>

#define TITLE_BAR_FIXED_HEIGHT 40

class KMenu;
class QLabel;
class QPushButton;

class TitleWidget : public QWidget
{
    Q_OBJECT
public:
    explicit TitleWidget(QWidget *parent = nullptr);
    ~TitleWidget();

    int getMenuBtnX();
    void setTitle(QString title, bool tip = true);
    void updateMaxButtonStatus(bool is_maxed);
    void setButtonState(bool is_available);

    void setMiniMode(bool mini){m_isMiniMode = mini;}
    void setHide();
    void setShow();
    void setHomePage(bool _isHomePage);

signals:
    void sigMiniMode();
    void sigMiniSize();
    void sigMaxSize();
    void sigShowMenu();
    void sigClose();
    void sigCanHide(bool);
    void sigDBClicked();

private:
    void initLayout();
    void initConnect();
    void resetFont();

private:
    QString m_fullTitle;
    QPushButton *btnIcon;
    QLabel  *labTitle;

    QWidget *widget;
    KMenu   *menu;

    QPushButton *btnMenu,
                *btnMiniMode,
                *btnMinSize,
                *btnMaxSize,
                *btnClose;

    bool m_isMiniMode = false,
         m_isHomePage = true,
         m_leaveState = false;

protected:
    bool event(QEvent *e) override;
    void enterEvent(QEvent *e) override;
    void leaveEvent(QEvent *e) override;
    void resizeEvent(QResizeEvent *e) override;
    void mouseDoubleClickEvent(QMouseEvent *event) override;
};

#endif // TITLEWIDGET_H
