%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.17.6"

\header {
  lsrtags = "editorial-annotations, scheme-language, tweaks-and-overrides"

  texidoc = "
To add a link to a grob-stencil you could use @code{add-link} as
defined here. Works with @code{\\override} and @code{\\tweak}.
Drawback: @code{point-and-click} will be disturbed for the linked grobs.

Limitation: Works for PDF only.

The linked objects are colored with a separate command.

"
  doctitle = "Adding links to objects"
} % begin verbatim

% Code by Thomas Morley
% Contributed by harm6
% Tested with 2.14.2 up to 2.17.9

#(define (add-link url-strg)
  (lambda (grob)
    (let* ((stil (ly:grob-property grob 'stencil)))
      (if (ly:stencil? stil)
        (begin
          (let* (
             (x-ext (ly:stencil-extent stil X))
             (y-ext (ly:stencil-extent stil Y))
             (url-expr (list 'url-link url-strg `(quote ,x-ext) `(quote ,y-ext)))
             (new-stil (ly:stencil-add (ly:make-stencil url-expr x-ext y-ext) stil)))
          (ly:grob-set-property! grob 'stencil new-stil)))
        #f))))

%%%% test

urlI =
"http://lilypond.org/doc/v2.14/Documentation/notation/writing-pitches"

urlII =
"http://lilypond.org/doc/v2.14/Documentation/notation/rhythms"

urlIII =
"http://lilypond.org/doc/v2.14/Documentation/notation/note-heads"

urlIV =
"http://lilypond.org/doc/v2.14/Documentation/notation/beams"

urlV =
"http://lilypond.org/doc/v2.14/Documentation/notation/note-head-styles"

\relative c' {
  \key cis \minor

  \once \override Staff.Clef.color = #green
  \once \override Staff.Clef.after-line-breaking =
    #(add-link urlI)

  \once \override Staff.TimeSignature.color = #green
  \once \override Staff.TimeSignature.after-line-breaking =
    #(add-link urlII)

  \once \override NoteHead.color = #green
  \once \override NoteHead.after-line-breaking =
    #(add-link urlIII)

  cis'1
  \once \override Beam.color = #green
  \once \override Beam.after-line-breaking =
    #(add-link urlIV)
  cis8 dis e fis gis2
  <gis,
   % With 2.17.9 you could use the command below to address the Accidental.
   % \tweak Accidental.before-line-breaking #(add-link url)
   \tweak color #green
   \tweak after-line-breaking #(add-link urlV)
   \tweak style #'harmonic
   bis
   dis
   fis
  >1
  <cis, cis' e>
}
