/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 14170 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "dessertAppParamsTable.h"
#include "dessertAppParamsTable_data_access.h"
#include "../dessert.h"
#include "../dessert_internal.h"


/** @ingroup interface
 * @addtogroup data_access data_access: Routines to access data
 *
 * These routines are used to locate the data used to satisfy
 * requests.
 * 
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table dessertAppParamsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * DESSERT-MIB::dessertAppParamsTable is subid 9 of dessertObjects.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9, length: 13
 */

/**
 * initialization for dessertAppParamsTable data access
 *
 * This function is called during startup to allow you to
 * allocate any resources you need for the data table.
 *
 * @param dessertAppParamsTable_reg
 *        Pointer to dessertAppParamsTable_registration
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : unrecoverable error.
 */
int
dessertAppParamsTable_init_data(dessertAppParamsTable_registration *
                                dessertAppParamsTable_reg)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_init_data", "called\n"));

    /*
     * TODO:303:o: Initialize dessertAppParamsTable data.
     */


    return MFD_SUCCESS;
}                               /* dessertAppParamsTable_init_data */

/**
 * container overview
 *
 */

/**
 * container initialization
 *
 * @param container_ptr_ptr A pointer to a container pointer. If you
 *        create a custom container, use this parameter to return it
 *        to the MFD helper. If set to NULL, the MFD helper will
 *        allocate a container for you.
 *
 *  This function is called at startup to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases. If no custom
 *  container is allocated, the MFD code will create one for your.
 *
 * @remark
 *  This would also be a good place to do any initialization needed
 *  for you data source. For example, opening a connection to another
 *  process that will supply the data, opening a database, etc.
 */
void
dessertAppParamsTable_container_init(netsnmp_container **
                                     container_ptr_ptr, netsnmp_cache * cache)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_container_init", "called\n"));

    if (NULL == container_ptr_ptr) {
        snmp_log(LOG_ERR,
                 "bad container param to dessertAppParamsTable_container_init\n");
        return;
    }

    /*
     * For advanced users, you can use a custom container. If you
     * do not create one, one will be created for you.
     */
    *container_ptr_ptr = NULL;
    if (NULL == cache) {
		snmp_log(LOG_ERR,
				 "bad cache param to dessertAppParamsTable_container_init\n");
		return;
	}

	/*
	 * TODO:345:A: Set up dessertAppStatsTable cache properties.
	 *
	 * Also for advanced users, you can set parameters for the
	 * cache. Do not change the magic pointer, as it is used
	 * by the MFD helper. To completely disable caching, set
	 * cache->enabled to 0.
	 */
	cache->timeout = DESSERTAPPPARAMSTABLE_CACHE_TIMEOUT;        /* seconds */
}                               /* dessertAppParamsTable_container_init */

/**
 * container shutdown
 *
 * @param container_ptr A pointer to the container.
 *
 *  This function is called at shutdown to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases.
 *
 *  This function is called before dessertAppParamsTable_container_free().
 *
 * @remark
 *  This would also be a good place to do any cleanup needed
 *  for you data source. For example, closing a connection to another
 *  process that supplied the data, closing a database, etc.
 */
void
dessertAppParamsTable_container_shutdown(netsnmp_container * container_ptr)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_container_shutdown", "called\n"));

    if (NULL == container_ptr) {
        snmp_log(LOG_ERR,
                 "bad params to dessertAppParamsTable_container_shutdown\n");
        return;
    }

}                               /* dessertAppParamsTable_container_shutdown */

/**
 * load initial data
 *
 * TODO:350:M: Implement dessertAppParamsTable data load
 *
 * @param container container to which items should be inserted
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_RESOURCE_UNAVAILABLE : Can't access data source
 * @retval MFD_ERROR                : other error.
 *
 *  This function is called to load the index(es) (and data, optionally)
 *  for the every row in the data set.
 *
 * @remark
 *  While loading the data, the only important thing is the indexes.
 *  If access to your data is cheap/fast (e.g. you have a pointer to a
 *  structure in memory), it would make sense to update the data here.
 *  If, however, the accessing the data invovles more work (e.g. parsing
 *  some other existing data, or peforming calculations to derive the data),
 *  then you can limit yourself to setting the indexes and saving any
 *  information you will need later. Then use the saved information in
 *  dessertAppParamsTable_row_prep() for populating data.
 *
 * @note
 *  If you need consistency between rows (like you want statistics
 *  for each row to be from the same time frame), you should set all
 *  data here.
 *
 */
int
dessertAppParamsTable_container_load(netsnmp_container * container)
{
    dessertAppParamsTable_rowreq_ctx *rowreq_ctx;
    size_t          count = 0;

    dessert_agentx_appparams_t *appparams_list = NULL;
    dessert_agentx_appparams_t *appparam;

    /*
     * temporary storage for index values
     */
    long            appParamsIndex;

    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_container_load", "called\n"));
    dessert_debug("dessertAppParamsTable_container_load called");

	/* harvest the appparams from the getter callbacks registered via *dessert_agentx_appparams_add* */
	if (_dessert_agentx_appparams_harvest_callbacks(&appparams_list)
			== DESSERT_ERR) {
		return MFD_RESOURCE_UNAVAILABLE;
	}

	/*
     * TODO:351:M: |-> Load/update data in the dessertAppParamsTable container.
     * loop over your dessertAppParamsTable data, allocate a rowreq context,
     * set the index(es) [and data, optionally] and insert into
     * the container.
     */
	DL_FOREACH(appparams_list, appparam) {

		appParamsIndex = appparam->index;

        /*
         * TODO:352:M: |   |-> set indexes in new dessertAppParamsTable rowreq context.
         * data context will be set from the param (unless NULL,
         *      in which case a new data context will be allocated)
         */
        rowreq_ctx = dessertAppParamsTable_allocate_rowreq_ctx();
        if (NULL == rowreq_ctx) {
            snmp_log(LOG_ERR, "memory allocation failed\n");
            return MFD_RESOURCE_UNAVAILABLE;
        }
        if (MFD_SUCCESS !=
            dessertAppParamsTable_indexes_set(rowreq_ctx,
                                              appParamsIndex)) {
            snmp_log(LOG_ERR,
                     "error setting index while loading "
                     "dessertAppParamsTable data.\n");
            dessertAppParamsTable_release_rowreq_ctx(rowreq_ctx);
            continue;
        }

        /* clear all column flags */
		rowreq_ctx->column_exists_flags = 0;

		/* these columns are always present*/
		rowreq_ctx->column_exists_flags |= COLUMN_APPPARAMSNAME_FLAG
				| COLUMN_APPPARAMSDESC_FLAG | COLUMN_APPPARAMSVALUETYPE_FLAG;

		rowreq_ctx->data.appParamsName_len = strlen(appparam->name);
		strcpy(rowreq_ctx->data.appParamsName, appparam->name);

		rowreq_ctx->data.appParamsDesc_len = strlen(appparam->desc);
		strcpy(rowreq_ctx->data.appParamsDesc, appparam->desc);

		appParamsValueType_map(&(rowreq_ctx->data.appParamsValueType), appparam->value_type);

		/* which of the 'value'-columns is actually present? */
		switch (appparam->value_type) {

		case DESSERT_APPPARAMS_VALUETYPE_BOOL:
			rowreq_ctx->column_exists_flags |= COLUMN_APPPARAMSTRUTHVALUE_FLAG;
			appParamsTruthValue_map(&(rowreq_ctx->data.appParamsTruthValue) , appparam->bool);

			break;

		case DESSERT_APPPARAMS_VALUETYPE_INT32:
			rowreq_ctx->column_exists_flags |= COLUMN_APPPARAMSINTEGER32_FLAG;
			rowreq_ctx->data.appParamsInteger32 = appparam->int32;

			break;

		case DESSERT_APPPARAMS_VALUETYPE_UINT32:
			rowreq_ctx->column_exists_flags |= COLUMN_APPPARAMSUNSIGNED32_FLAG;
			rowreq_ctx->data.appParamsUnsigned32 = appparam->uint32;

			break;

		case DESSERT_APPPARAMS_VALUETYPE_OCTETSTRING:
			rowreq_ctx->column_exists_flags |= COLUMN_APPPARAMSOCTETSTRING_FLAG;
			rowreq_ctx->data.appParamsOctetString_len = appparam->octetstring_len;
			memcpy(&(rowreq_ctx->data.appParamsOctetString), appparam->octetstring, appparam->octetstring_len);

			break;

		default:
			dessert_err("appparam->value_type not valid!");
		}

		/*
		 * insert into table container
		 */
		CONTAINER_INSERT(container, rowreq_ctx);
	}

	_dessert_agentx_appparams_free_list(&appparams_list);

    DEBUGMSGT(("verbose:dessertAppParamsTable:dessertAppParamsTable_container_load", "inserted %d records\n", count));

    return MFD_SUCCESS;
}                               /* dessertAppParamsTable_container_load */

/**
 * container clean up
 *
 * @param container container with all current items
 *
 *  This optional callback is called prior to all
 *  item's being removed from the container. If you
 *  need to do any processing before that, do it here.
 *
 * @note
 *  The MFD helper will take care of releasing all the row contexts.
 *
 */
void
dessertAppParamsTable_container_free(netsnmp_container * container)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_container_free", "called\n"));

    /*
     * TODO:380:M: Free dessertAppParamsTable container data.
     */
}                               /* dessertAppParamsTable_container_free */

/**
 * prepare row for processing.
 *
 *  When the agent has located the row for a request, this function is
 *  called to prepare the row for processing. If you fully populated
 *  the data context during the index setup phase, you may not need to
 *  do anything.
 *
 * @param rowreq_ctx pointer to a context.
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 */
int
dessertAppParamsTable_row_prep(dessertAppParamsTable_rowreq_ctx *
                               rowreq_ctx)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_row_prep", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:390:o: Prepare row for request.
     * If populating row data was delayed, this is the place to
     * fill in the row for this request.
     */

    return MFD_SUCCESS;
}                               /* dessertAppParamsTable_row_prep */

/** @} */
