/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.ConfiguredBenchmark;
import com.google.caliper.Measurement;
import com.google.caliper.MeasurementSet;
import com.google.caliper.Measurer;
import com.google.caliper.UserException;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;

class TimeMeasurer
extends Measurer {
    private final long warmupNanos;
    private final long runNanos;
    private static final double SHORT_CIRCUIT_TOLERANCE = 0.01;
    private static final int MAX_TRIALS = 10;

    TimeMeasurer(long warmupMillis, long runMillis) {
        Preconditions.checkArgument((warmupMillis > 50L ? 1 : 0) != 0);
        Preconditions.checkArgument((runMillis > 50L ? 1 : 0) != 0);
        this.warmupNanos = warmupMillis * 1000000L;
        this.runNanos = runMillis * 1000000L;
    }

    private double warmUp(Supplier<ConfiguredBenchmark> testSupplier) throws Exception {
        long elapsedNanos = 0L;
        long netReps = 0L;
        int reps = 1;
        boolean definitelyScalesLinearly = false;
        this.log("[starting warmup]");
        while (elapsedNanos < this.warmupNanos) {
            long nanos = this.measureReps((ConfiguredBenchmark)testSupplier.get(), reps);
            elapsedNanos += nanos;
            netReps += (long)reps;
            if ((reps *= 2) > 0) continue;
            if (!definitelyScalesLinearly) {
                this.checkScalesLinearly(testSupplier);
                definitelyScalesLinearly = true;
            }
            reps = Integer.MAX_VALUE;
        }
        this.log("[ending warmup]");
        double nanosPerExecution = (double)elapsedNanos / (double)netReps;
        double lowerBound = 0.1;
        double upperBound = 1.0E10;
        if (!(lowerBound <= nanosPerExecution) || !(nanosPerExecution <= upperBound)) {
            throw new UserException.RuntimeOutOfRangeException(nanosPerExecution, lowerBound, upperBound);
        }
        return nanosPerExecution;
    }

    private void checkScalesLinearly(Supplier<ConfiguredBenchmark> testSupplier) throws Exception {
        double one;
        double half = this.measureReps((ConfiguredBenchmark)testSupplier.get(), 0x3FFFFFFF);
        if (half / (one = (double)this.measureReps((ConfiguredBenchmark)testSupplier.get(), Integer.MAX_VALUE)) > 0.75) {
            throw new UserException.DoesNotScaleLinearlyException();
        }
    }

    @Override
    public MeasurementSet run(Supplier<ConfiguredBenchmark> testSupplier) throws Exception {
        double estimatedNanosPerRep = this.warmUp(testSupplier);
        this.log("[measuring nanos per rep with scale 1.00]");
        Measurement measurement100 = this.measure(testSupplier, 1.0, estimatedNanosPerRep);
        this.log("[measuring nanos per rep with scale 0.50]");
        Measurement measurement050 = this.measure(testSupplier, 0.5, measurement100.getRaw());
        this.log("[measuring nanos per rep with scale 1.50]");
        Measurement measurement150 = this.measure(testSupplier, 1.5, measurement100.getRaw());
        MeasurementSet measurementSet = new MeasurementSet(measurement100, measurement050, measurement150);
        for (int i = 3; i < 10; ++i) {
            double threshold = 0.01 * measurementSet.meanRaw();
            if (measurementSet.standardDeviationRaw() < threshold) {
                return measurementSet;
            }
            this.log("[performing additional measurement with scale 1.00]");
            Measurement measurement = this.measure(testSupplier, 1.0, measurement100.getRaw());
            measurementSet = measurementSet.plusMeasurement(measurement);
        }
        return measurementSet;
    }

    private Measurement measure(Supplier<ConfiguredBenchmark> testSupplier, double durationScale, double estimatedNanosPerRep) throws Exception {
        int reps = (int)(durationScale * (double)this.runNanos / estimatedNanosPerRep);
        if (reps == 0) {
            reps = 1;
        }
        this.log("[running trial with " + reps + " reps]");
        ConfiguredBenchmark benchmark = (ConfiguredBenchmark)testSupplier.get();
        long elapsedTime = this.measureReps(benchmark, reps);
        double nanosPerRep = (double)elapsedTime / (double)reps;
        this.log(String.format("[took %.2f nanoseconds per rep]", nanosPerRep));
        return new Measurement(benchmark.timeUnitNames(), nanosPerRep, benchmark.nanosToUnits(nanosPerRep));
    }

    private long measureReps(ConfiguredBenchmark benchmark, int reps) throws Exception {
        this.prepareForTest();
        this.log("[starting measured section]");
        long startNanos = System.nanoTime();
        benchmark.run(reps);
        long endNanos = System.nanoTime();
        this.log("[done measured section]");
        benchmark.close();
        return endNanos - startNanos;
    }
}

