/*
 * @file    TestValidASTNode.java
 * @brief   Test the isWellFormedASTNode function
 *
 * @author  Akiya Jouraku (Java conversion)
 * @author  Sarah Keating 
 * 
 * ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
 *
 * DO NOT EDIT THIS FILE.
 *
 * This file was generated automatically by converting the file located at
 * src/sbml/test/TestValidASTNode.cpp
 * using the conversion program dev/utilities/translateTests/translateTests.pl.
 * Any changes made here will be lost the next time the file is regenerated.
 *
 * -----------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright 2005-2010 California Institute of Technology.
 * Copyright 2002-2005 California Institute of Technology and
 *                     Japan Science and Technology Corporation.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * -----------------------------------------------------------------------------
 */

package org.sbml.libsbml.test.math;

import org.sbml.libsbml.*;

import java.io.File;
import java.lang.AssertionError;

public class TestValidASTNode {

  static void assertTrue(boolean condition) throws AssertionError
  {
    if (condition == true)
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      return;
    }
    else if ( (a == null) || (b == null) )
    {
      throw new AssertionError();
    }
    else if (a.equals(b))
    {
      return;
    }

    throw new AssertionError();
  }

  static void assertNotEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      throw new AssertionError();
    }
    else if ( (a == null) || (b == null) )
    {
      return;
    }
    else if (a.equals(b))
    {
      throw new AssertionError();
    }
  }

  static void assertEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(int a, int b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(int a, int b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  public void test_ValidASTNode_Name()
  {
    ASTNode n = libsbml.parseFormula("c");
    assertEquals( true, n.isWellFormedASTNode() );
    //ASTNode d = libsbml.parseFormula("d");
    //int i = n.addChild(d);
    //assertEquals(i, libsbml.LIBSBML_INVALID_OBJECT);
    //n = null;
  }

  public void test_ValidASTNode_Number()
  {
    ASTNode n = libsbml.parseFormula("1.2");
    assertEquals( true, n.isWellFormedASTNode() );
    //ASTNode d = libsbml.parseFormula("d");
    //int i = n.addChild(d);
    //assertEquals(i, libsbml.LIBSBML_INVALID_OBJECT);
    //n = null;
  }

  public void test_ValidASTNode_binary()
  {
    ASTNode n = new ASTNode(libsbml.AST_DIVIDE);
    assertEquals( false, (n.isWellFormedASTNode()) );
    ASTNode c = libsbml.parseFormula("c");
    n.addChild(c);
    assertEquals( false, (n.isWellFormedASTNode()) );
    ASTNode d = libsbml.parseFormula("d");
    n.addChild(d);
    assertEquals( true, n.isWellFormedASTNode() );
    n = null;
  }

  public void test_ValidASTNode_infix_nary_plus0()
  {
    ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <plus/>" + 
    "  </apply>" + 
    "</math>");
    assertTrue( n != null );
    String formula = libsbml.formulaToString(n);
    ASTNode node = libsbml.parseFormula(formula);
    assertTrue( node != null );
    n = null;
    node = null;
  }

  public void test_ValidASTNode_infix_nary_plus1()
  {
    ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <plus/>" + 
    "    <cn> 0 </cn>" + 
    "  </apply>" + 
    "</math>");
    assertTrue( n != null );
    String formula = libsbml.formulaToString(n);
    ASTNode node = libsbml.parseFormula(formula);
    assertTrue( node != null );
    n = null;
    node = null;
  }

  public void test_ValidASTNode_infix_nary_times0()
  {
    ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <times/>" + 
    "  </apply>" + 
    "</math>");
    assertTrue( n != null );
    String formula = libsbml.formulaToString(n);
    ASTNode node = libsbml.parseFormula(formula);
    assertTrue( node != null );
    n = null;
    node = null;
  }

  public void test_ValidASTNode_infix_nary_times1()
  {
    ASTNode n = libsbml.readMathMLFromString("<math xmlns='http://www.w3.org/1998/Math/MathML'>" + 
    "  <apply>" + 
    "    <times/>" + 
    "    <cn> 0 </cn>" + 
    "  </apply>" + 
    "</math>");
    assertTrue( n != null );
    String formula = libsbml.formulaToString(n);
    ASTNode node = libsbml.parseFormula(formula);
    assertTrue( node != null );
    n = null;
    node = null;
  }

  public void test_ValidASTNode_lambda()
  {
    ASTNode n = new ASTNode(libsbml.AST_LAMBDA);
    assertEquals( false, (n.isWellFormedASTNode()) );
    ASTNode c = libsbml.parseFormula("c");
    n.addChild(c);
    assertEquals( true, n.isWellFormedASTNode() );
    ASTNode d = libsbml.parseFormula("d");
    n.addChild(d);
    assertEquals( true, n.isWellFormedASTNode() );
    ASTNode e = libsbml.parseFormula("e");
    n.addChild(e);
    assertEquals( true, n.isWellFormedASTNode() );
    n = null;
  }

  public void test_ValidASTNode_nary()
  {
    ASTNode n = new ASTNode(libsbml.AST_DIVIDE);
    assertEquals( false, (n.isWellFormedASTNode()) );
    ASTNode c = libsbml.parseFormula("c");
    n.addChild((ASTNode)c.deepCopy());
    assertEquals( false, (n.isWellFormedASTNode()) );
    n.addChild((ASTNode)c.deepCopy());
    assertEquals( true, (n.isWellFormedASTNode()) );
    n.addChild((ASTNode)c.deepCopy());
    assertEquals( false, (n.isWellFormedASTNode()) );
    n = new ASTNode(libsbml.AST_TIMES);
    assertEquals( true, (n.isWellFormedASTNode()) );
    n.addChild(c);
    assertEquals( true, (n.isWellFormedASTNode()) );
    ASTNode d = libsbml.parseFormula("d");
    n.addChild(d);
    assertEquals( true, n.isWellFormedASTNode() );
    ASTNode e = libsbml.parseFormula("e");
    n.addChild(e);
    assertEquals( true, n.isWellFormedASTNode() );
    n = null;
  }

  public void test_ValidASTNode_returnsBoolean()
  {
    ASTNode node = new ASTNode ( libsbml.AST_LOGICAL_AND );
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_LOGICAL_NOT);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_LOGICAL_OR);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_LOGICAL_XOR);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_FUNCTION_PIECEWISE);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_RELATIONAL_EQ);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_RELATIONAL_GEQ);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_RELATIONAL_GT);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_RELATIONAL_LEQ);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_RELATIONAL_LT);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_RELATIONAL_NEQ);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_CONSTANT_TRUE);
    assertEquals( true, node.returnsBoolean() );
    node.setType(libsbml.AST_CONSTANT_FALSE);
    assertEquals( true, node.returnsBoolean() );
  }

  public void test_ValidASTNode_root()
  {
    ASTNode n = new ASTNode(libsbml.AST_FUNCTION_ROOT);
    assertEquals( false, (n.isWellFormedASTNode()) );
    ASTNode c = libsbml.parseFormula("c");
    n.addChild(c);
    assertEquals( true, n.isWellFormedASTNode() );
    ASTNode d = libsbml.parseFormula("3");
    n.addChild(d);
    assertEquals( true, n.isWellFormedASTNode() );
    ASTNode e = libsbml.parseFormula("3");
    n.addChild(e);
    assertEquals( false, (n.isWellFormedASTNode()) );
    n = null;
  }

  public void test_ValidASTNode_setType()
  {
    ASTNode n = new ASTNode();
    int i = n.setType(libsbml.AST_REAL);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
    assertTrue( n.getType() == libsbml.AST_REAL );
    i = n.setType(libsbml.AST_PLUS);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
    assertTrue( n.getType() == libsbml.AST_PLUS );
    assertTrue( n.getCharacter() ==  '+'  );
    i = n.setType(libsbml.AST_FUNCTION_ARCCOSH);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
    assertTrue( n.getType() == libsbml.AST_FUNCTION_ARCCOSH );
    i = n.setType(libsbml.AST_UNKNOWN);
    assertTrue( i == libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE );
    assertTrue( n.getType() == libsbml.AST_UNKNOWN );
    n = null;
  }

  public void test_ValidASTNode_unary()
  {
    ASTNode n = new ASTNode(libsbml.AST_FUNCTION_ABS);
    assertEquals( false, (n.isWellFormedASTNode()) );
    ASTNode c = libsbml.parseFormula("c");
    n.addChild(c);
    assertEquals( true, n.isWellFormedASTNode() );
    ASTNode d = libsbml.parseFormula("d");
    n.addChild(d);
    assertEquals( false, (n.isWellFormedASTNode()) );
    n = null;
  }

  /**
   * Loads the SWIG-generated libSBML Java module when this class is
   * loaded, or reports a sensible diagnostic message about why it failed.
   */
  static
  {
    String varname;
    String shlibname;

    if (System.getProperty("mrj.version") != null)
    {
      varname = "DYLD_LIBRARY_PATH";    // We're on a Mac.
      shlibname = "libsbmlj.jnilib and/or libsbml.dylib";
    }
    else
    {
      varname = "LD_LIBRARY_PATH";      // We're not on a Mac.
      shlibname = "libsbmlj.so and/or libsbml.so";
    }

    try
    {
      System.loadLibrary("sbmlj");
      // For extra safety, check that the jar file is in the classpath.
      Class.forName("org.sbml.libsbml.libsbml");
    }
    catch (SecurityException e)
    {
      e.printStackTrace();
      System.err.println("Could not load the libSBML library files due to a"+
                         " security exception.\n");
      System.exit(1);
    }
    catch (UnsatisfiedLinkError e)
    {
      e.printStackTrace();
      System.err.println("Error: could not link with the libSBML library files."+
                         " It is likely\nyour " + varname +
                         " environment variable does not include the directories\n"+
                         "containing the " + shlibname + " library files.\n");
      System.exit(1);
    }
    catch (ClassNotFoundException e)
    {
      e.printStackTrace();
      System.err.println("Error: unable to load the file libsbmlj.jar."+
                         " It is likely\nyour -classpath option and CLASSPATH" +
                         " environment variable\n"+
                         "do not include the path to libsbmlj.jar.\n");
      System.exit(1);
    }
  }
}
