/* refbase.cc - base class for using Glib::RefPtr
 * Copyright 2003 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "debug.hh"
#include "refbase.hh"

namespace shevek
{
  void refbase::reference ()
  {
    // in case of an overflow (2**(8*sizeof(int)) references), never delete
    // the object, because we will not know when.
    // This also makes sure that an object which is being deleted
    // can still be used (for example, if refptr_this is called from
    // its destructor).  Of course those pointers should be destroyed when
    // the destructor finishes; this code doesn't check that.
    if (m_refcount)
      ++m_refcount;
  }

  void refbase::unreference ()
  {
    if (m_refcount && !--m_refcount)
      {
	delete this;
      }
  }

  refbase::refbase ()
    : m_refcount (1)
  {
  }

  refbase::~refbase ()
  {
  }
}
