.TH PROMPTER %manext1% "January 18, 2001" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
prompter \- prompting editor front-end for nmh
.SH SYNOPSIS
.HP 5
.na
.B prompter
.RB [ \-erase
.IR chr ]
.RB [ \-kill
.IR chr ]
.RB [ \-prepend " | " \-noprepend ]
.RB [ \-rapid " | " \-norapid ]
.RB [ \-doteof " | " \-nodoteof ]
.I file
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Prompter
is an editor front\-end for
.B nmh
which allows rapid
composition of messages.  This program is not normally invoked directly by
users but takes the place of an editor and acts as an editor front\-end.
It operates on an RFC 822 style message draft skeleton specified by
.IR file ,
normally provided by the
.B nmh
commands
.BR comp ,
.BR dist ,
.BR forw ,
or
.BR repl .
.PP
.B Prompter
is particularly useful when composing messages over slow
network or modem lines.  It is an
.B nmh program in that it can have
its own profile entry with switches, but it is not invoked directly by
the user.  The commands
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
invoke
.B prompter as an editor, either when invoked with
.B \-editor
.IR prompter ,
or by the profile entry \*(lqEditor:\ prompter\*(rq,
or when given the command
.B edit
.B prompter
at the \*(lqWhat now?\*(rq prompt.
.PP
For each empty component
.B prompter finds in the draft, the user
is prompted for a response; A <RETURN> will cause the whole component
to be left out.  Otherwise, a `\\' preceding a <RETURN> will continue
the response on the next line, allowing for multiline components.
Continuation lines
.B must
begin with a space or tab.
.PP
Each non\-empty component is copied to the draft and displayed on the
terminal.
.PP
The start of the message body is denoted by a blank line or a line
of dashes.  If the body is non\-empty, the prompt, which isn't written
to the file, is
.PP
.RS 5
--------Enter additional text
.RE
.PP
or (if
.B \-prepend
was given)
.PP
.RS 5
--------Enter initial text
.RE
.PP
Message\-body typing is terminated with an end\-of\-file (usually
CTRL\-D).  With the
.B \-doteof
switch, a period on a line all by itself
also signifies end\-of\-file.  At this point control is returned to
the calling program, where the user is asked \*(lqWhat now?\*(rq.
See
.B whatnow (1)
for the valid options to this query.
.PP
By using the
.B \-prepend
switch, the user can add type\-in to the
beginning of the message body and have the rest of the body follow.
This is useful for the
.B forw
command.
.PP
By using the
.B \-rapid
switch, if the draft already contains text in
the message\-body, it is not displayed on the user's terminal.  This is
useful for low\-speed terminals.
.PP
The line editing characters for kill and erase may be specified by the
user via the arguments
.B \-kill
.I chr
and
.B \-erase
.IR chr ,
where
.I chr
may be a character; or `\\nnn', where \*(lqnnn\*(rq is the octal value for
the character.
.PP
An interrupt (usually CTRL\-C) during component typing will abort
.B prompter
and the
.B nmh
command that invoked it.  An interrupt
during message\-body typing is equivalent to CTRL\-D, for historical
reasons.  This means that
.B prompter
should finish up and exit.
.PP
The first non\-flag argument to
.B prompter is taken as the name of
the draft file, and subsequent non\-flag arguments are ignored.
.\" (\fIRepl\fR invokes editors with two file arguments:
.\" the draft file name and the replied\-to message file name.)
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^/tmp/prompter*~^Temporary copy of message
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
prompter\-next:	To name the editor to be used on exit from .B prompter
^Msg\-Protect:~^To set mode when creating a new draft
.fi
.SH "SEE ALSO"
.IR comp (1),
.IR dist (1),
.IR forw (1),
.IR repl (1),
.IR whatnow (1)
.SH DEFAULTS
.nf
.RB ` \-prepend '
.RB ` \-norapid '
.RB ` \-nodoteof '
.fi
.SH CONTEXT
None
.SH "HELPFUL HINTS"
The
.B \-rapid
option is particularly useful with
.BR forw ,
and
.B \-noprepend
is useful with
.B comp
.BR \-use .
.PP
The user may wish to link
.B prompter under several names (e.g.,
\*(lqrapid\*(rq) and give appropriate switches in the profile entries
under these names (e.g., \*(lqrapid: -rapid\*(rq).  This facilitates
invoking prompter differently for different
.B nmh
commands (e.g.,
\*(lqforw: -editor rapid\*(rq).
.SH BUGS
.B Prompter
uses
.IR stdio (3),
so it will lose if you edit files with nulls in them.
