/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.core.component;

import java.util.Iterator;
import org.apache.turbine.util.Log;
import org.chefproject.core.Event;
import org.chefproject.core.MailArchiveMessage;
import org.chefproject.core.MailArchiveMessageHeader;
import org.chefproject.core.NotificationAction;
import org.chefproject.core.component.SiteEmailNotification;
import org.chefproject.util.Email;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;

public class EmailSiteEmailNotification
extends SiteEmailNotification {
    public EmailSiteEmailNotification() {
    }

    public EmailSiteEmailNotification(String siteId) {
        super(null, siteId, null, null);
    }

    public NotificationAction getClone() {
        EmailSiteEmailNotification clone = new EmailSiteEmailNotification();
        clone.set(this);
        return clone;
    }

    public void notify(Event event) {
        Reference ref = new Reference(event.getResource());
        MailArchiveMessage msg = (MailArchiveMessage)ref.getResource();
        MailArchiveMessageHeader hdr2 = msg.getMailArchiveHeader();
        String from = hdr2.getFromAddress();
        String subject = hdr2.getSubject();
        String message = msg.getBody();
        ReferenceVector attachments = hdr2.getAttachments();
        if (attachments.size() > 0) {
            message = message + "\n" + "Attachments:\n\n";
            Iterator iAttachments = attachments.iterator();
            while (iAttachments.hasNext()) {
                Reference attachment = (Reference)iAttachments.next();
                message = message + attachment.getUrl() + "\n";
            }
        }
        String to = this.getTo();
        String headerTo = this.getHeaderTo();
        String replyTo = this.getReplyTo();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + " sending email to: " + to);
        }
        Email.send(from, to, subject, message, headerTo, replyTo);
    }
}

