/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_TEMPLATE_H_
#define _OPENCTL_TEMPLATE_H_

#include <OpenCTL/Export.h>
#include <GTLCore/PixelDescription.h>
#include <GTLCore/String.h>
#include <GTLCore/Type.h>

#include <map>

namespace GTLCore {
  class CompilationMessages;
}

namespace OpenCTL {
  class Module;
  /**
   * Allow to load a CTL Template and to transform it to a CTL @ref Module .
   * @ingroup OpenCTL
   */
  class OPENCTL_EXPORT Template {
      GTL_NO_COPY(Template);
    public:
      Template();
      ~Template();
      GTLCore::String name() const;
      /**
       * Set the code source of the module.
       */
      void setSource(const GTLCore::String& name, const GTLCore::String& source);
      /**
       * Load the module from the given file name.
       */
      void loadFromFile(const GTLCore::String& fileName);
      GTLCore::String fileName() const;
      void compile();
      /**
       * @return true if the module was successfully compiled.
       */
      bool isCompiled() const;
      /**
       * Generate a CTL code source from this template
       */
      GTLCore::String generateSource( const std::map< GTLCore::String, const GTLCore::Type* >& _namedTypes,
                        const GTLCore::PixelDescription& _pixelDescription );
      /**
       * Convenience function that generates a Module (not compiled)
       */
      Module* generateModule( const std::map< GTLCore::String, const GTLCore::Type* >& _namedTypes,
                        const GTLCore::PixelDescription& _pixelDescription );
      /**
       * Convenience function that generates a Module (not compiled)
       */
      Module* generateModule( const GTLCore::PixelDescription& _pixelDescription );
      /**
       */
      static void addIncludeDirectory(const GTLCore::String& directory);
      /**
       * @return a string with the content of the compilation error.
       */
      GTLCore::CompilationMessages compilationMessages() const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
