/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_WRAPPER_P_H_
#define _GTLFRAGMENT_WRAPPER_P_H_

#include <GTLFragment/Export.h>
#include <GTLFragment/WhichStdLibrary_p.h>

namespace llvm {
  class Module;
}

namespace GTLCore {
  class ConvertCenter;
  class ModuleData;
  class Type;
  class TypesManager;
  class ScopedName;
}

namespace GTLFragment {
  class Library;
  /**
   * @internal
   * @ingroup GTLFragment
   */
  class GTLFRAGMENT_EXPORT Wrapper {
      GTL_NO_COPY(Wrapper);
    public:
      Wrapper(GTLCore::ModuleData* _moduleData, llvm::Module* _llvmModule, int _channels);
      virtual ~Wrapper();
      virtual void fillTypesManager( GTLCore::TypesManager*, GTLCore::ConvertCenter*) = 0;
    protected:
      GTLCore::ModuleData* moduleData() const;
      llvm::Module* llvmModule();
      int channels() const;
    public:
      static const GTLCore::Type* createColorType(GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter);
    protected:
      void addFunctionFromModuleToType(const GTLCore::Type* type, GTLFragment::Library* library, const GTLCore::ScopedName& name);
    private:
      struct Private;
      Private* const d;
  };
}

#endif
