/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Library_p.h"

#include <GTLCore/Debug.h>
#include <GTLFragment/Library_p.h>

#include "LibrariesManager.h"

using namespace OpenShiva;

Library::Library(GTLFragment::Library::Type _type, int _channelsNb) : GTLFragment::Library(_type, _channelsNb), d(new Private)
{
  GTL_ASSERT(_channelsNb > 0);
  LibrariesManager::instance(); // This make sure the libraries manager is created whne compiling libraries
  GTLFragment::Library::d->libraryCompilation = d;

}

Library::~Library()
{
  cleanup();
  GTLFragment::Library::d->libraryCompilation = 0;
  delete d;
}
