///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/gui/properties/VectorControllerUI.h>
#include <core/scene/animation/controller/Controller.h>
#include <core/scene/animation/AnimManager.h>
#include <core/data/units/ParameterUnit.h>

namespace Core {

// Gives the class run-time type information.
IMPLEMENT_ABSTRACT_PLUGIN_CLASS(VectorControllerUI, FloatControllerUI)

/******************************************************************************
* The constructor.
******************************************************************************/
VectorControllerUI::VectorControllerUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& refField, size_t vectorComponent) 
	: FloatControllerUI(parentEditor, refField), component(vectorComponent)
{
	OVITO_ASSERT_MSG(vectorComponent >= 0 && vectorComponent < 3, "VectorControllerUI constructor", "The vector component must be in the range 0-2.");

	switch(component) {
		case 0: label()->setText(referenceField().displayName() + " (X):"); break;
		case 1: label()->setText(referenceField().displayName() + " (Y):"); break;
		case 2: label()->setText(referenceField().displayName() + " (Z):"); break;
	}
}

/******************************************************************************
* Takes the value entered by the user and stores it in the parameter object
* this parameter UI is bound to.
******************************************************************************/
void VectorControllerUI::updateParameterValue()
{
	VectorController* ctrl = dynamic_object_cast<VectorController>(parameterObject());
	if(ctrl != NULL && spinner()) {
		TimeInterval interval;
		Vector3 val = ctrl->getCurrentValue();
		val[component] = spinner()->floatValue();
		ctrl->setCurrentValue(val);
	}
}

/******************************************************************************
* This method updates the displayed value of the parameter UI.
******************************************************************************/
void VectorControllerUI::updateUI()
{
	VectorController* ctrl = dynamic_object_cast<VectorController>(parameterObject());
	if(ctrl != NULL && spinner() && !spinner()->isDragging()) {
		TimeInterval interval;
		Vector3 val = ctrl->getCurrentValue();
		spinner()->setFloatValue(val[component]);
	}
}

};

