/*
 * proc PMDA
 *
 * Copyright (c) 2000,2004,2007-2008 Silicon Graphics, Inc.  All Rights Reserved.
 * Copyright (c) 2002 International Business Machines Corp.
 * Copyright (c) 2007-2011 Aconex.  All Rights Reserved.
 * Copyright (c) 2012-2022 Red Hat.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * PMDA Debug Flags
 * -Dappl0	cgroups.c
 * -Dappl1	proc_pid.c (add -Ddesperate for more verbosity)
 * -Dappl2	pmns operations
 * -Dappl3	acct.c
 * -Dauth	authorization operations
 * -Dattr	in container proc_refresh diagnostic
 */

#include "pmapi.h"
#include "libpcp.h"
#include "pmda.h"
#include "domain.h"
#include "contexts.h"
#include "../linux/convert.h"

#include <ctype.h>
#include <unistd.h>
#include <sys/vfs.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <sys/utsname.h>
#include <utmp.h>
#include <pwd.h>
#include <grp.h>

#include "clusters.h"
#include "indom.h"
#include "hotproc.h"

#include "getinfo.h"
#include "proc_pid.h"
#include "proc_dynamic.h"
#include "cgroups.h"
#include "acct.h"

/* globals */
static int			_isDSO = 1;	/* =0 I am a daemon */
static int			rootfd = -1;	/* af_unix pmdaroot */
static proc_pid_t		proc_pid;
static proc_pid_t		hotproc_pid;
static proc_runq_t		proc_runq;
static proc_acct_t		proc_acct;
static int			all_access;	/* =1 no access checks */
static int			have_access;	/* =1 recvd uid/gid */
static int			autogroup = -1;	/* =1 autogroup enabled */
static unsigned int		threads;	/* control.all.threads */
static char *			cgroups;	/* control.all.cgroups */
size_t				_pm_system_pagesize;
long				_pm_hertz;

/*
 * Note on "jiffies".
 * In the Linux kernel jiffies are always "unsigned long" (aka
 * KERNEL_ULONG), so to scale from jiffies to milliseconds, the multiplier
 * is 1000 / hz.
 * Unfortunately this presents some overflow and precision challenges.
 * 1. Variables used to hold an intermediate jiffies value should
 *    be declared __pm_kernel_ulong_t
 * 2. If this value is instantiated from a string (as in the /proc
 *    stats files, it is safe to use strtoul().
 * 3. The resultant PCP metric should be in units of msec and may be
 *    of type KERNEL_ULONG or PM_TYPE_U64 or PM_TYPE_U32.  KERNEL_ULONG
 *    will become one of the other types depending on the platform. In
 *    the case of PM_TYPE+_32 overflow would occur in
 *    (2^32-1)/(1000/hz)/(3600*24) days, and for current settings of
 *    hz (100) this means 4971+ days or more than 13.5 years, so this is
 *    not a practical issue nor a reason to mandate PM_TYPE_U64.
 * 4. But if the calculation is done in 32-bit integer arithmetic we
 *    risk earlier overflow much earlier (49+ days) because the *1000
 *    exceeds 32-bits ... so the arithmetic should always be forced
 *    to 64-bits by
 *    (a) explicit cast of the jiffies (__int64_t)jiffies * 1000 / hz or
 *    (b) declaring the variable holding the jiffies to be of type
 *        __int64_t
 *    we choose option (b).
 */

char *proc_statspath = "";	/* optional path prefix for all stats files */

/*
 * The proc instance domain table is direct lookup and sparse.
 * It is initialized in proc_init(), see below.
 */
static pmdaIndom indomtab[NUM_INDOMS];

/*
 * all metrics supported in this PMDA - one table entry for each
 */
static pmdaMetric metrictab[] = {
/* proc.nprocs */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,99), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.pid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,0), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.cmd */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,1), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.sname */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,2), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.ppid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,3), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.pgrp */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,4), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.session */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,5), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.tty */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,6), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.tty_pgrp */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,7), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.flags */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,8), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.minflt */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,9), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.psinfo.cmin_flt */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,10), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.psinfo.maj_flt */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,11), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.psinfo.cmaj_flt */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,12), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.psinfo.utime */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,13), KERNEL_ULONG, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.stime */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,14), KERNEL_ULONG, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.cutime */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,15), KERNEL_ULONG, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.cstime */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,16), KERNEL_ULONG, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.priority */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,17), PM_TYPE_32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.nice */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,18), PM_TYPE_32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.it_real_value */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,20), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.start_time */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,21), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.vsize */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,22), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.psinfo.rss */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,23), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.psinfo.rss_rlim */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,24), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.psinfo.start_code */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,25), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.end_code */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,26), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.start_stack */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,27), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.esp */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,28), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.eip */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,29), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.signal */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,30), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.blocked */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,31), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.sigignore */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,32), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.sigcatch */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,33), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.wchan */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,34), KERNEL_ULONG, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.nswap */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,35), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.psinfo.cnswap */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,36), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.psinfo.exit_signal */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,37), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.processor */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,38), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.ttyname */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,39), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.psinfo.wchan_s */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,40), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.psargs */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,41), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.rt_priority */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,42), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.policy */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,43), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.delayacct_blkio_time */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,44), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.guest_time */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,45), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.cguest_time */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,46), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* proc.psinfo.environ */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,47), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.policy_s */
  { NULL, { PMDA_PMID(CLUSTER_PID_STAT,48), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.uid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS,0), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.euid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS,1), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.suid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS,2), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.fsuid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS,3), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.gid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 4), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.egid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 5), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.sgid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 6), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.fsgid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 7), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.uid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 8), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.euid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 9), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.suid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 10), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.fsuid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 11), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.gid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 12), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.egid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 13), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.sgid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 14), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.fsgid_nm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 15), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.signal_s */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 16), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.blocked_s */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 17), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.sigignore_s */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 18), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.sigcatch_s */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 19), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.memory.vmsize */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 20), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmlock */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 21), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmrss */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 22), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmdata */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 23), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmstack */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 24), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmexe */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 25), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmlib */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 26), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmswap */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 27), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmreal */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 43), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmnonlib */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 44), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.psinfo.threads */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 28), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.vctxsw */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 29), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.nvctxsw */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 30), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.cpusallowed */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 31), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.ngid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 32), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.memory.vmpeak */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 33), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmpin */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 34), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmhwm */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 35), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.memory.vmpte */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 36), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.namespaces.tpid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 37), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.namespaces.pid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 38), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.namespaces.pgid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 39), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.namespaces.sid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 40), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.tgid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 41), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.namespaces.envid */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATUS, 42), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.cgroups */
  { NULL, { PMDA_PMID(CLUSTER_PID_CGROUP, 0), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.id.container */
  { NULL, { PMDA_PMID(CLUSTER_PID_CGROUP, 1), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.labels */
  { NULL, { PMDA_PMID(CLUSTER_PID_LABEL, 0), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.oom_score */
  { NULL, { PMDA_PMID(CLUSTER_PID_OOM_SCORE, 0), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.cwd */
  { NULL, { PMDA_PMID(CLUSTER_PID_CWD, 0), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.psinfo.exe */
  { NULL, { PMDA_PMID(CLUSTER_PID_EXE, 0), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.memory.size */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,0), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.rss */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,1), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.share */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,2), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.textrss */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,3), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.librss */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,4), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.datrss */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,5), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.dirty */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,6), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* proc.memory.maps */
  { NULL, { PMDA_PMID(CLUSTER_PID_STATM,7), PM_TYPE_STRING, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.schedstat.cpu_time */
  { NULL, { PMDA_PMID(CLUSTER_PID_SCHEDSTAT,0), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0)}},
/* proc.schedstat.run_delay */
  { NULL, { PMDA_PMID(CLUSTER_PID_SCHEDSTAT,1), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0)}},
/* proc.schedstat.pcount */
  { NULL, { PMDA_PMID(CLUSTER_PID_SCHEDSTAT,2), KERNEL_ULONG, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE)}},
/* proc.io.rchar */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,0), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0)}},
/* proc.io.wchar */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,1), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0)}},
/* proc.io.syscr */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,2), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE)}},
/* proc.io.syscw */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,3), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE)}},
/* proc.io.read_bytes */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,4), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0)}},
/* proc.io.write_bytes */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,5), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0)}},
/* proc.io.cancelled_write_bytes */
  { NULL, { PMDA_PMID(CLUSTER_PID_IO,6), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0)}},
/* proc.smaps.rss */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,0), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.pss */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,1), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.pss_anon */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,2), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.pss_file */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,3), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.pss_shmem */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,4), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.shared_clean */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,5), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.shared_dirty */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,6), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.private_clean */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,7), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.private_dirty */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,8), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.referenced */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,9), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.anonymous */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,10), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.lazyfree */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,11), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.anonhugepages */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,12), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.shmempmdmapped */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,13), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.filepmdmapped */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,14), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.shared_hugetlb */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,15), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.private_hugetlb */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,16), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.swap */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,17), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.swappss */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,18), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.locked */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,19), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.smaps.pss_dirty */
  { NULL, { PMDA_PMID(CLUSTER_PID_SMAPS,20), PM_TYPE_U64, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0)}},
/* proc.fd.count */
  { NULL, { PMDA_PMID(CLUSTER_PID_FD,0), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.autogroup.enabled */
  { NULL, { PMDA_PMID(CLUSTER_PID_AUTOGROUP,0), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.autogroup.id */
  { NULL, { PMDA_PMID(CLUSTER_PID_AUTOGROUP,1), PM_TYPE_U32, PROC_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* proc.autogroup.nice */
  { NULL, { PMDA_PMID(CLUSTER_PID_AUTOGROUP,2), PM_TYPE_32, PROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)}},

/* proc.runq.runnable */
  { &proc_runq.runnable,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 0), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.blocked */
  { &proc_runq.blocked,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 1), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.sleeping */
  { &proc_runq.sleeping,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 2), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.stopped */
  { &proc_runq.stopped,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 3), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.swapped */
  { &proc_runq.swapped,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 4), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.defunct */
  { &proc_runq.defunct,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 5), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.unknown */
  { &proc_runq.unknown,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 6), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* proc.runq.kernel */
  { &proc_runq.kernel,
    { PMDA_PMID(CLUSTER_PROC_RUNQ, 7), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },

/* cgroups.subsys.hierarchy */
  { NULL, {PMDA_PMID(CLUSTER_CGROUP_SUBSYS, CG_SUBSYS_HIERARCHY), PM_TYPE_U32,
    CGROUP_SUBSYS_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroups.subsys.count */
  { NULL, {PMDA_PMID(CLUSTER_CGROUP_SUBSYS, CG_SUBSYS_COUNT), PM_TYPE_U32,
    PM_INDOM_NULL, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroups.subsys.num_cgroups */
  { NULL, {PMDA_PMID(CLUSTER_CGROUP_SUBSYS, CG_SUBSYS_NUMCGROUPS), PM_TYPE_U32,
    CGROUP_SUBSYS_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroups.subsys.enabled */
  { NULL, {PMDA_PMID(CLUSTER_CGROUP_SUBSYS, CG_SUBSYS_ENABLED), PM_TYPE_U32,
    CGROUP_SUBSYS_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroups.mounts.subsys */
  { NULL, {PMDA_PMID(CLUSTER_CGROUP_MOUNTS, CG_MOUNTS_SUBSYS), PM_TYPE_STRING,
    CGROUP_MOUNTS_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroups.mounts.count */
  { NULL, {PMDA_PMID(CLUSTER_CGROUP_MOUNTS, CG_MOUNTS_COUNT), PM_TYPE_U32,
    PM_INDOM_NULL, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.cpuset.cpus */
  { NULL, { PMDA_PMID(CLUSTER_CPUSET_GROUPS, CG_CPUSET_CPUS), PM_TYPE_STRING,
    CGROUP_CPUSET_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.cpuset.mems */
  { NULL, { PMDA_PMID(CLUSTER_CPUSET_GROUPS, CG_CPUSET_MEMS), PM_TYPE_STRING,
    CGROUP_CPUSET_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.cpuset.id.container */
  { NULL, { PMDA_PMID(CLUSTER_CPUSET_GROUPS, CG_CPUSET_ID_CONTAINER), PM_TYPE_STRING,
    CGROUP_CPUSET_INDOM, PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* cgroup.cpuacct.stat.user */
  { NULL, { PMDA_PMID(CLUSTER_CPUACCT_GROUPS, CG_CPUACCT_USER), PM_TYPE_U64,
    CGROUP_CPUACCT_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* cgroup.cpuacct.stat.system */
  { NULL, { PMDA_PMID(CLUSTER_CPUACCT_GROUPS, CG_CPUACCT_SYSTEM), PM_TYPE_U64,
    CGROUP_CPUACCT_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* cgroup.cpuacct.usage */
  { NULL, { PMDA_PMID(CLUSTER_CPUACCT_GROUPS, CG_CPUACCT_USAGE), PM_TYPE_U64,
    CGROUP_CPUACCT_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.cpuacct.usage_percpu */
  { NULL, { PMDA_PMID(CLUSTER_CPUACCT_GROUPS, CG_CPUACCT_PERCPU_USAGE), PM_TYPE_U64,
    CGROUP_PERCPUACCT_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.cpuacct.id.container */
  { NULL, { PMDA_PMID(CLUSTER_CPUACCT_GROUPS, CG_CPUACCT_ID_CONTAINER), PM_TYPE_STRING,
    CGROUP_CPUACCT_INDOM, PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* cgroup.cpusched.shares */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_SHARES), PM_TYPE_U64,
    CGROUP_CPUSCHED_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.cpusched.periods */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_PERIODS), PM_TYPE_U64,
    CGROUP_CPUSCHED_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.cpusched.throttled */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_THROTTLED), PM_TYPE_U64,
    CGROUP_CPUSCHED_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.cpusched.throttled_time */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_THROTTLED_TIME), PM_TYPE_U64,
    CGROUP_CPUSCHED_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.cpusched.cfs_period */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_CFS_PERIOD), PM_TYPE_U64,
    CGROUP_CPUSCHED_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.cpusched.cfs_quota */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_CFS_QUOTA), PM_TYPE_64,
    CGROUP_CPUSCHED_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.cpusched.id.container */
  { NULL, { PMDA_PMID(CLUSTER_CPUSCHED_GROUPS, CG_CPUSCHED_ID_CONTAINER), PM_TYPE_STRING,
    CGROUP_CPUSCHED_INDOM, PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* cgroup.memory.stat.cache */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_CACHE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.rss */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_RSS), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.rss_huge */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_RSS_HUGE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.mapped_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_MAPPED_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.writeback */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_WRITEBACK), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.swap */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_SWAP), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pgpgin */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGPGIN), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.pgpgout */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGPGOUT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.pgfault */
  { NULL, {PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGFAULT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.pgmajfault */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGMAJFAULT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.inactive_anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_INACTIVE_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.active_anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_ACTIVE_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.inactive_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_INACTIVE_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.active_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_ACTIVE_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.unevictable */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_UNEVICTABLE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.cache */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_CACHE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.rss */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_RSS), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.rss_huge */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_RSS_HUGE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.mapped_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_MAPPED_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.writeback */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_WRITEBACK), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.swap */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_SWAP), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.pgpgin */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_PGPGIN), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.total.pgpgout */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_PGPGOUT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.total.pgfault */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_PGFAULT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.total.pgmajfault */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_PGMAJFAULT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.stat.total.inactive_anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_INACTIVE_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.active_anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_ACTIVE_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.inactive_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_INACTIVE_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.active_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_ACTIVE_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.total.unevictable */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_TOTAL_UNEVICTABLE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.recent.rotated_anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_RECENT_ROTATED_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.recent.rotated_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_RECENT_ROTATED_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.recent.scanned_anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_RECENT_SCANNED_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.recent.scanned_file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_RECENT_SCANNED_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.anon */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_ANON), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.anon_thp */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_ANON_THP), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.file */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_FILE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.file_dirty */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_FILE_DIRTY), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.file_mapped */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_FILE_MAPPED), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.file_writeback */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_FILE_WRITEBACK), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.kernel_stack */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_KERNEL_STACK), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pgactivate */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGACTIVATE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pgdeactivate */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGDEACTIVATE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pglazyfree */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGLAZYFREE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pglazyfreed */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGLAZYFREED), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pgrefill */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGREFILL), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pgscan */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGSCAN), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.pgsteal */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_PGSTEAL), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.shmem */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_SHMEM), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.slab */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_SLAB), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.slab_reclaimable */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_SLAB_RECLAIMABLE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.slab_unreclaimable */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_SLAB_UNRECLAIMABLE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.sock */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_SOCK), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.thp_collapse_alloc */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_THP_COLLAPSE_ALLOC), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.thp_fault_alloc */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_THP_FAULT_ALLOC), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.workingset.activate */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_WORKINGSET_ACTIVATE), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.workingset.nodereclaim */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_WORKINGSET_NODERECLAIM), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.stat.workingset.refault */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_STAT_WORKINGSET_REFAULT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.current */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_CURRENT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.usage */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_USAGE_IN_BYTES), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.limit */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_LIMIT_IN_BYTES), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.memory.failcnt */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_FAILCNT), PM_TYPE_U64,
    CGROUP_MEMORY_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.memory.id.container */
  { NULL, { PMDA_PMID(CLUSTER_MEMORY_GROUPS, CG_MEMORY_ID_CONTAINER), PM_TYPE_STRING,
    CGROUP_MEMORY_INDOM, PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* cgroup.netclass.classid */
  { NULL, { PMDA_PMID(CLUSTER_NETCLS_GROUPS, CG_NETCLS_CLASSID), PM_TYPE_U64,
    CGROUP_NETCLS_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.netclass.id.container */
  { NULL, { PMDA_PMID(CLUSTER_NETCLS_GROUPS, CG_NETCLS_ID_CONTAINER), PM_TYPE_STRING,
    CGROUP_NETCLS_INDOM, PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* cgroup.blkio.dev.io_merged.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOMERGED_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_merged.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOMERGED_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_merged.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOMERGED_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_merged.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOMERGED_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_merged.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOMERGED_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_queued.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOQUEUED_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_queued.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOQUEUED_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_queued.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOQUEUED_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_queued.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOQUEUED_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_queued.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOQUEUED_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_service_bytes.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICEBYTES_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.io_service_bytes.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICEBYTES_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.io_service_bytes.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICEBYTES_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.io_service_bytes.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICEBYTES_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.io_service_bytes.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICEBYTES_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.io_serviced.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICED_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_serviced.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICED_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_serviced.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICED_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_serviced.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICED_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_serviced.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICED_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.io_service_time.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICETIME_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_service_time.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICETIME_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_service_time.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICETIME_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_service_time.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICETIME_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_service_time.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOSERVICETIME_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_wait_time.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOWAITTIME_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_wait_time.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOWAITTIME_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_wait_time.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOWAITTIME_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_wait_time.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOWAITTIME_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.io_wait_time.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_IOWAITTIME_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.dev.sectors */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_SECTORS), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* cgroup.blkio.dev.time */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_TIME), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* cgroup.blkio.dev.throttle.io_service_bytes.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.throttle.io_service_bytes.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.throttle.io_service_bytes.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.throttle.io_service_bytes.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.throttle.io_service_bytes.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.dev.throttle.io_serviced.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICED_READ), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.throttle.io_serviced.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICED_WRITE), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.throttle.io_serviced.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICED_SYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.throttle.io_serviced.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICED_ASYNC), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.dev.throttle.io_serviced.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_PERDEVBLKIO_THROTTLEIOSERVICED_TOTAL), PM_TYPE_U64,
    CGROUP_PERDEVBLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_merged.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOMERGED_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_merged.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOMERGED_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_merged.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOMERGED_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_merged.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOMERGED_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_merged.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOMERGED_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_queued.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOQUEUED_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_queued.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOQUEUED_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_queued.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOQUEUED_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_queued.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOQUEUED_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_queued.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOQUEUED_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_service_bytes.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICEBYTES_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.io_service_bytes.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICEBYTES_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.io_service_bytes.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICEBYTES_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.io_service_bytes.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICEBYTES_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.io_service_bytes.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICEBYTES_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.io_serviced.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICED_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_serviced.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICED_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_serviced.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICED_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_serviced.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICED_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_serviced.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICED_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.io_service_time.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICETIME_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_service_time.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICETIME_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_service_time.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICETIME_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_service_time.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICETIME_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_service_time.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOSERVICETIME_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_wait_time.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOWAITTIME_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_wait_time.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOWAITTIME_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_wait_time.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOWAITTIME_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_wait_time.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOWAITTIME_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.io_wait_time.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_IOWAITTIME_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_NSEC,0) } },
/* cgroup.blkio.all.sectors */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_SECTORS), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) } },
/* cgroup.blkio.all.time */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_TIME), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_MSEC,0) } },
/* cgroup.blkio.all.throttle.io_service_bytes.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICEBYTES_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.throttle.io_service_bytes.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICEBYTES_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.throttle.io_service_bytes.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICEBYTES_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.throttle.io_service_bytes.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICEBYTES_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.throttle.io_service_bytes.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICEBYTES_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.blkio.all.throttle.io_serviced.read */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICED_READ), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.throttle.io_serviced.write */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICED_WRITE), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.throttle.io_serviced.sync */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICED_SYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.throttle.io_serviced.async */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICED_ASYNC), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.all.throttle.io_serviced.total */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_THROTTLEIOSERVICED_TOTAL), PM_TYPE_U64,
    CGROUP_BLKIO_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.blkio.id.container */
  { NULL, { PMDA_PMID(CLUSTER_BLKIO_GROUPS, CG_BLKIO_ID_CONTAINER), PM_TYPE_STRING,
    CGROUP_BLKIO_INDOM, PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0)}},
/* cgroup.pressure.cpu.some.avg10sec */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_PRESSURE, CG_PRESSURE_CPU_SOME_AVG10SEC), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.cpu.some.avg1min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_PRESSURE, CG_PRESSURE_CPU_SOME_AVG1MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.cpu.some.avg5min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_PRESSURE, CG_PRESSURE_CPU_SOME_AVG5MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.cpu.some.total */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_PRESSURE, CG_PRESSURE_CPU_SOME_TOTAL), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.pressure.memory.some.avg10sec */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_SOME_AVG10SEC), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.memory.some.avg1min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_SOME_AVG1MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.memory.some.avg5min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_SOME_AVG5MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.memory.some.total */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_SOME_TOTAL), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.pressure.memory.full.avg10sec */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_FULL_AVG10SEC), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.memory.full.avg1min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_FULL_AVG1MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.memory.full.avg5min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_FULL_AVG5MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.memory.full.total */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_MEM_PRESSURE, CG_PRESSURE_MEM_FULL_TOTAL), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.pressure.io.some.avg10sec */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_SOME_AVG10SEC), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.io.some.avg1min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_SOME_AVG1MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.io.some.avg5min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_SOME_AVG5MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.io.some.total */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_SOME_TOTAL), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.pressure.io.full.avg10sec */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_FULL_AVG10SEC), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.io.full.avg1min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_FULL_AVG1MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.io.full.avg5min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_FULL_AVG5MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.io.full.total */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_PRESSURE, CG_PRESSURE_IO_FULL_TOTAL), PM_TYPE_U64, CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.pressure.irq.full.avg10sec */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IRQ_PRESSURE, CG_PRESSURE_IRQ_FULL_AVG10SEC), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.irq.full.avg1min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IRQ_PRESSURE, CG_PRESSURE_IRQ_FULL_AVG1MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.irq.full.avg5min */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IRQ_PRESSURE, CG_PRESSURE_IRQ_FULL_AVG5MIN), PM_TYPE_FLOAT,
    CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* cgroup.pressure.irq.full.total */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IRQ_PRESSURE, CG_PRESSURE_IRQ_FULL_TOTAL), PM_TYPE_U64, CGROUP2_INDOM, PM_SEM_INSTANT, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.cpu.stat.user */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_STAT, CG_CPU_STAT_USER), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.cpu.stat.system */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_STAT, CG_CPU_STAT_SYSTEM), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.cpu.stat.usage */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_CPU_STAT, CG_CPU_STAT_USAGE), PM_TYPE_U64,
    CGROUP2_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_USEC,0) } },
/* cgroup.io.stat.rbytes */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_STAT, CG_IO_STAT_RBYTES), PM_TYPE_U64,
    CGROUP2_PERDEV_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.io.stat.wbytes */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_STAT, CG_IO_STAT_WBYTES), PM_TYPE_U64,
    CGROUP2_PERDEV_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.io.stat.rios */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_STAT, CG_IO_STAT_RIOS), PM_TYPE_U64,
    CGROUP2_PERDEV_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.io.stat.wios */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_STAT, CG_IO_STAT_WIOS), PM_TYPE_U64,
    CGROUP2_PERDEV_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* cgroup.io.stat.dbytes */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_STAT, CG_IO_STAT_DBYTES), PM_TYPE_U64,
    CGROUP2_PERDEV_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) } },
/* cgroup.io.stat.dios */
  { NULL, { PMDA_PMID(CLUSTER_CGROUP2_IO_STAT, CG_IO_STAT_DIOS), PM_TYPE_U64,
    CGROUP2_PERDEV_INDOM, PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },

/*
 * Metrics control cluster
 */

/* proc.control.all.threads */
  { &threads,
    { PMDA_PMID(CLUSTER_CONTROL, 1), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.control.perclient.threads */
  { NULL, { PMDA_PMID(CLUSTER_CONTROL, 2), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* proc.control.perclient.cgroups */
  { NULL, { PMDA_PMID(CLUSTER_CONTROL, 3), PM_TYPE_STRING, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },

/*
 * Hot processes clusters
 */
 
/* hotproc.nprocs */
  { NULL, { PMDA_PMID(CLUSTER_HOTPROC_PID_STAT,99), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) } },
/* hotproc.control.refresh */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,1), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.control.config */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,8), PM_TYPE_STRING, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.control.config_gen */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,9), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.control.reload_config */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,10), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.total.cpuidle */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,2), PM_TYPE_FLOAT, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.total.cpuburn */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,3), PM_TYPE_FLOAT, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.total.cpuother.transient */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,4), PM_TYPE_FLOAT, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.total.cpuother.not_cpuburn */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,5), PM_TYPE_FLOAT, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.total.cpuother.total */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,6), PM_TYPE_FLOAT, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.total.cpuother.percent */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_GLOBAL,7), PM_TYPE_FLOAT, PM_INDOM_NULL,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0)} },
/* hotproc.predicate.ctxswitch */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,1), PM_TYPE_FLOAT, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,-1,1, 0,PM_TIME_SEC,0)} },
/* hotproc.predicate.virtualsize */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,2), PM_TYPE_U32, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0, PM_SPACE_KBYTE,0,0)} },
/* hotproc.predicate.residentsize */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,3), PM_TYPE_U32, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0, PM_SPACE_KBYTE,0,0)} },
/* hotproc.predicate.iodemand */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,4), PM_TYPE_FLOAT, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,-1,0, PM_SPACE_KBYTE,PM_TIME_SEC,0)} },
/* hotproc.predicate.iowait */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,5), PM_TYPE_FLOAT, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0, 0,0,0)} },
/* hotproc.predicate.schedwait */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,6), PM_TYPE_FLOAT, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0, 0,0,0)} },
/* hotproc.predicate.cpuburn */
  { NULL, {PMDA_PMID(CLUSTER_HOTPROC_PRED,7), PM_TYPE_FLOAT, HOTPROC_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0, 0,0,0)} },

/*
 * Accounting cluster
 */

/* acct.psinfo.tty */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_TTY), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.psinfo.ttyname */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_TTYNAME), PM_TYPE_STRING, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.psinfo.exitcode */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_EXITCODE), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.psinfo.pid */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_PID), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.psinfo.ppid */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_PPID), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.psinfo.btime */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_BTIME), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.psinfo.etime */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_ETIME), PM_TYPE_FLOAT, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.psinfo.utime */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_UTIME), PM_TYPE_FLOAT, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.psinfo.stime */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_STIME), PM_TYPE_FLOAT, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.psinfo.mem */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_MEM), PM_TYPE_U64, ACCT_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(1,0,0,PM_SPACE_KBYTE,0,0) }, },
/* acct.psinfo.io */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_IO), PM_TYPE_U64, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* acct.psinfo.rw */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_RW), PM_TYPE_U64, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* acct.psinfo.minflt */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_MINFLT), PM_TYPE_U64, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.psinfo.majflt */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_MAJFLT), PM_TYPE_U64, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* acct.psinfo.swaps */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_SWAPS), PM_TYPE_U64, ACCT_INDOM,
    PM_SEM_COUNTER, PMDA_PMUNITS(0,0,1,0,0,PM_COUNT_ONE) } },
/* acct.id.uid */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_UID), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.id.uid_nm */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_UIDNAME), PM_TYPE_STRING, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.id.gid */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_GID), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.id.gid_nm */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCT_GIDNAME), PM_TYPE_STRING, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.flag.fork */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCTFLAG_FORK), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.flag.su */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCTFLAG_SU), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_INSTANT, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.flag.core */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCTFLAG_CORE), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.flag.xsig */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,ACCTFLAG_XSIG), PM_TYPE_U32, ACCT_INDOM,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.control.open_retry_interval */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_OPEN_RETRY_INTERVAL), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.control.check_acct_interval */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_CHECK_ACCT_INTERVAL), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.control.file_size_threshold */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_FILE_SIZE_THRESHOLD), PM_TYPE_U64, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(1,0,0,PM_SPACE_BYTE,0,0) }, },
/* acct.control.lifetime */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_ACCT_LIFETIME), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.control.refresh */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_ACCT_TIMER_INTERVAL), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,1,0,0,PM_TIME_SEC,0) }, },
/* acct.control.enabled */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_ACCT_ENABLE), PM_TYPE_U32, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
/* acct.control.state */
  { NULL, { PMDA_PMID(CLUSTER_ACCT,CONTROL_ACCT_STATE), PM_TYPE_32, PM_INDOM_NULL,
    PM_SEM_DISCRETE, PMDA_PMUNITS(0,0,0,0,0,0) }, },
};

pmInDom
proc_indom(int serial)
{
    return indomtab[serial].it_indom;
}

FILE *
proc_statsfile(const char *path, char *buffer, int size)
{
    pmsprintf(buffer, size, "%s%s", proc_statspath, path);
    buffer[size-1] = '\0';
    return fopen(buffer, "r");
}

static void
refresh_sched_autogroup(void)
{
    char path[MAXPATHLEN];
    FILE *fp;

    if ((fp = proc_statsfile("/proc/sys/kernel/sched_autogroup_enabled",
			     path, sizeof(path))) == NULL)
	autogroup = 0;
    else if (fscanf(fp, "%u", &autogroup) != 1)
	autogroup = 0;
    if (fp)
	fclose(fp);
}

static int
proc_refresh(pmdaExt *pmda, int *need_refresh)
{
    char cgroup[MAXPATHLEN];
    proc_container_t *container;
    size_t cgrouplen = 0;
    int sts;

    if ((container = proc_ctx_container(pmda->e_context)) != NULL) {
	if ((sts = pmdaRootContainerCGroupName(rootfd,
				container->name, container->length,
				cgroup, sizeof(cgroup))) < 0)
	    return sts;
	cgrouplen = sts;
	if (pmDebugOptions.attr)
	    fprintf(stderr, "%s: for container %s, cgroup %s\n",
		    "proc_refresh", container->name, cgroup);
    }

    if (need_refresh[CLUSTER_CGROUP_SUBSYS] ||
	need_refresh[CLUSTER_CGROUP_MOUNTS] ||
	need_refresh[CLUSTER_CPUSET_GROUPS] || 
	need_refresh[CLUSTER_CPUACCT_GROUPS] ||
	need_refresh[CLUSTER_CPUSCHED_GROUPS] ||
	need_refresh[CLUSTER_MEMORY_GROUPS] ||
	need_refresh[CLUSTER_NETCLS_GROUPS] ||
	need_refresh[CLUSTER_BLKIO_GROUPS] ||
	need_refresh[CLUSTER_BLKIO_GROUPS] ||
	need_refresh[CLUSTER_CGROUP2_CPU_PRESSURE] ||
	need_refresh[CLUSTER_CGROUP2_IO_PRESSURE] ||
	need_refresh[CLUSTER_CGROUP2_IRQ_PRESSURE] ||
	need_refresh[CLUSTER_CGROUP2_MEM_PRESSURE] ||
	need_refresh[CLUSTER_CGROUP2_CPU_STAT] ||
	need_refresh[CLUSTER_CGROUP2_IO_STAT] ||
	container) {

	/* first-time initialisation + v1 updates */
	if (cgroup_version < 2) {
	    refresh_cgroup_subsys();
	    refresh_cgroup_filesys();
	}

	/* actual cgroup metric values refreshing */
	if (cgroup_version < 2)
	    refresh_cgroups1(cgroup, cgrouplen, need_refresh);
	else
	    refresh_cgroups2(cgroup, cgrouplen, need_refresh);
    }

    if (need_refresh[CLUSTER_ACCT] &&
	(all_access || proc_ctx_getuid(pmda->e_context) >= 0))
	refresh_acct(&proc_acct);

    if (need_refresh[CLUSTER_PID_STAT] ||
	need_refresh[CLUSTER_PID_STATM] || 
	need_refresh[CLUSTER_PID_STATUS] ||
	need_refresh[CLUSTER_PID_IO] ||
	need_refresh[CLUSTER_PID_LABEL] ||
	need_refresh[CLUSTER_PID_CGROUP] ||
	need_refresh[CLUSTER_PID_SCHEDSTAT] ||
	need_refresh[CLUSTER_PID_OOM_SCORE] ||
	need_refresh[CLUSTER_PID_AUTOGROUP] ||
	need_refresh[CLUSTER_PID_CWD] ||
	need_refresh[CLUSTER_PID_EXE] ||
	need_refresh[CLUSTER_PID_FD] ||
	need_refresh[CLUSTER_PROC_RUNQ]) {
	refresh_proc_pid(&proc_pid,
		need_refresh[CLUSTER_PROC_RUNQ]? &proc_runq : NULL,
		proc_ctx_threads(pmda->e_context, threads),
		proc_ctx_cgroups(pmda->e_context, cgroups),
		container ? cgroup : NULL, cgrouplen);

    }
    if (need_refresh[CLUSTER_HOTPROC_PID_STAT] ||
        need_refresh[CLUSTER_HOTPROC_PID_STATM] ||
        need_refresh[CLUSTER_HOTPROC_PID_STATUS] ||
        need_refresh[CLUSTER_HOTPROC_PID_IO] ||
        need_refresh[CLUSTER_HOTPROC_PID_LABEL] ||
        need_refresh[CLUSTER_HOTPROC_PID_CGROUP] ||
        need_refresh[CLUSTER_HOTPROC_PID_SCHEDSTAT] ||
        need_refresh[CLUSTER_HOTPROC_PID_OOM_SCORE] ||
	need_refresh[CLUSTER_HOTPROC_PID_AUTOGROUP] ||
        need_refresh[CLUSTER_HOTPROC_PID_CWD] ||
        need_refresh[CLUSTER_HOTPROC_PID_EXE] ||
        need_refresh[CLUSTER_HOTPROC_PID_FD] ||
        need_refresh[CLUSTER_HOTPROC_GLOBAL] ||
        need_refresh[CLUSTER_HOTPROC_PRED]){
        refresh_hotproc_pid(&hotproc_pid,
                        proc_ctx_threads(pmda->e_context, threads),
                        proc_ctx_cgroups(pmda->e_context, cgroups));
    }
    return 0;
}

static int
proc_instance(pmInDom indom, int inst, char *name, pmInResult **result, pmdaExt *pmda)
{
    unsigned int	serial = pmInDom_serial(indom);
    int			need_refresh[MAX_CLUSTER] = { 0 };
    char		newname[16];		/* see Note below */
    int			sts;

    switch (serial) {
    case PROC_INDOM:
    	need_refresh[CLUSTER_PID_STAT]++;
    	need_refresh[CLUSTER_PID_STATM]++;
        need_refresh[CLUSTER_PID_STATUS]++;
        need_refresh[CLUSTER_PID_LABEL]++;
        need_refresh[CLUSTER_PID_CGROUP]++;
        need_refresh[CLUSTER_PID_SCHEDSTAT]++;
        need_refresh[CLUSTER_PID_OOM_SCORE]++;
        need_refresh[CLUSTER_PID_AUTOGROUP]++;
        need_refresh[CLUSTER_PID_EXE]++;
        need_refresh[CLUSTER_PID_CWD]++;
        need_refresh[CLUSTER_PID_IO]++;
        need_refresh[CLUSTER_PID_FD]++;
	break;
    case HOTPROC_INDOM:
        need_refresh[CLUSTER_HOTPROC_PID_STAT]++;
        need_refresh[CLUSTER_HOTPROC_PID_STATM]++;
        need_refresh[CLUSTER_HOTPROC_PID_STATUS]++;
        need_refresh[CLUSTER_HOTPROC_PID_LABEL]++;
        need_refresh[CLUSTER_HOTPROC_PID_CGROUP]++;
        need_refresh[CLUSTER_HOTPROC_PID_SCHEDSTAT]++;
        need_refresh[CLUSTER_HOTPROC_PID_OOM_SCORE]++;
        need_refresh[CLUSTER_HOTPROC_PID_AUTOGROUP]++;
        need_refresh[CLUSTER_HOTPROC_PID_EXE]++;
        need_refresh[CLUSTER_HOTPROC_PID_CWD]++;
        need_refresh[CLUSTER_HOTPROC_PID_IO]++;
        need_refresh[CLUSTER_HOTPROC_PID_FD]++;
        need_refresh[CLUSTER_HOTPROC_GLOBAL]++;
        need_refresh[CLUSTER_HOTPROC_PRED]++;
        break;

    case CGROUP_CPUSET_INDOM:
	need_refresh[CLUSTER_CPUSET_GROUPS]++;
	break;
    case CGROUP_CPUACCT_INDOM:
    case CGROUP_PERCPUACCT_INDOM:
	need_refresh[CLUSTER_CPUACCT_GROUPS]++;
	break;
    case CGROUP_CPUSCHED_INDOM:
	need_refresh[CLUSTER_CPUSCHED_GROUPS]++;
	break;
    case CGROUP_MEMORY_INDOM:
	need_refresh[CLUSTER_MEMORY_GROUPS]++;
	break;
    case CGROUP_NETCLS_INDOM:
	need_refresh[CLUSTER_NETCLS_GROUPS]++;
	break;
    case CGROUP_BLKIO_INDOM:
    case CGROUP_PERDEVBLKIO_INDOM:
	need_refresh[CLUSTER_BLKIO_GROUPS]++;
	break;
    case CGROUP_SUBSYS_INDOM:
	need_refresh[CLUSTER_CGROUP_SUBSYS]++;
	break;
    case CGROUP_MOUNTS_INDOM:
    	need_refresh[CLUSTER_CGROUP_MOUNTS]++;
	break;
    case ACCT_INDOM:
	need_refresh[CLUSTER_ACCT]++;
	break;
    /* no default label : pmdaInstance will pick up errors */
    }

    if ((serial == PROC_INDOM || serial == HOTPROC_INDOM) &&
	inst == PM_IN_NULL && name != NULL) {
    	/*
	 * For the proc indoms if the name is a pid (as a string), and it
	 * contains only digits (i.e. it's not a full instance name) then
	 * reformat it to be exactly six digits, with leading zeros.
	 *
	 * Note that although format %06d is used here and in proc_pid.c,
	 *      the pid could be longer than this (in which case there
	 *      are no leading zeroes.  The size of newname[] is chosen
	 *	to comfortably accommodate a 32-bit pid (Linux maximum),
	 *      or max value of 4294967295 (10 digits)
	 */
	char *p;
	for (p = name; *p != '\0'; p++) {
	    if (!isdigit((int)*p))
	    	break;
	}
	if (*p == '\0') {
	    pmsprintf(newname, sizeof(newname), "%06d", atoi(name));
	    name = newname;
	}
    }

    sts = PM_ERR_PERMISSION;
    have_access = all_access || proc_ctx_access(pmda->e_context);
    if (pmDebugOptions.auth)
	fprintf(stderr, "%s: start access have=%d all=%d proc_ctx_access=%d\n",
		"proc_instance", have_access, all_access,
		proc_ctx_access(pmda->e_context));

    if (have_access ||
	((serial != PROC_INDOM) && (serial != HOTPROC_INDOM))) {
	if ((sts = proc_refresh(pmda, need_refresh)) == 0)
	    sts = pmdaInstance(indom, inst, name, result, pmda);
    }

    have_access = all_access || proc_ctx_revert(pmda->e_context);
    if (pmDebugOptions.auth)
	fprintf(stderr, "%s: final access have=%d all=%d proc_ctx_revert=%d\n",
		"proc_instance", have_access, all_access,
		proc_ctx_revert(pmda->e_context));

    return sts;
}

static char *
scheduler_policy_name(int policy)
{
    switch (policy) {
    case 0:	/* SCHED_NORMAL */
	return "NORMAL";
    case 1:	/* SCHED_FIFO */
	return "FIFO";
    case 2:	/* SCHED_RR */
	return "RR";
    case 3:	/* SCHED_BATCH */
	return "BATCH";
    case 5:	/* SCHED_IDLE */
	return "IDLE";
    case 6:	/* SCHED_DEADLINE */
	return "DEADLN";
    default:
	break;
    }
    return "?";
}

/*
 * callback provided to pmdaFetch
 */

static int
proc_fetchCallBack(pmdaMetric *mdesc, unsigned int inst, pmAtomValue *atom)
{
    unsigned int	cluster = pmID_cluster(mdesc->m_desc.pmid);
    unsigned int	item = pmID_item(mdesc->m_desc.pmid);
    pmInDom		indom;
    int			sts;
    int			have_totals;
    const char		*cp;
    proc_pid_entry_t	*entry;
    char 		*tmpbuf;
    cgroup2_t		*cgroup;
    proc_pid_t		*active_proc_pid;
    double		ta, ti, tt, tci;
    process_t		*hotnode;

    active_proc_pid = &proc_pid;

    if (mdesc->m_user != NULL) {
	/* 
	 * The metric value is extracted directly via the address specified
	 * in metrictab.  Note: not many metrics support this - those that
	 * don't have NULL for the m_user field in their metrictab slot.
	 */
	switch (mdesc->m_desc.type) {
	case PM_TYPE_32:
	    atom->l = *(__int32_t *)mdesc->m_user;
	    break;
	case PM_TYPE_U32:
	    atom->ul = *(__uint32_t *)mdesc->m_user;
	    break;
	case PM_TYPE_64:
	    atom->ll = *(__int64_t *)mdesc->m_user;
	    break;
	case PM_TYPE_U64:
	    atom->ull = *(__uint64_t *)mdesc->m_user;
	    break;
	case PM_TYPE_FLOAT:
	    atom->f = *(float *)mdesc->m_user;
	    break;
	case PM_TYPE_DOUBLE:
	    atom->d = *(double *)mdesc->m_user;
	    break;
	case PM_TYPE_STRING:
	    cp = *(char **)mdesc->m_user;
	    atom->cp = (char *)(cp ? cp : "");
	    break;
	default:
	    return 0;
	}
    }
    else
    switch (cluster) {
    case CLUSTER_HOTPROC_GLOBAL:
	have_totals = get_hot_totals(&ta, &ti, &tt, &tci);

	switch (item) {
	case 1: /* hotproc.control.refresh */
	    atom->ul = hotproc_update_interval.tv_sec;
	    break;
	case 8: /* hotproc.control.config */
	    tmpbuf = get_conf_buffer();
	    atom->cp = tmpbuf ? tmpbuf : "";
	    break;
	case 9: /* hotproc.control.config_gen */
	    atom->ul = conf_gen;
	    break;
	case 10: /* hotproc.control.reload_config */
	    atom->ul = 0;
	    break;
	case 2: /* hotproc.total.cpuidle */
	    atom->f = have_totals ? tci : 0;
	    break;
	case 3: /* hotproc.total.cpuburn */
	    atom->f = have_totals ? ta : 0;
	    break;
	case 4: /* hotproc.total.cpuother.transient */
	    atom->f = have_totals ? tt : 0;
	    break;
	case 5: /* hotproc.total.cpuother.not_cpuburn */
	    atom->f = have_totals ? ti : 0;
	    break;
	case 6: /* hotproc.total.cpuother.total */
	    atom->f = have_totals ? ti + tt : 0;
	    break;
	case 7: { /* hotproc.total.cpuother.percent */
	    double other = tt + ti;
	    double non_idle = other + ta;

	    /* if non_idle = 0, very unlikely,
	     * then the value here is meaningless
	     *
	     * Also if all the numbers are very small
	     * this is not accurate. Might want to dump this original metric
	     */
	    if (!have_totals || non_idle == 0)
		atom->f = 0;
	    else
		atom->f = other / non_idle * 100;
	    break;
	}

	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_HOTPROC_PRED:
	sts = get_hotproc_node(inst, &hotnode);
	if (sts == 0)
	    return PM_ERR_INST;

	switch (item) {
	    case 1: /* hotproc.predicate.ctxswitch */
		atom->f = hotnode->preds.ctxswitch;
		break;
	    case 2: /* hotproc.predicate.virtualsize */
		atom->ul = hotnode->preds.virtualsize;
		break;
	    case 3: /* hotproc.predicate.residentsize */
		atom->ul = hotnode->preds.residentsize;
		break;
	    case 4: /* hotproc.predicate.iodemand */
		atom->f = hotnode->preds.iodemand;
		break;
	    case 5: /* hotproc.predicate.iowait */
		atom->f = hotnode->preds.iowait;
		break;
	    case 6: /* hotproc.predicate.schedwait */
		atom->f = hotnode->preds.schedwait;
		break;
	    case 7: /* hotproc.predicate.cpuburn */
		atom->f = hotnode->r_cpuburn;
		break;
	    default:
		return PM_ERR_PMID;
	}
	break;

    case CLUSTER_HOTPROC_PID_STAT:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_STAT:
	if (item == 99) { /* proc.nprocs */
	    atom->ul = active_proc_pid->indom->it_numinst;
	    break;
	}

	if (!have_access)
	    return PM_ERR_PERMISSION;

	if (item == 0 || item == 41) {
	    if ((entry = proc_pid_entry_lookup(inst, active_proc_pid)) == NULL)
		return 0;
	    if (item == 0) /* proc.psinfo.pid */
		atom->ul = entry->id;
	    else           /* proc.psinfo.psargs */
		atom->cp = entry->psargs;
	    break;
	}
	if (item == 40) { /* proc.psinfo.wchan_s */
	    if ((entry = fetch_proc_pid_wchan(inst, active_proc_pid, &sts)) == NULL)
		return sts;
	    if (!entry->wchan_buf)	/* 2.6+ kernels */
		return 0;
	    atom->cp = entry->wchan_buf;
	    break;
	}
	if (item == 47) { /* proc.psinfo.environ */
	    if ((entry = fetch_proc_pid_environ(inst, active_proc_pid, &sts)) == NULL)
		return sts;
	    atom->cp = entry->environ_buf? entry->environ_buf : "";
	    break;
	}

	if ((entry = fetch_proc_pid_stat(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_STAT))
	    return 0;

	switch (item) {
	case 1: /* proc.psinfo.cmd */
	    if ((atom->cp = entry->stat.cmd) == NULL)
		return 0;
	    break;

	case 2: /* proc.psinfo.sname */
	    atom->cp = entry->stat.state;
	    break;

	case 3: /* proc.psinfo.ppid */
	    atom->ul = entry->stat.ppid;
	    break;

	case 4: /* proc.psinfo.pgrp */
	    atom->ul = entry->stat.pgrp;
	    break;

	case 5: /* proc.psinfo.session */
	    atom->ul = entry->stat.session;
	    break;

	case 6: /* proc.psinfo.tty */
	    atom->ul = entry->stat.tty;
	    break;

	case 7: /* proc.psinfo.tty_pgrp */
	    if (entry->stat.tty_pgrp < 0)
		return 0;
	    atom->ul = entry->stat.tty_pgrp;
	    break;

	case 8: /* proc.psinfo.flags */
	    atom->ul = entry->stat.flags;
	    break;

	case 9: /* proc.psinfo.minflt */
	    atom->ul = entry->stat.minflt;
	    break;

	case 10: /* proc.psinfo.cmin_flt */
	    atom->ul = entry->stat.cminflt;
	    break;

	case 11: /* proc.psinfo.maj_flt */
	    atom->ul = entry->stat.majflt;
	    break;

	case 12: /* proc.psinfo.cmaj_flt */
	    atom->ul = entry->stat.cmajflt;
	    break;

	case 13: /* proc.psinfo.utime */
	    _pm_assign_ulong(atom, entry->stat.utime * 1000 / _pm_hertz);
	    break;

	case 14: /* proc.psinfo.stime */
	    _pm_assign_ulong(atom, entry->stat.stime * 1000 / _pm_hertz);
	    break;

	case 15: /* proc.psinfo.cutime */
	    _pm_assign_ulong(atom, entry->stat.cutime * 1000 / _pm_hertz);
	    break;

	case 16: /* proc.psinfo.cstime */
	    _pm_assign_ulong(atom, entry->stat.cstime * 1000 / _pm_hertz);
	    break;

	case 17: /* proc.psinfo.priority */
	    atom->l = entry->stat.priority;
	    break;

	case 18: /* proc.psinfo.nice */
	    atom->l = entry->stat.nice;
	    break;

	/* case 19: -- threads */

	case 20: /* proc.psinfo.it_real_value */
	    atom->ul = entry->stat.it_real_value;
	    break;

	case 21: /* proc.psinfo.start_time */
	    atom->ull = entry->stat.start_time * 1000 / _pm_hertz;
	    break;

	case 22: /* proc.psinfo.vsize */
	    atom->ull = entry->stat.vsize / 1024;
	    break;

	case 23: /* proc.psinfo.rss */
	    atom->ull = entry->stat.rss * _pm_system_pagesize / 1024;
	    break;

	case 24: /* proc.psinfo.rss_rlim */
	    atom->ull = entry->stat.rss_rlim / 1024;
	    break;

	case 25: /* proc.psinfo.start_code */
	    atom->ul = entry->stat.start_code;
	    break;

	case 26: /* proc.psinfo.end_code */
	    atom->ul = entry->stat.end_code;
	    break;

	case 27: /* proc.psinfo.start_stack */
	    atom->ul = entry->stat.start_stack;
	    break;

	case 28: /* proc.psinfo.esp */
	    atom->ul = entry->stat.esp;
	    break;

	case 29: /* proc.psinfo.eip */
	    atom->ul = entry->stat.eip;
	    break;

	case 30: /* proc.psinfo.signal */
	    atom->ul = entry->stat.signal;
	    break;

	case 31: /* proc.psinfo.blocked */
	    atom->ul = entry->stat.blocked;
	    break;

	case 32: /* proc.psinfo.sigignore */
	    atom->ul = entry->stat.sigignore;
	    break;

	case 33: /* proc.psinfo.sigcatch */
	    atom->ul = entry->stat.sigcatch;
	    break;

	case 34: /* proc.psinfo.wchan */
	    _pm_assign_ulong(atom, entry->stat.wchan);
	    break;

	case 35: /* proc.psinfo.nswap */
	    atom->ul = entry->stat.nswap;
	    break;

	case 36: /* proc.psinfo.cnswap */
	    atom->ul = entry->stat.cnswap;
	    break;

	case 37: /* proc.psinfo.exit_signal */
	    atom->ul = entry->stat.exit_signal;
	    break;

	case 38: /* proc.psinfo.processor */
	    atom->ul = entry->stat.processor;
	    break;

	case 39: /* proc.psinfo.ttyname */
	    if (!entry->stat.tty)
		atom->cp = "?";
	    else
		atom->cp = get_ttyname_info((dev_t)entry->stat.tty);
	    break;
 
	case 42: /* proc.psinfo.rt_priority */
	    atom->ul = entry->stat.rtpriority;
	    break;

	case 43: /* proc.psinfo.policy */
	    atom->ul = entry->stat.policy;
	    break;

	case 44: /* proc.psinfo.delayacct_blkio_time */
	    atom->ull = entry->stat.delayacct_blkio_time * 1000 / _pm_hertz;
	    break;

	case 45: /* proc.psinfo.guest_time */
	    atom->ull = entry->stat.guest_time * 1000 / _pm_hertz;
	    break;

	case 46: /* proc.psinfo.cguest_time */
	    atom->ull = entry->stat.cguest_time * 1000 / _pm_hertz;
	    break;

	case 48: /* proc.psinfo.policy_s */
	    atom->cp = scheduler_policy_name(entry->stat.policy);
	    break;

	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_HOTPROC_PID_STATM:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_STATM:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if (item == 7) { /* proc.memory.maps */
	    if ((entry = fetch_proc_pid_maps(inst, active_proc_pid, &sts)) == NULL)
		return sts;
	    atom->cp = (entry->maps_buf ? entry->maps_buf : "");
	    break;
	}
	if ((entry = fetch_proc_pid_statm(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_STATM))
	    return 0;
	switch (item) {
	case 0: /* proc.memory.size */
	    atom->ul = entry->statm.size * _pm_system_pagesize / 1024;
	    break;
	case 1:	/* proc.memory.rss */
	    atom->ul = entry->statm.rss * _pm_system_pagesize / 1024;
	    break;
	case 2: /* proc.memory.share */
	    atom->ul = entry->statm.share * _pm_system_pagesize / 1024;
	    break;
	case 3: /* proc.memory.textrss */
	    atom->ul = entry->statm.textrs * _pm_system_pagesize / 1024;
	    break;
	case 4: /* proc.memory.librss */
	    atom->ul = entry->statm.librs * _pm_system_pagesize / 1024;
	    break;
	case 5: /* proc.memory.datrss */
	    atom->ul = entry->statm.datrs * _pm_system_pagesize / 1024;
	    break;
	case 6: /* proc.memory.dirty */
	    atom->ul = entry->statm.dirty * _pm_system_pagesize / 1024;
	    break;
	default:
	    return PM_ERR_PMID;
	}
    	break;

    case CLUSTER_HOTPROC_PID_SCHEDSTAT:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_SCHEDSTAT:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_schedstat(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_SCHEDSTAT))
	    return 0;

	switch (item) {
	case 0: /* proc.schedstat.cpu_time */
	    atom->ull = entry->schedstat.cputime;
	    break;
	case 1: /* proc.schedstat.run_delay */
	    atom->ull = entry->schedstat.rundelay;
	    break;
	case 2: /* proc.schedstat.pcount */
	    _pm_assign_ulong(atom, entry->schedstat.count);
	    break;
	default:
	    return PM_ERR_PMID;
	}
    	break;

    case CLUSTER_HOTPROC_PID_IO:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_IO:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_io(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_IO))
	    return 0;
	switch (item) {
	case 0: /* proc.io.rchar */
	    atom->ull = entry->io.rchar;
	    break;
	case 1: /* proc.io.wchar */
	    atom->ull = entry->io.wchar;
	    break;
	case 2: /* proc.io.syscr */
	    atom->ull = entry->io.syscr;
	    break;
	case 3: /* proc.io.syscw */
	    atom->ull = entry->io.syscw;
	    break;
	case 4: /* proc.io.read_bytes */
	    atom->ull = entry->io.readb;
	    break;
	case 5: /* proc.io.write_bytes */
	    atom->ull = entry->io.writeb;
	    break;
	case 6: /* proc.io.cancelled_write_bytes */
	    atom->ull = entry->io.cancel;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_HOTPROC_PID_SMAPS:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_SMAPS:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_smaps(inst, active_proc_pid, &sts)) == NULL)
	    return PM_ERR_APPVERSION;
	if (!(entry->success & PROC_PID_FLAG_SMAPS))
	    return 0;
	switch (item) {
	case 0: /* proc.smaps.rss */
	    atom->ull = entry->smaps.rss;
	    break;
	case 1: /* proc.smaps.pss */
	    atom->ull = entry->smaps.pss;
	    break;
	case 2: /* proc.smaps.pss_anon */
	    atom->ull = entry->smaps.pss_anon;
	    break;
	case 3: /* proc.smaps.pss_file */
	    atom->ull = entry->smaps.pss_file;
	    break;
	case 4: /* proc.smaps.pss_shmem */
	    atom->ull = entry->smaps.pss_shmem;
	    break;
	case 5: /* proc.smaps.shared_clean */
	    atom->ull = entry->smaps.shared_clean;
	    break;
	case 6: /* proc.smaps.shared_dirty */
	    atom->ull = entry->smaps.shared_dirty;
	    break;
	case 7: /* proc.smaps.private_clean */
	    atom->ull = entry->smaps.private_clean;
	    break;
	case 8: /* proc.smaps.private_dirty */
	    atom->ull = entry->smaps.private_dirty;
	    break;
	case 9: /* proc.smaps.referenced */
	    atom->ull = entry->smaps.referenced;
	    break;
	case 10: /* proc.smaps.anonymous */
	    atom->ull = entry->smaps.anonymous;
	    break;
	case 11: /* proc.smaps.lazyfree */
	    atom->ull = entry->smaps.lazyfree;
	    break;
	case 12: /* proc.smaps.anonhugepages */
	    atom->ull = entry->smaps.anonhugepages;
	    break;
	case 13: /* proc.smaps.shmempmdmapped */
	    atom->ull = entry->smaps.shmempmdmapped;
	    break;
	case 14: /* proc.smaps.filepmdmapped */
	    atom->ull = entry->smaps.filepmdmapped;
	    break;
	case 15: /* proc.smaps.shared_hugetlb */
	    atom->ull = entry->smaps.shared_hugetlb;
	    break;
	case 16: /* proc.smaps.private_hugetlb */
	    atom->ull = entry->smaps.private_hugetlb;
	    break;
	case 17: /* proc.smaps.swap */
	    atom->ull = entry->smaps.swap;
	    break;
	case 18: /* proc.smaps.swappss */
	    atom->ull = entry->smaps.swappss;
	    break;
	case 19: /* proc.smaps.locked */
	    atom->ull = entry->smaps.locked;
	    break;
	case 20: /* proc.smaps.pss_dirty */
	    atom->ull = entry->smaps.pss_dirty;
	    break;

	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_HOTPROC_PID_STATUS:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_STATUS:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_status(inst, active_proc_pid, &sts)) == NULL)
		return sts;
	if (!(entry->success & PROC_PID_FLAG_STATUS))
	    return 0;

	switch (item) {
	case 0: /* proc.id.uid */
	    atom->ul = entry->status.uid;
	    break;
	case 1: /* proc.id.euid */
	    atom->ul = entry->status.euid;
	    break;
	case 2: /* proc.id.suid */
	    atom->ul = entry->status.suid;
	    break;
	case 3: /* proc.id.fsuid */
	    atom->ul = entry->status.fsuid;
	    break;
	case 4: /* proc.id.gid */
	    atom->ul = entry->status.uid;
	    break;
	case 5: /* proc.id.egid */
	    atom->ul = entry->status.egid;
	    break;
	case 6: /* proc.id.sgid */
	    atom->ul = entry->status.sgid;
	    break;
	case 7: /* proc.id.fsgid */
	    atom->ul = entry->status.fsgid;
	    break;
	case 8: /* proc.id.uid_nm */
	    atom->cp = proc_uidname_lookup(entry->status.uid);
	    break;
	case 9: /* proc.id.euid_nm */
	    atom->cp = proc_uidname_lookup(entry->status.euid);
	    break;
	case 10: /* proc.id.suid_nm */
	    atom->cp = proc_uidname_lookup(entry->status.suid);
	    break;
	case 11: /* proc.id.fsuid_nm */
	    atom->cp = proc_uidname_lookup(entry->status.fsuid);
	    break;
	case 12: /* proc.id.gid_nm */
	    atom->cp = proc_gidname_lookup(entry->status.gid);
	    break;
	case 13: /* proc.id.egid_nm */
	    atom->cp = proc_gidname_lookup(entry->status.egid);
	    break;
	case 14: /* proc.id.sgid_nm */
	    atom->cp = proc_gidname_lookup(entry->status.sgid);
	    break;
	case 15: /* proc.id.fsgid_nm */
	    atom->cp = proc_gidname_lookup(entry->status.fsgid);
	    break;
	case 16: /* proc.psinfo.signal_s */
	    atom->cp = proc_strings_lookup(entry->status.sigpnd);
	    break;
	case 17: /* proc.psinfo.blocked_s */
	    atom->cp = proc_strings_lookup(entry->status.sigblk);
	    break;
	case 18: /* proc.psinfo.sigignore_s */
	    atom->cp = proc_strings_lookup(entry->status.sigign);
	    break;
	case 19: /* proc.psinfo.sigcatch_s */
	    atom->cp = proc_strings_lookup(entry->status.sigcgt);
	    break;
	case 20: /* proc.memory.vmsize */
	    atom->ul = entry->status.vmsize;
	    break;
	case 21: /* proc.memory.vmlock */
	    atom->ul = entry->status.vmlck;
	    break;
	case 22: /* proc.memory.vmrss */
            atom->ul = entry->status.vmrss;
            break;
	case 23: /* proc.memory.vmdata */
	    atom->ul = entry->status.vmdata;
	    break;
	case 24: /* proc.memory.vmstack */
	    atom->ul = entry->status.vmstk;
	    break;
	case 25: /* proc.memory.vmexe */
	    atom->ul = entry->status.vmexe;
	    break;
	case 26: /* proc.memory.vmlib */
	    atom->ul = entry->status.vmlib;
	    break;
	case 27: /* proc.memory.vmswap */
	    atom->ul = entry->status.vmswap;
	    break;
	case 28: /* proc.psinfo.threads */
	    atom->ul = entry->status.threads;
	    break;
	case 29: /* proc.psinfo.vctxsw */
	    atom->ul = entry->status.vctxsw;
	    break;
	case 30: /* proc.psinfo.nvctxsw */
	    atom->ul = entry->status.nvctxsw;
	     break;
	case 31: /* proc.psinfo.cpusallowed */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_CPUSALLOWED))
	        return PM_ERR_APPVERSION;
	    atom->cp = proc_strings_lookup(entry->status.cpusallowed);
	    break;
	case 32: /* proc.psinfo.ngid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_NGID))
	        return PM_ERR_APPVERSION;
	    atom->ul = entry->status.ngid;
	    break;
	case 33: /* proc.memory.vmpeak */
	    atom->ul = entry->status.vmpeak;
	    break;
	case 34: /* proc.memory.vmpin */
	    atom->ul = entry->status.vmpin;
	    break;
	case 35: /* proc.memory.vmhwm */
	    atom->ul = entry->status.vmhwm;
	    break;
	case 36: /* proc.memory.vmpte */
	    atom->ul = entry->status.vmpte;
	    break;
	case 37: /* proc.namespaces.tgid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_NSTGID))
		return PM_ERR_APPVERSION;
	    atom->cp = proc_strings_lookup(entry->status.nstgid);
	    break;
	case 38: /* proc.namespaces.pid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_NSPID))
		return PM_ERR_APPVERSION;
	    atom->cp = proc_strings_lookup(entry->status.nspid);
	    break;
	case 39: /* proc.namespaces.pgid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_NSPGID))
		return PM_ERR_APPVERSION;
	    atom->cp = proc_strings_lookup(entry->status.nspgid);
	    break;
	case 40: /* proc.namespaces.sid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_NSSID))
		return PM_ERR_APPVERSION;
	    atom->cp = proc_strings_lookup(entry->status.nssid);
	    break;
	case 41: /* proc.psinfo.tgid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_TGID))
	        return PM_ERR_APPVERSION;
	    atom->ul = entry->status.tgid;
	    break;
	case 42: /* proc.psinfo.envid */
	    if (!(entry->status.flags & PROC_STATUS_FLAG_ENVID))
	        return PM_ERR_APPVERSION;
	    atom->ul = entry->status.envid;
	    break;
	case 43: /* proc.memory.vmreal */
	    atom->ull = (__uint64_t)entry->status.vmrss +
			(__uint64_t)entry->status.vmswap;
	    break;
	case 44: /* proc.memory.vmnonlib */
	    atom->ull = (__uint64_t)entry->status.vmrss +
			(__uint64_t)entry->status.vmswap;
	    if (atom->ull >= (__uint64_t)entry->status.vmlib)
		atom->ull -= (__uint64_t)entry->status.vmlib;
	    else
		atom->ull = 0;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_CGROUP_SUBSYS: {
	subsys_t *ssp;

	indom = INDOM(CGROUP_SUBSYS_INDOM);
	if (item == 1) { /* cgroup.subsys.count */
	    atom->ul = pmdaCacheOp(indom, PMDA_CACHE_SIZE_ACTIVE);
	    break;
	}
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&ssp)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	    return 0;
	switch (item) {
	case CG_SUBSYS_HIERARCHY: /* cgroup.subsys.hierarchy */
	    atom->ul = ssp->hierarchy;
	    break;
	case CG_SUBSYS_NUMCGROUPS: /* cgroup.subsys.num_cgroups */
	    atom->ul = ssp->num_cgroups;
	    break;
	case CG_SUBSYS_ENABLED: /* cgroup.subsys.enabled */
	    atom->ul = ssp->enabled;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_CGROUP_MOUNTS: {
	filesys_t *fsp;

	indom = INDOM(CGROUP_MOUNTS_INDOM);
	switch (item) {
	case CG_MOUNTS_SUBSYS: /* cgroup.mounts.subsys */
	    if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&fsp)) < 0)
		return sts;
	    if (sts != PMDA_CACHE_ACTIVE)
	    	return 0;
	    atom->cp = cgroup_find_subsys(INDOM(CGROUP_SUBSYS_INDOM), fsp);
	    break;
	case CG_MOUNTS_COUNT: /* cgroup.mounts.count */
	    atom->ul = pmdaCacheOp(indom, PMDA_CACHE_SIZE_ACTIVE);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_CPUSET_GROUPS: {
	cgroup_cpuset_t *cpuset;

	indom = INDOM(CGROUP_CPUSET_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cpuset)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	   return 0;
	switch (item) {
	case CG_CPUSET_CPUS: /* cgroup.cpuset.cpus */
	    atom->cp = proc_strings_lookup(cpuset->cpus);
	    break;
	case CG_CPUSET_MEMS: /* cgroup.cpuset.mems */
	    atom->cp = proc_strings_lookup(cpuset->mems);
	    break;
	case CG_CPUSET_ID_CONTAINER: /* cgroup.cpuset.id.container */
	    atom->cp = proc_strings_lookup(cpuset->container);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_CPUACCT_GROUPS: {
	cgroup_percpuacct_t *percpuacct;
	cgroup_cpuacct_t *cpuacct;

	if (item == CG_CPUACCT_PERCPU_USAGE) {
	    indom = INDOM(CGROUP_PERCPUACCT_INDOM);
	    sts = pmdaCacheLookup(indom, inst, NULL, (void **)&percpuacct);
	} else {
	    indom = INDOM(CGROUP_CPUACCT_INDOM);
	    sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cpuacct);
	}
	if (sts < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	   return 0;
	switch (item) {
	case CG_CPUACCT_USER: /* cgroup.cpuacct.stat.user */
	    if (cpuacct->cputime.user == (__uint64_t)-1) return 0;
	    atom->ull = cpuacct->cputime.user;
	    break;
	case CG_CPUACCT_SYSTEM: /* cgroup.cpuacct.stat.system */
	    if (cpuacct->cputime.system == (__uint64_t)-1) return 0;
	    atom->ull = cpuacct->cputime.system;
	    break;
	case CG_CPUACCT_USAGE: /* cgroup.cpuacct.usage */
	    if (cpuacct->cputime.usage == (__uint64_t)-1) return 0;
	    atom->ull = cpuacct->cputime.usage;
	    break;
	case CG_CPUACCT_PERCPU_USAGE: /* cgroup.cpuacct.usage_percpu */
	    if (percpuacct->usage == (__uint64_t)-1) return 0;
	    atom->ull = percpuacct->usage;
	    break;
	case CG_CPUACCT_ID_CONTAINER: /* cgroup.cpuacct.id.container */
	    atom->cp = proc_strings_lookup(cpuacct->container);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_CPUSCHED_GROUPS: {
	cgroup_cpusched_t *cpusched;

	indom = INDOM(CGROUP_CPUSCHED_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cpusched)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	   return 0;
	switch (item) {
	case CG_CPUSCHED_SHARES: /* cgroup.cpusched.shares */
	    if (cpusched->shares == (__uint64_t)-1) return 0;
	    atom->ull = cpusched->shares;
	    break;
	case CG_CPUSCHED_PERIODS: /* cgroup.cpusched.periods */
	    if (cpusched->stat.nr_periods == (__uint64_t)-1) return 0;
	    atom->ull = cpusched->stat.nr_periods;
	    break;
	case CG_CPUSCHED_THROTTLED: /* cgroup.cpusched.throttled */
	    if (cpusched->stat.nr_throttled == (__uint64_t)-1) return 0;
	    atom->ull = cpusched->stat.nr_throttled;
	    break;
	case CG_CPUSCHED_THROTTLED_TIME: /* cgroup.cpusched.throttled_time */
	    if (cpusched->stat.throttled_time == (__uint64_t)-1) return 0;
	    atom->ull = cpusched->stat.throttled_time;
	    break;
	case CG_CPUSCHED_CFS_PERIOD: /* cgroup.cpusched.cfs_period */
	    if (cpusched->cfs_period == (__uint64_t)-1) return 0;
	    atom->ull = cpusched->cfs_period;
	    break;
	case CG_CPUSCHED_CFS_QUOTA: /* cgroup.cpusched.cfs_quota */
	    if (cpusched->cfs_quota == (__int64_t)-1) return 0;
	    atom->ll = cpusched->cfs_quota;
	    break;
	case CG_CPUSCHED_ID_CONTAINER: /* cgroup.cpusched.id.container */
	    atom->cp = proc_strings_lookup(cpusched->container);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_MEMORY_GROUPS: {
	cgroup_memory_t *memory;

	indom = INDOM(CGROUP_MEMORY_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&memory)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	    return 0;
	switch (item) {
	case CG_MEMORY_STAT_CACHE: /* cgroup.memory.stat.cache */
	    if (memory->stat.cache == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.cache;
	    break;
	case CG_MEMORY_STAT_RSS: /* cgroup.memory.stat.rss */
	    if (memory->stat.rss == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.rss;
	    break;
	case CG_MEMORY_STAT_RSS_HUGE: /* cgroup.memory.stat.rss_huge */
	    if (memory->stat.rss_huge == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.rss_huge;
	    break;
	case CG_MEMORY_STAT_MAPPED_FILE: /* cgroup.memory.stat.mapped_file */
	    if (memory->stat.mapped_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.mapped_file;
	    break;
	case CG_MEMORY_STAT_WRITEBACK: /* cgroup.memory.stat.writeback */
	    if (memory->stat.writeback == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.writeback;
	    break;
	case CG_MEMORY_STAT_SWAP: /* cgroup.memory.stat.swap */
	    if (memory->stat.swap == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.swap;
	    break;
	case CG_MEMORY_STAT_PGPGIN: /* cgroup.memory.stat.pgpgin */
	    if (memory->stat.pgpgin == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgpgin;
	    break;
	case CG_MEMORY_STAT_PGPGOUT: /* cgroup.memory.stat.pgpgout */
	    if (memory->stat.pgpgout == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgpgout;
	    break;
	case CG_MEMORY_STAT_PGFAULT: /* cgroup.memory.stat.pgfault */
	    if (memory->stat.pgfault == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgfault;
	    break;
	case CG_MEMORY_STAT_PGMAJFAULT: /* cgroup.memory.stat.pgmajfault */
	    if (memory->stat.pgmajfault == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgmajfault;
	    break;
	case CG_MEMORY_STAT_INACTIVE_ANON: /* cgroup.memory.stat.inactive_anon */
	    if (memory->stat.inactive_anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.inactive_anon;
	    break;
	case CG_MEMORY_STAT_ACTIVE_ANON: /* cgroup.memory.stat.active_anon */
	    if (memory->stat.active_anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.active_anon;
	    break;
	case CG_MEMORY_STAT_INACTIVE_FILE: /* cgroup.memory.stat.inactive_file */
	    if (memory->stat.inactive_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.inactive_file;
	    break;
	case CG_MEMORY_STAT_ACTIVE_FILE: /* cgroup.memory.stat.active_file */
	    if (memory->stat.active_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.active_file;
	    break;
	case CG_MEMORY_STAT_UNEVICTABLE: /* cgroup.memory.stat.unevictable */
	    if (memory->stat.unevictable == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.unevictable;
	    break;
	case CG_MEMORY_STAT_TOTAL_CACHE: /* cgroup.memory.stat.total.cache */
	    if (memory->stat.total_cache == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_cache;
	    break;
	case CG_MEMORY_STAT_TOTAL_RSS: /* cgroup.memory.stat.total.rss */
	    if (memory->stat.total_rss == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_rss;
	    break;
	case CG_MEMORY_STAT_TOTAL_RSS_HUGE: /* cgroup.memory.stat.total.rss_huge */
	    if (memory->stat.total_rss_huge == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_rss_huge;
	    break;
	case CG_MEMORY_STAT_TOTAL_MAPPED_FILE: /* cgroup.memory.stat.total.mapped_file */
	    if (memory->stat.total_mapped_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_mapped_file;
	    break;
	case CG_MEMORY_STAT_TOTAL_WRITEBACK: /* cgroup.memory.stat.total.writeback */
	    if (memory->stat.total_writeback == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_writeback;
	    break;
	case CG_MEMORY_STAT_TOTAL_SWAP: /* cgroup.memory.stat.total.swap */
	    if (memory->stat.total_swap == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_swap;
	    break;
	case CG_MEMORY_STAT_TOTAL_PGPGIN: /* cgroup.memory.stat.total.pgpgin */
	    if (memory->stat.total_pgpgin == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_pgpgin;
	    break;
	case CG_MEMORY_STAT_TOTAL_PGPGOUT: /* cgroup.memory.stat.total.pgpgout */
	    if (memory->stat.total_pgpgout == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_pgpgout;
	    break;
	case CG_MEMORY_STAT_TOTAL_PGFAULT: /* cgroup.memory.stat.total.pgfault */
	    if (memory->stat.total_pgfault == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_pgfault;
	    break;
	case CG_MEMORY_STAT_TOTAL_PGMAJFAULT: /* cgroup.memory.stat.total.pgmajfault */
	    if (memory->stat.total_pgmajfault == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_pgmajfault;
	    break;
	case CG_MEMORY_STAT_TOTAL_INACTIVE_ANON: /* cgroup.memory.stat.total.inactive_anon */
	    if (memory->stat.total_inactive_anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_inactive_anon;
	    break;
	case CG_MEMORY_STAT_TOTAL_ACTIVE_ANON: /* cgroup.memory.stat.total.active_anon */
	    if (memory->stat.total_active_anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_active_anon;
	    break;
	case CG_MEMORY_STAT_TOTAL_INACTIVE_FILE: /* cgroup.memory.stat.total.inactive_file */
	    if (memory->stat.total_inactive_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_inactive_file;
	    break;
	case CG_MEMORY_STAT_TOTAL_ACTIVE_FILE: /* cgroup.memory.stat.total.active_file */
	    if (memory->stat.total_active_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_active_file;
	    break;
	case CG_MEMORY_STAT_TOTAL_UNEVICTABLE: /* cgroup.memory.stat.total.unevictable */
	    if (memory->stat.total_unevictable == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.total_unevictable;
	    break;
	case CG_MEMORY_STAT_RECENT_ROTATED_ANON: /* cgroup.memory.stat.recent.rotated_anon */
	    if (memory->stat.recent_rotated_anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.recent_rotated_anon;
	    break;
	case CG_MEMORY_STAT_RECENT_ROTATED_FILE: /* cgroup.memory.stat.recent.rotated_file */
	    if (memory->stat.recent_rotated_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.recent_rotated_file;
	    break;
	case CG_MEMORY_STAT_RECENT_SCANNED_ANON: /* cgroup.memory.stat.recent.scanned_anon */
	    if (memory->stat.recent_scanned_anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.recent_scanned_anon;
	    break;
	case CG_MEMORY_STAT_RECENT_SCANNED_FILE: /* cgroup.memory.stat.recent.scanned_file */
	    if (memory->stat.recent_scanned_file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.recent_scanned_file;
	    break;
	case CG_MEMORY_STAT_ANON:
	    if (memory->stat.anon == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.anon;
	    break;
	case CG_MEMORY_STAT_ANON_THP:
	    if (memory->stat.anon_thp == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.anon_thp;
	    break;
	case CG_MEMORY_STAT_FILE:
	    if (memory->stat.file == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.file;
	    break;
	case CG_MEMORY_STAT_FILE_DIRTY:
	    if (memory->stat.file_dirty == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.file_dirty;
	    break;
	case CG_MEMORY_STAT_FILE_MAPPED:
	    if (memory->stat.file_mapped == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.file_mapped;
	    break;
	case CG_MEMORY_STAT_FILE_WRITEBACK:
	    if (memory->stat.file_writeback == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.file_writeback;
	    break;
	case CG_MEMORY_STAT_KERNEL_STACK:
	    if (memory->stat.kernel_stack == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.kernel_stack;
	    break;
	case CG_MEMORY_STAT_PGACTIVATE:
	    if (memory->stat.pgactivate == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgactivate;
	    break;
	case CG_MEMORY_STAT_PGDEACTIVATE:
	    if (memory->stat.pgdeactivate == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgdeactivate;
	    break;
	case CG_MEMORY_STAT_PGLAZYFREE:
	    if (memory->stat.pglazyfree == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pglazyfree;
	    break;
	case CG_MEMORY_STAT_PGLAZYFREED:
	    if (memory->stat.pglazyfreed == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pglazyfreed;
	    break;
	case CG_MEMORY_STAT_PGREFILL:
	    if (memory->stat.pgrefill == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgrefill;
	    break;
	case CG_MEMORY_STAT_PGSCAN:
	    if (memory->stat.pgscan == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgscan;
	    break;
	case CG_MEMORY_STAT_PGSTEAL:
	    if (memory->stat.pgsteal == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.pgsteal;
	    break;
	case CG_MEMORY_STAT_SHMEM:
	    if (memory->stat.shmem == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.shmem;
	    break;
	case CG_MEMORY_STAT_SLAB:
	    if (memory->stat.slab == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.slab;
	    break;
	case CG_MEMORY_STAT_SLAB_RECLAIMABLE:
	    if (memory->stat.slab_reclaimable == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.slab_reclaimable;
	    break;
	case CG_MEMORY_STAT_SLAB_UNRECLAIMABLE:
	    if (memory->stat.slab_unreclaimable == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.slab_unreclaimable;
	    break;
	case CG_MEMORY_STAT_SOCK:
	    if (memory->stat.sock == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.sock;
	    break;
	case CG_MEMORY_STAT_THP_COLLAPSE_ALLOC:
	    if (memory->stat.thp_collapse_alloc == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.thp_collapse_alloc;
	    break;
	case CG_MEMORY_STAT_THP_FAULT_ALLOC:
	    if (memory->stat.thp_fault_alloc == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.thp_fault_alloc;
	    break;
	case CG_MEMORY_STAT_WORKINGSET_ACTIVATE:
	    if (memory->stat.workingset_activate == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.workingset_activate;
	    break;
	case CG_MEMORY_STAT_WORKINGSET_NODERECLAIM:
	    if (memory->stat.workingset_nodereclaim == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.workingset_nodereclaim;
	    break;
	case CG_MEMORY_STAT_WORKINGSET_REFAULT:
	    if (memory->stat.workingset_refault == (__uint64_t)-1) return 0;
	    atom->ull = memory->stat.workingset_refault;
	    break;
	case CG_MEMORY_CURRENT: /* cgroup.memory.current */
	    if (memory->current == (__uint64_t)-1) return 0;
	    atom->ull = memory->current;
	    break;
	case CG_MEMORY_USAGE_IN_BYTES: /* cgroup.memory.usage */
	    if (memory->usage == (__uint64_t)-1) return 0;
	    atom->ull = memory->usage;
	    break;
	case CG_MEMORY_LIMIT_IN_BYTES: /* cgroup.memory.limit */
	    if (memory->limit == (__uint64_t)-1) return 0;
	    atom->ull = memory->limit;
	    break;
	case CG_MEMORY_FAILCNT: /* cgroup.memory.failcnt */
	    if (memory->failcnt == (__uint64_t)-1) return 0;
	    atom->ull = memory->failcnt;
	    break;
	case CG_MEMORY_ID_CONTAINER: /* cgroup.memory.id.container */
	    atom->cp = proc_strings_lookup(memory->container);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_NETCLS_GROUPS: {
	cgroup_netcls_t *netcls;

	indom = INDOM(CGROUP_NETCLS_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&netcls)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	   return 0;
	switch (item) {
	case CG_NETCLS_CLASSID: /* cgroup.netclass.classid */
	    if (netcls->classid == (__uint64_t)-1) return 0;
	    atom->ull = netcls->classid;
	    break;
	case CG_NETCLS_ID_CONTAINER: /* cgroup.netclass.id.container */
	    atom->cp = proc_strings_lookup(netcls->container);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_BLKIO_GROUPS: {
	cgroup_perdevblkio_t *blkdev = NULL;
	cgroup_blkio_t *blkio = NULL;

	if (mdesc->m_desc.indom == INDOM(CGROUP_PERDEVBLKIO_INDOM)) {
	    indom = INDOM(CGROUP_PERDEVBLKIO_INDOM);
	    if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&blkdev)) < 0)
		return sts;
	    if (sts != PMDA_CACHE_ACTIVE || blkdev == NULL)
		return 0;
	} else {
	    indom = INDOM(CGROUP_BLKIO_INDOM);
	    if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&blkio)) < 0)
		return sts;
	    if (sts != PMDA_CACHE_ACTIVE || blkio == NULL)
		return 0;
	}
	switch (item) {
	case CG_PERDEVBLKIO_IOMERGED_READ: /* cgroup.blkio.dev.io_merged.read */
	    atom->ull = blkdev->stats.io_merged.read;
	    break;
	case CG_PERDEVBLKIO_IOMERGED_WRITE: /* cgroup.blkio.dev.io_merged.write */
	    atom->ull = blkdev->stats.io_merged.write;
	    break;
	case CG_PERDEVBLKIO_IOMERGED_SYNC: /* cgroup.blkio.dev.io_merged.sync */
	    atom->ull = blkdev->stats.io_merged.sync;
	    break;
	case CG_PERDEVBLKIO_IOMERGED_ASYNC: /* cgroup.blkio.dev.io_merged.async */
	    atom->ull = blkdev->stats.io_merged.async;
	    break;
	case CG_PERDEVBLKIO_IOMERGED_TOTAL: /* cgroup.blkio.dev.io_merged.total */
	    atom->ull = blkdev->stats.io_merged.total;
	    break;
	case CG_PERDEVBLKIO_IOQUEUED_READ: /* cgroup.blkio.dev.io_queued.read */
	    atom->ull = blkdev->stats.io_queued.read;
	    break;
	case CG_PERDEVBLKIO_IOQUEUED_WRITE: /* cgroup.blkio.dev.io_queued.write */
	    atom->ull = blkdev->stats.io_queued.write;
	    break;
	case CG_PERDEVBLKIO_IOQUEUED_SYNC: /* cgroup.blkio.dev.io_queued.sync */
	    atom->ull = blkdev->stats.io_queued.sync;
	    break;
	case CG_PERDEVBLKIO_IOQUEUED_ASYNC: /* cgroup.blkio.dev.io_queued.async */
	    atom->ull = blkdev->stats.io_queued.async;
	    break;
	case CG_PERDEVBLKIO_IOQUEUED_TOTAL: /* cgroup.blkio.dev.io_queued.total */
	    atom->ull = blkdev->stats.io_queued.total;
	    break;
	case CG_PERDEVBLKIO_IOSERVICEBYTES_READ: /* cgroup.blkio.dev.io_service_bytes.read */
	    atom->ull = blkdev->stats.io_service_bytes.read;
	    break;
	case CG_PERDEVBLKIO_IOSERVICEBYTES_WRITE: /* cgroup.blkio.dev.io_service_bytes.write */
	    atom->ull = blkdev->stats.io_service_bytes.write;
	    break;
	case CG_PERDEVBLKIO_IOSERVICEBYTES_SYNC: /* cgroup.blkio.dev.io_service_bytes.sync */
	    atom->ull = blkdev->stats.io_service_bytes.sync;
	    break;
	case CG_PERDEVBLKIO_IOSERVICEBYTES_ASYNC: /* cgroup.blkio.dev.io_service_bytes.async */
	    atom->ull = blkdev->stats.io_service_bytes.async;
	    break;
	case CG_PERDEVBLKIO_IOSERVICEBYTES_TOTAL: /* cgroup.blkio.dev.io_service_bytes.total */
	    atom->ull = blkdev->stats.io_service_bytes.total;
	    break;
	case CG_PERDEVBLKIO_IOSERVICED_READ: /* cgroup.blkio.dev.io_serviced.read */
	    atom->ull = blkdev->stats.io_serviced.read;
	    break;
	case CG_PERDEVBLKIO_IOSERVICED_WRITE: /* cgroup.blkio.dev.io_serviced.write */
	    atom->ull = blkdev->stats.io_serviced.write;
	    break;
	case CG_PERDEVBLKIO_IOSERVICED_SYNC: /* cgroup.blkio.dev.io_serviced.sync */
	    atom->ull = blkdev->stats.io_serviced.sync;
	    break;
	case CG_PERDEVBLKIO_IOSERVICED_ASYNC: /* cgroup.blkio.dev.io_serviced.async */
	    atom->ull = blkdev->stats.io_serviced.async;
	    break;
	case CG_PERDEVBLKIO_IOSERVICED_TOTAL: /* cgroup.blkio.dev.io_serviced.total */
	    atom->ull = blkdev->stats.io_serviced.total;
	    break;
	case CG_PERDEVBLKIO_IOSERVICETIME_READ: /* cgroup.blkio.dev.io_service_time.read */
	    atom->ull = blkdev->stats.io_service_time.read;
	    break;
	case CG_PERDEVBLKIO_IOSERVICETIME_WRITE: /* cgroup.blkio.dev.io_service_time.write */
	    atom->ull = blkdev->stats.io_service_time.write;
	    break;
	case CG_PERDEVBLKIO_IOSERVICETIME_SYNC: /* cgroup.blkio.dev.io_service_time.sync */
	    atom->ull = blkdev->stats.io_service_time.sync;
	    break;
	case CG_PERDEVBLKIO_IOSERVICETIME_ASYNC: /* cgroup.blkio.dev.io_service_time.async */
	    atom->ull = blkdev->stats.io_service_time.async;
	    break;
	case CG_PERDEVBLKIO_IOSERVICETIME_TOTAL: /* cgroup.blkio.dev.io_service_time.total */
	    atom->ull = blkdev->stats.io_service_time.total;
	    break;
	case CG_PERDEVBLKIO_IOWAITTIME_READ: /* cgroup.blkio.dev.io_wait_time.read */
	    atom->ull = blkdev->stats.io_wait_time.read;
	    break;
	case CG_PERDEVBLKIO_IOWAITTIME_WRITE: /* cgroup.blkio.dev.io_wait_time.write */
	    atom->ull = blkdev->stats.io_wait_time.write;
	    break;
	case CG_PERDEVBLKIO_IOWAITTIME_SYNC: /* cgroup.blkio.dev.io_wait_time.sync */
	    atom->ull = blkdev->stats.io_wait_time.sync;
	    break;
	case CG_PERDEVBLKIO_IOWAITTIME_ASYNC: /* cgroup.blkio.dev.io_wait_time.async */
	    atom->ull = blkdev->stats.io_wait_time.async;
	    break;
	case CG_PERDEVBLKIO_IOWAITTIME_TOTAL: /* cgroup.blkio.dev.io_wait_time.total */
	    atom->ull = blkdev->stats.io_wait_time.total;
	    break;
	case CG_PERDEVBLKIO_SECTORS: /* cgroup.blkio.dev.sectors */
	    /* sectors are 512 bytes - we export here in kilobytes */
	    atom->ull = blkdev->stats.sectors >> 1;
	    break;
	case CG_PERDEVBLKIO_TIME: /* cgroup.blkio.dev.time */
	    /* unsigned jiffies converted to unsigned milliseconds */
	    atom->ull = (__uint64_t)blkdev->stats.time * 1000 / _pm_hertz;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_READ: /* cgroup.blkio.dev.throttle.io_service_bytes.read */
	    atom->ull = blkdev->stats.throttle_io_service_bytes.read;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_WRITE: /* cgroup.blkio.dev.throttle.io_service_bytes.write */
	    atom->ull = blkdev->stats.throttle_io_service_bytes.write;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_SYNC: /* cgroup.blkio.dev.throttle.io_service_bytes.sync */
	    atom->ull = blkdev->stats.throttle_io_service_bytes.sync;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_ASYNC: /* cgroup.blkio.dev.throttle.io_service_bytes.async */
	    atom->ull = blkdev->stats.throttle_io_service_bytes.async;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICEBYTES_TOTAL: /* cgroup.blkio.dev.throttle.io_service_bytes.total */
	    atom->ull = blkdev->stats.throttle_io_service_bytes.total;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICED_READ: /* cgroup.blkio.dev.throttle.io_serviced.read */
	    atom->ull = blkdev->stats.throttle_io_serviced.read;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICED_WRITE: /* cgroup.blkio.dev.throttle.io_serviced.write */
	    atom->ull = blkdev->stats.throttle_io_serviced.write;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICED_SYNC: /* cgroup.blkio.dev.throttle.io_serviced.sync */
	    atom->ull = blkdev->stats.throttle_io_serviced.sync;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICED_ASYNC: /* cgroup.blkio.dev.throttle.io_serviced.async */
	    atom->ull = blkdev->stats.throttle_io_serviced.async;
	    break;
	case CG_PERDEVBLKIO_THROTTLEIOSERVICED_TOTAL: /* cgroup.blkio.dev.throttle.io_serviced.total */
	    atom->ull = blkdev->stats.throttle_io_serviced.total;
	    break;

	case CG_BLKIO_IOMERGED_READ: /* cgroup.blkio.all.io_merged.read */
	    atom->ull = blkio->total.io_merged.read;
	    break;
	case CG_BLKIO_IOMERGED_WRITE: /* cgroup.blkio.all.io_merged.write */
	    atom->ull = blkio->total.io_merged.write;
	    break;
	case CG_BLKIO_IOMERGED_SYNC: /* cgroup.blkio.all.io_merged.sync */
	    atom->ull = blkio->total.io_merged.sync;
	    break;
	case CG_BLKIO_IOMERGED_ASYNC: /* cgroup.blkio.all.io_merged.async */
	    atom->ull = blkio->total.io_merged.async;
	    break;
	case CG_BLKIO_IOMERGED_TOTAL: /* cgroup.blkio.all.io_merged.total */
	    atom->ull = blkio->total.io_merged.total;
	    break;
	case CG_BLKIO_IOQUEUED_READ: /* cgroup.blkio.all.io_queued.read */
	    atom->ull = blkio->total.io_queued.read;
	    break;
	case CG_BLKIO_IOQUEUED_WRITE: /* cgroup.blkio.all.io_queued.write */
	    atom->ull = blkio->total.io_queued.write;
	    break;
	case CG_BLKIO_IOQUEUED_SYNC: /* cgroup.blkio.all.io_queued.sync */
	    atom->ull = blkio->total.io_queued.sync;
	    break;
	case CG_BLKIO_IOQUEUED_ASYNC: /* cgroup.blkio.all.io_queued.async */
	    atom->ull = blkio->total.io_queued.async;
	    break;
	case CG_BLKIO_IOQUEUED_TOTAL: /* cgroup.blkio.all.io_queued.total */
	    atom->ull = blkio->total.io_queued.total;
	    break;
	case CG_BLKIO_IOSERVICEBYTES_READ: /* cgroup.blkio.all.io_service_bytes.read */
	    atom->ull = blkio->total.io_service_bytes.read;
	    break;
	case CG_BLKIO_IOSERVICEBYTES_WRITE: /* cgroup.blkio.all.io_service_bytes.wrie */
	    atom->ull = blkio->total.io_service_bytes.write;
	    break;
	case CG_BLKIO_IOSERVICEBYTES_SYNC: /* cgroup.blkio.all.io_service_bytes.sync */
	    atom->ull = blkio->total.io_service_bytes.sync;
	    break;
	case CG_BLKIO_IOSERVICEBYTES_ASYNC: /* cgroup.blkio.all.io_service_bytes.async */
	    atom->ull = blkio->total.io_service_bytes.async;
	    break;
	case CG_BLKIO_IOSERVICEBYTES_TOTAL: /* cgroup.blkio.all.io_service_bytes.total */
	    atom->ull = blkio->total.io_service_bytes.total;
	    break;
	case CG_BLKIO_IOSERVICED_READ: /* cgroup.blkio.all.io_serviced.read */
	    atom->ull = blkio->total.io_serviced.read;
	    break;
	case CG_BLKIO_IOSERVICED_WRITE: /* cgroup.blkio.all.io_serviced.write */
	    atom->ull = blkio->total.io_serviced.write;
	    break;
	case CG_BLKIO_IOSERVICED_SYNC: /* cgroup.blkio.all.io_serviced.sync */
	    atom->ull = blkio->total.io_serviced.sync;
	    break;
	case CG_BLKIO_IOSERVICED_ASYNC: /* cgroup.blkio.all.io_serviced.async */
	    atom->ull = blkio->total.io_serviced.async;
	    break;
	case CG_BLKIO_IOSERVICED_TOTAL: /* cgroup.blkio.all.io_serviced.total */
	    atom->ull = blkio->total.io_serviced.total;
	    break;
	case CG_BLKIO_IOSERVICETIME_READ: /* cgroup.blkio.all.io_service_time.read */
	    atom->ull = blkio->total.io_service_time.read;
	    break;
	case CG_BLKIO_IOSERVICETIME_WRITE: /* cgroup.blkio.all.io_service_time.write */
	    atom->ull = blkio->total.io_service_time.write;
	    break;
	case CG_BLKIO_IOSERVICETIME_SYNC: /* cgroup.blkio.all.io_service_time.sync */
	    atom->ull = blkio->total.io_service_time.sync;
	    break;
	case CG_BLKIO_IOSERVICETIME_ASYNC: /* cgroup.blkio.all.io_service_time.async */
	    atom->ull = blkio->total.io_service_time.async;
	    break;
	case CG_BLKIO_IOSERVICETIME_TOTAL: /* cgroup.blkio.all.io_service_time.total */
	    atom->ull = blkio->total.io_service_time.total;
	    break;
	case CG_BLKIO_IOWAITTIME_READ: /* cgroup.blkio.all.io_wait_time.read */
	    atom->ull = blkio->total.io_wait_time.read;
	    break;
	case CG_BLKIO_IOWAITTIME_WRITE: /* cgroup.blkio.all.io_wait_time.write */
	    atom->ull = blkio->total.io_wait_time.write;
	    break;
	case CG_BLKIO_IOWAITTIME_SYNC: /* cgroup.blkio.all.io_wait_time.sync */
	    atom->ull = blkio->total.io_wait_time.sync;
	    break;
	case CG_BLKIO_IOWAITTIME_ASYNC: /* cgroup.blkio.all.io_wait_time.async */
	    atom->ull = blkio->total.io_wait_time.async;
	    break;
	case CG_BLKIO_IOWAITTIME_TOTAL: /* cgroup.blkio.all.io_wait_time.total */
	    atom->ull = blkio->total.io_wait_time.total;
	    break;
	case CG_BLKIO_SECTORS: /* cgroup.blkio.all.sectors */
	    /* sectors are 512 bytes - we export here in kilobytes */
	    atom->ull = blkio->total.sectors >> 1;
	    break;
	case CG_BLKIO_TIME: /* cgroup.blkio.all.time */
	    /* unsigned jiffies converted to unsigned milliseconds */
	    atom->ull = (__uint64_t)blkio->total.time * 1000 / _pm_hertz;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICEBYTES_READ: /* cgroup.blkio.all.throttle.io_service_bytes.read */
	    atom->ull = blkio->total.throttle_io_service_bytes.read;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICEBYTES_WRITE: /* cgroup.blkio.all.throttle.io_service_bytes.wrie */
	    atom->ull = blkio->total.throttle_io_service_bytes.write;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICEBYTES_SYNC: /* cgroup.blkio.all.throttle.io_service_bytes.sync */
	    atom->ull = blkio->total.throttle_io_service_bytes.sync;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICEBYTES_ASYNC: /* cgroup.blkio.all.throttle.io_service_bytes.async */
	    atom->ull = blkio->total.throttle_io_service_bytes.async;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICEBYTES_TOTAL: /* cgroup.blkio.all.throttle.io_service_bytes.total */
	    atom->ull = blkio->total.throttle_io_service_bytes.total;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICED_READ: /* cgroup.blkio.all.throttle.io_serviced.read */
	    atom->ull = blkio->total.throttle_io_serviced.read;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICED_WRITE: /* cgroup.blkio.all.throttle.io_serviced.write */
	    atom->ull = blkio->total.throttle_io_serviced.write;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICED_SYNC: /* cgroup.blkio.all.throttle.io_serviced.sync */
	    atom->ull = blkio->total.throttle_io_serviced.sync;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICED_ASYNC: /* cgroup.blkio.all.throttle.io_serviced.async */
	    atom->ull = blkio->total.throttle_io_serviced.async;
	    break;
	case CG_BLKIO_THROTTLEIOSERVICED_TOTAL: /* cgroup.blkio.all.throttle.io_serviced.total */
	    atom->ull = blkio->total.throttle_io_serviced.total;
	    break;
	case CG_BLKIO_ID_CONTAINER: /* cgroup.blkio.id.container */
	    atom->cp = proc_strings_lookup(blkio->container);
	    break;

	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_CGROUP2_CPU_STAT:
	indom = INDOM(CGROUP2_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cgroup)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	   return 0;
	switch (item) {
	case CG_CPU_STAT_USER: /* cgroup.cpu.stat.user */
	    if (cgroup->cputime.user == (__uint64_t)-1) return 0;
	    atom->ull = cgroup->cputime.user;
	    break;
	case CG_CPU_STAT_SYSTEM: /* cgroup.cpu.stat.system */
	    if (cgroup->cputime.system == (__uint64_t)-1) return 0;
	    atom->ull = cgroup->cputime.system;
	    break;
	case CG_CPU_STAT_USAGE: /* cgroup.cpu.stat.usage */
	    if (cgroup->cputime.usage == (__uint64_t)-1) return 0;
	    atom->ull = cgroup->cputime.usage;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_CGROUP2_CPU_PRESSURE:
	indom = INDOM(CGROUP2_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cgroup)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	    return 0;
	switch (item) {
	case CG_PRESSURE_CPU_SOME_AVG10SEC:
	    if (cgroup->cpu_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->cpu_pressures.some.avg10sec;
	    break;
	case CG_PRESSURE_CPU_SOME_AVG1MIN:
	    if (cgroup->cpu_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->cpu_pressures.some.avg1min;
	    break;
	case CG_PRESSURE_CPU_SOME_AVG5MIN:
	    if (cgroup->cpu_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->cpu_pressures.some.avg5min;
	    break;
	case CG_PRESSURE_CPU_SOME_TOTAL:
	    if (cgroup->cpu_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->cpu_pressures.some.total;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;


    case CLUSTER_CGROUP2_MEM_PRESSURE:
	indom = INDOM(CGROUP2_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cgroup)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	    return 0;
	switch (item) {
	case CG_PRESSURE_MEM_SOME_AVG10SEC:
	    if (cgroup->mem_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.some.avg10sec;
	    break;
	case CG_PRESSURE_MEM_SOME_AVG1MIN:
	    if (cgroup->mem_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.some.avg1min;
	    break;
	case CG_PRESSURE_MEM_SOME_AVG5MIN:
	    if (cgroup->mem_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.some.avg5min;
	    break;
	case CG_PRESSURE_MEM_SOME_TOTAL:
	    if (cgroup->mem_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.some.total;
	    break;
	case CG_PRESSURE_MEM_FULL_AVG10SEC:
	    if (cgroup->mem_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.full.avg10sec;
	    break;
	case CG_PRESSURE_MEM_FULL_AVG1MIN:
	    if (cgroup->mem_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.full.avg1min;
	    break;
	case CG_PRESSURE_MEM_FULL_AVG5MIN:
	    if (cgroup->mem_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.full.avg5min;
	    break;
	case CG_PRESSURE_MEM_FULL_TOTAL:
	    if (cgroup->mem_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->mem_pressures.full.total;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_CGROUP2_IO_PRESSURE:
	indom = INDOM(CGROUP2_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cgroup)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	    return 0;
	switch (item) {
	case CG_PRESSURE_IO_SOME_AVG10SEC:
	    if (cgroup->io_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.some.avg10sec;
	    break;
	case CG_PRESSURE_IO_SOME_AVG1MIN:
	    if (cgroup->io_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.some.avg1min;
	    break;
	case CG_PRESSURE_IO_SOME_AVG5MIN:
	    if (cgroup->io_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.some.avg5min;
	    break;
	case CG_PRESSURE_IO_SOME_TOTAL:
	    if (cgroup->io_pressures.some.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.some.total;
	    break;
	case CG_PRESSURE_IO_FULL_AVG10SEC:
	    if (cgroup->io_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.full.avg10sec;
	    break;
	case CG_PRESSURE_IO_FULL_AVG1MIN:
	    if (cgroup->io_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.full.avg1min;
	    break;
	case CG_PRESSURE_IO_FULL_AVG5MIN:
	    if (cgroup->io_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.full.avg5min;
	    break;
	case CG_PRESSURE_IO_FULL_TOTAL:
	    if (cgroup->io_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->io_pressures.full.total;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_CGROUP2_IRQ_PRESSURE:
	indom = INDOM(CGROUP2_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&cgroup)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	    return 0;
	switch (item) {
	case CG_PRESSURE_IRQ_FULL_AVG10SEC:
	    if (cgroup->irq_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->irq_pressures.full.avg10sec;
	    break;
	case CG_PRESSURE_IRQ_FULL_AVG1MIN:
	    if (cgroup->irq_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->irq_pressures.full.avg1min;
	    break;
	case CG_PRESSURE_IRQ_FULL_AVG5MIN:
	    if (cgroup->irq_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->irq_pressures.full.avg5min;
	    break;
	case CG_PRESSURE_IRQ_FULL_TOTAL:
	    if (cgroup->irq_pressures.full.updated == 0) return 0;
	    atom->ull = cgroup->irq_pressures.full.total;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_CGROUP2_IO_STAT: {
	cgroup_perdev_iostat_t *iostat;

	indom = INDOM(CGROUP2_PERDEV_INDOM);
	if ((sts = pmdaCacheLookup(indom, inst, NULL, (void **)&iostat)) < 0)
	    return sts;
	if (sts != PMDA_CACHE_ACTIVE)
	   return 0;
	switch (item) {
	case CG_IO_STAT_RBYTES: /* cgroup.io.stat.rbytes */
	    if (iostat->stats.rbytes == (__uint64_t)-1) return 0;
	    atom->ull = iostat->stats.rbytes;
	    break;
	case CG_IO_STAT_WBYTES: /* cgroup.io.stat.wbytes */
	    if (iostat->stats.wbytes == (__uint64_t)-1) return 0;
	    atom->ull = iostat->stats.wbytes;
	    break;
	case CG_IO_STAT_RIOS: /* cgroup.io.stat.rios */
	    if (iostat->stats.rios == (__uint64_t)-1) return 0;
	    atom->ull = iostat->stats.rios;
	    break;
	case CG_IO_STAT_WIOS: /* cgroup.io.stat.wios */
	    if (iostat->stats.wios == (__uint64_t)-1) return 0;
	    atom->ull = iostat->stats.wios;
	    break;
	case CG_IO_STAT_DBYTES: /* cgroup.io.stat.dbytes */
	    if (iostat->stats.dbytes == (__uint64_t)-1) return 0;
	    atom->ull = iostat->stats.dbytes;
	    break;
	case CG_IO_STAT_DIOS: /* cgroup.io.stat.dios */
	    if (iostat->stats.dios == (__uint64_t)-1) return 0;
	    atom->ull = iostat->stats.dios;
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;
    }

    case CLUSTER_HOTPROC_PID_FD:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_FD:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_fd(inst, active_proc_pid, &sts)) == NULL) /* proc.fd.count */
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_FD))
	    return 0;
	if (item == 0) /* proc.fd.count */
	    atom->ul = entry->fd_count;
	else
	    return PM_ERR_PMID;
	break;

    case CLUSTER_HOTPROC_PID_CGROUP:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_CGROUP:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_cgroup(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_CGROUP))
	    return 0;
	switch (item) {
	case 0: /* proc.psinfo.cgroups */
	    atom->cp = proc_strings_lookup(entry->cgroup_id);
	    break;
	case 1: /* proc.id.container */
	    atom->cp = proc_strings_lookup(entry->container_id);
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    case CLUSTER_HOTPROC_PID_LABEL:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_LABEL:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_label(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_LABEL))
	    return 0;
	if (item == 0) /* proc.psinfo.labels */
	    atom->cp = proc_strings_lookup(entry->label_id);
	else
	    return PM_ERR_PMID;
	break;

    case CLUSTER_HOTPROC_PID_OOM_SCORE:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_OOM_SCORE:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_oom_score(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_OOM_SCORE))
	    return 0;
	if (item == 0) /* proc.psinfo.oom_score */
	    atom->ul = entry->oom_score;
	else
	    return PM_ERR_PMID;
	break;

    case CLUSTER_HOTPROC_PID_CWD:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_CWD:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_cwd(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_CWD))
	    return 0;
	if (item == 0) /* proc.psinfo.cwd */
	    atom->cp = proc_strings_lookup(entry->cwd_id);
	else
	    return PM_ERR_PMID;
	break;

    case CLUSTER_HOTPROC_PID_EXE:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_EXE:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if ((entry = fetch_proc_pid_exe(inst, active_proc_pid, &sts)) == NULL)
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_EXE))
	    return 0;
	if (item == 0) /* proc.psinfo.exe */
	    atom->cp = proc_strings_lookup(entry->exe_id);
	else
	    return PM_ERR_PMID;
	break;

    case CLUSTER_ACCT:
	return acct_fetchCallBack(inst, item, &proc_acct, atom);

    case CLUSTER_HOTPROC_PID_AUTOGROUP:
	active_proc_pid = &hotproc_pid;
	/*FALLTHROUGH*/
    case CLUSTER_PID_AUTOGROUP:
	if (!have_access)
	    return PM_ERR_PERMISSION;
	if (autogroup == -1)
	    refresh_sched_autogroup();
	if (item == 0) { /* proc.autogroup.enabled */
	    atom->ul = (autogroup == 1);
	    break;
	}
	if (autogroup != 1)	/* sched_autogroup_enabled is zero */
	    return 0;
	if (!(entry = fetch_proc_pid_autogroup(inst, active_proc_pid, &sts)))
	    return sts;
	if (!(entry->success & PROC_PID_FLAG_AUTOGROUP))
	    return 0;
	if (item == 1) /* proc.autogroup.id */
	    atom->ul = entry->autogroup_id;
	else if (item == 2) /* proc.autogroup.nice */
	    atom->l = entry->autogroup_nice;
	else
	    return PM_ERR_PMID;
	break;

    case CLUSTER_CONTROL:
	switch (item) {
	/* case 1: not reached -- proc.control.all.threads is direct */
	case 2:	/* proc.control.perclient.threads */
	    atom->ul = proc_ctx_threads(pmdaGetContext(), threads);
	    break;
	case 3:	/* proc.control.perclient.cgroups */
	    cp = proc_ctx_cgroups(pmdaGetContext(), cgroups);
	    atom->cp = (char *)(cp ? cp : "");
	    break;
	default:
	    return PM_ERR_PMID;
	}
	break;

    default: /* unknown cluster */
	return PM_ERR_PMID;
    }

    return PMDA_FETCH_STATIC;
}

static int
proc_fetch(int numpmid, pmID pmidlist[], pmResult **resp, pmdaExt *pmda)
{
    int			i, sts, need_refresh[MAX_CLUSTER] = { 0 };

    for (i = 0; i < numpmid; i++) {
	unsigned int	cluster = pmID_cluster(pmidlist[i]);
	if (cluster >= MIN_CLUSTER && cluster < MAX_CLUSTER)
	    need_refresh[cluster]++;
    }
    autogroup = -1;	/* reset, state not known for this fetch */

    have_access = all_access || proc_ctx_access(pmda->e_context);
    if (pmDebugOptions.auth)
	fprintf(stderr, "%s: start access have=%d all=%d proc_ctx_access=%d\n",
		"proc_fetch", have_access, all_access,
		proc_ctx_access(pmda->e_context));

    if ((sts = proc_refresh(pmda, need_refresh)) == 0)
	sts = pmdaFetch(numpmid, pmidlist, resp, pmda);

    have_access = all_access || proc_ctx_revert(pmda->e_context);
    if (pmDebugOptions.auth)
	fprintf(stderr, "%s: final access have=%d all=%d proc_ctx_revert=%d\n",
		"proc_fetch", have_access, all_access,
		proc_ctx_revert(pmda->e_context));

    return sts;
}

static int
proc_store(pmResult *result, pmdaExt *pmda)
{
    int			i, sts = 0, isroot;

    have_access = all_access || proc_ctx_access(pmda->e_context);
    isroot = (proc_ctx_getuid(pmda->e_context) == 0);

    for (i = 0; i < result->numpmid; i++) {
	pmValueSet *vsp = result->vset[i];
	pmAtomValue av;

	switch (pmID_cluster(vsp->pmid)) {
	case CLUSTER_CONTROL:
	    if (vsp->numval != 1)
		sts = PM_ERR_INST;
	    else switch (pmID_item(vsp->pmid)) {
	    case 1: /* proc.control.all.threads */
		if (!have_access)
		    sts = PM_ERR_PERMISSION;
		else if ((sts = pmExtractValue(vsp->valfmt, &vsp->vlist[0],
				PM_TYPE_U32, &av, PM_TYPE_U32)) >= 0) {
		    if (av.ul > 1)	/* only zero or one allowed */
			sts = PM_ERR_BADSTORE;
		    else
			threads = av.ul;
		}
		break;
	    case 2: /* proc.control.perclient.threads */
		if ((sts = pmExtractValue(vsp->valfmt, &vsp->vlist[0],
				PM_TYPE_U32, &av, PM_TYPE_U32)) >= 0) {
		    sts = proc_ctx_set_threads(pmda->e_context, av.ul);
		}
		break;
	    case 3:	/* proc.control.perclient.cgroups */
		if ((sts = pmExtractValue(vsp->valfmt, &vsp->vlist[0],
				PM_TYPE_STRING, &av, PM_TYPE_STRING)) >= 0) {
		    if ((sts = proc_ctx_set_cgroups(pmda->e_context, av.cp)) < 0)
			free(av.cp);
		}
		break;
	    default:
		sts = PM_ERR_PERMISSION;
		break;
	    }
	    break;

	case CLUSTER_HOTPROC_GLOBAL:
	    if (!isroot)
		sts = PM_ERR_PERMISSION;
	    else switch (pmID_item(vsp->pmid)) {
	    case 1: /* hotproc.control.refresh */
		if ((sts = pmExtractValue(vsp->valfmt, &vsp->vlist[0],
				PM_TYPE_U32, &av, PM_TYPE_U32)) >= 0) {
		    hotproc_update_interval.tv_sec = av.ul;
		    reset_hotproc_timer();
		}
		break;
	    case 8: { /* hotproc.control.config */
		bool_node *tree = NULL;
		char *savebuffer;
                int lsts;

		if ((sts = pmExtractValue(vsp->valfmt, &vsp->vlist[0],
				PM_TYPE_STRING, &av, PM_TYPE_STRING)) >= 0) {
		    savebuffer = get_conf_buffer() ? strdup(get_conf_buffer()) : NULL;
		    set_conf_buffer(av.cp);
                    lsts = parse_config(&tree);
		    if (lsts < 0) {
                        /* Bad config */
			if (savebuffer)
			    set_conf_buffer(savebuffer);
                        sts = PM_ERR_BADSTORE;
		    }
                    else if (lsts == 0) {
                        /* Empty Config */
                        disable_hotproc();
                    }
		    else {
			conf_gen++;
			new_tree(tree);
			if (conf_gen == 1) {
			    /* There was no config to start with.
			     * This is the first one, so enable the timer.
			     */
			    reset_hotproc_timer();
			}
		    }
		    if (savebuffer)
			free(savebuffer);
		    free(av.cp);
		}
		break;
	    }
            case 10: /* hotproc.control.reload_config */
		if ((sts = pmExtractValue(vsp->valfmt, &vsp->vlist[0],
				PM_TYPE_U32, &av, PM_TYPE_U32)) >= 0) {
                    hotproc_init();
		    reset_hotproc_timer();
		}
		break;

	    default:
		sts = PM_ERR_PERMISSION;
		break;
	    }
	    break;

	case CLUSTER_ACCT:
	    if (!isroot)
		sts = PM_ERR_PERMISSION;
	    else
		sts = acct_store(result, pmda, vsp);
	    break;

	default:
	    sts = PM_ERR_PERMISSION;
	    break;
	}
	if (sts < 0)
	    break;
    }

    have_access = all_access || proc_ctx_revert(pmda->e_context);
    return sts;
}

static int
proc_text(int ident, int type, char **buf, pmdaExt *pmda)
{
    if ((type & PM_TEXT_PMID) == PM_TEXT_PMID) {
	int sts = pmdaDynamicLookupText(ident, type, buf, pmda);
	if (sts != -ENOENT)
	    return sts;
    }
    return pmdaText(ident, type, buf, pmda);
}

static int
proc_pmid(const char *name, pmID *pmid, pmdaExt *pmda)
{
    pmdaNameSpace	*tree = pmdaDynamicLookupName(pmda, name);

    if (tree == NULL)
	return PM_ERR_NAME;
    if (pmDebugOptions.appl2) {
	fprintf(stderr, "proc_pmid: name=%s tree:\n", name);
	__pmDumpNameNode(stderr, tree->root, 1);
    }
    return pmdaTreePMID(tree, name, pmid);
}

static int
proc_name(pmID pmid, char ***nameset, pmdaExt *pmda)
{
    pmdaNameSpace	*tree = pmdaDynamicLookupPMID(pmda, pmid);

    if (tree == NULL)
	return PM_ERR_PMID;
    if (pmDebugOptions.appl2) {
	fprintf(stderr, "proc_name: pmid=%s tree:\n", pmIDStr(pmid));
	__pmDumpNameNode(stderr, tree->root, 1);
    }
    return pmdaTreeName(tree, pmid, nameset);
}

static int
proc_children(const char *name, int flag, char ***kids, int **sts, pmdaExt *pmda)
{
    pmdaNameSpace	*tree = pmdaDynamicLookupName(pmda, name);

    if (tree == NULL)
	return PM_ERR_NAME;
    if (pmDebugOptions.appl2) {
	fprintf(stderr, "proc_children: name=%s flag=%d tree:\n", name, flag);
	__pmDumpNameNode(stderr, tree->root, 1);
    }
    return pmdaTreeChildren(tree, name, flag, kids, sts);
}

static int
proc_labelCallBack(pmInDom indom, unsigned int inst, pmLabelSet **lp)
{
    char		*name, *device;
    int			sts;

    switch (pmInDom_serial(indom)) {
    case PROC_INDOM:
    case HOTPROC_INDOM:
	return pmdaAddLabels(lp, "{\"pid\":%u}", inst);

    case CGROUP_PERDEVBLKIO_INDOM:
    case CGROUP2_PERDEV_INDOM:
	sts = pmdaCacheLookup(indom, inst, &name, NULL);
	if (sts < 0 || sts == PMDA_CACHE_INACTIVE)
	    return 0;
	device = strrchr(name, ':');
	return pmdaAddLabels(lp, "{\"cgroup\":\"%.*s\",\"device_name\":\"%s\"}",
				(int)(device - name) - 1, name, device + 1);

    case CGROUP_PERCPUACCT_INDOM:
	sts = pmdaCacheLookup(indom, inst, &name, NULL);
	if (sts < 0 || sts == PMDA_CACHE_INACTIVE)
	    return 0;
	device = strrchr(name, ':');
	return pmdaAddLabels(lp, "{\"cgroup\":\"%.*s\",\"cpu\":\"%s\"}",
				(int)(device - name) - 1, name, device + 4);

    case CGROUP_CPUSET_INDOM:
    case CGROUP_CPUACCT_INDOM:
    case CGROUP_CPUSCHED_INDOM:
    case CGROUP_MEMORY_INDOM:
    case CGROUP_NETCLS_INDOM:
    case CGROUP_BLKIO_INDOM:
    case CGROUP2_INDOM:
	sts = pmdaCacheLookup(indom, inst, &name, NULL);
	if (sts < 0 || sts == PMDA_CACHE_INACTIVE)
	    return 0;
	return pmdaAddLabels(lp, "{\"cgroup\":\"%s\"}", name);

    default:
	break;
    }
    return 0;
}

static int
proc_label_indom(pmInDom indom, pmLabelSet **lp, pmdaExt *pmda)
{
    switch (pmInDom_serial(indom)) {
    case CGROUP_CPUSET_INDOM:
    case CGROUP_CPUACCT_INDOM:
    case CGROUP_CPUSCHED_INDOM:
    case CGROUP_PERCPUACCT_INDOM:
	return pmdaAddLabels(lp, "{\"device_type\":\"cpu\"}");
    case CGROUP_MEMORY_INDOM:
	return pmdaAddLabels(lp, "{\"device_type\":\"memory\"}");
    case CGROUP_NETCLS_INDOM:
	return pmdaAddLabels(lp, "{\"device_type\":\"interface\"}");
    case CGROUP_BLKIO_INDOM:
    case CGROUP2_PERDEV_INDOM:
    case CGROUP_PERDEVBLKIO_INDOM:
	return pmdaAddLabels(lp, "{\"device_type\":\"block\"}");
    default:
	break;
    }
    return 0;
}

static int
proc_label(int ident, int type, pmLabelSet **lp, pmdaExt *pmda)
{
    int			sts;

    if ((type & PM_LABEL_INDOM) &&
	(sts = proc_label_indom(ident, lp, pmda)) < 0)
	return sts;

    return pmdaLabel(ident, type, lp, pmda);
}

/*
 * Helper routines for accessing a generic static string dictionary,
 * a uid -> username dictionary, and a gid -> groupname dictionary.
 */

char *
proc_strings_lookup(int index)
{
    char		*value;

    if (pmdaCacheLookup(INDOM(STRINGS_INDOM), index,
			&value, NULL) == PMDA_CACHE_ACTIVE)
	return value;
    return "";
}

int
proc_strings_insert(const char *buf)
{
    return pmdaCacheStore(INDOM(STRINGS_INDOM), PMDA_CACHE_ADD, buf, NULL);
}

char *
proc_uidname_lookup(int uid)
{
    struct passwd	*pwe;
    pmInDom		indom = INDOM(UIDNAME_INDOM);
    char		*name;

    if (pmdaCacheLookupKey(indom, NULL, sizeof(uid), &uid,
			   &name, NULL, NULL) == PMDA_CACHE_ACTIVE)
	return name;
    if ((pwe = getpwuid(uid)) != NULL)
	name = pwe->pw_name;
    else
	name = "";
    pmdaCacheStoreKey(indom, PMDA_CACHE_ADD, name, sizeof(uid), &uid, NULL);
    if (pmdaCacheLookupKey(indom, NULL, sizeof(uid), &uid,
			   &name, NULL, NULL) == PMDA_CACHE_ACTIVE)
	return name;
    return "";
}

char *
proc_gidname_lookup(int gid)
{
    struct group	*gre;
    pmInDom		indom = INDOM(GIDNAME_INDOM);
    char		*name;

    if (pmdaCacheLookupKey(indom, NULL, sizeof(gid), &gid,
			   &name, NULL, NULL) == PMDA_CACHE_ACTIVE)
	return name;
    if ((gre = getgrgid(gid)) != NULL)
	name = gre->gr_name;
    else
	name = "";
    pmdaCacheStoreKey(indom, PMDA_CACHE_ADD, name, sizeof(gid), &gid, NULL);
    if (pmdaCacheLookupKey(indom, NULL, sizeof(gid), &gid,
			   &name, NULL, NULL) == PMDA_CACHE_ACTIVE)
	return name;
    return "";
}

/*
 * Initialise the agent (both daemon and DSO).
 */

void 
__PMDA_INIT_CALL
proc_init(pmdaInterface *dp)
{
    int		nindoms = sizeof(indomtab)/sizeof(indomtab[0]);
    int		nmetrics = sizeof(metrictab)/sizeof(metrictab[0]);
    char	*envpath;

    /* optional overrides of some globals for testing */
    if ((envpath = getenv("PROC_HERTZ")) != NULL)
	_pm_hertz = atoi(envpath);
    else
	_pm_hertz = sysconf(_SC_CLK_TCK);
    if ((envpath = getenv("PROC_PAGESIZE")) != NULL)
	_pm_system_pagesize = atoi(envpath);
    else
	_pm_system_pagesize = getpagesize();
    if ((envpath = getenv("PROC_STATSPATH")) != NULL)
	proc_statspath = envpath;
    if ((envpath = getenv("PROC_THREADS")) != NULL)
	threads = atoi(envpath);
    if ((envpath = getenv("PROC_ACCESS")) != NULL)
	all_access = atoi(envpath);

    if (_isDSO) {
	char helppath[MAXPATHLEN];
	int sep = pmPathSeparator();
	pmsprintf(helppath, sizeof(helppath), "%s%c" "proc" "%c" "help",
		pmGetConfig("PCP_PMDAS_DIR"), sep, sep);
	pmdaDSO(dp, PMDA_INTERFACE_7, "proc DSO", helppath);
    }

    if (dp->status != 0)
	return;
    pmdaSetCommFlags(dp, PMDA_FLAG_AUTHORIZE | PMDA_FLAG_CONTAINER);

    dp->version.seven.instance = proc_instance;
    dp->version.seven.store = proc_store;
    dp->version.seven.fetch = proc_fetch;
    dp->version.seven.text = proc_text;
    dp->version.seven.pmid = proc_pmid;
    dp->version.seven.name = proc_name;
    dp->version.seven.children = proc_children;
    dp->version.seven.attribute = proc_ctx_attrs;
    dp->version.seven.label = proc_label;
    pmdaSetLabelCallBack(dp, proc_labelCallBack);
    pmdaSetEndContextCallBack(dp, proc_ctx_end);
    pmdaSetFetchCallBack(dp, proc_fetchCallBack);

    /*
     * Initialize the instance domain table.
     */
    indomtab[STRINGS_INDOM].it_indom = STRINGS_INDOM;
    indomtab[UIDNAME_INDOM].it_indom = UIDNAME_INDOM;
    indomtab[GIDNAME_INDOM].it_indom = GIDNAME_INDOM;
    indomtab[DEVT_INDOM].it_indom = DEVT_INDOM;
    indomtab[DISK_INDOM].it_indom = DISK_INDOM;
    indomtab[PROC_INDOM].it_indom = PROC_INDOM;
    indomtab[CGROUP_CPUSET_INDOM].it_indom = CGROUP_CPUSET_INDOM;
    indomtab[CGROUP_CPUACCT_INDOM].it_indom = CGROUP_CPUACCT_INDOM;
    indomtab[CGROUP_CPUSCHED_INDOM].it_indom = CGROUP_CPUSCHED_INDOM;
    indomtab[CGROUP_PERCPUACCT_INDOM].it_indom = CGROUP_PERCPUACCT_INDOM;
    indomtab[CGROUP_MEMORY_INDOM].it_indom = CGROUP_MEMORY_INDOM;
    indomtab[CGROUP_NETCLS_INDOM].it_indom = CGROUP_NETCLS_INDOM;
    indomtab[CGROUP_BLKIO_INDOM].it_indom = CGROUP_BLKIO_INDOM;
    indomtab[CGROUP_PERDEVBLKIO_INDOM].it_indom = CGROUP_PERDEVBLKIO_INDOM;
    indomtab[CGROUP_SUBSYS_INDOM].it_indom = CGROUP_SUBSYS_INDOM;
    indomtab[CGROUP_MOUNTS_INDOM].it_indom = CGROUP_MOUNTS_INDOM;
    indomtab[CGROUP2_INDOM].it_indom = CGROUP2_INDOM;
    indomtab[CGROUP2_PERDEV_INDOM].it_indom = CGROUP2_PERDEV_INDOM;

    proc_pid.indom = &indomtab[PROC_INDOM];

    indomtab[HOTPROC_INDOM].it_indom = HOTPROC_INDOM;
    hotproc_pid.indom = &indomtab[HOTPROC_INDOM];

    hotproc_init();
    init_hotproc_pid(&hotproc_pid);

    proc_ctx_init();
    proc_dynamic_init(metrictab, nmetrics);

    indomtab[ACCT_INDOM].it_indom = ACCT_INDOM;
    proc_acct.indom = &indomtab[ACCT_INDOM];
    acct_init(&proc_acct);

    tty_driver_init();

    rootfd = pmdaRootConnect(NULL);
    pmdaSetFlags(dp, PMDA_EXT_FLAG_HASHED);
    pmdaInit(dp, indomtab, nindoms, metrictab, nmetrics);

    /* string metrics use the pmdaCache API for value indexing */
    pmdaCacheOp(INDOM(STRINGS_INDOM), PMDA_CACHE_STRINGS);
    pmdaCacheOp(INDOM(UIDNAME_INDOM), PMDA_CACHE_STRINGS);
    pmdaCacheOp(INDOM(GIDNAME_INDOM), PMDA_CACHE_STRINGS);

    /* cgroup metrics use the pmdaCache API for indom indexing */
    pmdaCacheOp(INDOM(CGROUP_CPUSET_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_CPUACCT_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_CPUSCHED_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_PERCPUACCT_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_MEMORY_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_NETCLS_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_BLKIO_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_PERDEVBLKIO_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_SUBSYS_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP_MOUNTS_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP2_INDOM), PMDA_CACHE_CULL);
    pmdaCacheOp(INDOM(CGROUP2_PERDEV_INDOM), PMDA_CACHE_CULL);
}

pmLongOptions	longopts[] = {
    PMDA_OPTIONS_HEADER("Options"),
    PMOPT_DEBUG,
    { "no-access-checks", 0, 'A', 0, "no access checks will be performed (insecure, beware!)" },
    PMDAOPT_DOMAIN,
    PMDAOPT_LOGFILE,
    { "with-threads", 0, 'L', 0, "include threads in the all-processes instance domain" },
    { "from-cgroup", 1, 'r', "NAME", "restrict monitoring to processes in the named cgroup" },
    PMDAOPT_USERNAME,
    PMOPT_HELP,
    PMDA_OPTIONS_END
};

pmdaOptions	opts = {
    .short_options = "AD:d:l:Lr:U:?",
    .long_options = longopts,
};

int
main(int argc, char **argv)
{
    int			c, sep = pmPathSeparator();
    pmdaInterface	dispatch;
    char		helppath[MAXPATHLEN];
    char		*username = "root";

    _isDSO = 0;
    pmSetProgname(argv[0]);
    pmsprintf(helppath, sizeof(helppath), "%s%c" "proc" "%c" "help",
		pmGetConfig("PCP_PMDAS_DIR"), sep, sep);
    pmdaDaemon(&dispatch, PMDA_INTERFACE_7, pmGetProgname(), PROC, "proc.log", helppath);

    while ((c = pmdaGetOptions(argc, argv, &opts, &dispatch)) != EOF) {
	switch (c) {
	case 'A':
	    all_access = 1;
	    break;
	case 'L':
	    threads = 1;
	    break;
	case 'r':
	    cgroups = opts.optarg;
	    break;
	}
    }

    if (opts.errors) {
	pmdaUsageMessage(&opts);
	exit(1);
    }
    if (opts.username)
	username = opts.username;

    pmdaOpenLog(&dispatch);
    pmSetProcessIdentity(username);

    proc_init(&dispatch);
    pmdaConnect(&dispatch);
    pmdaMain(&dispatch);
    exit(0);
}
