/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.IOException;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.bzip2.BZip2Compressor;

public class BZip2Archiver
extends AbstractArchiver {
    private BZip2Compressor compressor = new BZip2Compressor();

    public void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        if (this.getFiles().size() > 1) {
            throw new ArchiverException("There is more than one file in input.");
        }
        ArchiveEntry entry = (ArchiveEntry)this.getFiles().values().toArray()[0];
        this.compressor.setSourceFile(entry.getFile());
        this.compressor.setDestFile(this.getDestFile());
        this.compressor.compress();
    }

    public boolean isSupportingForced() {
        return true;
    }

    protected void cleanUp() {
    }

    protected void close() {
        this.compressor.close();
    }

    protected String getArchiveType() {
        return "bzip2";
    }
}

