#!/bin/sh
# Run this to generate all the initial makefiles, etc.
# Parts of this script taken from the Cairo source tree

LIBTOOLIZE=${LIBTOOLIZE-libtoolize}
LIBTOOLIZE_FLAGS="--copy --force"
AUTOHEADER=${AUTOHEADER-autoheader}
AUTOMAKE_FLAGS="--add-missing --gnu"
AUTOCONF=${AUTOCONF-autoconf}

# Some stuff requires automake >= 1.7
automake_min_vers=1.7
aclocal_min_vers=$automake_min_vers
autoconf_min_vers=2.54

LC_ALL=C

PACKAGE="pureadmin"
srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.


DIE=0

# if [ -n "$GNOME2_DIR" ]; then
# 	ACLOCAL_FLAGS="-I $GNOME2_DIR/share/aclocal $ACLOCAL_FLAGS"
# 	LD_LIBRARY_PATH="$GNOME2_DIR/lib:$LD_LIBRARY_PATH"
# 	PATH="$GNOME2_DIR/bin:$PATH"
# 	export PATH
# 	export LD_LIBRARY_PATH
# fi

(test -f $srcdir/configure.in) || {
    echo -n "**Error**: Directory "\`$srcdir\'" does not look like the"
    echo " top-level package directory"
    exit 1
}

# Check for required autoconf version
if ($AUTOCONF --version) < /dev/null > /dev/null 2>&1 ; then
    if ($AUTOCONF --version | head -n 1 | awk 'NR==1 { if( $(NF) >= '$autoconf_min_vers') \
			       exit 1; exit 0; }');
    then
       echo "$ARGV0: ERROR: \`$AUTOCONF' is too old."
       $AUTOCONF --version
       echo "           (version $autoconf_min_vers or newer is required)"
       DIE="yes"
    fi
else
    echo
    echo "**Error**: You must have \`autoconf' installed."
    echo "Download the appropriate package for your distribution,"
    echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
    DIE=1
fi

(grep "^AC_PROG_INTLTOOL" $srcdir/configure.in >/dev/null) && {
  (intltoolize --version) < /dev/null > /dev/null 2>&1 || {
    echo 
    echo "**Error**: You must have \`intltool' installed."
    echo "You can get it from:"
    echo "  ftp://ftp.gnome.org/pub/GNOME/"
    DIE=1
  }
}

(grep "^AM_PROG_XML_I18N_TOOLS" $srcdir/configure.in >/dev/null) && {
  (xml-i18n-toolize --version) < /dev/null > /dev/null 2>&1 || {
    echo
    echo "**Error**: You must have \`xml-i18n-toolize' installed."
    echo "You can get it from:"
    echo "  ftp://ftp.gnome.org/pub/GNOME/"
    DIE=1
  }
}

(grep "^AM_PROG_LIBTOOL" $srcdir/configure.in >/dev/null) && {
  (libtool --version) < /dev/null > /dev/null 2>&1 || {
    echo
    echo "**Error**: You must have \`libtool' installed."
    echo "You can get it from: ftp://ftp.gnu.org/pub/gnu/"
    DIE=1
  }
}

(grep "^AM_GLIB_GNU_GETTEXT" $srcdir/configure.in >/dev/null) && {
  (grep "sed.*POTFILES" $srcdir/configure.in) > /dev/null || \
  (glib-gettextize --version) < /dev/null > /dev/null 2>&1 || {
    echo
    echo "**Error**: You must have \`glib' installed."
    echo "You can get it from: ftp://ftp.gtk.org/pub/gtk"
    DIE=1
  }
}


#
# Hunt for an appropriate version of automake and aclocal; we can't
# assume that 'automake' is necessarily the most recent installed version
# 
# We check automake first to allow it to be a newer version than we know about.
#
if test x"$AUTOMAKE" = x || test x"$ACLOCAL" = x ; then
  am_ver=""
  for ver in "" "-1.9" "-1.8" "-1.7" ; do
    am="automake$ver"
    if ($am --version) < /dev/null > /dev/null 2>&1 ; then
      if ($am --version | head -n 1 | awk 'NR==1 { if( $(NF) >= '$automake_min_vers') \
	  		 exit 1; exit 0; }'); then : ; else
         am_ver=$ver
         break;
      fi
    fi
  done
  
  AUTOMAKE=${AUTOMAKE-automake$am_ver}
  ACLOCAL=${ACLOCAL-aclocal$am_ver}
fi

#
# Now repeat the tests with the copies we decided upon and error out if they
# aren't sufficiently new.
#
if ($AUTOMAKE --version) < /dev/null > /dev/null 2>&1 ; then
  if ($AUTOMAKE --version | head -n 1 | awk 'NR==1 { if( $(NF) >= '$automake_min_vers') \
			     exit 1; exit 0; }');
     then
     echo "$ARGV0: ERROR: \`$AUTOMAKE' is too old."
     $AUTOMAKE --version
     echo "           (version $automake_min_vers or newer is required)"
     DIE="yes"
  fi
  if ($ACLOCAL --version) < /dev/null > /dev/null 2>&1; then
    if ($ACLOCAL --version | head -n 1 | awk 'NR==1 { if( $(NF) >= '$aclocal_min_vers' ) \
						exit 1; exit 0; }' );
    then
      echo "$ARGV0: ERROR: \`$ACLOCAL' is too old."
      $ACLOCAL --version
      echo "           (version $aclocal_min_vers or newer is required)"
      DIE="yes"
    fi
  else
    echo $ACLOCAL: command not found
    echo
    echo "$ARGV0: ERROR: Missing \`$ACLOCAL'"
    echo "           The version of $AUTOMAKE installed doesn't appear recent enough."
    DIE="yes"
  fi
else
    echo $AUTOMAKE: command not found
    echo
    echo "$ARGV0: ERROR: You must have \`automake' installed to compile $PACKAGE."
    echo "           (version $automake_min_vers or newer is required)"
    DIE="yes"
fi

if test -z "$ACLOCAL_FLAGS"; then
    acdir=`$ACLOCAL --print-ac-dir`
    if [ ! -f $acdir/pkg.m4 ]; then
	echo "$ARGV0: Error: Could not find pkg-config macros."
	echo "        (Looked in $acdir/pkg.m4)"
	echo "        If pkg.m4 is available in /another/directory, please set"
	echo "        ACLOCAL_FLAGS=\"-I /another/directory\""
	echo "        Otherwise, please install pkg-config."
	echo ""
	echo "pkg-config is available from:"
	echo "http://www.freedesktop.org/software/pkgconfig/"
	DIE=yes
    fi
fi


if test "$DIE" -eq 1; then
  exit 1
fi

if test -z "$*"; then
  echo "**Warning**: I am going to run \`configure' with no arguments."
  echo "If you wish to pass any to it, please specify them on the"
  echo \`$0\'" command line."
  echo
fi

case $CC in
xlc )
  am_opt=--include-deps;;
esac

for coin in `find $srcdir -path $srcdir/CVS -prune -o -name configure.in -print`
do 
  dr=`dirname $coin`
  if test -f $dr/NO-AUTO-GEN; then
    echo skipping $dr -- flagged as no auto-gen
  else
    echo processing $dr
    ( cd $dr

      aclocalinclude="$ACLOCAL_FLAGS"

      if grep "^AM_GLIB_GNU_GETTEXT" configure.in >/dev/null; then
	echo "Creating $dr/aclocal.m4 ..."
	test -r $dr/aclocal.m4 || touch $dr/aclocal.m4
	echo "Running glib-gettextize...  Ignore non-fatal messages."
	echo "no" | glib-gettextize --force --copy
	echo "Making $dr/aclocal.m4 writable ..."
	test -r $dr/aclocal.m4 && chmod u+w $dr/aclocal.m4
      fi
      if grep "^AC_PROG_INTLTOOL" configure.in >/dev/null; then
        echo "Running intltoolize..."
	intltoolize --copy --force --automake
      fi
      if grep "^AM_PROG_XML_I18N_TOOLS" configure.in >/dev/null; then
        echo "Running xml-i18n-toolize..."
	xml-i18n-toolize --copy --force --automake
      fi
      if grep "^AM_PROG_LIBTOOL" configure.in >/dev/null; then
	if test -z "$NO_LIBTOOLIZE" ; then 
	  echo "Running libtoolize..."
	  libtoolize --force --copy
	fi
      fi
      echo "Running aclocal: $ACLOCAL $aclocalinclude ..."
      $ACLOCAL $aclocalinclude
      if grep "^AM_CONFIG_HEADER" configure.in >/dev/null; then
	echo "Running autoheader ($AUTOHEADER)..."
	$AUTOHEADER
      fi
      echo "Running automake: $AUTOMAKE $AUTOMAKE_FLAGS $am_opt ..."
      $AUTOMAKE $AUTOMAKE_FLAGS $am_opt
      echo "Running autoconf: $AUTOCONF ..."
      $AUTOCONF
    )
  fi
done

conf_flags="--enable-maintainer-mode"

if test x$NOCONFIGURE = x; then
  echo Running $srcdir/configure $conf_flags "$@" ...
  $srcdir/configure $conf_flags "$@" \
  && echo Now type \`make\' to compile. || exit 1
else
  echo Skipping configure process.
fi
