# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessRightsDescription(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Rights that this key has.
    """

    SERVICE_CONFIG = "ServiceConfig"
    ENROLLMENT_READ = "EnrollmentRead"
    ENROLLMENT_WRITE = "EnrollmentWrite"
    DEVICE_CONNECT = "DeviceConnect"
    REGISTRATION_STATUS_READ = "RegistrationStatusRead"
    REGISTRATION_STATUS_WRITE = "RegistrationStatusWrite"

class AllocationPolicy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Allocation policy to be used by this provisioning service.
    """

    HASHED = "Hashed"
    GEO_LATENCY = "GeoLatency"
    STATIC = "Static"

class CertificatePurpose(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_AUTHENTICATION = "clientAuthentication"
    SERVER_AUTHENTICATION = "serverAuthentication"

class IotDpsSku(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sku name.
    """

    S1 = "S1"

class IpFilterActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The desired action for requests captured by this rule.
    """

    ACCEPT = "Accept"
    REJECT = "Reject"

class IpFilterTargetType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Target for requests captured by this rule.
    """

    ALL = "all"
    SERVICE_API = "serviceApi"
    DEVICE_API = "deviceApi"

class NameUnavailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """specifies the reason a name is unavailable
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class PrivateLinkServiceConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of a private endpoint connection
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class PublicNetworkAccess(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether requests from Public Network are allowed
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class State(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current state of the provisioning service.
    """

    ACTIVATING = "Activating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DELETED = "Deleted"
    ACTIVATION_FAILED = "ActivationFailed"
    DELETION_FAILED = "DeletionFailed"
    TRANSITIONING = "Transitioning"
    SUSPENDING = "Suspending"
    SUSPENDED = "Suspended"
    RESUMING = "Resuming"
    FAILING_OVER = "FailingOver"
    FAILOVER_FAILED = "FailoverFailed"
