# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class WorkbookTemplateResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class WorkbookTemplate(WorkbookTemplateResource):
    """An Application Insights workbook template definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar priority: Priority of the template. Determines which template to open when a workbook
     gallery is opened in viewer mode.
    :vartype priority: int
    :ivar author: Information about the author of the workbook template.
    :vartype author: str
    :ivar template_data: Valid JSON object containing workbook template payload.
    :vartype template_data: JSON
    :ivar galleries: Workbook galleries supported by the template.
    :vartype galleries:
     list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateGallery]
    :ivar localized: Key value pair of localized gallery. Each key is the locale code of languages
     supported by the Azure portal.
    :vartype localized: dict[str,
     list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateLocalizedGallery]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "priority": {"key": "properties.priority", "type": "int"},
        "author": {"key": "properties.author", "type": "str"},
        "template_data": {"key": "properties.templateData", "type": "object"},
        "galleries": {"key": "properties.galleries", "type": "[WorkbookTemplateGallery]"},
        "localized": {"key": "properties.localized", "type": "{[WorkbookTemplateLocalizedGallery]}"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        priority: Optional[int] = None,
        author: Optional[str] = None,
        template_data: Optional[JSON] = None,
        galleries: Optional[List["_models.WorkbookTemplateGallery"]] = None,
        localized: Optional[Dict[str, List["_models.WorkbookTemplateLocalizedGallery"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword priority: Priority of the template. Determines which template to open when a workbook
         gallery is opened in viewer mode.
        :paramtype priority: int
        :keyword author: Information about the author of the workbook template.
        :paramtype author: str
        :keyword template_data: Valid JSON object containing workbook template payload.
        :paramtype template_data: JSON
        :keyword galleries: Workbook galleries supported by the template.
        :paramtype galleries:
         list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateGallery]
        :keyword localized: Key value pair of localized gallery. Each key is the locale code of
         languages supported by the Azure portal.
        :paramtype localized: dict[str,
         list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateLocalizedGallery]]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.priority = priority
        self.author = author
        self.template_data = template_data
        self.galleries = galleries
        self.localized = localized


class WorkbookTemplateError(_serialization.Model):
    """Error message that will indicate why the operation failed.

    :ivar error: Error message object that will indicate why the operation failed.
    :vartype error: ~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateErrorBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "WorkbookTemplateErrorBody"},
    }

    def __init__(self, *, error: Optional["_models.WorkbookTemplateErrorBody"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error message object that will indicate why the operation failed.
        :paramtype error: ~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateErrorBody
        """
        super().__init__(**kwargs)
        self.error = error


class WorkbookTemplateErrorBody(_serialization.Model):
    """Error message body that will indicate why the operation failed.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details:
     list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateErrorFieldContract]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[WorkbookTemplateErrorFieldContract]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["_models.WorkbookTemplateErrorFieldContract"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details:
         list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateErrorFieldContract]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class WorkbookTemplateErrorFieldContract(_serialization.Model):
    """Error Field contract.

    :ivar code: Property level error code.
    :vartype code: str
    :ivar message: Human-readable representation of property-level error.
    :vartype message: str
    :ivar target: Property name.
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Property level error code.
        :paramtype code: str
        :keyword message: Human-readable representation of property-level error.
        :paramtype message: str
        :keyword target: Property name.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class WorkbookTemplateGallery(_serialization.Model):
    """Gallery information for a workbook template.

    :ivar name: Name of the workbook template in the gallery.
    :vartype name: str
    :ivar category: Category for the gallery.
    :vartype category: str
    :ivar type: Type of workbook supported by the workbook template.
    :vartype type: str
    :ivar order: Order of the template within the gallery.
    :vartype order: int
    :ivar resource_type: Azure resource type supported by the gallery.
    :vartype resource_type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        category: Optional[str] = None,
        type: Optional[str] = None,
        order: Optional[int] = None,
        resource_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the workbook template in the gallery.
        :paramtype name: str
        :keyword category: Category for the gallery.
        :paramtype category: str
        :keyword type: Type of workbook supported by the workbook template.
        :paramtype type: str
        :keyword order: Order of the template within the gallery.
        :paramtype order: int
        :keyword resource_type: Azure resource type supported by the gallery.
        :paramtype resource_type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.category = category
        self.type = type
        self.order = order
        self.resource_type = resource_type


class WorkbookTemplateLocalizedGallery(_serialization.Model):
    """Localized template data and gallery information.

    :ivar template_data: Valid JSON object containing workbook template payload.
    :vartype template_data: JSON
    :ivar galleries: Workbook galleries supported by the template.
    :vartype galleries:
     list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateGallery]
    """

    _attribute_map = {
        "template_data": {"key": "templateData", "type": "object"},
        "galleries": {"key": "galleries", "type": "[WorkbookTemplateGallery]"},
    }

    def __init__(
        self,
        *,
        template_data: Optional[JSON] = None,
        galleries: Optional[List["_models.WorkbookTemplateGallery"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template_data: Valid JSON object containing workbook template payload.
        :paramtype template_data: JSON
        :keyword galleries: Workbook galleries supported by the template.
        :paramtype galleries:
         list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateGallery]
        """
        super().__init__(**kwargs)
        self.template_data = template_data
        self.galleries = galleries


class WorkbookTemplatesListResult(_serialization.Model):
    """WorkbookTemplate list result.

    :ivar value: An array of workbook templates.
    :vartype value: list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplate]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkbookTemplate]"},
    }

    def __init__(self, *, value: Optional[List["_models.WorkbookTemplate"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of workbook templates.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplate]
        """
        super().__init__(**kwargs)
        self.value = value


class WorkbookTemplateUpdateParameters(_serialization.Model):
    """The parameters that can be provided when updating workbook template.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar priority: Priority of the template. Determines which template to open when a workbook
     gallery is opened in viewer mode.
    :vartype priority: int
    :ivar author: Information about the author of the workbook template.
    :vartype author: str
    :ivar template_data: Valid JSON object containing workbook template payload.
    :vartype template_data: JSON
    :ivar galleries: Workbook galleries supported by the template.
    :vartype galleries:
     list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateGallery]
    :ivar localized: Key value pair of localized gallery. Each key is the locale code of languages
     supported by the Azure portal.
    :vartype localized: dict[str,
     list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateLocalizedGallery]]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "priority": {"key": "properties.priority", "type": "int"},
        "author": {"key": "properties.author", "type": "str"},
        "template_data": {"key": "properties.templateData", "type": "object"},
        "galleries": {"key": "properties.galleries", "type": "[WorkbookTemplateGallery]"},
        "localized": {"key": "properties.localized", "type": "{[WorkbookTemplateLocalizedGallery]}"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        priority: Optional[int] = None,
        author: Optional[str] = None,
        template_data: Optional[JSON] = None,
        galleries: Optional[List["_models.WorkbookTemplateGallery"]] = None,
        localized: Optional[Dict[str, List["_models.WorkbookTemplateLocalizedGallery"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword priority: Priority of the template. Determines which template to open when a workbook
         gallery is opened in viewer mode.
        :paramtype priority: int
        :keyword author: Information about the author of the workbook template.
        :paramtype author: str
        :keyword template_data: Valid JSON object containing workbook template payload.
        :paramtype template_data: JSON
        :keyword galleries: Workbook galleries supported by the template.
        :paramtype galleries:
         list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateGallery]
        :keyword localized: Key value pair of localized gallery. Each key is the locale code of
         languages supported by the Azure portal.
        :paramtype localized: dict[str,
         list[~azure.mgmt.applicationinsights.v2020_11_20.models.WorkbookTemplateLocalizedGallery]]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.priority = priority
        self.author = author
        self.template_data = template_data
        self.galleries = galleries
        self.localized = localized
