# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ParticipantList(ListResource):
    """  """

    def __init__(self, version, account_sid, conference_sid):
        """
        Initialize the ParticipantList

        :param Version version: Version that contains the resource
        :param account_sid: The unique sid that identifies this account
        :param conference_sid: A string that uniquely identifies this conference

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantList
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantList
        """
        super(ParticipantList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, 'conference_sid': conference_sid,}
        self._uri = '/Accounts/{account_sid}/Conferences/{conference_sid}/Participants.json'.format(**self._solution)

    def create(self, from_, to, status_callback=values.unset,
               status_callback_method=values.unset,
               status_callback_event=values.unset, timeout=values.unset,
               record=values.unset, muted=values.unset, beep=values.unset,
               start_conference_on_enter=values.unset,
               end_conference_on_exit=values.unset, wait_url=values.unset,
               wait_method=values.unset, early_media=values.unset,
               max_participants=values.unset, conference_record=values.unset,
               conference_trim=values.unset,
               conference_status_callback=values.unset,
               conference_status_callback_method=values.unset,
               conference_status_callback_event=values.unset,
               recording_channels=values.unset,
               recording_status_callback=values.unset,
               recording_status_callback_method=values.unset,
               sip_auth_username=values.unset, sip_auth_password=values.unset,
               region=values.unset,
               conference_recording_status_callback=values.unset,
               conference_recording_status_callback_method=values.unset):
        """
        Create a new ParticipantInstance

        :param unicode from_: The from
        :param unicode to: The to
        :param unicode status_callback: The status_callback
        :param unicode status_callback_method: The status_callback_method
        :param unicode status_callback_event: The status_callback_event
        :param unicode timeout: The timeout
        :param bool record: The record
        :param bool muted: The muted
        :param unicode beep: The beep
        :param bool start_conference_on_enter: The start_conference_on_enter
        :param bool end_conference_on_exit: The end_conference_on_exit
        :param unicode wait_url: The wait_url
        :param unicode wait_method: The wait_method
        :param bool early_media: The early_media
        :param unicode max_participants: The max_participants
        :param unicode conference_record: The conference_record
        :param unicode conference_trim: The conference_trim
        :param unicode conference_status_callback: The conference_status_callback
        :param unicode conference_status_callback_method: The conference_status_callback_method
        :param unicode conference_status_callback_event: The conference_status_callback_event
        :param unicode recording_channels: The recording_channels
        :param unicode recording_status_callback: The recording_status_callback
        :param unicode recording_status_callback_method: The recording_status_callback_method
        :param unicode sip_auth_username: The sip_auth_username
        :param unicode sip_auth_password: The sip_auth_password
        :param unicode region: The region
        :param unicode conference_recording_status_callback: The conference_recording_status_callback
        :param unicode conference_recording_status_callback_method: The conference_recording_status_callback_method

        :returns: Newly created ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        data = values.of({
            'From': from_,
            'To': to,
            'StatusCallback': status_callback,
            'StatusCallbackMethod': status_callback_method,
            'StatusCallbackEvent': status_callback_event,
            'Timeout': timeout,
            'Record': record,
            'Muted': muted,
            'Beep': beep,
            'StartConferenceOnEnter': start_conference_on_enter,
            'EndConferenceOnExit': end_conference_on_exit,
            'WaitUrl': wait_url,
            'WaitMethod': wait_method,
            'EarlyMedia': early_media,
            'MaxParticipants': max_participants,
            'ConferenceRecord': conference_record,
            'ConferenceTrim': conference_trim,
            'ConferenceStatusCallback': conference_status_callback,
            'ConferenceStatusCallbackMethod': conference_status_callback_method,
            'ConferenceStatusCallbackEvent': conference_status_callback_event,
            'RecordingChannels': recording_channels,
            'RecordingStatusCallback': recording_status_callback,
            'RecordingStatusCallbackMethod': recording_status_callback_method,
            'SipAuthUsername': sip_auth_username,
            'SipAuthPassword': sip_auth_password,
            'Region': region,
            'ConferenceRecordingStatusCallback': conference_recording_status_callback,
            'ConferenceRecordingStatusCallbackMethod': conference_recording_status_callback_method,
        })

        payload = self._version.create(
            'POST',
            self._uri,
            data=data,
        )

        return ParticipantInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            conference_sid=self._solution['conference_sid'],
        )

    def stream(self, muted=values.unset, hold=values.unset, limit=None,
               page_size=None):
        """
        Streams ParticipantInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param bool muted: Filter by muted participants
        :param bool hold: The hold
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.api.v2010.account.conference.participant.ParticipantInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(muted=muted, hold=hold, page_size=limits['page_size'],)

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, muted=values.unset, hold=values.unset, limit=None,
             page_size=None):
        """
        Lists ParticipantInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param bool muted: Filter by muted participants
        :param bool hold: The hold
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.api.v2010.account.conference.participant.ParticipantInstance]
        """
        return list(self.stream(muted=muted, hold=hold, limit=limit, page_size=page_size,))

    def page(self, muted=values.unset, hold=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of ParticipantInstance records from the API.
        Request is executed immediately

        :param bool muted: Filter by muted participants
        :param bool hold: The hold
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantPage
        """
        params = values.of({
            'Muted': muted,
            'Hold': hold,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(
            'GET',
            self._uri,
            params=params,
        )

        return ParticipantPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ParticipantInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ParticipantPage(self._version, response, self._solution)

    def get(self, call_sid):
        """
        Constructs a ParticipantContext

        :param call_sid: The call_sid

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        """
        return ParticipantContext(
            self._version,
            account_sid=self._solution['account_sid'],
            conference_sid=self._solution['conference_sid'],
            call_sid=call_sid,
        )

    def __call__(self, call_sid):
        """
        Constructs a ParticipantContext

        :param call_sid: The call_sid

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        """
        return ParticipantContext(
            self._version,
            account_sid=self._solution['account_sid'],
            conference_sid=self._solution['conference_sid'],
            call_sid=call_sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.ParticipantList>'


class ParticipantPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the ParticipantPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: The unique sid that identifies this account
        :param conference_sid: A string that uniquely identifies this conference

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantPage
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantPage
        """
        super(ParticipantPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ParticipantInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        return ParticipantInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            conference_sid=self._solution['conference_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.ParticipantPage>'


class ParticipantContext(InstanceContext):
    """  """

    def __init__(self, version, account_sid, conference_sid, call_sid):
        """
        Initialize the ParticipantContext

        :param Version version: Version that contains the resource
        :param account_sid: The account_sid
        :param conference_sid: The string that uniquely identifies this conference
        :param call_sid: The call_sid

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        """
        super(ParticipantContext, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, 'conference_sid': conference_sid, 'call_sid': call_sid,}
        self._uri = '/Accounts/{account_sid}/Conferences/{conference_sid}/Participants/{call_sid}.json'.format(**self._solution)

    def fetch(self):
        """
        Fetch a ParticipantInstance

        :returns: Fetched ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        params = values.of({})

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return ParticipantInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            conference_sid=self._solution['conference_sid'],
            call_sid=self._solution['call_sid'],
        )

    def update(self, muted=values.unset, hold=values.unset, hold_url=values.unset,
               hold_method=values.unset, announce_url=values.unset,
               announce_method=values.unset):
        """
        Update the ParticipantInstance

        :param bool muted: Indicates if the participant should be muted
        :param bool hold: The hold
        :param unicode hold_url: The hold_url
        :param unicode hold_method: The hold_method
        :param unicode announce_url: The announce_url
        :param unicode announce_method: The announce_method

        :returns: Updated ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        data = values.of({
            'Muted': muted,
            'Hold': hold,
            'HoldUrl': hold_url,
            'HoldMethod': hold_method,
            'AnnounceUrl': announce_url,
            'AnnounceMethod': announce_method,
        })

        payload = self._version.update(
            'POST',
            self._uri,
            data=data,
        )

        return ParticipantInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            conference_sid=self._solution['conference_sid'],
            call_sid=self._solution['call_sid'],
        )

    def delete(self):
        """
        Deletes the ParticipantInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete('delete', self._uri)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Api.V2010.ParticipantContext {}>'.format(context)


class ParticipantInstance(InstanceResource):
    """  """

    class Status(object):
        QUEUED = "queued"
        CONNECTING = "connecting"
        RINGING = "ringing"
        CONNECTED = "connected"
        COMPLETE = "complete"
        FAILED = "failed"

    def __init__(self, version, payload, account_sid, conference_sid,
                 call_sid=None):
        """
        Initialize the ParticipantInstance

        :returns: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        super(ParticipantInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'call_sid': payload['call_sid'],
            'conference_sid': payload['conference_sid'],
            'date_created': deserialize.rfc2822_datetime(payload['date_created']),
            'date_updated': deserialize.rfc2822_datetime(payload['date_updated']),
            'end_conference_on_exit': payload['end_conference_on_exit'],
            'muted': payload['muted'],
            'hold': payload['hold'],
            'start_conference_on_enter': payload['start_conference_on_enter'],
            'status': payload['status'],
            'uri': payload['uri'],
        }

        # Context
        self._context = None
        self._solution = {
            'account_sid': account_sid,
            'conference_sid': conference_sid,
            'call_sid': call_sid or self._properties['call_sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ParticipantContext for this ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantContext
        """
        if self._context is None:
            self._context = ParticipantContext(
                self._version,
                account_sid=self._solution['account_sid'],
                conference_sid=self._solution['conference_sid'],
                call_sid=self._solution['call_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique sid that identifies this account
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def call_sid(self):
        """
        :returns: A string that uniquely identifies this call
        :rtype: unicode
        """
        return self._properties['call_sid']

    @property
    def conference_sid(self):
        """
        :returns: A string that uniquely identifies this conference
        :rtype: unicode
        """
        return self._properties['conference_sid']

    @property
    def date_created(self):
        """
        :returns: The date this resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date this resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def end_conference_on_exit(self):
        """
        :returns: Indicates if the endConferenceOnExit was set
        :rtype: bool
        """
        return self._properties['end_conference_on_exit']

    @property
    def muted(self):
        """
        :returns: Indicates if the participant is muted
        :rtype: bool
        """
        return self._properties['muted']

    @property
    def hold(self):
        """
        :returns: The hold
        :rtype: bool
        """
        return self._properties['hold']

    @property
    def start_conference_on_enter(self):
        """
        :returns: Indicates if the startConferenceOnEnter attribute was set
        :rtype: bool
        """
        return self._properties['start_conference_on_enter']

    @property
    def status(self):
        """
        :returns: The status
        :rtype: ParticipantInstance.Status
        """
        return self._properties['status']

    @property
    def uri(self):
        """
        :returns: The URI for this resource
        :rtype: unicode
        """
        return self._properties['uri']

    def fetch(self):
        """
        Fetch a ParticipantInstance

        :returns: Fetched ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        return self._proxy.fetch()

    def update(self, muted=values.unset, hold=values.unset, hold_url=values.unset,
               hold_method=values.unset, announce_url=values.unset,
               announce_method=values.unset):
        """
        Update the ParticipantInstance

        :param bool muted: Indicates if the participant should be muted
        :param bool hold: The hold
        :param unicode hold_url: The hold_url
        :param unicode hold_method: The hold_method
        :param unicode announce_url: The announce_url
        :param unicode announce_method: The announce_method

        :returns: Updated ParticipantInstance
        :rtype: twilio.rest.api.v2010.account.conference.participant.ParticipantInstance
        """
        return self._proxy.update(
            muted=muted,
            hold=hold,
            hold_url=hold_url,
            hold_method=hold_method,
            announce_url=announce_url,
            announce_method=announce_method,
        )

    def delete(self):
        """
        Deletes the ParticipantInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Api.V2010.ParticipantInstance {}>'.format(context)
