% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusionmap-plotting.r
\name{plot.DiffusionMap}
\alias{plot.DiffusionMap}
\alias{plot,DiffusionMap,numeric-method}
\alias{plot,DiffusionMap,missing-method}
\title{3D or 2D plot of diffusion map}
\usage{
plot.DiffusionMap(
  x,
  dims = 1:3,
  new_dcs = if (!is.null(new_data)) dm_predict(x, new_data),
  new_data = NULL,
  col = NULL,
  col_by = NULL,
  col_limits = NULL,
  col_new = "red",
  pal = NULL,
  pal_new = NULL,
  ...,
  ticks = FALSE,
  axes = TRUE,
  box = FALSE,
  legend_main = col_by,
  legend_opts = list(),
  interactive = FALSE,
  draw_legend = !is.null(col_by) || (length(col) > 1 && !is.character(col)),
  consec_col = TRUE,
  col_na = "grey",
  plot_more = function(p, ..., rescale = NULL) p
)

\S4method{plot}{DiffusionMap,numeric}(x, y, ...)

\S4method{plot}{DiffusionMap,missing}(x, y, ...)
}
\arguments{
\item{x}{A \link{DiffusionMap}}

\item{dims, y}{Diffusion components (eigenvectors) to plot (default: first three components; 1:3)}

\item{new_dcs}{An optional matrix also containing the rows specified with \code{y} and plotted. (default: no more points)}

\item{new_data}{A data set in the same format as \code{x} that is used to create \code{new_dcs <- \link{dm_predict}(dif, new_data)}}

\item{col}{Single color string or vector of discrete or categoric values to be mapped to colors.
E.g. a column of the data matrix used for creation of the diffusion map. (default: \code{\link[igraph]{cluster_louvain}} if igraph is installed)}

\item{col_by}{Specify a \code{dataset(x)} or \code{phenoData(dataset(x))} column to use as color}

\item{col_limits}{If \code{col} is a continuous (=double) vector, this can be overridden to map the color range differently than from min to max (e.g. specify \code{c(0, 1)})}

\item{col_new}{If \code{new_dcs} is given, it will take on this color. A vector is also possible. (default: red)}

\item{pal}{Palette used to map the \code{col} vector to colors. (default: use \code{\link{hcl.colors}} for continuous and \code{\link{palette}()} for discrete data)}

\item{pal_new}{Palette used to map the \code{col_new} vector to colors. (default: see \code{pal} argument)}

\item{...}{Parameters passed to \link{plot}, \link[scatterplot3d]{scatterplot3d}, or \link[rgl]{plot3d} (if \code{interactive == TRUE})}

\item{ticks}{logical. If TRUE, show axis ticks (default: FALSE)}

\item{axes}{logical. If TRUE, draw plot axes (default: Only if \code{ticks} is TRUE)}

\item{box}{logical. If TRUE, draw plot frame (default: TRUE or the same as \code{axes} if specified)}

\item{legend_main}{Title of legend. (default: nothing unless \code{col_by} is given)}

\item{legend_opts}{Other \link{colorlegend} options (default: empty list)}

\item{interactive}{Use \link[rgl]{plot3d} to plot instead of \link[scatterplot3d]{scatterplot3d}?}

\item{draw_legend}{logical. If TRUE, draw color legend (default: TRUE if \code{col_by} is given or \code{col} is given and a vector to be mapped)}

\item{consec_col}{If \code{col} or \code{col_by} refers to an integer column, with gaps (e.g. \code{c(5,0,0,3)}) use the palette color consecutively (e.g. \code{c(3,1,1,2)})}

\item{col_na}{Color for \code{NA} in the data. specify \code{NA} to hide.}

\item{plot_more}{Function that will be called while the plot margins are temporarily changed
(its \code{p} argument is the rgl or scatterplot3d instance or NULL,
its \code{rescale} argument is \code{NULL}, a \code{list(from = c(a, b), to = c(c, d))}),
or an array of shape \eqn{from|to \times dims \times min|max}, i.e. \eqn{2 \times length(dims) \times 2}.
In case of 2d plotting, it should take and return a ggplot2 object.}
}
\value{
The return value of the underlying call is returned, i.e. a scatterplot3d or rgl object.
}
\description{
If you want to plot the eigenvalues, simply \code{plot(eigenvalues(dm)[start:end], ...)}
}
\details{
If you specify negative numbers as diffusion components (e.g. \code{plot(dm, c(-1,2))}), then the corresponding components will be flipped.
}
\examples{
data(guo)
plot(DiffusionMap(guo))

}
