\name{lengthbias}
\alias{lengthbias-class}
\alias{lengthbias}
\alias{explo.plot,lengthbias-method}
\alias{show,lengthbias-method}
\alias{dat2save,lengthbias-method}
\docType{class}
\title{lengthbias class}

\description{
lengthbias class generated from dat() function with type="lengthbias". 
This object contains the trimmed mean of expression for each length bin of 200 features per sample or condition and also per biotype (if available). 
It also includes the corresponding spline regression models fitted to explain the relationship between length and expression.
}

\usage{
\S4method{explo.plot}{lengthbias}(object, samples = NULL, toplot = "global", ...)
\S4method{dat2save}{lengthbias}(object)
}

\arguments{
  \item{object}{
    Object generated with \code{dat()} function.
  }
  \item{toplot}{
    Biological group to be plotted (features not belonging to that group are discarded).
    It may be a number or a text with the name of the biological group. 
    If toplot=1 or toplot="global", all features are used for the plot.
  }
  \item{samples}{
    Samples (or conditions) to be plotted. If NULL, all the samples are plotted.
    If samples > 2, only a descriptive plot will be generated. If not, diagnostic plots will be obtained showing both the R-squared and model p-value
from the spline regression model describing the relationship between the length and the expression. 
  }  
  \item{...}{
    Any argument from \code{par}.
  }
}

\section{Slots/List Components}{
Objects of this class contain (at least) the following list components:

  \code{dat}: List containing the information generated by dat() function. This list has the following elements:
  
  \code{data2plot}: A list with as many elements as biological groups (the first element correspond to all the features). 
Each element of the list is a matrix containing the length bins in the first column and an additional column 
for the trimmed mean expression per bin for each sample or condition. 
  \code{RegressionModels}: A list with as many elements as samples or conditions. 
Each element is an "lm" class object containing the spline regression model relating length and expression for that sample or condition (considering all the features).
  
}

\section{Methods}{
This class has an specific \code{show} method to print
a summary of spline regression models and a \code{dat2save} method
to save the length bin information. It also has an
\code{explo.plot} method to plot the data contained in the object.
}

\author{Sonia Tarazona}

\keyword{classes}
