% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{bit_in}
\alias{bit_in}
\title{bit \%in\%}
\usage{
bit_in(x, table, retFUN = as.bit)
}
\arguments{
\item{x}{an integer vector of values to be looked-up}

\item{table}{an integer vector used as lookup-table}

\item{retFUN}{a function that coerces \code{\link[=bit]{bit()}} and \code{\link[=logical]{logical()}} vectors}
}
\value{
a boolean vector coerced to \code{retFUN}
}
\description{
fast \code{\link[=match]{\%in\%}} for integers
}
\details{
determines the range of the integers and checks if the density justifies use
of a bit vector; if yes, maps \code{x} or \code{table} -- whatever is smaller
-- into a bit vector and searches the other of \code{table} or \code{x} in
the it vector; if no, falls back to \code{\link[=match]{\%in\%}}
}
\examples{
bit_in(1:2, 2:3)
bit_in(1:2, 2:3, retFUN=as.logical)
}
\seealso{
\code{\link[=match]{\%in\%}}
}
