% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findLinearCombos.R
\name{findLinearCombos}
\alias{findLinearCombos}
\title{Determine linear combinations in a matrix}
\usage{
findLinearCombos(x)
}
\arguments{
\item{x}{a numeric matrix}
}
\value{
a list with elements: \item{linearCombos }{If there are linear
combinations, this will be a list with elements for each dependency that
contains vectors of column numbers. } \item{remove }{a list of column
numbers that can be removed to counter the linear combinations}
}
\description{
Enumerate and resolve the linear combinations in a numeric matrix
}
\details{
The QR decomposition is used to determine if the matrix is full rank and
then identify the sets of columns that are involved in the dependencies.

To "resolve" them, columns are iteratively removed and the matrix rank is
rechecked.
}
\examples{

testData1 <- matrix(0, nrow=20, ncol=8)
testData1[,1] <- 1
testData1[,2] <- round(rnorm(20), 1)
testData1[,3] <- round(rnorm(20), 1)
testData1[,4] <- round(rnorm(20), 1)
testData1[,5] <- 0.5 * testData1[,2] - 0.25 * testData1[,3] - 0.25 * testData1[,4]
testData1[1:4,6] <- 1
testData1[5:10,7] <- 1
testData1[11:20,8] <- 1

findLinearCombos(testData1)

testData2 <- matrix(0, nrow=6, ncol=6)
testData2[,1] <- c(1, 1, 1, 1, 1, 1)
testData2[,2] <- c(1, 1, 1, 0, 0, 0)
testData2[,3] <- c(0, 0, 0, 1, 1, 1)
testData2[,4] <- c(1, 0, 0, 1, 0, 0)
testData2[,5] <- c(0, 1, 0, 0, 1, 0)
testData2[,6] <- c(0, 0, 1, 0, 0, 1)

findLinearCombos(testData2)

}
\author{
Kirk Mettler and Jed Wing (\code{enumLC}) and Max Kuhn
(\code{findLinearCombos})
}
\keyword{manip}
