% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-bin2d.r, R/stat-bin2d.r
\name{geom_bin2d}
\alias{geom_bin2d}
\alias{stat_bin2d}
\alias{stat_bin_2d}
\title{Add heatmap of 2d bin counts.}
\usage{
geom_bin2d(mapping = NULL, data = NULL, stat = "bin2d",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

stat_bin_2d(mapping = NULL, data = NULL, geom = "tile",
  position = "identity", bins = 30, binwidth = NULL, drop = TRUE,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{geom, stat}{Use to override the default connection between
\code{geom_bin2d} and \code{stat_bin2d}.}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{binwidth}{Numeric vector giving bin width in both vertical and
horizontal directions. Overrides \code{bins} if both set.}

\item{drop}{if \code{TRUE} removes all cells with 0 counts.}
}
\description{
Add heatmap of 2d bin counts.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("stat", "bin2d")}
}
\examples{
d <- ggplot(diamonds, aes(x, y)) + xlim(4, 10) + ylim(4, 10)
d + geom_bin2d()

# You can control the size of the bins by specifying the number of
# bins in each direction:
d + geom_bin2d(bins = 10)
d + geom_bin2d(bins = 30)

# Or by specifying the width of the bins
d + geom_bin2d(binwidth = c(0.1, 0.1))
}
\seealso{
\code{\link{stat_binhex}} for hexagonal binning
}

