\name{reporter}
\alias{reporter}
\alias{reporter.rma.uni}
\title{Dynamically Generated Analysis Reports for 'rma.uni' Objects}
\description{
   The function dynamically generates analysis reports for objects of class \code{"rma.uni"}.
}
\usage{
reporter(x, \dots)

\method{reporter}{rma.uni}(x, dir, filename, format="html_document", open=TRUE,
         digits, forest, funnel, footnotes=FALSE, verbose=TRUE, \dots)
}
\arguments{
   \item{x}{an object of class \code{"rma.uni"}.}
   \item{dir}{optional character string to specify the directory for creating the report. If unspecified, \code{\link{tempdir}} will be used.}
   \item{filename}{optional character string to specify the filename (without file extension) for the report. If unspecified, the function sets a filename automatically.}
   \item{format}{output format for the report (either \code{html_document}, \code{pdf_document}, or \code{word_document}). Can be abbreviated. See \sQuote{Note}.}
   \item{open}{logical to specify whether the report should be opened after it has been generated (the default is \code{TRUE}). See \sQuote{Note}.}
   \item{digits}{integer to specify the number of decimal places to which the printed results should be rounded. If unspecified, the default is to take the value from the object.}
   \item{forest}{either a logical which will suppress the drawing of the forest plot when set to \code{FALSE} or a character string with arguments to be added to the call to \code{\link{forest.rma}} for generating the forest plot.}
   \item{funnel}{either a logical which will suppress the drawing of the funnel plot when set to \code{FALSE} or a character string with arguments to be added to the call to \code{\link{funnel.rma}} for generating the funnel plot.}
   \item{footnotes}{logical to specify whether additional explanatory footnotes should be added to the report (the default is \code{FALSE}).}
   \item{verbose}{logical to specify whether information on the progress of the report generation should be provided (the default is \code{TRUE}).}
   \item{\dots}{other arguments.}
}
\details{
   The function dynamically generates an analysis report based on the model object. The report includes information about the model that was fitted, the distribution of the observed effect sizes or outcomes, the estimate of the average outcome based on the fitted model, tests and statistics that are informative about potential (residual) heterogeneity in the outcomes, checks for outliers and/or influential studies, and tests for funnel plot asymmetry. By default, a forest plot and a funnel plot are also provided (these can be suppressed by setting \code{forest=FALSE} and/or \code{funnel=FALSE}).
}
\value{
   The function generates either a html, pdf, or docx file and returns (invisibly) the path to the generated document.
}
\note{
   Since the report is created based on an R markdown document that is generated by the function, the \href{https://cran.r-project.org/package=rmarkdown}{rmarkdown} package and \href{https://pandoc.org}{pandoc} must be installed.

   To render the report into a pdf document (i.e., using \code{format="pdf_document"}) requires a LaTeX installation. If LaTeX is not already installed, you could try using the \href{https://cran.r-project.org/package=tinytex}{tinytex} package to install a lightweight LaTeX distribution based on TeX Live.

   Once the report is generated, the function tries to open the output file (either a .html, .pdf, or .docx file) with an appropriate application (if \code{open=TRUE}). This will only work when an appropriate application for the file type is installed and associated with the extension.

   If \code{filename} is unspecified, the default is to use \code{report}, followed by an underscore (i.e., \code{_}) and the name of the object passed to the function. Both the R markdown file (with extension .rmd) and the actual report (with extension .html, .pdf, or .docx) are named accordingly. To generate the report, the model object is also saved to a file (with the same filename as above, but with extension .rdata). Also, files \code{references.bib} and \code{apa.csl} are copied to the same directory (these files are needed to generate the references in APA format).

   Since the report is put together based on predefined text blocks, the writing is not very elegant. Also, using personal pronouns (\sQuote{I} or \sQuote{we}) does not make sense for such a report, so a lot of passive voice is used.

   The generated report provides an illustration of how the results of the model can be reported, but is not a substitute for a careful examination of the results.
}
\author{
   Wolfgang Viechtbauer \email{wvb@metafor-project.org} \url{https://www.metafor-project.org}
}
\references{
   Viechtbauer, W. (2010). Conducting meta-analyses in R with the metafor package. \emph{Journal of Statistical Software}, \bold{36}(3), 1--48. \verb{https://doi.org/10.18637/jss.v036.i03}
}
\seealso{
   \code{\link{rma.uni}}
}
\examples{
### copy BCG vaccine data into 'dat'
dat <- dat.bcg

### calculate log risk ratios and corresponding sampling variances
dat <- escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat,
              slab=paste(author, ", ", year, sep=""))

### fit random-effects model
res <- rma(yi, vi, data=dat)

\dontrun{
### generate pdf report
reporter(res)}
}
\keyword{methods}
