% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_fragment.R
\name{html_fragment}
\alias{html_fragment}
\title{Convert to an HTML fragment.}
\usage{
html_fragment(
  number_sections = FALSE,
  section_divs = TRUE,
  fig_width = 7,
  fig_height = 5,
  fig_retina = 2,
  fig_caption = TRUE,
  dev = "png",
  df_print = "default",
  smart = TRUE,
  mathjax = TRUE,
  includes = NULL,
  keep_md = FALSE,
  md_extensions = NULL,
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{number_sections}{\code{TRUE} to number section headings}

\item{section_divs}{Wrap sections in <div> tags, and attach identifiers to the
enclosing <div> rather than the header itself.}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2, which
currently works for all widely used retina displays). Set to \code{NULL} to
prevent retina scaling. Note that this will always be \code{NULL} when
\code{keep_md} is specified (this is because \code{fig_retina} relies on
outputting HTML directly into the markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}.}

\item{smart}{Produce typographically correct output, converting straight
quotes to curly quotes, \code{---} to em-dashes, \code{--} to en-dashes, and
\code{...} to ellipses.}

\item{mathjax}{\code{TRUE} to convert $ and $$ math blocks into MathJax
compatible output. Note that you'll still need to ensure that the page
where the fragment is included loads the required MathJax scripts.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{...}{Additional arguments passed to \code{\link{html_document}}}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
An html fragment is suitable for inclusion into an external html page. See
\code{\link{html_document}} for full details - this is a minor variation that
assumes you will include the output into an existing document (e.g. a blog
post).
}
\details{
See the \href{https://rmarkdown.rstudio.com/html_document_format.html}{online
documentation} for additional details on using the \code{html_fragment}
format.
}
