# this file has been automatically generated by valabind
from ctypes import *
from ctypes.util import find_library
lib = CDLL (find_library ('r_bin'))
def rlist2array(x,y):
	it = x.iterator ()
	ret = []
	while True:
		data = it.get_data ()
		ds = cast (data, POINTER(y)).contents
		ret.append (ds)
		if it.n == None:
			break
		it = it.get_next ()
	return ret

class AddressHolder(object):
	def __get__(self, obj, type_):
		if getattr(obj, '_address', None) is None:
			obj._address = addressof(obj)
		return obj._address

	def __set__(self, obj, value):
		obj._address = value

class WrappedRMethod(object):
	def __init__(self, cname, args, ret):
		self.cname = cname
		self.args = args
		self.ret = ret
		self.args_set = False
		self.method = getattr(lib, cname)

	def __call__(self, *a):
		if not self.args_set:
			if self.args:
				self.method.argtypes = [eval(x.strip()) for x in self.args.split(',')]
			self.method.restype = eval(self.ret) if self.ret else None
			self.args_set = True
		return self.method(*a)

class WrappedApiMethod(object):
	def __init__(self, method, ret2, last):
		self.method = method
		self._o = None
		self.ret2 = ret2
		self.last = last

	def __call__(self, *a):
		result = self.method(self._o, *a)
		if self.ret2:
			result = eval(self.ret2)(result)
		if self.last:
			return getattr(result, self.last)
		return result

	def __get__(self, obj, type_):
		self._o = obj._o
		return self

def register(cname, args, ret):
	ret2 = last = None
	if ret:
		if ret[0]>='A' and ret[0]<='Z':
			x = ret.find('<')
			if x != -1:
				ret = ret[0:x]
			last = 'contents'
			ret = 'POINTER('+ret+')'
		else:
			last = 'value'
			ret2 = ret
			
	method = WrappedRMethod(cname, args, ret)
	wrapped_method = WrappedApiMethod(method, ret2, last)
	return wrapped_method, method

class RBinPlugin(Structure): #2
	_fields_ = [
	]
class RBinDwarfRow(Structure): #3
	_fields_ = [
		("address", c_ulonglong),
		("file", c_char_p),
		("line", c_int),
		("column", c_int),
	]
class RBinClass(Structure): #4
	_fields_ = [
		("name", c_char_p),
		("super", c_char_p),
		("index", c_int),
		("methods", c_void_p),
		("fields", c_void_p),
		("visibility", c_bool),
	]
class RBinAddr(Structure): #6
	_fields_ = [
		("rva", c_ulonglong),
		("offset", c_ulonglong),
	]
class RBinSection(Structure): #7
	_fields_ = [
		('name', c_char * 512),
		("size", c_ulonglong),
		("vsize", c_ulonglong),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
		("srwx", c_ulonglong),
	]
class RBinSymbol(Structure): #8
	_fields_ = [
		('name', c_char * 512),
		('forwarder', c_char * 512),
		('bind', c_char * 512),
		('type', c_char * 512),
		("classname", c_char_p),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
		("size", c_ulonglong),
		("ordinal", c_ulonglong),
	]
class RBinImport(Structure): #9
	_fields_ = [
		('name', c_char * 512),
		('bind', c_char * 512),
		('type', c_char * 512),
		("ordinal", c_ulonglong),
	]
class RBinReloc(Structure): #10
	_fields_ = [
		("type", c_ubyte),
		("additive", c_ubyte),
		("import", RBinImport),
		("addend", c_longlong),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
	]
class RBinInfo(Structure): #11
	_fields_ = [
		('file', c_char * 512),
		('type', c_char * 512),
		('bclass', c_char * 512),
		('rclass', c_char * 512),
		('arch', c_char * 512),
		('machine', c_char * 512),
		('os', c_char * 512),
		('subsystem', c_char * 512),
		('rpath', c_char * 512),
		("lang", c_char_p),
		("bits", c_int),
		("has_va", c_bool),
		("has_pi", c_bool),
		("big_endian", c_bool),
		("dbg_info", c_ulonglong),
	]
class RBinObject(Structure): #5
	_fields_ = [
		("baddr", c_ulonglong),
		("size", c_int),
		("sections", c_void_p),
		("imports", c_void_p),
		("symbols", c_void_p),
		("entries", c_void_p),
		("fields", c_void_p),
		("libs", c_void_p),
		("relocs", c_void_p),
		("strings", c_void_p),
		("classes", c_void_p),
		("lines", c_void_p),
		("info", RBinInfo),
		('binsym', RBinAddr * 4),
	]
class RBinString(Structure): #12
	_fields_ = [
		('string', c_char * 512),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
		("ordinal", c_ulonglong),
		("size", c_ulonglong),
	]
class RBinField(Structure): #13
	_fields_ = [
		('name', c_char * 512),
		("rva", c_ulonglong),
		("offset", c_ulonglong),
	]
class RNum(Structure): #14
	_fields_ = [
	]
	def __init__(self, cb, user):
		Structure.__init__(self)
		r_num_new = lib.r_num_new
		r_num_new.restype = c_void_p
		self._o = r_num_new (cb, user)

	_o = AddressHolder()

	get, r_num_get = register('r_num_get','c_void_p, c_char_p','c_ulonglong')
	math, r_num_math = register('r_num_math','c_void_p, c_char_p','c_ulonglong')

class RBuffer(Structure): #15
	_fields_ = [
		("buf", POINTER(c_ubyte)),
		("length", c_int),
		("cur", c_int),
		("base", c_ulonglong),
	]
	def __init__(self):
		Structure.__init__(self)
		r_buf_new = lib.r_buf_new
		r_buf_new.restype = c_void_p
		self._o = r_buf_new ()

	_o = AddressHolder()

	read_at, r_buf_read_at = register('r_buf_read_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	write_at, r_buf_write_at = register('r_buf_write_at','c_void_p, c_ulonglong, POINTER(c_ubyte), c_int','c_int')
	set_bytes, r_buf_set_bytes = register('r_buf_set_bytes','c_void_p, POINTER(c_ubyte), c_int','c_bool')

class RBinArch(Structure): #1
	_fields_ = [
		("buf", RBuffer),
		("file", c_char_p),
		("size", c_int),
		("offset", c_ulonglong),
		("o", RBinObject),
		("bin_obj", c_char_p),
		("curplugin", RBinPlugin),
	]
class RBin(Structure): #0
	_fields_ = [
		("file", c_char_p),
		("cur", RBinArch),
		("narch", c_int),
	]
	def __init__(self):
		Structure.__init__(self)
		r_bin_new = lib.r_bin_new
		r_bin_new.restype = c_void_p
		self._o = r_bin_new ()

	_o = AddressHolder()

	wr_scn_resize, r_bin_wr_scn_resize = register('r_bin_wr_scn_resize','c_void_p, c_char_p, c_ulonglong','c_ulonglong')
	wr_rpath_del, r_bin_wr_rpath_del = register('r_bin_wr_rpath_del','c_void_p','c_int')
	wr_output, r_bin_wr_output = register('r_bin_wr_output','c_void_p, c_char_p','c_int')
	load, r_bin_load = register('r_bin_load','c_void_p, c_char_p, c_bool','c_int')
	create, r_bin_create = register('r_bin_create','c_void_p, POINTER(c_ubyte), c_int, POINTER(c_ubyte), c_int','RBuffer')
	use_arch, r_bin_use_arch = register('r_bin_use_arch','c_void_p, c_char_p, c_int, c_char_p','c_int')
	select, r_bin_select = register('r_bin_select','c_void_p, c_char_p, c_int, c_char_p','c_int')
	select_idx, r_bin_select_idx = register('r_bin_select_idx','c_void_p, c_int','c_int')
	list, r_bin_list = register('r_bin_list','c_void_p','c_int')
	get_baddr, r_bin_get_baddr = register('r_bin_get_baddr','c_void_p','c_ulonglong')
	get_sym, r_bin_get_sym = register('r_bin_get_sym','c_void_p, c_int','RBinAddr')
	_get_entries, r_bin_get_entries = register('r_bin_get_entries','c_void_p','RList<RBinAddr>')
	_get_fields, r_bin_get_fields = register('r_bin_get_fields','c_void_p','RList<RBinField>')
	_get_imports, r_bin_get_imports = register('r_bin_get_imports','c_void_p','RList<RBinImport>')
	_get_sections, r_bin_get_sections = register('r_bin_get_sections','c_void_p','RList<RBinSection>')
	_get_strings, r_bin_get_strings = register('r_bin_get_strings','c_void_p','RList<RBinString>')
	_get_symbols, r_bin_get_symbols = register('r_bin_get_symbols','c_void_p','RList<RBinSymbol>')
	_get_relocs, r_bin_get_relocs = register('r_bin_get_relocs','c_void_p','RList<RBinReloc>')
	_get_libs, r_bin_get_libs = register('r_bin_get_libs','c_void_p','RList<c_char_p>')
	get_info, r_bin_get_info = register('r_bin_get_info','c_void_p','RBinInfo')
	is_big_endian, r_bin_is_big_endian = register('r_bin_is_big_endian','c_void_p','c_int')
	is_stripped, r_bin_is_stripped = register('r_bin_is_stripped','c_void_p','c_int')
	is_static, r_bin_is_static = register('r_bin_is_static','c_void_p','c_int')
	has_dbg_linenums, r_bin_has_dbg_linenums = register('r_bin_has_dbg_linenums','c_void_p','c_int')
	has_dbg_syms, r_bin_has_dbg_syms = register('r_bin_has_dbg_syms','c_void_p','c_int')
	has_dbg_relocs, r_bin_has_dbg_relocs = register('r_bin_has_dbg_relocs','c_void_p','c_int')
	meta_get_line, r_bin_meta_get_line = register('r_bin_meta_get_line','c_void_p, c_ulonglong, POINTER(c_char_p), c_int, POINTER(c_int)','c_int')
	meta_get_source_line, r_bin_meta_get_source_line = register('r_bin_meta_get_source_line','c_void_p, c_ulonglong','c_char_p')
	get_object, r_bin_get_object = register('r_bin_get_object','c_void_p','RBinObject')
	def get_entries(self):
		return rlist2array(self._get_entries(),RBinAddr)
	def get_fields(self):
		return rlist2array(self._get_fields(),RBinField)
	def get_imports(self):
		return rlist2array(self._get_imports(),RBinImport)
	def get_sections(self):
		return rlist2array(self._get_sections(),RBinSection)
	def get_strings(self):
		return rlist2array(self._get_strings(),RBinString)
	def get_symbols(self):
		return rlist2array(self._get_symbols(),RBinSymbol)
	def get_relocs(self):
		return rlist2array(self._get_relocs(),RBinReloc)
	def get_libs(self):
		return rlist2array(self._get_libs(),c_char_p)

class RList(Structure): #16
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_list_new = lib.r_list_new
		r_list_new.restype = c_void_p
		self._o = r_list_new ()
	def to_list(self,type):
		return rlist2array(self,type)

	_o = AddressHolder()

	append, r_list_append = register('r_list_append','c_void_p, c_void_p',None)
	prepend, r_list_prepend = register('r_list_prepend','c_void_p, c_void_p',None)
	iterator, r_list_iterator = register('r_list_iterator','c_void_p','RListIter')
	length, r_list_length = register('r_list_length','c_void_p','c_uint')
	del_n, r_list_del_n = register('r_list_del_n','c_void_p, c_int','c_bool')
	get_top, r_list_get_top = register('r_list_get_top','c_void_p','c_bool')
	pop, r_list_pop = register('r_list_pop','c_void_p','c_void_p')

class RListIter(Structure): #17
	_fields_ = [
		("data", c_void_p),
		("n", c_void_p),
		("p", c_void_p),
	]
	def __init__(self):
		Structure.__init__(self)

	_o = AddressHolder()

	get_data, r_list_iter_get_data = register('r_list_iter_get_data','c_void_p','c_void_p')
	get_next, r_list_iter_get_next = register('r_list_iter_get_next','c_void_p','RListIter')

class RRange(Structure): #18
	_fields_ = [
	]
	def __init__(self):
		Structure.__init__(self)
		r_range_new = lib.r_range_new
		r_range_new.restype = c_void_p
		self._o = r_range_new ()
		r_range_new_from_string = lib.r_range_new_from_string
		r_range_new_from_string.restype = c_void_p
		self._o = r_range_new_from_string (str)

	_o = AddressHolder()

	item_get, r_range_item_get = register('r_range_item_get','c_void_p, c_ulonglong','POINTER(RRangeItem)')
	size, r_range_size = register('r_range_size','c_void_p','c_ulonglong')
	add_from_string, r_range_add_from_string = register('r_range_add_from_string','c_void_p, c_char_p','c_ulonglong')
	contains, r_range_contains = register('r_range_contains','c_void_p, c_ulonglong','c_bool')
	sort, r_range_sort = register('r_range_sort','c_void_p','c_bool')
	list, r_range_list = register('r_range_list','c_void_p, c_bool','c_bool')
	get_n, r_range_get_n = register('r_range_get_n','c_void_p, c_int, POINTER(c_ulonglong), POINTER(c_ulonglong)','c_bool')
	inverse, r_range_inverse = register('r_range_inverse','c_void_p, c_ulonglong, c_ulonglong, c_int','POINTER(RRange)')

class RRangeItem(Structure): #19
	_fields_ = [
		("fr", c_ulonglong),
		("to", c_ulonglong),
		("data", POINTER(c_ubyte)),
		("datalen", c_int),
	]
