#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "embankment_dg.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2], "vector");
  Float lambda = (argc > 3) ? atof(argv[3]) : 1;
  size_t d = omega.dimension();
  size_t k = Xh.degree();
  Float beta = (k+1)*(k+d)/d;
  point f (0,0,0);
  f[d-1] = -1;
  trial u (Xh); test v (Xh);
  form  a = integrate (lambda*div_h(u)*div_h(v) + 2*ddot(Dh(u),Dh(v)))
          + integrate (omega.internal_sides() + dirichlet_boundary(omega),
                  beta*penalty()*dot(jump(u),jump(v))
	 	- lambda*dot(jump(u),average(div_h(v)*normal()))
	 	- lambda*dot(jump(v),average(div_h(u)*normal()))
	 	- 2*dot(jump(u),average(Dh(v)*normal()))
	 	- 2*dot(jump(v),average(Dh(u)*normal())));
  field lh = integrate (dot(f,v));
  solver sa (a.uu());
  field uh(Xh);
  uh.set_u() = sa.solve(lh.u());
  dout << uh;
}
