set terminal epslatex color standalone
set output "burgers-200-P0.tex"

set size square
set key left bottom
set key at graph 0.1,0.1
set xrange [0:1]
set yrange [-0.1:1.1]
set arrow from 0,0 to 0.8,0 nohead lt 2 lc 0 lw 1

set xtics (0,0.6,0.8,1)
set ytics (0,1)

plot \
 'burgers-200-P0-t=0.gdat' \
   t '[r]{$t=0$}' \
   w l lt 1 lc 0 lw 4, \
 'burgers-200-P0-t=0.16.gdat' \
   t '[r]{$t=0.16$}' \
   w l lt 1 lc 1 lw 4, \
 'burgers-200-P0-t=0.30.gdat' \
   t '[r]{$t=0.30$}' \
   w l lt 1 lc 3 lw 4

#pause -1
