/// Generated by rustemo. Do not edit manually!
use std::fmt::Debug;
use std::hash::Hash;
use rustemo::{
    Result, Input as InputT, Lexer, Token, TokenRecognizer as TokenRecognizerT, Parser,
    ParserDefinition, State as StateT, Builder,
};
use rustemo::regex::Regex;
use rustemo::once_cell::sync::Lazy;
use rustemo::StringLexer;
use rustemo::LRBuilder;
use super::map_actions;
use rustemo::{LRParser, LRContext};
use rustemo::Action::{self, Shift, Reduce, Accept};
#[allow(unused_imports)]
use rustemo::debug::{log, logn};
#[allow(unused_imports)]
#[cfg(debug_assertions)]
use rustemo::colored::*;
pub type Input = str;
const STATE_COUNT: usize = 32usize;
const MAX_RECOGNIZERS: usize = 6usize;
#[allow(dead_code)]
const TERMINAL_COUNT: usize = 13usize;
#[allow(clippy::upper_case_acronyms)]
#[derive(Debug, Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum TokenKind {
    #[default]
    STOP,
    WS,
    CommentLine,
    NotComment,
    START_COMMENT,
    END_COMMENT,
    IDENTIFIER,
    AT,
    COMMA,
    SEMICOLON,
    OPENBRACKET,
    CLOSEBRACKET,
    NOT,
}
use TokenKind as TK;
impl From<TokenKind> for usize {
    fn from(t: TokenKind) -> Self {
        t as usize
    }
}
#[allow(clippy::enum_variant_names)]
#[derive(Clone, Copy, PartialEq)]
pub enum ProdKind {
    MapP1,
    Association1P1,
    Association1P2,
    AssociationP1,
    NOTOptP1,
    NOTOptP2,
    NodeIdP1,
    TypeNameP1,
    LayoutP1,
    LayoutItem1P1,
    LayoutItem1P2,
    LayoutItem0P1,
    LayoutItem0P2,
    LayoutItemP1,
    LayoutItemP2,
    CommentP1,
    CommentP2,
    CorncsP1,
    Cornc1P1,
    Cornc1P2,
    Cornc0P1,
    Cornc0P2,
    CorncP1,
    CorncP2,
    CorncP3,
}
use ProdKind as PK;
impl std::fmt::Debug for ProdKind {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let name = match self {
            ProdKind::MapP1 => "Map: Association1",
            ProdKind::Association1P1 => "Association1: Association1 COMMA Association",
            ProdKind::Association1P2 => "Association1: Association",
            ProdKind::AssociationP1 => "Association: NodeId SEMICOLON NOTOpt TypeName",
            ProdKind::NOTOptP1 => "NOTOpt: NOT",
            ProdKind::NOTOptP2 => "NOTOpt: ",
            ProdKind::NodeIdP1 => "NodeId: IDENTIFIER",
            ProdKind::TypeNameP1 => "TypeName: IDENTIFIER",
            ProdKind::LayoutP1 => "Layout: LayoutItem0",
            ProdKind::LayoutItem1P1 => "LayoutItem1: LayoutItem1 LayoutItem",
            ProdKind::LayoutItem1P2 => "LayoutItem1: LayoutItem",
            ProdKind::LayoutItem0P1 => "LayoutItem0: LayoutItem1",
            ProdKind::LayoutItem0P2 => "LayoutItem0: ",
            ProdKind::LayoutItemP1 => "LayoutItem: WS",
            ProdKind::LayoutItemP2 => "LayoutItem: Comment",
            ProdKind::CommentP1 => "Comment: START_COMMENT Corncs END_COMMENT",
            ProdKind::CommentP2 => "Comment: CommentLine",
            ProdKind::CorncsP1 => "Corncs: Cornc0",
            ProdKind::Cornc1P1 => "Cornc1: Cornc1 Cornc",
            ProdKind::Cornc1P2 => "Cornc1: Cornc",
            ProdKind::Cornc0P1 => "Cornc0: Cornc1",
            ProdKind::Cornc0P2 => "Cornc0: ",
            ProdKind::CorncP1 => "Cornc: Comment",
            ProdKind::CorncP2 => "Cornc: NotComment",
            ProdKind::CorncP3 => "Cornc: WS",
        };
        write!(f, "{name}")
    }
}
#[allow(clippy::upper_case_acronyms)]
#[allow(dead_code)]
#[derive(Clone, Copy, Debug)]
pub enum NonTermKind {
    EMPTY,
    AUG,
    AUGL,
    Map,
    Association1,
    Association,
    NOTOpt,
    NodeId,
    TypeName,
    Layout,
    LayoutItem1,
    LayoutItem0,
    LayoutItem,
    Comment,
    Corncs,
    Cornc1,
    Cornc0,
    Cornc,
}
impl From<ProdKind> for NonTermKind {
    fn from(prod: ProdKind) -> Self {
        match prod {
            ProdKind::MapP1 => NonTermKind::Map,
            ProdKind::Association1P1 => NonTermKind::Association1,
            ProdKind::Association1P2 => NonTermKind::Association1,
            ProdKind::AssociationP1 => NonTermKind::Association,
            ProdKind::NOTOptP1 => NonTermKind::NOTOpt,
            ProdKind::NOTOptP2 => NonTermKind::NOTOpt,
            ProdKind::NodeIdP1 => NonTermKind::NodeId,
            ProdKind::TypeNameP1 => NonTermKind::TypeName,
            ProdKind::LayoutP1 => NonTermKind::Layout,
            ProdKind::LayoutItem1P1 => NonTermKind::LayoutItem1,
            ProdKind::LayoutItem1P2 => NonTermKind::LayoutItem1,
            ProdKind::LayoutItem0P1 => NonTermKind::LayoutItem0,
            ProdKind::LayoutItem0P2 => NonTermKind::LayoutItem0,
            ProdKind::LayoutItemP1 => NonTermKind::LayoutItem,
            ProdKind::LayoutItemP2 => NonTermKind::LayoutItem,
            ProdKind::CommentP1 => NonTermKind::Comment,
            ProdKind::CommentP2 => NonTermKind::Comment,
            ProdKind::CorncsP1 => NonTermKind::Corncs,
            ProdKind::Cornc1P1 => NonTermKind::Cornc1,
            ProdKind::Cornc1P2 => NonTermKind::Cornc1,
            ProdKind::Cornc0P1 => NonTermKind::Cornc0,
            ProdKind::Cornc0P2 => NonTermKind::Cornc0,
            ProdKind::CorncP1 => NonTermKind::Cornc,
            ProdKind::CorncP2 => NonTermKind::Cornc,
            ProdKind::CorncP3 => NonTermKind::Cornc,
        }
    }
}
#[allow(clippy::enum_variant_names)]
#[derive(Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord)]
pub enum State {
    #[default]
    AUGS0,
    IDENTIFIERS1,
    MapS2,
    Association1S3,
    AssociationS4,
    NodeIdS5,
    COMMAS6,
    SEMICOLONS7,
    AssociationS8,
    NOTS9,
    NOTOptS10,
    IDENTIFIERS11,
    TypeNameS12,
    AUGLS13,
    WSS14,
    CommentLineS15,
    START_COMMENTS16,
    LayoutS17,
    LayoutItem1S18,
    LayoutItem0S19,
    LayoutItemS20,
    CommentS21,
    WSS22,
    NotCommentS23,
    CommentS24,
    CorncsS25,
    Cornc1S26,
    Cornc0S27,
    CorncS28,
    LayoutItemS29,
    END_COMMENTS30,
    CorncS31,
}
impl StateT for State {
    fn default_layout() -> Option<Self> {
        Some(State::AUGLS13)
    }
}
impl From<State> for usize {
    fn from(s: State) -> Self {
        s as usize
    }
}
impl std::fmt::Debug for State {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let name = match self {
            State::AUGS0 => "0:AUG",
            State::IDENTIFIERS1 => "1:IDENTIFIER",
            State::MapS2 => "2:Map",
            State::Association1S3 => "3:Association1",
            State::AssociationS4 => "4:Association",
            State::NodeIdS5 => "5:NodeId",
            State::COMMAS6 => "6:COMMA",
            State::SEMICOLONS7 => "7:SEMICOLON",
            State::AssociationS8 => "8:Association",
            State::NOTS9 => "9:NOT",
            State::NOTOptS10 => "10:NOTOpt",
            State::IDENTIFIERS11 => "11:IDENTIFIER",
            State::TypeNameS12 => "12:TypeName",
            State::AUGLS13 => "13:AUGL",
            State::WSS14 => "14:WS",
            State::CommentLineS15 => "15:CommentLine",
            State::START_COMMENTS16 => "16:START_COMMENT",
            State::LayoutS17 => "17:Layout",
            State::LayoutItem1S18 => "18:LayoutItem1",
            State::LayoutItem0S19 => "19:LayoutItem0",
            State::LayoutItemS20 => "20:LayoutItem",
            State::CommentS21 => "21:Comment",
            State::WSS22 => "22:WS",
            State::NotCommentS23 => "23:NotComment",
            State::CommentS24 => "24:Comment",
            State::CorncsS25 => "25:Corncs",
            State::Cornc1S26 => "26:Cornc1",
            State::Cornc0S27 => "27:Cornc0",
            State::CorncS28 => "28:Cornc",
            State::LayoutItemS29 => "29:LayoutItem",
            State::END_COMMENTS30 => "30:END_COMMENT",
            State::CorncS31 => "31:Cornc",
        };
        write!(f, "{name}")
    }
}
#[derive(Debug)]
pub enum Symbol {
    Terminal(Terminal),
    NonTerminal(NonTerminal),
}
#[allow(clippy::upper_case_acronyms)]
#[derive(Debug)]
pub enum Terminal {
    IDENTIFIER(map_actions::IDENTIFIER),
    COMMA,
    SEMICOLON,
    NOT,
}
#[derive(Debug)]
pub enum NonTerminal {
    Map(map_actions::Map),
    Association1(map_actions::Association1),
    Association(map_actions::Association),
    NOTOpt(map_actions::NOTOpt),
    NodeId(map_actions::NodeId),
    TypeName(map_actions::TypeName),
}
type ActionFn = fn(token: TokenKind) -> Vec<Action<State, ProdKind>>;
pub struct MapParserDefinition {
    actions: [ActionFn; STATE_COUNT],
    gotos: [fn(nonterm: NonTermKind) -> State; STATE_COUNT],
    token_kinds: [[Option<(TokenKind, bool)>; MAX_RECOGNIZERS]; STATE_COUNT],
}
fn action_aug_s0(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS1)]),
        _ => vec![],
    }
}
fn action_identifier_s1(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::SEMICOLON => Vec::from(&[Reduce(PK::NodeIdP1, 1usize)]),
        _ => vec![],
    }
}
fn action_map_s2(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Accept]),
        _ => vec![],
    }
}
fn action_association1_s3(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::MapP1, 1usize)]),
        TK::COMMA => Vec::from(&[Shift(State::COMMAS6)]),
        _ => vec![],
    }
}
fn action_association_s4(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::Association1P2, 1usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::Association1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_nodeid_s5(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::SEMICOLON => Vec::from(&[Shift(State::SEMICOLONS7)]),
        _ => vec![],
    }
}
fn action_comma_s6(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS1)]),
        _ => vec![],
    }
}
fn action_semicolon_s7(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Reduce(PK::NOTOptP2, 0usize)]),
        TK::NOT => Vec::from(&[Shift(State::NOTS9)]),
        _ => vec![],
    }
}
fn action_association_s8(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::Association1P1, 3usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::Association1P1, 3usize)]),
        _ => vec![],
    }
}
fn action_not_s9(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Reduce(PK::NOTOptP1, 1usize)]),
        _ => vec![],
    }
}
fn action_notopt_s10(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS11)]),
        _ => vec![],
    }
}
fn action_identifier_s11(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::TypeNameP1, 1usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::TypeNameP1, 1usize)]),
        _ => vec![],
    }
}
fn action_typename_s12(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::AssociationP1, 4usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::AssociationP1, 4usize)]),
        _ => vec![],
    }
}
fn action_augl_s13(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem0P2, 0usize)]),
        TK::WS => Vec::from(&[Shift(State::WSS14)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS15)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS16)]),
        _ => vec![],
    }
}
fn action_ws_s14(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        _ => vec![],
    }
}
fn action_commentline_s15(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        _ => vec![],
    }
}
fn action_start_comment_s16(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Shift(State::WSS22)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS15)]),
        TK::NotComment => Vec::from(&[Shift(State::NotCommentS23)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS16)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc0P2, 0usize)]),
        _ => vec![],
    }
}
fn action_layout_s17(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Accept]),
        _ => vec![],
    }
}
fn action_layoutitem1_s18(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem0P1, 1usize)]),
        TK::WS => Vec::from(&[Shift(State::WSS14)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS15)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS16)]),
        _ => vec![],
    }
}
fn action_layoutitem0_s19(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutP1, 1usize)]),
        _ => vec![],
    }
}
fn action_layoutitem_s20(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_comment_s21(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        _ => vec![],
    }
}
fn action_ws_s22(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        _ => vec![],
    }
}
fn action_notcomment_s23(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        _ => vec![],
    }
}
fn action_comment_s24(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        _ => vec![],
    }
}
fn action_corncs_s25(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::END_COMMENT => Vec::from(&[Shift(State::END_COMMENTS30)]),
        _ => vec![],
    }
}
fn action_cornc1_s26(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Shift(State::WSS22)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS15)]),
        TK::NotComment => Vec::from(&[Shift(State::NotCommentS23)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS16)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc0P1, 1usize)]),
        _ => vec![],
    }
}
fn action_cornc0_s27(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncsP1, 1usize)]),
        _ => vec![],
    }
}
fn action_cornc_s28(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_layoutitem_s29(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        _ => vec![],
    }
}
fn action_end_comment_s30(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::WS => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        _ => vec![],
    }
}
fn action_cornc_s31(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        _ => vec![],
    }
}
fn goto_aug_s0(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Map => State::MapS2,
        NonTermKind::Association1 => State::Association1S3,
        NonTermKind::Association => State::AssociationS4,
        NonTermKind::NodeId => State::NodeIdS5,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::AUGS0
            )
        }
    }
}
fn goto_comma_s6(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Association => State::AssociationS8,
        NonTermKind::NodeId => State::NodeIdS5,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::COMMAS6
            )
        }
    }
}
fn goto_semicolon_s7(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::NOTOpt => State::NOTOptS10,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::SEMICOLONS7
            )
        }
    }
}
fn goto_notopt_s10(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::TypeName => State::TypeNameS12,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::NOTOptS10
            )
        }
    }
}
fn goto_augl_s13(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Layout => State::LayoutS17,
        NonTermKind::LayoutItem1 => State::LayoutItem1S18,
        NonTermKind::LayoutItem0 => State::LayoutItem0S19,
        NonTermKind::LayoutItem => State::LayoutItemS20,
        NonTermKind::Comment => State::CommentS21,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::AUGLS13
            )
        }
    }
}
fn goto_start_comment_s16(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Comment => State::CommentS24,
        NonTermKind::Corncs => State::CorncsS25,
        NonTermKind::Cornc1 => State::Cornc1S26,
        NonTermKind::Cornc0 => State::Cornc0S27,
        NonTermKind::Cornc => State::CorncS28,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::START_COMMENTS16
            )
        }
    }
}
fn goto_layoutitem1_s18(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::LayoutItem => State::LayoutItemS29,
        NonTermKind::Comment => State::CommentS21,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::LayoutItem1S18
            )
        }
    }
}
fn goto_cornc1_s26(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Comment => State::CommentS24,
        NonTermKind::Cornc => State::CorncS31,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::Cornc1S26
            )
        }
    }
}
fn goto_invalid(_nonterm_kind: NonTermKind) -> State {
    panic!("Invalid GOTO entry!");
}
pub(crate) static PARSER_DEFINITION: MapParserDefinition = MapParserDefinition {
    actions: [
        action_aug_s0,
        action_identifier_s1,
        action_map_s2,
        action_association1_s3,
        action_association_s4,
        action_nodeid_s5,
        action_comma_s6,
        action_semicolon_s7,
        action_association_s8,
        action_not_s9,
        action_notopt_s10,
        action_identifier_s11,
        action_typename_s12,
        action_augl_s13,
        action_ws_s14,
        action_commentline_s15,
        action_start_comment_s16,
        action_layout_s17,
        action_layoutitem1_s18,
        action_layoutitem0_s19,
        action_layoutitem_s20,
        action_comment_s21,
        action_ws_s22,
        action_notcomment_s23,
        action_comment_s24,
        action_corncs_s25,
        action_cornc1_s26,
        action_cornc0_s27,
        action_cornc_s28,
        action_layoutitem_s29,
        action_end_comment_s30,
        action_cornc_s31,
    ],
    gotos: [
        goto_aug_s0,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_comma_s6,
        goto_semicolon_s7,
        goto_invalid,
        goto_invalid,
        goto_notopt_s10,
        goto_invalid,
        goto_invalid,
        goto_augl_s13,
        goto_invalid,
        goto_invalid,
        goto_start_comment_s16,
        goto_invalid,
        goto_layoutitem1_s18,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_cornc1_s26,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
    ],
    token_kinds: [
        [Some((TK::IDENTIFIER, false)), None, None, None, None, None],
        [Some((TK::SEMICOLON, true)), None, None, None, None, None],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::SEMICOLON, true)), None, None, None, None, None],
        [Some((TK::IDENTIFIER, false)), None, None, None, None, None],
        [Some((TK::NOT, true)), Some((TK::IDENTIFIER, false)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::IDENTIFIER, false)), None, None, None, None, None],
        [Some((TK::IDENTIFIER, false)), None, None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::COMMA, true)), None, None, None, None],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [Some((TK::END_COMMENT, true)), None, None, None, None, None],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [Some((TK::END_COMMENT, true)), None, None, None, None, None],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
    ],
};
impl ParserDefinition<State, ProdKind, TokenKind, NonTermKind> for MapParserDefinition {
    fn actions(&self, state: State, token: TokenKind) -> Vec<Action<State, ProdKind>> {
        PARSER_DEFINITION.actions[state as usize](token)
    }
    fn goto(&self, state: State, nonterm: NonTermKind) -> State {
        PARSER_DEFINITION.gotos[state as usize](nonterm)
    }
    fn expected_token_kinds(&self, state: State) -> Vec<(TokenKind, bool)> {
        PARSER_DEFINITION.token_kinds[state as usize].iter().map_while(|t| *t).collect()
    }
    fn longest_match() -> bool {
        true
    }
    fn grammar_order() -> bool {
        true
    }
}
pub(crate) type Context<'i, I> = LRContext<'i, I, State, TokenKind>;
pub struct MapParser<
    'i,
    I: InputT + ?Sized,
    L: Lexer<'i, Context<'i, I>, State, TokenKind, Input = I>,
    B,
>(
    LRParser<
        'i,
        Context<'i, I>,
        State,
        ProdKind,
        TokenKind,
        NonTermKind,
        MapParserDefinition,
        L,
        B,
        I,
    >,
);
#[allow(dead_code)]
impl<
    'i,
> MapParser<
    'i,
    Input,
    StringLexer<Context<'i, Input>, State, TokenKind, TokenRecognizer, TERMINAL_COUNT>,
    DefaultBuilder,
> {
    pub fn new() -> Self {
        Self(
            LRParser::new(
                &PARSER_DEFINITION,
                State::default(),
                false,
                true,
                StringLexer::new(false, &RECOGNIZERS),
                DefaultBuilder::new(),
            ),
        )
    }
}
#[allow(dead_code)]
impl<'i, I, L, B> Parser<'i, I, Context<'i, I>, State, TokenKind>
for MapParser<'i, I, L, B>
where
    I: InputT + ?Sized + Debug,
    L: Lexer<'i, Context<'i, I>, State, TokenKind, Input = I>,
    B: LRBuilder<'i, I, Context<'i, I>, State, ProdKind, TokenKind>,
{
    type Output = B::Output;
    fn parse(&self, input: &'i I) -> Result<Self::Output> {
        self.0.parse(input)
    }
    fn parse_with_context(
        &self,
        context: &mut Context<'i, I>,
        input: &'i I,
    ) -> Result<Self::Output> {
        self.0.parse_with_context(context, input)
    }
    fn parse_file<'a, F: AsRef<std::path::Path>>(
        &'a mut self,
        file: F,
    ) -> Result<Self::Output>
    where
        'a: 'i,
    {
        self.0.parse_file(file)
    }
}
#[allow(dead_code)]
#[derive(Debug)]
pub enum Recognizer {
    Stop,
    StrMatch(&'static str),
    RegexMatch(Lazy<Regex>),
}
#[allow(dead_code)]
#[derive(Debug)]
pub struct TokenRecognizer(TokenKind, Recognizer);
impl<'i> TokenRecognizerT<'i> for TokenRecognizer {
    fn recognize(&self, input: &'i str) -> Option<&'i str> {
        match &self {
            #[allow(unused_variables)]
            TokenRecognizer(token_kind, Recognizer::StrMatch(s)) => {
                logn!("{} {:?} -- ", "    Recognizing".green(), token_kind);
                if input.starts_with(s) {
                    log!("{}", "recognized".bold().green());
                    Some(s)
                } else {
                    log!("{}", "not recognized".red());
                    None
                }
            }
            #[allow(unused_variables)]
            TokenRecognizer(token_kind, Recognizer::RegexMatch(r)) => {
                logn!("{} {:?} -- ", "    Recognizing".green(), token_kind);
                let match_str = r.find(input);
                match match_str {
                    Some(x) => {
                        let x_str = x.as_str();
                        log!("{} '{}'", "recognized".bold().green(), x_str);
                        Some(x_str)
                    }
                    _ => {
                        log!("{}", "not recognized".red());
                        None
                    }
                }
            }
            TokenRecognizer(_, Recognizer::Stop) => {
                logn!("{} STOP -- ", "    Recognizing".green());
                if input.is_empty() {
                    log!("{}", "recognized".bold().green());
                    Some("")
                } else {
                    log!("{}", "not recognized".red());
                    None
                }
            }
        }
    }
}
pub(crate) static RECOGNIZERS: [TokenRecognizer; TERMINAL_COUNT] = [
    TokenRecognizer(TokenKind::STOP, Recognizer::Stop),
    TokenRecognizer(
        TokenKind::WS,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "\\s+")).unwrap() }),
        ),
    ),
    TokenRecognizer(
        TokenKind::CommentLine,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "//.*")).unwrap() }),
        ),
    ),
    TokenRecognizer(
        TokenKind::NotComment,
        Recognizer::RegexMatch(
            Lazy::new(|| {
                Regex::new(concat!("^", "((\\*[^/])|[^\\s*/]|/[^\\*])+")).unwrap()
            }),
        ),
    ),
    TokenRecognizer(TokenKind::START_COMMENT, Recognizer::StrMatch("/*")),
    TokenRecognizer(TokenKind::END_COMMENT, Recognizer::StrMatch("*/")),
    TokenRecognizer(
        TokenKind::IDENTIFIER,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "\\w+")).unwrap() }),
        ),
    ),
    TokenRecognizer(TokenKind::AT, Recognizer::StrMatch("@")),
    TokenRecognizer(TokenKind::COMMA, Recognizer::StrMatch(",")),
    TokenRecognizer(TokenKind::SEMICOLON, Recognizer::StrMatch(":")),
    TokenRecognizer(TokenKind::OPENBRACKET, Recognizer::StrMatch("[")),
    TokenRecognizer(TokenKind::CLOSEBRACKET, Recognizer::StrMatch("]")),
    TokenRecognizer(TokenKind::NOT, Recognizer::StrMatch("!")),
];
pub struct DefaultBuilder {
    res_stack: Vec<Symbol>,
}
impl DefaultBuilder {
    #[allow(dead_code)]
    pub fn new() -> Self {
        Self { res_stack: vec![] }
    }
}
impl Builder for DefaultBuilder {
    type Output = map_actions::Map;
    fn get_result(&mut self) -> Self::Output {
        match self.res_stack.pop().unwrap() {
            Symbol::NonTerminal(NonTerminal::Map(r)) => r,
            _ => panic!("Invalid result on the parse stack!"),
        }
    }
}
impl<'i> LRBuilder<'i, Input, Context<'i, Input>, State, ProdKind, TokenKind>
for DefaultBuilder {
    #![allow(unused_variables)]
    fn shift_action(
        &mut self,
        context: &Context<'i, Input>,
        token: Token<'i, Input, TokenKind>,
    ) {
        let val = match token.kind {
            TokenKind::STOP => panic!("Cannot shift STOP token!"),
            TokenKind::IDENTIFIER => {
                Terminal::IDENTIFIER(map_actions::identifier(context, token))
            }
            TokenKind::COMMA => Terminal::COMMA,
            TokenKind::SEMICOLON => Terminal::SEMICOLON,
            TokenKind::NOT => Terminal::NOT,
            _ => panic!("Shift of unreachable terminal!"),
        };
        self.res_stack.push(Symbol::Terminal(val));
    }
    fn reduce_action(
        &mut self,
        context: &Context<'i, Input>,
        prod: ProdKind,
        prod_len: usize,
    ) {
        let prod = match prod {
            ProdKind::MapP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Association1(p0)) => {
                        NonTerminal::Map(map_actions::map_association1(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::Association1P1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::Association1(p0)),
                        _,
                        Symbol::NonTerminal(NonTerminal::Association(p1)),
                    ) => {
                        NonTerminal::Association1(
                            map_actions::association1_c1(context, p0, p1),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::Association1P2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Association(p0)) => {
                        NonTerminal::Association1(
                            map_actions::association1_association(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::AssociationP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 4usize)
                    .into_iter();
                match (
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                ) {
                    (
                        Symbol::NonTerminal(NonTerminal::NodeId(p0)),
                        _,
                        Symbol::NonTerminal(NonTerminal::NOTOpt(p1)),
                        Symbol::NonTerminal(NonTerminal::TypeName(p2)),
                    ) => {
                        NonTerminal::Association(
                            map_actions::association_c1(context, p0, p1, p2),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::NOTOptP1 => {
                let _ = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                NonTerminal::NOTOpt(map_actions::notopt_not(context))
            }
            ProdKind::NOTOptP2 => NonTerminal::NOTOpt(map_actions::notopt_empty(context)),
            ProdKind::NodeIdP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::IDENTIFIER(p0)) => {
                        NonTerminal::NodeId(map_actions::node_id_identifier(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::TypeNameP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::IDENTIFIER(p0)) => {
                        NonTerminal::TypeName(
                            map_actions::type_name_identifier(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            _ => panic!("Reduce of unreachable nonterminal!"),
        };
        self.res_stack.push(Symbol::NonTerminal(prod));
    }
}
